; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S                             | FileCheck %s --check-prefixes=ANY,NO-FLOAT-SHRINK
; RUN: opt < %s -passes=instcombine -enable-double-float-shrink -S | FileCheck %s --check-prefixes=ANY,DO-FLOAT-SHRINK

declare double @llvm.cos.f64(double)
declare float @llvm.cos.f32(float)

declare double @llvm.sin.f64(double)
declare float @llvm.sin.f32(float)

; cos -> cosf

define float @cos_no_fastmath(float %f) {
; NO-FLOAT-SHRINK-LABEL: @cos_no_fastmath(
; NO-FLOAT-SHRINK-NEXT:    [[D:%.*]] = fpext float [[F:%.*]] to double
; NO-FLOAT-SHRINK-NEXT:    [[RESULT:%.*]] = call double @llvm.cos.f64(double [[D]])
; NO-FLOAT-SHRINK-NEXT:    [[TRUNCATED_RESULT:%.*]] = fptrunc double [[RESULT]] to float
; NO-FLOAT-SHRINK-NEXT:    ret float [[TRUNCATED_RESULT]]
;
; DO-FLOAT-SHRINK-LABEL: @cos_no_fastmath(
; DO-FLOAT-SHRINK-NEXT:    [[TMP1:%.*]] = call float @llvm.cos.f32(float [[F:%.*]])
; DO-FLOAT-SHRINK-NEXT:    ret float [[TMP1]]
;
  %d = fpext float %f to double
  %result = call double @llvm.cos.f64(double %d)
  %truncated_result = fptrunc double %result to float
  ret float %truncated_result
}

define float @cos_fastmath(float %f) {
; ANY-LABEL: @cos_fastmath(
; ANY-NEXT:    [[TMP1:%.*]] = call fast float @llvm.cos.f32(float [[F:%.*]])
; ANY-NEXT:    ret float [[TMP1]]
;
  %d = fpext float %f to double
  %result = call fast double @llvm.cos.f64(double %d)
  %truncated_result = fptrunc double %result to float
  ret float %truncated_result
}

; sin -> sinf

define float @sin_no_fastmath(float %f) {
; NO-FLOAT-SHRINK-LABEL: @sin_no_fastmath(
; NO-FLOAT-SHRINK-NEXT:    [[D:%.*]] = fpext float [[F:%.*]] to double
; NO-FLOAT-SHRINK-NEXT:    [[RESULT:%.*]] = call double @llvm.sin.f64(double [[D]])
; NO-FLOAT-SHRINK-NEXT:    [[TRUNCATED_RESULT:%.*]] = fptrunc double [[RESULT]] to float
; NO-FLOAT-SHRINK-NEXT:    ret float [[TRUNCATED_RESULT]]
;
; DO-FLOAT-SHRINK-LABEL: @sin_no_fastmath(
; DO-FLOAT-SHRINK-NEXT:    [[TMP1:%.*]] = call float @llvm.sin.f32(float [[F:%.*]])
; DO-FLOAT-SHRINK-NEXT:    ret float [[TMP1]]
;
  %d = fpext float %f to double
  %result = call double @llvm.sin.f64(double %d)
  %truncated_result = fptrunc double %result to float
  ret float %truncated_result
}

define float @sin_fastmath(float %f) {
; ANY-LABEL: @sin_fastmath(
; ANY-NEXT:    [[TMP1:%.*]] = call fast float @llvm.sin.f32(float [[F:%.*]])
; ANY-NEXT:    ret float [[TMP1]]
;
  %d = fpext float %f to double
  %result = call fast double @llvm.sin.f64(double %d)
  %truncated_result = fptrunc double %result to float
  ret float %truncated_result
}
