; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX7,GFX7-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx700 < %s | FileCheck -check-prefixes=GFX7,GFX7-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx801 < %s | FileCheck -check-prefixes=GFX8,GFX8-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx801 < %s | FileCheck -check-prefixes=GFX8,GFX8-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX9-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx942 < %s | FileCheck -check-prefixes=GFX9,GFX9-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10,GFX10-SDAG %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1010 < %s | FileCheck -check-prefixes=GFX10,GFX10-GISEL %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-SDAG,GFX11-SDAG-FAKE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-GISEL,GFX11-GISEL-TRUE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-GISEL,GFX11-GISEL-FAKE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-TRUE16 %s
; RUN: llc -global-isel=0 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-SDAG,GFX12-SDAG-FAKE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL,GFX12-GISEL-TRUE16 %s
; RUN: llc -global-isel=1 -mtriple=amdgcn -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-GISEL,GFX12-GISEL-FAKE16 %s

define half @test_vector_reduce_fmul_v2half(half %sp, <2 x half> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_fmul_v2half:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_fmul_v2half:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v2half:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v2half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v2half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_fmul_v2half:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_fmul_v2half:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: test_vector_reduce_fmul_v2half:
; GFX11-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: test_vector_reduce_fmul_v2half:
; GFX11-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_fmul_v2half:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_fmul_v2half:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-TRUE16-LABEL: test_vector_reduce_fmul_v2half:
; GFX12-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX12-GISEL-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-FAKE16-LABEL: test_vector_reduce_fmul_v2half:
; GFX12-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX12-GISEL-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call half @llvm.vector.reduce.fmul.v2half(half %sp, <2 x half> %v)
  ret half %res
}

define half @test_vector_reduce_fmul_v3half(half %sp, <3 x half> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_fmul_v3half:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_fmul_v3half:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v3
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v3half:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v3half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v3half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_fmul_v3half:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_fmul_v3half:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: test_vector_reduce_fmul_v3half:
; GFX11-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.h
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: test_vector_reduce_fmul_v3half:
; GFX11-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_fmul_v3half:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.h
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_fmul_v3half:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-TRUE16-LABEL: test_vector_reduce_fmul_v3half:
; GFX12-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX12-GISEL-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.h
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX12-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-FAKE16-LABEL: test_vector_reduce_fmul_v3half:
; GFX12-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX12-GISEL-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX12-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call half @llvm.vector.reduce.fmul.v3half(half %sp, <3 x half> %v)
  ret half %res
}

define half @test_vector_reduce_fmul_v4half(half %sp, <4 x half> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_fmul_v4half:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_fmul_v4half:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v3
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v4
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v4half:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v4half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v4half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_fmul_v4half:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_fmul_v4half:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: test_vector_reduce_fmul_v4half:
; GFX11-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: test_vector_reduce_fmul_v4half:
; GFX11-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_fmul_v4half:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.h
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_fmul_v4half:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-TRUE16-LABEL: test_vector_reduce_fmul_v4half:
; GFX12-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX12-GISEL-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-FAKE16-LABEL: test_vector_reduce_fmul_v4half:
; GFX12-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX12-GISEL-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call half @llvm.vector.reduce.fmul.v4half(half %sp, <4 x half> %v)
  ret half %res
}

define half @test_vector_reduce_fmul_v8half(half %sp, <8 x half> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_fmul_v8half:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v8, v8
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_fmul_v8half:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v3
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v4
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v5
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v6
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v7
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v8
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v8half:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v8half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v8half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_fmul_v8half:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v3.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v4.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v4.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_fmul_v8half:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: test_vector_reduce_fmul_v8half:
; GFX11-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v3.l
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v4.l
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: test_vector_reduce_fmul_v8half:
; GFX11-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_fmul_v8half:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.h
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.h
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v3.h
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v4.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v4.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_fmul_v8half:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-TRUE16-LABEL: test_vector_reduce_fmul_v8half:
; GFX12-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX12-GISEL-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v3.l
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v4.l
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-FAKE16-LABEL: test_vector_reduce_fmul_v8half:
; GFX12-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX12-GISEL-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call half @llvm.vector.reduce.fmul.v8half(half %sp, <8 x half> %v)
  ret half %res
}

define half @test_vector_reduce_fmul_v16half(half %sp, <16 x half> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_fmul_v16half:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v2, v2
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v3, v3
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v4, v4
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v5, v5
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v6, v6
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v2, v2
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v7, v7
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v3, v3
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v8, v8
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v4, v4
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v9, v9
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v5, v5
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v10, v10
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v6, v6
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v11, v11
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v7, v7
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v12, v12
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v8, v8
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v13, v13
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v9, v9
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v14, v14
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v10, v10
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v15, v15
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v11, v11
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX7-SDAG-NEXT:    v_cvt_f16_f32_e32 v16, v16
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v12, v12
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v13, v13
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v9
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v14, v14
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v10
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v15, v15
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v11
; GFX7-SDAG-NEXT:    v_cvt_f32_f16_e32 v16, v16
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v12
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v13
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v14
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v15
; GFX7-SDAG-NEXT:    v_mul_f32_e32 v0, v0, v16
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_fmul_v16half:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v2
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v3
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v4
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v5
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v6
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v7
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v8
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v9
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v10
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v11
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v12
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v13
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v14
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v15
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v1, v16
; GFX7-GISEL-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-GISEL-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-GISEL-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v16half:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v5
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v6
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v7
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    v_mul_f16_e32 v0, v0, v8
; GFX8-NEXT:    v_mul_f16_sdwa v0, v0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v16half:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v5
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v6
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v7
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    v_mul_f16_e32 v0, v0, v8
; GFX9-NEXT:    v_mul_f16_sdwa v0, v0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v16half:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v5
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v6
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v7
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    v_mul_f16_e32 v0, v0, v8
; GFX10-NEXT:    v_mul_f16_sdwa v0, v0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-TRUE16-LABEL: test_vector_reduce_fmul_v16half:
; GFX11-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX11-SDAG-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v3.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v3.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v4.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v4.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v5.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v5.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v6.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v6.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v7.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v7.h
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v8.l
; GFX11-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v8.h
; GFX11-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-FAKE16-LABEL: test_vector_reduce_fmul_v16half:
; GFX11-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX11-SDAG-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v5
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v6
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v7
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v7
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v8
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v8
; GFX11-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-TRUE16-LABEL: test_vector_reduce_fmul_v16half:
; GFX11-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX11-GISEL-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v3.l
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v4.l
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v5.l
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v6.l
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v7
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v7.l
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v8
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v8.l
; GFX11-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX11-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-FAKE16-LABEL: test_vector_reduce_fmul_v16half:
; GFX11-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX11-GISEL-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v5
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v6
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v7
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v7
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v8
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v8
; GFX11-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX11-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-TRUE16-LABEL: test_vector_reduce_fmul_v16half:
; GFX12-SDAG-TRUE16:       ; %bb.0: ; %entry
; GFX12-SDAG-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.h
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.h
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v3.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v3.h
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v4.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v4.h
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v5.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v5.h
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v6.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v6.h
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v7.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v7.h
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v8.l
; GFX12-SDAG-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v8.h
; GFX12-SDAG-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-FAKE16-LABEL: test_vector_reduce_fmul_v16half:
; GFX12-SDAG-FAKE16:       ; %bb.0: ; %entry
; GFX12-SDAG-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v5
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v6
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v7
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v7
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v8
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v8
; GFX12-SDAG-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-SDAG-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-SDAG-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-TRUE16-LABEL: test_vector_reduce_fmul_v16half:
; GFX12-GISEL-TRUE16:       ; %bb.0: ; %entry
; GFX12-GISEL-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v2.l
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v3.l
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v4.l
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v5.l
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v6.l
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v7
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v7.l
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v8
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v8.l
; GFX12-GISEL-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-TRUE16-NEXT:    v_mul_f16_e32 v0.l, v0.l, v1.l
; GFX12-GISEL-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-FAKE16-LABEL: test_vector_reduce_fmul_v16half:
; GFX12-GISEL-FAKE16:       ; %bb.0: ; %entry
; GFX12-GISEL-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v2
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v2
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v3
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v3
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v4
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v4
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v5
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v5
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v6
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v6
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v7
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v7
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    v_lshrrev_b32_e32 v1, 16, v8
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v8
; GFX12-GISEL-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-GISEL-FAKE16-NEXT:    v_mul_f16_e32 v0, v0, v1
; GFX12-GISEL-FAKE16-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call half @llvm.vector.reduce.fmul.v16half(half %sp, <16 x half> %v)
  ret half %res
}

define float @test_vector_reduce_fmul_v2float(float %sp, <2 x float> %v) {
; GFX7-LABEL: test_vector_reduce_fmul_v2float:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v2float:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v2float:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v2float:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fmul_v2float:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_fmul_v2float:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call float @llvm.vector.reduce.fmul.v2float(float %sp, <2 x float> %v)
  ret float %res
}

define float @test_vector_reduce_fmul_v3float(float %sp, <3 x float> %v) {
; GFX7-LABEL: test_vector_reduce_fmul_v3float:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v3float:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v3float:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v3float:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fmul_v3float:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_fmul_v3float:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call float @llvm.vector.reduce.fmul.v3float(float %sp, <3 x float> %v)
  ret float %res
}

define float @test_vector_reduce_fmul_v4float(float %sp, <4 x float> %v) {
; GFX7-LABEL: test_vector_reduce_fmul_v4float:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v4float:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v4float:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v4float:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fmul_v4float:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_fmul_v4float:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call float @llvm.vector.reduce.fmul.v4float(float %sp, <4 x float> %v)
  ret float %res
}

define float @test_vector_reduce_fmul_v8float(float %sp, <8 x float> %v) {
; GFX7-LABEL: test_vector_reduce_fmul_v8float:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v8float:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v8float:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v8float:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fmul_v8float:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_fmul_v8float:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call float @llvm.vector.reduce.fmul.v8float(float %sp, <8 x float> %v)
  ret float %res
}

define float @test_vector_reduce_fmul_v16float(float %sp, <16 x float> %v) {
; GFX7-LABEL: test_vector_reduce_fmul_v16float:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v9
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v10
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v11
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v12
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v13
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v14
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v15
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v16
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v16float:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v9
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v10
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v11
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v12
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v13
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v14
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v15
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v16
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v16float:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v9
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v10
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v11
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v12
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v13
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v14
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v15
; GFX9-NEXT:    v_mul_f32_e32 v0, v0, v16
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v16float:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v9
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v10
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v11
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v12
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v13
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v14
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v15
; GFX10-NEXT:    v_mul_f32_e32 v0, v0, v16
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fmul_v16float:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v9
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v10
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v11
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v12
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v13
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v14
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v15
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v16
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_fmul_v16float:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v1
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v2
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v3
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v4
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v5
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v6
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v7
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v8
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v9
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v10
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v11
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v12
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v13
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v14
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v15
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f32_e32 v0, v0, v16
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call float @llvm.vector.reduce.fmul.v16float(float %sp, <16 x float> %v)
  ret float %res
}


define double @test_vector_reduce_fmul_v2double(double %sp, <2 x double> %v) {
; GFX7-LABEL: test_vector_reduce_fmul_v2double:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v2double:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v2double:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v2double:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fmul_v2double:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_fmul_v2double:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[4:5]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call double @llvm.vector.reduce.fmul.v2double(double %sp, <2 x double> %v)
  ret double %res
}

define double @test_vector_reduce_fmul_v3double(double %sp, <3 x double> %v) {
; GFX7-LABEL: test_vector_reduce_fmul_v3double:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v3double:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v3double:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v3double:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fmul_v3double:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_fmul_v3double:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[4:5]
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[6:7]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call double @llvm.vector.reduce.fmul.v3double(double %sp, <3 x double> %v)
  ret double %res
}

define double @test_vector_reduce_fmul_v4double(double %sp, <4 x double> %v) {
; GFX7-LABEL: test_vector_reduce_fmul_v4double:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v4double:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v4double:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v4double:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fmul_v4double:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_fmul_v4double:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[4:5]
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[6:7]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[8:9]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call double @llvm.vector.reduce.fmul.v4double(double %sp, <4 x double> %v)
  ret double %res
}

define double @test_vector_reduce_fmul_v8double(double %sp, <8 x double> %v) {
; GFX7-LABEL: test_vector_reduce_fmul_v8double:
; GFX7:       ; %bb.0: ; %entry
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX7-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: test_vector_reduce_fmul_v8double:
; GFX8:       ; %bb.0: ; %entry
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX8-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: test_vector_reduce_fmul_v8double:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX9-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: test_vector_reduce_fmul_v8double:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX10-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: test_vector_reduce_fmul_v8double:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: test_vector_reduce_fmul_v8double:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[4:5]
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[6:7]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[8:9]
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[10:11]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[12:13]
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[14:15]
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[16:17]
; GFX12-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call double @llvm.vector.reduce.fmul.v8double(double %sp, <8 x double> %v)
  ret double %res
}

define double @test_vector_reduce_fmul_v16double(double %sp, <16 x double> %v) {
; GFX7-SDAG-LABEL: test_vector_reduce_fmul_v16double:
; GFX7-SDAG:       ; %bb.0: ; %entry
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX7-SDAG-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX7-SDAG-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8
; GFX7-SDAG-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[18:19]
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[20:21]
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[22:23]
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[24:25]
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[26:27]
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[28:29]
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(2)
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[30:31]
; GFX7-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX7-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX7-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX7-GISEL-LABEL: test_vector_reduce_fmul_v16double:
; GFX7-GISEL:       ; %bb.0: ; %entry
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX7-GISEL-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX7-GISEL-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4
; GFX7-GISEL-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[18:19]
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[20:21]
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[22:23]
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[24:25]
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[26:27]
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[28:29]
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(2)
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[30:31]
; GFX7-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX7-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX7-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-SDAG-LABEL: test_vector_reduce_fmul_v16double:
; GFX8-SDAG:       ; %bb.0: ; %entry
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX8-SDAG-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX8-SDAG-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8
; GFX8-SDAG-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[18:19]
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[20:21]
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[22:23]
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[24:25]
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[26:27]
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[28:29]
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(2)
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[30:31]
; GFX8-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX8-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX8-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-GISEL-LABEL: test_vector_reduce_fmul_v16double:
; GFX8-GISEL:       ; %bb.0: ; %entry
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX8-GISEL-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX8-GISEL-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4
; GFX8-GISEL-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[18:19]
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[20:21]
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[22:23]
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[24:25]
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[26:27]
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[28:29]
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(2)
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[30:31]
; GFX8-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX8-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX8-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-SDAG-LABEL: test_vector_reduce_fmul_v16double:
; GFX9-SDAG:       ; %bb.0: ; %entry
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-SDAG-NEXT:    scratch_load_dword v33, off, s32 offset:8
; GFX9-SDAG-NEXT:    scratch_load_dword v31, off, s32
; GFX9-SDAG-NEXT:    scratch_load_dword v32, off, s32 offset:4
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[18:19]
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[20:21]
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[22:23]
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[24:25]
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[26:27]
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[28:29]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(1)
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[30:31]
; GFX9-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX9-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[32:33]
; GFX9-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-GISEL-LABEL: test_vector_reduce_fmul_v16double:
; GFX9-GISEL:       ; %bb.0: ; %entry
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-GISEL-NEXT:    scratch_load_dword v31, off, s32
; GFX9-GISEL-NEXT:    scratch_load_dword v32, off, s32 offset:4
; GFX9-GISEL-NEXT:    scratch_load_dword v33, off, s32 offset:8
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[18:19]
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[20:21]
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[22:23]
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[24:25]
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[26:27]
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[28:29]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(2)
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[30:31]
; GFX9-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX9-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[32:33]
; GFX9-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-SDAG-LABEL: test_vector_reduce_fmul_v16double:
; GFX10-SDAG:       ; %bb.0: ; %entry
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-SDAG-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX10-SDAG-NEXT:    s_clause 0x1
; GFX10-SDAG-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8
; GFX10-SDAG-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[18:19]
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[20:21]
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[22:23]
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[24:25]
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[26:27]
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[28:29]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(2)
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[30:31]
; GFX10-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX10-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX10-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-GISEL-LABEL: test_vector_reduce_fmul_v16double:
; GFX10-GISEL:       ; %bb.0: ; %entry
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-GISEL-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX10-GISEL-NEXT:    s_clause 0x1
; GFX10-GISEL-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:4
; GFX10-GISEL-NEXT:    buffer_load_dword v3, off, s[0:3], s32 offset:8
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[18:19]
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[20:21]
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[22:23]
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[24:25]
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[26:27]
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[28:29]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(2)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[30:31]
; GFX10-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX10-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX10-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-SDAG-LABEL: test_vector_reduce_fmul_v16double:
; GFX11-SDAG:       ; %bb.0: ; %entry
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX11-SDAG-NEXT:    s_clause 0x2
; GFX11-SDAG-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-SDAG-NEXT:    scratch_load_b32 v3, off, s32 offset:8
; GFX11-SDAG-NEXT:    scratch_load_b32 v2, off, s32 offset:4
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[18:19]
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[20:21]
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[22:23]
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[24:25]
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[26:27]
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[28:29]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(2)
; GFX11-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[30:31]
; GFX11-SDAG-NEXT:    s_waitcnt vmcnt(0)
; GFX11-SDAG-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX11-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-GISEL-LABEL: test_vector_reduce_fmul_v16double:
; GFX11-GISEL:       ; %bb.0: ; %entry
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX11-GISEL-NEXT:    s_clause 0x2
; GFX11-GISEL-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-GISEL-NEXT:    scratch_load_b32 v2, off, s32 offset:4
; GFX11-GISEL-NEXT:    scratch_load_b32 v3, off, s32 offset:8
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[4:5]
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[6:7]
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[8:9]
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[10:11]
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[12:13]
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[14:15]
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[16:17]
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[18:19]
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[20:21]
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[22:23]
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[24:25]
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[26:27]
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[28:29]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(2)
; GFX11-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[30:31]
; GFX11-GISEL-NEXT:    s_waitcnt vmcnt(0)
; GFX11-GISEL-NEXT:    v_mul_f64 v[0:1], v[0:1], v[2:3]
; GFX11-GISEL-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-SDAG-LABEL: test_vector_reduce_fmul_v16double:
; GFX12-SDAG:       ; %bb.0: ; %entry
; GFX12-SDAG-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-SDAG-NEXT:    s_wait_expcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_samplecnt 0x0
; GFX12-SDAG-NEXT:    s_wait_bvhcnt 0x0
; GFX12-SDAG-NEXT:    s_wait_kmcnt 0x0
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-SDAG-NEXT:    s_clause 0x2
; GFX12-SDAG-NEXT:    scratch_load_b32 v31, off, s32
; GFX12-SDAG-NEXT:    scratch_load_b32 v3, off, s32 offset:8
; GFX12-SDAG-NEXT:    scratch_load_b32 v2, off, s32 offset:4
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[4:5]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[6:7]
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[8:9]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[10:11]
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[12:13]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[14:15]
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[16:17]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[18:19]
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[20:21]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[22:23]
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[24:25]
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[26:27]
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[28:29]
; GFX12-SDAG-NEXT:    s_wait_loadcnt 0x2
; GFX12-SDAG-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[30:31]
; GFX12-SDAG-NEXT:    s_wait_loadcnt 0x0
; GFX12-SDAG-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-SDAG-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-GISEL-LABEL: test_vector_reduce_fmul_v16double:
; GFX12-GISEL:       ; %bb.0: ; %entry
; GFX12-GISEL-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-GISEL-NEXT:    s_wait_expcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_samplecnt 0x0
; GFX12-GISEL-NEXT:    s_wait_bvhcnt 0x0
; GFX12-GISEL-NEXT:    s_wait_kmcnt 0x0
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    s_clause 0x2
; GFX12-GISEL-NEXT:    scratch_load_b32 v31, off, s32
; GFX12-GISEL-NEXT:    scratch_load_b32 v2, off, s32 offset:4
; GFX12-GISEL-NEXT:    scratch_load_b32 v3, off, s32 offset:8
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[4:5]
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[6:7]
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[8:9]
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[10:11]
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[12:13]
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[14:15]
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[16:17]
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[18:19]
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[20:21]
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[22:23]
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[24:25]
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[26:27]
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[28:29]
; GFX12-GISEL-NEXT:    s_wait_loadcnt 0x2
; GFX12-GISEL-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[30:31]
; GFX12-GISEL-NEXT:    s_wait_loadcnt 0x0
; GFX12-GISEL-NEXT:    v_mul_f64_e32 v[0:1], v[0:1], v[2:3]
; GFX12-GISEL-NEXT:    s_setpc_b64 s[30:31]
entry:
  %res = call double @llvm.vector.reduce.fmul.v16double(double %sp, <16 x double> %v)
  ret double %res
}

declare half @llvm.vector.reduce.fmul.v2half(half, <2 x half>)
declare half @llvm.vector.reduce.fmul.v3half(half, <3 x half>)
declare half @llvm.vector.reduce.fmul.v4half(half, <4 x half>)
declare half @llvm.vector.reduce.fmul.v8half(half, <8 x half>)
declare half @llvm.vector.reduce.fmul.v16half(half, <16 x half>)
declare float @llvm.vector.reduce.fmul.v2float(float, <2 x float>)
declare float @llvm.vector.reduce.fmul.v3float(float, <3 x float>)
declare float @llvm.vector.reduce.fmul.v4float(float, <4 x float>)
declare float @llvm.vector.reduce.fmul.v8float(float, <8 x float>)
declare float @llvm.vector.reduce.fmul.v16float(float, <16 x float>)
declare double @llvm.vector.reduce.fmul.v2double(double, <2 x double>)
declare double @llvm.vector.reduce.fmul.v3double(double, <3 x double>)
declare double @llvm.vector.reduce.fmul.v4double(double, <4 x double>)
declare double @llvm.vector.reduce.fmul.v8double(double, <8 x double>)
declare double @llvm.vector.reduce.fmul.v16double(double, <16 x double>)
