; Test that LICM uses basicaa to do alias analysis, which is capable of
; disambiguating some obvious cases.  If LICM is able to disambiguate the
; two pointers, then the load should be hoisted, and the store sunk.

; RUN: opt < %s -aa-pipeline=basic-aa -passes='loop-mssa(licm)' -S | FileCheck %s
target datalayout = "E-p:64:64:64-a0:0:8-f32:32:32-f64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:32:64-v64:64:64-v128:128:128"

@A = global i32 7               ; <ptr> [#uses=3]
@B = global i32 8               ; <ptr> [#uses=2]
@C = global [2 x i32] [ i32 4, i32 8 ]          ; <ptr> [#uses=2]

define i32 @test1(i1 %c) {
        %Atmp = load i32, ptr @A            ; <i32> [#uses=2]
        br label %Loop

Loop:           ; preds = %Loop, %0
        %ToRemove = load i32, ptr @A                ; <i32> [#uses=1]
        store i32 %Atmp, ptr @B
        br i1 %c, label %Out, label %Loop

Out:            ; preds = %Loop
        %X = sub i32 %ToRemove, %Atmp           ; <i32> [#uses=1]
        ret i32 %X
        
; The Loop block should be empty after the load/store are promoted.
; CHECK:     @test1
; CHECK:        load i32, ptr @A
; CHECK:         load i32, ptr @A
; CHECK:         store i32 %Atmp, ptr @B
; CHECK:      Loop:
; CHECK-NEXT:   br i1 %c, label %Out, label %Loop
; CHECK:      Out:
}

define i32 @test2(i1 %c) {
        br label %Loop

Loop:           ; preds = %Loop, %0
        %AVal = load i32, ptr @A            ; <i32> [#uses=2]
        %C0 = getelementptr [2 x i32], ptr @C, i64 0, i64 0         ; <ptr> [#uses=1]
        store i32 %AVal, ptr %C0
        %BVal = load i32, ptr @B            ; <i32> [#uses=2]
        %C1 = getelementptr [2 x i32], ptr @C, i64 0, i64 1         ; <ptr> [#uses=1]
        store i32 %BVal, ptr %C1
        br i1 %c, label %Out, label %Loop

Out:            ; preds = %Loop
        %X = sub i32 %AVal, %BVal               ; <i32> [#uses=1]
        ret i32 %X
; The Loop block should be empty after the load/store are promoted.
; CHECK:     @test2
; CHECK:      Loop:
; CHECK-NEXT:   br i1 %c, label %Out, label %Loop
}

