; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='print<access-info>' -disable-output %s 2>&1 | FileCheck %s

target datalayout = "e-m:e-p:32:32-Fi8-i64:64-v128:64:128-a:0:32-n32-S64"

; Note: The datalayout for the test specifies a 32 bit index type.

; No UB: accessing last valid byte, pointer after the object
; doesnt wrap (%p + 2147483647).
define void @pointer_after_object_does_not_wrap(i32 %y, ptr %s, ptr %p) {
; CHECK-LABEL: 'pointer_after_object_does_not_wrap'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep2.iv = getelementptr inbounds i8, ptr %p, i32 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep1.iv = getelementptr inbounds i8, ptr %s, i32 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: (%y + %p) High: (2147483647 + %p))
; CHECK-NEXT:            Member: {(%y + %p),+,1}<nw><%loop>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: (%y + %s) High: (2147483647 + %s))
; CHECK-NEXT:            Member: {(%y + %s),+,1}<nw><%loop>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ %y, %entry ], [ %iv.next, %loop ]
  %gep1.iv = getelementptr inbounds i8 , ptr %s, i32 %iv
  %load = load i8, ptr %gep1.iv, align 4
  %gep2.iv = getelementptr inbounds i8, ptr %p, i32 %iv
  store i8 %load, ptr %gep2.iv, align 4
  %iv.next = add nsw i32 %iv, 1
  %c.2 = icmp slt i32 %iv.next, 2147483647
  br i1 %c.2, label %loop, label %exit

exit:
  ret void
}

; UB: accessing %p + 2147483646 and p + 2147483647.
; Pointer the past the object would wrap in signed.
define void @pointer_after_object_would_wrap(i32 %y, ptr %s, ptr %p) {
; CHECK-LABEL: 'pointer_after_object_would_wrap'
; CHECK-NEXT:    loop:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep2.iv = getelementptr inbounds i8, ptr %p, i32 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep1.iv = getelementptr inbounds i8, ptr %s, i32 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: (%y + %p) High: (-2147483648 + %p))
; CHECK-NEXT:            Member: {(%y + %p),+,1}<nw><%loop>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: (%y + %s) High: (-2147483648 + %s))
; CHECK-NEXT:            Member: {(%y + %s),+,1}<nw><%loop>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop

loop:
  %iv = phi i32 [ %y, %entry ], [ %iv.next, %loop ]
  %gep1.iv = getelementptr inbounds i8 , ptr %s, i32 %iv
  %load = load i16, ptr %gep1.iv, align 4
  %gep2.iv = getelementptr inbounds i8, ptr %p, i32 %iv
  store i16 %load, ptr %gep2.iv, align 4
  %iv.next = add nsw i32 %iv, 1
  %c.2 = icmp slt i32 %iv.next, 2147483647
  br i1 %c.2, label %loop, label %exit

exit:
  ret void
}
