; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='print<access-info>' -disable-output  < %s 2>&1 | FileCheck %s

; This is the test case from PR26314.
; When we were retrying dependence checking with memchecks only,
; the loop-invariant access in the inner loop was incorrectly determined to be wrapping
; because it was not strided in the inner loop.

; #define Z 32
; typedef struct s {
;	int v1[Z];
;	int v2[Z];
;	int v3[Z][Z];
; } s;
;
; void slow_function (s* const obj, int z) {
;    for (int j=0; j<Z; j++) {
;        for (int k=0; k<z; k++) {
;            int x = obj->v1[k] + obj->v2[j];
;            obj->v3[j][k] += x;
;        }
;    }
; }

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

%struct.s = type { [32 x i32], [32 x i32], [32 x [32 x i32]] }

define void @Test(ptr nocapture %obj, i64 %z) #0 {
; CHECK-LABEL: 'Test'
; CHECK-NEXT:    .inner:
; CHECK-NEXT:      Memory dependences are safe with a maximum safe vector width of 2048 bits with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %6 = getelementptr inbounds %struct.s, ptr %obj, i64 0, i32 2, i64 %i, i64 %j
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %2 = getelementptr inbounds %struct.s, ptr %obj, i64 0, i32 0, i64 %j
; CHECK-NEXT:      Check 1:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %6 = getelementptr inbounds %struct.s, ptr %obj, i64 0, i32 2, i64 %i, i64 %j
; CHECK-NEXT:        Against group GRP2:
; CHECK-NEXT:          %1 = getelementptr inbounds %struct.s, ptr %obj, i64 0, i32 1, i64 %i
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: {(256 + %obj)<nuw>,+,128}<nuw><%.outer.preheader> High: {(256 + (4 * %z) + %obj),+,128}<nw><%.outer.preheader>)
; CHECK-NEXT:            Member: {{\{\{}}(256 + %obj)<nuw>,+,128}<nuw><%.outer.preheader>,+,4}<nuw><%.inner>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %obj High: ((4 * %z) + %obj))
; CHECK-NEXT:            Member: {%obj,+,4}<nuw><%.inner>
; CHECK-NEXT:        Group GRP2:
; CHECK-NEXT:          (Low: {(128 + %obj)<nuw>,+,4}<nuw><%.outer.preheader> High: {(132 + %obj),+,4}<nw><%.outer.preheader>)
; CHECK-NEXT:            Member: {(128 + %obj)<nuw>,+,4}<nuw><%.outer.preheader>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
; CHECK-NEXT:    .outer.preheader:
; CHECK-NEXT:      Report: loop is not the innermost loop
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
  br label %.outer.preheader


.outer.preheader:
  %i = phi i64 [ 0, %0 ], [ %i.next, %.outer ]
  %1 = getelementptr inbounds %struct.s, ptr %obj, i64 0, i32 1, i64 %i
  br label %.inner

.exit:
  ret void

.outer:
  %i.next = add nuw nsw i64 %i, 1
  %exitcond.outer = icmp eq i64 %i.next, 32
  br i1 %exitcond.outer, label %.exit, label %.outer.preheader

.inner:
  %j = phi i64 [ 0, %.outer.preheader ], [ %j.next, %.inner ]
  %2 = getelementptr inbounds %struct.s, ptr %obj, i64 0, i32 0, i64 %j
  %3 = load i32, ptr %2
  %4 = load i32, ptr %1
  %5 = add nsw i32 %4, %3
  %6 = getelementptr inbounds %struct.s, ptr %obj, i64 0, i32 2, i64 %i, i64 %j
  %7 = load i32, ptr %6
  %8 = add nsw i32 %5, %7
  store i32 %8, ptr %6
  %j.next = add nuw nsw i64 %j, 1
  %exitcond.inner = icmp eq i64 %j.next, %z
  br i1 %exitcond.inner, label %.outer, label %.inner
}
