; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=arm64-eabi | FileCheck %s


define <4 x i16> @fptosi_v4f64_to_v4i16(ptr %ptr) {
; CHECK-LABEL: fptosi_v4f64_to_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    fcvtzs v1.2d, v1.2d
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
  %tmp1 = load <4 x double>, ptr %ptr
  %tmp2 = fptosi <4 x double> %tmp1 to <4 x i16>
  ret <4 x i16> %tmp2
}

define <8 x i8> @fptosi_v4f64_to_v4i8(ptr %ptr) {
; CHECK-LABEL: fptosi_v4f64_to_v4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0, #32]
; CHECK-NEXT:    ldp q2, q3, [x0]
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    fcvtzs v1.2d, v1.2d
; CHECK-NEXT:    fcvtzs v3.2d, v3.2d
; CHECK-NEXT:    fcvtzs v2.2d, v2.2d
; CHECK-NEXT:    uzp1 v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    uzp1 v1.4s, v2.4s, v3.4s
; CHECK-NEXT:    uzp1 v0.8h, v1.8h, v0.8h
; CHECK-NEXT:    xtn v0.8b, v0.8h
; CHECK-NEXT:    ret
  %tmp1 = load <8 x double>, ptr %ptr
  %tmp2 = fptosi <8 x double> %tmp1 to <8 x i8>
  ret <8 x i8> %tmp2
}

define <4 x half> @uitofp_v4i64_to_v4f16(ptr %ptr) {
; CHECK-LABEL: uitofp_v4i64_to_v4f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    ucvtf v0.2d, v0.2d
; CHECK-NEXT:    ucvtf v1.2d, v1.2d
; CHECK-NEXT:    fcvtn v0.2s, v0.2d
; CHECK-NEXT:    fcvtn2 v0.4s, v1.2d
; CHECK-NEXT:    fcvtn v0.4h, v0.4s
; CHECK-NEXT:    ret
  %tmp1 = load <4 x i64>, ptr %ptr
  %tmp2 = uitofp <4 x i64> %tmp1 to <4 x half>
  ret <4 x half> %tmp2
}

define <4 x bfloat> @uitofp_v4i64_to_v4bf16(ptr %ptr) {
; CHECK-LABEL: uitofp_v4i64_to_v4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q2, [x0]
; CHECK-NEXT:    mov x8, v0.d[1]
; CHECK-NEXT:    fmov x9, d0
; CHECK-NEXT:    ucvtf s1, x9
; CHECK-NEXT:    mov x9, v2.d[1]
; CHECK-NEXT:    ucvtf s0, x8
; CHECK-NEXT:    fmov x8, d2
; CHECK-NEXT:    ucvtf s2, x8
; CHECK-NEXT:    mov v1.s[1], v0.s[0]
; CHECK-NEXT:    ucvtf s0, x9
; CHECK-NEXT:    mov v1.s[2], v2.s[0]
; CHECK-NEXT:    movi v2.4s, #127, msl #8
; CHECK-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-NEXT:    movi v0.4s, #1
; CHECK-NEXT:    ushr v3.4s, v1.4s, #16
; CHECK-NEXT:    add v2.4s, v1.4s, v2.4s
; CHECK-NEXT:    and v0.16b, v3.16b, v0.16b
; CHECK-NEXT:    fcmeq v3.4s, v1.4s, v1.4s
; CHECK-NEXT:    orr v1.4s, #64, lsl #16
; CHECK-NEXT:    add v0.4s, v0.4s, v2.4s
; CHECK-NEXT:    bif v0.16b, v1.16b, v3.16b
; CHECK-NEXT:    shrn v0.4h, v0.4s, #16
; CHECK-NEXT:    ret
  %tmp1 = load <4 x i64>, ptr %ptr
  %tmp2 = uitofp <4 x i64> %tmp1 to <4 x bfloat>
  ret <4 x bfloat> %tmp2
}

define <4 x i16> @trunc_v4i64_to_v4i16(ptr %ptr) {
; CHECK-LABEL: trunc_v4i64_to_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q1, q0, [x0]
; CHECK-NEXT:    uzp1 v0.4s, v1.4s, v0.4s
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
  %tmp1 = load <4 x i64>, ptr %ptr
  %tmp2 = trunc <4 x i64> %tmp1 to <4 x i16>
  ret <4 x i16> %tmp2
}

define <4 x i16> @fptoui_v4f64_to_v4i16(ptr %ptr) {
; CHECK-LABEL: fptoui_v4f64_to_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q1, [x0]
; CHECK-NEXT:    fcvtzs v1.2d, v1.2d
; CHECK-NEXT:    fcvtzs v0.2d, v0.2d
; CHECK-NEXT:    uzp1 v0.4s, v0.4s, v1.4s
; CHECK-NEXT:    xtn v0.4h, v0.4s
; CHECK-NEXT:    ret
  %tmp1 = load <4 x double>, ptr %ptr
  %tmp2 = fptoui <4 x double> %tmp1 to <4 x i16>
  ret <4 x i16> %tmp2
}
