; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mattr=+sve -o - | FileCheck %s
; RUN: llc -use-constant-int-for-scalable-splat -use-constant-fp-for-scalable-splat < %s --mattr=+sve -o - | FileCheck %s

target triple = "aarch64"

; a[i] * b[i] * (11.0 + 3.0.i);
;
define <vscale x 4 x double> @complex_mul_const(<vscale x 4 x double> %a, <vscale x 4 x double> %b) {
; CHECK-LABEL: complex_mul_const:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v4.2d, #0000000000000000
; CHECK-NEXT:    movi v5.2d, #0000000000000000
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fmov z6.d, #3.00000000
; CHECK-NEXT:    fmov z7.d, #11.00000000
; CHECK-NEXT:    fcmla z4.d, p0/m, z0.d, z2.d, #0
; CHECK-NEXT:    fcmla z5.d, p0/m, z1.d, z3.d, #0
; CHECK-NEXT:    fcmla z4.d, p0/m, z0.d, z2.d, #90
; CHECK-NEXT:    movi v2.2d, #0000000000000000
; CHECK-NEXT:    fcmla z5.d, p0/m, z1.d, z3.d, #90
; CHECK-NEXT:    zip2 z1.d, z7.d, z6.d
; CHECK-NEXT:    movi v0.2d, #0000000000000000
; CHECK-NEXT:    zip1 z3.d, z7.d, z6.d
; CHECK-NEXT:    fcmla z2.d, p0/m, z5.d, z1.d, #0
; CHECK-NEXT:    fcmla z0.d, p0/m, z4.d, z3.d, #0
; CHECK-NEXT:    fcmla z2.d, p0/m, z5.d, z1.d, #90
; CHECK-NEXT:    fcmla z0.d, p0/m, z4.d, z3.d, #90
; CHECK-NEXT:    mov z1.d, z2.d
; CHECK-NEXT:    ret
entry:
  %strided.vec = tail call { <vscale x 2 x double>, <vscale x 2 x double> } @llvm.vector.deinterleave2.nxv4f64(<vscale x 4 x double> %a)
  %0 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %strided.vec, 0
  %1 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %strided.vec, 1
  %strided.vec48 = tail call { <vscale x 2 x double>, <vscale x 2 x double> } @llvm.vector.deinterleave2.nxv4f64(<vscale x 4 x double> %b)
  %2 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %strided.vec48, 0
  %3 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %strided.vec48, 1
  %4 = fmul fast <vscale x 2 x double> %3, %0
  %5 = fmul fast <vscale x 2 x double> %2, %1
  %6 = fadd fast <vscale x 2 x double> %4, %5
  %7 = fmul fast <vscale x 2 x double> %2, %0
  %8 = fmul fast <vscale x 2 x double> %3, %1
  %9 = fsub fast <vscale x 2 x double> %7, %8
  %10 = fmul fast <vscale x 2 x double> %9, splat (double 3.000000e+00)
  %11 = fmul fast <vscale x 2 x double> %6, splat (double 1.100000e+01)
  %12 = fadd fast <vscale x 2 x double> %10, %11
  %13 = fmul fast <vscale x 2 x double> %9, splat (double 1.100000e+01)
  %14 = fmul fast <vscale x 2 x double> %6, splat (double 3.000000e+00)
  %15 = fsub fast <vscale x 2 x double> %13, %14
  %interleaved.vec = tail call <vscale x 4 x double> @llvm.vector.interleave2.nxv4f64(<vscale x 2 x double> %15, <vscale x 2 x double> %12)
  ret <vscale x 4 x double> %interleaved.vec
}

; a[i] * b[i] * c;
;
define <vscale x 4 x double> @complex_mul_non_const(<vscale x 4 x double> %a, <vscale x 4 x double> %b, [2 x double] %c) {
; CHECK-LABEL: complex_mul_non_const:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v7.2d, #0000000000000000
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    // kill: def $d5 killed $d5 def $z5
; CHECK-NEXT:    // kill: def $d4 killed $d4 def $z4
; CHECK-NEXT:    movi v6.2d, #0000000000000000
; CHECK-NEXT:    mov z5.d, d5
; CHECK-NEXT:    mov z24.d, d4
; CHECK-NEXT:    movi v4.2d, #0000000000000000
; CHECK-NEXT:    fcmla z7.d, p0/m, z1.d, z3.d, #0
; CHECK-NEXT:    fcmla z6.d, p0/m, z0.d, z2.d, #0
; CHECK-NEXT:    fcmla z7.d, p0/m, z1.d, z3.d, #90
; CHECK-NEXT:    zip2 z1.d, z24.d, z5.d
; CHECK-NEXT:    fcmla z6.d, p0/m, z0.d, z2.d, #90
; CHECK-NEXT:    movi v0.2d, #0000000000000000
; CHECK-NEXT:    zip1 z2.d, z24.d, z5.d
; CHECK-NEXT:    fcmla z4.d, p0/m, z7.d, z1.d, #0
; CHECK-NEXT:    fcmla z0.d, p0/m, z6.d, z2.d, #0
; CHECK-NEXT:    fcmla z4.d, p0/m, z7.d, z1.d, #90
; CHECK-NEXT:    fcmla z0.d, p0/m, z6.d, z2.d, #90
; CHECK-NEXT:    mov z1.d, z4.d
; CHECK-NEXT:    ret
entry:
  %c.coerce.fca.0.extract = extractvalue [2 x double] %c, 0
  %c.coerce.fca.1.extract = extractvalue [2 x double] %c, 1
  %broadcast.splatinsert = insertelement <vscale x 2 x double> poison, double %c.coerce.fca.1.extract, i64 0
  %broadcast.splat = shufflevector <vscale x 2 x double> %broadcast.splatinsert, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %broadcast.splatinsert49 = insertelement <vscale x 2 x double> poison, double %c.coerce.fca.0.extract, i64 0
  %broadcast.splat50 = shufflevector <vscale x 2 x double> %broadcast.splatinsert49, <vscale x 2 x double> poison, <vscale x 2 x i32> zeroinitializer
  %strided.vec = tail call { <vscale x 2 x double>, <vscale x 2 x double> } @llvm.vector.deinterleave2.nxv4f64(<vscale x 4 x double> %a)
  %0 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %strided.vec, 0
  %1 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %strided.vec, 1
  %strided.vec48 = tail call { <vscale x 2 x double>, <vscale x 2 x double> } @llvm.vector.deinterleave2.nxv4f64(<vscale x 4 x double> %b)
  %2 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %strided.vec48, 0
  %3 = extractvalue { <vscale x 2 x double>, <vscale x 2 x double> } %strided.vec48, 1
  %4 = fmul fast <vscale x 2 x double> %3, %0
  %5 = fmul fast <vscale x 2 x double> %2, %1
  %6 = fadd fast <vscale x 2 x double> %4, %5
  %7 = fmul fast <vscale x 2 x double> %2, %0
  %8 = fmul fast <vscale x 2 x double> %3, %1
  %9 = fsub fast <vscale x 2 x double> %7, %8
  %10 = fmul fast <vscale x 2 x double> %9, %broadcast.splat
  %11 = fmul fast <vscale x 2 x double> %6, %broadcast.splat50
  %12 = fadd fast <vscale x 2 x double> %10, %11
  %13 = fmul fast <vscale x 2 x double> %9, %broadcast.splat50
  %14 = fmul fast <vscale x 2 x double> %6, %broadcast.splat
  %15 = fsub fast <vscale x 2 x double> %13, %14
  %interleaved.vec = tail call <vscale x 4 x double> @llvm.vector.interleave2.nxv4f64(<vscale x 2 x double> %15, <vscale x 2 x double> %12)
  ret <vscale x 4 x double> %interleaved.vec
}

declare { <vscale x 2 x double>, <vscale x 2 x double> } @llvm.vector.deinterleave2.nxv4f64(<vscale x 4 x double>)
declare <vscale x 4 x double> @llvm.vector.interleave2.nxv4f64(<vscale x 2 x double>, <vscale x 2 x double>)
