; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -filetype asm -o - %s | FileCheck %s

; This shows that CodeGen for AArch64 will elide the tag check when lowering
; the HWASan memaccess intrinsic for null pointers.
;
; N.B. The HWASan pass will normally omit the memaccess intrinsic if the
;      pointer is already statically known to be null.
;
; The source was generated from llvm/test/Instrumentation/HWAddressSanitizer/zero-ptr.ll
; with the memaccess deliberately retained.

; ModuleID = '<stdin>'
source_filename = "<stdin>"
target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "aarch64--linux-android10000"

$hwasan.module_ctor = comdat any

@__start_hwasan_globals = external hidden constant [0 x i8]
@__stop_hwasan_globals = external hidden constant [0 x i8]
@hwasan.note = private constant { i32, i32, i32, [8 x i8], i32, i32 } { i32 8, i32 8, i32 3, [8 x i8] c"LLVM\00\00\00\00", i32 trunc (i64 sub (i64 ptrtoint (ptr @__start_hwasan_globals to i64), i64 ptrtoint (ptr @hwasan.note to i64)) to i32), i32 trunc (i64 sub (i64 ptrtoint (ptr @__stop_hwasan_globals to i64), i64 ptrtoint (ptr @hwasan.note to i64)) to i32) }, section ".note.hwasan.globals", comdat($hwasan.module_ctor), align 4

; Function Attrs: sanitize_hwaddress
define void @test_store_to_zeroptr() #0 {
; CHECK-LABEL: test_store_to_zeroptr:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    .cfi_offset w30, -16
; CHECK-NEXT:    mov x8, xzr
; CHECK-NEXT:    mov w9, #42 // =0x2a
; CHECK-NEXT:    str x9, [x8]
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
entry:
  %.hwasan.shadow = call ptr asm "", "=r,0"(ptr null)
  %b = inttoptr i64 0 to ptr
  call void @llvm.hwasan.check.memaccess.shortgranules.fixedshadow(ptr %b, i32 19, i64 0)
  store i64 42, ptr %b, align 8
  ret void
}

; Function Attrs: nounwind
declare void @llvm.hwasan.check.memaccess.shortgranules.fixedshadow(ptr, i32 immarg, i64 immarg) #1

attributes #0 = { sanitize_hwaddress }
attributes #1 = { nounwind }

declare void @__hwasan_init()

; Function Attrs: nounwind
define internal void @hwasan.module_ctor() #1 comdat {
; CHECK-LABEL: hwasan.module_ctor:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    bl __hwasan_init
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
  call void @__hwasan_init()
  ret void
}

!llvm.module.flags = !{!1}

!0 = !{ptr @hwasan.note}
!1 = !{i32 4, !"nosanitize_hwaddress", i32 1}
