; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mattr=+sve,+bf16            < %s | FileCheck %s --check-prefixes=CHECK,SVE
; RUN: llc -mattr=+sme -force-streaming < %s | FileCheck %s --check-prefixes=CHECK,STREAMING-SVE

target triple = "aarch64-unknown-linux-gnu"

define <vscale x 2 x i1> @fptosi_nxv2bf16_to_nxv2i1(<vscale x 2 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv2bf16_to_nxv2i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z0.s
; CHECK-NEXT:    cmpne p0.d, p0/z, z0.d, #0
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 2 x bfloat> %a to <vscale x 2 x i1>
  ret <vscale x 2 x i1> %res
}

define <vscale x 2 x i8> @fptosi_nxv2bf16_to_nxv2i8(<vscale x 2 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv2bf16_to_nxv2i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 2 x bfloat> %a to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %res
}

define <vscale x 2 x i16> @fptosi_nxv2bf16_to_nxv2i16(<vscale x 2 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv2bf16_to_nxv2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 2 x bfloat> %a to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %res
}

define <vscale x 2 x i32> @fptosi_nxv2bf16_to_nxv2i32(<vscale x 2 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv2bf16_to_nxv2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 2 x bfloat> %a to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %res
}

define <vscale x 2 x i64> @fptosi_nxv2bf16_to_nxv2i64(<vscale x 2 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv2bf16_to_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 2 x bfloat> %a to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %res
}

define <vscale x 4 x i1> @fptosi_nxv4bf16_to_nxv4i1(<vscale x 4 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv4bf16_to_nxv4i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.s
; CHECK-NEXT:    cmpne p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 4 x bfloat> %a to <vscale x 4 x i1>
  ret <vscale x 4 x i1> %res
}

define <vscale x 4 x i8> @fptosi_nxv4bf16_to_nxv4i8(<vscale x 4 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv4bf16_to_nxv4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 4 x bfloat> %a to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %res
}

define <vscale x 4 x i16> @fptosi_nxv4bf16_to_nxv4i16(<vscale x 4 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv4bf16_to_nxv4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 4 x bfloat> %a to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %res
}

define <vscale x 4 x i32> @fptosi_nxv4bf16_to_nxv4i32(<vscale x 4 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv4bf16_to_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 4 x bfloat> %a to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %res
}

define <vscale x 4 x i64> @fptosi_nxv4bf16_to_nxv4i64(<vscale x 4 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv4bf16_to_nxv4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z1.d, z0.s
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    lsl z1.s, z1.s, #16
; CHECK-NEXT:    lsl z2.s, z0.s, #16
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fcvtzs z1.d, p0/m, z2.s
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 4 x bfloat> %a to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %res
}

define <vscale x 8 x i1> @fptosi_nxv8bf16_to_nxv8i1(<vscale x 8 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv8bf16_to_nxv8i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z1.s, z0.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    lsl z1.s, z1.s, #16
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    fcvtzs z1.s, p0/m, z1.s
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.s
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    uzp1 z0.h, z0.h, z1.h
; CHECK-NEXT:    cmpne p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 8 x bfloat> %a to <vscale x 8 x i1>
  ret <vscale x 8 x i1> %res
}

define <vscale x 8 x i8> @fptosi_nxv8bf16_to_nxv8i8(<vscale x 8 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv8bf16_to_nxv8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z1.s, z0.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    lsl z1.s, z1.s, #16
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    fcvtzs z1.s, p0/m, z1.s
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 8 x bfloat> %a to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %res
}

define <vscale x 8 x i16> @fptosi_nxv8bf16_to_nxv8i16(<vscale x 8 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv8bf16_to_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z1.s, z0.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    lsl z1.s, z1.s, #16
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    fcvtzs z1.s, p0/m, z1.s
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 8 x bfloat> %a to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %res
}

define <vscale x 8 x i32> @fptosi_nxv8bf16_to_nxv8i32(<vscale x 8 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv8bf16_to_nxv8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z1.s, z0.h
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    lsl z1.s, z1.s, #16
; CHECK-NEXT:    lsl z2.s, z0.s, #16
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fcvtzs z1.s, p0/m, z2.s
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 8 x bfloat> %a to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %res
}

define <vscale x 8 x i64> @fptosi_nxv8bf16_to_nxv8i64(<vscale x 8 x bfloat> %a) {
; CHECK-LABEL: fptosi_nxv8bf16_to_nxv8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z1.s, z0.h
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    uunpklo z2.d, z1.s
; CHECK-NEXT:    uunpkhi z1.d, z1.s
; CHECK-NEXT:    uunpklo z3.d, z0.s
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    lsl z1.s, z1.s, #16
; CHECK-NEXT:    lsl z2.s, z2.s, #16
; CHECK-NEXT:    lsl z3.s, z3.s, #16
; CHECK-NEXT:    lsl z4.s, z0.s, #16
; CHECK-NEXT:    fcvtzs z1.d, p0/m, z1.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z2.s
; CHECK-NEXT:    movprfx z2, z3
; CHECK-NEXT:    fcvtzs z2.d, p0/m, z3.s
; CHECK-NEXT:    movprfx z3, z4
; CHECK-NEXT:    fcvtzs z3.d, p0/m, z4.s
; CHECK-NEXT:    ret
  %res = fptosi <vscale x 8 x bfloat> %a to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %res
}

define <vscale x 2 x i1> @fptoui_nxv2bf16_to_nxv2i1(<vscale x 2 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv2bf16_to_nxv2i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvtzu z0.d, p0/m, z0.s
; CHECK-NEXT:    cmpne p0.d, p0/z, z0.d, #0
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 2 x bfloat> %a to <vscale x 2 x i1>
  ret <vscale x 2 x i1> %res
}

; NOTE: Using fcvtzs is safe as fptoui overflow is considered poison and a
; 64bit signed value encompasses the entire range of a 16bit unsigned value.
define <vscale x 2 x i8> @fptoui_nxv2bf16_to_nxv2i8(<vscale x 2 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv2bf16_to_nxv2i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 2 x bfloat> %a to <vscale x 2 x i8>
  ret <vscale x 2 x i8> %res
}

define <vscale x 2 x i16> @fptoui_nxv2bf16_to_nxv2i16(<vscale x 2 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv2bf16_to_nxv2i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 2 x bfloat> %a to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %res
}

define <vscale x 2 x i32> @fptoui_nxv2bf16_to_nxv2i32(<vscale x 2 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv2bf16_to_nxv2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvtzs z0.d, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 2 x bfloat> %a to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %res
}

define <vscale x 2 x i64> @fptoui_nxv2bf16_to_nxv2i64(<vscale x 2 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv2bf16_to_nxv2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    fcvtzu z0.d, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 2 x bfloat> %a to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %res
}

define <vscale x 4 x i1> @fptoui_nxv4bf16_to_nxv4i1(<vscale x 4 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv4bf16_to_nxv4i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvtzu z0.s, p0/m, z0.s
; CHECK-NEXT:    cmpne p0.s, p0/z, z0.s, #0
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 4 x bfloat> %a to <vscale x 4 x i1>
  ret <vscale x 4 x i1> %res
}

define <vscale x 4 x i8> @fptoui_nxv4bf16_to_nxv4i8(<vscale x 4 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv4bf16_to_nxv4i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 4 x bfloat> %a to <vscale x 4 x i8>
  ret <vscale x 4 x i8> %res
}

define <vscale x 4 x i16> @fptoui_nxv4bf16_to_nxv4i16(<vscale x 4 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv4bf16_to_nxv4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 4 x bfloat> %a to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %res
}

define <vscale x 4 x i32> @fptoui_nxv4bf16_to_nxv4i32(<vscale x 4 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv4bf16_to_nxv4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    fcvtzu z0.s, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 4 x bfloat> %a to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %res
}

define <vscale x 4 x i64> @fptoui_nxv4bf16_to_nxv4i64(<vscale x 4 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv4bf16_to_nxv4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z1.d, z0.s
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    lsl z1.s, z1.s, #16
; CHECK-NEXT:    lsl z2.s, z0.s, #16
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fcvtzu z0.d, p0/m, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fcvtzu z1.d, p0/m, z2.s
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 4 x bfloat> %a to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %res
}

define <vscale x 8 x i1> @fptoui_nxv8bf16_to_nxv8i1(<vscale x 8 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv8bf16_to_nxv8i1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z1.s, z0.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    lsl z1.s, z1.s, #16
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    fcvtzs z1.s, p0/m, z1.s
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.s
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    uzp1 z0.h, z0.h, z1.h
; CHECK-NEXT:    cmpne p0.h, p0/z, z0.h, #0
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 8 x bfloat> %a to <vscale x 8 x i1>
  ret <vscale x 8 x i1> %res
}

define <vscale x 8 x i8> @fptoui_nxv8bf16_to_nxv8i8(<vscale x 8 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv8bf16_to_nxv8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z1.s, z0.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    lsl z1.s, z1.s, #16
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    fcvtzs z1.s, p0/m, z1.s
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 8 x bfloat> %a to <vscale x 8 x i8>
  ret <vscale x 8 x i8> %res
}

define <vscale x 8 x i16> @fptoui_nxv8bf16_to_nxv8i16(<vscale x 8 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv8bf16_to_nxv8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z1.s, z0.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    lsl z1.s, z1.s, #16
; CHECK-NEXT:    lsl z0.s, z0.s, #16
; CHECK-NEXT:    fcvtzs z1.s, p0/m, z1.s
; CHECK-NEXT:    fcvtzs z0.s, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 8 x bfloat> %a to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %res
}

define <vscale x 8 x i32> @fptoui_nxv8bf16_to_nxv8i32(<vscale x 8 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv8bf16_to_nxv8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z1.s, z0.h
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    lsl z1.s, z1.s, #16
; CHECK-NEXT:    lsl z2.s, z0.s, #16
; CHECK-NEXT:    movprfx z0, z1
; CHECK-NEXT:    fcvtzu z0.s, p0/m, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    fcvtzu z1.s, p0/m, z2.s
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 8 x bfloat> %a to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %res
}

define <vscale x 8 x i64> @fptoui_nxv8bf16_to_nxv8i64(<vscale x 8 x bfloat> %a) {
; CHECK-LABEL: fptoui_nxv8bf16_to_nxv8i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpklo z1.s, z0.h
; CHECK-NEXT:    uunpkhi z0.s, z0.h
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    uunpklo z2.d, z1.s
; CHECK-NEXT:    uunpkhi z1.d, z1.s
; CHECK-NEXT:    uunpklo z3.d, z0.s
; CHECK-NEXT:    uunpkhi z0.d, z0.s
; CHECK-NEXT:    lsl z1.s, z1.s, #16
; CHECK-NEXT:    lsl z2.s, z2.s, #16
; CHECK-NEXT:    lsl z3.s, z3.s, #16
; CHECK-NEXT:    lsl z4.s, z0.s, #16
; CHECK-NEXT:    fcvtzu z1.d, p0/m, z1.s
; CHECK-NEXT:    movprfx z0, z2
; CHECK-NEXT:    fcvtzu z0.d, p0/m, z2.s
; CHECK-NEXT:    movprfx z2, z3
; CHECK-NEXT:    fcvtzu z2.d, p0/m, z3.s
; CHECK-NEXT:    movprfx z3, z4
; CHECK-NEXT:    fcvtzu z3.d, p0/m, z4.s
; CHECK-NEXT:    ret
  %res = fptoui <vscale x 8 x bfloat> %a to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %res
}

; NOTE: f16(-1.875) == bf16(-1.0)
define <vscale x 2 x bfloat> @sitofp_nxv2i1_to_nxv2bf16(<vscale x 2 x i1> %a) {
; SVE-LABEL: sitofp_nxv2i1_to_nxv2bf16:
; SVE:       // %bb.0:
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fmov z0.h, p0/m, #-1.87500000
; SVE-NEXT:    ret
;
; STREAMING-SVE-LABEL: sitofp_nxv2i1_to_nxv2bf16:
; STREAMING-SVE:       // %bb.0:
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    fmov z0.h, p0/m, #-1.87500000
; STREAMING-SVE-NEXT:    ret
  %res = sitofp <vscale x 2 x i1> %a to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 2 x bfloat> @sitofp_nxv2i8_to_nxv2bf16(<vscale x 2 x i8> %a) {
; CHECK-LABEL: sitofp_nxv2i8_to_nxv2bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    sxtb z0.d, p0/m, z0.d
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = sitofp <vscale x 2 x i8> %a to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 2 x bfloat> @sitofp_nxv2i16_to_nxv2bf16(<vscale x 2 x i16> %a) {
; CHECK-LABEL: sitofp_nxv2i16_to_nxv2bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    sxth z0.d, p0/m, z0.d
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = sitofp <vscale x 2 x i16> %a to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 2 x bfloat> @sitofp_nxv2i32_to_nxv2bf16(<vscale x 2 x i32> %a) {
; CHECK-LABEL: sitofp_nxv2i32_to_nxv2bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = sitofp <vscale x 2 x i32> %a to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 2 x bfloat> @sitofp_nxv2i64_to_nxv2bf16(<vscale x 2 x i64> %a) {
; CHECK-LABEL: sitofp_nxv2i64_to_nxv2bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = sitofp <vscale x 2 x i64> %a to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 4 x bfloat> @sitofp_nxv4i1_to_nxv4bf16(<vscale x 4 x i1> %a) {
; SVE-LABEL: sitofp_nxv4i1_to_nxv4bf16:
; SVE:       // %bb.0:
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fmov z0.h, p0/m, #-1.87500000
; SVE-NEXT:    ret
;
; STREAMING-SVE-LABEL: sitofp_nxv4i1_to_nxv4bf16:
; STREAMING-SVE:       // %bb.0:
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    fmov z0.h, p0/m, #-1.87500000
; STREAMING-SVE-NEXT:    ret
  %res = sitofp <vscale x 4 x i1> %a to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 4 x bfloat> @sitofp_nxv4i8_to_nxv4bf16(<vscale x 4 x i8> %a) {
; CHECK-LABEL: sitofp_nxv4i8_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sxtb z0.s, p0/m, z0.s
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = sitofp <vscale x 4 x i8> %a to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 4 x bfloat> @sitofp_nxv4i16_to_nxv4bf16(<vscale x 4 x i16> %a) {
; CHECK-LABEL: sitofp_nxv4i16_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sxth z0.s, p0/m, z0.s
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = sitofp <vscale x 4 x i16> %a to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 4 x bfloat> @sitofp_nxv4i32_to_nxv4bf16(<vscale x 4 x i32> %a) {
; CHECK-LABEL: sitofp_nxv4i32_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = sitofp <vscale x 4 x i32> %a to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 4 x bfloat> @sitofp_nxv4i64_to_nxv4bf16(<vscale x 4 x i64> %a) {
; CHECK-LABEL: sitofp_nxv4i64_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    bfcvt z1.h, p0/m, z1.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.s, z0.s, z1.s
; CHECK-NEXT:    ret
  %res = sitofp <vscale x 4 x i64> %a to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 8 x bfloat> @sitofp_nxv8i1_to_nxv8bf16(<vscale x 8 x i1> %a) {
; SVE-LABEL: sitofp_nxv8i1_to_nxv8bf16:
; SVE:       // %bb.0:
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fmov z0.h, p0/m, #-1.87500000
; SVE-NEXT:    ret
;
; STREAMING-SVE-LABEL: sitofp_nxv8i1_to_nxv8bf16:
; STREAMING-SVE:       // %bb.0:
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    fmov z0.h, p0/m, #-1.87500000
; STREAMING-SVE-NEXT:    ret
  %res = sitofp <vscale x 8 x i1> %a to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %res
}

define <vscale x 8 x bfloat> @sitofp_nxv8i8_to_nxv8bf16(<vscale x 8 x i8> %a) {
; CHECK-LABEL: sitofp_nxv8i8_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h
; CHECK-NEXT:    sxtb z0.h, p0/m, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    sunpkhi z1.s, z0.h
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z1.h, p0/m, z1.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
  %res = sitofp <vscale x 8 x i8> %a to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %res
}

define <vscale x 8 x bfloat> @sitofp_nxv8i16_to_nxv8bf16(<vscale x 8 x i16> %a) {
; CHECK-LABEL: sitofp_nxv8i16_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sunpkhi z1.s, z0.h
; CHECK-NEXT:    sunpklo z0.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z1.h, p0/m, z1.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
  %res = sitofp <vscale x 8 x i16> %a to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %res
}

define <vscale x 8 x bfloat> @sitofp_nxv8i32_to_nxv8bf16(<vscale x 8 x i32> %a) {
; CHECK-LABEL: sitofp_nxv8i32_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z1.h, p0/m, z1.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
  %res = sitofp <vscale x 8 x i32> %a to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %res
}

define <vscale x 8 x bfloat> @sitofp_nxv8i64_to_nxv8bf16(<vscale x 8 x i64> %a) {
; CHECK-LABEL: sitofp_nxv8i64_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    scvtf z3.s, p0/m, z3.d
; CHECK-NEXT:    scvtf z2.s, p0/m, z2.d
; CHECK-NEXT:    scvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    scvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    bfcvt z3.h, p0/m, z3.s
; CHECK-NEXT:    bfcvt z2.h, p0/m, z2.s
; CHECK-NEXT:    bfcvt z1.h, p0/m, z1.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z3.s
; CHECK-NEXT:    uzp1 z0.s, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z2.h
; CHECK-NEXT:    ret
  %res = sitofp <vscale x 8 x i64> %a to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %res
}

; NOTE: f16(1.875) == bf16(1.0)
define <vscale x 2 x bfloat> @uitofp_nxv2i1_to_nxv2bf16(<vscale x 2 x i1> %a) {
; SVE-LABEL: uitofp_nxv2i1_to_nxv2bf16:
; SVE:       // %bb.0:
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fmov z0.h, p0/m, #1.87500000
; SVE-NEXT:    ret
;
; STREAMING-SVE-LABEL: uitofp_nxv2i1_to_nxv2bf16:
; STREAMING-SVE:       // %bb.0:
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    fmov z0.h, p0/m, #1.87500000
; STREAMING-SVE-NEXT:    ret
  %res = uitofp <vscale x 2 x i1> %a to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 2 x bfloat> @uitofp_nxv2i8_to_nxv2bf16(<vscale x 2 x i8> %a) {
; CHECK-LABEL: uitofp_nxv2i8_to_nxv2bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and z0.d, z0.d, #0xff
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = uitofp <vscale x 2 x i8> %a to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 2 x bfloat> @uitofp_nxv2i16_to_nxv2bf16(<vscale x 2 x i16> %a) {
; CHECK-LABEL: uitofp_nxv2i16_to_nxv2bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and z0.d, z0.d, #0xffff
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = uitofp <vscale x 2 x i16> %a to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 2 x bfloat> @uitofp_nxv2i32_to_nxv2bf16(<vscale x 2 x i32> %a) {
; CHECK-LABEL: uitofp_nxv2i32_to_nxv2bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = uitofp <vscale x 2 x i32> %a to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 2 x bfloat> @uitofp_nxv2i64_to_nxv2bf16(<vscale x 2 x i64> %a) {
; CHECK-LABEL: uitofp_nxv2i64_to_nxv2bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = uitofp <vscale x 2 x i64> %a to <vscale x 2 x bfloat>
  ret <vscale x 2 x bfloat> %res
}

define <vscale x 4 x bfloat> @uitofp_nxv4i1_to_nxv4bf16(<vscale x 4 x i1> %a) {
; SVE-LABEL: uitofp_nxv4i1_to_nxv4bf16:
; SVE:       // %bb.0:
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fmov z0.h, p0/m, #1.87500000
; SVE-NEXT:    ret
;
; STREAMING-SVE-LABEL: uitofp_nxv4i1_to_nxv4bf16:
; STREAMING-SVE:       // %bb.0:
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    fmov z0.h, p0/m, #1.87500000
; STREAMING-SVE-NEXT:    ret
  %res = uitofp <vscale x 4 x i1> %a to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 4 x bfloat> @uitofp_nxv4i8_to_nxv4bf16(<vscale x 4 x i8> %a) {
; CHECK-LABEL: uitofp_nxv4i8_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and z0.s, z0.s, #0xff
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = uitofp <vscale x 4 x i8> %a to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 4 x bfloat> @uitofp_nxv4i16_to_nxv4bf16(<vscale x 4 x i16> %a) {
; CHECK-LABEL: uitofp_nxv4i16_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and z0.s, z0.s, #0xffff
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = uitofp <vscale x 4 x i16> %a to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 4 x bfloat> @uitofp_nxv4i32_to_nxv4bf16(<vscale x 4 x i32> %a) {
; CHECK-LABEL: uitofp_nxv4i32_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    ret
  %res = uitofp <vscale x 4 x i32> %a to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 4 x bfloat> @uitofp_nxv4i64_to_nxv4bf16(<vscale x 4 x i64> %a) {
; CHECK-LABEL: uitofp_nxv4i64_to_nxv4bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    bfcvt z1.h, p0/m, z1.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.s, z0.s, z1.s
; CHECK-NEXT:    ret
  %res = uitofp <vscale x 4 x i64> %a to <vscale x 4 x bfloat>
  ret <vscale x 4 x bfloat> %res
}

define <vscale x 8 x bfloat> @uitofp_nxv8i1_to_nxv8bf16(<vscale x 8 x i1> %a) {
; SVE-LABEL: uitofp_nxv8i1_to_nxv8bf16:
; SVE:       // %bb.0:
; SVE-NEXT:    movi v0.2d, #0000000000000000
; SVE-NEXT:    fmov z0.h, p0/m, #1.87500000
; SVE-NEXT:    ret
;
; STREAMING-SVE-LABEL: uitofp_nxv8i1_to_nxv8bf16:
; STREAMING-SVE:       // %bb.0:
; STREAMING-SVE-NEXT:    mov z0.h, #0 // =0x0
; STREAMING-SVE-NEXT:    fmov z0.h, p0/m, #1.87500000
; STREAMING-SVE-NEXT:    ret
  %res = uitofp <vscale x 8 x i1> %a to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %res
}

define <vscale x 8 x bfloat> @uitofp_nxv8i8_to_nxv8bf16(<vscale x 8 x i8> %a) {
; CHECK-LABEL: uitofp_nxv8i8_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    and z0.h, z0.h, #0xff
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    uunpkhi z1.s, z0.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z1.h, p0/m, z1.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
  %res = uitofp <vscale x 8 x i8> %a to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %res
}

define <vscale x 8 x bfloat> @uitofp_nxv8i16_to_nxv8bf16(<vscale x 8 x i16> %a) {
; CHECK-LABEL: uitofp_nxv8i16_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    uunpkhi z1.s, z0.h
; CHECK-NEXT:    uunpklo z0.s, z0.h
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z1.h, p0/m, z1.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
  %res = uitofp <vscale x 8 x i16> %a to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %res
}

define <vscale x 8 x bfloat> @uitofp_nxv8i32_to_nxv8bf16(<vscale x 8 x i32> %a) {
; CHECK-LABEL: uitofp_nxv8i32_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.s
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.s
; CHECK-NEXT:    bfcvt z1.h, p0/m, z1.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
  %res = uitofp <vscale x 8 x i32> %a to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %res
}

define <vscale x 8 x bfloat> @uitofp_nxv8i64_to_nxv8bf16(<vscale x 8 x i64> %a) {
; CHECK-LABEL: uitofp_nxv8i64_to_nxv8bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d
; CHECK-NEXT:    ucvtf z3.s, p0/m, z3.d
; CHECK-NEXT:    ucvtf z2.s, p0/m, z2.d
; CHECK-NEXT:    ucvtf z1.s, p0/m, z1.d
; CHECK-NEXT:    ucvtf z0.s, p0/m, z0.d
; CHECK-NEXT:    bfcvt z3.h, p0/m, z3.s
; CHECK-NEXT:    bfcvt z2.h, p0/m, z2.s
; CHECK-NEXT:    bfcvt z1.h, p0/m, z1.s
; CHECK-NEXT:    bfcvt z0.h, p0/m, z0.s
; CHECK-NEXT:    uzp1 z2.s, z2.s, z3.s
; CHECK-NEXT:    uzp1 z0.s, z0.s, z1.s
; CHECK-NEXT:    uzp1 z0.h, z0.h, z2.h
; CHECK-NEXT:    ret
  %res = uitofp <vscale x 8 x i64> %a to <vscale x 8 x bfloat>
  ret <vscale x 8 x bfloat> %res
}
