; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=aarch64-linux-gnu < %s | FileCheck %s

;
; SMULH
;

define <vscale x 16 x i8> @smulh_i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b) #0 {
; CHECK-LABEL: smulh_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smulh z0.b, z0.b, z1.b
; CHECK-NEXT:    ret
  %1 = sext <vscale x 16 x i8> %a to <vscale x 16 x i16>
  %2 = sext <vscale x 16 x i8> %b to <vscale x 16 x i16>
  %mul = mul <vscale x 16 x i16> %1, %2
  %shr = lshr <vscale x 16 x i16> %mul, splat(i16 8)
  %tr = trunc <vscale x 16 x i16> %shr to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %tr
}

define <vscale x 8 x i16> @smulh_i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b) #0 {
; CHECK-LABEL: smulh_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smulh z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
  %1 = sext <vscale x 8 x i16> %a to <vscale x 8 x i32>
  %2 = sext <vscale x 8 x i16> %b to <vscale x 8 x i32>
  %mul = mul <vscale x 8 x i32> %1, %2
  %shr = lshr <vscale x 8 x i32> %mul, splat(i32 16)
  %tr = trunc <vscale x 8 x i32> %shr to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %tr
}

define <vscale x 4 x i32> @smulh_i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b) #0 {
; CHECK-LABEL: smulh_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smulh z0.s, z0.s, z1.s
; CHECK-NEXT:    ret
  %1 = sext <vscale x 4 x i32> %a to <vscale x 4 x i64>
  %2 = sext <vscale x 4 x i32> %b to <vscale x 4 x i64>
  %mul = mul <vscale x 4 x i64> %1, %2
  %shr = lshr <vscale x 4 x i64> %mul, splat(i64 32)
  %tr = trunc <vscale x 4 x i64> %shr to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %tr
}

define <vscale x 2 x i64> @smulh_i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b) #0 {
; CHECK-LABEL: smulh_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    smulh z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
  %1 = sext <vscale x 2 x i64> %a to <vscale x 2 x i128>
  %2 = sext <vscale x 2 x i64> %b to <vscale x 2 x i128>
  %mul = mul <vscale x 2 x i128> %1, %2
  %shr = lshr <vscale x 2 x i128> %mul, splat(i128 64)
  %tr = trunc <vscale x 2 x i128> %shr to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %tr
}

;
; UMULH
;

define <vscale x 16 x i8> @umulh_i8(<vscale x 16 x i8> %a, <vscale x 16 x i8> %b) #0 {
; CHECK-LABEL: umulh_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umulh z0.b, z0.b, z1.b
; CHECK-NEXT:    ret
  %1 = zext <vscale x 16 x i8> %a to <vscale x 16 x i16>
  %2 = zext <vscale x 16 x i8> %b to <vscale x 16 x i16>
  %mul = mul <vscale x 16 x i16> %1, %2
  %shr = lshr <vscale x 16 x i16> %mul, splat(i16 8)
  %tr = trunc <vscale x 16 x i16> %shr to <vscale x 16 x i8>
  ret <vscale x 16 x i8> %tr
}

define <vscale x 8 x i16> @umulh_i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b) #0 {
; CHECK-LABEL: umulh_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umulh z0.h, z0.h, z1.h
; CHECK-NEXT:    ret
  %1 = zext <vscale x 8 x i16> %a to <vscale x 8 x i32>
  %2 = zext <vscale x 8 x i16> %b to <vscale x 8 x i32>
  %mul = mul <vscale x 8 x i32> %1, %2
  %shr = lshr <vscale x 8 x i32> %mul, splat(i32 16)
  %tr = trunc <vscale x 8 x i32> %shr to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %tr
}

define <vscale x 4 x i32> @umulh_i32(<vscale x 4 x i32> %a, <vscale x 4 x i32> %b) #0 {
; CHECK-LABEL: umulh_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umulh z0.s, z0.s, z1.s
; CHECK-NEXT:    ret
  %1 = zext <vscale x 4 x i32> %a to <vscale x 4 x i64>
  %2 = zext <vscale x 4 x i32> %b to <vscale x 4 x i64>
  %mul = mul <vscale x 4 x i64> %1, %2
  %shr = lshr <vscale x 4 x i64> %mul, splat(i64 32)
  %tr = trunc <vscale x 4 x i64> %shr to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %tr
}

define <vscale x 2 x i64> @umulh_i64(<vscale x 2 x i64> %a, <vscale x 2 x i64> %b) #0 {
; CHECK-LABEL: umulh_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    umulh z0.d, z0.d, z1.d
; CHECK-NEXT:    ret
  %1 = zext <vscale x 2 x i64> %a to <vscale x 2 x i128>
  %2 = zext <vscale x 2 x i64> %b to <vscale x 2 x i128>
  %mul = mul <vscale x 2 x i128> %1, %2
  %shr = lshr <vscale x 2 x i128> %mul, splat(i128 64)
  %tr = trunc <vscale x 2 x i128> %shr to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %tr
}

attributes #0 = { "target-features"="+sve2" }
