; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 3
; RUN: llc -global-isel -mtriple=amdgcn-amd-amdpal -mcpu=gfx1010 -new-reg-bank-select -verify-machineinstrs < %s | FileCheck -check-prefix=GFX10 %s

define void @temporal_divergent_i1_phi(float %val, ptr %addr) {
; GFX10-LABEL: temporal_divergent_i1_phi:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    s_mov_b32 s5, 1
; GFX10-NEXT:    s_mov_b32 s6, 0
; GFX10-NEXT:    ; implicit-def: $sgpr7
; GFX10-NEXT:  .LBB0_1: ; %loop
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    v_cvt_f32_u32_e32 v3, s6
; GFX10-NEXT:    s_and_b32 s8, s5, 1
; GFX10-NEXT:    s_cmp_lg_u32 s8, 0
; GFX10-NEXT:    s_cselect_b32 s8, exec_lo, 0
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v0
; GFX10-NEXT:    s_xor_b32 s5, s5, 1
; GFX10-NEXT:    s_add_i32 s6, s6, 1
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 s7, s7, exec_lo
; GFX10-NEXT:    s_and_b32 s8, exec_lo, s8
; GFX10-NEXT:    s_or_b32 s7, s7, s8
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB0_1
; GFX10-NEXT:  ; %bb.2: ; %exit
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1.0, s7
; GFX10-NEXT:    flat_store_dword v[1:2], v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  br label %loop

loop:
  %counter = phi i32 [ 0, %entry ], [ %counterPlus1, %loop ]
  %bool_counter = phi i1 [ true, %entry ], [ %neg_bool_counter, %loop ]
  %neg_bool_counter = xor i1 %bool_counter, true
  %fcounter = uitofp i32 %counter to float
  %cond = fcmp ogt float %fcounter, %val
  %counterPlus1 = add i32 %counter, 1
  br i1 %cond, label %exit, label %loop

exit:
  %select = select i1 %bool_counter, float 1.000000e+00, float 0.000000e+00
  store float %select, ptr %addr
  ret void
}

define void @temporal_divergent_i1_non_phi(float %val, ptr %addr) {
; GFX10-LABEL: temporal_divergent_i1_non_phi:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    s_mov_b32 s5, 1
; GFX10-NEXT:    s_mov_b32 s6, 0
; GFX10-NEXT:    ; implicit-def: $sgpr7
; GFX10-NEXT:  .LBB1_1: ; %loop
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    v_cvt_f32_u32_e32 v3, s6
; GFX10-NEXT:    s_xor_b32 s5, s5, 1
; GFX10-NEXT:    s_and_b32 s8, s5, 1
; GFX10-NEXT:    s_cmp_lg_u32 s8, 0
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v0
; GFX10-NEXT:    s_cselect_b32 s8, exec_lo, 0
; GFX10-NEXT:    s_add_i32 s6, s6, 1
; GFX10-NEXT:    s_or_b32 s4, vcc_lo, s4
; GFX10-NEXT:    s_andn2_b32 s7, s7, exec_lo
; GFX10-NEXT:    s_and_b32 s8, exec_lo, s8
; GFX10-NEXT:    s_or_b32 s7, s7, s8
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    s_cbranch_execnz .LBB1_1
; GFX10-NEXT:  ; %bb.2: ; %exit
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1.0, s7
; GFX10-NEXT:    flat_store_dword v[1:2], v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  br label %loop

loop:
  %counter = phi i32 [ 0, %entry ], [ %counterPlus1, %loop ]
  %bool_counter = phi i1 [ true, %entry ], [ %neg_bool_counter, %loop ]
  %neg_bool_counter = xor i1 %bool_counter, true
  %fcounter = uitofp i32 %counter to float
  %cond = fcmp ogt float %fcounter, %val
  %counterPlus1 = add i32 %counter, 1
  br i1 %cond, label %exit, label %loop

exit:
  %select = select i1 %neg_bool_counter, float 1.000000e+00, float 0.000000e+00
  store float %select, ptr %addr
  ret void
}

; This is temporal divergent uniform i1 structurize-cfg phi.
; Loop has uniform condition if with body with break at the end.
define amdgpu_cs void @loop_with_1break(ptr addrspace(1) %x, i32 %x.size, ptr addrspace(1) inreg %a, ptr addrspace(1) inreg %a.break) {
; GFX10-LABEL: loop_with_1break:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    v_mov_b32_e32 v3, 0
; GFX10-NEXT:    s_mov_b32 s8, 0
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    ; implicit-def: $sgpr10
; GFX10-NEXT:    ; implicit-def: $sgpr9
; GFX10-NEXT:    s_branch .LBB2_3
; GFX10-NEXT:  .LBB2_1: ; %loop.body
; GFX10-NEXT:    ; in Loop: Header=BB2_3 Depth=1
; GFX10-NEXT:    v_mov_b32_e32 v4, s6
; GFX10-NEXT:    v_mov_b32_e32 v5, s7
; GFX10-NEXT:    s_andn2_b32 s6, s10, exec_lo
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    v_add_co_u32 v4, vcc_lo, v0, v4
; GFX10-NEXT:    v_add_co_ci_u32_e32 v5, vcc_lo, v1, v5, vcc_lo
; GFX10-NEXT:    v_cmp_lt_u32_e32 vcc_lo, s4, v2
; GFX10-NEXT:    s_add_i32 s4, s4, 1
; GFX10-NEXT:    global_load_dword v6, v[4:5], off
; GFX10-NEXT:    s_and_b32 s7, exec_lo, vcc_lo
; GFX10-NEXT:    s_or_b32 s10, s6, s7
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_add_nc_u32_e32 v6, 1, v6
; GFX10-NEXT:    global_store_dword v[4:5], v6, off
; GFX10-NEXT:  .LBB2_2: ; %Flow
; GFX10-NEXT:    ; in Loop: Header=BB2_3 Depth=1
; GFX10-NEXT:    s_cmp_lg_u32 s5, 0
; GFX10-NEXT:    s_cselect_b32 s5, exec_lo, 0
; GFX10-NEXT:    s_and_b32 s6, exec_lo, s10
; GFX10-NEXT:    s_or_b32 s8, s6, s8
; GFX10-NEXT:    s_andn2_b32 s6, s9, exec_lo
; GFX10-NEXT:    s_and_b32 s5, exec_lo, s5
; GFX10-NEXT:    s_or_b32 s9, s6, s5
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s8
; GFX10-NEXT:    s_cbranch_execz .LBB2_5
; GFX10-NEXT:  .LBB2_3: ; %A
; GFX10-NEXT:    ; =>This Inner Loop Header: Depth=1
; GFX10-NEXT:    s_ashr_i32 s5, s4, 31
; GFX10-NEXT:    s_lshl_b64 s[6:7], s[4:5], 2
; GFX10-NEXT:    s_add_u32 s12, s0, s6
; GFX10-NEXT:    s_addc_u32 s13, s1, s7
; GFX10-NEXT:    global_load_dword v4, v3, s[12:13]
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_readfirstlane_b32 s5, v4
; GFX10-NEXT:    s_cmp_lg_u32 s5, 0
; GFX10-NEXT:    s_cselect_b32 s5, 1, 0
; GFX10-NEXT:    s_andn2_b32 s10, s10, exec_lo
; GFX10-NEXT:    s_and_b32 s11, exec_lo, exec_lo
; GFX10-NEXT:    s_or_b32 s10, s10, s11
; GFX10-NEXT:    s_cmp_lg_u32 s5, 0
; GFX10-NEXT:    s_cbranch_scc1 .LBB2_1
; GFX10-NEXT:  ; %bb.4: ; in Loop: Header=BB2_3 Depth=1
; GFX10-NEXT:    s_mov_b32 s5, 1
; GFX10-NEXT:    ; implicit-def: $sgpr4
; GFX10-NEXT:    s_branch .LBB2_2
; GFX10-NEXT:  .LBB2_5: ; %loop.exit.guard
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s8
; GFX10-NEXT:    s_and_saveexec_b32 s0, s9
; GFX10-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX10-NEXT:    s_cbranch_execz .LBB2_7
; GFX10-NEXT:  ; %bb.6: ; %break.body
; GFX10-NEXT:    v_mov_b32_e32 v0, 10
; GFX10-NEXT:    v_mov_b32_e32 v1, 0
; GFX10-NEXT:    global_store_dword v1, v0, s[2:3]
; GFX10-NEXT:  .LBB2_7: ; %exit
; GFX10-NEXT:    s_endpgm
entry:
  br label %A

A:
  %counter = phi i32 [ %counter.plus.1, %loop.body ], [ 0, %entry ]
  %a.plus.counter = getelementptr inbounds i32, ptr addrspace(1) %a, i32 %counter
  %a.val = load i32, ptr addrspace(1) %a.plus.counter
  %a.cond = icmp eq i32 %a.val, 0
  br i1 %a.cond, label %break.body, label %loop.body

break.body:
  store i32 10, ptr addrspace(1) %a.break
  br label %exit

loop.body:
  %x.plus.counter = getelementptr inbounds i32, ptr addrspace(1) %x, i32 %counter
  %x.val = load i32, ptr addrspace(1) %x.plus.counter
  %x.val.plus.1 = add i32 %x.val, 1
  store i32 %x.val.plus.1, ptr addrspace(1) %x.plus.counter
  %counter.plus.1 = add i32 %counter, 1
  %x.cond = icmp ult i32 %counter, %x.size
  br i1 %x.cond, label %exit, label %A

exit:
  ret void
}

; Temporal divergence i1 across inner and outer nested loops
define void @nested_loops_temporal_divergence_inner(float %pre.cond.val, i32 %n.i, ptr %mat, ptr %mat.oe, ptr %arr) {
; GFX10-LABEL: nested_loops_temporal_divergence_inner:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_lt_f32_e64 s8, 1.0, v0
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    s_mov_b32 s6, 0
; GFX10-NEXT:  .LBB3_1: ; %OuterHeader
; GFX10-NEXT:    ; =>This Loop Header: Depth=1
; GFX10-NEXT:    ; Child Loop BB3_2 Depth 2
; GFX10-NEXT:    s_ashr_i32 s7, s6, 31
; GFX10-NEXT:    s_mov_b32 s4, s8
; GFX10-NEXT:    s_lshl_b64 s[10:11], s[6:7], 2
; GFX10-NEXT:    ; implicit-def: $sgpr9
; GFX10-NEXT:    v_mov_b32_e32 v6, s10
; GFX10-NEXT:    v_mov_b32_e32 v7, s11
; GFX10-NEXT:    s_mov_b32 s10, 0
; GFX10-NEXT:    s_mov_b32 s11, 0
; GFX10-NEXT:    v_add_co_u32 v6, vcc_lo, v2, v6
; GFX10-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, v3, v7, vcc_lo
; GFX10-NEXT:    flat_load_dword v0, v[6:7]
; GFX10-NEXT:  .LBB3_2: ; %InnerHeader
; GFX10-NEXT:    ; Parent Loop BB3_1 Depth=1
; GFX10-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX10-NEXT:    v_cvt_f32_u32_e32 v6, s11
; GFX10-NEXT:    s_mov_b32 s12, exec_lo
; GFX10-NEXT:    s_add_i32 s11, s11, 1
; GFX10-NEXT:    s_xor_b32 s4, s4, s12
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v0
; GFX10-NEXT:    s_or_b32 s10, vcc_lo, s10
; GFX10-NEXT:    s_andn2_b32 s9, s9, exec_lo
; GFX10-NEXT:    s_and_b32 s12, exec_lo, s4
; GFX10-NEXT:    s_or_b32 s9, s9, s12
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s10
; GFX10-NEXT:    s_cbranch_execnz .LBB3_2
; GFX10-NEXT:  ; %bb.3: ; %UseInst
; GFX10-NEXT:    ; in Loop: Header=BB3_1 Depth=1
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s10
; GFX10-NEXT:    v_mov_b32_e32 v6, s6
; GFX10-NEXT:    v_mov_b32_e32 v7, s7
; GFX10-NEXT:    v_cmp_lt_u32_e32 vcc_lo, s6, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s9
; GFX10-NEXT:    s_add_i32 s6, s6, 1
; GFX10-NEXT:    v_add_co_u32 v6, s4, v4, v6
; GFX10-NEXT:    v_add_co_ci_u32_e64 v7, s4, v5, v7, s4
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    flat_store_byte v[6:7], v0
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB3_1
; GFX10-NEXT:  ; %bb.4: ; %exit
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  %pre.cond = fcmp ogt float %pre.cond.val, 1.0
  br label %OuterHeader

OuterHeader:
  %i = phi i32 [ 0, %entry ], [ %i.plus.1, %OuterLatch ]
  %mat.i = getelementptr float, ptr %mat, i32 %i
  %val.i = load float, ptr %mat.i
  br label %InnerHeader

InnerHeader:
  %j = phi i32 [ 0, %OuterHeader ], [ %j.plus.1, %InnerHeader ]
  %bool.counter = phi i1 [ %pre.cond, %OuterHeader ], [ %odd.even.counter, %InnerHeader ]

  %odd.even.counter = xor i1 %bool.counter, true

  %f.j = uitofp i32 %j to float
  %j.plus.1 = add i32 %j, 1
  %cond.j = fcmp ogt float %f.j, %val.i
  br i1 %cond.j, label %UseInst, label %InnerHeader

UseInst:
  %mat.oe.i = getelementptr i1, ptr %mat.oe, i32 %i
  ; mat.oe[i] = oddOReven(mat[i])
  store i1 %odd.even.counter, ptr %mat.oe.i
  br label %OuterLatch

OuterLatch:
  %cond.i = icmp ult i32 %i, %n.i
  %i.plus.1 = add i32 %i, 1
  br i1 %cond.i, label %exit, label %OuterHeader

exit:
  ret void
}

define void @nested_loops_temporal_divergence_outer(float %pre.cond.val, i32 %n.i, ptr %mat, ptr %mat.oe, ptr %arr) {
; GFX10-LABEL: nested_loops_temporal_divergence_outer:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_lt_f32_e64 s8, 1.0, v0
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    s_mov_b32 s6, 0
; GFX10-NEXT:  .LBB4_1: ; %OuterHeader
; GFX10-NEXT:    ; =>This Loop Header: Depth=1
; GFX10-NEXT:    ; Child Loop BB4_2 Depth 2
; GFX10-NEXT:    s_ashr_i32 s7, s6, 31
; GFX10-NEXT:    s_mov_b32 s4, s8
; GFX10-NEXT:    s_lshl_b64 s[10:11], s[6:7], 2
; GFX10-NEXT:    ; implicit-def: $sgpr9
; GFX10-NEXT:    v_mov_b32_e32 v6, s10
; GFX10-NEXT:    v_mov_b32_e32 v7, s11
; GFX10-NEXT:    s_mov_b32 s10, 0
; GFX10-NEXT:    s_mov_b32 s11, 0
; GFX10-NEXT:    v_add_co_u32 v6, vcc_lo, v2, v6
; GFX10-NEXT:    v_add_co_ci_u32_e32 v7, vcc_lo, v3, v7, vcc_lo
; GFX10-NEXT:    flat_load_dword v0, v[6:7]
; GFX10-NEXT:  .LBB4_2: ; %InnerHeader
; GFX10-NEXT:    ; Parent Loop BB4_1 Depth=1
; GFX10-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX10-NEXT:    v_cvt_f32_u32_e32 v6, s11
; GFX10-NEXT:    s_mov_b32 s12, exec_lo
; GFX10-NEXT:    s_add_i32 s11, s11, 1
; GFX10-NEXT:    s_xor_b32 s4, s4, s12
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v0
; GFX10-NEXT:    s_or_b32 s10, vcc_lo, s10
; GFX10-NEXT:    s_andn2_b32 s9, s9, exec_lo
; GFX10-NEXT:    s_and_b32 s12, exec_lo, s4
; GFX10-NEXT:    s_or_b32 s9, s9, s12
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s10
; GFX10-NEXT:    s_cbranch_execnz .LBB4_2
; GFX10-NEXT:  ; %bb.3: ; %UseInst
; GFX10-NEXT:    ; in Loop: Header=BB4_1 Depth=1
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s10
; GFX10-NEXT:    v_mov_b32_e32 v6, s6
; GFX10-NEXT:    v_mov_b32_e32 v7, s7
; GFX10-NEXT:    v_cmp_lt_u32_e32 vcc_lo, s6, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s9
; GFX10-NEXT:    s_add_i32 s6, s6, 1
; GFX10-NEXT:    v_add_co_u32 v6, s4, v4, v6
; GFX10-NEXT:    v_add_co_ci_u32_e64 v7, s4, v5, v7, s4
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    flat_store_byte v[6:7], v0
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB4_1
; GFX10-NEXT:  ; %bb.4: ; %exit
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  %pre.cond = fcmp ogt float %pre.cond.val, 1.0
  br label %OuterHeader

OuterHeader:
  %i = phi i32 [ 0, %entry ], [ %i.plus.1, %OuterLatch ]
  %mat.i = getelementptr float, ptr %mat, i32 %i
  %val.i = load float, ptr %mat.i
  br label %InnerHeader

InnerHeader:
  %j = phi i32 [ 0, %OuterHeader ], [ %j.plus.1, %InnerHeader ]
  %bool.counter = phi i1 [ %pre.cond, %OuterHeader ], [ %odd.even.counter, %InnerHeader ]

  %odd.even.counter = xor i1 %bool.counter, true

  %f.j = uitofp i32 %j to float
  %j.plus.1 = add i32 %j, 1
  %cond.j = fcmp ogt float %f.j, %val.i
  br i1 %cond.j, label %UseInst, label %InnerHeader

UseInst:
  %mat.oe.i = getelementptr i1, ptr %mat.oe, i32 %i
  ; mat.oe[i] = oddOReven(mat[i])
  store i1 %odd.even.counter, ptr %mat.oe.i
  br label %OuterLatch

OuterLatch:
  %cond.i = icmp ult i32 %i, %n.i
  %i.plus.1 = add i32 %i, 1
  br i1 %cond.i, label %exit, label %OuterHeader

exit:
  ret void
}

define void @nested_loops_temporal_divergence_both(float %pre.cond.val, i32 %n.i, ptr %mat, ptr %mat.oe, ptr %arr) {
; GFX10-LABEL: nested_loops_temporal_divergence_both:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_lt_f32_e64 s8, 1.0, v0
; GFX10-NEXT:    s_mov_b32 s5, 0
; GFX10-NEXT:    s_mov_b32 s6, 0
; GFX10-NEXT:    ; implicit-def: $sgpr9
; GFX10-NEXT:  .LBB5_1: ; %OuterHeader
; GFX10-NEXT:    ; =>This Loop Header: Depth=1
; GFX10-NEXT:    ; Child Loop BB5_2 Depth 2
; GFX10-NEXT:    s_ashr_i32 s7, s6, 31
; GFX10-NEXT:    s_mov_b32 s4, s8
; GFX10-NEXT:    s_lshl_b64 s[10:11], s[6:7], 2
; GFX10-NEXT:    v_mov_b32_e32 v8, s10
; GFX10-NEXT:    v_mov_b32_e32 v9, s11
; GFX10-NEXT:    s_mov_b32 s10, 0
; GFX10-NEXT:    s_mov_b32 s11, 0
; GFX10-NEXT:    v_add_co_u32 v8, vcc_lo, v2, v8
; GFX10-NEXT:    v_add_co_ci_u32_e32 v9, vcc_lo, v3, v9, vcc_lo
; GFX10-NEXT:    flat_load_dword v0, v[8:9]
; GFX10-NEXT:  .LBB5_2: ; %InnerHeader
; GFX10-NEXT:    ; Parent Loop BB5_1 Depth=1
; GFX10-NEXT:    ; => This Inner Loop Header: Depth=2
; GFX10-NEXT:    v_cvt_f32_u32_e32 v8, s11
; GFX10-NEXT:    s_mov_b32 s12, exec_lo
; GFX10-NEXT:    s_add_i32 s11, s11, 1
; GFX10-NEXT:    s_xor_b32 s4, s4, s12
; GFX10-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v8, v0
; GFX10-NEXT:    s_or_b32 s10, vcc_lo, s10
; GFX10-NEXT:    s_andn2_b32 s9, s9, exec_lo
; GFX10-NEXT:    s_and_b32 s12, exec_lo, s4
; GFX10-NEXT:    s_or_b32 s9, s9, s12
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s10
; GFX10-NEXT:    s_cbranch_execnz .LBB5_2
; GFX10-NEXT:  ; %bb.3: ; %UseInst
; GFX10-NEXT:    ; in Loop: Header=BB5_1 Depth=1
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s10
; GFX10-NEXT:    v_mov_b32_e32 v9, s7
; GFX10-NEXT:    v_mov_b32_e32 v8, s6
; GFX10-NEXT:    v_cmp_lt_u32_e32 vcc_lo, s6, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s9
; GFX10-NEXT:    s_add_i32 s6, s6, 1
; GFX10-NEXT:    v_add_co_u32 v8, s4, v4, v8
; GFX10-NEXT:    v_add_co_ci_u32_e64 v9, s4, v5, v9, s4
; GFX10-NEXT:    s_or_b32 s5, vcc_lo, s5
; GFX10-NEXT:    flat_store_byte v[8:9], v0
; GFX10-NEXT:    s_waitcnt_depctr 0xffe3
; GFX10-NEXT:    s_andn2_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    s_cbranch_execnz .LBB5_1
; GFX10-NEXT:  ; %bb.4: ; %exit
; GFX10-NEXT:    s_or_b32 exec_lo, exec_lo, s5
; GFX10-NEXT:    flat_store_byte v[6:7], v0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
entry:
  %pre.cond = fcmp ogt float %pre.cond.val, 1.0
  br label %OuterHeader

OuterHeader:
  %i = phi i32 [ 0, %entry ], [ %i.plus.1, %OuterLatch ]
  %mat.i = getelementptr float, ptr %mat, i32 %i
  %val.i = load float, ptr %mat.i
  br label %InnerHeader

InnerHeader:
  %j = phi i32 [ 0, %OuterHeader ], [ %j.plus.1, %InnerHeader ]
  %bool.counter = phi i1 [ %pre.cond, %OuterHeader ], [ %odd.even.counter, %InnerHeader ]

  %odd.even.counter = xor i1 %bool.counter, true

  %f.j = uitofp i32 %j to float
  %j.plus.1 = add i32 %j, 1
  %cond.j = fcmp ogt float %f.j, %val.i
  br i1 %cond.j, label %UseInst, label %InnerHeader

UseInst:
  %mat.oe.i = getelementptr i1, ptr %mat.oe, i32 %i
  ; mat.oe[i] = oddOReven(mat[i])
  store i1 %odd.even.counter, ptr %mat.oe.i
  br label %OuterLatch

OuterLatch:
  %cond.i = icmp ult i32 %i, %n.i
  %i.plus.1 = add i32 %i, 1
  br i1 %cond.i, label %exit, label %OuterHeader

exit:
  ; arr = oddOReven(mat[n.i - 1])
  store i1 %odd.even.counter, ptr %arr
  ret void
}
