; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5

; RUN: llc -mtriple=amdgcn -mcpu=tahiti < %s | FileCheck -check-prefix=SI %s
; RUN: llc -mtriple=amdgcn -mcpu=tonga < %s | FileCheck -check-prefix=VI %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-FAKE16 %s

define <20 x float> @bitcast_v20i32_to_v20f32(<20 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v20i32_to_v20f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB0_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB0_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v20i32_to_v20f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB0_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB0_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v20i32_to_v20f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB0_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB0_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v20i32_to_v20f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB0_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB0_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <20 x i32> %a, splat (i32 3)
  %a2 = bitcast <20 x i32> %a1 to <20 x float>
  br label %end

cmp.false:
  %a3 = bitcast <20 x i32> %a to <20 x float>
  br label %end

end:
  %phi = phi <20 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x float> %phi
}

define inreg <20 x float> @bitcast_v20i32_to_v20f32_scalar(<20 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v20i32_to_v20f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v6
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB1_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB1_3
; SI-NEXT:  .LBB1_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB1_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB1_4:
; SI-NEXT:    s_branch .LBB1_2
;
; VI-LABEL: bitcast_v20i32_to_v20f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v6
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB1_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB1_3
; VI-NEXT:  .LBB1_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB1_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB1_4:
; VI-NEXT:    s_branch .LBB1_2
;
; GFX9-LABEL: bitcast_v20i32_to_v20f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB1_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB1_3
; GFX9-NEXT:  .LBB1_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB1_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB1_4:
; GFX9-NEXT:    s_branch .LBB1_2
;
; GFX11-LABEL: bitcast_v20i32_to_v20f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB1_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB1_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB1_3:
; GFX11-NEXT:  .LBB1_4: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <20 x i32> %a, splat (i32 3)
  %a2 = bitcast <20 x i32> %a1 to <20 x float>
  br label %end

cmp.false:
  %a3 = bitcast <20 x i32> %a to <20 x float>
  br label %end

end:
  %phi = phi <20 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x float> %phi
}

define <20 x i32> @bitcast_v20f32_to_v20i32(<20 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v20f32_to_v20i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB2_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB2_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v20f32_to_v20i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB2_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB2_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v20f32_to_v20i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB2_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB2_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v20f32_to_v20i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB2_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  .LBB2_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <20 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <20 x float> %a1 to <20 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <20 x float> %a to <20 x i32>
  br label %end

end:
  %phi = phi <20 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x i32> %phi
}

define inreg <20 x i32> @bitcast_v20f32_to_v20i32_scalar(<20 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v20f32_to_v20i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v6
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB3_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB3_3
; SI-NEXT:  .LBB3_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB3_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB3_4:
; SI-NEXT:    s_branch .LBB3_2
;
; VI-LABEL: bitcast_v20f32_to_v20i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v6
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB3_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB3_3
; VI-NEXT:  .LBB3_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB3_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB3_4:
; VI-NEXT:    s_branch .LBB3_2
;
; GFX9-LABEL: bitcast_v20f32_to_v20i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB3_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB3_3
; GFX9-NEXT:  .LBB3_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB3_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB3_4:
; GFX9-NEXT:    s_branch .LBB3_2
;
; GFX11-LABEL: bitcast_v20f32_to_v20i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB3_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB3_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB3_3:
; GFX11-NEXT:  .LBB3_4: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <20 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <20 x float> %a1 to <20 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <20 x float> %a to <20 x i32>
  br label %end

end:
  %phi = phi <20 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x i32> %phi
}

define <10 x i64> @bitcast_v20i32_to_v10i64(<20 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v20i32_to_v10i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB4_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB4_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v20i32_to_v10i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB4_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB4_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v20i32_to_v10i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB4_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB4_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v20i32_to_v10i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB4_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB4_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <20 x i32> %a, splat (i32 3)
  %a2 = bitcast <20 x i32> %a1 to <10 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <20 x i32> %a to <10 x i64>
  br label %end

end:
  %phi = phi <10 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x i64> %phi
}

define inreg <10 x i64> @bitcast_v20i32_to_v10i64_scalar(<20 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v20i32_to_v10i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v6
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB5_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB5_3
; SI-NEXT:  .LBB5_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB5_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB5_4:
; SI-NEXT:    s_branch .LBB5_2
;
; VI-LABEL: bitcast_v20i32_to_v10i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v6
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB5_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB5_3
; VI-NEXT:  .LBB5_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB5_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB5_4:
; VI-NEXT:    s_branch .LBB5_2
;
; GFX9-LABEL: bitcast_v20i32_to_v10i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB5_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB5_3
; GFX9-NEXT:  .LBB5_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB5_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB5_4:
; GFX9-NEXT:    s_branch .LBB5_2
;
; GFX11-LABEL: bitcast_v20i32_to_v10i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB5_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB5_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB5_3:
; GFX11-NEXT:  .LBB5_4: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <20 x i32> %a, splat (i32 3)
  %a2 = bitcast <20 x i32> %a1 to <10 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <20 x i32> %a to <10 x i64>
  br label %end

end:
  %phi = phi <10 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x i64> %phi
}

define <20 x i32> @bitcast_v10i64_to_v20i32(<10 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v10i64_to_v20i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB6_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB6_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v10i64_to_v20i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB6_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB6_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v10i64_to_v20i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB6_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 3, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB6_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v10i64_to_v20i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB6_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  .LBB6_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <10 x i64> %a, splat (i64 3)
  %a2 = bitcast <10 x i64> %a1 to <20 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <10 x i64> %a to <20 x i32>
  br label %end

end:
  %phi = phi <20 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x i32> %phi
}

define inreg <20 x i32> @bitcast_v10i64_to_v20i32_scalar(<10 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v10i64_to_v20i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v6
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB7_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB7_3
; SI-NEXT:  .LBB7_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB7_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB7_4:
; SI-NEXT:    s_branch .LBB7_2
;
; VI-LABEL: bitcast_v10i64_to_v20i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v6
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB7_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB7_3
; VI-NEXT:  .LBB7_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB7_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB7_4:
; VI-NEXT:    s_branch .LBB7_2
;
; GFX9-LABEL: bitcast_v10i64_to_v20i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB7_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB7_3
; GFX9-NEXT:  .LBB7_2: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 3, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB7_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB7_4:
; GFX9-NEXT:    s_branch .LBB7_2
;
; GFX11-LABEL: bitcast_v10i64_to_v20i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB7_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB7_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB7_3:
; GFX11-NEXT:  .LBB7_4: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <10 x i64> %a, splat (i64 3)
  %a2 = bitcast <10 x i64> %a1 to <20 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <10 x i64> %a to <20 x i32>
  br label %end

end:
  %phi = phi <20 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x i32> %phi
}

define <10 x double> @bitcast_v20i32_to_v10f64(<20 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v20i32_to_v10f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB8_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB8_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v20i32_to_v10f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB8_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB8_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v20i32_to_v10f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB8_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB8_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v20i32_to_v10f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB8_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:  .LBB8_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <20 x i32> %a, splat (i32 3)
  %a2 = bitcast <20 x i32> %a1 to <10 x double>
  br label %end

cmp.false:
  %a3 = bitcast <20 x i32> %a to <10 x double>
  br label %end

end:
  %phi = phi <10 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x double> %phi
}

define inreg <10 x double> @bitcast_v20i32_to_v10f64_scalar(<20 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v20i32_to_v10f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v6
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB9_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB9_3
; SI-NEXT:  .LBB9_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:  .LBB9_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB9_4:
; SI-NEXT:    s_branch .LBB9_2
;
; VI-LABEL: bitcast_v20i32_to_v10f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v6
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB9_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB9_3
; VI-NEXT:  .LBB9_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:  .LBB9_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB9_4:
; VI-NEXT:    s_branch .LBB9_2
;
; GFX9-LABEL: bitcast_v20i32_to_v10f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB9_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB9_3
; GFX9-NEXT:  .LBB9_2: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:  .LBB9_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB9_4:
; GFX9-NEXT:    s_branch .LBB9_2
;
; GFX11-LABEL: bitcast_v20i32_to_v10f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB9_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB9_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB9_3:
; GFX11-NEXT:  .LBB9_4: ; %cmp.true
; GFX11-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <20 x i32> %a, splat (i32 3)
  %a2 = bitcast <20 x i32> %a1 to <10 x double>
  br label %end

cmp.false:
  %a3 = bitcast <20 x i32> %a to <10 x double>
  br label %end

end:
  %phi = phi <10 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x double> %phi
}

define <20 x i32> @bitcast_v10f64_to_v20i32(<10 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v10f64_to_v20i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB10_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB10_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v10f64_to_v20i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB10_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; VI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB10_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v10f64_to_v20i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB10_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB10_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v10f64_to_v20i32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB10_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX11-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB10_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <10 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <10 x double> %a1 to <20 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <10 x double> %a to <20 x i32>
  br label %end

end:
  %phi = phi <20 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x i32> %phi
}

define inreg <20 x i32> @bitcast_v10f64_to_v20i32_scalar(<10 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v10f64_to_v20i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v12, v6
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB11_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB11_3
; SI-NEXT:  .LBB11_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB11_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB11_4:
; SI-NEXT:    s_branch .LBB11_2
;
; VI-LABEL: bitcast_v10f64_to_v20i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v12, v6
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB11_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB11_3
; VI-NEXT:  .LBB11_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; VI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB11_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB11_4:
; VI-NEXT:    s_branch .LBB11_2
;
; GFX9-LABEL: bitcast_v10f64_to_v20i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v12, v6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB11_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB11_3
; GFX9-NEXT:  .LBB11_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB11_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB11_4:
; GFX9-NEXT:    s_branch .LBB11_2
;
; GFX11-LABEL: bitcast_v10f64_to_v20i32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB11_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB11_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB11_3:
; GFX11-NEXT:  .LBB11_4: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX11-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <10 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <10 x double> %a1 to <20 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <10 x double> %a to <20 x i32>
  br label %end

end:
  %phi = phi <20 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x i32> %phi
}

define <40 x i16> @bitcast_v20i32_to_v40i16(<20 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v20i32_to_v40i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v21
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB12_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v21, v20, v19, 16
; SI-NEXT:    v_alignbit_b32 v22, v18, v17, 16
; SI-NEXT:    v_alignbit_b32 v23, v16, v15, 16
; SI-NEXT:    v_alignbit_b32 v24, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v26, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v28, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v31, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v33, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v35, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v37, v2, v1, 16
; SI-NEXT:    v_lshrrev_b32_e32 v25, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v2
; SI-NEXT:  .LBB12_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB12_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_alignbit_b32 v21, v20, v19, 16
; SI-NEXT:    v_alignbit_b32 v22, v18, v17, 16
; SI-NEXT:    v_alignbit_b32 v23, v16, v15, 16
; SI-NEXT:    v_alignbit_b32 v24, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v26, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v28, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v31, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v33, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v35, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v37, v2, v1, 16
; SI-NEXT:    v_lshrrev_b32_e32 v25, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v2
; SI-NEXT:  .LBB12_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; SI-NEXT:    v_or_b32_e32 v1, v1, v37
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v48
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 4, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v35
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 8, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v39
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 12, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v33
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 16, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v38
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 20, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v7
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v31
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 24, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v36
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 28, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v9
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v28
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 32, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v10
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v34
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 36, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v11
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v26
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 40, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v12
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v32
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v13
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v24
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v14
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v30
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 52, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v15
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v23
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 56, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v16
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v29
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 60, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v17
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v22
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 64, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v18
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v27
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v19
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v21
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v20
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v25
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x4c, v0
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v20i32_to_v40i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr27
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr25
; VI-NEXT:    ; implicit-def: $vgpr24
; VI-NEXT:    ; implicit-def: $vgpr23
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr21
; VI-NEXT:    ; implicit-def: $vgpr20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB12_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; VI-NEXT:  .LBB12_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB12_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; VI-NEXT:  .LBB12_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; VI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; VI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; VI-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; VI-NEXT:    v_lshlrev_b32_e32 v35, 16, v35
; VI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; VI-NEXT:    v_lshlrev_b32_e32 v33, 16, v33
; VI-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; VI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; VI-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; VI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; VI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; VI-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; VI-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; VI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; VI-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; VI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; VI-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; VI-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; VI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; VI-NEXT:    v_or_b32_sdwa v0, v0, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v8, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v9, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v10, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v11, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v12, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v13, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v14, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v15, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v16, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v17, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v18, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v19, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v20i32_to_v40i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr27
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr25
; GFX9-NEXT:    ; implicit-def: $vgpr24
; GFX9-NEXT:    ; implicit-def: $vgpr23
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr21
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB12_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX9-NEXT:  .LBB12_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB12_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX9-NEXT:  .LBB12_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v39, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v38, v1, s4
; GFX9-NEXT:    v_perm_b32 v2, v37, v2, s4
; GFX9-NEXT:    v_perm_b32 v3, v36, v3, s4
; GFX9-NEXT:    v_perm_b32 v4, v35, v4, s4
; GFX9-NEXT:    v_perm_b32 v5, v34, v5, s4
; GFX9-NEXT:    v_perm_b32 v6, v33, v6, s4
; GFX9-NEXT:    v_perm_b32 v7, v32, v7, s4
; GFX9-NEXT:    v_perm_b32 v8, v31, v8, s4
; GFX9-NEXT:    v_perm_b32 v9, v30, v9, s4
; GFX9-NEXT:    v_perm_b32 v10, v29, v10, s4
; GFX9-NEXT:    v_perm_b32 v11, v28, v11, s4
; GFX9-NEXT:    v_perm_b32 v12, v27, v12, s4
; GFX9-NEXT:    v_perm_b32 v13, v26, v13, s4
; GFX9-NEXT:    v_perm_b32 v14, v25, v14, s4
; GFX9-NEXT:    v_perm_b32 v15, v24, v15, s4
; GFX9-NEXT:    v_perm_b32 v16, v23, v16, s4
; GFX9-NEXT:    v_perm_b32 v17, v22, v17, s4
; GFX9-NEXT:    v_perm_b32 v18, v21, v18, s4
; GFX9-NEXT:    v_perm_b32 v19, v20, v19, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v20i32_to_v40i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-TRUE16-NEXT:  .LBB12_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v20i32_to_v40i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr27
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr25
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr24
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr23
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr20
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB12_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX11-FAKE16-NEXT:  .LBB12_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB12_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX11-FAKE16-NEXT:  .LBB12_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v39, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v38, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v37, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v36, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v35, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v34, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v33, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v32, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v31, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v30, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v29, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v28, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v27, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v26, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v25, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v24, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v23, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v22, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v21, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v20, v19, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <20 x i32> %a, splat (i32 3)
  %a2 = bitcast <20 x i32> %a1 to <40 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <20 x i32> %a to <40 x i16>
  br label %end

end:
  %phi = phi <40 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <40 x i16> %phi
}

define inreg <40 x i16> @bitcast_v20i32_to_v40i16_scalar(<20 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v20i32_to_v40i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v7
; SI-NEXT:    v_readfirstlane_b32 s11, v1
; SI-NEXT:    v_readfirstlane_b32 s10, v2
; SI-NEXT:    v_readfirstlane_b32 s9, v3
; SI-NEXT:    v_readfirstlane_b32 s8, v4
; SI-NEXT:    v_readfirstlane_b32 s7, v5
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_readfirstlane_b32 s6, v6
; SI-NEXT:    s_cbranch_scc0 .LBB13_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    v_mov_b32_e32 v2, s9
; SI-NEXT:    v_mov_b32_e32 v3, s11
; SI-NEXT:    v_mov_b32_e32 v4, s28
; SI-NEXT:    v_mov_b32_e32 v5, s26
; SI-NEXT:    v_mov_b32_e32 v6, s24
; SI-NEXT:    v_mov_b32_e32 v7, s22
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v9, s18
; SI-NEXT:    v_mov_b32_e32 v10, s16
; SI-NEXT:    v_alignbit_b32 v1, s6, v1, 16
; SI-NEXT:    v_alignbit_b32 v2, s8, v2, 16
; SI-NEXT:    v_alignbit_b32 v3, s10, v3, 16
; SI-NEXT:    v_alignbit_b32 v4, s29, v4, 16
; SI-NEXT:    v_alignbit_b32 v5, s27, v5, 16
; SI-NEXT:    v_alignbit_b32 v6, s25, v6, 16
; SI-NEXT:    v_alignbit_b32 v7, s23, v7, 16
; SI-NEXT:    v_alignbit_b32 v8, s21, v8, 16
; SI-NEXT:    v_alignbit_b32 v9, s19, v9, 16
; SI-NEXT:    v_alignbit_b32 v10, s17, v10, 16
; SI-NEXT:    s_lshr_b32 s12, s6, 16
; SI-NEXT:    s_lshr_b32 s13, s8, 16
; SI-NEXT:    s_lshr_b32 s14, s10, 16
; SI-NEXT:    s_lshr_b32 s15, s29, 16
; SI-NEXT:    s_lshr_b32 s40, s27, 16
; SI-NEXT:    s_lshr_b32 s41, s25, 16
; SI-NEXT:    s_lshr_b32 s42, s23, 16
; SI-NEXT:    s_lshr_b32 s43, s21, 16
; SI-NEXT:    s_lshr_b32 s44, s19, 16
; SI-NEXT:    s_lshr_b32 s45, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB13_3
; SI-NEXT:  .LBB13_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_add_i32 s11, s11, 3
; SI-NEXT:    s_add_i32 s9, s9, 3
; SI-NEXT:    s_add_i32 s7, s7, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_add_i32 s25, s25, 3
; SI-NEXT:    s_add_i32 s27, s27, 3
; SI-NEXT:    s_add_i32 s29, s29, 3
; SI-NEXT:    s_add_i32 s10, s10, 3
; SI-NEXT:    s_add_i32 s8, s8, 3
; SI-NEXT:    s_add_i32 s6, s6, 3
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    v_mov_b32_e32 v2, s9
; SI-NEXT:    v_mov_b32_e32 v3, s11
; SI-NEXT:    v_mov_b32_e32 v4, s28
; SI-NEXT:    v_mov_b32_e32 v5, s26
; SI-NEXT:    v_mov_b32_e32 v6, s24
; SI-NEXT:    v_mov_b32_e32 v7, s22
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v9, s18
; SI-NEXT:    v_mov_b32_e32 v10, s16
; SI-NEXT:    v_alignbit_b32 v1, s6, v1, 16
; SI-NEXT:    v_alignbit_b32 v2, s8, v2, 16
; SI-NEXT:    v_alignbit_b32 v3, s10, v3, 16
; SI-NEXT:    v_alignbit_b32 v4, s29, v4, 16
; SI-NEXT:    v_alignbit_b32 v5, s27, v5, 16
; SI-NEXT:    v_alignbit_b32 v6, s25, v6, 16
; SI-NEXT:    v_alignbit_b32 v7, s23, v7, 16
; SI-NEXT:    v_alignbit_b32 v8, s21, v8, 16
; SI-NEXT:    v_alignbit_b32 v9, s19, v9, 16
; SI-NEXT:    v_alignbit_b32 v10, s17, v10, 16
; SI-NEXT:    s_lshr_b32 s12, s6, 16
; SI-NEXT:    s_lshr_b32 s13, s8, 16
; SI-NEXT:    s_lshr_b32 s14, s10, 16
; SI-NEXT:    s_lshr_b32 s15, s29, 16
; SI-NEXT:    s_lshr_b32 s40, s27, 16
; SI-NEXT:    s_lshr_b32 s41, s25, 16
; SI-NEXT:    s_lshr_b32 s42, s23, 16
; SI-NEXT:    s_lshr_b32 s43, s21, 16
; SI-NEXT:    s_lshr_b32 s44, s19, 16
; SI-NEXT:    s_lshr_b32 s45, s17, 16
; SI-NEXT:  .LBB13_3: ; %end
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, s4, v10
; SI-NEXT:    s_and_b32 s4, s17, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s45, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_mov_b32_e32 v11, s4
; SI-NEXT:    s_and_b32 s4, s18, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    buffer_store_dword v10, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v10, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v9, s4, v9
; SI-NEXT:    s_and_b32 s4, s19, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s44, 16
; SI-NEXT:    buffer_store_dword v11, v10, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v10, vcc, 8, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v9, v10, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v10, s4
; SI-NEXT:    s_and_b32 s4, s20, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v9, vcc, 12, v0
; SI-NEXT:    v_or_b32_e32 v8, s4, v8
; SI-NEXT:    s_and_b32 s4, s21, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s43, 16
; SI-NEXT:    buffer_store_dword v10, v9, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v9, vcc, 16, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v8, v9, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v9, s4
; SI-NEXT:    s_and_b32 s4, s22, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v8, vcc, 20, v0
; SI-NEXT:    v_or_b32_e32 v7, s4, v7
; SI-NEXT:    s_and_b32 s4, s23, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s42, 16
; SI-NEXT:    buffer_store_dword v9, v8, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v8, vcc, 24, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v7, v8, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v8, s4
; SI-NEXT:    s_and_b32 s4, s24, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v7, vcc, 28, v0
; SI-NEXT:    v_or_b32_e32 v6, s4, v6
; SI-NEXT:    s_and_b32 s4, s25, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s41, 16
; SI-NEXT:    buffer_store_dword v8, v7, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v7, vcc, 32, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v6, v7, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v7, s4
; SI-NEXT:    s_and_b32 s4, s26, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v6, vcc, 36, v0
; SI-NEXT:    v_or_b32_e32 v5, s4, v5
; SI-NEXT:    s_and_b32 s4, s27, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s40, 16
; SI-NEXT:    buffer_store_dword v7, v6, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v6, vcc, 40, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v5, v6, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v6, s4
; SI-NEXT:    s_and_b32 s4, s28, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v5, vcc, 44, v0
; SI-NEXT:    v_or_b32_e32 v4, s4, v4
; SI-NEXT:    s_and_b32 s4, s29, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s15, 16
; SI-NEXT:    buffer_store_dword v6, v5, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v5, vcc, 48, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v4, v5, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v5, s4
; SI-NEXT:    s_and_b32 s4, s11, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v4, vcc, 52, v0
; SI-NEXT:    v_or_b32_e32 v3, s4, v3
; SI-NEXT:    s_and_b32 s4, s10, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s14, 16
; SI-NEXT:    buffer_store_dword v5, v4, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v4, vcc, 56, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v3, v4, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v4, s4
; SI-NEXT:    s_and_b32 s4, s9, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v3, vcc, 60, v0
; SI-NEXT:    v_or_b32_e32 v2, s4, v2
; SI-NEXT:    s_and_b32 s4, s8, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s13, 16
; SI-NEXT:    buffer_store_dword v4, v3, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v3, vcc, 64, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v2, v3, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v3, s4
; SI-NEXT:    s_and_b32 s4, s7, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x44, v0
; SI-NEXT:    v_or_b32_e32 v1, s4, v1
; SI-NEXT:    s_and_b32 s4, s6, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s12, 16
; SI-NEXT:    buffer_store_dword v3, v2, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x48, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x4c, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s4
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB13_4:
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $sgpr45
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $sgpr44
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $sgpr43
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $sgpr42
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $sgpr41
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $sgpr40
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $sgpr15
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr14
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $sgpr13
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr12
; SI-NEXT:    s_branch .LBB13_2
;
; VI-LABEL: bitcast_v20i32_to_v40i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    v_readfirstlane_b32 s11, v0
; VI-NEXT:    v_readfirstlane_b32 s10, v1
; VI-NEXT:    v_readfirstlane_b32 s9, v2
; VI-NEXT:    v_readfirstlane_b32 s8, v3
; VI-NEXT:    v_readfirstlane_b32 s6, v4
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_readfirstlane_b32 s7, v5
; VI-NEXT:    s_cbranch_scc0 .LBB13_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s12, s7, 16
; VI-NEXT:    s_lshr_b32 s13, s6, 16
; VI-NEXT:    s_lshr_b32 s14, s8, 16
; VI-NEXT:    s_lshr_b32 s15, s9, 16
; VI-NEXT:    s_lshr_b32 s40, s10, 16
; VI-NEXT:    s_lshr_b32 s41, s11, 16
; VI-NEXT:    s_lshr_b32 s42, s29, 16
; VI-NEXT:    s_lshr_b32 s43, s28, 16
; VI-NEXT:    s_lshr_b32 s44, s27, 16
; VI-NEXT:    s_lshr_b32 s45, s26, 16
; VI-NEXT:    s_lshr_b32 s46, s25, 16
; VI-NEXT:    s_lshr_b32 s47, s24, 16
; VI-NEXT:    s_lshr_b32 s56, s23, 16
; VI-NEXT:    s_lshr_b32 s57, s22, 16
; VI-NEXT:    s_lshr_b32 s58, s21, 16
; VI-NEXT:    s_lshr_b32 s59, s20, 16
; VI-NEXT:    s_lshr_b32 s60, s19, 16
; VI-NEXT:    s_lshr_b32 s61, s18, 16
; VI-NEXT:    s_lshr_b32 s62, s17, 16
; VI-NEXT:    s_lshr_b32 s63, s16, 16
; VI-NEXT:    s_cbranch_execnz .LBB13_3
; VI-NEXT:  .LBB13_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s7, s7, 3
; VI-NEXT:    s_add_i32 s6, s6, 3
; VI-NEXT:    s_add_i32 s8, s8, 3
; VI-NEXT:    s_add_i32 s9, s9, 3
; VI-NEXT:    s_add_i32 s10, s10, 3
; VI-NEXT:    s_add_i32 s11, s11, 3
; VI-NEXT:    s_add_i32 s29, s29, 3
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    s_add_i32 s27, s27, 3
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_add_i32 s25, s25, 3
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_lshr_b32 s12, s7, 16
; VI-NEXT:    s_lshr_b32 s13, s6, 16
; VI-NEXT:    s_lshr_b32 s14, s8, 16
; VI-NEXT:    s_lshr_b32 s15, s9, 16
; VI-NEXT:    s_lshr_b32 s40, s10, 16
; VI-NEXT:    s_lshr_b32 s41, s11, 16
; VI-NEXT:    s_lshr_b32 s42, s29, 16
; VI-NEXT:    s_lshr_b32 s43, s28, 16
; VI-NEXT:    s_lshr_b32 s44, s27, 16
; VI-NEXT:    s_lshr_b32 s45, s26, 16
; VI-NEXT:    s_lshr_b32 s46, s25, 16
; VI-NEXT:    s_lshr_b32 s47, s24, 16
; VI-NEXT:    s_lshr_b32 s56, s23, 16
; VI-NEXT:    s_lshr_b32 s57, s22, 16
; VI-NEXT:    s_lshr_b32 s58, s21, 16
; VI-NEXT:    s_lshr_b32 s59, s20, 16
; VI-NEXT:    s_lshr_b32 s60, s19, 16
; VI-NEXT:    s_lshr_b32 s61, s18, 16
; VI-NEXT:    s_lshr_b32 s62, s17, 16
; VI-NEXT:    s_lshr_b32 s63, s16, 16
; VI-NEXT:  .LBB13_3: ; %end
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s63, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s16, s62, 16
; VI-NEXT:    s_or_b32 s5, s5, s16
; VI-NEXT:    s_and_b32 s16, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s17, s61, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s17, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s18, s60, 16
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s18, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s19, s59, 16
; VI-NEXT:    s_or_b32 s18, s18, s19
; VI-NEXT:    s_and_b32 s19, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s20, s58, 16
; VI-NEXT:    s_or_b32 s19, s19, s20
; VI-NEXT:    s_and_b32 s20, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s21, s57, 16
; VI-NEXT:    s_or_b32 s20, s20, s21
; VI-NEXT:    s_and_b32 s21, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s22, s56, 16
; VI-NEXT:    s_or_b32 s21, s21, s22
; VI-NEXT:    s_and_b32 s22, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s23, s47, 16
; VI-NEXT:    s_or_b32 s22, s22, s23
; VI-NEXT:    s_and_b32 s23, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s24, s46, 16
; VI-NEXT:    s_or_b32 s23, s23, s24
; VI-NEXT:    s_and_b32 s24, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s25, s45, 16
; VI-NEXT:    s_or_b32 s24, s24, s25
; VI-NEXT:    s_and_b32 s25, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s26, s44, 16
; VI-NEXT:    s_or_b32 s25, s25, s26
; VI-NEXT:    s_and_b32 s26, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s27, s43, 16
; VI-NEXT:    s_or_b32 s26, s26, s27
; VI-NEXT:    s_and_b32 s27, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s28, s42, 16
; VI-NEXT:    s_or_b32 s27, s27, s28
; VI-NEXT:    s_and_b32 s11, 0xffff, s11
; VI-NEXT:    s_lshl_b32 s28, s41, 16
; VI-NEXT:    s_or_b32 s11, s11, s28
; VI-NEXT:    s_and_b32 s10, 0xffff, s10
; VI-NEXT:    s_lshl_b32 s28, s40, 16
; VI-NEXT:    s_and_b32 s9, 0xffff, s9
; VI-NEXT:    s_lshl_b32 s15, s15, 16
; VI-NEXT:    s_and_b32 s8, 0xffff, s8
; VI-NEXT:    s_lshl_b32 s14, s14, 16
; VI-NEXT:    s_and_b32 s6, 0xffff, s6
; VI-NEXT:    s_lshl_b32 s13, s13, 16
; VI-NEXT:    s_and_b32 s7, 0xffff, s7
; VI-NEXT:    s_lshl_b32 s12, s12, 16
; VI-NEXT:    s_or_b32 s10, s10, s28
; VI-NEXT:    s_or_b32 s9, s9, s15
; VI-NEXT:    s_or_b32 s8, s8, s14
; VI-NEXT:    s_or_b32 s6, s6, s13
; VI-NEXT:    s_or_b32 s7, s7, s12
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    v_mov_b32_e32 v3, s17
; VI-NEXT:    v_mov_b32_e32 v4, s18
; VI-NEXT:    v_mov_b32_e32 v5, s19
; VI-NEXT:    v_mov_b32_e32 v6, s20
; VI-NEXT:    v_mov_b32_e32 v7, s21
; VI-NEXT:    v_mov_b32_e32 v8, s22
; VI-NEXT:    v_mov_b32_e32 v9, s23
; VI-NEXT:    v_mov_b32_e32 v10, s24
; VI-NEXT:    v_mov_b32_e32 v11, s25
; VI-NEXT:    v_mov_b32_e32 v12, s26
; VI-NEXT:    v_mov_b32_e32 v13, s27
; VI-NEXT:    v_mov_b32_e32 v14, s11
; VI-NEXT:    v_mov_b32_e32 v15, s10
; VI-NEXT:    v_mov_b32_e32 v16, s9
; VI-NEXT:    v_mov_b32_e32 v17, s8
; VI-NEXT:    v_mov_b32_e32 v18, s6
; VI-NEXT:    v_mov_b32_e32 v19, s7
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB13_4:
; VI-NEXT:    ; implicit-def: $sgpr63
; VI-NEXT:    ; implicit-def: $sgpr62
; VI-NEXT:    ; implicit-def: $sgpr61
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr59
; VI-NEXT:    ; implicit-def: $sgpr58
; VI-NEXT:    ; implicit-def: $sgpr57
; VI-NEXT:    ; implicit-def: $sgpr56
; VI-NEXT:    ; implicit-def: $sgpr47
; VI-NEXT:    ; implicit-def: $sgpr46
; VI-NEXT:    ; implicit-def: $sgpr45
; VI-NEXT:    ; implicit-def: $sgpr44
; VI-NEXT:    ; implicit-def: $sgpr43
; VI-NEXT:    ; implicit-def: $sgpr42
; VI-NEXT:    ; implicit-def: $sgpr41
; VI-NEXT:    ; implicit-def: $sgpr40
; VI-NEXT:    ; implicit-def: $sgpr15
; VI-NEXT:    ; implicit-def: $sgpr14
; VI-NEXT:    ; implicit-def: $sgpr13
; VI-NEXT:    ; implicit-def: $sgpr12
; VI-NEXT:    s_branch .LBB13_2
;
; GFX9-LABEL: bitcast_v20i32_to_v40i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    v_readfirstlane_b32 s6, v0
; GFX9-NEXT:    v_readfirstlane_b32 s7, v1
; GFX9-NEXT:    v_readfirstlane_b32 s8, v2
; GFX9-NEXT:    v_readfirstlane_b32 s9, v3
; GFX9-NEXT:    v_readfirstlane_b32 s10, v4
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_readfirstlane_b32 s11, v5
; GFX9-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s12, s11, 16
; GFX9-NEXT:    s_lshr_b32 s13, s10, 16
; GFX9-NEXT:    s_lshr_b32 s14, s9, 16
; GFX9-NEXT:    s_lshr_b32 s15, s8, 16
; GFX9-NEXT:    s_lshr_b32 s40, s7, 16
; GFX9-NEXT:    s_lshr_b32 s41, s6, 16
; GFX9-NEXT:    s_lshr_b32 s42, s29, 16
; GFX9-NEXT:    s_lshr_b32 s43, s28, 16
; GFX9-NEXT:    s_lshr_b32 s44, s27, 16
; GFX9-NEXT:    s_lshr_b32 s45, s26, 16
; GFX9-NEXT:    s_lshr_b32 s46, s25, 16
; GFX9-NEXT:    s_lshr_b32 s47, s24, 16
; GFX9-NEXT:    s_lshr_b32 s56, s23, 16
; GFX9-NEXT:    s_lshr_b32 s57, s22, 16
; GFX9-NEXT:    s_lshr_b32 s58, s21, 16
; GFX9-NEXT:    s_lshr_b32 s59, s20, 16
; GFX9-NEXT:    s_lshr_b32 s60, s19, 16
; GFX9-NEXT:    s_lshr_b32 s61, s18, 16
; GFX9-NEXT:    s_lshr_b32 s62, s17, 16
; GFX9-NEXT:    s_lshr_b32 s63, s16, 16
; GFX9-NEXT:    s_cbranch_execnz .LBB13_3
; GFX9-NEXT:  .LBB13_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s11, s11, 3
; GFX9-NEXT:    s_add_i32 s10, s10, 3
; GFX9-NEXT:    s_add_i32 s9, s9, 3
; GFX9-NEXT:    s_add_i32 s8, s8, 3
; GFX9-NEXT:    s_add_i32 s7, s7, 3
; GFX9-NEXT:    s_add_i32 s6, s6, 3
; GFX9-NEXT:    s_add_i32 s29, s29, 3
; GFX9-NEXT:    s_add_i32 s28, s28, 3
; GFX9-NEXT:    s_add_i32 s27, s27, 3
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_add_i32 s25, s25, 3
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_add_i32 s23, s23, 3
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_lshr_b32 s12, s11, 16
; GFX9-NEXT:    s_lshr_b32 s13, s10, 16
; GFX9-NEXT:    s_lshr_b32 s14, s9, 16
; GFX9-NEXT:    s_lshr_b32 s15, s8, 16
; GFX9-NEXT:    s_lshr_b32 s40, s7, 16
; GFX9-NEXT:    s_lshr_b32 s41, s6, 16
; GFX9-NEXT:    s_lshr_b32 s42, s29, 16
; GFX9-NEXT:    s_lshr_b32 s43, s28, 16
; GFX9-NEXT:    s_lshr_b32 s44, s27, 16
; GFX9-NEXT:    s_lshr_b32 s45, s26, 16
; GFX9-NEXT:    s_lshr_b32 s46, s25, 16
; GFX9-NEXT:    s_lshr_b32 s47, s24, 16
; GFX9-NEXT:    s_lshr_b32 s56, s23, 16
; GFX9-NEXT:    s_lshr_b32 s57, s22, 16
; GFX9-NEXT:    s_lshr_b32 s58, s21, 16
; GFX9-NEXT:    s_lshr_b32 s59, s20, 16
; GFX9-NEXT:    s_lshr_b32 s60, s19, 16
; GFX9-NEXT:    s_lshr_b32 s61, s18, 16
; GFX9-NEXT:    s_lshr_b32 s62, s17, 16
; GFX9-NEXT:    s_lshr_b32 s63, s16, 16
; GFX9-NEXT:  .LBB13_3: ; %end
; GFX9-NEXT:    s_pack_ll_b32_b16 s4, s16, s63
; GFX9-NEXT:    s_pack_ll_b32_b16 s5, s17, s62
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s18, s61
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s19, s60
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s20, s59
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s21, s58
; GFX9-NEXT:    s_pack_ll_b32_b16 s20, s22, s57
; GFX9-NEXT:    s_pack_ll_b32_b16 s21, s23, s56
; GFX9-NEXT:    s_pack_ll_b32_b16 s22, s24, s47
; GFX9-NEXT:    s_pack_ll_b32_b16 s23, s25, s46
; GFX9-NEXT:    s_pack_ll_b32_b16 s24, s26, s45
; GFX9-NEXT:    s_pack_ll_b32_b16 s25, s27, s44
; GFX9-NEXT:    s_pack_ll_b32_b16 s26, s28, s43
; GFX9-NEXT:    s_pack_ll_b32_b16 s27, s29, s42
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s6, s41
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s7, s40
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s8, s15
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s9, s14
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s10, s13
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s11, s12
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s16
; GFX9-NEXT:    v_mov_b32_e32 v3, s17
; GFX9-NEXT:    v_mov_b32_e32 v4, s18
; GFX9-NEXT:    v_mov_b32_e32 v5, s19
; GFX9-NEXT:    v_mov_b32_e32 v6, s20
; GFX9-NEXT:    v_mov_b32_e32 v7, s21
; GFX9-NEXT:    v_mov_b32_e32 v8, s22
; GFX9-NEXT:    v_mov_b32_e32 v9, s23
; GFX9-NEXT:    v_mov_b32_e32 v10, s24
; GFX9-NEXT:    v_mov_b32_e32 v11, s25
; GFX9-NEXT:    v_mov_b32_e32 v12, s26
; GFX9-NEXT:    v_mov_b32_e32 v13, s27
; GFX9-NEXT:    v_mov_b32_e32 v14, s6
; GFX9-NEXT:    v_mov_b32_e32 v15, s7
; GFX9-NEXT:    v_mov_b32_e32 v16, s8
; GFX9-NEXT:    v_mov_b32_e32 v17, s9
; GFX9-NEXT:    v_mov_b32_e32 v18, s10
; GFX9-NEXT:    v_mov_b32_e32 v19, s11
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB13_4:
; GFX9-NEXT:    ; implicit-def: $sgpr63
; GFX9-NEXT:    ; implicit-def: $sgpr62
; GFX9-NEXT:    ; implicit-def: $sgpr61
; GFX9-NEXT:    ; implicit-def: $sgpr60
; GFX9-NEXT:    ; implicit-def: $sgpr59
; GFX9-NEXT:    ; implicit-def: $sgpr58
; GFX9-NEXT:    ; implicit-def: $sgpr57
; GFX9-NEXT:    ; implicit-def: $sgpr56
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr46
; GFX9-NEXT:    ; implicit-def: $sgpr45
; GFX9-NEXT:    ; implicit-def: $sgpr44
; GFX9-NEXT:    ; implicit-def: $sgpr43
; GFX9-NEXT:    ; implicit-def: $sgpr42
; GFX9-NEXT:    ; implicit-def: $sgpr41
; GFX9-NEXT:    ; implicit-def: $sgpr40
; GFX9-NEXT:    ; implicit-def: $sgpr15
; GFX9-NEXT:    ; implicit-def: $sgpr14
; GFX9-NEXT:    ; implicit-def: $sgpr13
; GFX9-NEXT:    ; implicit-def: $sgpr12
; GFX9-NEXT:    s_branch .LBB13_2
;
; GFX11-LABEL: bitcast_v20i32_to_v40i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-NEXT:    v_readfirstlane_b32 s5, v0
; GFX11-NEXT:    v_readfirstlane_b32 s4, v1
; GFX11-NEXT:    s_mov_b32 s58, 0
; GFX11-NEXT:    s_and_b32 s6, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB13_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s6, s4, 16
; GFX11-NEXT:    s_lshr_b32 s7, s5, 16
; GFX11-NEXT:    s_lshr_b32 s8, s29, 16
; GFX11-NEXT:    s_lshr_b32 s9, s28, 16
; GFX11-NEXT:    s_lshr_b32 s10, s27, 16
; GFX11-NEXT:    s_lshr_b32 s11, s26, 16
; GFX11-NEXT:    s_lshr_b32 s12, s25, 16
; GFX11-NEXT:    s_lshr_b32 s13, s24, 16
; GFX11-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-NEXT:    s_lshr_b32 s15, s22, 16
; GFX11-NEXT:    s_lshr_b32 s40, s21, 16
; GFX11-NEXT:    s_lshr_b32 s41, s20, 16
; GFX11-NEXT:    s_lshr_b32 s42, s19, 16
; GFX11-NEXT:    s_lshr_b32 s43, s18, 16
; GFX11-NEXT:    s_lshr_b32 s44, s17, 16
; GFX11-NEXT:    s_lshr_b32 s45, s16, 16
; GFX11-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-NEXT:    s_lshr_b32 s47, s2, 16
; GFX11-NEXT:    s_lshr_b32 s56, s1, 16
; GFX11-NEXT:    s_lshr_b32 s57, s0, 16
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s58
; GFX11-NEXT:    s_cbranch_vccnz .LBB13_3
; GFX11-NEXT:  .LBB13_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s4, s4, 3
; GFX11-NEXT:    s_add_i32 s5, s5, 3
; GFX11-NEXT:    s_add_i32 s29, s29, 3
; GFX11-NEXT:    s_add_i32 s28, s28, 3
; GFX11-NEXT:    s_add_i32 s27, s27, 3
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_add_i32 s25, s25, 3
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    s_add_i32 s23, s23, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_add_i32 s21, s21, 3
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_lshr_b32 s6, s4, 16
; GFX11-NEXT:    s_lshr_b32 s7, s5, 16
; GFX11-NEXT:    s_lshr_b32 s8, s29, 16
; GFX11-NEXT:    s_lshr_b32 s9, s28, 16
; GFX11-NEXT:    s_lshr_b32 s10, s27, 16
; GFX11-NEXT:    s_lshr_b32 s11, s26, 16
; GFX11-NEXT:    s_lshr_b32 s12, s25, 16
; GFX11-NEXT:    s_lshr_b32 s13, s24, 16
; GFX11-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-NEXT:    s_lshr_b32 s15, s22, 16
; GFX11-NEXT:    s_lshr_b32 s40, s21, 16
; GFX11-NEXT:    s_lshr_b32 s41, s20, 16
; GFX11-NEXT:    s_lshr_b32 s42, s19, 16
; GFX11-NEXT:    s_lshr_b32 s43, s18, 16
; GFX11-NEXT:    s_lshr_b32 s44, s17, 16
; GFX11-NEXT:    s_lshr_b32 s45, s16, 16
; GFX11-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-NEXT:    s_lshr_b32 s47, s2, 16
; GFX11-NEXT:    s_lshr_b32 s56, s1, 16
; GFX11-NEXT:    s_lshr_b32 s57, s0, 16
; GFX11-NEXT:  .LBB13_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_pack_ll_b32_b16 s0, s0, s57
; GFX11-NEXT:    s_pack_ll_b32_b16 s1, s1, s56
; GFX11-NEXT:    s_pack_ll_b32_b16 s2, s2, s47
; GFX11-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-NEXT:    s_pack_ll_b32_b16 s16, s16, s45
; GFX11-NEXT:    s_pack_ll_b32_b16 s17, s17, s44
; GFX11-NEXT:    s_pack_ll_b32_b16 s18, s18, s43
; GFX11-NEXT:    s_pack_ll_b32_b16 s19, s19, s42
; GFX11-NEXT:    s_pack_ll_b32_b16 s20, s20, s41
; GFX11-NEXT:    s_pack_ll_b32_b16 s21, s21, s40
; GFX11-NEXT:    s_pack_ll_b32_b16 s15, s22, s15
; GFX11-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-NEXT:    s_pack_ll_b32_b16 s13, s24, s13
; GFX11-NEXT:    s_pack_ll_b32_b16 s12, s25, s12
; GFX11-NEXT:    s_pack_ll_b32_b16 s11, s26, s11
; GFX11-NEXT:    s_pack_ll_b32_b16 s10, s27, s10
; GFX11-NEXT:    s_pack_ll_b32_b16 s9, s28, s9
; GFX11-NEXT:    s_pack_ll_b32_b16 s8, s29, s8
; GFX11-NEXT:    s_pack_ll_b32_b16 s5, s5, s7
; GFX11-NEXT:    s_pack_ll_b32_b16 s4, s4, s6
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s15 :: v_dual_mov_b32 v11, s14
; GFX11-NEXT:    v_dual_mov_b32 v12, s13 :: v_dual_mov_b32 v13, s12
; GFX11-NEXT:    v_dual_mov_b32 v14, s11 :: v_dual_mov_b32 v15, s10
; GFX11-NEXT:    v_dual_mov_b32 v16, s9 :: v_dual_mov_b32 v17, s8
; GFX11-NEXT:    v_dual_mov_b32 v18, s5 :: v_dual_mov_b32 v19, s4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB13_4:
; GFX11-NEXT:    ; implicit-def: $sgpr57
; GFX11-NEXT:    ; implicit-def: $sgpr56
; GFX11-NEXT:    ; implicit-def: $sgpr47
; GFX11-NEXT:    ; implicit-def: $sgpr46
; GFX11-NEXT:    ; implicit-def: $sgpr45
; GFX11-NEXT:    ; implicit-def: $sgpr44
; GFX11-NEXT:    ; implicit-def: $sgpr43
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr41
; GFX11-NEXT:    ; implicit-def: $sgpr40
; GFX11-NEXT:    ; implicit-def: $sgpr15
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    ; implicit-def: $sgpr13
; GFX11-NEXT:    ; implicit-def: $sgpr12
; GFX11-NEXT:    ; implicit-def: $sgpr11
; GFX11-NEXT:    ; implicit-def: $sgpr10
; GFX11-NEXT:    ; implicit-def: $sgpr9
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr7
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    s_branch .LBB13_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <20 x i32> %a, splat (i32 3)
  %a2 = bitcast <20 x i32> %a1 to <40 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <20 x i32> %a to <40 x i16>
  br label %end

end:
  %phi = phi <40 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <40 x i16> %phi
}

define <20 x i32> @bitcast_v40i16_to_v20i32(<40 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v40i16_to_v20i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v52, v6
; SI-NEXT:    v_mov_b32_e32 v53, v4
; SI-NEXT:    v_mov_b32_e32 v54, v2
; SI-NEXT:    v_mov_b32_e32 v55, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:36
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:28
; SI-NEXT:    v_mov_b32_e32 v49, v12
; SI-NEXT:    v_mov_b32_e32 v50, v10
; SI-NEXT:    v_mov_b32_e32 v51, v8
; SI-NEXT:    v_mov_b32_e32 v37, v20
; SI-NEXT:    v_mov_b32_e32 v38, v18
; SI-NEXT:    v_mov_b32_e32 v39, v16
; SI-NEXT:    v_mov_b32_e32 v48, v14
; SI-NEXT:    v_lshlrev_b32_e32 v42, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v41, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v36, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v35, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v40, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v34, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v33, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v32, 16, v15
; SI-NEXT:    s_waitcnt expcnt(5)
; SI-NEXT:    v_lshlrev_b32_e32 v63, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v62, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v61, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v60, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v59, 16, v25
; SI-NEXT:    v_lshlrev_b32_e32 v58, 16, v27
; SI-NEXT:    v_lshlrev_b32_e32 v57, 16, v29
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v56, 16, v0
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v4
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:16
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:20
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_lshlrev_b32_e32 v45, 16, v6
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v47, 16, v8
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v46, 16, v10
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:12
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB14_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v55
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v54
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v53
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v52
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v51
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v50
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v49
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v48
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v39
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v38
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v37
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v43
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    v_or_b32_e32 v0, v0, v42
; SI-NEXT:    v_or_b32_e32 v1, v1, v41
; SI-NEXT:    v_or_b32_e32 v2, v2, v36
; SI-NEXT:    v_or_b32_e32 v3, v3, v35
; SI-NEXT:    v_or_b32_e32 v4, v4, v40
; SI-NEXT:    v_or_b32_e32 v5, v5, v34
; SI-NEXT:    v_or_b32_e32 v6, v6, v33
; SI-NEXT:    v_or_b32_e32 v7, v7, v32
; SI-NEXT:    v_or_b32_e32 v8, v8, v63
; SI-NEXT:    v_or_b32_e32 v9, v9, v62
; SI-NEXT:    v_or_b32_e32 v10, v10, v61
; SI-NEXT:    v_or_b32_e32 v16, v16, v47
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_or_b32_e32 v11, v11, v60
; SI-NEXT:    v_or_b32_e32 v12, v12, v59
; SI-NEXT:    v_or_b32_e32 v13, v13, v58
; SI-NEXT:    v_or_b32_e32 v14, v14, v57
; SI-NEXT:    v_or_b32_e32 v15, v15, v56
; SI-NEXT:    v_or_b32_e32 v17, v17, v46
; SI-NEXT:    v_or_b32_e32 v18, v18, v45
; SI-NEXT:    v_or_b32_e32 v19, v19, v44
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:  .LBB14_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB14_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v55
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v54
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v53
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v52
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v51
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v50
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v49
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v48
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v39
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v38
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v37
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v43
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; SI-NEXT:    v_or_b32_e32 v0, v42, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v41, v1
; SI-NEXT:    v_or_b32_e32 v2, v36, v2
; SI-NEXT:    v_or_b32_e32 v3, v35, v3
; SI-NEXT:    v_or_b32_e32 v4, v40, v4
; SI-NEXT:    v_or_b32_e32 v5, v34, v5
; SI-NEXT:    v_or_b32_e32 v6, v33, v6
; SI-NEXT:    v_or_b32_e32 v7, v32, v7
; SI-NEXT:    v_or_b32_e32 v8, v63, v8
; SI-NEXT:    v_or_b32_e32 v9, v62, v9
; SI-NEXT:    v_or_b32_e32 v10, v61, v10
; SI-NEXT:    v_or_b32_e32 v16, v47, v16
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, s6, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, s6, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, s6, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, s6, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, s6, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, s6, v10
; SI-NEXT:    v_add_i32_e32 v16, vcc, s6, v16
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    v_or_b32_e32 v11, v60, v11
; SI-NEXT:    v_or_b32_e32 v12, v59, v12
; SI-NEXT:    v_or_b32_e32 v13, v58, v13
; SI-NEXT:    v_or_b32_e32 v14, v57, v14
; SI-NEXT:    v_or_b32_e32 v15, v56, v15
; SI-NEXT:    v_or_b32_e32 v17, v46, v17
; SI-NEXT:    v_or_b32_e32 v18, v45, v18
; SI-NEXT:    v_or_b32_e32 v19, v44, v19
; SI-NEXT:    v_add_i32_e32 v11, vcc, s6, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, s6, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, s6, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, s6, v14
; SI-NEXT:    v_add_i32_e32 v15, vcc, s6, v15
; SI-NEXT:    v_add_i32_e32 v17, vcc, s6, v17
; SI-NEXT:    v_add_i32_e32 v18, vcc, s6, v18
; SI-NEXT:    v_add_i32_e32 v19, vcc, s6, v19
; SI-NEXT:  .LBB14_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v40i16_to_v20i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    v_mov_b32_e32 v32, v19
; VI-NEXT:    v_mov_b32_e32 v33, v18
; VI-NEXT:    v_mov_b32_e32 v34, v17
; VI-NEXT:    v_mov_b32_e32 v35, v16
; VI-NEXT:    v_mov_b32_e32 v36, v15
; VI-NEXT:    v_mov_b32_e32 v37, v14
; VI-NEXT:    v_mov_b32_e32 v38, v13
; VI-NEXT:    v_mov_b32_e32 v39, v12
; VI-NEXT:    v_mov_b32_e32 v48, v11
; VI-NEXT:    v_mov_b32_e32 v49, v10
; VI-NEXT:    v_mov_b32_e32 v50, v9
; VI-NEXT:    v_mov_b32_e32 v51, v8
; VI-NEXT:    v_mov_b32_e32 v52, v7
; VI-NEXT:    v_mov_b32_e32 v53, v6
; VI-NEXT:    v_mov_b32_e32 v54, v5
; VI-NEXT:    v_mov_b32_e32 v55, v4
; VI-NEXT:    v_mov_b32_e32 v40, v3
; VI-NEXT:    v_mov_b32_e32 v41, v2
; VI-NEXT:    v_mov_b32_e32 v42, v1
; VI-NEXT:    v_mov_b32_e32 v43, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB14_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_mov_b32_e32 v19, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v19, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v19, v42 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v19, v41 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v3, v19, v40 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v4, v19, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v5, v19, v54 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v6, v19, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v7, v19, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v8, v19, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v9, v19, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v10, v19, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v11, v19, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v12, v19, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v13, v19, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v14, v19, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v15, v19, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v16, v19, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v17, v19, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v18, v19, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v19, v19, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v43, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v42, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v41, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v40, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v55, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v54, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v53, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v52, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v51, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v50, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v49, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v48, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v39, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v38, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v37, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v36, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v35, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v34, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v33, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v32, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:  .LBB14_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB14_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v19, 3
; VI-NEXT:    v_add_u16_e32 v0, 3, v43
; VI-NEXT:    v_add_u16_sdwa v1, v43, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v42
; VI-NEXT:    v_add_u16_sdwa v2, v42, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    v_add_u16_e32 v2, 3, v41
; VI-NEXT:    v_add_u16_sdwa v3, v41, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    v_add_u16_e32 v3, 3, v40
; VI-NEXT:    v_add_u16_sdwa v4, v40, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v55
; VI-NEXT:    v_add_u16_sdwa v5, v55, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v4, v5
; VI-NEXT:    v_add_u16_e32 v5, 3, v54
; VI-NEXT:    v_add_u16_sdwa v6, v54, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v5, v6
; VI-NEXT:    v_add_u16_e32 v6, 3, v53
; VI-NEXT:    v_add_u16_sdwa v7, v53, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v6, v7
; VI-NEXT:    v_add_u16_e32 v7, 3, v52
; VI-NEXT:    v_add_u16_sdwa v8, v52, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v7, v8
; VI-NEXT:    v_add_u16_e32 v8, 3, v51
; VI-NEXT:    v_add_u16_sdwa v9, v51, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v8, v8, v9
; VI-NEXT:    v_add_u16_e32 v9, 3, v50
; VI-NEXT:    v_add_u16_sdwa v10, v50, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v9, v9, v10
; VI-NEXT:    v_add_u16_e32 v10, 3, v49
; VI-NEXT:    v_add_u16_sdwa v11, v49, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v10, v10, v11
; VI-NEXT:    v_add_u16_e32 v11, 3, v48
; VI-NEXT:    v_add_u16_sdwa v12, v48, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v11, v11, v12
; VI-NEXT:    v_add_u16_e32 v12, 3, v39
; VI-NEXT:    v_add_u16_sdwa v13, v39, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v12, v12, v13
; VI-NEXT:    v_add_u16_e32 v13, 3, v38
; VI-NEXT:    v_add_u16_sdwa v14, v38, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v13, v13, v14
; VI-NEXT:    v_add_u16_e32 v14, 3, v37
; VI-NEXT:    v_add_u16_sdwa v15, v37, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v14, v14, v15
; VI-NEXT:    v_add_u16_e32 v15, 3, v36
; VI-NEXT:    v_add_u16_sdwa v16, v36, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v15, v15, v16
; VI-NEXT:    v_add_u16_e32 v16, 3, v35
; VI-NEXT:    v_add_u16_sdwa v17, v35, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v16, v16, v17
; VI-NEXT:    v_add_u16_e32 v17, 3, v34
; VI-NEXT:    v_add_u16_sdwa v18, v34, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v17, v17, v18
; VI-NEXT:    v_add_u16_e32 v18, 3, v33
; VI-NEXT:    v_add_u16_sdwa v20, v33, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v18, v18, v20
; VI-NEXT:    v_add_u16_e32 v20, 3, v32
; VI-NEXT:    v_add_u16_sdwa v19, v32, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v19, v20, v19
; VI-NEXT:  .LBB14_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v40i16_to_v20i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v19
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    v_mov_b32_e32 v33, v18
; GFX9-NEXT:    v_mov_b32_e32 v43, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v32
; GFX9-NEXT:    v_mov_b32_e32 v34, v17
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v33
; GFX9-NEXT:    v_mov_b32_e32 v35, v16
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v34
; GFX9-NEXT:    v_mov_b32_e32 v36, v15
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v35
; GFX9-NEXT:    v_mov_b32_e32 v37, v14
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v36
; GFX9-NEXT:    v_mov_b32_e32 v38, v13
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v37
; GFX9-NEXT:    v_mov_b32_e32 v39, v12
; GFX9-NEXT:    v_mov_b32_e32 v48, v11
; GFX9-NEXT:    v_mov_b32_e32 v49, v10
; GFX9-NEXT:    v_mov_b32_e32 v50, v9
; GFX9-NEXT:    v_mov_b32_e32 v51, v8
; GFX9-NEXT:    v_mov_b32_e32 v52, v7
; GFX9-NEXT:    v_mov_b32_e32 v53, v6
; GFX9-NEXT:    v_mov_b32_e32 v54, v5
; GFX9-NEXT:    v_mov_b32_e32 v55, v4
; GFX9-NEXT:    v_mov_b32_e32 v40, v3
; GFX9-NEXT:    v_mov_b32_e32 v41, v2
; GFX9-NEXT:    v_mov_b32_e32 v42, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v38
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v39
; GFX9-NEXT:    v_lshrrev_b32_e32 v60, 16, v48
; GFX9-NEXT:    v_lshrrev_b32_e32 v61, 16, v49
; GFX9-NEXT:    v_lshrrev_b32_e32 v62, 16, v50
; GFX9-NEXT:    v_lshrrev_b32_e32 v63, 16, v51
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v52
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v53
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v54
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v55
; GFX9-NEXT:    v_lshrrev_b32_e32 v56, 16, v40
; GFX9-NEXT:    v_lshrrev_b32_e32 v57, 16, v41
; GFX9-NEXT:    v_lshrrev_b32_e32 v58, 16, v42
; GFX9-NEXT:    v_lshrrev_b32_e32 v59, 16, v43
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB14_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 16, v39
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 16, v38
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v37
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 16, v36
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v16, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v19, 16, v32
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    v_perm_b32 v0, v59, v43, s6
; GFX9-NEXT:    v_perm_b32 v1, v58, v42, s6
; GFX9-NEXT:    v_perm_b32 v2, v57, v41, s6
; GFX9-NEXT:    v_perm_b32 v3, v56, v40, s6
; GFX9-NEXT:    v_perm_b32 v4, v47, v55, s6
; GFX9-NEXT:    v_perm_b32 v5, v46, v54, s6
; GFX9-NEXT:    v_perm_b32 v6, v45, v53, s6
; GFX9-NEXT:    v_perm_b32 v7, v44, v52, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v51, s6
; GFX9-NEXT:    v_perm_b32 v9, v62, v50, s6
; GFX9-NEXT:    v_perm_b32 v10, v61, v49, s6
; GFX9-NEXT:    v_perm_b32 v11, v60, v48, s6
; GFX9-NEXT:    v_perm_b32 v12, v12, v39, s6
; GFX9-NEXT:    v_perm_b32 v13, v13, v38, s6
; GFX9-NEXT:    v_perm_b32 v14, v14, v37, s6
; GFX9-NEXT:    v_perm_b32 v15, v15, v36, s6
; GFX9-NEXT:    v_perm_b32 v16, v16, v35, s6
; GFX9-NEXT:    v_perm_b32 v17, v17, v34, s6
; GFX9-NEXT:    v_perm_b32 v18, v18, v33, s6
; GFX9-NEXT:    v_perm_b32 v19, v19, v32, s6
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr60
; GFX9-NEXT:    ; implicit-def: $vgpr61
; GFX9-NEXT:    ; implicit-def: $vgpr62
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr56
; GFX9-NEXT:    ; implicit-def: $vgpr57
; GFX9-NEXT:    ; implicit-def: $vgpr58
; GFX9-NEXT:    ; implicit-def: $vgpr59
; GFX9-NEXT:  .LBB14_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB14_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v59, v43, s6
; GFX9-NEXT:    v_perm_b32 v1, v58, v42, s6
; GFX9-NEXT:    v_perm_b32 v2, v57, v41, s6
; GFX9-NEXT:    v_perm_b32 v3, v56, v40, s6
; GFX9-NEXT:    v_perm_b32 v4, v47, v55, s6
; GFX9-NEXT:    v_perm_b32 v5, v46, v54, s6
; GFX9-NEXT:    v_perm_b32 v6, v45, v53, s6
; GFX9-NEXT:    v_perm_b32 v7, v44, v52, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v51, s6
; GFX9-NEXT:    v_perm_b32 v9, v62, v50, s6
; GFX9-NEXT:    v_perm_b32 v10, v61, v49, s6
; GFX9-NEXT:    v_perm_b32 v11, v60, v48, s6
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(7)
; GFX9-NEXT:    v_perm_b32 v12, v12, v39, s6
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_perm_b32 v13, v13, v38, s6
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_perm_b32 v14, v14, v37, s6
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_perm_b32 v15, v15, v36, s6
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_perm_b32 v16, v16, v35, s6
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_perm_b32 v17, v17, v34, s6
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_perm_b32 v18, v18, v33, s6
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v19, v19, v32, s6
; GFX9-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB14_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v40i16_to_v20i32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB14_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:  .LBB14_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v40i16_to_v20i32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v3
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v37, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v38, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v39, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v48, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v36, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v35, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v34, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v33, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v32, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v31, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v30, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v29, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v28, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v27, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v26, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v25, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v24, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v23, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v22, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v21, v19, 0x5040100
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB14_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:  .LBB14_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <40 x i16> %a, splat (i16 3)
  %a2 = bitcast <40 x i16> %a1 to <20 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <40 x i16> %a to <20 x i32>
  br label %end

end:
  %phi = phi <20 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x i32> %phi
}

define inreg <20 x i32> @bitcast_v40i16_to_v20i32_scalar(<40 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v40i16_to_v20i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v26
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v32, v24
; SI-NEXT:    v_mov_b32_e32 v33, v22
; SI-NEXT:    v_mov_b32_e32 v34, v20
; SI-NEXT:    v_mov_b32_e32 v35, v18
; SI-NEXT:    v_mov_b32_e32 v36, v16
; SI-NEXT:    v_mov_b32_e32 v37, v14
; SI-NEXT:    v_mov_b32_e32 v38, v12
; SI-NEXT:    v_mov_b32_e32 v39, v10
; SI-NEXT:    v_mov_b32_e32 v48, v8
; SI-NEXT:    v_mov_b32_e32 v49, v6
; SI-NEXT:    v_mov_b32_e32 v50, v4
; SI-NEXT:    v_mov_b32_e32 v51, v2
; SI-NEXT:    v_mov_b32_e32 v52, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v57, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v56, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v47, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v46, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v45, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v43, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v42, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v41, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v40, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v55, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v54, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v53, 16, v25
; SI-NEXT:    s_cbranch_scc0 .LBB15_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v52
; SI-NEXT:    v_or_b32_e32 v7, v0, v57
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v51
; SI-NEXT:    v_or_b32_e32 v8, v0, v56
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v50
; SI-NEXT:    v_or_b32_e32 v9, v0, v47
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v49
; SI-NEXT:    v_or_b32_e32 v10, v0, v46
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v48
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    v_or_b32_e32 v11, v0, v45
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v39
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    v_or_b32_e32 v12, v0, v44
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v38
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    v_or_b32_e32 v13, v0, v43
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v37
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    v_or_b32_e32 v14, v0, v42
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v36
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    v_or_b32_e32 v15, v0, v41
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v35
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    v_or_b32_e32 v16, v0, v40
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v34
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_or_b32_e32 v17, v0, v55
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v33
; SI-NEXT:    s_or_b32 s10, s10, s11
; SI-NEXT:    v_or_b32_e32 v18, v0, v54
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v32
; SI-NEXT:    v_or_b32_e32 v19, v0, v53
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    s_cbranch_execnz .LBB15_3
; SI-NEXT:  .LBB15_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v52
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v57, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v51
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v56, v0
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v50
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v47, v0
; SI-NEXT:    v_add_i32_e32 v9, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v49
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v46, v0
; SI-NEXT:    v_add_i32_e32 v10, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v48
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v45, v0
; SI-NEXT:    v_add_i32_e32 v11, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v39
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v44, v0
; SI-NEXT:    v_add_i32_e32 v12, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v38
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v43, v0
; SI-NEXT:    v_add_i32_e32 v13, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v37
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v42, v0
; SI-NEXT:    v_add_i32_e32 v14, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v36
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v41, v0
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v35
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    v_or_b32_e32 v0, v40, v0
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    v_add_i32_e32 v16, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v34
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    v_or_b32_e32 v0, v55, v0
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    v_add_i32_e32 v17, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v33
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    v_or_b32_e32 v0, v54, v0
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_add_i32_e32 v18, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v32
; SI-NEXT:    s_or_b32 s10, s11, s10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:    s_add_i32 s10, s10, 0x30000
; SI-NEXT:    v_or_b32_e32 v0, v53, v0
; SI-NEXT:    v_add_i32_e32 v19, vcc, 0x30000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:  .LBB15_3: ; %end
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB15_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    s_branch .LBB15_2
;
; VI-LABEL: bitcast_v40i16_to_v20i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s6, s29, 16
; VI-NEXT:    s_lshr_b32 s7, s28, 16
; VI-NEXT:    s_lshr_b32 s8, s27, 16
; VI-NEXT:    s_lshr_b32 s9, s26, 16
; VI-NEXT:    s_lshr_b32 s10, s25, 16
; VI-NEXT:    s_lshr_b32 s11, s24, 16
; VI-NEXT:    s_lshr_b32 s12, s23, 16
; VI-NEXT:    s_lshr_b32 s13, s22, 16
; VI-NEXT:    s_lshr_b32 s14, s21, 16
; VI-NEXT:    s_lshr_b32 s15, s20, 16
; VI-NEXT:    s_lshr_b32 s40, s19, 16
; VI-NEXT:    s_lshr_b32 s41, s18, 16
; VI-NEXT:    s_lshr_b32 s42, s17, 16
; VI-NEXT:    s_lshr_b32 s43, s16, 16
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    v_mov_b32_e32 v32, v5
; VI-NEXT:    v_mov_b32_e32 v33, v4
; VI-NEXT:    v_mov_b32_e32 v34, v3
; VI-NEXT:    v_mov_b32_e32 v35, v2
; VI-NEXT:    v_mov_b32_e32 v36, v1
; VI-NEXT:    v_mov_b32_e32 v37, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    s_cbranch_scc0 .LBB15_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s43, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s44, s42, 16
; VI-NEXT:    s_or_b32 s5, s5, s44
; VI-NEXT:    s_and_b32 s44, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s45, s41, 16
; VI-NEXT:    s_or_b32 s44, s44, s45
; VI-NEXT:    s_and_b32 s45, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s46, s40, 16
; VI-NEXT:    s_or_b32 s45, s45, s46
; VI-NEXT:    s_and_b32 s46, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s47, s15, 16
; VI-NEXT:    s_or_b32 s46, s46, s47
; VI-NEXT:    s_and_b32 s47, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s56, s14, 16
; VI-NEXT:    s_or_b32 s47, s47, s56
; VI-NEXT:    s_and_b32 s56, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s57, s13, 16
; VI-NEXT:    s_or_b32 s56, s56, s57
; VI-NEXT:    s_and_b32 s57, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s58, s12, 16
; VI-NEXT:    s_or_b32 s57, s57, s58
; VI-NEXT:    s_and_b32 s58, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s59, s11, 16
; VI-NEXT:    s_or_b32 s58, s58, s59
; VI-NEXT:    s_and_b32 s59, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s60, s10, 16
; VI-NEXT:    v_mov_b32_e32 v0, 16
; VI-NEXT:    s_or_b32 s59, s59, s60
; VI-NEXT:    s_and_b32 s60, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s61, s9, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s60, s60, s61
; VI-NEXT:    s_and_b32 s61, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s62, s8, 16
; VI-NEXT:    v_or_b32_sdwa v14, v37, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s61, s61, s62
; VI-NEXT:    s_and_b32 s62, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s63, s7, 16
; VI-NEXT:    v_or_b32_sdwa v16, v35, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s62, s62, s63
; VI-NEXT:    s_and_b32 s63, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s72, s6, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v0, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v17, v34, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v0, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s63, s63, s72
; VI-NEXT:    v_or_b32_sdwa v15, v36, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v33, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v32, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s44
; VI-NEXT:    v_mov_b32_e32 v3, s45
; VI-NEXT:    v_mov_b32_e32 v4, s46
; VI-NEXT:    v_mov_b32_e32 v5, s47
; VI-NEXT:    v_mov_b32_e32 v6, s56
; VI-NEXT:    v_mov_b32_e32 v7, s57
; VI-NEXT:    v_mov_b32_e32 v8, s58
; VI-NEXT:    v_mov_b32_e32 v9, s59
; VI-NEXT:    v_mov_b32_e32 v10, s60
; VI-NEXT:    v_mov_b32_e32 v11, s61
; VI-NEXT:    v_mov_b32_e32 v12, s62
; VI-NEXT:    v_mov_b32_e32 v13, s63
; VI-NEXT:    s_cbranch_execnz .LBB15_3
; VI-NEXT:  .LBB15_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s43, 16
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s17, 0xffff
; VI-NEXT:    s_lshl_b32 s16, s42, 16
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s5, s16, s5
; VI-NEXT:    s_and_b32 s16, s18, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s41, 16
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_or_b32 s16, s17, s16
; VI-NEXT:    s_and_b32 s17, s19, 0xffff
; VI-NEXT:    s_lshl_b32 s18, s40, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    v_mov_b32_e32 v1, 16
; VI-NEXT:    s_or_b32 s17, s18, s17
; VI-NEXT:    s_and_b32 s18, s20, 0xffff
; VI-NEXT:    s_lshl_b32 s15, s15, 16
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v37
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s15, s15, s18
; VI-NEXT:    s_and_b32 s18, s21, 0xffff
; VI-NEXT:    s_lshl_b32 s14, s14, 16
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v36
; VI-NEXT:    v_lshlrev_b32_sdwa v3, v1, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s14, s14, s18
; VI-NEXT:    s_and_b32 s18, s22, 0xffff
; VI-NEXT:    s_lshl_b32 s13, s13, 16
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s13, s13, s18
; VI-NEXT:    s_and_b32 s18, s23, 0xffff
; VI-NEXT:    s_lshl_b32 s12, s12, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    v_add_u32_e32 v14, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v15, vcc, 0x30000, v2
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v35
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s12, s12, s18
; VI-NEXT:    s_and_b32 s18, s24, 0xffff
; VI-NEXT:    s_lshl_b32 s11, s11, 16
; VI-NEXT:    s_add_i32 s25, s25, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s11, s11, s18
; VI-NEXT:    s_and_b32 s18, s25, 0xffff
; VI-NEXT:    s_lshl_b32 s10, s10, 16
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    v_add_u32_e32 v16, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v34
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s10, s10, s18
; VI-NEXT:    s_and_b32 s18, s26, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    s_add_i32 s27, s27, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s9, s9, s18
; VI-NEXT:    s_and_b32 s18, s27, 0xffff
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    s_or_b32 s8, s8, s18
; VI-NEXT:    s_and_b32 s18, s28, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_add_i32 s29, s29, 3
; VI-NEXT:    v_add_u32_e32 v17, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v33
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s7, s7, s18
; VI-NEXT:    s_and_b32 s18, s29, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s6, s6, s18
; VI-NEXT:    v_add_u32_e32 v18, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v32
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v1, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_add_i32 s4, s4, 0x30000
; VI-NEXT:    s_add_i32 s5, s5, 0x30000
; VI-NEXT:    s_add_i32 s16, s16, 0x30000
; VI-NEXT:    s_add_i32 s17, s17, 0x30000
; VI-NEXT:    s_add_i32 s15, s15, 0x30000
; VI-NEXT:    s_add_i32 s14, s14, 0x30000
; VI-NEXT:    s_add_i32 s13, s13, 0x30000
; VI-NEXT:    s_add_i32 s12, s12, 0x30000
; VI-NEXT:    s_add_i32 s11, s11, 0x30000
; VI-NEXT:    s_add_i32 s10, s10, 0x30000
; VI-NEXT:    s_add_i32 s9, s9, 0x30000
; VI-NEXT:    s_add_i32 s8, s8, 0x30000
; VI-NEXT:    s_add_i32 s7, s7, 0x30000
; VI-NEXT:    s_add_i32 s6, s6, 0x30000
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v19, vcc, 0x30000, v0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    v_mov_b32_e32 v3, s17
; VI-NEXT:    v_mov_b32_e32 v4, s15
; VI-NEXT:    v_mov_b32_e32 v5, s14
; VI-NEXT:    v_mov_b32_e32 v6, s13
; VI-NEXT:    v_mov_b32_e32 v7, s12
; VI-NEXT:    v_mov_b32_e32 v8, s11
; VI-NEXT:    v_mov_b32_e32 v9, s10
; VI-NEXT:    v_mov_b32_e32 v10, s9
; VI-NEXT:    v_mov_b32_e32 v11, s8
; VI-NEXT:    v_mov_b32_e32 v12, s7
; VI-NEXT:    v_mov_b32_e32 v13, s6
; VI-NEXT:  .LBB15_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB15_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_branch .LBB15_2
;
; GFX9-LABEL: bitcast_v40i16_to_v20i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v5
; GFX9-NEXT:    v_mov_b32_e32 v33, v4
; GFX9-NEXT:    v_mov_b32_e32 v34, v3
; GFX9-NEXT:    v_mov_b32_e32 v35, v2
; GFX9-NEXT:    v_mov_b32_e32 v36, v1
; GFX9-NEXT:    v_mov_b32_e32 v37, v0
; GFX9-NEXT:    s_lshr_b32 s40, s29, 16
; GFX9-NEXT:    s_lshr_b32 s41, s28, 16
; GFX9-NEXT:    s_lshr_b32 s42, s27, 16
; GFX9-NEXT:    s_lshr_b32 s43, s26, 16
; GFX9-NEXT:    s_lshr_b32 s15, s25, 16
; GFX9-NEXT:    s_lshr_b32 s14, s24, 16
; GFX9-NEXT:    s_lshr_b32 s13, s23, 16
; GFX9-NEXT:    s_lshr_b32 s12, s22, 16
; GFX9-NEXT:    s_lshr_b32 s11, s21, 16
; GFX9-NEXT:    s_lshr_b32 s10, s20, 16
; GFX9-NEXT:    s_lshr_b32 s9, s19, 16
; GFX9-NEXT:    s_lshr_b32 s8, s18, 16
; GFX9-NEXT:    s_lshr_b32 s7, s17, 16
; GFX9-NEXT:    s_lshr_b32 s6, s16, 16
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v36
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v37
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s16, s6
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s17, s7
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s18, s8
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s19, s9
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s20, s10
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s21, s11
; GFX9-NEXT:    s_pack_ll_b32_b16 s12, s22, s12
; GFX9-NEXT:    s_pack_ll_b32_b16 s13, s23, s13
; GFX9-NEXT:    s_pack_ll_b32_b16 s14, s24, s14
; GFX9-NEXT:    s_pack_ll_b32_b16 s15, s25, s15
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s26, s43
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s27, s42
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s28, s41
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s29, s40
; GFX9-NEXT:    s_cbranch_scc0 .LBB15_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v37
; GFX9-NEXT:    v_lshl_or_b32 v14, v51, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v36
; GFX9-NEXT:    v_lshl_or_b32 v15, v50, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v35
; GFX9-NEXT:    v_lshl_or_b32 v16, v49, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v34
; GFX9-NEXT:    v_lshl_or_b32 v17, v48, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v33
; GFX9-NEXT:    v_lshl_or_b32 v18, v39, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v32
; GFX9-NEXT:    v_lshl_or_b32 v19, v38, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_mov_b32_e32 v6, s12
; GFX9-NEXT:    v_mov_b32_e32 v7, s13
; GFX9-NEXT:    v_mov_b32_e32 v8, s14
; GFX9-NEXT:    v_mov_b32_e32 v9, s15
; GFX9-NEXT:    v_mov_b32_e32 v10, s16
; GFX9-NEXT:    v_mov_b32_e32 v11, s17
; GFX9-NEXT:    v_mov_b32_e32 v12, s18
; GFX9-NEXT:    v_mov_b32_e32 v13, s19
; GFX9-NEXT:    s_cbranch_execnz .LBB15_3
; GFX9-NEXT:  .LBB15_2: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff, v37
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v36
; GFX9-NEXT:    v_and_b32_e32 v16, 0xffff, v35
; GFX9-NEXT:    v_and_b32_e32 v17, 0xffff, v34
; GFX9-NEXT:    v_and_b32_e32 v18, 0xffff, v33
; GFX9-NEXT:    v_and_b32_e32 v19, 0xffff, v32
; GFX9-NEXT:    v_lshl_or_b32 v14, v51, 16, v14
; GFX9-NEXT:    v_lshl_or_b32 v15, v50, 16, v15
; GFX9-NEXT:    v_lshl_or_b32 v16, v49, 16, v16
; GFX9-NEXT:    v_lshl_or_b32 v17, v48, 16, v17
; GFX9-NEXT:    v_lshl_or_b32 v18, v39, 16, v18
; GFX9-NEXT:    v_lshl_or_b32 v19, v38, 16, v19
; GFX9-NEXT:    v_pk_add_u16 v0, s6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, s11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, s12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, s13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, s14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v9, s15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v12, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB15_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB15_4:
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_branch .LBB15_2
;
; GFX11-TRUE16-LABEL: bitcast_v40i16_to_v20i32_scalar:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.h, 0
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.l, v1.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.l, v0.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v35, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.h, v32.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v34, 0xffff, v1
; GFX11-TRUE16-NEXT:    s_lshr_b32 s41, s29, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s42, s28, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s43, s27, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s44, s26, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s45, s25, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s15, s24, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s13, s22, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s12, s21, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s11, s20, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s10, s19, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s9, s18, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s8, s17, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s7, s16, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s6, s2, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s4, s0, 16
; GFX11-TRUE16-NEXT:    s_mov_b32 s40, 0
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s4, s0, s4
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s5, s1, s5
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s6, s2, s6
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s7, s16, s7
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s8, s17, s8
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s9, s18, s9
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s10, s19, s10
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s11, s20, s11
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s12, s21, s12
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s13, s22, s13
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s15, s24, s15
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s16, s25, s45
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s17, s26, s44
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s0, s27, s43
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s1, s28, s42
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s2, s29, s41
; GFX11-TRUE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-TRUE16-NEXT:    s_cbranch_scc0 .LBB15_4
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s3
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v4, s7 :: v_dual_mov_b32 v5, s8
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v6, s9 :: v_dual_mov_b32 v7, s10
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v8, s11 :: v_dual_mov_b32 v9, s12
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v10, s13 :: v_dual_mov_b32 v11, s14
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v12, s15 :: v_dual_mov_b32 v13, s16
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v14, s17 :: v_dual_mov_b32 v15, s0
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v16, s1 :: v_dual_mov_b32 v17, s2
; GFX11-TRUE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s40
; GFX11-TRUE16-NEXT:    s_cbranch_vccnz .LBB15_3
; GFX11-TRUE16-NEXT:  .LBB15_2: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v0, s4, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v1, s5, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v2, s6, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v4, s7, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v5, s8, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v6, s9, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v7, s10, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v8, s11, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v9, s12, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v10, s13, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v11, s14, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v12, s15, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v13, s16, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v14, s17, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v15, s0, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v16, s1, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v17, s2, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:  .LBB15_3: ; %end
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB15_4:
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-TRUE16-NEXT:    s_branch .LBB15_2
;
; GFX11-FAKE16-LABEL: bitcast_v40i16_to_v20i32_scalar:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v35, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v34, 0xffff, v1
; GFX11-FAKE16-NEXT:    s_lshr_b32 s41, s29, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s42, s28, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s43, s27, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s44, s26, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s45, s25, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s15, s24, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s13, s22, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s12, s21, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s11, s20, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s10, s19, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s9, s18, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s8, s17, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s7, s16, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s6, s2, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s4, s0, 16
; GFX11-FAKE16-NEXT:    s_mov_b32 s40, 0
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s4, s0, s4
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s5, s1, s5
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s6, s2, s6
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s7, s16, s7
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s8, s17, s8
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s9, s18, s9
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s10, s19, s10
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s11, s20, s11
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s12, s21, s12
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s13, s22, s13
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s15, s24, s15
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s16, s25, s45
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s17, s26, s44
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s0, s27, s43
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s1, s28, s42
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s2, s29, s41
; GFX11-FAKE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-FAKE16-NEXT:    s_cbranch_scc0 .LBB15_4
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s3
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v4, s7 :: v_dual_mov_b32 v5, s8
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v6, s9 :: v_dual_mov_b32 v7, s10
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v8, s11 :: v_dual_mov_b32 v9, s12
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v10, s13 :: v_dual_mov_b32 v11, s14
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v12, s15 :: v_dual_mov_b32 v13, s16
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v14, s17 :: v_dual_mov_b32 v15, s0
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v16, s1 :: v_dual_mov_b32 v17, s2
; GFX11-FAKE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s40
; GFX11-FAKE16-NEXT:    s_cbranch_vccnz .LBB15_3
; GFX11-FAKE16-NEXT:  .LBB15_2: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v0, s4, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v1, s5, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v2, s6, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v4, s7, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v5, s8, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v6, s9, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v7, s10, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v8, s11, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v9, s12, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v10, s13, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v11, s14, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v12, s15, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v13, s16, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v14, s17, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v15, s0, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v16, s1, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v17, s2, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:  .LBB15_3: ; %end
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB15_4:
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-FAKE16-NEXT:    s_branch .LBB15_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <40 x i16> %a, splat (i16 3)
  %a2 = bitcast <40 x i16> %a1 to <20 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <40 x i16> %a to <20 x i32>
  br label %end

end:
  %phi = phi <20 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x i32> %phi
}

define <40 x half> @bitcast_v20i32_to_v40f16(<20 x i32> %a, i32 %b) {
; SI-LABEL: bitcast_v20i32_to_v40f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v21
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB16_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v32, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v34, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v36, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v39, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v49, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v51, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v53, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v55, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v41, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v43, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v4
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_cvt_f32_f16_e32 v46, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v3
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_cvt_f32_f16_e32 v56, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v21, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v19
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_cvt_f32_f16_e32 v58, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v60, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v33, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v35, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v37, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v38, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v48, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v50, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v52, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v54, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v40, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v42, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v44, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v45, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v47, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v57, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v59, v1
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:  .LBB16_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB16_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_add_i32_e32 v20, vcc, 3, v20
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v60, 16, v1
; SI-NEXT:    v_lshrrev_b32_e32 v58, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v46, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v43, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v55, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v51, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v49, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v13
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v28, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v26, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v24, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v19
; SI-NEXT:    v_lshrrev_b32_e32 v21, 16, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v33, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v35, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v37, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v38, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v48, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v50, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v52, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v54, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v40, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v42, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v44, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v45, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v47, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v57, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v59, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v32, v32
; SI-NEXT:    v_cvt_f32_f16_e32 v34, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v36, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v39, v39
; SI-NEXT:    v_cvt_f32_f16_e32 v49, v49
; SI-NEXT:    v_cvt_f32_f16_e32 v51, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v53, v53
; SI-NEXT:    v_cvt_f32_f16_e32 v55, v55
; SI-NEXT:    v_cvt_f32_f16_e32 v41, v41
; SI-NEXT:    v_cvt_f32_f16_e32 v43, v43
; SI-NEXT:    v_cvt_f32_f16_e32 v46, v46
; SI-NEXT:    v_cvt_f32_f16_e32 v56, v56
; SI-NEXT:    v_cvt_f32_f16_e32 v58, v58
; SI-NEXT:    v_cvt_f32_f16_e32 v60, v60
; SI-NEXT:  .LBB16_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v60
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v59
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v58
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v57
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v2, v4, v2
; SI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v56
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v47
; SI-NEXT:    v_add_i32_e32 v3, vcc, 8, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v46
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v45
; SI-NEXT:    v_add_i32_e32 v3, vcc, 12, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v43
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v44
; SI-NEXT:    v_add_i32_e32 v3, vcc, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v41
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v42
; SI-NEXT:    v_add_i32_e32 v3, vcc, 20, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v55
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v40
; SI-NEXT:    v_add_i32_e32 v3, vcc, 24, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v53
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v54
; SI-NEXT:    v_add_i32_e32 v3, vcc, 28, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v51
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v52
; SI-NEXT:    v_add_i32_e32 v3, vcc, 32, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v49
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v50
; SI-NEXT:    v_add_i32_e32 v3, vcc, 36, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v39
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v48
; SI-NEXT:    v_add_i32_e32 v3, vcc, 40, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v38
; SI-NEXT:    v_add_i32_e32 v3, vcc, 44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v34
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v37
; SI-NEXT:    v_add_i32_e32 v3, vcc, 48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v32
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v35
; SI-NEXT:    v_add_i32_e32 v3, vcc, 52, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v30
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v33
; SI-NEXT:    v_add_i32_e32 v3, vcc, 56, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v31
; SI-NEXT:    v_add_i32_e32 v3, vcc, 60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v29
; SI-NEXT:    v_add_i32_e32 v3, vcc, 64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v27
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v25
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v23
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x4c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v20i32_to_v40f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr27
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr25
; VI-NEXT:    ; implicit-def: $vgpr24
; VI-NEXT:    ; implicit-def: $vgpr23
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr21
; VI-NEXT:    ; implicit-def: $vgpr20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB16_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; VI-NEXT:  .LBB16_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB16_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v19, vcc, 3, v19
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_add_u32_e32 v17, vcc, 3, v17
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_add_u32_e32 v15, vcc, 3, v15
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_add_u32_e32 v13, vcc, 3, v13
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_add_u32_e32 v11, vcc, 3, v11
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_add_u32_e32 v9, vcc, 3, v9
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_add_u32_e32 v7, vcc, 3, v7
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_add_u32_e32 v5, vcc, 3, v5
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_add_u32_e32 v3, vcc, 3, v3
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_add_u32_e32 v1, vcc, 3, v1
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; VI-NEXT:  .LBB16_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; VI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; VI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; VI-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; VI-NEXT:    v_lshlrev_b32_e32 v35, 16, v35
; VI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; VI-NEXT:    v_lshlrev_b32_e32 v33, 16, v33
; VI-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; VI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; VI-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; VI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; VI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; VI-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; VI-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; VI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; VI-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; VI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; VI-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; VI-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; VI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; VI-NEXT:    v_or_b32_sdwa v0, v0, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v8, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v9, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v10, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v11, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v12, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v13, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v14, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v15, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v16, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v17, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v18, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v19, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v20i32_to_v40f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr27
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr25
; GFX9-NEXT:    ; implicit-def: $vgpr24
; GFX9-NEXT:    ; implicit-def: $vgpr23
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr21
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB16_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX9-NEXT:  .LBB16_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB16_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_u32_e32 v19, 3, v19
; GFX9-NEXT:    v_add_u32_e32 v18, 3, v18
; GFX9-NEXT:    v_add_u32_e32 v17, 3, v17
; GFX9-NEXT:    v_add_u32_e32 v16, 3, v16
; GFX9-NEXT:    v_add_u32_e32 v15, 3, v15
; GFX9-NEXT:    v_add_u32_e32 v14, 3, v14
; GFX9-NEXT:    v_add_u32_e32 v13, 3, v13
; GFX9-NEXT:    v_add_u32_e32 v12, 3, v12
; GFX9-NEXT:    v_add_u32_e32 v11, 3, v11
; GFX9-NEXT:    v_add_u32_e32 v10, 3, v10
; GFX9-NEXT:    v_add_u32_e32 v9, 3, v9
; GFX9-NEXT:    v_add_u32_e32 v8, 3, v8
; GFX9-NEXT:    v_add_u32_e32 v7, 3, v7
; GFX9-NEXT:    v_add_u32_e32 v6, 3, v6
; GFX9-NEXT:    v_add_u32_e32 v5, 3, v5
; GFX9-NEXT:    v_add_u32_e32 v4, 3, v4
; GFX9-NEXT:    v_add_u32_e32 v3, 3, v3
; GFX9-NEXT:    v_add_u32_e32 v2, 3, v2
; GFX9-NEXT:    v_add_u32_e32 v1, 3, v1
; GFX9-NEXT:    v_add_u32_e32 v0, 3, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX9-NEXT:  .LBB16_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v39, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v38, v1, s4
; GFX9-NEXT:    v_perm_b32 v2, v37, v2, s4
; GFX9-NEXT:    v_perm_b32 v3, v36, v3, s4
; GFX9-NEXT:    v_perm_b32 v4, v35, v4, s4
; GFX9-NEXT:    v_perm_b32 v5, v34, v5, s4
; GFX9-NEXT:    v_perm_b32 v6, v33, v6, s4
; GFX9-NEXT:    v_perm_b32 v7, v32, v7, s4
; GFX9-NEXT:    v_perm_b32 v8, v31, v8, s4
; GFX9-NEXT:    v_perm_b32 v9, v30, v9, s4
; GFX9-NEXT:    v_perm_b32 v10, v29, v10, s4
; GFX9-NEXT:    v_perm_b32 v11, v28, v11, s4
; GFX9-NEXT:    v_perm_b32 v12, v27, v12, s4
; GFX9-NEXT:    v_perm_b32 v13, v26, v13, s4
; GFX9-NEXT:    v_perm_b32 v14, v25, v14, s4
; GFX9-NEXT:    v_perm_b32 v15, v24, v15, s4
; GFX9-NEXT:    v_perm_b32 v16, v23, v16, s4
; GFX9-NEXT:    v_perm_b32 v17, v22, v17, s4
; GFX9-NEXT:    v_perm_b32 v18, v21, v18, s4
; GFX9-NEXT:    v_perm_b32 v19, v20, v19, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v20i32_to_v40f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB16_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-TRUE16-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-TRUE16-NEXT:  .LBB16_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v20i32_to_v40f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr27
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr25
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr24
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr23
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr20
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB16_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX11-FAKE16-NEXT:  .LBB16_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB16_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v19, 3, v19
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v18, 3, v18
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v17, 3, v17
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v16, 3, v16
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v15, 3, v15
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v14, 3, v14
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v13, 3, v13
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v12, 3, v12
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v11, 3, v11
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v10, 3, v10
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v9, 3, v9
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v8, 3, v8
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v7, 3, v7
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v6, 3, v6
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v5, 3, v5
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v4, 3, v4
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v3, 3, v3
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v2, 3, v2
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v1, 3, v1
; GFX11-FAKE16-NEXT:    v_add_nc_u32_e32 v0, 3, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX11-FAKE16-NEXT:  .LBB16_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v39, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v38, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v37, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v36, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v35, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v34, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v33, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v32, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v31, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v30, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v29, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v28, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v27, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v26, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v25, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v24, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v23, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v22, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v21, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v20, v19, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <20 x i32> %a, splat (i32 3)
  %a2 = bitcast <20 x i32> %a1 to <40 x half>
  br label %end

cmp.false:
  %a3 = bitcast <20 x i32> %a to <40 x half>
  br label %end

end:
  %phi = phi <40 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <40 x half> %phi
}

define inreg <40 x half> @bitcast_v20i32_to_v40f16_scalar(<20 x i32> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v20i32_to_v40f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v7
; SI-NEXT:    v_readfirstlane_b32 s11, v1
; SI-NEXT:    v_readfirstlane_b32 s10, v2
; SI-NEXT:    v_readfirstlane_b32 s8, v3
; SI-NEXT:    v_readfirstlane_b32 s7, v4
; SI-NEXT:    v_readfirstlane_b32 s6, v5
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_readfirstlane_b32 s9, v6
; SI-NEXT:    s_cbranch_scc0 .LBB17_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s9, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    s_lshr_b32 s4, s6, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s4
; SI-NEXT:    s_lshr_b32 s4, s7, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s4
; SI-NEXT:    s_lshr_b32 s4, s8, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s4
; SI-NEXT:    s_lshr_b32 s4, s10, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s4
; SI-NEXT:    s_lshr_b32 s4, s11, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s4
; SI-NEXT:    s_lshr_b32 s4, s29, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s4
; SI-NEXT:    s_lshr_b32 s4, s28, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s4
; SI-NEXT:    s_lshr_b32 s4, s27, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v16, s4
; SI-NEXT:    s_lshr_b32 s4, s26, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v19, s4
; SI-NEXT:    s_lshr_b32 s4, s25, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v21, s4
; SI-NEXT:    s_lshr_b32 s4, s24, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v23, s4
; SI-NEXT:    s_lshr_b32 s4, s23, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v25, s4
; SI-NEXT:    s_lshr_b32 s4, s22, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v27, s4
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v29, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v31, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v34, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v36, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v38, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v48, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s9
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s8
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s10
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s11
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s29
; SI-NEXT:    v_cvt_f32_f16_e32 v17, s28
; SI-NEXT:    v_cvt_f32_f16_e32 v18, s27
; SI-NEXT:    v_cvt_f32_f16_e32 v20, s26
; SI-NEXT:    v_cvt_f32_f16_e32 v22, s25
; SI-NEXT:    v_cvt_f32_f16_e32 v24, s24
; SI-NEXT:    v_cvt_f32_f16_e32 v26, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v28, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v30, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v32, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v33, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v35, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v37, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v39, s16
; SI-NEXT:    s_cbranch_execnz .LBB17_3
; SI-NEXT:  .LBB17_2: ; %cmp.true
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    s_add_i32 s17, s17, 3
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    s_add_i32 s19, s19, 3
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    s_add_i32 s21, s21, 3
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    s_add_i32 s23, s23, 3
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    s_add_i32 s25, s25, 3
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    s_add_i32 s27, s27, 3
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    s_add_i32 s29, s29, 3
; SI-NEXT:    s_add_i32 s11, s11, 3
; SI-NEXT:    s_add_i32 s10, s10, 3
; SI-NEXT:    s_add_i32 s8, s8, 3
; SI-NEXT:    s_add_i32 s7, s7, 3
; SI-NEXT:    s_add_i32 s6, s6, 3
; SI-NEXT:    s_add_i32 s9, s9, 3
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    s_lshr_b32 s5, s17, 16
; SI-NEXT:    s_lshr_b32 s12, s18, 16
; SI-NEXT:    s_lshr_b32 s13, s19, 16
; SI-NEXT:    s_lshr_b32 s14, s20, 16
; SI-NEXT:    s_lshr_b32 s15, s21, 16
; SI-NEXT:    s_lshr_b32 s40, s22, 16
; SI-NEXT:    s_lshr_b32 s41, s23, 16
; SI-NEXT:    s_lshr_b32 s42, s24, 16
; SI-NEXT:    s_lshr_b32 s43, s25, 16
; SI-NEXT:    s_lshr_b32 s44, s26, 16
; SI-NEXT:    s_lshr_b32 s45, s27, 16
; SI-NEXT:    s_lshr_b32 s46, s28, 16
; SI-NEXT:    s_lshr_b32 s47, s29, 16
; SI-NEXT:    s_lshr_b32 s56, s11, 16
; SI-NEXT:    s_lshr_b32 s57, s10, 16
; SI-NEXT:    s_lshr_b32 s58, s8, 16
; SI-NEXT:    s_lshr_b32 s59, s7, 16
; SI-NEXT:    s_lshr_b32 s60, s6, 16
; SI-NEXT:    s_lshr_b32 s61, s9, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s9
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s8
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s10
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s11
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s29
; SI-NEXT:    v_cvt_f32_f16_e32 v17, s28
; SI-NEXT:    v_cvt_f32_f16_e32 v18, s27
; SI-NEXT:    v_cvt_f32_f16_e32 v20, s26
; SI-NEXT:    v_cvt_f32_f16_e32 v22, s25
; SI-NEXT:    v_cvt_f32_f16_e32 v24, s24
; SI-NEXT:    v_cvt_f32_f16_e32 v26, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v28, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v30, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v32, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v33, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v35, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v37, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v39, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s61
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s60
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s59
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s58
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s57
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s56
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s47
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s46
; SI-NEXT:    v_cvt_f32_f16_e32 v16, s45
; SI-NEXT:    v_cvt_f32_f16_e32 v19, s44
; SI-NEXT:    v_cvt_f32_f16_e32 v21, s43
; SI-NEXT:    v_cvt_f32_f16_e32 v23, s42
; SI-NEXT:    v_cvt_f32_f16_e32 v25, s41
; SI-NEXT:    v_cvt_f32_f16_e32 v27, s40
; SI-NEXT:    v_cvt_f32_f16_e32 v29, s15
; SI-NEXT:    v_cvt_f32_f16_e32 v31, s14
; SI-NEXT:    v_cvt_f32_f16_e32 v34, s13
; SI-NEXT:    v_cvt_f32_f16_e32 v36, s12
; SI-NEXT:    v_cvt_f32_f16_e32 v38, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v48, s4
; SI-NEXT:  .LBB17_3: ; %end
; SI-NEXT:    v_cvt_f16_f32_e32 v48, v48
; SI-NEXT:    v_cvt_f16_f32_e32 v39, v39
; SI-NEXT:    v_cvt_f16_f32_e32 v38, v38
; SI-NEXT:    v_cvt_f16_f32_e32 v37, v37
; SI-NEXT:    v_cvt_f16_f32_e32 v36, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v35, v35
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v34
; SI-NEXT:    v_lshlrev_b32_e32 v48, 16, v48
; SI-NEXT:    v_cvt_f16_f32_e32 v33, v33
; SI-NEXT:    v_cvt_f16_f32_e32 v31, v31
; SI-NEXT:    v_or_b32_e32 v39, v39, v48
; SI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v32
; SI-NEXT:    v_cvt_f16_f32_e32 v29, v29
; SI-NEXT:    buffer_store_dword v39, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v39, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v37, v37, v38
; SI-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v30, v30
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v27
; SI-NEXT:    buffer_store_dword v37, v39, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v37, vcc, 8, v0
; SI-NEXT:    v_or_b32_e32 v35, v35, v36
; SI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v25, v25
; SI-NEXT:    buffer_store_dword v35, v37, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v35, vcc, 12, v0
; SI-NEXT:    v_or_b32_e32 v33, v33, v34
; SI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v23
; SI-NEXT:    buffer_store_dword v33, v35, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v33, vcc, 16, v0
; SI-NEXT:    v_or_b32_e32 v31, v32, v31
; SI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v21
; SI-NEXT:    buffer_store_dword v31, v33, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v31, vcc, 20, v0
; SI-NEXT:    v_or_b32_e32 v29, v30, v29
; SI-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    buffer_store_dword v29, v31, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v29, vcc, 24, v0
; SI-NEXT:    v_or_b32_e32 v27, v28, v27
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    buffer_store_dword v27, v29, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v27, vcc, 28, v0
; SI-NEXT:    v_or_b32_e32 v25, v26, v25
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    buffer_store_dword v25, v27, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v25, vcc, 32, v0
; SI-NEXT:    v_or_b32_e32 v23, v24, v23
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; SI-NEXT:    buffer_store_dword v23, v25, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v23, vcc, 36, v0
; SI-NEXT:    v_or_b32_e32 v21, v22, v21
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; SI-NEXT:    buffer_store_dword v21, v23, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v21, vcc, 40, v0
; SI-NEXT:    v_or_b32_e32 v19, v20, v19
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; SI-NEXT:    buffer_store_dword v19, v21, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v19, vcc, 44, v0
; SI-NEXT:    v_or_b32_e32 v16, v18, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    buffer_store_dword v16, v19, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v17
; SI-NEXT:    v_add_i32_e32 v17, vcc, 48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v16, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    buffer_store_dword v14, v17, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v15
; SI-NEXT:    v_add_i32_e32 v15, vcc, 52, v0
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_or_b32_e32 v12, v14, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    buffer_store_dword v12, v15, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v13
; SI-NEXT:    v_add_i32_e32 v13, vcc, 56, v0
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v12, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    buffer_store_dword v10, v13, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v11
; SI-NEXT:    v_add_i32_e32 v11, vcc, 60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v10, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    buffer_store_dword v8, v11, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v9
; SI-NEXT:    v_add_i32_e32 v9, vcc, 64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    buffer_store_dword v6, v9, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v7
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    buffer_store_dword v4, v7, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v5
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v4, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    buffer_store_dword v2, v5, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v3
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x4c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB17_4:
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    s_branch .LBB17_2
;
; VI-LABEL: bitcast_v20i32_to_v40f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    v_readfirstlane_b32 s11, v0
; VI-NEXT:    v_readfirstlane_b32 s10, v1
; VI-NEXT:    v_readfirstlane_b32 s9, v2
; VI-NEXT:    v_readfirstlane_b32 s8, v3
; VI-NEXT:    v_readfirstlane_b32 s6, v4
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_readfirstlane_b32 s7, v5
; VI-NEXT:    s_cbranch_scc0 .LBB17_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s12, s7, 16
; VI-NEXT:    s_lshr_b32 s13, s6, 16
; VI-NEXT:    s_lshr_b32 s14, s8, 16
; VI-NEXT:    s_lshr_b32 s15, s9, 16
; VI-NEXT:    s_lshr_b32 s40, s10, 16
; VI-NEXT:    s_lshr_b32 s41, s11, 16
; VI-NEXT:    s_lshr_b32 s42, s29, 16
; VI-NEXT:    s_lshr_b32 s43, s28, 16
; VI-NEXT:    s_lshr_b32 s44, s27, 16
; VI-NEXT:    s_lshr_b32 s45, s26, 16
; VI-NEXT:    s_lshr_b32 s46, s25, 16
; VI-NEXT:    s_lshr_b32 s47, s24, 16
; VI-NEXT:    s_lshr_b32 s56, s23, 16
; VI-NEXT:    s_lshr_b32 s57, s22, 16
; VI-NEXT:    s_lshr_b32 s58, s21, 16
; VI-NEXT:    s_lshr_b32 s59, s20, 16
; VI-NEXT:    s_lshr_b32 s60, s19, 16
; VI-NEXT:    s_lshr_b32 s61, s18, 16
; VI-NEXT:    s_lshr_b32 s62, s17, 16
; VI-NEXT:    s_lshr_b32 s63, s16, 16
; VI-NEXT:    s_cbranch_execnz .LBB17_3
; VI-NEXT:  .LBB17_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s7, s7, 3
; VI-NEXT:    s_add_i32 s6, s6, 3
; VI-NEXT:    s_add_i32 s8, s8, 3
; VI-NEXT:    s_add_i32 s9, s9, 3
; VI-NEXT:    s_add_i32 s10, s10, 3
; VI-NEXT:    s_add_i32 s11, s11, 3
; VI-NEXT:    s_add_i32 s29, s29, 3
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    s_add_i32 s27, s27, 3
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    s_add_i32 s25, s25, 3
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_lshr_b32 s12, s7, 16
; VI-NEXT:    s_lshr_b32 s13, s6, 16
; VI-NEXT:    s_lshr_b32 s14, s8, 16
; VI-NEXT:    s_lshr_b32 s15, s9, 16
; VI-NEXT:    s_lshr_b32 s40, s10, 16
; VI-NEXT:    s_lshr_b32 s41, s11, 16
; VI-NEXT:    s_lshr_b32 s42, s29, 16
; VI-NEXT:    s_lshr_b32 s43, s28, 16
; VI-NEXT:    s_lshr_b32 s44, s27, 16
; VI-NEXT:    s_lshr_b32 s45, s26, 16
; VI-NEXT:    s_lshr_b32 s46, s25, 16
; VI-NEXT:    s_lshr_b32 s47, s24, 16
; VI-NEXT:    s_lshr_b32 s56, s23, 16
; VI-NEXT:    s_lshr_b32 s57, s22, 16
; VI-NEXT:    s_lshr_b32 s58, s21, 16
; VI-NEXT:    s_lshr_b32 s59, s20, 16
; VI-NEXT:    s_lshr_b32 s60, s19, 16
; VI-NEXT:    s_lshr_b32 s61, s18, 16
; VI-NEXT:    s_lshr_b32 s62, s17, 16
; VI-NEXT:    s_lshr_b32 s63, s16, 16
; VI-NEXT:  .LBB17_3: ; %end
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s63, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s16, s62, 16
; VI-NEXT:    s_or_b32 s5, s5, s16
; VI-NEXT:    s_and_b32 s16, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s17, s61, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s17, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s18, s60, 16
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s18, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s19, s59, 16
; VI-NEXT:    s_or_b32 s18, s18, s19
; VI-NEXT:    s_and_b32 s19, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s20, s58, 16
; VI-NEXT:    s_or_b32 s19, s19, s20
; VI-NEXT:    s_and_b32 s20, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s21, s57, 16
; VI-NEXT:    s_or_b32 s20, s20, s21
; VI-NEXT:    s_and_b32 s21, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s22, s56, 16
; VI-NEXT:    s_or_b32 s21, s21, s22
; VI-NEXT:    s_and_b32 s22, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s23, s47, 16
; VI-NEXT:    s_or_b32 s22, s22, s23
; VI-NEXT:    s_and_b32 s23, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s24, s46, 16
; VI-NEXT:    s_or_b32 s23, s23, s24
; VI-NEXT:    s_and_b32 s24, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s25, s45, 16
; VI-NEXT:    s_or_b32 s24, s24, s25
; VI-NEXT:    s_and_b32 s25, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s26, s44, 16
; VI-NEXT:    s_or_b32 s25, s25, s26
; VI-NEXT:    s_and_b32 s26, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s27, s43, 16
; VI-NEXT:    s_or_b32 s26, s26, s27
; VI-NEXT:    s_and_b32 s27, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s28, s42, 16
; VI-NEXT:    s_or_b32 s27, s27, s28
; VI-NEXT:    s_and_b32 s11, 0xffff, s11
; VI-NEXT:    s_lshl_b32 s28, s41, 16
; VI-NEXT:    s_or_b32 s11, s11, s28
; VI-NEXT:    s_and_b32 s10, 0xffff, s10
; VI-NEXT:    s_lshl_b32 s28, s40, 16
; VI-NEXT:    s_and_b32 s9, 0xffff, s9
; VI-NEXT:    s_lshl_b32 s15, s15, 16
; VI-NEXT:    s_and_b32 s8, 0xffff, s8
; VI-NEXT:    s_lshl_b32 s14, s14, 16
; VI-NEXT:    s_and_b32 s6, 0xffff, s6
; VI-NEXT:    s_lshl_b32 s13, s13, 16
; VI-NEXT:    s_and_b32 s7, 0xffff, s7
; VI-NEXT:    s_lshl_b32 s12, s12, 16
; VI-NEXT:    s_or_b32 s10, s10, s28
; VI-NEXT:    s_or_b32 s9, s9, s15
; VI-NEXT:    s_or_b32 s8, s8, s14
; VI-NEXT:    s_or_b32 s6, s6, s13
; VI-NEXT:    s_or_b32 s7, s7, s12
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    v_mov_b32_e32 v3, s17
; VI-NEXT:    v_mov_b32_e32 v4, s18
; VI-NEXT:    v_mov_b32_e32 v5, s19
; VI-NEXT:    v_mov_b32_e32 v6, s20
; VI-NEXT:    v_mov_b32_e32 v7, s21
; VI-NEXT:    v_mov_b32_e32 v8, s22
; VI-NEXT:    v_mov_b32_e32 v9, s23
; VI-NEXT:    v_mov_b32_e32 v10, s24
; VI-NEXT:    v_mov_b32_e32 v11, s25
; VI-NEXT:    v_mov_b32_e32 v12, s26
; VI-NEXT:    v_mov_b32_e32 v13, s27
; VI-NEXT:    v_mov_b32_e32 v14, s11
; VI-NEXT:    v_mov_b32_e32 v15, s10
; VI-NEXT:    v_mov_b32_e32 v16, s9
; VI-NEXT:    v_mov_b32_e32 v17, s8
; VI-NEXT:    v_mov_b32_e32 v18, s6
; VI-NEXT:    v_mov_b32_e32 v19, s7
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB17_4:
; VI-NEXT:    ; implicit-def: $sgpr63
; VI-NEXT:    ; implicit-def: $sgpr62
; VI-NEXT:    ; implicit-def: $sgpr61
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr59
; VI-NEXT:    ; implicit-def: $sgpr58
; VI-NEXT:    ; implicit-def: $sgpr57
; VI-NEXT:    ; implicit-def: $sgpr56
; VI-NEXT:    ; implicit-def: $sgpr47
; VI-NEXT:    ; implicit-def: $sgpr46
; VI-NEXT:    ; implicit-def: $sgpr45
; VI-NEXT:    ; implicit-def: $sgpr44
; VI-NEXT:    ; implicit-def: $sgpr43
; VI-NEXT:    ; implicit-def: $sgpr42
; VI-NEXT:    ; implicit-def: $sgpr41
; VI-NEXT:    ; implicit-def: $sgpr40
; VI-NEXT:    ; implicit-def: $sgpr15
; VI-NEXT:    ; implicit-def: $sgpr14
; VI-NEXT:    ; implicit-def: $sgpr13
; VI-NEXT:    ; implicit-def: $sgpr12
; VI-NEXT:    s_branch .LBB17_2
;
; GFX9-LABEL: bitcast_v20i32_to_v40f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    v_readfirstlane_b32 s6, v0
; GFX9-NEXT:    v_readfirstlane_b32 s7, v1
; GFX9-NEXT:    v_readfirstlane_b32 s8, v2
; GFX9-NEXT:    v_readfirstlane_b32 s9, v3
; GFX9-NEXT:    v_readfirstlane_b32 s10, v4
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_readfirstlane_b32 s11, v5
; GFX9-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s12, s11, 16
; GFX9-NEXT:    s_lshr_b32 s13, s10, 16
; GFX9-NEXT:    s_lshr_b32 s14, s9, 16
; GFX9-NEXT:    s_lshr_b32 s15, s8, 16
; GFX9-NEXT:    s_lshr_b32 s40, s7, 16
; GFX9-NEXT:    s_lshr_b32 s41, s6, 16
; GFX9-NEXT:    s_lshr_b32 s42, s29, 16
; GFX9-NEXT:    s_lshr_b32 s43, s28, 16
; GFX9-NEXT:    s_lshr_b32 s44, s27, 16
; GFX9-NEXT:    s_lshr_b32 s45, s26, 16
; GFX9-NEXT:    s_lshr_b32 s46, s25, 16
; GFX9-NEXT:    s_lshr_b32 s47, s24, 16
; GFX9-NEXT:    s_lshr_b32 s56, s23, 16
; GFX9-NEXT:    s_lshr_b32 s57, s22, 16
; GFX9-NEXT:    s_lshr_b32 s58, s21, 16
; GFX9-NEXT:    s_lshr_b32 s59, s20, 16
; GFX9-NEXT:    s_lshr_b32 s60, s19, 16
; GFX9-NEXT:    s_lshr_b32 s61, s18, 16
; GFX9-NEXT:    s_lshr_b32 s62, s17, 16
; GFX9-NEXT:    s_lshr_b32 s63, s16, 16
; GFX9-NEXT:    s_cbranch_execnz .LBB17_3
; GFX9-NEXT:  .LBB17_2: ; %cmp.true
; GFX9-NEXT:    s_add_i32 s11, s11, 3
; GFX9-NEXT:    s_add_i32 s10, s10, 3
; GFX9-NEXT:    s_add_i32 s9, s9, 3
; GFX9-NEXT:    s_add_i32 s8, s8, 3
; GFX9-NEXT:    s_add_i32 s7, s7, 3
; GFX9-NEXT:    s_add_i32 s6, s6, 3
; GFX9-NEXT:    s_add_i32 s29, s29, 3
; GFX9-NEXT:    s_add_i32 s28, s28, 3
; GFX9-NEXT:    s_add_i32 s27, s27, 3
; GFX9-NEXT:    s_add_i32 s26, s26, 3
; GFX9-NEXT:    s_add_i32 s25, s25, 3
; GFX9-NEXT:    s_add_i32 s24, s24, 3
; GFX9-NEXT:    s_add_i32 s23, s23, 3
; GFX9-NEXT:    s_add_i32 s22, s22, 3
; GFX9-NEXT:    s_add_i32 s21, s21, 3
; GFX9-NEXT:    s_add_i32 s20, s20, 3
; GFX9-NEXT:    s_add_i32 s19, s19, 3
; GFX9-NEXT:    s_add_i32 s18, s18, 3
; GFX9-NEXT:    s_add_i32 s17, s17, 3
; GFX9-NEXT:    s_add_i32 s16, s16, 3
; GFX9-NEXT:    s_lshr_b32 s12, s11, 16
; GFX9-NEXT:    s_lshr_b32 s13, s10, 16
; GFX9-NEXT:    s_lshr_b32 s14, s9, 16
; GFX9-NEXT:    s_lshr_b32 s15, s8, 16
; GFX9-NEXT:    s_lshr_b32 s40, s7, 16
; GFX9-NEXT:    s_lshr_b32 s41, s6, 16
; GFX9-NEXT:    s_lshr_b32 s42, s29, 16
; GFX9-NEXT:    s_lshr_b32 s43, s28, 16
; GFX9-NEXT:    s_lshr_b32 s44, s27, 16
; GFX9-NEXT:    s_lshr_b32 s45, s26, 16
; GFX9-NEXT:    s_lshr_b32 s46, s25, 16
; GFX9-NEXT:    s_lshr_b32 s47, s24, 16
; GFX9-NEXT:    s_lshr_b32 s56, s23, 16
; GFX9-NEXT:    s_lshr_b32 s57, s22, 16
; GFX9-NEXT:    s_lshr_b32 s58, s21, 16
; GFX9-NEXT:    s_lshr_b32 s59, s20, 16
; GFX9-NEXT:    s_lshr_b32 s60, s19, 16
; GFX9-NEXT:    s_lshr_b32 s61, s18, 16
; GFX9-NEXT:    s_lshr_b32 s62, s17, 16
; GFX9-NEXT:    s_lshr_b32 s63, s16, 16
; GFX9-NEXT:  .LBB17_3: ; %end
; GFX9-NEXT:    s_pack_ll_b32_b16 s4, s16, s63
; GFX9-NEXT:    s_pack_ll_b32_b16 s5, s17, s62
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s18, s61
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s19, s60
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s20, s59
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s21, s58
; GFX9-NEXT:    s_pack_ll_b32_b16 s20, s22, s57
; GFX9-NEXT:    s_pack_ll_b32_b16 s21, s23, s56
; GFX9-NEXT:    s_pack_ll_b32_b16 s22, s24, s47
; GFX9-NEXT:    s_pack_ll_b32_b16 s23, s25, s46
; GFX9-NEXT:    s_pack_ll_b32_b16 s24, s26, s45
; GFX9-NEXT:    s_pack_ll_b32_b16 s25, s27, s44
; GFX9-NEXT:    s_pack_ll_b32_b16 s26, s28, s43
; GFX9-NEXT:    s_pack_ll_b32_b16 s27, s29, s42
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s6, s41
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s7, s40
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s8, s15
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s9, s14
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s10, s13
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s11, s12
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s16
; GFX9-NEXT:    v_mov_b32_e32 v3, s17
; GFX9-NEXT:    v_mov_b32_e32 v4, s18
; GFX9-NEXT:    v_mov_b32_e32 v5, s19
; GFX9-NEXT:    v_mov_b32_e32 v6, s20
; GFX9-NEXT:    v_mov_b32_e32 v7, s21
; GFX9-NEXT:    v_mov_b32_e32 v8, s22
; GFX9-NEXT:    v_mov_b32_e32 v9, s23
; GFX9-NEXT:    v_mov_b32_e32 v10, s24
; GFX9-NEXT:    v_mov_b32_e32 v11, s25
; GFX9-NEXT:    v_mov_b32_e32 v12, s26
; GFX9-NEXT:    v_mov_b32_e32 v13, s27
; GFX9-NEXT:    v_mov_b32_e32 v14, s6
; GFX9-NEXT:    v_mov_b32_e32 v15, s7
; GFX9-NEXT:    v_mov_b32_e32 v16, s8
; GFX9-NEXT:    v_mov_b32_e32 v17, s9
; GFX9-NEXT:    v_mov_b32_e32 v18, s10
; GFX9-NEXT:    v_mov_b32_e32 v19, s11
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB17_4:
; GFX9-NEXT:    ; implicit-def: $sgpr63
; GFX9-NEXT:    ; implicit-def: $sgpr62
; GFX9-NEXT:    ; implicit-def: $sgpr61
; GFX9-NEXT:    ; implicit-def: $sgpr60
; GFX9-NEXT:    ; implicit-def: $sgpr59
; GFX9-NEXT:    ; implicit-def: $sgpr58
; GFX9-NEXT:    ; implicit-def: $sgpr57
; GFX9-NEXT:    ; implicit-def: $sgpr56
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr46
; GFX9-NEXT:    ; implicit-def: $sgpr45
; GFX9-NEXT:    ; implicit-def: $sgpr44
; GFX9-NEXT:    ; implicit-def: $sgpr43
; GFX9-NEXT:    ; implicit-def: $sgpr42
; GFX9-NEXT:    ; implicit-def: $sgpr41
; GFX9-NEXT:    ; implicit-def: $sgpr40
; GFX9-NEXT:    ; implicit-def: $sgpr15
; GFX9-NEXT:    ; implicit-def: $sgpr14
; GFX9-NEXT:    ; implicit-def: $sgpr13
; GFX9-NEXT:    ; implicit-def: $sgpr12
; GFX9-NEXT:    s_branch .LBB17_2
;
; GFX11-LABEL: bitcast_v20i32_to_v40f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-NEXT:    v_readfirstlane_b32 s5, v0
; GFX11-NEXT:    v_readfirstlane_b32 s4, v1
; GFX11-NEXT:    s_mov_b32 s58, 0
; GFX11-NEXT:    s_and_b32 s6, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB17_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s6, s4, 16
; GFX11-NEXT:    s_lshr_b32 s7, s5, 16
; GFX11-NEXT:    s_lshr_b32 s8, s29, 16
; GFX11-NEXT:    s_lshr_b32 s9, s28, 16
; GFX11-NEXT:    s_lshr_b32 s10, s27, 16
; GFX11-NEXT:    s_lshr_b32 s11, s26, 16
; GFX11-NEXT:    s_lshr_b32 s12, s25, 16
; GFX11-NEXT:    s_lshr_b32 s13, s24, 16
; GFX11-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-NEXT:    s_lshr_b32 s15, s22, 16
; GFX11-NEXT:    s_lshr_b32 s40, s21, 16
; GFX11-NEXT:    s_lshr_b32 s41, s20, 16
; GFX11-NEXT:    s_lshr_b32 s42, s19, 16
; GFX11-NEXT:    s_lshr_b32 s43, s18, 16
; GFX11-NEXT:    s_lshr_b32 s44, s17, 16
; GFX11-NEXT:    s_lshr_b32 s45, s16, 16
; GFX11-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-NEXT:    s_lshr_b32 s47, s2, 16
; GFX11-NEXT:    s_lshr_b32 s56, s1, 16
; GFX11-NEXT:    s_lshr_b32 s57, s0, 16
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s58
; GFX11-NEXT:    s_cbranch_vccnz .LBB17_3
; GFX11-NEXT:  .LBB17_2: ; %cmp.true
; GFX11-NEXT:    s_add_i32 s4, s4, 3
; GFX11-NEXT:    s_add_i32 s5, s5, 3
; GFX11-NEXT:    s_add_i32 s29, s29, 3
; GFX11-NEXT:    s_add_i32 s28, s28, 3
; GFX11-NEXT:    s_add_i32 s27, s27, 3
; GFX11-NEXT:    s_add_i32 s26, s26, 3
; GFX11-NEXT:    s_add_i32 s25, s25, 3
; GFX11-NEXT:    s_add_i32 s24, s24, 3
; GFX11-NEXT:    s_add_i32 s23, s23, 3
; GFX11-NEXT:    s_add_i32 s22, s22, 3
; GFX11-NEXT:    s_add_i32 s21, s21, 3
; GFX11-NEXT:    s_add_i32 s20, s20, 3
; GFX11-NEXT:    s_add_i32 s19, s19, 3
; GFX11-NEXT:    s_add_i32 s18, s18, 3
; GFX11-NEXT:    s_add_i32 s17, s17, 3
; GFX11-NEXT:    s_add_i32 s16, s16, 3
; GFX11-NEXT:    s_add_i32 s3, s3, 3
; GFX11-NEXT:    s_add_i32 s2, s2, 3
; GFX11-NEXT:    s_add_i32 s1, s1, 3
; GFX11-NEXT:    s_add_i32 s0, s0, 3
; GFX11-NEXT:    s_lshr_b32 s6, s4, 16
; GFX11-NEXT:    s_lshr_b32 s7, s5, 16
; GFX11-NEXT:    s_lshr_b32 s8, s29, 16
; GFX11-NEXT:    s_lshr_b32 s9, s28, 16
; GFX11-NEXT:    s_lshr_b32 s10, s27, 16
; GFX11-NEXT:    s_lshr_b32 s11, s26, 16
; GFX11-NEXT:    s_lshr_b32 s12, s25, 16
; GFX11-NEXT:    s_lshr_b32 s13, s24, 16
; GFX11-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-NEXT:    s_lshr_b32 s15, s22, 16
; GFX11-NEXT:    s_lshr_b32 s40, s21, 16
; GFX11-NEXT:    s_lshr_b32 s41, s20, 16
; GFX11-NEXT:    s_lshr_b32 s42, s19, 16
; GFX11-NEXT:    s_lshr_b32 s43, s18, 16
; GFX11-NEXT:    s_lshr_b32 s44, s17, 16
; GFX11-NEXT:    s_lshr_b32 s45, s16, 16
; GFX11-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-NEXT:    s_lshr_b32 s47, s2, 16
; GFX11-NEXT:    s_lshr_b32 s56, s1, 16
; GFX11-NEXT:    s_lshr_b32 s57, s0, 16
; GFX11-NEXT:  .LBB17_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_pack_ll_b32_b16 s0, s0, s57
; GFX11-NEXT:    s_pack_ll_b32_b16 s1, s1, s56
; GFX11-NEXT:    s_pack_ll_b32_b16 s2, s2, s47
; GFX11-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-NEXT:    s_pack_ll_b32_b16 s16, s16, s45
; GFX11-NEXT:    s_pack_ll_b32_b16 s17, s17, s44
; GFX11-NEXT:    s_pack_ll_b32_b16 s18, s18, s43
; GFX11-NEXT:    s_pack_ll_b32_b16 s19, s19, s42
; GFX11-NEXT:    s_pack_ll_b32_b16 s20, s20, s41
; GFX11-NEXT:    s_pack_ll_b32_b16 s21, s21, s40
; GFX11-NEXT:    s_pack_ll_b32_b16 s15, s22, s15
; GFX11-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-NEXT:    s_pack_ll_b32_b16 s13, s24, s13
; GFX11-NEXT:    s_pack_ll_b32_b16 s12, s25, s12
; GFX11-NEXT:    s_pack_ll_b32_b16 s11, s26, s11
; GFX11-NEXT:    s_pack_ll_b32_b16 s10, s27, s10
; GFX11-NEXT:    s_pack_ll_b32_b16 s9, s28, s9
; GFX11-NEXT:    s_pack_ll_b32_b16 s8, s29, s8
; GFX11-NEXT:    s_pack_ll_b32_b16 s5, s5, s7
; GFX11-NEXT:    s_pack_ll_b32_b16 s4, s4, s6
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s15 :: v_dual_mov_b32 v11, s14
; GFX11-NEXT:    v_dual_mov_b32 v12, s13 :: v_dual_mov_b32 v13, s12
; GFX11-NEXT:    v_dual_mov_b32 v14, s11 :: v_dual_mov_b32 v15, s10
; GFX11-NEXT:    v_dual_mov_b32 v16, s9 :: v_dual_mov_b32 v17, s8
; GFX11-NEXT:    v_dual_mov_b32 v18, s5 :: v_dual_mov_b32 v19, s4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB17_4:
; GFX11-NEXT:    ; implicit-def: $sgpr57
; GFX11-NEXT:    ; implicit-def: $sgpr56
; GFX11-NEXT:    ; implicit-def: $sgpr47
; GFX11-NEXT:    ; implicit-def: $sgpr46
; GFX11-NEXT:    ; implicit-def: $sgpr45
; GFX11-NEXT:    ; implicit-def: $sgpr44
; GFX11-NEXT:    ; implicit-def: $sgpr43
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr41
; GFX11-NEXT:    ; implicit-def: $sgpr40
; GFX11-NEXT:    ; implicit-def: $sgpr15
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    ; implicit-def: $sgpr13
; GFX11-NEXT:    ; implicit-def: $sgpr12
; GFX11-NEXT:    ; implicit-def: $sgpr11
; GFX11-NEXT:    ; implicit-def: $sgpr10
; GFX11-NEXT:    ; implicit-def: $sgpr9
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr7
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    s_branch .LBB17_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <20 x i32> %a, splat (i32 3)
  %a2 = bitcast <20 x i32> %a1 to <40 x half>
  br label %end

cmp.false:
  %a3 = bitcast <20 x i32> %a to <40 x half>
  br label %end

end:
  %phi = phi <40 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <40 x half> %phi
}

define <20 x i32> @bitcast_v40f16_to_v20i32(<40 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v40f16_to_v20i32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v48, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v49, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:16
; SI-NEXT:    buffer_load_dword v51, off, s[0:3], s32 offset:12
; SI-NEXT:    buffer_load_dword v52, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v53, off, s[0:3], s32 offset:20
; SI-NEXT:    buffer_load_dword v54, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v55, off, s[0:3], s32 offset:28
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:36
; SI-NEXT:    v_cvt_f16_f32_e32 v38, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v39, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v37, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v36, v2
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v35, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v33, v7
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v63, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v62, v8
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v27
; SI-NEXT:    v_cvt_f16_f32_e32 v61, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v60, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v59, v13
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v58, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v57, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v56, v14
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v29
; SI-NEXT:    v_cvt_f16_f32_e32 v47, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v46, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v45, v19
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v44, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v43, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v42, v20
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v30
; SI-NEXT:    v_cvt_f16_f32_e32 v41, v23
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(14) expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v31
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v48
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_cvt_f16_f32_e32 v48, v55
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v49
; SI-NEXT:    v_cvt_f16_f32_e32 v49, v54
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v40
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v50
; SI-NEXT:    v_cvt_f16_f32_e32 v50, v53
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v51
; SI-NEXT:    v_cvt_f16_f32_e32 v51, v52
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB18_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v41
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v39
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v37
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v35
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v33
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v63
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v61
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v59
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v57
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v47
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v45
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v43
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v49
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    v_or_b32_e32 v0, v38, v0
; SI-NEXT:    v_or_b32_e32 v1, v36, v1
; SI-NEXT:    v_or_b32_e32 v2, v34, v2
; SI-NEXT:    v_or_b32_e32 v3, v32, v3
; SI-NEXT:    v_or_b32_e32 v4, v62, v4
; SI-NEXT:    v_or_b32_e32 v5, v60, v5
; SI-NEXT:    v_or_b32_e32 v6, v58, v6
; SI-NEXT:    v_or_b32_e32 v7, v56, v7
; SI-NEXT:    v_or_b32_e32 v8, v46, v8
; SI-NEXT:    v_or_b32_e32 v9, v44, v9
; SI-NEXT:    v_or_b32_e32 v10, v42, v10
; SI-NEXT:    v_or_b32_e32 v19, v48, v19
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v14, v13
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_or_b32_e32 v16, v17, v16
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    v_or_b32_e32 v17, v18, v17
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v51
; SI-NEXT:    v_or_b32_e32 v18, v50, v18
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:  .LBB18_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB18_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v39
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v37
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v38
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v36
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v35
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v32
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v62
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v33
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v60
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v58
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v63
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v57
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v56
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v61
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v46
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v43
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v59
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v42
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v49
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v47
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v45
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v48
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v20, 0x38000000, v20
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v10, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v44
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v20
; SI-NEXT:    v_add_f32_e32 v21, 0x38000000, v21
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v21
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_or_b32_e32 v9, v10, v9
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v41
; SI-NEXT:    v_or_b32_e32 v10, v12, v10
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_or_b32_e32 v11, v13, v11
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v14
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    v_or_b32_e32 v13, v15, v13
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v19, 0x38000000, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v16, v14
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v17
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v18
; SI-NEXT:    v_add_f32_e32 v18, 0x38000000, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    v_or_b32_e32 v16, v18, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v51
; SI-NEXT:    v_add_f32_e32 v18, 0x38000000, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    v_or_b32_e32 v17, v19, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v50
; SI-NEXT:    v_add_f32_e32 v19, 0x38000000, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    v_or_b32_e32 v18, v19, v18
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v20
; SI-NEXT:    v_or_b32_e32 v19, v21, v19
; SI-NEXT:  .LBB18_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v40f16_to_v20i32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    v_mov_b32_e32 v32, v19
; VI-NEXT:    v_mov_b32_e32 v33, v18
; VI-NEXT:    v_mov_b32_e32 v34, v17
; VI-NEXT:    v_mov_b32_e32 v35, v16
; VI-NEXT:    v_mov_b32_e32 v36, v15
; VI-NEXT:    v_mov_b32_e32 v37, v14
; VI-NEXT:    v_mov_b32_e32 v38, v13
; VI-NEXT:    v_mov_b32_e32 v39, v12
; VI-NEXT:    v_mov_b32_e32 v48, v11
; VI-NEXT:    v_mov_b32_e32 v49, v10
; VI-NEXT:    v_mov_b32_e32 v50, v9
; VI-NEXT:    v_mov_b32_e32 v51, v8
; VI-NEXT:    v_mov_b32_e32 v52, v7
; VI-NEXT:    v_mov_b32_e32 v53, v6
; VI-NEXT:    v_mov_b32_e32 v54, v5
; VI-NEXT:    v_mov_b32_e32 v55, v4
; VI-NEXT:    v_mov_b32_e32 v40, v3
; VI-NEXT:    v_mov_b32_e32 v41, v2
; VI-NEXT:    v_mov_b32_e32 v42, v1
; VI-NEXT:    v_mov_b32_e32 v43, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB18_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_mov_b32_e32 v19, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v19, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v19, v42 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v19, v41 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v3, v19, v40 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v4, v19, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v5, v19, v54 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v6, v19, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v7, v19, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v8, v19, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v9, v19, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v10, v19, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v11, v19, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v12, v19, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v13, v19, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v14, v19, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v15, v19, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v16, v19, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v17, v19, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v18, v19, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v19, v19, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v43, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v42, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v41, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v40, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v55, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v54, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v53, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v52, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v51, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v50, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v49, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v48, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v39, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v38, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v37, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v36, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v35, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v34, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v33, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v32, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:  .LBB18_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB18_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v19, 0x200
; VI-NEXT:    v_add_f16_sdwa v0, v43, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v43
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    v_add_f16_sdwa v1, v42, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v42
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    v_add_f16_sdwa v2, v41, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v41
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_add_f16_sdwa v3, v40, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v40
; VI-NEXT:    v_or_b32_e32 v3, v4, v3
; VI-NEXT:    v_add_f16_sdwa v4, v55, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v55
; VI-NEXT:    v_or_b32_e32 v4, v5, v4
; VI-NEXT:    v_add_f16_sdwa v5, v54, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v54
; VI-NEXT:    v_or_b32_e32 v5, v6, v5
; VI-NEXT:    v_add_f16_sdwa v6, v53, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, 0x200, v53
; VI-NEXT:    v_or_b32_e32 v6, v7, v6
; VI-NEXT:    v_add_f16_sdwa v7, v52, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, 0x200, v52
; VI-NEXT:    v_or_b32_e32 v7, v8, v7
; VI-NEXT:    v_add_f16_sdwa v8, v51, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v9, 0x200, v51
; VI-NEXT:    v_or_b32_e32 v8, v9, v8
; VI-NEXT:    v_add_f16_sdwa v9, v50, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v10, 0x200, v50
; VI-NEXT:    v_or_b32_e32 v9, v10, v9
; VI-NEXT:    v_add_f16_sdwa v10, v49, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v11, 0x200, v49
; VI-NEXT:    v_or_b32_e32 v10, v11, v10
; VI-NEXT:    v_add_f16_sdwa v11, v48, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v12, 0x200, v48
; VI-NEXT:    v_or_b32_e32 v11, v12, v11
; VI-NEXT:    v_add_f16_sdwa v12, v39, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v13, 0x200, v39
; VI-NEXT:    v_or_b32_e32 v12, v13, v12
; VI-NEXT:    v_add_f16_sdwa v13, v38, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v14, 0x200, v38
; VI-NEXT:    v_or_b32_e32 v13, v14, v13
; VI-NEXT:    v_add_f16_sdwa v14, v37, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v15, 0x200, v37
; VI-NEXT:    v_or_b32_e32 v14, v15, v14
; VI-NEXT:    v_add_f16_sdwa v15, v36, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v16, 0x200, v36
; VI-NEXT:    v_or_b32_e32 v15, v16, v15
; VI-NEXT:    v_add_f16_sdwa v16, v35, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v17, 0x200, v35
; VI-NEXT:    v_or_b32_e32 v16, v17, v16
; VI-NEXT:    v_add_f16_sdwa v17, v34, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v18, 0x200, v34
; VI-NEXT:    v_or_b32_e32 v17, v18, v17
; VI-NEXT:    v_add_f16_sdwa v18, v33, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v20, 0x200, v33
; VI-NEXT:    v_or_b32_e32 v18, v20, v18
; VI-NEXT:    v_add_f16_sdwa v19, v32, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v20, 0x200, v32
; VI-NEXT:    v_or_b32_e32 v19, v20, v19
; VI-NEXT:  .LBB18_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v40f16_to_v20i32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v19
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    v_mov_b32_e32 v33, v18
; GFX9-NEXT:    v_mov_b32_e32 v43, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v32
; GFX9-NEXT:    v_mov_b32_e32 v34, v17
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v33
; GFX9-NEXT:    v_mov_b32_e32 v35, v16
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v34
; GFX9-NEXT:    v_mov_b32_e32 v36, v15
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v35
; GFX9-NEXT:    v_mov_b32_e32 v37, v14
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v36
; GFX9-NEXT:    v_mov_b32_e32 v38, v13
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v37
; GFX9-NEXT:    v_mov_b32_e32 v39, v12
; GFX9-NEXT:    v_mov_b32_e32 v48, v11
; GFX9-NEXT:    v_mov_b32_e32 v49, v10
; GFX9-NEXT:    v_mov_b32_e32 v50, v9
; GFX9-NEXT:    v_mov_b32_e32 v51, v8
; GFX9-NEXT:    v_mov_b32_e32 v52, v7
; GFX9-NEXT:    v_mov_b32_e32 v53, v6
; GFX9-NEXT:    v_mov_b32_e32 v54, v5
; GFX9-NEXT:    v_mov_b32_e32 v55, v4
; GFX9-NEXT:    v_mov_b32_e32 v40, v3
; GFX9-NEXT:    v_mov_b32_e32 v41, v2
; GFX9-NEXT:    v_mov_b32_e32 v42, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v38
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v39
; GFX9-NEXT:    v_lshrrev_b32_e32 v60, 16, v48
; GFX9-NEXT:    v_lshrrev_b32_e32 v61, 16, v49
; GFX9-NEXT:    v_lshrrev_b32_e32 v62, 16, v50
; GFX9-NEXT:    v_lshrrev_b32_e32 v63, 16, v51
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v52
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v53
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v54
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v55
; GFX9-NEXT:    v_lshrrev_b32_e32 v56, 16, v40
; GFX9-NEXT:    v_lshrrev_b32_e32 v57, 16, v41
; GFX9-NEXT:    v_lshrrev_b32_e32 v58, 16, v42
; GFX9-NEXT:    v_lshrrev_b32_e32 v59, 16, v43
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB18_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 16, v39
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 16, v38
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v37
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 16, v36
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v16, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v19, 16, v32
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    v_perm_b32 v0, v59, v43, s6
; GFX9-NEXT:    v_perm_b32 v1, v58, v42, s6
; GFX9-NEXT:    v_perm_b32 v2, v57, v41, s6
; GFX9-NEXT:    v_perm_b32 v3, v56, v40, s6
; GFX9-NEXT:    v_perm_b32 v4, v47, v55, s6
; GFX9-NEXT:    v_perm_b32 v5, v46, v54, s6
; GFX9-NEXT:    v_perm_b32 v6, v45, v53, s6
; GFX9-NEXT:    v_perm_b32 v7, v44, v52, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v51, s6
; GFX9-NEXT:    v_perm_b32 v9, v62, v50, s6
; GFX9-NEXT:    v_perm_b32 v10, v61, v49, s6
; GFX9-NEXT:    v_perm_b32 v11, v60, v48, s6
; GFX9-NEXT:    v_perm_b32 v12, v12, v39, s6
; GFX9-NEXT:    v_perm_b32 v13, v13, v38, s6
; GFX9-NEXT:    v_perm_b32 v14, v14, v37, s6
; GFX9-NEXT:    v_perm_b32 v15, v15, v36, s6
; GFX9-NEXT:    v_perm_b32 v16, v16, v35, s6
; GFX9-NEXT:    v_perm_b32 v17, v17, v34, s6
; GFX9-NEXT:    v_perm_b32 v18, v18, v33, s6
; GFX9-NEXT:    v_perm_b32 v19, v19, v32, s6
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr60
; GFX9-NEXT:    ; implicit-def: $vgpr61
; GFX9-NEXT:    ; implicit-def: $vgpr62
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr56
; GFX9-NEXT:    ; implicit-def: $vgpr57
; GFX9-NEXT:    ; implicit-def: $vgpr58
; GFX9-NEXT:    ; implicit-def: $vgpr59
; GFX9-NEXT:  .LBB18_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB18_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v59, v43, s6
; GFX9-NEXT:    s_movk_i32 s7, 0x200
; GFX9-NEXT:    v_perm_b32 v1, v58, v42, s6
; GFX9-NEXT:    v_perm_b32 v2, v57, v41, s6
; GFX9-NEXT:    v_perm_b32 v3, v56, v40, s6
; GFX9-NEXT:    v_perm_b32 v4, v47, v55, s6
; GFX9-NEXT:    v_perm_b32 v5, v46, v54, s6
; GFX9-NEXT:    v_perm_b32 v6, v45, v53, s6
; GFX9-NEXT:    v_perm_b32 v7, v44, v52, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v51, s6
; GFX9-NEXT:    v_perm_b32 v9, v62, v50, s6
; GFX9-NEXT:    v_perm_b32 v10, v61, v49, s6
; GFX9-NEXT:    v_perm_b32 v11, v60, v48, s6
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, v6, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v7, v7, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v8, v8, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v9, v9, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v10, v10, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v11, v11, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(7)
; GFX9-NEXT:    v_perm_b32 v12, v12, v39, s6
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_perm_b32 v13, v13, v38, s6
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_perm_b32 v14, v14, v37, s6
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_perm_b32 v15, v15, v36, s6
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_perm_b32 v16, v16, v35, s6
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_perm_b32 v17, v17, v34, s6
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_perm_b32 v18, v18, v33, s6
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v19, v19, v32, s6
; GFX9-NEXT:    v_pk_add_f16 v12, v12, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v13, v13, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v14, v14, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v15, v15, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v16, v16, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v17, v17, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v18, v18, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v19, v19, s7 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB18_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v40f16_to_v20i32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB18_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v6, 0x200, v6 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v7, 0x200, v7 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v8, 0x200, v8 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v9, 0x200, v9 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v10, 0x200, v10 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v11, 0x200, v11 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v12, 0x200, v12 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v13, 0x200, v13 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v14, 0x200, v14 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v15, 0x200, v15 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v16, 0x200, v16 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v17, 0x200, v17 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v18, 0x200, v18 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v19, 0x200, v19 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:  .LBB18_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v40f16_to_v20i32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v3
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v37, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v38, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v39, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v48, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v36, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v35, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v34, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v33, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v32, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v31, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v30, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v29, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v28, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v27, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v26, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v25, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v24, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v23, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v22, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v21, v19, 0x5040100
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB18_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v6, 0x200, v6 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v7, 0x200, v7 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v8, 0x200, v8 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v9, 0x200, v9 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v10, 0x200, v10 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v11, 0x200, v11 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v12, 0x200, v12 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v13, 0x200, v13 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v14, 0x200, v14 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v15, 0x200, v15 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v16, 0x200, v16 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v17, 0x200, v17 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v18, 0x200, v18 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v19, 0x200, v19 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:  .LBB18_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <40 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <40 x half> %a1 to <20 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <40 x half> %a to <20 x i32>
  br label %end

end:
  %phi = phi <20 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x i32> %phi
}

define inreg <20 x i32> @bitcast_v40f16_to_v20i32_scalar(<40 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v40f16_to_v20i32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v47, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v63, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v62, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v44, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v43, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v42, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v41, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v40, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v55, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v54, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v53, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v52, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v51, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v50, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v49, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v48, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v31, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v30, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v29, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v23
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v58, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v60, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v59, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v57, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v39, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v56, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v38, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v37, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v36, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v35, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v34, s27
; SI-NEXT:    v_cvt_f16_f32_e32 v61, s26
; SI-NEXT:    v_cvt_f16_f32_e32 v25, s29
; SI-NEXT:    v_cvt_f16_f32_e32 v24, s28
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v26
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_cbranch_scc0 .LBB19_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v58
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v59
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v39
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v38
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v36
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v34
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v25
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v32
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v63
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v44
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v42
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v40
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v54
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v52
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v50
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v48
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v30
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v28
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v20
; SI-NEXT:    v_or_b32_e32 v0, v60, v0
; SI-NEXT:    v_or_b32_e32 v1, v57, v1
; SI-NEXT:    v_or_b32_e32 v2, v56, v2
; SI-NEXT:    v_or_b32_e32 v3, v37, v3
; SI-NEXT:    v_or_b32_e32 v4, v35, v4
; SI-NEXT:    v_or_b32_e32 v5, v61, v5
; SI-NEXT:    v_or_b32_e32 v6, v24, v6
; SI-NEXT:    v_or_b32_e32 v7, v47, v7
; SI-NEXT:    v_or_b32_e32 v8, v62, v8
; SI-NEXT:    v_or_b32_e32 v9, v43, v9
; SI-NEXT:    v_or_b32_e32 v10, v41, v10
; SI-NEXT:    v_or_b32_e32 v11, v55, v11
; SI-NEXT:    v_or_b32_e32 v12, v53, v12
; SI-NEXT:    v_or_b32_e32 v13, v51, v13
; SI-NEXT:    v_or_b32_e32 v14, v49, v14
; SI-NEXT:    v_or_b32_e32 v15, v31, v15
; SI-NEXT:    v_or_b32_e32 v16, v29, v16
; SI-NEXT:    v_or_b32_e32 v17, v27, v17
; SI-NEXT:    v_or_b32_e32 v18, v22, v18
; SI-NEXT:    v_or_b32_e32 v19, v21, v19
; SI-NEXT:    s_cbranch_execnz .LBB19_3
; SI-NEXT:  .LBB19_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v58
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v59
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v60
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v57
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v39
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v56
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v37
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v35
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v38
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v61
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v24
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v32
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v47
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v62
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v42
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v25
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v41
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v55
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v63
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v44
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v10, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v43
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v52
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v51
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v49
; SI-NEXT:    v_or_b32_e32 v9, v10, v9
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v40
; SI-NEXT:    v_or_b32_e32 v10, v12, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v54
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_or_b32_e32 v11, v13, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v53
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v27
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v50
; SI-NEXT:    v_or_b32_e32 v13, v15, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v48
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v31
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; SI-NEXT:    v_add_f32_e32 v18, 0x38000000, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v19, 0x38000000, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v28
; SI-NEXT:    v_or_b32_e32 v16, v18, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_add_f32_e32 v18, 0x38000000, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    v_add_f32_e32 v20, 0x38000000, v20
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    v_or_b32_e32 v17, v19, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v20
; SI-NEXT:    v_add_f32_e32 v21, 0x38000000, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v21
; SI-NEXT:    v_add_f32_e32 v19, 0x38000000, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; SI-NEXT:    v_or_b32_e32 v18, v19, v18
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v20
; SI-NEXT:    v_or_b32_e32 v19, v21, v19
; SI-NEXT:  .LBB19_3: ; %end
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB19_4:
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v59, v48
; SI-NEXT:    v_mov_b32_e32 v48, v21
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v60, v49
; SI-NEXT:    v_mov_b32_e32 v49, v20
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v43, v50
; SI-NEXT:    v_mov_b32_e32 v50, v22
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v44, v51
; SI-NEXT:    v_mov_b32_e32 v51, v23
; SI-NEXT:    v_mov_b32_e32 v45, v52
; SI-NEXT:    v_mov_b32_e32 v52, v27
; SI-NEXT:    v_mov_b32_e32 v46, v53
; SI-NEXT:    v_mov_b32_e32 v53, v28
; SI-NEXT:    buffer_store_dword v36, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v39, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v41, v32
; SI-NEXT:    v_mov_b32_e32 v33, v47
; SI-NEXT:    v_mov_b32_e32 v47, v54
; SI-NEXT:    v_mov_b32_e32 v54, v29
; SI-NEXT:    v_mov_b32_e32 v42, v56
; SI-NEXT:    v_mov_b32_e32 v56, v55
; SI-NEXT:    v_mov_b32_e32 v55, v30
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_mov_b32_e32 v36, v57
; SI-NEXT:    v_mov_b32_e32 v57, v40
; SI-NEXT:    v_mov_b32_e32 v40, v31
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v39, v58
; SI-NEXT:    v_mov_b32_e32 v58, v37
; SI-NEXT:    v_mov_b32_e32 v37, v34
; SI-NEXT:    v_mov_b32_e32 v34, v24
; SI-NEXT:    v_mov_b32_e32 v32, v38
; SI-NEXT:    v_mov_b32_e32 v38, v35
; SI-NEXT:    v_mov_b32_e32 v35, v25
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    v_mov_b32_e32 v25, v35
; SI-NEXT:    v_mov_b32_e32 v35, v38
; SI-NEXT:    v_mov_b32_e32 v38, v32
; SI-NEXT:    v_mov_b32_e32 v24, v34
; SI-NEXT:    v_mov_b32_e32 v34, v37
; SI-NEXT:    v_mov_b32_e32 v37, v58
; SI-NEXT:    v_mov_b32_e32 v58, v39
; SI-NEXT:    v_mov_b32_e32 v31, v40
; SI-NEXT:    v_mov_b32_e32 v40, v57
; SI-NEXT:    v_mov_b32_e32 v57, v36
; SI-NEXT:    v_mov_b32_e32 v30, v55
; SI-NEXT:    v_mov_b32_e32 v55, v56
; SI-NEXT:    v_mov_b32_e32 v56, v42
; SI-NEXT:    v_mov_b32_e32 v32, v41
; SI-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v36, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v23, v51
; SI-NEXT:    v_mov_b32_e32 v51, v44
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v22, v50
; SI-NEXT:    v_mov_b32_e32 v50, v43
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v20, v49
; SI-NEXT:    v_mov_b32_e32 v49, v60
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v21, v48
; SI-NEXT:    v_mov_b32_e32 v48, v59
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v29, v54
; SI-NEXT:    v_mov_b32_e32 v54, v47
; SI-NEXT:    v_mov_b32_e32 v47, v33
; SI-NEXT:    v_mov_b32_e32 v28, v53
; SI-NEXT:    v_mov_b32_e32 v53, v46
; SI-NEXT:    v_mov_b32_e32 v27, v52
; SI-NEXT:    v_mov_b32_e32 v52, v45
; SI-NEXT:    s_branch .LBB19_2
;
; VI-LABEL: bitcast_v40f16_to_v20i32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s6, s29, 16
; VI-NEXT:    s_lshr_b32 s7, s28, 16
; VI-NEXT:    s_lshr_b32 s8, s27, 16
; VI-NEXT:    s_lshr_b32 s9, s26, 16
; VI-NEXT:    s_lshr_b32 s10, s25, 16
; VI-NEXT:    s_lshr_b32 s11, s24, 16
; VI-NEXT:    s_lshr_b32 s12, s23, 16
; VI-NEXT:    s_lshr_b32 s13, s22, 16
; VI-NEXT:    s_lshr_b32 s14, s21, 16
; VI-NEXT:    s_lshr_b32 s15, s20, 16
; VI-NEXT:    s_lshr_b32 s40, s19, 16
; VI-NEXT:    s_lshr_b32 s41, s18, 16
; VI-NEXT:    s_lshr_b32 s42, s17, 16
; VI-NEXT:    s_lshr_b32 s43, s16, 16
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    v_mov_b32_e32 v32, v5
; VI-NEXT:    v_mov_b32_e32 v33, v4
; VI-NEXT:    v_mov_b32_e32 v34, v3
; VI-NEXT:    v_mov_b32_e32 v35, v2
; VI-NEXT:    v_mov_b32_e32 v36, v1
; VI-NEXT:    v_mov_b32_e32 v37, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    s_cbranch_scc0 .LBB19_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s43, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s44, s42, 16
; VI-NEXT:    s_or_b32 s5, s5, s44
; VI-NEXT:    s_and_b32 s44, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s45, s41, 16
; VI-NEXT:    s_or_b32 s44, s44, s45
; VI-NEXT:    s_and_b32 s45, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s46, s40, 16
; VI-NEXT:    s_or_b32 s45, s45, s46
; VI-NEXT:    s_and_b32 s46, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s47, s15, 16
; VI-NEXT:    s_or_b32 s46, s46, s47
; VI-NEXT:    s_and_b32 s47, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s56, s14, 16
; VI-NEXT:    s_or_b32 s47, s47, s56
; VI-NEXT:    s_and_b32 s56, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s57, s13, 16
; VI-NEXT:    s_or_b32 s56, s56, s57
; VI-NEXT:    s_and_b32 s57, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s58, s12, 16
; VI-NEXT:    s_or_b32 s57, s57, s58
; VI-NEXT:    s_and_b32 s58, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s59, s11, 16
; VI-NEXT:    s_or_b32 s58, s58, s59
; VI-NEXT:    s_and_b32 s59, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s60, s10, 16
; VI-NEXT:    v_mov_b32_e32 v0, 16
; VI-NEXT:    s_or_b32 s59, s59, s60
; VI-NEXT:    s_and_b32 s60, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s61, s9, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s60, s60, s61
; VI-NEXT:    s_and_b32 s61, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s62, s8, 16
; VI-NEXT:    v_or_b32_sdwa v14, v37, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s61, s61, s62
; VI-NEXT:    s_and_b32 s62, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s63, s7, 16
; VI-NEXT:    v_or_b32_sdwa v16, v35, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s62, s62, s63
; VI-NEXT:    s_and_b32 s63, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s72, s6, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v0, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v17, v34, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v0, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s63, s63, s72
; VI-NEXT:    v_or_b32_sdwa v15, v36, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v33, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v32, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s44
; VI-NEXT:    v_mov_b32_e32 v3, s45
; VI-NEXT:    v_mov_b32_e32 v4, s46
; VI-NEXT:    v_mov_b32_e32 v5, s47
; VI-NEXT:    v_mov_b32_e32 v6, s56
; VI-NEXT:    v_mov_b32_e32 v7, s57
; VI-NEXT:    v_mov_b32_e32 v8, s58
; VI-NEXT:    v_mov_b32_e32 v9, s59
; VI-NEXT:    v_mov_b32_e32 v10, s60
; VI-NEXT:    v_mov_b32_e32 v11, s61
; VI-NEXT:    v_mov_b32_e32 v12, s62
; VI-NEXT:    v_mov_b32_e32 v13, s63
; VI-NEXT:    s_cbranch_execnz .LBB19_3
; VI-NEXT:  .LBB19_2: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v13, 0x200
; VI-NEXT:    v_mov_b32_e32 v0, s43
; VI-NEXT:    v_mov_b32_e32 v2, s42
; VI-NEXT:    v_add_f16_sdwa v0, v0, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, s16, v13
; VI-NEXT:    v_add_f16_sdwa v2, v2, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, s17, v13
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    v_or_b32_e32 v1, v3, v2
; VI-NEXT:    v_mov_b32_e32 v2, s41
; VI-NEXT:    v_add_f16_sdwa v2, v2, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, s18, v13
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_mov_b32_e32 v3, s40
; VI-NEXT:    v_add_f16_sdwa v3, v3, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, s19, v13
; VI-NEXT:    v_or_b32_e32 v3, v4, v3
; VI-NEXT:    v_mov_b32_e32 v4, s15
; VI-NEXT:    v_add_f16_sdwa v4, v4, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, s20, v13
; VI-NEXT:    v_or_b32_e32 v4, v5, v4
; VI-NEXT:    v_mov_b32_e32 v5, s14
; VI-NEXT:    v_add_f16_sdwa v5, v5, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, s21, v13
; VI-NEXT:    v_or_b32_e32 v5, v6, v5
; VI-NEXT:    v_mov_b32_e32 v6, s13
; VI-NEXT:    v_add_f16_sdwa v6, v6, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, s22, v13
; VI-NEXT:    v_or_b32_e32 v6, v7, v6
; VI-NEXT:    v_mov_b32_e32 v7, s12
; VI-NEXT:    v_add_f16_sdwa v7, v7, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, s23, v13
; VI-NEXT:    v_or_b32_e32 v7, v8, v7
; VI-NEXT:    v_mov_b32_e32 v8, s11
; VI-NEXT:    v_add_f16_sdwa v8, v8, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v9, s24, v13
; VI-NEXT:    v_or_b32_e32 v8, v9, v8
; VI-NEXT:    v_mov_b32_e32 v9, s10
; VI-NEXT:    v_add_f16_sdwa v9, v9, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v10, s25, v13
; VI-NEXT:    v_or_b32_e32 v9, v10, v9
; VI-NEXT:    v_mov_b32_e32 v10, s9
; VI-NEXT:    v_add_f16_sdwa v10, v10, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v11, s26, v13
; VI-NEXT:    v_or_b32_e32 v10, v11, v10
; VI-NEXT:    v_mov_b32_e32 v11, s8
; VI-NEXT:    v_add_f16_sdwa v11, v11, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v12, s27, v13
; VI-NEXT:    v_or_b32_e32 v11, v12, v11
; VI-NEXT:    v_mov_b32_e32 v12, s7
; VI-NEXT:    v_add_f16_sdwa v12, v12, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v14, s28, v13
; VI-NEXT:    v_or_b32_e32 v12, v14, v12
; VI-NEXT:    v_mov_b32_e32 v14, s6
; VI-NEXT:    v_add_f16_sdwa v14, v14, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v13, s29, v13
; VI-NEXT:    v_mov_b32_e32 v19, 0x200
; VI-NEXT:    v_or_b32_e32 v13, v13, v14
; VI-NEXT:    v_add_f16_sdwa v14, v37, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v15, 0x200, v37
; VI-NEXT:    v_or_b32_e32 v14, v15, v14
; VI-NEXT:    v_add_f16_sdwa v15, v36, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v16, 0x200, v36
; VI-NEXT:    v_or_b32_e32 v15, v16, v15
; VI-NEXT:    v_add_f16_sdwa v16, v35, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v17, 0x200, v35
; VI-NEXT:    v_or_b32_e32 v16, v17, v16
; VI-NEXT:    v_add_f16_sdwa v17, v34, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v18, 0x200, v34
; VI-NEXT:    v_or_b32_e32 v17, v18, v17
; VI-NEXT:    v_add_f16_sdwa v18, v33, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v20, 0x200, v33
; VI-NEXT:    v_or_b32_e32 v18, v20, v18
; VI-NEXT:    v_add_f16_sdwa v19, v32, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v20, 0x200, v32
; VI-NEXT:    v_or_b32_e32 v19, v20, v19
; VI-NEXT:  .LBB19_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB19_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_branch .LBB19_2
;
; GFX9-LABEL: bitcast_v40f16_to_v20i32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v5
; GFX9-NEXT:    v_mov_b32_e32 v33, v4
; GFX9-NEXT:    v_mov_b32_e32 v34, v3
; GFX9-NEXT:    v_mov_b32_e32 v35, v2
; GFX9-NEXT:    v_mov_b32_e32 v36, v1
; GFX9-NEXT:    v_mov_b32_e32 v37, v0
; GFX9-NEXT:    s_lshr_b32 s40, s29, 16
; GFX9-NEXT:    s_lshr_b32 s41, s28, 16
; GFX9-NEXT:    s_lshr_b32 s42, s27, 16
; GFX9-NEXT:    s_lshr_b32 s43, s26, 16
; GFX9-NEXT:    s_lshr_b32 s15, s25, 16
; GFX9-NEXT:    s_lshr_b32 s14, s24, 16
; GFX9-NEXT:    s_lshr_b32 s13, s23, 16
; GFX9-NEXT:    s_lshr_b32 s12, s22, 16
; GFX9-NEXT:    s_lshr_b32 s11, s21, 16
; GFX9-NEXT:    s_lshr_b32 s10, s20, 16
; GFX9-NEXT:    s_lshr_b32 s9, s19, 16
; GFX9-NEXT:    s_lshr_b32 s8, s18, 16
; GFX9-NEXT:    s_lshr_b32 s7, s17, 16
; GFX9-NEXT:    s_lshr_b32 s6, s16, 16
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v36
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v37
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s16, s6
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s17, s7
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s18, s8
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s19, s9
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s20, s10
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s21, s11
; GFX9-NEXT:    s_pack_ll_b32_b16 s12, s22, s12
; GFX9-NEXT:    s_pack_ll_b32_b16 s13, s23, s13
; GFX9-NEXT:    s_pack_ll_b32_b16 s14, s24, s14
; GFX9-NEXT:    s_pack_ll_b32_b16 s15, s25, s15
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s26, s43
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s27, s42
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s28, s41
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s29, s40
; GFX9-NEXT:    s_cbranch_scc0 .LBB19_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v37
; GFX9-NEXT:    v_lshl_or_b32 v14, v51, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v36
; GFX9-NEXT:    v_lshl_or_b32 v15, v50, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v35
; GFX9-NEXT:    v_lshl_or_b32 v16, v49, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v34
; GFX9-NEXT:    v_lshl_or_b32 v17, v48, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v33
; GFX9-NEXT:    v_lshl_or_b32 v18, v39, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v32
; GFX9-NEXT:    v_lshl_or_b32 v19, v38, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_mov_b32_e32 v6, s12
; GFX9-NEXT:    v_mov_b32_e32 v7, s13
; GFX9-NEXT:    v_mov_b32_e32 v8, s14
; GFX9-NEXT:    v_mov_b32_e32 v9, s15
; GFX9-NEXT:    v_mov_b32_e32 v10, s16
; GFX9-NEXT:    v_mov_b32_e32 v11, s17
; GFX9-NEXT:    v_mov_b32_e32 v12, s18
; GFX9-NEXT:    v_mov_b32_e32 v13, s19
; GFX9-NEXT:    s_cbranch_execnz .LBB19_3
; GFX9-NEXT:  .LBB19_2: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff, v37
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v36
; GFX9-NEXT:    v_and_b32_e32 v16, 0xffff, v35
; GFX9-NEXT:    v_and_b32_e32 v17, 0xffff, v34
; GFX9-NEXT:    v_and_b32_e32 v18, 0xffff, v33
; GFX9-NEXT:    v_and_b32_e32 v19, 0xffff, v32
; GFX9-NEXT:    v_mov_b32_e32 v13, 0x200
; GFX9-NEXT:    s_movk_i32 s4, 0x200
; GFX9-NEXT:    v_lshl_or_b32 v14, v51, 16, v14
; GFX9-NEXT:    v_lshl_or_b32 v15, v50, 16, v15
; GFX9-NEXT:    v_lshl_or_b32 v16, v49, 16, v16
; GFX9-NEXT:    v_lshl_or_b32 v17, v48, 16, v17
; GFX9-NEXT:    v_lshl_or_b32 v18, v39, 16, v18
; GFX9-NEXT:    v_lshl_or_b32 v19, v38, 16, v19
; GFX9-NEXT:    v_pk_add_f16 v0, s6, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s7, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, s8, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, s9, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, s10, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, s11, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, s12, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v7, s13, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v8, s14, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v9, s15, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v10, s16, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v11, s17, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v12, s18, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v13, s19, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v14, v14, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v15, v15, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v16, v16, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v17, v17, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v18, v18, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v19, v19, s4 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB19_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB19_4:
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_branch .LBB19_2
;
; GFX11-TRUE16-LABEL: bitcast_v40f16_to_v20i32_scalar:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.h, 0
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.l, v1.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.l, v0.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v35, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.h, v32.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v34, 0xffff, v1
; GFX11-TRUE16-NEXT:    s_lshr_b32 s41, s29, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s42, s28, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s43, s27, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s44, s26, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s45, s25, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s15, s24, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s13, s22, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s12, s21, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s11, s20, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s10, s19, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s9, s18, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s8, s17, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s7, s16, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s6, s2, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s4, s0, 16
; GFX11-TRUE16-NEXT:    s_mov_b32 s40, 0
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s4, s0, s4
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s5, s1, s5
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s6, s2, s6
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s7, s16, s7
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s8, s17, s8
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s9, s18, s9
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s10, s19, s10
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s11, s20, s11
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s12, s21, s12
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s13, s22, s13
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s15, s24, s15
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s16, s25, s45
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s17, s26, s44
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s0, s27, s43
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s1, s28, s42
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s2, s29, s41
; GFX11-TRUE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-TRUE16-NEXT:    s_cbranch_scc0 .LBB19_4
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s3
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v4, s7 :: v_dual_mov_b32 v5, s8
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v6, s9 :: v_dual_mov_b32 v7, s10
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v8, s11 :: v_dual_mov_b32 v9, s12
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v10, s13 :: v_dual_mov_b32 v11, s14
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v12, s15 :: v_dual_mov_b32 v13, s16
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v14, s17 :: v_dual_mov_b32 v15, s0
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v16, s1 :: v_dual_mov_b32 v17, s2
; GFX11-TRUE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s40
; GFX11-TRUE16-NEXT:    s_cbranch_vccnz .LBB19_3
; GFX11-TRUE16-NEXT:  .LBB19_2: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v0, 0x200, s4 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v1, 0x200, s5 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v2, 0x200, s6 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v4, 0x200, s7 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v5, 0x200, s8 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v6, 0x200, s9 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v7, 0x200, s10 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v8, 0x200, s11 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v9, 0x200, s12 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v10, 0x200, s13 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v11, 0x200, s14 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v12, 0x200, s15 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v13, 0x200, s16 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v14, 0x200, s17 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v15, 0x200, s0 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v16, 0x200, s1 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v17, 0x200, s2 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v18, 0x200, v18 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v19, 0x200, v19 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:  .LBB19_3: ; %end
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB19_4:
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-TRUE16-NEXT:    s_branch .LBB19_2
;
; GFX11-FAKE16-LABEL: bitcast_v40f16_to_v20i32_scalar:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v35, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v34, 0xffff, v1
; GFX11-FAKE16-NEXT:    s_lshr_b32 s41, s29, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s42, s28, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s43, s27, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s44, s26, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s45, s25, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s15, s24, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s13, s22, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s12, s21, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s11, s20, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s10, s19, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s9, s18, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s8, s17, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s7, s16, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s6, s2, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s4, s0, 16
; GFX11-FAKE16-NEXT:    s_mov_b32 s40, 0
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s4, s0, s4
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s5, s1, s5
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s6, s2, s6
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s7, s16, s7
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s8, s17, s8
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s9, s18, s9
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s10, s19, s10
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s11, s20, s11
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s12, s21, s12
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s13, s22, s13
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s15, s24, s15
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s16, s25, s45
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s17, s26, s44
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s0, s27, s43
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s1, s28, s42
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s2, s29, s41
; GFX11-FAKE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-FAKE16-NEXT:    s_cbranch_scc0 .LBB19_4
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s3
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v4, s7 :: v_dual_mov_b32 v5, s8
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v6, s9 :: v_dual_mov_b32 v7, s10
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v8, s11 :: v_dual_mov_b32 v9, s12
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v10, s13 :: v_dual_mov_b32 v11, s14
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v12, s15 :: v_dual_mov_b32 v13, s16
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v14, s17 :: v_dual_mov_b32 v15, s0
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v16, s1 :: v_dual_mov_b32 v17, s2
; GFX11-FAKE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s40
; GFX11-FAKE16-NEXT:    s_cbranch_vccnz .LBB19_3
; GFX11-FAKE16-NEXT:  .LBB19_2: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v0, 0x200, s4 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v1, 0x200, s5 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v2, 0x200, s6 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v4, 0x200, s7 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v5, 0x200, s8 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v6, 0x200, s9 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v7, 0x200, s10 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v8, 0x200, s11 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v9, 0x200, s12 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v10, 0x200, s13 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v11, 0x200, s14 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v12, 0x200, s15 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v13, 0x200, s16 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v14, 0x200, s17 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v15, 0x200, s0 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v16, 0x200, s1 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v17, 0x200, s2 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v18, 0x200, v18 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v19, 0x200, v19 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:  .LBB19_3: ; %end
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB19_4:
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-FAKE16-NEXT:    s_branch .LBB19_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <40 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <40 x half> %a1 to <20 x i32>
  br label %end

cmp.false:
  %a3 = bitcast <40 x half> %a to <20 x i32>
  br label %end

end:
  %phi = phi <20 x i32> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x i32> %phi
}

define <10 x i64> @bitcast_v20f32_to_v10i64(<20 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v20f32_to_v10i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB20_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB20_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v20f32_to_v10i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB20_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB20_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v20f32_to_v10i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB20_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB20_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v20f32_to_v10i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB20_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  .LBB20_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <20 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <20 x float> %a1 to <10 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <20 x float> %a to <10 x i64>
  br label %end

end:
  %phi = phi <10 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x i64> %phi
}

define inreg <10 x i64> @bitcast_v20f32_to_v10i64_scalar(<20 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v20f32_to_v10i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v6
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB21_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB21_3
; SI-NEXT:  .LBB21_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB21_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB21_4:
; SI-NEXT:    s_branch .LBB21_2
;
; VI-LABEL: bitcast_v20f32_to_v10i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v6
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB21_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB21_3
; VI-NEXT:  .LBB21_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB21_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB21_4:
; VI-NEXT:    s_branch .LBB21_2
;
; GFX9-LABEL: bitcast_v20f32_to_v10i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB21_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB21_3
; GFX9-NEXT:  .LBB21_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB21_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB21_4:
; GFX9-NEXT:    s_branch .LBB21_2
;
; GFX11-LABEL: bitcast_v20f32_to_v10i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB21_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB21_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB21_3:
; GFX11-NEXT:  .LBB21_4: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <20 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <20 x float> %a1 to <10 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <20 x float> %a to <10 x i64>
  br label %end

end:
  %phi = phi <10 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x i64> %phi
}

define <20 x float> @bitcast_v10i64_to_v20f32(<10 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v10i64_to_v20f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB22_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB22_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v10i64_to_v20f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB22_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB22_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v10i64_to_v20f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB22_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 3, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB22_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v10i64_to_v20f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB22_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:  .LBB22_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <10 x i64> %a, splat (i64 3)
  %a2 = bitcast <10 x i64> %a1 to <20 x float>
  br label %end

cmp.false:
  %a3 = bitcast <10 x i64> %a to <20 x float>
  br label %end

end:
  %phi = phi <20 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x float> %phi
}

define inreg <20 x float> @bitcast_v10i64_to_v20f32_scalar(<10 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v10i64_to_v20f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v6
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB23_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB23_3
; SI-NEXT:  .LBB23_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:  .LBB23_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB23_4:
; SI-NEXT:    s_branch .LBB23_2
;
; VI-LABEL: bitcast_v10i64_to_v20f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v6
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB23_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB23_3
; VI-NEXT:  .LBB23_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:  .LBB23_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB23_4:
; VI-NEXT:    s_branch .LBB23_2
;
; GFX9-LABEL: bitcast_v10i64_to_v20f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB23_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB23_3
; GFX9-NEXT:  .LBB23_2: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 3, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:  .LBB23_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB23_4:
; GFX9-NEXT:    s_branch .LBB23_2
;
; GFX11-LABEL: bitcast_v10i64_to_v20f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB23_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB23_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB23_3:
; GFX11-NEXT:  .LBB23_4: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <10 x i64> %a, splat (i64 3)
  %a2 = bitcast <10 x i64> %a1 to <20 x float>
  br label %end

cmp.false:
  %a3 = bitcast <10 x i64> %a to <20 x float>
  br label %end

end:
  %phi = phi <20 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x float> %phi
}

define <10 x double> @bitcast_v20f32_to_v10f64(<20 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v20f32_to_v10f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB24_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB24_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v20f32_to_v10f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB24_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB24_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v20f32_to_v10f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB24_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB24_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v20f32_to_v10f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB24_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:  .LBB24_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <20 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <20 x float> %a1 to <10 x double>
  br label %end

cmp.false:
  %a3 = bitcast <20 x float> %a to <10 x double>
  br label %end

end:
  %phi = phi <10 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x double> %phi
}

define inreg <10 x double> @bitcast_v20f32_to_v10f64_scalar(<20 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v20f32_to_v10f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v6
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB25_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB25_3
; SI-NEXT:  .LBB25_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; SI-NEXT:  .LBB25_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB25_4:
; SI-NEXT:    s_branch .LBB25_2
;
; VI-LABEL: bitcast_v20f32_to_v10f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v6
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB25_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB25_3
; VI-NEXT:  .LBB25_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:  .LBB25_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB25_4:
; VI-NEXT:    s_branch .LBB25_2
;
; GFX9-LABEL: bitcast_v20f32_to_v10f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB25_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB25_3
; GFX9-NEXT:  .LBB25_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:  .LBB25_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB25_4:
; GFX9-NEXT:    s_branch .LBB25_2
;
; GFX11-LABEL: bitcast_v20f32_to_v10f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB25_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB25_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB25_3:
; GFX11-NEXT:  .LBB25_4: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <20 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <20 x float> %a1 to <10 x double>
  br label %end

cmp.false:
  %a3 = bitcast <20 x float> %a to <10 x double>
  br label %end

end:
  %phi = phi <10 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x double> %phi
}

define <20 x float> @bitcast_v10f64_to_v20f32(<10 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v10f64_to_v20f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB26_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB26_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v10f64_to_v20f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB26_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; VI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB26_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v10f64_to_v20f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB26_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB26_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v10f64_to_v20f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB26_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX11-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:  .LBB26_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <10 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <10 x double> %a1 to <20 x float>
  br label %end

cmp.false:
  %a3 = bitcast <10 x double> %a to <20 x float>
  br label %end

end:
  %phi = phi <20 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x float> %phi
}

define inreg <20 x float> @bitcast_v10f64_to_v20f32_scalar(<10 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v10f64_to_v20f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v12, v6
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB27_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB27_3
; SI-NEXT:  .LBB27_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:  .LBB27_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB27_4:
; SI-NEXT:    s_branch .LBB27_2
;
; VI-LABEL: bitcast_v10f64_to_v20f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v12, v6
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB27_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB27_3
; VI-NEXT:  .LBB27_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; VI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:  .LBB27_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB27_4:
; VI-NEXT:    s_branch .LBB27_2
;
; GFX9-LABEL: bitcast_v10f64_to_v20f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v12, v6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB27_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB27_3
; GFX9-NEXT:  .LBB27_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX9-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:  .LBB27_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB27_4:
; GFX9-NEXT:    s_branch .LBB27_2
;
; GFX11-LABEL: bitcast_v10f64_to_v20f32_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB27_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB27_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB27_3:
; GFX11-NEXT:  .LBB27_4: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX11-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <10 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <10 x double> %a1 to <20 x float>
  br label %end

cmp.false:
  %a3 = bitcast <10 x double> %a to <20 x float>
  br label %end

end:
  %phi = phi <20 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x float> %phi
}

define <40 x i16> @bitcast_v20f32_to_v40i16(<20 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v20f32_to_v40i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v21
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB28_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v21, v20, v19, 16
; SI-NEXT:    v_alignbit_b32 v22, v18, v17, 16
; SI-NEXT:    v_alignbit_b32 v23, v16, v15, 16
; SI-NEXT:    v_alignbit_b32 v24, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v26, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v28, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v31, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v33, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v35, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v37, v2, v1, 16
; SI-NEXT:    v_lshrrev_b32_e32 v25, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v2
; SI-NEXT:  .LBB28_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB28_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_alignbit_b32 v21, v20, v19, 16
; SI-NEXT:    v_alignbit_b32 v22, v18, v17, 16
; SI-NEXT:    v_alignbit_b32 v23, v16, v15, 16
; SI-NEXT:    v_alignbit_b32 v24, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v26, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v28, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v31, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v33, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v35, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v37, v2, v1, 16
; SI-NEXT:    v_lshrrev_b32_e32 v25, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v2
; SI-NEXT:  .LBB28_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; SI-NEXT:    v_or_b32_e32 v1, v1, v37
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v48
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 4, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v35
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 8, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v39
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 12, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v33
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 16, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v38
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 20, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v7
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v31
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 24, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v36
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 28, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v9
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v28
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 32, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v10
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v34
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 36, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v11
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v26
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 40, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v12
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v32
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v13
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v24
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v14
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v30
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 52, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v15
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v23
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 56, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v16
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v29
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 60, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v17
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v22
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 64, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v18
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v27
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v19
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v21
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v20
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v25
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x4c, v0
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v20f32_to_v40i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr27
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr25
; VI-NEXT:    ; implicit-def: $vgpr24
; VI-NEXT:    ; implicit-def: $vgpr23
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr21
; VI-NEXT:    ; implicit-def: $vgpr20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB28_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; VI-NEXT:  .LBB28_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB28_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; VI-NEXT:  .LBB28_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; VI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; VI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; VI-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; VI-NEXT:    v_lshlrev_b32_e32 v35, 16, v35
; VI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; VI-NEXT:    v_lshlrev_b32_e32 v33, 16, v33
; VI-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; VI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; VI-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; VI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; VI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; VI-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; VI-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; VI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; VI-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; VI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; VI-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; VI-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; VI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; VI-NEXT:    v_or_b32_sdwa v0, v0, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v8, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v9, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v10, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v11, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v12, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v13, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v14, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v15, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v16, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v17, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v18, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v19, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v20f32_to_v40i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr27
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr25
; GFX9-NEXT:    ; implicit-def: $vgpr24
; GFX9-NEXT:    ; implicit-def: $vgpr23
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr21
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB28_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX9-NEXT:  .LBB28_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB28_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX9-NEXT:  .LBB28_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v39, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v38, v1, s4
; GFX9-NEXT:    v_perm_b32 v2, v37, v2, s4
; GFX9-NEXT:    v_perm_b32 v3, v36, v3, s4
; GFX9-NEXT:    v_perm_b32 v4, v35, v4, s4
; GFX9-NEXT:    v_perm_b32 v5, v34, v5, s4
; GFX9-NEXT:    v_perm_b32 v6, v33, v6, s4
; GFX9-NEXT:    v_perm_b32 v7, v32, v7, s4
; GFX9-NEXT:    v_perm_b32 v8, v31, v8, s4
; GFX9-NEXT:    v_perm_b32 v9, v30, v9, s4
; GFX9-NEXT:    v_perm_b32 v10, v29, v10, s4
; GFX9-NEXT:    v_perm_b32 v11, v28, v11, s4
; GFX9-NEXT:    v_perm_b32 v12, v27, v12, s4
; GFX9-NEXT:    v_perm_b32 v13, v26, v13, s4
; GFX9-NEXT:    v_perm_b32 v14, v25, v14, s4
; GFX9-NEXT:    v_perm_b32 v15, v24, v15, s4
; GFX9-NEXT:    v_perm_b32 v16, v23, v16, s4
; GFX9-NEXT:    v_perm_b32 v17, v22, v17, s4
; GFX9-NEXT:    v_perm_b32 v18, v21, v18, s4
; GFX9-NEXT:    v_perm_b32 v19, v20, v19, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v20f32_to_v40i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB28_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-TRUE16-NEXT:  .LBB28_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v20f32_to_v40i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr27
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr25
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr24
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr23
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr20
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB28_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX11-FAKE16-NEXT:  .LBB28_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB28_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX11-FAKE16-NEXT:  .LBB28_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v39, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v38, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v37, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v36, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v35, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v34, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v33, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v32, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v31, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v30, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v29, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v28, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v27, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v26, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v25, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v24, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v23, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v22, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v21, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v20, v19, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <20 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <20 x float> %a1 to <40 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <20 x float> %a to <40 x i16>
  br label %end

end:
  %phi = phi <40 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <40 x i16> %phi
}

define inreg <40 x i16> @bitcast_v20f32_to_v40i16_scalar(<20 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v20f32_to_v40i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v7
; SI-NEXT:    v_mov_b32_e32 v21, s16
; SI-NEXT:    v_mov_b32_e32 v20, s17
; SI-NEXT:    v_mov_b32_e32 v19, s18
; SI-NEXT:    v_mov_b32_e32 v17, s19
; SI-NEXT:    v_mov_b32_e32 v16, s20
; SI-NEXT:    v_mov_b32_e32 v15, s21
; SI-NEXT:    v_mov_b32_e32 v14, s22
; SI-NEXT:    v_mov_b32_e32 v13, s23
; SI-NEXT:    v_mov_b32_e32 v12, s24
; SI-NEXT:    v_mov_b32_e32 v11, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v9, s27
; SI-NEXT:    v_mov_b32_e32 v8, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v7, s29
; SI-NEXT:    s_cbranch_scc0 .LBB29_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v18, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v22, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v23, v2, v1, 16
; SI-NEXT:    v_alignbit_b32 v24, v7, v8, 16
; SI-NEXT:    v_alignbit_b32 v26, v9, v10, 16
; SI-NEXT:    v_alignbit_b32 v28, v11, v12, 16
; SI-NEXT:    v_alignbit_b32 v31, v13, v14, 16
; SI-NEXT:    v_alignbit_b32 v33, v15, v16, 16
; SI-NEXT:    v_alignbit_b32 v35, v17, v19, 16
; SI-NEXT:    v_alignbit_b32 v37, v20, v21, 16
; SI-NEXT:    v_lshrrev_b32_e32 v25, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v13
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v20
; SI-NEXT:    s_cbranch_execnz .LBB29_3
; SI-NEXT:  .LBB29_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    v_add_f32_e32 v21, 1.0, v21
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_alignbit_b32 v18, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v22, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v23, v2, v1, 16
; SI-NEXT:    v_alignbit_b32 v24, v7, v8, 16
; SI-NEXT:    v_alignbit_b32 v26, v9, v10, 16
; SI-NEXT:    v_alignbit_b32 v28, v11, v12, 16
; SI-NEXT:    v_alignbit_b32 v31, v13, v14, 16
; SI-NEXT:    v_alignbit_b32 v33, v15, v16, 16
; SI-NEXT:    v_alignbit_b32 v35, v17, v19, 16
; SI-NEXT:    v_alignbit_b32 v37, v20, v21, 16
; SI-NEXT:    v_lshrrev_b32_e32 v25, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v13
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v20
; SI-NEXT:  .LBB29_3: ; %end
; SI-NEXT:    v_and_b32_e32 v21, 0xffff, v21
; SI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; SI-NEXT:    v_or_b32_e32 v21, v21, v37
; SI-NEXT:    buffer_store_dword v21, v0, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v48
; SI-NEXT:    v_or_b32_e32 v20, v20, v21
; SI-NEXT:    v_add_i32_e32 v21, vcc, 4, v0
; SI-NEXT:    buffer_store_dword v20, v21, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v20, 16, v35
; SI-NEXT:    v_or_b32_e32 v19, v19, v20
; SI-NEXT:    v_add_i32_e32 v20, vcc, 8, v0
; SI-NEXT:    buffer_store_dword v19, v20, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v39
; SI-NEXT:    v_or_b32_e32 v17, v17, v19
; SI-NEXT:    v_add_i32_e32 v19, vcc, 12, v0
; SI-NEXT:    buffer_store_dword v17, v19, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v33
; SI-NEXT:    v_or_b32_e32 v16, v16, v17
; SI-NEXT:    v_add_i32_e32 v17, vcc, 16, v0
; SI-NEXT:    buffer_store_dword v16, v17, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v38
; SI-NEXT:    v_or_b32_e32 v15, v15, v16
; SI-NEXT:    v_add_i32_e32 v16, vcc, 20, v0
; SI-NEXT:    buffer_store_dword v15, v16, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v31
; SI-NEXT:    v_or_b32_e32 v14, v14, v15
; SI-NEXT:    v_add_i32_e32 v15, vcc, 24, v0
; SI-NEXT:    buffer_store_dword v14, v15, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v36
; SI-NEXT:    v_or_b32_e32 v13, v13, v14
; SI-NEXT:    v_add_i32_e32 v14, vcc, 28, v0
; SI-NEXT:    buffer_store_dword v13, v14, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v28
; SI-NEXT:    v_or_b32_e32 v12, v12, v13
; SI-NEXT:    v_add_i32_e32 v13, vcc, 32, v0
; SI-NEXT:    buffer_store_dword v12, v13, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v34
; SI-NEXT:    v_or_b32_e32 v11, v11, v12
; SI-NEXT:    v_add_i32_e32 v12, vcc, 36, v0
; SI-NEXT:    buffer_store_dword v11, v12, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v26
; SI-NEXT:    v_or_b32_e32 v10, v10, v11
; SI-NEXT:    v_add_i32_e32 v11, vcc, 40, v0
; SI-NEXT:    buffer_store_dword v10, v11, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v32
; SI-NEXT:    v_or_b32_e32 v9, v9, v10
; SI-NEXT:    v_add_i32_e32 v10, vcc, 44, v0
; SI-NEXT:    buffer_store_dword v9, v10, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v24
; SI-NEXT:    v_or_b32_e32 v8, v8, v9
; SI-NEXT:    v_add_i32_e32 v9, vcc, 48, v0
; SI-NEXT:    buffer_store_dword v8, v9, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v30
; SI-NEXT:    v_or_b32_e32 v7, v7, v8
; SI-NEXT:    v_add_i32_e32 v8, vcc, 52, v0
; SI-NEXT:    buffer_store_dword v7, v8, s[0:3], 0 offen
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v23
; SI-NEXT:    v_or_b32_e32 v1, v1, v7
; SI-NEXT:    v_add_i32_e32 v7, vcc, 56, v0
; SI-NEXT:    buffer_store_dword v1, v7, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v29
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 60, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v22
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 64, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v27
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v18
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v25
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x4c, v0
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB29_4:
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    s_branch .LBB29_2
;
; VI-LABEL: bitcast_v20f32_to_v40i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    v_mov_b32_e32 v20, s16
; VI-NEXT:    v_mov_b32_e32 v19, s17
; VI-NEXT:    v_mov_b32_e32 v18, s18
; VI-NEXT:    v_mov_b32_e32 v17, s19
; VI-NEXT:    v_mov_b32_e32 v16, s20
; VI-NEXT:    v_mov_b32_e32 v15, s21
; VI-NEXT:    v_mov_b32_e32 v14, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB29_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v20
; VI-NEXT:    s_cbranch_execnz .LBB29_3
; VI-NEXT:  .LBB29_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v20
; VI-NEXT:  .LBB29_3: ; %end
; VI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; VI-NEXT:    v_or_b32_sdwa v6, v14, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v38
; VI-NEXT:    v_or_b32_sdwa v7, v7, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v37
; VI-NEXT:    v_or_b32_sdwa v8, v8, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v36
; VI-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; VI-NEXT:    v_or_b32_sdwa v9, v9, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v35
; VI-NEXT:    v_or_b32_sdwa v24, v20, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v20, 16, v25
; VI-NEXT:    v_or_b32_sdwa v10, v10, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v34
; VI-NEXT:    v_or_b32_sdwa v25, v19, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v19, 16, v39
; VI-NEXT:    v_or_b32_sdwa v11, v11, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v33
; VI-NEXT:    v_or_b32_sdwa v20, v18, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v18, 16, v21
; VI-NEXT:    v_or_b32_sdwa v12, v12, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v32
; VI-NEXT:    v_or_b32_sdwa v21, v17, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v17, 16, v22
; VI-NEXT:    v_or_b32_sdwa v13, v13, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v31
; VI-NEXT:    v_or_b32_sdwa v22, v16, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v23
; VI-NEXT:    v_or_b32_sdwa v14, v0, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v30
; VI-NEXT:    v_or_b32_sdwa v23, v15, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v29
; VI-NEXT:    v_or_b32_sdwa v16, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v28
; VI-NEXT:    v_or_b32_sdwa v17, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v27
; VI-NEXT:    v_or_b32_sdwa v18, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v26
; VI-NEXT:    v_or_b32_sdwa v19, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, v24
; VI-NEXT:    v_mov_b32_e32 v1, v25
; VI-NEXT:    v_mov_b32_e32 v2, v20
; VI-NEXT:    v_mov_b32_e32 v3, v21
; VI-NEXT:    v_mov_b32_e32 v4, v22
; VI-NEXT:    v_mov_b32_e32 v5, v23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB29_4:
; VI-NEXT:    ; implicit-def: $vgpr24
; VI-NEXT:    ; implicit-def: $vgpr25
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr21
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr23
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr27
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    s_branch .LBB29_2
;
; GFX9-LABEL: bitcast_v20f32_to_v40i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    v_mov_b32_e32 v20, s16
; GFX9-NEXT:    v_mov_b32_e32 v19, s17
; GFX9-NEXT:    v_mov_b32_e32 v18, s18
; GFX9-NEXT:    v_mov_b32_e32 v17, s19
; GFX9-NEXT:    v_mov_b32_e32 v16, s20
; GFX9-NEXT:    v_mov_b32_e32 v15, s21
; GFX9-NEXT:    v_mov_b32_e32 v14, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB29_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v20
; GFX9-NEXT:    s_cbranch_execnz .LBB29_3
; GFX9-NEXT:  .LBB29_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v20
; GFX9-NEXT:  .LBB29_3: ; %end
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX9-NEXT:    v_lshl_or_b32 v6, v6, 16, v14
; GFX9-NEXT:    v_lshl_or_b32 v14, v31, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v1
; GFX9-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; GFX9-NEXT:    v_lshl_or_b32 v23, v23, 16, v15
; GFX9-NEXT:    v_lshl_or_b32 v15, v30, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v2
; GFX9-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX9-NEXT:    v_lshl_or_b32 v22, v22, 16, v16
; GFX9-NEXT:    v_lshl_or_b32 v16, v29, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v3
; GFX9-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; GFX9-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; GFX9-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; GFX9-NEXT:    v_lshl_or_b32 v21, v21, 16, v17
; GFX9-NEXT:    v_lshl_or_b32 v17, v28, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v4
; GFX9-NEXT:    v_lshl_or_b32 v24, v24, 16, v20
; GFX9-NEXT:    v_lshl_or_b32 v25, v25, 16, v19
; GFX9-NEXT:    v_lshl_or_b32 v20, v39, 16, v18
; GFX9-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX9-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX9-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX9-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX9-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX9-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX9-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; GFX9-NEXT:    v_lshl_or_b32 v18, v27, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v5
; GFX9-NEXT:    v_lshl_or_b32 v7, v38, 16, v7
; GFX9-NEXT:    v_lshl_or_b32 v8, v37, 16, v8
; GFX9-NEXT:    v_lshl_or_b32 v9, v36, 16, v9
; GFX9-NEXT:    v_lshl_or_b32 v10, v35, 16, v10
; GFX9-NEXT:    v_lshl_or_b32 v11, v34, 16, v11
; GFX9-NEXT:    v_lshl_or_b32 v12, v33, 16, v12
; GFX9-NEXT:    v_lshl_or_b32 v13, v32, 16, v13
; GFX9-NEXT:    v_lshl_or_b32 v19, v26, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v24
; GFX9-NEXT:    v_mov_b32_e32 v1, v25
; GFX9-NEXT:    v_mov_b32_e32 v2, v20
; GFX9-NEXT:    v_mov_b32_e32 v3, v21
; GFX9-NEXT:    v_mov_b32_e32 v4, v22
; GFX9-NEXT:    v_mov_b32_e32 v5, v23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB29_4:
; GFX9-NEXT:    ; implicit-def: $vgpr24
; GFX9-NEXT:    ; implicit-def: $vgpr25
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr21
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr23
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr27
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    s_branch .LBB29_2
;
; GFX11-LABEL: bitcast_v20f32_to_v40i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-NEXT:    v_dual_mov_b32 v20, s0 :: v_dual_mov_b32 v19, s1
; GFX11-NEXT:    v_dual_mov_b32 v18, s2 :: v_dual_mov_b32 v3, s16
; GFX11-NEXT:    v_dual_mov_b32 v4, s3 :: v_dual_mov_b32 v9, s17
; GFX11-NEXT:    v_dual_mov_b32 v8, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s20 :: v_dual_mov_b32 v5, s21
; GFX11-NEXT:    v_dual_mov_b32 v14, s22 :: v_dual_mov_b32 v13, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v11, s25
; GFX11-NEXT:    v_dual_mov_b32 v10, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v17, s28 :: v_dual_mov_b32 v16, s29
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB29_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    v_lshrrev_b32_e32 v22, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v23, 16, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v24, 16, v16
; GFX11-NEXT:    v_lshrrev_b32_e32 v25, 16, v17
; GFX11-NEXT:    v_lshrrev_b32_e32 v26, 16, v15
; GFX11-NEXT:    v_lshrrev_b32_e32 v27, 16, v10
; GFX11-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v29, 16, v12
; GFX11-NEXT:    v_lshrrev_b32_e32 v30, 16, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v31, 16, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v32, 16, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v34, 16, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v35, 16, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v36, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v37, 16, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v38, 16, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v18
; GFX11-NEXT:    v_lshrrev_b32_e32 v21, 16, v19
; GFX11-NEXT:    v_lshrrev_b32_e32 v39, 16, v20
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB29_3
; GFX11-NEXT:  .LBB29_2: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:    v_dual_add_f32 v16, 1.0, v16 :: v_dual_add_f32 v17, 1.0, v17
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-NEXT:    v_lshrrev_b32_e32 v22, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v23, 16, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v24, 16, v16
; GFX11-NEXT:    v_lshrrev_b32_e32 v25, 16, v17
; GFX11-NEXT:    v_lshrrev_b32_e32 v26, 16, v15
; GFX11-NEXT:    v_lshrrev_b32_e32 v27, 16, v10
; GFX11-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v29, 16, v12
; GFX11-NEXT:    v_lshrrev_b32_e32 v30, 16, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v31, 16, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v32, 16, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v34, 16, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v35, 16, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v36, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v37, 16, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v38, 16, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v18
; GFX11-NEXT:    v_lshrrev_b32_e32 v21, 16, v19
; GFX11-NEXT:    v_lshrrev_b32_e32 v39, 16, v20
; GFX11-NEXT:  .LBB29_3: ; %end
; GFX11-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; GFX11-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; GFX11-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX11-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX11-NEXT:    v_lshl_or_b32 v21, v21, 16, v19
; GFX11-NEXT:    v_lshl_or_b32 v2, v2, 16, v18
; GFX11-NEXT:    v_and_b32_e32 v18, 0xffff, v6
; GFX11-NEXT:    v_and_b32_e32 v19, 0xffff, v5
; GFX11-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; GFX11-NEXT:    v_lshl_or_b32 v5, v36, 16, v9
; GFX11-NEXT:    v_lshl_or_b32 v6, v35, 16, v8
; GFX11-NEXT:    v_lshl_or_b32 v8, v33, 16, v18
; GFX11-NEXT:    v_lshl_or_b32 v9, v32, 16, v19
; GFX11-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; GFX11-NEXT:    v_and_b32_e32 v18, 0xffff, v11
; GFX11-NEXT:    v_and_b32_e32 v19, 0xffff, v10
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-NEXT:    v_and_b32_e32 v48, 0xffff, v3
; GFX11-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX11-NEXT:    v_lshl_or_b32 v10, v31, 16, v14
; GFX11-NEXT:    v_lshl_or_b32 v11, v30, 16, v13
; GFX11-NEXT:    v_lshl_or_b32 v13, v28, 16, v18
; GFX11-NEXT:    v_lshl_or_b32 v14, v27, 16, v19
; GFX11-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX11-NEXT:    v_and_b32_e32 v18, 0xffff, v16
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    v_lshl_or_b32 v19, v22, 16, v1
; GFX11-NEXT:    v_mov_b32_e32 v1, v21
; GFX11-NEXT:    v_lshl_or_b32 v20, v39, 16, v20
; GFX11-NEXT:    v_lshl_or_b32 v3, v38, 16, v4
; GFX11-NEXT:    v_lshl_or_b32 v4, v37, 16, v48
; GFX11-NEXT:    v_lshl_or_b32 v7, v34, 16, v7
; GFX11-NEXT:    v_lshl_or_b32 v12, v29, 16, v12
; GFX11-NEXT:    v_lshl_or_b32 v15, v26, 16, v15
; GFX11-NEXT:    v_lshl_or_b32 v16, v25, 16, v17
; GFX11-NEXT:    v_lshl_or_b32 v17, v24, 16, v18
; GFX11-NEXT:    v_lshl_or_b32 v18, v23, 16, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, v20
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB29_4:
; GFX11-NEXT:    ; implicit-def: $vgpr39
; GFX11-NEXT:    ; implicit-def: $vgpr21
; GFX11-NEXT:    ; implicit-def: $vgpr2
; GFX11-NEXT:    ; implicit-def: $vgpr38
; GFX11-NEXT:    ; implicit-def: $vgpr37
; GFX11-NEXT:    ; implicit-def: $vgpr36
; GFX11-NEXT:    ; implicit-def: $vgpr35
; GFX11-NEXT:    ; implicit-def: $vgpr34
; GFX11-NEXT:    ; implicit-def: $vgpr33
; GFX11-NEXT:    ; implicit-def: $vgpr32
; GFX11-NEXT:    ; implicit-def: $vgpr31
; GFX11-NEXT:    ; implicit-def: $vgpr30
; GFX11-NEXT:    ; implicit-def: $vgpr29
; GFX11-NEXT:    ; implicit-def: $vgpr28
; GFX11-NEXT:    ; implicit-def: $vgpr27
; GFX11-NEXT:    ; implicit-def: $vgpr26
; GFX11-NEXT:    ; implicit-def: $vgpr25
; GFX11-NEXT:    ; implicit-def: $vgpr24
; GFX11-NEXT:    ; implicit-def: $vgpr23
; GFX11-NEXT:    ; implicit-def: $vgpr22
; GFX11-NEXT:    s_branch .LBB29_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <20 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <20 x float> %a1 to <40 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <20 x float> %a to <40 x i16>
  br label %end

end:
  %phi = phi <40 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <40 x i16> %phi
}

define <20 x float> @bitcast_v40i16_to_v20f32(<40 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v40i16_to_v20f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v52, v6
; SI-NEXT:    v_mov_b32_e32 v53, v4
; SI-NEXT:    v_mov_b32_e32 v54, v2
; SI-NEXT:    v_mov_b32_e32 v55, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:36
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:28
; SI-NEXT:    v_mov_b32_e32 v49, v12
; SI-NEXT:    v_mov_b32_e32 v50, v10
; SI-NEXT:    v_mov_b32_e32 v51, v8
; SI-NEXT:    v_mov_b32_e32 v37, v20
; SI-NEXT:    v_mov_b32_e32 v38, v18
; SI-NEXT:    v_mov_b32_e32 v39, v16
; SI-NEXT:    v_mov_b32_e32 v48, v14
; SI-NEXT:    v_lshlrev_b32_e32 v42, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v41, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v36, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v35, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v40, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v34, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v33, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v32, 16, v15
; SI-NEXT:    s_waitcnt expcnt(5)
; SI-NEXT:    v_lshlrev_b32_e32 v63, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v62, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v61, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v60, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v59, 16, v25
; SI-NEXT:    v_lshlrev_b32_e32 v58, 16, v27
; SI-NEXT:    v_lshlrev_b32_e32 v57, 16, v29
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v56, 16, v0
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v4
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:16
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:20
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_lshlrev_b32_e32 v45, 16, v6
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v47, 16, v8
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v46, 16, v10
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:12
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB30_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v55
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v54
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v53
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v52
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v51
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v50
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v49
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v48
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v39
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v38
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v37
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v43
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    v_or_b32_e32 v0, v0, v42
; SI-NEXT:    v_or_b32_e32 v1, v1, v41
; SI-NEXT:    v_or_b32_e32 v2, v2, v36
; SI-NEXT:    v_or_b32_e32 v3, v3, v35
; SI-NEXT:    v_or_b32_e32 v4, v4, v40
; SI-NEXT:    v_or_b32_e32 v5, v5, v34
; SI-NEXT:    v_or_b32_e32 v6, v6, v33
; SI-NEXT:    v_or_b32_e32 v7, v7, v32
; SI-NEXT:    v_or_b32_e32 v8, v8, v63
; SI-NEXT:    v_or_b32_e32 v9, v9, v62
; SI-NEXT:    v_or_b32_e32 v10, v10, v61
; SI-NEXT:    v_or_b32_e32 v16, v16, v47
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_or_b32_e32 v11, v11, v60
; SI-NEXT:    v_or_b32_e32 v12, v12, v59
; SI-NEXT:    v_or_b32_e32 v13, v13, v58
; SI-NEXT:    v_or_b32_e32 v14, v14, v57
; SI-NEXT:    v_or_b32_e32 v15, v15, v56
; SI-NEXT:    v_or_b32_e32 v17, v17, v46
; SI-NEXT:    v_or_b32_e32 v18, v18, v45
; SI-NEXT:    v_or_b32_e32 v19, v19, v44
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:  .LBB30_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB30_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v55
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v54
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v53
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v52
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v51
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v50
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v49
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v48
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v39
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v38
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v37
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v43
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; SI-NEXT:    v_or_b32_e32 v0, v42, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v41, v1
; SI-NEXT:    v_or_b32_e32 v2, v36, v2
; SI-NEXT:    v_or_b32_e32 v3, v35, v3
; SI-NEXT:    v_or_b32_e32 v4, v40, v4
; SI-NEXT:    v_or_b32_e32 v5, v34, v5
; SI-NEXT:    v_or_b32_e32 v6, v33, v6
; SI-NEXT:    v_or_b32_e32 v7, v32, v7
; SI-NEXT:    v_or_b32_e32 v8, v63, v8
; SI-NEXT:    v_or_b32_e32 v9, v62, v9
; SI-NEXT:    v_or_b32_e32 v10, v61, v10
; SI-NEXT:    v_or_b32_e32 v16, v47, v16
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, s6, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, s6, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, s6, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, s6, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, s6, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, s6, v10
; SI-NEXT:    v_add_i32_e32 v16, vcc, s6, v16
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    v_or_b32_e32 v11, v60, v11
; SI-NEXT:    v_or_b32_e32 v12, v59, v12
; SI-NEXT:    v_or_b32_e32 v13, v58, v13
; SI-NEXT:    v_or_b32_e32 v14, v57, v14
; SI-NEXT:    v_or_b32_e32 v15, v56, v15
; SI-NEXT:    v_or_b32_e32 v17, v46, v17
; SI-NEXT:    v_or_b32_e32 v18, v45, v18
; SI-NEXT:    v_or_b32_e32 v19, v44, v19
; SI-NEXT:    v_add_i32_e32 v11, vcc, s6, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, s6, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, s6, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, s6, v14
; SI-NEXT:    v_add_i32_e32 v15, vcc, s6, v15
; SI-NEXT:    v_add_i32_e32 v17, vcc, s6, v17
; SI-NEXT:    v_add_i32_e32 v18, vcc, s6, v18
; SI-NEXT:    v_add_i32_e32 v19, vcc, s6, v19
; SI-NEXT:  .LBB30_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v40i16_to_v20f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    v_mov_b32_e32 v32, v19
; VI-NEXT:    v_mov_b32_e32 v33, v18
; VI-NEXT:    v_mov_b32_e32 v34, v17
; VI-NEXT:    v_mov_b32_e32 v35, v16
; VI-NEXT:    v_mov_b32_e32 v36, v15
; VI-NEXT:    v_mov_b32_e32 v37, v14
; VI-NEXT:    v_mov_b32_e32 v38, v13
; VI-NEXT:    v_mov_b32_e32 v39, v12
; VI-NEXT:    v_mov_b32_e32 v48, v11
; VI-NEXT:    v_mov_b32_e32 v49, v10
; VI-NEXT:    v_mov_b32_e32 v50, v9
; VI-NEXT:    v_mov_b32_e32 v51, v8
; VI-NEXT:    v_mov_b32_e32 v52, v7
; VI-NEXT:    v_mov_b32_e32 v53, v6
; VI-NEXT:    v_mov_b32_e32 v54, v5
; VI-NEXT:    v_mov_b32_e32 v55, v4
; VI-NEXT:    v_mov_b32_e32 v40, v3
; VI-NEXT:    v_mov_b32_e32 v41, v2
; VI-NEXT:    v_mov_b32_e32 v42, v1
; VI-NEXT:    v_mov_b32_e32 v43, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB30_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_mov_b32_e32 v19, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v19, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v19, v42 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v19, v41 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v3, v19, v40 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v4, v19, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v5, v19, v54 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v6, v19, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v7, v19, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v8, v19, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v9, v19, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v10, v19, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v11, v19, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v12, v19, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v13, v19, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v14, v19, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v15, v19, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v16, v19, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v17, v19, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v18, v19, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v19, v19, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v43, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v42, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v41, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v40, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v55, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v54, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v53, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v52, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v51, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v50, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v49, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v48, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v39, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v38, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v37, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v36, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v35, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v34, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v33, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v32, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:  .LBB30_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB30_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v19, 3
; VI-NEXT:    v_add_u16_e32 v0, 3, v43
; VI-NEXT:    v_add_u16_sdwa v1, v43, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v42
; VI-NEXT:    v_add_u16_sdwa v2, v42, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    v_add_u16_e32 v2, 3, v41
; VI-NEXT:    v_add_u16_sdwa v3, v41, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    v_add_u16_e32 v3, 3, v40
; VI-NEXT:    v_add_u16_sdwa v4, v40, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v55
; VI-NEXT:    v_add_u16_sdwa v5, v55, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v4, v5
; VI-NEXT:    v_add_u16_e32 v5, 3, v54
; VI-NEXT:    v_add_u16_sdwa v6, v54, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v5, v6
; VI-NEXT:    v_add_u16_e32 v6, 3, v53
; VI-NEXT:    v_add_u16_sdwa v7, v53, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v6, v7
; VI-NEXT:    v_add_u16_e32 v7, 3, v52
; VI-NEXT:    v_add_u16_sdwa v8, v52, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v7, v8
; VI-NEXT:    v_add_u16_e32 v8, 3, v51
; VI-NEXT:    v_add_u16_sdwa v9, v51, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v8, v8, v9
; VI-NEXT:    v_add_u16_e32 v9, 3, v50
; VI-NEXT:    v_add_u16_sdwa v10, v50, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v9, v9, v10
; VI-NEXT:    v_add_u16_e32 v10, 3, v49
; VI-NEXT:    v_add_u16_sdwa v11, v49, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v10, v10, v11
; VI-NEXT:    v_add_u16_e32 v11, 3, v48
; VI-NEXT:    v_add_u16_sdwa v12, v48, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v11, v11, v12
; VI-NEXT:    v_add_u16_e32 v12, 3, v39
; VI-NEXT:    v_add_u16_sdwa v13, v39, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v12, v12, v13
; VI-NEXT:    v_add_u16_e32 v13, 3, v38
; VI-NEXT:    v_add_u16_sdwa v14, v38, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v13, v13, v14
; VI-NEXT:    v_add_u16_e32 v14, 3, v37
; VI-NEXT:    v_add_u16_sdwa v15, v37, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v14, v14, v15
; VI-NEXT:    v_add_u16_e32 v15, 3, v36
; VI-NEXT:    v_add_u16_sdwa v16, v36, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v15, v15, v16
; VI-NEXT:    v_add_u16_e32 v16, 3, v35
; VI-NEXT:    v_add_u16_sdwa v17, v35, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v16, v16, v17
; VI-NEXT:    v_add_u16_e32 v17, 3, v34
; VI-NEXT:    v_add_u16_sdwa v18, v34, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v17, v17, v18
; VI-NEXT:    v_add_u16_e32 v18, 3, v33
; VI-NEXT:    v_add_u16_sdwa v20, v33, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v18, v18, v20
; VI-NEXT:    v_add_u16_e32 v20, 3, v32
; VI-NEXT:    v_add_u16_sdwa v19, v32, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v19, v20, v19
; VI-NEXT:  .LBB30_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v40i16_to_v20f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v19
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    v_mov_b32_e32 v33, v18
; GFX9-NEXT:    v_mov_b32_e32 v43, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v32
; GFX9-NEXT:    v_mov_b32_e32 v34, v17
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v33
; GFX9-NEXT:    v_mov_b32_e32 v35, v16
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v34
; GFX9-NEXT:    v_mov_b32_e32 v36, v15
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v35
; GFX9-NEXT:    v_mov_b32_e32 v37, v14
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v36
; GFX9-NEXT:    v_mov_b32_e32 v38, v13
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v37
; GFX9-NEXT:    v_mov_b32_e32 v39, v12
; GFX9-NEXT:    v_mov_b32_e32 v48, v11
; GFX9-NEXT:    v_mov_b32_e32 v49, v10
; GFX9-NEXT:    v_mov_b32_e32 v50, v9
; GFX9-NEXT:    v_mov_b32_e32 v51, v8
; GFX9-NEXT:    v_mov_b32_e32 v52, v7
; GFX9-NEXT:    v_mov_b32_e32 v53, v6
; GFX9-NEXT:    v_mov_b32_e32 v54, v5
; GFX9-NEXT:    v_mov_b32_e32 v55, v4
; GFX9-NEXT:    v_mov_b32_e32 v40, v3
; GFX9-NEXT:    v_mov_b32_e32 v41, v2
; GFX9-NEXT:    v_mov_b32_e32 v42, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v38
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v39
; GFX9-NEXT:    v_lshrrev_b32_e32 v60, 16, v48
; GFX9-NEXT:    v_lshrrev_b32_e32 v61, 16, v49
; GFX9-NEXT:    v_lshrrev_b32_e32 v62, 16, v50
; GFX9-NEXT:    v_lshrrev_b32_e32 v63, 16, v51
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v52
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v53
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v54
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v55
; GFX9-NEXT:    v_lshrrev_b32_e32 v56, 16, v40
; GFX9-NEXT:    v_lshrrev_b32_e32 v57, 16, v41
; GFX9-NEXT:    v_lshrrev_b32_e32 v58, 16, v42
; GFX9-NEXT:    v_lshrrev_b32_e32 v59, 16, v43
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB30_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 16, v39
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 16, v38
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v37
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 16, v36
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v16, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v19, 16, v32
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    v_perm_b32 v0, v59, v43, s6
; GFX9-NEXT:    v_perm_b32 v1, v58, v42, s6
; GFX9-NEXT:    v_perm_b32 v2, v57, v41, s6
; GFX9-NEXT:    v_perm_b32 v3, v56, v40, s6
; GFX9-NEXT:    v_perm_b32 v4, v47, v55, s6
; GFX9-NEXT:    v_perm_b32 v5, v46, v54, s6
; GFX9-NEXT:    v_perm_b32 v6, v45, v53, s6
; GFX9-NEXT:    v_perm_b32 v7, v44, v52, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v51, s6
; GFX9-NEXT:    v_perm_b32 v9, v62, v50, s6
; GFX9-NEXT:    v_perm_b32 v10, v61, v49, s6
; GFX9-NEXT:    v_perm_b32 v11, v60, v48, s6
; GFX9-NEXT:    v_perm_b32 v12, v12, v39, s6
; GFX9-NEXT:    v_perm_b32 v13, v13, v38, s6
; GFX9-NEXT:    v_perm_b32 v14, v14, v37, s6
; GFX9-NEXT:    v_perm_b32 v15, v15, v36, s6
; GFX9-NEXT:    v_perm_b32 v16, v16, v35, s6
; GFX9-NEXT:    v_perm_b32 v17, v17, v34, s6
; GFX9-NEXT:    v_perm_b32 v18, v18, v33, s6
; GFX9-NEXT:    v_perm_b32 v19, v19, v32, s6
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr60
; GFX9-NEXT:    ; implicit-def: $vgpr61
; GFX9-NEXT:    ; implicit-def: $vgpr62
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr56
; GFX9-NEXT:    ; implicit-def: $vgpr57
; GFX9-NEXT:    ; implicit-def: $vgpr58
; GFX9-NEXT:    ; implicit-def: $vgpr59
; GFX9-NEXT:  .LBB30_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB30_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v59, v43, s6
; GFX9-NEXT:    v_perm_b32 v1, v58, v42, s6
; GFX9-NEXT:    v_perm_b32 v2, v57, v41, s6
; GFX9-NEXT:    v_perm_b32 v3, v56, v40, s6
; GFX9-NEXT:    v_perm_b32 v4, v47, v55, s6
; GFX9-NEXT:    v_perm_b32 v5, v46, v54, s6
; GFX9-NEXT:    v_perm_b32 v6, v45, v53, s6
; GFX9-NEXT:    v_perm_b32 v7, v44, v52, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v51, s6
; GFX9-NEXT:    v_perm_b32 v9, v62, v50, s6
; GFX9-NEXT:    v_perm_b32 v10, v61, v49, s6
; GFX9-NEXT:    v_perm_b32 v11, v60, v48, s6
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(7)
; GFX9-NEXT:    v_perm_b32 v12, v12, v39, s6
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_perm_b32 v13, v13, v38, s6
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_perm_b32 v14, v14, v37, s6
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_perm_b32 v15, v15, v36, s6
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_perm_b32 v16, v16, v35, s6
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_perm_b32 v17, v17, v34, s6
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_perm_b32 v18, v18, v33, s6
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v19, v19, v32, s6
; GFX9-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB30_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v40i16_to_v20f32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB30_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:  .LBB30_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v40i16_to_v20f32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v3
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v37, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v38, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v39, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v48, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v36, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v35, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v34, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v33, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v32, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v31, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v30, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v29, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v28, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v27, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v26, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v25, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v24, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v23, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v22, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v21, v19, 0x5040100
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB30_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:  .LBB30_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <40 x i16> %a, splat (i16 3)
  %a2 = bitcast <40 x i16> %a1 to <20 x float>
  br label %end

cmp.false:
  %a3 = bitcast <40 x i16> %a to <20 x float>
  br label %end

end:
  %phi = phi <20 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x float> %phi
}

define inreg <20 x float> @bitcast_v40i16_to_v20f32_scalar(<40 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v40i16_to_v20f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v26
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v32, v24
; SI-NEXT:    v_mov_b32_e32 v33, v22
; SI-NEXT:    v_mov_b32_e32 v34, v20
; SI-NEXT:    v_mov_b32_e32 v35, v18
; SI-NEXT:    v_mov_b32_e32 v36, v16
; SI-NEXT:    v_mov_b32_e32 v37, v14
; SI-NEXT:    v_mov_b32_e32 v38, v12
; SI-NEXT:    v_mov_b32_e32 v39, v10
; SI-NEXT:    v_mov_b32_e32 v48, v8
; SI-NEXT:    v_mov_b32_e32 v49, v6
; SI-NEXT:    v_mov_b32_e32 v50, v4
; SI-NEXT:    v_mov_b32_e32 v51, v2
; SI-NEXT:    v_mov_b32_e32 v52, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v57, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v56, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v47, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v46, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v45, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v43, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v42, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v41, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v40, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v55, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v54, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v53, 16, v25
; SI-NEXT:    s_cbranch_scc0 .LBB31_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v52
; SI-NEXT:    v_or_b32_e32 v7, v0, v57
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v51
; SI-NEXT:    v_or_b32_e32 v8, v0, v56
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v50
; SI-NEXT:    v_or_b32_e32 v9, v0, v47
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v49
; SI-NEXT:    v_or_b32_e32 v10, v0, v46
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v48
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    v_or_b32_e32 v11, v0, v45
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v39
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    v_or_b32_e32 v12, v0, v44
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v38
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    v_or_b32_e32 v13, v0, v43
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v37
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    v_or_b32_e32 v14, v0, v42
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v36
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    v_or_b32_e32 v15, v0, v41
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v35
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    v_or_b32_e32 v16, v0, v40
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v34
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_or_b32_e32 v17, v0, v55
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v33
; SI-NEXT:    s_or_b32 s10, s10, s11
; SI-NEXT:    v_or_b32_e32 v18, v0, v54
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v32
; SI-NEXT:    v_or_b32_e32 v19, v0, v53
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    s_cbranch_execnz .LBB31_3
; SI-NEXT:  .LBB31_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v52
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v57, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v51
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v56, v0
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v50
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v47, v0
; SI-NEXT:    v_add_i32_e32 v9, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v49
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v46, v0
; SI-NEXT:    v_add_i32_e32 v10, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v48
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v45, v0
; SI-NEXT:    v_add_i32_e32 v11, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v39
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v44, v0
; SI-NEXT:    v_add_i32_e32 v12, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v38
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v43, v0
; SI-NEXT:    v_add_i32_e32 v13, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v37
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v42, v0
; SI-NEXT:    v_add_i32_e32 v14, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v36
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v41, v0
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v35
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    v_or_b32_e32 v0, v40, v0
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    v_add_i32_e32 v16, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v34
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    v_or_b32_e32 v0, v55, v0
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    v_add_i32_e32 v17, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v33
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    v_or_b32_e32 v0, v54, v0
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_add_i32_e32 v18, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v32
; SI-NEXT:    s_or_b32 s10, s11, s10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:    s_add_i32 s10, s10, 0x30000
; SI-NEXT:    v_or_b32_e32 v0, v53, v0
; SI-NEXT:    v_add_i32_e32 v19, vcc, 0x30000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:  .LBB31_3: ; %end
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB31_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    s_branch .LBB31_2
;
; VI-LABEL: bitcast_v40i16_to_v20f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s6, s29, 16
; VI-NEXT:    s_lshr_b32 s7, s28, 16
; VI-NEXT:    s_lshr_b32 s8, s27, 16
; VI-NEXT:    s_lshr_b32 s9, s26, 16
; VI-NEXT:    s_lshr_b32 s10, s25, 16
; VI-NEXT:    s_lshr_b32 s11, s24, 16
; VI-NEXT:    s_lshr_b32 s12, s23, 16
; VI-NEXT:    s_lshr_b32 s13, s22, 16
; VI-NEXT:    s_lshr_b32 s14, s21, 16
; VI-NEXT:    s_lshr_b32 s15, s20, 16
; VI-NEXT:    s_lshr_b32 s40, s19, 16
; VI-NEXT:    s_lshr_b32 s41, s18, 16
; VI-NEXT:    s_lshr_b32 s42, s17, 16
; VI-NEXT:    s_lshr_b32 s43, s16, 16
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    v_mov_b32_e32 v32, v5
; VI-NEXT:    v_mov_b32_e32 v33, v4
; VI-NEXT:    v_mov_b32_e32 v34, v3
; VI-NEXT:    v_mov_b32_e32 v35, v2
; VI-NEXT:    v_mov_b32_e32 v36, v1
; VI-NEXT:    v_mov_b32_e32 v37, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    s_cbranch_scc0 .LBB31_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s43, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s44, s42, 16
; VI-NEXT:    s_or_b32 s5, s5, s44
; VI-NEXT:    s_and_b32 s44, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s45, s41, 16
; VI-NEXT:    s_or_b32 s44, s44, s45
; VI-NEXT:    s_and_b32 s45, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s46, s40, 16
; VI-NEXT:    s_or_b32 s45, s45, s46
; VI-NEXT:    s_and_b32 s46, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s47, s15, 16
; VI-NEXT:    s_or_b32 s46, s46, s47
; VI-NEXT:    s_and_b32 s47, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s56, s14, 16
; VI-NEXT:    s_or_b32 s47, s47, s56
; VI-NEXT:    s_and_b32 s56, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s57, s13, 16
; VI-NEXT:    s_or_b32 s56, s56, s57
; VI-NEXT:    s_and_b32 s57, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s58, s12, 16
; VI-NEXT:    s_or_b32 s57, s57, s58
; VI-NEXT:    s_and_b32 s58, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s59, s11, 16
; VI-NEXT:    s_or_b32 s58, s58, s59
; VI-NEXT:    s_and_b32 s59, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s60, s10, 16
; VI-NEXT:    v_mov_b32_e32 v0, 16
; VI-NEXT:    s_or_b32 s59, s59, s60
; VI-NEXT:    s_and_b32 s60, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s61, s9, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s60, s60, s61
; VI-NEXT:    s_and_b32 s61, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s62, s8, 16
; VI-NEXT:    v_or_b32_sdwa v14, v37, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s61, s61, s62
; VI-NEXT:    s_and_b32 s62, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s63, s7, 16
; VI-NEXT:    v_or_b32_sdwa v16, v35, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s62, s62, s63
; VI-NEXT:    s_and_b32 s63, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s72, s6, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v0, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v17, v34, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v0, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s63, s63, s72
; VI-NEXT:    v_or_b32_sdwa v15, v36, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v33, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v32, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s44
; VI-NEXT:    v_mov_b32_e32 v3, s45
; VI-NEXT:    v_mov_b32_e32 v4, s46
; VI-NEXT:    v_mov_b32_e32 v5, s47
; VI-NEXT:    v_mov_b32_e32 v6, s56
; VI-NEXT:    v_mov_b32_e32 v7, s57
; VI-NEXT:    v_mov_b32_e32 v8, s58
; VI-NEXT:    v_mov_b32_e32 v9, s59
; VI-NEXT:    v_mov_b32_e32 v10, s60
; VI-NEXT:    v_mov_b32_e32 v11, s61
; VI-NEXT:    v_mov_b32_e32 v12, s62
; VI-NEXT:    v_mov_b32_e32 v13, s63
; VI-NEXT:    s_cbranch_execnz .LBB31_3
; VI-NEXT:  .LBB31_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s43, 16
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s17, 0xffff
; VI-NEXT:    s_lshl_b32 s16, s42, 16
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s5, s16, s5
; VI-NEXT:    s_and_b32 s16, s18, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s41, 16
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_or_b32 s16, s17, s16
; VI-NEXT:    s_and_b32 s17, s19, 0xffff
; VI-NEXT:    s_lshl_b32 s18, s40, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    v_mov_b32_e32 v1, 16
; VI-NEXT:    s_or_b32 s17, s18, s17
; VI-NEXT:    s_and_b32 s18, s20, 0xffff
; VI-NEXT:    s_lshl_b32 s15, s15, 16
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v37
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s15, s15, s18
; VI-NEXT:    s_and_b32 s18, s21, 0xffff
; VI-NEXT:    s_lshl_b32 s14, s14, 16
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v36
; VI-NEXT:    v_lshlrev_b32_sdwa v3, v1, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s14, s14, s18
; VI-NEXT:    s_and_b32 s18, s22, 0xffff
; VI-NEXT:    s_lshl_b32 s13, s13, 16
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s13, s13, s18
; VI-NEXT:    s_and_b32 s18, s23, 0xffff
; VI-NEXT:    s_lshl_b32 s12, s12, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    v_add_u32_e32 v14, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v15, vcc, 0x30000, v2
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v35
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s12, s12, s18
; VI-NEXT:    s_and_b32 s18, s24, 0xffff
; VI-NEXT:    s_lshl_b32 s11, s11, 16
; VI-NEXT:    s_add_i32 s25, s25, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s11, s11, s18
; VI-NEXT:    s_and_b32 s18, s25, 0xffff
; VI-NEXT:    s_lshl_b32 s10, s10, 16
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    v_add_u32_e32 v16, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v34
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s10, s10, s18
; VI-NEXT:    s_and_b32 s18, s26, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    s_add_i32 s27, s27, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s9, s9, s18
; VI-NEXT:    s_and_b32 s18, s27, 0xffff
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    s_or_b32 s8, s8, s18
; VI-NEXT:    s_and_b32 s18, s28, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_add_i32 s29, s29, 3
; VI-NEXT:    v_add_u32_e32 v17, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v33
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s7, s7, s18
; VI-NEXT:    s_and_b32 s18, s29, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s6, s6, s18
; VI-NEXT:    v_add_u32_e32 v18, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v32
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v1, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_add_i32 s4, s4, 0x30000
; VI-NEXT:    s_add_i32 s5, s5, 0x30000
; VI-NEXT:    s_add_i32 s16, s16, 0x30000
; VI-NEXT:    s_add_i32 s17, s17, 0x30000
; VI-NEXT:    s_add_i32 s15, s15, 0x30000
; VI-NEXT:    s_add_i32 s14, s14, 0x30000
; VI-NEXT:    s_add_i32 s13, s13, 0x30000
; VI-NEXT:    s_add_i32 s12, s12, 0x30000
; VI-NEXT:    s_add_i32 s11, s11, 0x30000
; VI-NEXT:    s_add_i32 s10, s10, 0x30000
; VI-NEXT:    s_add_i32 s9, s9, 0x30000
; VI-NEXT:    s_add_i32 s8, s8, 0x30000
; VI-NEXT:    s_add_i32 s7, s7, 0x30000
; VI-NEXT:    s_add_i32 s6, s6, 0x30000
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v19, vcc, 0x30000, v0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    v_mov_b32_e32 v3, s17
; VI-NEXT:    v_mov_b32_e32 v4, s15
; VI-NEXT:    v_mov_b32_e32 v5, s14
; VI-NEXT:    v_mov_b32_e32 v6, s13
; VI-NEXT:    v_mov_b32_e32 v7, s12
; VI-NEXT:    v_mov_b32_e32 v8, s11
; VI-NEXT:    v_mov_b32_e32 v9, s10
; VI-NEXT:    v_mov_b32_e32 v10, s9
; VI-NEXT:    v_mov_b32_e32 v11, s8
; VI-NEXT:    v_mov_b32_e32 v12, s7
; VI-NEXT:    v_mov_b32_e32 v13, s6
; VI-NEXT:  .LBB31_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB31_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_branch .LBB31_2
;
; GFX9-LABEL: bitcast_v40i16_to_v20f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v5
; GFX9-NEXT:    v_mov_b32_e32 v33, v4
; GFX9-NEXT:    v_mov_b32_e32 v34, v3
; GFX9-NEXT:    v_mov_b32_e32 v35, v2
; GFX9-NEXT:    v_mov_b32_e32 v36, v1
; GFX9-NEXT:    v_mov_b32_e32 v37, v0
; GFX9-NEXT:    s_lshr_b32 s40, s29, 16
; GFX9-NEXT:    s_lshr_b32 s41, s28, 16
; GFX9-NEXT:    s_lshr_b32 s42, s27, 16
; GFX9-NEXT:    s_lshr_b32 s43, s26, 16
; GFX9-NEXT:    s_lshr_b32 s15, s25, 16
; GFX9-NEXT:    s_lshr_b32 s14, s24, 16
; GFX9-NEXT:    s_lshr_b32 s13, s23, 16
; GFX9-NEXT:    s_lshr_b32 s12, s22, 16
; GFX9-NEXT:    s_lshr_b32 s11, s21, 16
; GFX9-NEXT:    s_lshr_b32 s10, s20, 16
; GFX9-NEXT:    s_lshr_b32 s9, s19, 16
; GFX9-NEXT:    s_lshr_b32 s8, s18, 16
; GFX9-NEXT:    s_lshr_b32 s7, s17, 16
; GFX9-NEXT:    s_lshr_b32 s6, s16, 16
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v36
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v37
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s16, s6
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s17, s7
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s18, s8
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s19, s9
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s20, s10
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s21, s11
; GFX9-NEXT:    s_pack_ll_b32_b16 s12, s22, s12
; GFX9-NEXT:    s_pack_ll_b32_b16 s13, s23, s13
; GFX9-NEXT:    s_pack_ll_b32_b16 s14, s24, s14
; GFX9-NEXT:    s_pack_ll_b32_b16 s15, s25, s15
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s26, s43
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s27, s42
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s28, s41
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s29, s40
; GFX9-NEXT:    s_cbranch_scc0 .LBB31_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v37
; GFX9-NEXT:    v_lshl_or_b32 v14, v51, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v36
; GFX9-NEXT:    v_lshl_or_b32 v15, v50, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v35
; GFX9-NEXT:    v_lshl_or_b32 v16, v49, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v34
; GFX9-NEXT:    v_lshl_or_b32 v17, v48, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v33
; GFX9-NEXT:    v_lshl_or_b32 v18, v39, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v32
; GFX9-NEXT:    v_lshl_or_b32 v19, v38, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_mov_b32_e32 v6, s12
; GFX9-NEXT:    v_mov_b32_e32 v7, s13
; GFX9-NEXT:    v_mov_b32_e32 v8, s14
; GFX9-NEXT:    v_mov_b32_e32 v9, s15
; GFX9-NEXT:    v_mov_b32_e32 v10, s16
; GFX9-NEXT:    v_mov_b32_e32 v11, s17
; GFX9-NEXT:    v_mov_b32_e32 v12, s18
; GFX9-NEXT:    v_mov_b32_e32 v13, s19
; GFX9-NEXT:    s_cbranch_execnz .LBB31_3
; GFX9-NEXT:  .LBB31_2: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff, v37
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v36
; GFX9-NEXT:    v_and_b32_e32 v16, 0xffff, v35
; GFX9-NEXT:    v_and_b32_e32 v17, 0xffff, v34
; GFX9-NEXT:    v_and_b32_e32 v18, 0xffff, v33
; GFX9-NEXT:    v_and_b32_e32 v19, 0xffff, v32
; GFX9-NEXT:    v_lshl_or_b32 v14, v51, 16, v14
; GFX9-NEXT:    v_lshl_or_b32 v15, v50, 16, v15
; GFX9-NEXT:    v_lshl_or_b32 v16, v49, 16, v16
; GFX9-NEXT:    v_lshl_or_b32 v17, v48, 16, v17
; GFX9-NEXT:    v_lshl_or_b32 v18, v39, 16, v18
; GFX9-NEXT:    v_lshl_or_b32 v19, v38, 16, v19
; GFX9-NEXT:    v_pk_add_u16 v0, s6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, s11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, s12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, s13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, s14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v9, s15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v12, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB31_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB31_4:
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_branch .LBB31_2
;
; GFX11-TRUE16-LABEL: bitcast_v40i16_to_v20f32_scalar:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.h, 0
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.l, v1.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.l, v0.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v35, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.h, v32.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v34, 0xffff, v1
; GFX11-TRUE16-NEXT:    s_lshr_b32 s41, s29, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s42, s28, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s43, s27, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s44, s26, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s45, s25, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s15, s24, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s13, s22, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s12, s21, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s11, s20, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s10, s19, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s9, s18, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s8, s17, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s7, s16, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s6, s2, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s4, s0, 16
; GFX11-TRUE16-NEXT:    s_mov_b32 s40, 0
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s4, s0, s4
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s5, s1, s5
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s6, s2, s6
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s7, s16, s7
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s8, s17, s8
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s9, s18, s9
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s10, s19, s10
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s11, s20, s11
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s12, s21, s12
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s13, s22, s13
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s15, s24, s15
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s16, s25, s45
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s17, s26, s44
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s0, s27, s43
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s1, s28, s42
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s2, s29, s41
; GFX11-TRUE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-TRUE16-NEXT:    s_cbranch_scc0 .LBB31_4
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s3
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v4, s7 :: v_dual_mov_b32 v5, s8
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v6, s9 :: v_dual_mov_b32 v7, s10
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v8, s11 :: v_dual_mov_b32 v9, s12
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v10, s13 :: v_dual_mov_b32 v11, s14
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v12, s15 :: v_dual_mov_b32 v13, s16
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v14, s17 :: v_dual_mov_b32 v15, s0
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v16, s1 :: v_dual_mov_b32 v17, s2
; GFX11-TRUE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s40
; GFX11-TRUE16-NEXT:    s_cbranch_vccnz .LBB31_3
; GFX11-TRUE16-NEXT:  .LBB31_2: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v0, s4, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v1, s5, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v2, s6, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v4, s7, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v5, s8, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v6, s9, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v7, s10, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v8, s11, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v9, s12, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v10, s13, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v11, s14, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v12, s15, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v13, s16, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v14, s17, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v15, s0, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v16, s1, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v17, s2, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:  .LBB31_3: ; %end
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB31_4:
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-TRUE16-NEXT:    s_branch .LBB31_2
;
; GFX11-FAKE16-LABEL: bitcast_v40i16_to_v20f32_scalar:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v35, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v34, 0xffff, v1
; GFX11-FAKE16-NEXT:    s_lshr_b32 s41, s29, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s42, s28, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s43, s27, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s44, s26, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s45, s25, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s15, s24, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s13, s22, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s12, s21, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s11, s20, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s10, s19, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s9, s18, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s8, s17, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s7, s16, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s6, s2, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s4, s0, 16
; GFX11-FAKE16-NEXT:    s_mov_b32 s40, 0
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s4, s0, s4
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s5, s1, s5
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s6, s2, s6
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s7, s16, s7
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s8, s17, s8
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s9, s18, s9
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s10, s19, s10
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s11, s20, s11
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s12, s21, s12
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s13, s22, s13
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s15, s24, s15
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s16, s25, s45
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s17, s26, s44
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s0, s27, s43
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s1, s28, s42
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s2, s29, s41
; GFX11-FAKE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-FAKE16-NEXT:    s_cbranch_scc0 .LBB31_4
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s3
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v4, s7 :: v_dual_mov_b32 v5, s8
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v6, s9 :: v_dual_mov_b32 v7, s10
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v8, s11 :: v_dual_mov_b32 v9, s12
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v10, s13 :: v_dual_mov_b32 v11, s14
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v12, s15 :: v_dual_mov_b32 v13, s16
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v14, s17 :: v_dual_mov_b32 v15, s0
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v16, s1 :: v_dual_mov_b32 v17, s2
; GFX11-FAKE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s40
; GFX11-FAKE16-NEXT:    s_cbranch_vccnz .LBB31_3
; GFX11-FAKE16-NEXT:  .LBB31_2: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v0, s4, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v1, s5, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v2, s6, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v4, s7, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v5, s8, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v6, s9, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v7, s10, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v8, s11, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v9, s12, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v10, s13, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v11, s14, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v12, s15, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v13, s16, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v14, s17, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v15, s0, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v16, s1, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v17, s2, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:  .LBB31_3: ; %end
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB31_4:
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-FAKE16-NEXT:    s_branch .LBB31_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <40 x i16> %a, splat (i16 3)
  %a2 = bitcast <40 x i16> %a1 to <20 x float>
  br label %end

cmp.false:
  %a3 = bitcast <40 x i16> %a to <20 x float>
  br label %end

end:
  %phi = phi <20 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x float> %phi
}

define <40 x half> @bitcast_v20f32_to_v40f16(<20 x float> %a, i32 %b) {
; SI-LABEL: bitcast_v20f32_to_v40f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v21
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB32_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v32, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v34, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v36, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v39, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v49, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v51, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v53, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v55, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v41, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v43, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v4
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_cvt_f32_f16_e32 v46, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v3
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_cvt_f32_f16_e32 v56, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v21, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v19
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_cvt_f32_f16_e32 v58, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v60, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v33, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v35, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v37, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v38, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v48, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v50, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v52, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v54, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v40, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v42, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v44, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v45, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v47, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v57, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v59, v1
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:  .LBB32_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB32_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; SI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; SI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; SI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; SI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; SI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; SI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; SI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; SI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; SI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; SI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; SI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; SI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; SI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; SI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; SI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; SI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; SI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; SI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; SI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v60, 16, v1
; SI-NEXT:    v_lshrrev_b32_e32 v58, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v46, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v43, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v55, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v51, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v49, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v13
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v28, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v26, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v24, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v19
; SI-NEXT:    v_lshrrev_b32_e32 v21, 16, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v33, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v35, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v37, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v38, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v48, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v50, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v52, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v54, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v40, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v42, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v44, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v45, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v47, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v57, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v59, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v32, v32
; SI-NEXT:    v_cvt_f32_f16_e32 v34, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v36, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v39, v39
; SI-NEXT:    v_cvt_f32_f16_e32 v49, v49
; SI-NEXT:    v_cvt_f32_f16_e32 v51, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v53, v53
; SI-NEXT:    v_cvt_f32_f16_e32 v55, v55
; SI-NEXT:    v_cvt_f32_f16_e32 v41, v41
; SI-NEXT:    v_cvt_f32_f16_e32 v43, v43
; SI-NEXT:    v_cvt_f32_f16_e32 v46, v46
; SI-NEXT:    v_cvt_f32_f16_e32 v56, v56
; SI-NEXT:    v_cvt_f32_f16_e32 v58, v58
; SI-NEXT:    v_cvt_f32_f16_e32 v60, v60
; SI-NEXT:  .LBB32_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v60
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v59
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v58
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v57
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v2, v4, v2
; SI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v56
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v47
; SI-NEXT:    v_add_i32_e32 v3, vcc, 8, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v46
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v45
; SI-NEXT:    v_add_i32_e32 v3, vcc, 12, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v43
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v44
; SI-NEXT:    v_add_i32_e32 v3, vcc, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v41
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v42
; SI-NEXT:    v_add_i32_e32 v3, vcc, 20, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v55
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v40
; SI-NEXT:    v_add_i32_e32 v3, vcc, 24, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v53
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v54
; SI-NEXT:    v_add_i32_e32 v3, vcc, 28, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v51
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v52
; SI-NEXT:    v_add_i32_e32 v3, vcc, 32, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v49
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v50
; SI-NEXT:    v_add_i32_e32 v3, vcc, 36, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v39
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v48
; SI-NEXT:    v_add_i32_e32 v3, vcc, 40, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v38
; SI-NEXT:    v_add_i32_e32 v3, vcc, 44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v34
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v37
; SI-NEXT:    v_add_i32_e32 v3, vcc, 48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v32
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v35
; SI-NEXT:    v_add_i32_e32 v3, vcc, 52, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v30
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v33
; SI-NEXT:    v_add_i32_e32 v3, vcc, 56, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v31
; SI-NEXT:    v_add_i32_e32 v3, vcc, 60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v29
; SI-NEXT:    v_add_i32_e32 v3, vcc, 64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v27
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v25
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v23
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x4c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v20f32_to_v40f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr27
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr25
; VI-NEXT:    ; implicit-def: $vgpr24
; VI-NEXT:    ; implicit-def: $vgpr23
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr21
; VI-NEXT:    ; implicit-def: $vgpr20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB32_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; VI-NEXT:  .LBB32_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB32_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v6, 1.0, v6
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; VI-NEXT:  .LBB32_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; VI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; VI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; VI-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; VI-NEXT:    v_lshlrev_b32_e32 v35, 16, v35
; VI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; VI-NEXT:    v_lshlrev_b32_e32 v33, 16, v33
; VI-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; VI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; VI-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; VI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; VI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; VI-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; VI-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; VI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; VI-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; VI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; VI-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; VI-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; VI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; VI-NEXT:    v_or_b32_sdwa v0, v0, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v8, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v9, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v10, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v11, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v12, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v13, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v14, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v15, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v16, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v17, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v18, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v19, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v20f32_to_v40f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr27
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr25
; GFX9-NEXT:    ; implicit-def: $vgpr24
; GFX9-NEXT:    ; implicit-def: $vgpr23
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr21
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB32_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX9-NEXT:  .LBB32_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB32_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v6, 1.0, v6
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX9-NEXT:  .LBB32_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v39, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v38, v1, s4
; GFX9-NEXT:    v_perm_b32 v2, v37, v2, s4
; GFX9-NEXT:    v_perm_b32 v3, v36, v3, s4
; GFX9-NEXT:    v_perm_b32 v4, v35, v4, s4
; GFX9-NEXT:    v_perm_b32 v5, v34, v5, s4
; GFX9-NEXT:    v_perm_b32 v6, v33, v6, s4
; GFX9-NEXT:    v_perm_b32 v7, v32, v7, s4
; GFX9-NEXT:    v_perm_b32 v8, v31, v8, s4
; GFX9-NEXT:    v_perm_b32 v9, v30, v9, s4
; GFX9-NEXT:    v_perm_b32 v10, v29, v10, s4
; GFX9-NEXT:    v_perm_b32 v11, v28, v11, s4
; GFX9-NEXT:    v_perm_b32 v12, v27, v12, s4
; GFX9-NEXT:    v_perm_b32 v13, v26, v13, s4
; GFX9-NEXT:    v_perm_b32 v14, v25, v14, s4
; GFX9-NEXT:    v_perm_b32 v15, v24, v15, s4
; GFX9-NEXT:    v_perm_b32 v16, v23, v16, s4
; GFX9-NEXT:    v_perm_b32 v17, v22, v17, s4
; GFX9-NEXT:    v_perm_b32 v18, v21, v18, s4
; GFX9-NEXT:    v_perm_b32 v19, v20, v19, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v20f32_to_v40f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB32_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-TRUE16-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-TRUE16-NEXT:  .LBB32_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v20f32_to_v40f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr27
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr25
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr24
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr23
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr20
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB32_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX11-FAKE16-NEXT:  .LBB32_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB32_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v17, 1.0, v17 :: v_dual_add_f32 v16, 1.0, v16
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v2, 1.0, v2
; GFX11-FAKE16-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX11-FAKE16-NEXT:  .LBB32_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v39, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v38, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v37, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v36, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v35, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v34, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v33, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v32, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v31, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v30, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v29, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v28, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v27, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v26, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v25, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v24, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v23, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v22, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v21, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v20, v19, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <20 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <20 x float> %a1 to <40 x half>
  br label %end

cmp.false:
  %a3 = bitcast <20 x float> %a to <40 x half>
  br label %end

end:
  %phi = phi <40 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <40 x half> %phi
}

define inreg <40 x half> @bitcast_v20f32_to_v40f16_scalar(<20 x float> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v20f32_to_v40f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v7
; SI-NEXT:    v_readfirstlane_b32 s11, v1
; SI-NEXT:    v_readfirstlane_b32 s10, v2
; SI-NEXT:    v_readfirstlane_b32 s8, v3
; SI-NEXT:    v_readfirstlane_b32 s7, v4
; SI-NEXT:    v_readfirstlane_b32 s6, v5
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_readfirstlane_b32 s9, v6
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    s_cbranch_scc0 .LBB33_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s9, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    s_lshr_b32 s4, s6, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s4
; SI-NEXT:    s_lshr_b32 s4, s7, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s4
; SI-NEXT:    s_lshr_b32 s4, s8, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s4
; SI-NEXT:    s_lshr_b32 s4, s10, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s4
; SI-NEXT:    s_lshr_b32 s4, s11, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s4
; SI-NEXT:    s_lshr_b32 s4, s29, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s4
; SI-NEXT:    s_lshr_b32 s4, s28, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s4
; SI-NEXT:    s_lshr_b32 s4, s27, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v16, s4
; SI-NEXT:    s_lshr_b32 s4, s26, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v19, s4
; SI-NEXT:    s_lshr_b32 s4, s25, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v21, s4
; SI-NEXT:    s_lshr_b32 s4, s24, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v23, s4
; SI-NEXT:    s_lshr_b32 s4, s23, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v25, s4
; SI-NEXT:    s_lshr_b32 s4, s22, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v27, s4
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v29, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v31, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v34, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v36, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v38, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v48, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s9
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s8
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s10
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s11
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s29
; SI-NEXT:    v_cvt_f32_f16_e32 v17, s28
; SI-NEXT:    v_cvt_f32_f16_e32 v18, s27
; SI-NEXT:    v_cvt_f32_f16_e32 v20, s26
; SI-NEXT:    v_cvt_f32_f16_e32 v22, s25
; SI-NEXT:    v_cvt_f32_f16_e32 v24, s24
; SI-NEXT:    v_cvt_f32_f16_e32 v26, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v28, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v30, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v32, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v33, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v35, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v37, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v39, s16
; SI-NEXT:    s_cbranch_execnz .LBB33_3
; SI-NEXT:  .LBB33_2: ; %cmp.true
; SI-NEXT:    v_add_f32_e64 v1, s16, 1.0
; SI-NEXT:    v_add_f32_e64 v2, s17, 1.0
; SI-NEXT:    v_add_f32_e64 v4, s18, 1.0
; SI-NEXT:    v_add_f32_e64 v6, s19, 1.0
; SI-NEXT:    v_add_f32_e64 v8, s20, 1.0
; SI-NEXT:    v_add_f32_e64 v10, s21, 1.0
; SI-NEXT:    v_add_f32_e64 v12, s22, 1.0
; SI-NEXT:    v_add_f32_e64 v14, s23, 1.0
; SI-NEXT:    v_add_f32_e64 v16, s24, 1.0
; SI-NEXT:    v_add_f32_e64 v19, s25, 1.0
; SI-NEXT:    v_add_f32_e64 v20, s26, 1.0
; SI-NEXT:    v_add_f32_e64 v18, s27, 1.0
; SI-NEXT:    v_add_f32_e64 v17, s28, 1.0
; SI-NEXT:    v_add_f32_e64 v15, s29, 1.0
; SI-NEXT:    v_add_f32_e64 v13, s11, 1.0
; SI-NEXT:    v_add_f32_e64 v11, s10, 1.0
; SI-NEXT:    v_add_f32_e64 v9, s8, 1.0
; SI-NEXT:    v_add_f32_e64 v7, s7, 1.0
; SI-NEXT:    v_add_f32_e64 v5, s6, 1.0
; SI-NEXT:    v_add_f32_e64 v3, s9, 1.0
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v1
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v21, 16, v19
; SI-NEXT:    v_lshrrev_b32_e32 v49, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v50, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v51, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v52, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v13
; SI-NEXT:    v_lshrrev_b32_e32 v54, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v55, 16, v9
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_lshrrev_b32_e32 v40, 16, v7
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_lshrrev_b32_e32 v41, 16, v5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v42, 16, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v32, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v33, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v35, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v37, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v39, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v42
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v41
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v40
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v55
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v54
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v53
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v52
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v50
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v49
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v25
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v27
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v31
; SI-NEXT:    v_cvt_f32_f16_e32 v34, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v36, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v38, v38
; SI-NEXT:    v_cvt_f32_f16_e32 v48, v48
; SI-NEXT:  .LBB33_3: ; %end
; SI-NEXT:    v_cvt_f16_f32_e32 v48, v48
; SI-NEXT:    v_cvt_f16_f32_e32 v39, v39
; SI-NEXT:    v_cvt_f16_f32_e32 v38, v38
; SI-NEXT:    v_cvt_f16_f32_e32 v37, v37
; SI-NEXT:    v_cvt_f16_f32_e32 v36, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v35, v35
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v34
; SI-NEXT:    v_lshlrev_b32_e32 v48, 16, v48
; SI-NEXT:    v_cvt_f16_f32_e32 v33, v33
; SI-NEXT:    v_cvt_f16_f32_e32 v31, v31
; SI-NEXT:    v_or_b32_e32 v39, v39, v48
; SI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v32
; SI-NEXT:    v_cvt_f16_f32_e32 v29, v29
; SI-NEXT:    buffer_store_dword v39, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v39, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v37, v37, v38
; SI-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v30, v30
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v27
; SI-NEXT:    buffer_store_dword v37, v39, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v37, vcc, 8, v0
; SI-NEXT:    v_or_b32_e32 v35, v35, v36
; SI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v25, v25
; SI-NEXT:    buffer_store_dword v35, v37, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v35, vcc, 12, v0
; SI-NEXT:    v_or_b32_e32 v33, v33, v34
; SI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v23
; SI-NEXT:    buffer_store_dword v33, v35, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v33, vcc, 16, v0
; SI-NEXT:    v_or_b32_e32 v31, v32, v31
; SI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v21
; SI-NEXT:    buffer_store_dword v31, v33, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v31, vcc, 20, v0
; SI-NEXT:    v_or_b32_e32 v29, v30, v29
; SI-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    buffer_store_dword v29, v31, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v29, vcc, 24, v0
; SI-NEXT:    v_or_b32_e32 v27, v28, v27
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    buffer_store_dword v27, v29, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v27, vcc, 28, v0
; SI-NEXT:    v_or_b32_e32 v25, v26, v25
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    buffer_store_dword v25, v27, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v25, vcc, 32, v0
; SI-NEXT:    v_or_b32_e32 v23, v24, v23
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; SI-NEXT:    buffer_store_dword v23, v25, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v23, vcc, 36, v0
; SI-NEXT:    v_or_b32_e32 v21, v22, v21
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; SI-NEXT:    buffer_store_dword v21, v23, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v21, vcc, 40, v0
; SI-NEXT:    v_or_b32_e32 v19, v20, v19
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; SI-NEXT:    buffer_store_dword v19, v21, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v19, vcc, 44, v0
; SI-NEXT:    v_or_b32_e32 v16, v18, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    buffer_store_dword v16, v19, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v17
; SI-NEXT:    v_add_i32_e32 v17, vcc, 48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v16, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    buffer_store_dword v14, v17, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v15
; SI-NEXT:    v_add_i32_e32 v15, vcc, 52, v0
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_or_b32_e32 v12, v14, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    buffer_store_dword v12, v15, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v13
; SI-NEXT:    v_add_i32_e32 v13, vcc, 56, v0
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v12, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    buffer_store_dword v10, v13, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v11
; SI-NEXT:    v_add_i32_e32 v11, vcc, 60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v10, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    buffer_store_dword v8, v11, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v9
; SI-NEXT:    v_add_i32_e32 v9, vcc, 64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    buffer_store_dword v6, v9, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v7
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    buffer_store_dword v4, v7, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v5
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v4, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    buffer_store_dword v2, v5, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v3
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x4c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB33_4:
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    s_branch .LBB33_2
;
; VI-LABEL: bitcast_v20f32_to_v40f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    v_mov_b32_e32 v20, s16
; VI-NEXT:    v_mov_b32_e32 v19, s17
; VI-NEXT:    v_mov_b32_e32 v18, s18
; VI-NEXT:    v_mov_b32_e32 v17, s19
; VI-NEXT:    v_mov_b32_e32 v16, s20
; VI-NEXT:    v_mov_b32_e32 v15, s21
; VI-NEXT:    v_mov_b32_e32 v14, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB33_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v20
; VI-NEXT:    s_cbranch_execnz .LBB33_3
; VI-NEXT:  .LBB33_2: ; %cmp.true
; VI-NEXT:    v_add_f32_e32 v5, 1.0, v5
; VI-NEXT:    v_add_f32_e32 v4, 1.0, v4
; VI-NEXT:    v_add_f32_e32 v3, 1.0, v3
; VI-NEXT:    v_add_f32_e32 v2, 1.0, v2
; VI-NEXT:    v_add_f32_e32 v1, 1.0, v1
; VI-NEXT:    v_add_f32_e32 v0, 1.0, v0
; VI-NEXT:    v_add_f32_e32 v13, 1.0, v13
; VI-NEXT:    v_add_f32_e32 v12, 1.0, v12
; VI-NEXT:    v_add_f32_e32 v11, 1.0, v11
; VI-NEXT:    v_add_f32_e32 v10, 1.0, v10
; VI-NEXT:    v_add_f32_e32 v9, 1.0, v9
; VI-NEXT:    v_add_f32_e32 v8, 1.0, v8
; VI-NEXT:    v_add_f32_e32 v7, 1.0, v7
; VI-NEXT:    v_add_f32_e32 v14, 1.0, v14
; VI-NEXT:    v_add_f32_e32 v15, 1.0, v15
; VI-NEXT:    v_add_f32_e32 v16, 1.0, v16
; VI-NEXT:    v_add_f32_e32 v17, 1.0, v17
; VI-NEXT:    v_add_f32_e32 v18, 1.0, v18
; VI-NEXT:    v_add_f32_e32 v19, 1.0, v19
; VI-NEXT:    v_add_f32_e32 v20, 1.0, v20
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v0
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v20
; VI-NEXT:  .LBB33_3: ; %end
; VI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; VI-NEXT:    v_or_b32_sdwa v6, v14, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v38
; VI-NEXT:    v_or_b32_sdwa v7, v7, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v37
; VI-NEXT:    v_or_b32_sdwa v8, v8, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v36
; VI-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; VI-NEXT:    v_or_b32_sdwa v9, v9, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v35
; VI-NEXT:    v_or_b32_sdwa v24, v20, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v20, 16, v25
; VI-NEXT:    v_or_b32_sdwa v10, v10, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v34
; VI-NEXT:    v_or_b32_sdwa v25, v19, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v19, 16, v39
; VI-NEXT:    v_or_b32_sdwa v11, v11, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v33
; VI-NEXT:    v_or_b32_sdwa v20, v18, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v18, 16, v21
; VI-NEXT:    v_or_b32_sdwa v12, v12, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v32
; VI-NEXT:    v_or_b32_sdwa v21, v17, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v17, 16, v22
; VI-NEXT:    v_or_b32_sdwa v13, v13, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v14, 16, v31
; VI-NEXT:    v_or_b32_sdwa v22, v16, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v16, 16, v23
; VI-NEXT:    v_or_b32_sdwa v14, v0, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v30
; VI-NEXT:    v_or_b32_sdwa v23, v15, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v29
; VI-NEXT:    v_or_b32_sdwa v16, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v28
; VI-NEXT:    v_or_b32_sdwa v17, v3, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v27
; VI-NEXT:    v_or_b32_sdwa v18, v4, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v0, 16, v26
; VI-NEXT:    v_or_b32_sdwa v19, v5, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, v24
; VI-NEXT:    v_mov_b32_e32 v1, v25
; VI-NEXT:    v_mov_b32_e32 v2, v20
; VI-NEXT:    v_mov_b32_e32 v3, v21
; VI-NEXT:    v_mov_b32_e32 v4, v22
; VI-NEXT:    v_mov_b32_e32 v5, v23
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB33_4:
; VI-NEXT:    ; implicit-def: $vgpr24
; VI-NEXT:    ; implicit-def: $vgpr25
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr21
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr23
; VI-NEXT:    ; implicit-def: $vgpr6
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr27
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    s_branch .LBB33_2
;
; GFX9-LABEL: bitcast_v20f32_to_v40f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    v_mov_b32_e32 v20, s16
; GFX9-NEXT:    v_mov_b32_e32 v19, s17
; GFX9-NEXT:    v_mov_b32_e32 v18, s18
; GFX9-NEXT:    v_mov_b32_e32 v17, s19
; GFX9-NEXT:    v_mov_b32_e32 v16, s20
; GFX9-NEXT:    v_mov_b32_e32 v15, s21
; GFX9-NEXT:    v_mov_b32_e32 v14, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB33_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v20
; GFX9-NEXT:    s_cbranch_execnz .LBB33_3
; GFX9-NEXT:  .LBB33_2: ; %cmp.true
; GFX9-NEXT:    v_add_f32_e32 v5, 1.0, v5
; GFX9-NEXT:    v_add_f32_e32 v4, 1.0, v4
; GFX9-NEXT:    v_add_f32_e32 v3, 1.0, v3
; GFX9-NEXT:    v_add_f32_e32 v2, 1.0, v2
; GFX9-NEXT:    v_add_f32_e32 v1, 1.0, v1
; GFX9-NEXT:    v_add_f32_e32 v0, 1.0, v0
; GFX9-NEXT:    v_add_f32_e32 v13, 1.0, v13
; GFX9-NEXT:    v_add_f32_e32 v12, 1.0, v12
; GFX9-NEXT:    v_add_f32_e32 v11, 1.0, v11
; GFX9-NEXT:    v_add_f32_e32 v10, 1.0, v10
; GFX9-NEXT:    v_add_f32_e32 v9, 1.0, v9
; GFX9-NEXT:    v_add_f32_e32 v8, 1.0, v8
; GFX9-NEXT:    v_add_f32_e32 v7, 1.0, v7
; GFX9-NEXT:    v_add_f32_e32 v14, 1.0, v14
; GFX9-NEXT:    v_add_f32_e32 v15, 1.0, v15
; GFX9-NEXT:    v_add_f32_e32 v16, 1.0, v16
; GFX9-NEXT:    v_add_f32_e32 v17, 1.0, v17
; GFX9-NEXT:    v_add_f32_e32 v18, 1.0, v18
; GFX9-NEXT:    v_add_f32_e32 v19, 1.0, v19
; GFX9-NEXT:    v_add_f32_e32 v20, 1.0, v20
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v6, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v20
; GFX9-NEXT:  .LBB33_3: ; %end
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX9-NEXT:    v_lshl_or_b32 v6, v6, 16, v14
; GFX9-NEXT:    v_lshl_or_b32 v14, v31, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v1
; GFX9-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; GFX9-NEXT:    v_lshl_or_b32 v23, v23, 16, v15
; GFX9-NEXT:    v_lshl_or_b32 v15, v30, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v2
; GFX9-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX9-NEXT:    v_lshl_or_b32 v22, v22, 16, v16
; GFX9-NEXT:    v_lshl_or_b32 v16, v29, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v3
; GFX9-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; GFX9-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; GFX9-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; GFX9-NEXT:    v_lshl_or_b32 v21, v21, 16, v17
; GFX9-NEXT:    v_lshl_or_b32 v17, v28, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v4
; GFX9-NEXT:    v_lshl_or_b32 v24, v24, 16, v20
; GFX9-NEXT:    v_lshl_or_b32 v25, v25, 16, v19
; GFX9-NEXT:    v_lshl_or_b32 v20, v39, 16, v18
; GFX9-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX9-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX9-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX9-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; GFX9-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; GFX9-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX9-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; GFX9-NEXT:    v_lshl_or_b32 v18, v27, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v5
; GFX9-NEXT:    v_lshl_or_b32 v7, v38, 16, v7
; GFX9-NEXT:    v_lshl_or_b32 v8, v37, 16, v8
; GFX9-NEXT:    v_lshl_or_b32 v9, v36, 16, v9
; GFX9-NEXT:    v_lshl_or_b32 v10, v35, 16, v10
; GFX9-NEXT:    v_lshl_or_b32 v11, v34, 16, v11
; GFX9-NEXT:    v_lshl_or_b32 v12, v33, 16, v12
; GFX9-NEXT:    v_lshl_or_b32 v13, v32, 16, v13
; GFX9-NEXT:    v_lshl_or_b32 v19, v26, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, v24
; GFX9-NEXT:    v_mov_b32_e32 v1, v25
; GFX9-NEXT:    v_mov_b32_e32 v2, v20
; GFX9-NEXT:    v_mov_b32_e32 v3, v21
; GFX9-NEXT:    v_mov_b32_e32 v4, v22
; GFX9-NEXT:    v_mov_b32_e32 v5, v23
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB33_4:
; GFX9-NEXT:    ; implicit-def: $vgpr24
; GFX9-NEXT:    ; implicit-def: $vgpr25
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr21
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr23
; GFX9-NEXT:    ; implicit-def: $vgpr6
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr27
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    s_branch .LBB33_2
;
; GFX11-LABEL: bitcast_v20f32_to_v40f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-NEXT:    v_dual_mov_b32 v20, s0 :: v_dual_mov_b32 v19, s1
; GFX11-NEXT:    v_dual_mov_b32 v18, s2 :: v_dual_mov_b32 v3, s16
; GFX11-NEXT:    v_dual_mov_b32 v4, s3 :: v_dual_mov_b32 v9, s17
; GFX11-NEXT:    v_dual_mov_b32 v8, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s20 :: v_dual_mov_b32 v5, s21
; GFX11-NEXT:    v_dual_mov_b32 v14, s22 :: v_dual_mov_b32 v13, s23
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v11, s25
; GFX11-NEXT:    v_dual_mov_b32 v10, s26 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v17, s28 :: v_dual_mov_b32 v16, s29
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB33_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    v_lshrrev_b32_e32 v22, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v23, 16, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v24, 16, v16
; GFX11-NEXT:    v_lshrrev_b32_e32 v25, 16, v17
; GFX11-NEXT:    v_lshrrev_b32_e32 v26, 16, v15
; GFX11-NEXT:    v_lshrrev_b32_e32 v27, 16, v10
; GFX11-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v29, 16, v12
; GFX11-NEXT:    v_lshrrev_b32_e32 v30, 16, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v31, 16, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v32, 16, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v34, 16, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v35, 16, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v36, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v37, 16, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v38, 16, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v18
; GFX11-NEXT:    v_lshrrev_b32_e32 v21, 16, v19
; GFX11-NEXT:    v_lshrrev_b32_e32 v39, 16, v20
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccnz .LBB33_3
; GFX11-NEXT:  .LBB33_2: ; %cmp.true
; GFX11-NEXT:    v_dual_add_f32 v1, 1.0, v1 :: v_dual_add_f32 v0, 1.0, v0
; GFX11-NEXT:    v_dual_add_f32 v16, 1.0, v16 :: v_dual_add_f32 v17, 1.0, v17
; GFX11-NEXT:    v_dual_add_f32 v15, 1.0, v15 :: v_dual_add_f32 v10, 1.0, v10
; GFX11-NEXT:    v_dual_add_f32 v11, 1.0, v11 :: v_dual_add_f32 v12, 1.0, v12
; GFX11-NEXT:    v_dual_add_f32 v13, 1.0, v13 :: v_dual_add_f32 v14, 1.0, v14
; GFX11-NEXT:    v_dual_add_f32 v5, 1.0, v5 :: v_dual_add_f32 v6, 1.0, v6
; GFX11-NEXT:    v_dual_add_f32 v7, 1.0, v7 :: v_dual_add_f32 v8, 1.0, v8
; GFX11-NEXT:    v_dual_add_f32 v9, 1.0, v9 :: v_dual_add_f32 v4, 1.0, v4
; GFX11-NEXT:    v_dual_add_f32 v3, 1.0, v3 :: v_dual_add_f32 v18, 1.0, v18
; GFX11-NEXT:    v_dual_add_f32 v19, 1.0, v19 :: v_dual_add_f32 v20, 1.0, v20
; GFX11-NEXT:    v_lshrrev_b32_e32 v22, 16, v1
; GFX11-NEXT:    v_lshrrev_b32_e32 v23, 16, v0
; GFX11-NEXT:    v_lshrrev_b32_e32 v24, 16, v16
; GFX11-NEXT:    v_lshrrev_b32_e32 v25, 16, v17
; GFX11-NEXT:    v_lshrrev_b32_e32 v26, 16, v15
; GFX11-NEXT:    v_lshrrev_b32_e32 v27, 16, v10
; GFX11-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-NEXT:    v_lshrrev_b32_e32 v29, 16, v12
; GFX11-NEXT:    v_lshrrev_b32_e32 v30, 16, v13
; GFX11-NEXT:    v_lshrrev_b32_e32 v31, 16, v14
; GFX11-NEXT:    v_lshrrev_b32_e32 v32, 16, v5
; GFX11-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-NEXT:    v_lshrrev_b32_e32 v34, 16, v7
; GFX11-NEXT:    v_lshrrev_b32_e32 v35, 16, v8
; GFX11-NEXT:    v_lshrrev_b32_e32 v36, 16, v9
; GFX11-NEXT:    v_lshrrev_b32_e32 v37, 16, v3
; GFX11-NEXT:    v_lshrrev_b32_e32 v38, 16, v4
; GFX11-NEXT:    v_lshrrev_b32_e32 v2, 16, v18
; GFX11-NEXT:    v_lshrrev_b32_e32 v21, 16, v19
; GFX11-NEXT:    v_lshrrev_b32_e32 v39, 16, v20
; GFX11-NEXT:  .LBB33_3: ; %end
; GFX11-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; GFX11-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; GFX11-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; GFX11-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; GFX11-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; GFX11-NEXT:    v_lshl_or_b32 v21, v21, 16, v19
; GFX11-NEXT:    v_lshl_or_b32 v2, v2, 16, v18
; GFX11-NEXT:    v_and_b32_e32 v18, 0xffff, v6
; GFX11-NEXT:    v_and_b32_e32 v19, 0xffff, v5
; GFX11-NEXT:    v_and_b32_e32 v20, 0xffff, v20
; GFX11-NEXT:    v_lshl_or_b32 v5, v36, 16, v9
; GFX11-NEXT:    v_lshl_or_b32 v6, v35, 16, v8
; GFX11-NEXT:    v_lshl_or_b32 v8, v33, 16, v18
; GFX11-NEXT:    v_lshl_or_b32 v9, v32, 16, v19
; GFX11-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; GFX11-NEXT:    v_and_b32_e32 v18, 0xffff, v11
; GFX11-NEXT:    v_and_b32_e32 v19, 0xffff, v10
; GFX11-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; GFX11-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; GFX11-NEXT:    v_and_b32_e32 v48, 0xffff, v3
; GFX11-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; GFX11-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; GFX11-NEXT:    v_lshl_or_b32 v10, v31, 16, v14
; GFX11-NEXT:    v_lshl_or_b32 v11, v30, 16, v13
; GFX11-NEXT:    v_lshl_or_b32 v13, v28, 16, v18
; GFX11-NEXT:    v_lshl_or_b32 v14, v27, 16, v19
; GFX11-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; GFX11-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; GFX11-NEXT:    v_and_b32_e32 v18, 0xffff, v16
; GFX11-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; GFX11-NEXT:    v_lshl_or_b32 v19, v22, 16, v1
; GFX11-NEXT:    v_mov_b32_e32 v1, v21
; GFX11-NEXT:    v_lshl_or_b32 v20, v39, 16, v20
; GFX11-NEXT:    v_lshl_or_b32 v3, v38, 16, v4
; GFX11-NEXT:    v_lshl_or_b32 v4, v37, 16, v48
; GFX11-NEXT:    v_lshl_or_b32 v7, v34, 16, v7
; GFX11-NEXT:    v_lshl_or_b32 v12, v29, 16, v12
; GFX11-NEXT:    v_lshl_or_b32 v15, v26, 16, v15
; GFX11-NEXT:    v_lshl_or_b32 v16, v25, 16, v17
; GFX11-NEXT:    v_lshl_or_b32 v17, v24, 16, v18
; GFX11-NEXT:    v_lshl_or_b32 v18, v23, 16, v0
; GFX11-NEXT:    v_mov_b32_e32 v0, v20
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB33_4:
; GFX11-NEXT:    ; implicit-def: $vgpr39
; GFX11-NEXT:    ; implicit-def: $vgpr21
; GFX11-NEXT:    ; implicit-def: $vgpr2
; GFX11-NEXT:    ; implicit-def: $vgpr38
; GFX11-NEXT:    ; implicit-def: $vgpr37
; GFX11-NEXT:    ; implicit-def: $vgpr36
; GFX11-NEXT:    ; implicit-def: $vgpr35
; GFX11-NEXT:    ; implicit-def: $vgpr34
; GFX11-NEXT:    ; implicit-def: $vgpr33
; GFX11-NEXT:    ; implicit-def: $vgpr32
; GFX11-NEXT:    ; implicit-def: $vgpr31
; GFX11-NEXT:    ; implicit-def: $vgpr30
; GFX11-NEXT:    ; implicit-def: $vgpr29
; GFX11-NEXT:    ; implicit-def: $vgpr28
; GFX11-NEXT:    ; implicit-def: $vgpr27
; GFX11-NEXT:    ; implicit-def: $vgpr26
; GFX11-NEXT:    ; implicit-def: $vgpr25
; GFX11-NEXT:    ; implicit-def: $vgpr24
; GFX11-NEXT:    ; implicit-def: $vgpr23
; GFX11-NEXT:    ; implicit-def: $vgpr22
; GFX11-NEXT:    s_branch .LBB33_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <20 x float> %a, splat (float 1.000000e+00)
  %a2 = bitcast <20 x float> %a1 to <40 x half>
  br label %end

cmp.false:
  %a3 = bitcast <20 x float> %a to <40 x half>
  br label %end

end:
  %phi = phi <40 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <40 x half> %phi
}

define <20 x float> @bitcast_v40f16_to_v20f32(<40 x half> %a, i32 %b) {
; SI-LABEL: bitcast_v40f16_to_v20f32:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v48, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v49, off, s[0:3], s32 offset:4
; SI-NEXT:    buffer_load_dword v50, off, s[0:3], s32 offset:16
; SI-NEXT:    buffer_load_dword v51, off, s[0:3], s32 offset:12
; SI-NEXT:    buffer_load_dword v52, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v53, off, s[0:3], s32 offset:20
; SI-NEXT:    buffer_load_dword v54, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v55, off, s[0:3], s32 offset:28
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:36
; SI-NEXT:    v_cvt_f16_f32_e32 v38, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v39, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v37, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v36, v2
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:152 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v35, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v33, v7
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:148 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v63, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v62, v8
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:144 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v27
; SI-NEXT:    v_cvt_f16_f32_e32 v61, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v60, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v59, v13
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:140 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v58, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v57, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v56, v14
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:136 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v29
; SI-NEXT:    v_cvt_f16_f32_e32 v47, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v46, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v45, v19
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v44, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v43, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v42, v20
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v30
; SI-NEXT:    v_cvt_f16_f32_e32 v41, v23
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt vmcnt(14) expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v31
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v48
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_cvt_f16_f32_e32 v48, v55
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v49
; SI-NEXT:    v_cvt_f16_f32_e32 v49, v54
; SI-NEXT:    s_waitcnt vmcnt(10)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v40
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v50
; SI-NEXT:    v_cvt_f16_f32_e32 v50, v53
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v51
; SI-NEXT:    v_cvt_f16_f32_e32 v51, v52
; SI-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB34_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v41
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v39
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v37
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v35
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v33
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v63
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v61
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v59
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v57
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v47
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v45
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v43
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v49
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    v_or_b32_e32 v0, v38, v0
; SI-NEXT:    v_or_b32_e32 v1, v36, v1
; SI-NEXT:    v_or_b32_e32 v2, v34, v2
; SI-NEXT:    v_or_b32_e32 v3, v32, v3
; SI-NEXT:    v_or_b32_e32 v4, v62, v4
; SI-NEXT:    v_or_b32_e32 v5, v60, v5
; SI-NEXT:    v_or_b32_e32 v6, v58, v6
; SI-NEXT:    v_or_b32_e32 v7, v56, v7
; SI-NEXT:    v_or_b32_e32 v8, v46, v8
; SI-NEXT:    v_or_b32_e32 v9, v44, v9
; SI-NEXT:    v_or_b32_e32 v10, v42, v10
; SI-NEXT:    v_or_b32_e32 v19, v48, v19
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_or_b32_e32 v11, v12, v11
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; SI-NEXT:    v_or_b32_e32 v13, v14, v13
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v15, v14
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; SI-NEXT:    v_or_b32_e32 v16, v17, v16
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    v_or_b32_e32 v17, v18, v17
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v51
; SI-NEXT:    v_or_b32_e32 v18, v50, v18
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:  .LBB34_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB34_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v39
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v37
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:152 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:140 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:136 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v38
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v36
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v35
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v32
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v62
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v33
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v60
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v58
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v63
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v57
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v56
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v61
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v46
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v43
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v59
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v42
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v49
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v47
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v45
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v48
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v20, 0x38000000, v20
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v10, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v44
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v20
; SI-NEXT:    v_add_f32_e32 v21, 0x38000000, v21
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v21
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_or_b32_e32 v9, v10, v9
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v41
; SI-NEXT:    v_or_b32_e32 v10, v12, v10
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:148 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_or_b32_e32 v11, v13, v11
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:144 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v19
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v14
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    v_or_b32_e32 v13, v15, v13
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v19, 0x38000000, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v16, v14
; SI-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v17
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v18
; SI-NEXT:    v_add_f32_e32 v18, 0x38000000, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    v_or_b32_e32 v16, v18, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v51
; SI-NEXT:    v_add_f32_e32 v18, 0x38000000, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    v_or_b32_e32 v17, v19, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v50
; SI-NEXT:    v_add_f32_e32 v19, 0x38000000, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    v_or_b32_e32 v18, v19, v18
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v20
; SI-NEXT:    v_or_b32_e32 v19, v21, v19
; SI-NEXT:  .LBB34_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v40f16_to_v20f32:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    v_mov_b32_e32 v32, v19
; VI-NEXT:    v_mov_b32_e32 v33, v18
; VI-NEXT:    v_mov_b32_e32 v34, v17
; VI-NEXT:    v_mov_b32_e32 v35, v16
; VI-NEXT:    v_mov_b32_e32 v36, v15
; VI-NEXT:    v_mov_b32_e32 v37, v14
; VI-NEXT:    v_mov_b32_e32 v38, v13
; VI-NEXT:    v_mov_b32_e32 v39, v12
; VI-NEXT:    v_mov_b32_e32 v48, v11
; VI-NEXT:    v_mov_b32_e32 v49, v10
; VI-NEXT:    v_mov_b32_e32 v50, v9
; VI-NEXT:    v_mov_b32_e32 v51, v8
; VI-NEXT:    v_mov_b32_e32 v52, v7
; VI-NEXT:    v_mov_b32_e32 v53, v6
; VI-NEXT:    v_mov_b32_e32 v54, v5
; VI-NEXT:    v_mov_b32_e32 v55, v4
; VI-NEXT:    v_mov_b32_e32 v40, v3
; VI-NEXT:    v_mov_b32_e32 v41, v2
; VI-NEXT:    v_mov_b32_e32 v42, v1
; VI-NEXT:    v_mov_b32_e32 v43, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB34_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_mov_b32_e32 v19, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v19, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v19, v42 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v19, v41 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v3, v19, v40 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v4, v19, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v5, v19, v54 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v6, v19, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v7, v19, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v8, v19, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v9, v19, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v10, v19, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v11, v19, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v12, v19, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v13, v19, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v14, v19, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v15, v19, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v16, v19, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v17, v19, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v18, v19, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v19, v19, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v43, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v42, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v41, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v40, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v55, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v54, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v53, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v52, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v51, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v50, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v49, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v48, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v39, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v38, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v37, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v36, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v35, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v34, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v33, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v32, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:  .LBB34_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB34_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v19, 0x200
; VI-NEXT:    v_add_f16_sdwa v0, v43, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, 0x200, v43
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    v_add_f16_sdwa v1, v42, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v2, 0x200, v42
; VI-NEXT:    v_or_b32_e32 v1, v2, v1
; VI-NEXT:    v_add_f16_sdwa v2, v41, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, 0x200, v41
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_add_f16_sdwa v3, v40, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, 0x200, v40
; VI-NEXT:    v_or_b32_e32 v3, v4, v3
; VI-NEXT:    v_add_f16_sdwa v4, v55, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, 0x200, v55
; VI-NEXT:    v_or_b32_e32 v4, v5, v4
; VI-NEXT:    v_add_f16_sdwa v5, v54, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, 0x200, v54
; VI-NEXT:    v_or_b32_e32 v5, v6, v5
; VI-NEXT:    v_add_f16_sdwa v6, v53, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, 0x200, v53
; VI-NEXT:    v_or_b32_e32 v6, v7, v6
; VI-NEXT:    v_add_f16_sdwa v7, v52, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, 0x200, v52
; VI-NEXT:    v_or_b32_e32 v7, v8, v7
; VI-NEXT:    v_add_f16_sdwa v8, v51, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v9, 0x200, v51
; VI-NEXT:    v_or_b32_e32 v8, v9, v8
; VI-NEXT:    v_add_f16_sdwa v9, v50, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v10, 0x200, v50
; VI-NEXT:    v_or_b32_e32 v9, v10, v9
; VI-NEXT:    v_add_f16_sdwa v10, v49, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v11, 0x200, v49
; VI-NEXT:    v_or_b32_e32 v10, v11, v10
; VI-NEXT:    v_add_f16_sdwa v11, v48, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v12, 0x200, v48
; VI-NEXT:    v_or_b32_e32 v11, v12, v11
; VI-NEXT:    v_add_f16_sdwa v12, v39, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v13, 0x200, v39
; VI-NEXT:    v_or_b32_e32 v12, v13, v12
; VI-NEXT:    v_add_f16_sdwa v13, v38, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v14, 0x200, v38
; VI-NEXT:    v_or_b32_e32 v13, v14, v13
; VI-NEXT:    v_add_f16_sdwa v14, v37, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v15, 0x200, v37
; VI-NEXT:    v_or_b32_e32 v14, v15, v14
; VI-NEXT:    v_add_f16_sdwa v15, v36, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v16, 0x200, v36
; VI-NEXT:    v_or_b32_e32 v15, v16, v15
; VI-NEXT:    v_add_f16_sdwa v16, v35, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v17, 0x200, v35
; VI-NEXT:    v_or_b32_e32 v16, v17, v16
; VI-NEXT:    v_add_f16_sdwa v17, v34, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v18, 0x200, v34
; VI-NEXT:    v_or_b32_e32 v17, v18, v17
; VI-NEXT:    v_add_f16_sdwa v18, v33, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v20, 0x200, v33
; VI-NEXT:    v_or_b32_e32 v18, v20, v18
; VI-NEXT:    v_add_f16_sdwa v19, v32, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v20, 0x200, v32
; VI-NEXT:    v_or_b32_e32 v19, v20, v19
; VI-NEXT:  .LBB34_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v40f16_to_v20f32:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v19
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    v_mov_b32_e32 v33, v18
; GFX9-NEXT:    v_mov_b32_e32 v43, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v32
; GFX9-NEXT:    v_mov_b32_e32 v34, v17
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v33
; GFX9-NEXT:    v_mov_b32_e32 v35, v16
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v34
; GFX9-NEXT:    v_mov_b32_e32 v36, v15
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v35
; GFX9-NEXT:    v_mov_b32_e32 v37, v14
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v36
; GFX9-NEXT:    v_mov_b32_e32 v38, v13
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v37
; GFX9-NEXT:    v_mov_b32_e32 v39, v12
; GFX9-NEXT:    v_mov_b32_e32 v48, v11
; GFX9-NEXT:    v_mov_b32_e32 v49, v10
; GFX9-NEXT:    v_mov_b32_e32 v50, v9
; GFX9-NEXT:    v_mov_b32_e32 v51, v8
; GFX9-NEXT:    v_mov_b32_e32 v52, v7
; GFX9-NEXT:    v_mov_b32_e32 v53, v6
; GFX9-NEXT:    v_mov_b32_e32 v54, v5
; GFX9-NEXT:    v_mov_b32_e32 v55, v4
; GFX9-NEXT:    v_mov_b32_e32 v40, v3
; GFX9-NEXT:    v_mov_b32_e32 v41, v2
; GFX9-NEXT:    v_mov_b32_e32 v42, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v38
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v39
; GFX9-NEXT:    v_lshrrev_b32_e32 v60, 16, v48
; GFX9-NEXT:    v_lshrrev_b32_e32 v61, 16, v49
; GFX9-NEXT:    v_lshrrev_b32_e32 v62, 16, v50
; GFX9-NEXT:    v_lshrrev_b32_e32 v63, 16, v51
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v52
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v53
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v54
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v55
; GFX9-NEXT:    v_lshrrev_b32_e32 v56, 16, v40
; GFX9-NEXT:    v_lshrrev_b32_e32 v57, 16, v41
; GFX9-NEXT:    v_lshrrev_b32_e32 v58, 16, v42
; GFX9-NEXT:    v_lshrrev_b32_e32 v59, 16, v43
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB34_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 16, v39
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 16, v38
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v37
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 16, v36
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v16, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v19, 16, v32
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    v_perm_b32 v0, v59, v43, s6
; GFX9-NEXT:    v_perm_b32 v1, v58, v42, s6
; GFX9-NEXT:    v_perm_b32 v2, v57, v41, s6
; GFX9-NEXT:    v_perm_b32 v3, v56, v40, s6
; GFX9-NEXT:    v_perm_b32 v4, v47, v55, s6
; GFX9-NEXT:    v_perm_b32 v5, v46, v54, s6
; GFX9-NEXT:    v_perm_b32 v6, v45, v53, s6
; GFX9-NEXT:    v_perm_b32 v7, v44, v52, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v51, s6
; GFX9-NEXT:    v_perm_b32 v9, v62, v50, s6
; GFX9-NEXT:    v_perm_b32 v10, v61, v49, s6
; GFX9-NEXT:    v_perm_b32 v11, v60, v48, s6
; GFX9-NEXT:    v_perm_b32 v12, v12, v39, s6
; GFX9-NEXT:    v_perm_b32 v13, v13, v38, s6
; GFX9-NEXT:    v_perm_b32 v14, v14, v37, s6
; GFX9-NEXT:    v_perm_b32 v15, v15, v36, s6
; GFX9-NEXT:    v_perm_b32 v16, v16, v35, s6
; GFX9-NEXT:    v_perm_b32 v17, v17, v34, s6
; GFX9-NEXT:    v_perm_b32 v18, v18, v33, s6
; GFX9-NEXT:    v_perm_b32 v19, v19, v32, s6
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr60
; GFX9-NEXT:    ; implicit-def: $vgpr61
; GFX9-NEXT:    ; implicit-def: $vgpr62
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr56
; GFX9-NEXT:    ; implicit-def: $vgpr57
; GFX9-NEXT:    ; implicit-def: $vgpr58
; GFX9-NEXT:    ; implicit-def: $vgpr59
; GFX9-NEXT:  .LBB34_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB34_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v59, v43, s6
; GFX9-NEXT:    s_movk_i32 s7, 0x200
; GFX9-NEXT:    v_perm_b32 v1, v58, v42, s6
; GFX9-NEXT:    v_perm_b32 v2, v57, v41, s6
; GFX9-NEXT:    v_perm_b32 v3, v56, v40, s6
; GFX9-NEXT:    v_perm_b32 v4, v47, v55, s6
; GFX9-NEXT:    v_perm_b32 v5, v46, v54, s6
; GFX9-NEXT:    v_perm_b32 v6, v45, v53, s6
; GFX9-NEXT:    v_perm_b32 v7, v44, v52, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v51, s6
; GFX9-NEXT:    v_perm_b32 v9, v62, v50, s6
; GFX9-NEXT:    v_perm_b32 v10, v61, v49, s6
; GFX9-NEXT:    v_perm_b32 v11, v60, v48, s6
; GFX9-NEXT:    v_pk_add_f16 v0, v0, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, v1, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, v2, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, v3, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, v4, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, v5, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, v6, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v7, v7, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v8, v8, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v9, v9, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v10, v10, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v11, v11, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(7)
; GFX9-NEXT:    v_perm_b32 v12, v12, v39, s6
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_perm_b32 v13, v13, v38, s6
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_perm_b32 v14, v14, v37, s6
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_perm_b32 v15, v15, v36, s6
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_perm_b32 v16, v16, v35, s6
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_perm_b32 v17, v17, v34, s6
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_perm_b32 v18, v18, v33, s6
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v19, v19, v32, s6
; GFX9-NEXT:    v_pk_add_f16 v12, v12, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v13, v13, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v14, v14, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v15, v15, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v16, v16, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v17, v17, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v18, v18, s7 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v19, v19, s7 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB34_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v40f16_to_v20f32:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB34_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v6, 0x200, v6 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v7, 0x200, v7 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v8, 0x200, v8 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v9, 0x200, v9 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v10, 0x200, v10 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v11, 0x200, v11 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v12, 0x200, v12 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v13, 0x200, v13 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v14, 0x200, v14 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v15, 0x200, v15 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v16, 0x200, v16 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v17, 0x200, v17 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v18, 0x200, v18 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v19, 0x200, v19 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:  .LBB34_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v40f16_to_v20f32:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v3
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v37, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v38, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v39, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v48, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v36, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v35, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v34, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v33, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v32, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v31, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v30, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v29, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v28, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v27, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v26, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v25, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v24, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v23, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v22, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v21, v19, 0x5040100
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB34_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v0, 0x200, v0 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v1, 0x200, v1 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v2, 0x200, v2 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v3, 0x200, v3 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v4, 0x200, v4 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v5, 0x200, v5 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v6, 0x200, v6 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v7, 0x200, v7 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v8, 0x200, v8 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v9, 0x200, v9 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v10, 0x200, v10 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v11, 0x200, v11 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v12, 0x200, v12 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v13, 0x200, v13 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v14, 0x200, v14 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v15, 0x200, v15 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v16, 0x200, v16 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v17, 0x200, v17 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v18, 0x200, v18 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v19, 0x200, v19 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:  .LBB34_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <40 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <40 x half> %a1 to <20 x float>
  br label %end

cmp.false:
  %a3 = bitcast <40 x half> %a to <20 x float>
  br label %end

end:
  %phi = phi <20 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x float> %phi
}

define inreg <20 x float> @bitcast_v40f16_to_v20f32_scalar(<40 x half> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v40f16_to_v20f32_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v47, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v63, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v62, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v44, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v43, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v42, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v41, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v40, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v55, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v54, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v53, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v52, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v51, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v50, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v49, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v48, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v31, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v30, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v29, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v23
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v58, s17
; SI-NEXT:    v_cvt_f16_f32_e32 v60, s16
; SI-NEXT:    v_cvt_f16_f32_e32 v59, s19
; SI-NEXT:    v_cvt_f16_f32_e32 v57, s18
; SI-NEXT:    v_cvt_f16_f32_e32 v39, s21
; SI-NEXT:    v_cvt_f16_f32_e32 v56, s20
; SI-NEXT:    v_cvt_f16_f32_e32 v38, s23
; SI-NEXT:    v_cvt_f16_f32_e32 v37, s22
; SI-NEXT:    v_cvt_f16_f32_e32 v36, s25
; SI-NEXT:    v_cvt_f16_f32_e32 v35, s24
; SI-NEXT:    v_cvt_f16_f32_e32 v34, s27
; SI-NEXT:    v_cvt_f16_f32_e32 v61, s26
; SI-NEXT:    v_cvt_f16_f32_e32 v25, s29
; SI-NEXT:    v_cvt_f16_f32_e32 v24, s28
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v26
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_cbranch_scc0 .LBB35_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v58
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v59
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v39
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v38
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v36
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v34
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v25
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v32
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v63
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v44
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v42
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v40
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v54
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v52
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v50
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v48
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v30
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v28
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v20
; SI-NEXT:    v_or_b32_e32 v0, v60, v0
; SI-NEXT:    v_or_b32_e32 v1, v57, v1
; SI-NEXT:    v_or_b32_e32 v2, v56, v2
; SI-NEXT:    v_or_b32_e32 v3, v37, v3
; SI-NEXT:    v_or_b32_e32 v4, v35, v4
; SI-NEXT:    v_or_b32_e32 v5, v61, v5
; SI-NEXT:    v_or_b32_e32 v6, v24, v6
; SI-NEXT:    v_or_b32_e32 v7, v47, v7
; SI-NEXT:    v_or_b32_e32 v8, v62, v8
; SI-NEXT:    v_or_b32_e32 v9, v43, v9
; SI-NEXT:    v_or_b32_e32 v10, v41, v10
; SI-NEXT:    v_or_b32_e32 v11, v55, v11
; SI-NEXT:    v_or_b32_e32 v12, v53, v12
; SI-NEXT:    v_or_b32_e32 v13, v51, v13
; SI-NEXT:    v_or_b32_e32 v14, v49, v14
; SI-NEXT:    v_or_b32_e32 v15, v31, v15
; SI-NEXT:    v_or_b32_e32 v16, v29, v16
; SI-NEXT:    v_or_b32_e32 v17, v27, v17
; SI-NEXT:    v_or_b32_e32 v18, v22, v18
; SI-NEXT:    v_or_b32_e32 v19, v21, v19
; SI-NEXT:    s_cbranch_execnz .LBB35_3
; SI-NEXT:  .LBB35_2: ; %cmp.true
; SI-NEXT:    v_cvt_f32_f16_e32 v0, v58
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v59
; SI-NEXT:    v_cvt_f32_f16_e32 v1, v60
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v57
; SI-NEXT:    v_add_f32_e32 v0, 0x38000000, v0
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_add_f32_e32 v1, 0x38000000, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_lshlrev_b32_e32 v0, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v0, v1, v0
; SI-NEXT:    v_or_b32_e32 v1, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v2, v39
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v56
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v37
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v35
; SI-NEXT:    v_add_f32_e32 v2, 0x38000000, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_or_b32_e32 v2, v3, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v3, v38
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v61
; SI-NEXT:    v_add_f32_e32 v3, 0x38000000, v3
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v7, v24
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    v_or_b32_e32 v3, v4, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v4, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v32
; SI-NEXT:    v_add_f32_e32 v7, 0x38000000, v7
; SI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; SI-NEXT:    v_add_f32_e32 v4, 0x38000000, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v47
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v5, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v5, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v62
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_add_f32_e32 v5, 0x38000000, v5
; SI-NEXT:    v_cvt_f16_f32_e32 v5, v5
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v42
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    v_or_b32_e32 v5, v6, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v6, v25
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v41
; SI-NEXT:    v_add_f32_e32 v6, 0x38000000, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v55
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v7, v6
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v8, v63
; SI-NEXT:    v_or_b32_e32 v7, v9, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v9, v44
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_add_f32_e32 v8, 0x38000000, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    v_add_f32_e32 v9, 0x38000000, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v10, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v10, v43
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v52
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v51
; SI-NEXT:    v_add_f32_e32 v10, 0x38000000, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v49
; SI-NEXT:    v_or_b32_e32 v9, v10, v9
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v11, v40
; SI-NEXT:    v_or_b32_e32 v10, v12, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v12, v54
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_add_f32_e32 v11, 0x38000000, v11
; SI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; SI-NEXT:    v_add_f32_e32 v12, 0x38000000, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; SI-NEXT:    v_or_b32_e32 v11, v13, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v13, v53
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v13, 0x38000000, v13
; SI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v29
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v27
; SI-NEXT:    v_or_b32_e32 v12, v13, v12
; SI-NEXT:    v_lshlrev_b32_e32 v13, 16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v14, v50
; SI-NEXT:    v_or_b32_e32 v13, v15, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v15, v48
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_add_f32_e32 v14, 0x38000000, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    v_add_f32_e32 v15, 0x38000000, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v16, v31
; SI-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; SI-NEXT:    v_add_f32_e32 v18, 0x38000000, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    v_add_f32_e32 v16, 0x38000000, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    v_add_f32_e32 v19, 0x38000000, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v20, v20
; SI-NEXT:    v_or_b32_e32 v15, v16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v17, v28
; SI-NEXT:    v_or_b32_e32 v16, v18, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v18, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_add_f32_e32 v17, 0x38000000, v17
; SI-NEXT:    v_cvt_f16_f32_e32 v17, v17
; SI-NEXT:    v_add_f32_e32 v18, 0x38000000, v18
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    v_add_f32_e32 v20, 0x38000000, v20
; SI-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; SI-NEXT:    v_or_b32_e32 v17, v19, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v19, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v20
; SI-NEXT:    v_add_f32_e32 v21, 0x38000000, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v21
; SI-NEXT:    v_add_f32_e32 v19, 0x38000000, v19
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; SI-NEXT:    v_or_b32_e32 v18, v19, v18
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v20
; SI-NEXT:    v_or_b32_e32 v19, v21, v19
; SI-NEXT:  .LBB35_3: ; %end
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB35_4:
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v59, v48
; SI-NEXT:    v_mov_b32_e32 v48, v21
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v60, v49
; SI-NEXT:    v_mov_b32_e32 v49, v20
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v43, v50
; SI-NEXT:    v_mov_b32_e32 v50, v22
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v44, v51
; SI-NEXT:    v_mov_b32_e32 v51, v23
; SI-NEXT:    v_mov_b32_e32 v45, v52
; SI-NEXT:    v_mov_b32_e32 v52, v27
; SI-NEXT:    v_mov_b32_e32 v46, v53
; SI-NEXT:    v_mov_b32_e32 v53, v28
; SI-NEXT:    buffer_store_dword v36, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v39, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v41, v32
; SI-NEXT:    v_mov_b32_e32 v33, v47
; SI-NEXT:    v_mov_b32_e32 v47, v54
; SI-NEXT:    v_mov_b32_e32 v54, v29
; SI-NEXT:    v_mov_b32_e32 v42, v56
; SI-NEXT:    v_mov_b32_e32 v56, v55
; SI-NEXT:    v_mov_b32_e32 v55, v30
; SI-NEXT:    s_waitcnt expcnt(1)
; SI-NEXT:    v_mov_b32_e32 v36, v57
; SI-NEXT:    v_mov_b32_e32 v57, v40
; SI-NEXT:    v_mov_b32_e32 v40, v31
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v39, v58
; SI-NEXT:    v_mov_b32_e32 v58, v37
; SI-NEXT:    v_mov_b32_e32 v37, v34
; SI-NEXT:    v_mov_b32_e32 v34, v24
; SI-NEXT:    v_mov_b32_e32 v32, v38
; SI-NEXT:    v_mov_b32_e32 v38, v35
; SI-NEXT:    v_mov_b32_e32 v35, v25
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    v_mov_b32_e32 v25, v35
; SI-NEXT:    v_mov_b32_e32 v35, v38
; SI-NEXT:    v_mov_b32_e32 v38, v32
; SI-NEXT:    v_mov_b32_e32 v24, v34
; SI-NEXT:    v_mov_b32_e32 v34, v37
; SI-NEXT:    v_mov_b32_e32 v37, v58
; SI-NEXT:    v_mov_b32_e32 v58, v39
; SI-NEXT:    v_mov_b32_e32 v31, v40
; SI-NEXT:    v_mov_b32_e32 v40, v57
; SI-NEXT:    v_mov_b32_e32 v57, v36
; SI-NEXT:    v_mov_b32_e32 v30, v55
; SI-NEXT:    v_mov_b32_e32 v55, v56
; SI-NEXT:    v_mov_b32_e32 v56, v42
; SI-NEXT:    v_mov_b32_e32 v32, v41
; SI-NEXT:    buffer_load_dword v39, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v36, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v23, v51
; SI-NEXT:    v_mov_b32_e32 v51, v44
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v22, v50
; SI-NEXT:    v_mov_b32_e32 v50, v43
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v20, v49
; SI-NEXT:    v_mov_b32_e32 v49, v60
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v21, v48
; SI-NEXT:    v_mov_b32_e32 v48, v59
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    v_mov_b32_e32 v29, v54
; SI-NEXT:    v_mov_b32_e32 v54, v47
; SI-NEXT:    v_mov_b32_e32 v47, v33
; SI-NEXT:    v_mov_b32_e32 v28, v53
; SI-NEXT:    v_mov_b32_e32 v53, v46
; SI-NEXT:    v_mov_b32_e32 v27, v52
; SI-NEXT:    v_mov_b32_e32 v52, v45
; SI-NEXT:    s_branch .LBB35_2
;
; VI-LABEL: bitcast_v40f16_to_v20f32_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s6, s29, 16
; VI-NEXT:    s_lshr_b32 s7, s28, 16
; VI-NEXT:    s_lshr_b32 s8, s27, 16
; VI-NEXT:    s_lshr_b32 s9, s26, 16
; VI-NEXT:    s_lshr_b32 s10, s25, 16
; VI-NEXT:    s_lshr_b32 s11, s24, 16
; VI-NEXT:    s_lshr_b32 s12, s23, 16
; VI-NEXT:    s_lshr_b32 s13, s22, 16
; VI-NEXT:    s_lshr_b32 s14, s21, 16
; VI-NEXT:    s_lshr_b32 s15, s20, 16
; VI-NEXT:    s_lshr_b32 s40, s19, 16
; VI-NEXT:    s_lshr_b32 s41, s18, 16
; VI-NEXT:    s_lshr_b32 s42, s17, 16
; VI-NEXT:    s_lshr_b32 s43, s16, 16
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    v_mov_b32_e32 v32, v5
; VI-NEXT:    v_mov_b32_e32 v33, v4
; VI-NEXT:    v_mov_b32_e32 v34, v3
; VI-NEXT:    v_mov_b32_e32 v35, v2
; VI-NEXT:    v_mov_b32_e32 v36, v1
; VI-NEXT:    v_mov_b32_e32 v37, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    s_cbranch_scc0 .LBB35_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s43, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s44, s42, 16
; VI-NEXT:    s_or_b32 s5, s5, s44
; VI-NEXT:    s_and_b32 s44, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s45, s41, 16
; VI-NEXT:    s_or_b32 s44, s44, s45
; VI-NEXT:    s_and_b32 s45, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s46, s40, 16
; VI-NEXT:    s_or_b32 s45, s45, s46
; VI-NEXT:    s_and_b32 s46, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s47, s15, 16
; VI-NEXT:    s_or_b32 s46, s46, s47
; VI-NEXT:    s_and_b32 s47, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s56, s14, 16
; VI-NEXT:    s_or_b32 s47, s47, s56
; VI-NEXT:    s_and_b32 s56, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s57, s13, 16
; VI-NEXT:    s_or_b32 s56, s56, s57
; VI-NEXT:    s_and_b32 s57, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s58, s12, 16
; VI-NEXT:    s_or_b32 s57, s57, s58
; VI-NEXT:    s_and_b32 s58, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s59, s11, 16
; VI-NEXT:    s_or_b32 s58, s58, s59
; VI-NEXT:    s_and_b32 s59, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s60, s10, 16
; VI-NEXT:    v_mov_b32_e32 v0, 16
; VI-NEXT:    s_or_b32 s59, s59, s60
; VI-NEXT:    s_and_b32 s60, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s61, s9, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s60, s60, s61
; VI-NEXT:    s_and_b32 s61, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s62, s8, 16
; VI-NEXT:    v_or_b32_sdwa v14, v37, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s61, s61, s62
; VI-NEXT:    s_and_b32 s62, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s63, s7, 16
; VI-NEXT:    v_or_b32_sdwa v16, v35, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s62, s62, s63
; VI-NEXT:    s_and_b32 s63, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s72, s6, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v0, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v17, v34, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v0, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s63, s63, s72
; VI-NEXT:    v_or_b32_sdwa v15, v36, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v33, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v32, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s44
; VI-NEXT:    v_mov_b32_e32 v3, s45
; VI-NEXT:    v_mov_b32_e32 v4, s46
; VI-NEXT:    v_mov_b32_e32 v5, s47
; VI-NEXT:    v_mov_b32_e32 v6, s56
; VI-NEXT:    v_mov_b32_e32 v7, s57
; VI-NEXT:    v_mov_b32_e32 v8, s58
; VI-NEXT:    v_mov_b32_e32 v9, s59
; VI-NEXT:    v_mov_b32_e32 v10, s60
; VI-NEXT:    v_mov_b32_e32 v11, s61
; VI-NEXT:    v_mov_b32_e32 v12, s62
; VI-NEXT:    v_mov_b32_e32 v13, s63
; VI-NEXT:    s_cbranch_execnz .LBB35_3
; VI-NEXT:  .LBB35_2: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v13, 0x200
; VI-NEXT:    v_mov_b32_e32 v0, s43
; VI-NEXT:    v_mov_b32_e32 v2, s42
; VI-NEXT:    v_add_f16_sdwa v0, v0, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v1, s16, v13
; VI-NEXT:    v_add_f16_sdwa v2, v2, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, s17, v13
; VI-NEXT:    v_or_b32_e32 v0, v1, v0
; VI-NEXT:    v_or_b32_e32 v1, v3, v2
; VI-NEXT:    v_mov_b32_e32 v2, s41
; VI-NEXT:    v_add_f16_sdwa v2, v2, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v3, s18, v13
; VI-NEXT:    v_or_b32_e32 v2, v3, v2
; VI-NEXT:    v_mov_b32_e32 v3, s40
; VI-NEXT:    v_add_f16_sdwa v3, v3, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v4, s19, v13
; VI-NEXT:    v_or_b32_e32 v3, v4, v3
; VI-NEXT:    v_mov_b32_e32 v4, s15
; VI-NEXT:    v_add_f16_sdwa v4, v4, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v5, s20, v13
; VI-NEXT:    v_or_b32_e32 v4, v5, v4
; VI-NEXT:    v_mov_b32_e32 v5, s14
; VI-NEXT:    v_add_f16_sdwa v5, v5, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v6, s21, v13
; VI-NEXT:    v_or_b32_e32 v5, v6, v5
; VI-NEXT:    v_mov_b32_e32 v6, s13
; VI-NEXT:    v_add_f16_sdwa v6, v6, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v7, s22, v13
; VI-NEXT:    v_or_b32_e32 v6, v7, v6
; VI-NEXT:    v_mov_b32_e32 v7, s12
; VI-NEXT:    v_add_f16_sdwa v7, v7, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v8, s23, v13
; VI-NEXT:    v_or_b32_e32 v7, v8, v7
; VI-NEXT:    v_mov_b32_e32 v8, s11
; VI-NEXT:    v_add_f16_sdwa v8, v8, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v9, s24, v13
; VI-NEXT:    v_or_b32_e32 v8, v9, v8
; VI-NEXT:    v_mov_b32_e32 v9, s10
; VI-NEXT:    v_add_f16_sdwa v9, v9, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v10, s25, v13
; VI-NEXT:    v_or_b32_e32 v9, v10, v9
; VI-NEXT:    v_mov_b32_e32 v10, s9
; VI-NEXT:    v_add_f16_sdwa v10, v10, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v11, s26, v13
; VI-NEXT:    v_or_b32_e32 v10, v11, v10
; VI-NEXT:    v_mov_b32_e32 v11, s8
; VI-NEXT:    v_add_f16_sdwa v11, v11, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v12, s27, v13
; VI-NEXT:    v_or_b32_e32 v11, v12, v11
; VI-NEXT:    v_mov_b32_e32 v12, s7
; VI-NEXT:    v_add_f16_sdwa v12, v12, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v14, s28, v13
; VI-NEXT:    v_or_b32_e32 v12, v14, v12
; VI-NEXT:    v_mov_b32_e32 v14, s6
; VI-NEXT:    v_add_f16_sdwa v14, v14, v13 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v13, s29, v13
; VI-NEXT:    v_mov_b32_e32 v19, 0x200
; VI-NEXT:    v_or_b32_e32 v13, v13, v14
; VI-NEXT:    v_add_f16_sdwa v14, v37, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v15, 0x200, v37
; VI-NEXT:    v_or_b32_e32 v14, v15, v14
; VI-NEXT:    v_add_f16_sdwa v15, v36, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v16, 0x200, v36
; VI-NEXT:    v_or_b32_e32 v15, v16, v15
; VI-NEXT:    v_add_f16_sdwa v16, v35, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v17, 0x200, v35
; VI-NEXT:    v_or_b32_e32 v16, v17, v16
; VI-NEXT:    v_add_f16_sdwa v17, v34, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v18, 0x200, v34
; VI-NEXT:    v_or_b32_e32 v17, v18, v17
; VI-NEXT:    v_add_f16_sdwa v18, v33, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v20, 0x200, v33
; VI-NEXT:    v_or_b32_e32 v18, v20, v18
; VI-NEXT:    v_add_f16_sdwa v19, v32, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_add_f16_e32 v20, 0x200, v32
; VI-NEXT:    v_or_b32_e32 v19, v20, v19
; VI-NEXT:  .LBB35_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB35_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_branch .LBB35_2
;
; GFX9-LABEL: bitcast_v40f16_to_v20f32_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v5
; GFX9-NEXT:    v_mov_b32_e32 v33, v4
; GFX9-NEXT:    v_mov_b32_e32 v34, v3
; GFX9-NEXT:    v_mov_b32_e32 v35, v2
; GFX9-NEXT:    v_mov_b32_e32 v36, v1
; GFX9-NEXT:    v_mov_b32_e32 v37, v0
; GFX9-NEXT:    s_lshr_b32 s40, s29, 16
; GFX9-NEXT:    s_lshr_b32 s41, s28, 16
; GFX9-NEXT:    s_lshr_b32 s42, s27, 16
; GFX9-NEXT:    s_lshr_b32 s43, s26, 16
; GFX9-NEXT:    s_lshr_b32 s15, s25, 16
; GFX9-NEXT:    s_lshr_b32 s14, s24, 16
; GFX9-NEXT:    s_lshr_b32 s13, s23, 16
; GFX9-NEXT:    s_lshr_b32 s12, s22, 16
; GFX9-NEXT:    s_lshr_b32 s11, s21, 16
; GFX9-NEXT:    s_lshr_b32 s10, s20, 16
; GFX9-NEXT:    s_lshr_b32 s9, s19, 16
; GFX9-NEXT:    s_lshr_b32 s8, s18, 16
; GFX9-NEXT:    s_lshr_b32 s7, s17, 16
; GFX9-NEXT:    s_lshr_b32 s6, s16, 16
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v36
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v37
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s16, s6
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s17, s7
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s18, s8
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s19, s9
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s20, s10
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s21, s11
; GFX9-NEXT:    s_pack_ll_b32_b16 s12, s22, s12
; GFX9-NEXT:    s_pack_ll_b32_b16 s13, s23, s13
; GFX9-NEXT:    s_pack_ll_b32_b16 s14, s24, s14
; GFX9-NEXT:    s_pack_ll_b32_b16 s15, s25, s15
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s26, s43
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s27, s42
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s28, s41
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s29, s40
; GFX9-NEXT:    s_cbranch_scc0 .LBB35_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v37
; GFX9-NEXT:    v_lshl_or_b32 v14, v51, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v36
; GFX9-NEXT:    v_lshl_or_b32 v15, v50, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v35
; GFX9-NEXT:    v_lshl_or_b32 v16, v49, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v34
; GFX9-NEXT:    v_lshl_or_b32 v17, v48, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v33
; GFX9-NEXT:    v_lshl_or_b32 v18, v39, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v32
; GFX9-NEXT:    v_lshl_or_b32 v19, v38, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_mov_b32_e32 v6, s12
; GFX9-NEXT:    v_mov_b32_e32 v7, s13
; GFX9-NEXT:    v_mov_b32_e32 v8, s14
; GFX9-NEXT:    v_mov_b32_e32 v9, s15
; GFX9-NEXT:    v_mov_b32_e32 v10, s16
; GFX9-NEXT:    v_mov_b32_e32 v11, s17
; GFX9-NEXT:    v_mov_b32_e32 v12, s18
; GFX9-NEXT:    v_mov_b32_e32 v13, s19
; GFX9-NEXT:    s_cbranch_execnz .LBB35_3
; GFX9-NEXT:  .LBB35_2: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff, v37
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v36
; GFX9-NEXT:    v_and_b32_e32 v16, 0xffff, v35
; GFX9-NEXT:    v_and_b32_e32 v17, 0xffff, v34
; GFX9-NEXT:    v_and_b32_e32 v18, 0xffff, v33
; GFX9-NEXT:    v_and_b32_e32 v19, 0xffff, v32
; GFX9-NEXT:    v_mov_b32_e32 v13, 0x200
; GFX9-NEXT:    s_movk_i32 s4, 0x200
; GFX9-NEXT:    v_lshl_or_b32 v14, v51, 16, v14
; GFX9-NEXT:    v_lshl_or_b32 v15, v50, 16, v15
; GFX9-NEXT:    v_lshl_or_b32 v16, v49, 16, v16
; GFX9-NEXT:    v_lshl_or_b32 v17, v48, 16, v17
; GFX9-NEXT:    v_lshl_or_b32 v18, v39, 16, v18
; GFX9-NEXT:    v_lshl_or_b32 v19, v38, 16, v19
; GFX9-NEXT:    v_pk_add_f16 v0, s6, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v1, s7, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v2, s8, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v3, s9, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v4, s10, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v5, s11, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v6, s12, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v7, s13, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v8, s14, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v9, s15, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v10, s16, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v11, s17, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v12, s18, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v13, s19, v13 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v14, v14, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v15, v15, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v16, v16, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v17, v17, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v18, v18, s4 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_f16 v19, v19, s4 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB35_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB35_4:
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_branch .LBB35_2
;
; GFX11-TRUE16-LABEL: bitcast_v40f16_to_v20f32_scalar:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.h, 0
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.l, v1.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.l, v0.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v35, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.h, v32.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v34, 0xffff, v1
; GFX11-TRUE16-NEXT:    s_lshr_b32 s41, s29, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s42, s28, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s43, s27, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s44, s26, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s45, s25, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s15, s24, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s13, s22, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s12, s21, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s11, s20, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s10, s19, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s9, s18, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s8, s17, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s7, s16, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s6, s2, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s4, s0, 16
; GFX11-TRUE16-NEXT:    s_mov_b32 s40, 0
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s4, s0, s4
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s5, s1, s5
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s6, s2, s6
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s7, s16, s7
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s8, s17, s8
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s9, s18, s9
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s10, s19, s10
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s11, s20, s11
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s12, s21, s12
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s13, s22, s13
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s15, s24, s15
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s16, s25, s45
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s17, s26, s44
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s0, s27, s43
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s1, s28, s42
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s2, s29, s41
; GFX11-TRUE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-TRUE16-NEXT:    s_cbranch_scc0 .LBB35_4
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s3
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v4, s7 :: v_dual_mov_b32 v5, s8
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v6, s9 :: v_dual_mov_b32 v7, s10
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v8, s11 :: v_dual_mov_b32 v9, s12
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v10, s13 :: v_dual_mov_b32 v11, s14
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v12, s15 :: v_dual_mov_b32 v13, s16
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v14, s17 :: v_dual_mov_b32 v15, s0
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v16, s1 :: v_dual_mov_b32 v17, s2
; GFX11-TRUE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s40
; GFX11-TRUE16-NEXT:    s_cbranch_vccnz .LBB35_3
; GFX11-TRUE16-NEXT:  .LBB35_2: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v0, 0x200, s4 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v1, 0x200, s5 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v2, 0x200, s6 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v4, 0x200, s7 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v5, 0x200, s8 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v6, 0x200, s9 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v7, 0x200, s10 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v8, 0x200, s11 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v9, 0x200, s12 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v10, 0x200, s13 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v11, 0x200, s14 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v12, 0x200, s15 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v13, 0x200, s16 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v14, 0x200, s17 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v15, 0x200, s0 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v16, 0x200, s1 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v17, 0x200, s2 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v18, 0x200, v18 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:    v_pk_add_f16 v19, 0x200, v19 op_sel_hi:[0,1]
; GFX11-TRUE16-NEXT:  .LBB35_3: ; %end
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB35_4:
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-TRUE16-NEXT:    s_branch .LBB35_2
;
; GFX11-FAKE16-LABEL: bitcast_v40f16_to_v20f32_scalar:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v35, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v34, 0xffff, v1
; GFX11-FAKE16-NEXT:    s_lshr_b32 s41, s29, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s42, s28, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s43, s27, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s44, s26, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s45, s25, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s15, s24, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s13, s22, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s12, s21, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s11, s20, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s10, s19, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s9, s18, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s8, s17, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s7, s16, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s6, s2, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s4, s0, 16
; GFX11-FAKE16-NEXT:    s_mov_b32 s40, 0
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s4, s0, s4
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s5, s1, s5
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s6, s2, s6
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s7, s16, s7
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s8, s17, s8
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s9, s18, s9
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s10, s19, s10
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s11, s20, s11
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s12, s21, s12
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s13, s22, s13
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s15, s24, s15
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s16, s25, s45
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s17, s26, s44
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s0, s27, s43
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s1, s28, s42
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s2, s29, s41
; GFX11-FAKE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-FAKE16-NEXT:    s_cbranch_scc0 .LBB35_4
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s3
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v4, s7 :: v_dual_mov_b32 v5, s8
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v6, s9 :: v_dual_mov_b32 v7, s10
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v8, s11 :: v_dual_mov_b32 v9, s12
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v10, s13 :: v_dual_mov_b32 v11, s14
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v12, s15 :: v_dual_mov_b32 v13, s16
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v14, s17 :: v_dual_mov_b32 v15, s0
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v16, s1 :: v_dual_mov_b32 v17, s2
; GFX11-FAKE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s40
; GFX11-FAKE16-NEXT:    s_cbranch_vccnz .LBB35_3
; GFX11-FAKE16-NEXT:  .LBB35_2: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v0, 0x200, s4 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v1, 0x200, s5 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v2, 0x200, s6 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v3, 0x200, s3 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v4, 0x200, s7 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v5, 0x200, s8 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v6, 0x200, s9 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v7, 0x200, s10 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v8, 0x200, s11 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v9, 0x200, s12 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v10, 0x200, s13 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v11, 0x200, s14 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v12, 0x200, s15 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v13, 0x200, s16 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v14, 0x200, s17 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v15, 0x200, s0 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v16, 0x200, s1 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v17, 0x200, s2 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v18, 0x200, v18 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:    v_pk_add_f16 v19, 0x200, v19 op_sel_hi:[0,1]
; GFX11-FAKE16-NEXT:  .LBB35_3: ; %end
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB35_4:
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-FAKE16-NEXT:    s_branch .LBB35_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <40 x half> %a, splat (half 0xH0200)
  %a2 = bitcast <40 x half> %a1 to <20 x float>
  br label %end

cmp.false:
  %a3 = bitcast <40 x half> %a to <20 x float>
  br label %end

end:
  %phi = phi <20 x float> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <20 x float> %phi
}

define <10 x double> @bitcast_v10i64_to_v10f64(<10 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v10i64_to_v10f64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB36_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; SI-NEXT:  .LBB36_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v10i64_to_v10f64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB36_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:  .LBB36_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v10i64_to_v10f64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB36_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 3, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:  .LBB36_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v10i64_to_v10f64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB36_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-NEXT:  .LBB36_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <10 x i64> %a, splat (i64 3)
  %a2 = bitcast <10 x i64> %a1 to <10 x double>
  br label %end

cmp.false:
  %a3 = bitcast <10 x i64> %a to <10 x double>
  br label %end

end:
  %phi = phi <10 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x double> %phi
}

define inreg <10 x double> @bitcast_v10i64_to_v10f64_scalar(<10 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v10i64_to_v10f64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v13, v6
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB37_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB37_3
; SI-NEXT:  .LBB37_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v0
; SI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v2
; SI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v4
; SI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v6
; SI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v8
; SI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v10
; SI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v16
; SI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; SI-NEXT:  .LBB37_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB37_4:
; SI-NEXT:    s_branch .LBB37_2
;
; VI-LABEL: bitcast_v10i64_to_v10f64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v13, v6
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB37_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB37_3
; VI-NEXT:  .LBB37_2: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:  .LBB37_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB37_4:
; VI-NEXT:    s_branch .LBB37_2
;
; GFX9-LABEL: bitcast_v10i64_to_v10f64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v13, v6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v13
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB37_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB37_3
; GFX9-NEXT:  .LBB37_2: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 3, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:  .LBB37_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB37_4:
; GFX9-NEXT:    s_branch .LBB37_2
;
; GFX11-LABEL: bitcast_v10i64_to_v10f64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB37_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB37_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB37_3:
; GFX11-NEXT:  .LBB37_4: ; %cmp.true
; GFX11-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <10 x i64> %a, splat (i64 3)
  %a2 = bitcast <10 x i64> %a1 to <10 x double>
  br label %end

cmp.false:
  %a3 = bitcast <10 x i64> %a to <10 x double>
  br label %end

end:
  %phi = phi <10 x double> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x double> %phi
}

define <10 x i64> @bitcast_v10f64_to_v10i64(<10 x double> %a, i32 %b) {
; SI-LABEL: bitcast_v10f64_to_v10i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB38_2
; SI-NEXT:  ; %bb.1: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; SI-NEXT:  .LBB38_2: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v10f64_to_v10i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB38_2
; VI-NEXT:  ; %bb.1: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; VI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; VI-NEXT:  .LBB38_2: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v10f64_to_v10i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB38_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX9-NEXT:  .LBB38_2: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: bitcast_v10f64_to_v10i64:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-NEXT:    s_cbranch_execz .LBB38_2
; GFX11-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX11-NEXT:  .LBB38_2: ; %end
; GFX11-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <10 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <10 x double> %a1 to <10 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <10 x double> %a to <10 x i64>
  br label %end

end:
  %phi = phi <10 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x i64> %phi
}

define inreg <10 x i64> @bitcast_v10f64_to_v10i64_scalar(<10 x double> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v10f64_to_v10i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_mov_b32_e32 v12, v6
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; SI-NEXT:    v_mov_b32_e32 v19, v5
; SI-NEXT:    v_mov_b32_e32 v18, v4
; SI-NEXT:    v_mov_b32_e32 v17, v3
; SI-NEXT:    v_mov_b32_e32 v16, v2
; SI-NEXT:    v_mov_b32_e32 v15, v1
; SI-NEXT:    v_mov_b32_e32 v14, v0
; SI-NEXT:    v_mov_b32_e32 v0, s16
; SI-NEXT:    v_mov_b32_e32 v1, s17
; SI-NEXT:    v_mov_b32_e32 v2, s18
; SI-NEXT:    v_mov_b32_e32 v3, s19
; SI-NEXT:    v_mov_b32_e32 v4, s20
; SI-NEXT:    v_mov_b32_e32 v5, s21
; SI-NEXT:    v_mov_b32_e32 v6, s22
; SI-NEXT:    v_mov_b32_e32 v7, s23
; SI-NEXT:    v_mov_b32_e32 v8, s24
; SI-NEXT:    v_mov_b32_e32 v9, s25
; SI-NEXT:    v_mov_b32_e32 v10, s26
; SI-NEXT:    v_mov_b32_e32 v11, s27
; SI-NEXT:    v_mov_b32_e32 v12, s28
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_mov_b32_e32 v13, s29
; SI-NEXT:    s_cbranch_scc0 .LBB39_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_cbranch_execnz .LBB39_3
; SI-NEXT:  .LBB39_2: ; %cmp.true
; SI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; SI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; SI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; SI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; SI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; SI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; SI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; SI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; SI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; SI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; SI-NEXT:  .LBB39_3: ; %end
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB39_4:
; SI-NEXT:    s_branch .LBB39_2
;
; VI-LABEL: bitcast_v10f64_to_v10i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v12, v6
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; VI-NEXT:    v_mov_b32_e32 v19, v5
; VI-NEXT:    v_mov_b32_e32 v18, v4
; VI-NEXT:    v_mov_b32_e32 v17, v3
; VI-NEXT:    v_mov_b32_e32 v16, v2
; VI-NEXT:    v_mov_b32_e32 v15, v1
; VI-NEXT:    v_mov_b32_e32 v14, v0
; VI-NEXT:    v_mov_b32_e32 v0, s16
; VI-NEXT:    v_mov_b32_e32 v1, s17
; VI-NEXT:    v_mov_b32_e32 v2, s18
; VI-NEXT:    v_mov_b32_e32 v3, s19
; VI-NEXT:    v_mov_b32_e32 v4, s20
; VI-NEXT:    v_mov_b32_e32 v5, s21
; VI-NEXT:    v_mov_b32_e32 v6, s22
; VI-NEXT:    v_mov_b32_e32 v7, s23
; VI-NEXT:    v_mov_b32_e32 v8, s24
; VI-NEXT:    v_mov_b32_e32 v9, s25
; VI-NEXT:    v_mov_b32_e32 v10, s26
; VI-NEXT:    v_mov_b32_e32 v11, s27
; VI-NEXT:    v_mov_b32_e32 v12, s28
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_mov_b32_e32 v13, s29
; VI-NEXT:    s_cbranch_scc0 .LBB39_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_cbranch_execnz .LBB39_3
; VI-NEXT:  .LBB39_2: ; %cmp.true
; VI-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; VI-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; VI-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; VI-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; VI-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; VI-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; VI-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; VI-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; VI-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; VI-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; VI-NEXT:  .LBB39_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB39_4:
; VI-NEXT:    s_branch .LBB39_2
;
; GFX9-LABEL: bitcast_v10f64_to_v10i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v12, v6
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v12
; GFX9-NEXT:    v_mov_b32_e32 v19, v5
; GFX9-NEXT:    v_mov_b32_e32 v18, v4
; GFX9-NEXT:    v_mov_b32_e32 v17, v3
; GFX9-NEXT:    v_mov_b32_e32 v16, v2
; GFX9-NEXT:    v_mov_b32_e32 v15, v1
; GFX9-NEXT:    v_mov_b32_e32 v14, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s16
; GFX9-NEXT:    v_mov_b32_e32 v1, s17
; GFX9-NEXT:    v_mov_b32_e32 v2, s18
; GFX9-NEXT:    v_mov_b32_e32 v3, s19
; GFX9-NEXT:    v_mov_b32_e32 v4, s20
; GFX9-NEXT:    v_mov_b32_e32 v5, s21
; GFX9-NEXT:    v_mov_b32_e32 v6, s22
; GFX9-NEXT:    v_mov_b32_e32 v7, s23
; GFX9-NEXT:    v_mov_b32_e32 v8, s24
; GFX9-NEXT:    v_mov_b32_e32 v9, s25
; GFX9-NEXT:    v_mov_b32_e32 v10, s26
; GFX9-NEXT:    v_mov_b32_e32 v11, s27
; GFX9-NEXT:    v_mov_b32_e32 v12, s28
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_mov_b32_e32 v13, s29
; GFX9-NEXT:    s_cbranch_scc0 .LBB39_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_cbranch_execnz .LBB39_3
; GFX9-NEXT:  .LBB39_2: ; %cmp.true
; GFX9-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX9-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX9-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX9-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX9-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX9-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX9-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX9-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX9-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX9-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX9-NEXT:  .LBB39_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB39_4:
; GFX9-NEXT:    s_branch .LBB39_2
;
; GFX11-LABEL: bitcast_v10f64_to_v10i64_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v16, v2 :: v_dual_mov_b32 v19, v1
; GFX11-NEXT:    v_dual_mov_b32 v18, v0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v16
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v11, s23
; GFX11-NEXT:    v_dual_mov_b32 v10, s22 :: v_dual_mov_b32 v13, s25
; GFX11-NEXT:    v_dual_mov_b32 v12, s24 :: v_dual_mov_b32 v15, s27
; GFX11-NEXT:    v_dual_mov_b32 v14, s26 :: v_dual_mov_b32 v17, s29
; GFX11-NEXT:    v_mov_b32_e32 v16, s28
; GFX11-NEXT:    s_mov_b32 s0, 0
; GFX11-NEXT:    s_and_b32 s1, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB39_3
; GFX11-NEXT:  ; %bb.1: ; %Flow
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s0
; GFX11-NEXT:    s_cbranch_vccz .LBB39_4
; GFX11-NEXT:  ; %bb.2: ; %end
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB39_3:
; GFX11-NEXT:  .LBB39_4: ; %cmp.true
; GFX11-NEXT:    v_add_f64 v[0:1], v[0:1], 1.0
; GFX11-NEXT:    v_add_f64 v[2:3], v[2:3], 1.0
; GFX11-NEXT:    v_add_f64 v[4:5], v[4:5], 1.0
; GFX11-NEXT:    v_add_f64 v[6:7], v[6:7], 1.0
; GFX11-NEXT:    v_add_f64 v[8:9], v[8:9], 1.0
; GFX11-NEXT:    v_add_f64 v[10:11], v[10:11], 1.0
; GFX11-NEXT:    v_add_f64 v[12:13], v[12:13], 1.0
; GFX11-NEXT:    v_add_f64 v[14:15], v[14:15], 1.0
; GFX11-NEXT:    v_add_f64 v[16:17], v[16:17], 1.0
; GFX11-NEXT:    v_add_f64 v[18:19], v[18:19], 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = fadd <10 x double> %a, splat (double 1.000000e+00)
  %a2 = bitcast <10 x double> %a1 to <10 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <10 x double> %a to <10 x i64>
  br label %end

end:
  %phi = phi <10 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x i64> %phi
}

define <40 x i16> @bitcast_v10i64_to_v40i16(<10 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v10i64_to_v40i16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v21
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB40_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_alignbit_b32 v21, v20, v19, 16
; SI-NEXT:    v_alignbit_b32 v22, v18, v17, 16
; SI-NEXT:    v_alignbit_b32 v23, v16, v15, 16
; SI-NEXT:    v_alignbit_b32 v24, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v25, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v28, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v30, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v33, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v35, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v37, v2, v1, 16
; SI-NEXT:    v_lshrrev_b32_e32 v26, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v2
; SI-NEXT:  .LBB40_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB40_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_addc_u32_e32 v6, vcc, 0, v6, vcc
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_addc_u32_e32 v8, vcc, 0, v8, vcc
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_addc_u32_e32 v10, vcc, 0, v10, vcc
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_addc_u32_e32 v12, vcc, 0, v12, vcc
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_addc_u32_e32 v14, vcc, 0, v14, vcc
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_addc_u32_e32 v16, vcc, 0, v16, vcc
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_addc_u32_e32 v18, vcc, 0, v18, vcc
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_addc_u32_e32 v20, vcc, 0, v20, vcc
; SI-NEXT:    v_alignbit_b32 v21, v20, v19, 16
; SI-NEXT:    v_alignbit_b32 v22, v18, v17, 16
; SI-NEXT:    v_alignbit_b32 v23, v16, v15, 16
; SI-NEXT:    v_alignbit_b32 v24, v14, v13, 16
; SI-NEXT:    v_alignbit_b32 v25, v12, v11, 16
; SI-NEXT:    v_alignbit_b32 v28, v10, v9, 16
; SI-NEXT:    v_alignbit_b32 v30, v8, v7, 16
; SI-NEXT:    v_alignbit_b32 v33, v6, v5, 16
; SI-NEXT:    v_alignbit_b32 v35, v4, v3, 16
; SI-NEXT:    v_alignbit_b32 v37, v2, v1, 16
; SI-NEXT:    v_lshrrev_b32_e32 v26, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v27, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v29, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v31, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v38, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v48, 16, v2
; SI-NEXT:  .LBB40_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; SI-NEXT:    v_or_b32_e32 v1, v1, v37
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v2
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v48
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 4, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v3
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v35
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 8, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v4
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v39
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 12, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v5
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v33
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 16, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v6
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v38
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 20, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v7
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v30
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 24, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v8
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v36
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 28, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v9
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v28
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 32, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v10
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v34
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 36, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v11
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v25
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 40, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v12
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v32
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v13
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v24
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v14
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v31
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 52, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v15
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v23
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 56, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v16
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v29
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 60, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v17
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v22
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 64, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v18
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v27
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x44, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v19
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v21
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x48, v0
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v20
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v26
; SI-NEXT:    v_or_b32_e32 v1, v1, v2
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x4c, v0
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v10i64_to_v40i16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr27
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr25
; VI-NEXT:    ; implicit-def: $vgpr24
; VI-NEXT:    ; implicit-def: $vgpr23
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr21
; VI-NEXT:    ; implicit-def: $vgpr20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB40_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; VI-NEXT:  .LBB40_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB40_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; VI-NEXT:  .LBB40_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; VI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; VI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; VI-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; VI-NEXT:    v_lshlrev_b32_e32 v35, 16, v35
; VI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; VI-NEXT:    v_lshlrev_b32_e32 v33, 16, v33
; VI-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; VI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; VI-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; VI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; VI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; VI-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; VI-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; VI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; VI-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; VI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; VI-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; VI-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; VI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; VI-NEXT:    v_or_b32_sdwa v0, v0, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v8, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v9, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v10, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v11, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v12, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v13, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v14, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v15, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v16, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v17, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v18, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v19, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v10i64_to_v40i16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr27
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr25
; GFX9-NEXT:    ; implicit-def: $vgpr24
; GFX9-NEXT:    ; implicit-def: $vgpr23
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr21
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB40_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX9-NEXT:  .LBB40_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB40_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 3, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX9-NEXT:  .LBB40_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v39, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v38, v1, s4
; GFX9-NEXT:    v_perm_b32 v2, v37, v2, s4
; GFX9-NEXT:    v_perm_b32 v3, v36, v3, s4
; GFX9-NEXT:    v_perm_b32 v4, v35, v4, s4
; GFX9-NEXT:    v_perm_b32 v5, v34, v5, s4
; GFX9-NEXT:    v_perm_b32 v6, v33, v6, s4
; GFX9-NEXT:    v_perm_b32 v7, v32, v7, s4
; GFX9-NEXT:    v_perm_b32 v8, v31, v8, s4
; GFX9-NEXT:    v_perm_b32 v9, v30, v9, s4
; GFX9-NEXT:    v_perm_b32 v10, v29, v10, s4
; GFX9-NEXT:    v_perm_b32 v11, v28, v11, s4
; GFX9-NEXT:    v_perm_b32 v12, v27, v12, s4
; GFX9-NEXT:    v_perm_b32 v13, v26, v13, s4
; GFX9-NEXT:    v_perm_b32 v14, v25, v14, s4
; GFX9-NEXT:    v_perm_b32 v15, v24, v15, s4
; GFX9-NEXT:    v_perm_b32 v16, v23, v16, s4
; GFX9-NEXT:    v_perm_b32 v17, v22, v17, s4
; GFX9-NEXT:    v_perm_b32 v18, v21, v18, s4
; GFX9-NEXT:    v_perm_b32 v19, v20, v19, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v10i64_to_v40i16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB40_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-TRUE16-NEXT:  .LBB40_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v10i64_to_v40i16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr27
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr25
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr24
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr23
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr20
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB40_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX11-FAKE16-NEXT:  .LBB40_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB40_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX11-FAKE16-NEXT:  .LBB40_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v39, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v38, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v37, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v36, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v35, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v34, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v33, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v32, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v31, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v30, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v29, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v28, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v27, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v26, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v25, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v24, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v23, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v22, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v21, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v20, v19, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <10 x i64> %a, splat (i64 3)
  %a2 = bitcast <10 x i64> %a1 to <40 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <10 x i64> %a to <40 x i16>
  br label %end

end:
  %phi = phi <40 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <40 x i16> %phi
}

define inreg <40 x i16> @bitcast_v10i64_to_v40i16_scalar(<10 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v10i64_to_v40i16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v7
; SI-NEXT:    v_readfirstlane_b32 s11, v1
; SI-NEXT:    v_readfirstlane_b32 s10, v2
; SI-NEXT:    v_readfirstlane_b32 s9, v3
; SI-NEXT:    v_readfirstlane_b32 s8, v4
; SI-NEXT:    v_readfirstlane_b32 s7, v5
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_readfirstlane_b32 s6, v6
; SI-NEXT:    s_cbranch_scc0 .LBB41_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    v_mov_b32_e32 v2, s9
; SI-NEXT:    v_mov_b32_e32 v3, s11
; SI-NEXT:    v_mov_b32_e32 v4, s28
; SI-NEXT:    v_mov_b32_e32 v5, s26
; SI-NEXT:    v_mov_b32_e32 v6, s24
; SI-NEXT:    v_mov_b32_e32 v7, s22
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v9, s18
; SI-NEXT:    v_mov_b32_e32 v10, s16
; SI-NEXT:    v_alignbit_b32 v1, s6, v1, 16
; SI-NEXT:    v_alignbit_b32 v2, s8, v2, 16
; SI-NEXT:    v_alignbit_b32 v3, s10, v3, 16
; SI-NEXT:    v_alignbit_b32 v4, s29, v4, 16
; SI-NEXT:    v_alignbit_b32 v5, s27, v5, 16
; SI-NEXT:    v_alignbit_b32 v6, s25, v6, 16
; SI-NEXT:    v_alignbit_b32 v7, s23, v7, 16
; SI-NEXT:    v_alignbit_b32 v8, s21, v8, 16
; SI-NEXT:    v_alignbit_b32 v9, s19, v9, 16
; SI-NEXT:    v_alignbit_b32 v10, s17, v10, 16
; SI-NEXT:    s_lshr_b32 s12, s6, 16
; SI-NEXT:    s_lshr_b32 s13, s8, 16
; SI-NEXT:    s_lshr_b32 s14, s10, 16
; SI-NEXT:    s_lshr_b32 s15, s29, 16
; SI-NEXT:    s_lshr_b32 s40, s27, 16
; SI-NEXT:    s_lshr_b32 s41, s25, 16
; SI-NEXT:    s_lshr_b32 s42, s23, 16
; SI-NEXT:    s_lshr_b32 s43, s21, 16
; SI-NEXT:    s_lshr_b32 s44, s19, 16
; SI-NEXT:    s_lshr_b32 s45, s17, 16
; SI-NEXT:    s_cbranch_execnz .LBB41_3
; SI-NEXT:  .LBB41_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s16, s16, 3
; SI-NEXT:    s_addc_u32 s17, s17, 0
; SI-NEXT:    s_add_u32 s18, s18, 3
; SI-NEXT:    s_addc_u32 s19, s19, 0
; SI-NEXT:    s_add_u32 s20, s20, 3
; SI-NEXT:    s_addc_u32 s21, s21, 0
; SI-NEXT:    s_add_u32 s22, s22, 3
; SI-NEXT:    s_addc_u32 s23, s23, 0
; SI-NEXT:    s_add_u32 s24, s24, 3
; SI-NEXT:    s_addc_u32 s25, s25, 0
; SI-NEXT:    s_add_u32 s26, s26, 3
; SI-NEXT:    s_addc_u32 s27, s27, 0
; SI-NEXT:    s_add_u32 s28, s28, 3
; SI-NEXT:    s_addc_u32 s29, s29, 0
; SI-NEXT:    s_add_u32 s11, s11, 3
; SI-NEXT:    s_addc_u32 s10, s10, 0
; SI-NEXT:    s_add_u32 s9, s9, 3
; SI-NEXT:    s_addc_u32 s8, s8, 0
; SI-NEXT:    s_add_u32 s7, s7, 3
; SI-NEXT:    s_addc_u32 s6, s6, 0
; SI-NEXT:    v_mov_b32_e32 v1, s7
; SI-NEXT:    v_mov_b32_e32 v2, s9
; SI-NEXT:    v_mov_b32_e32 v3, s11
; SI-NEXT:    v_mov_b32_e32 v4, s28
; SI-NEXT:    v_mov_b32_e32 v5, s26
; SI-NEXT:    v_mov_b32_e32 v6, s24
; SI-NEXT:    v_mov_b32_e32 v7, s22
; SI-NEXT:    v_mov_b32_e32 v8, s20
; SI-NEXT:    v_mov_b32_e32 v9, s18
; SI-NEXT:    v_mov_b32_e32 v10, s16
; SI-NEXT:    v_alignbit_b32 v1, s6, v1, 16
; SI-NEXT:    v_alignbit_b32 v2, s8, v2, 16
; SI-NEXT:    v_alignbit_b32 v3, s10, v3, 16
; SI-NEXT:    v_alignbit_b32 v4, s29, v4, 16
; SI-NEXT:    v_alignbit_b32 v5, s27, v5, 16
; SI-NEXT:    v_alignbit_b32 v6, s25, v6, 16
; SI-NEXT:    v_alignbit_b32 v7, s23, v7, 16
; SI-NEXT:    v_alignbit_b32 v8, s21, v8, 16
; SI-NEXT:    v_alignbit_b32 v9, s19, v9, 16
; SI-NEXT:    v_alignbit_b32 v10, s17, v10, 16
; SI-NEXT:    s_lshr_b32 s12, s6, 16
; SI-NEXT:    s_lshr_b32 s13, s8, 16
; SI-NEXT:    s_lshr_b32 s14, s10, 16
; SI-NEXT:    s_lshr_b32 s15, s29, 16
; SI-NEXT:    s_lshr_b32 s40, s27, 16
; SI-NEXT:    s_lshr_b32 s41, s25, 16
; SI-NEXT:    s_lshr_b32 s42, s23, 16
; SI-NEXT:    s_lshr_b32 s43, s21, 16
; SI-NEXT:    s_lshr_b32 s44, s19, 16
; SI-NEXT:    s_lshr_b32 s45, s17, 16
; SI-NEXT:  .LBB41_3: ; %end
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, s4, v10
; SI-NEXT:    s_and_b32 s4, s17, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s45, 16
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    v_mov_b32_e32 v11, s4
; SI-NEXT:    s_and_b32 s4, s18, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; SI-NEXT:    buffer_store_dword v10, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v10, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v9, s4, v9
; SI-NEXT:    s_and_b32 s4, s19, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s44, 16
; SI-NEXT:    buffer_store_dword v11, v10, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v10, vcc, 8, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v9, v10, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v10, s4
; SI-NEXT:    s_and_b32 s4, s20, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v9, vcc, 12, v0
; SI-NEXT:    v_or_b32_e32 v8, s4, v8
; SI-NEXT:    s_and_b32 s4, s21, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s43, 16
; SI-NEXT:    buffer_store_dword v10, v9, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v9, vcc, 16, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v8, v9, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v9, s4
; SI-NEXT:    s_and_b32 s4, s22, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v8, vcc, 20, v0
; SI-NEXT:    v_or_b32_e32 v7, s4, v7
; SI-NEXT:    s_and_b32 s4, s23, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s42, 16
; SI-NEXT:    buffer_store_dword v9, v8, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v8, vcc, 24, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v7, v8, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v8, s4
; SI-NEXT:    s_and_b32 s4, s24, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v7, vcc, 28, v0
; SI-NEXT:    v_or_b32_e32 v6, s4, v6
; SI-NEXT:    s_and_b32 s4, s25, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s41, 16
; SI-NEXT:    buffer_store_dword v8, v7, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v7, vcc, 32, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v6, v7, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v7, s4
; SI-NEXT:    s_and_b32 s4, s26, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v6, vcc, 36, v0
; SI-NEXT:    v_or_b32_e32 v5, s4, v5
; SI-NEXT:    s_and_b32 s4, s27, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s40, 16
; SI-NEXT:    buffer_store_dword v7, v6, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v6, vcc, 40, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v5, v6, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v6, s4
; SI-NEXT:    s_and_b32 s4, s28, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v5, vcc, 44, v0
; SI-NEXT:    v_or_b32_e32 v4, s4, v4
; SI-NEXT:    s_and_b32 s4, s29, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s15, 16
; SI-NEXT:    buffer_store_dword v6, v5, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v5, vcc, 48, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v4, v5, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v5, s4
; SI-NEXT:    s_and_b32 s4, s11, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v4, vcc, 52, v0
; SI-NEXT:    v_or_b32_e32 v3, s4, v3
; SI-NEXT:    s_and_b32 s4, s10, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s14, 16
; SI-NEXT:    buffer_store_dword v5, v4, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v4, vcc, 56, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v3, v4, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v4, s4
; SI-NEXT:    s_and_b32 s4, s9, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v3, vcc, 60, v0
; SI-NEXT:    v_or_b32_e32 v2, s4, v2
; SI-NEXT:    s_and_b32 s4, s8, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s13, 16
; SI-NEXT:    buffer_store_dword v4, v3, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v3, vcc, 64, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v2, v3, s[0:3], 0 offen
; SI-NEXT:    v_mov_b32_e32 v3, s4
; SI-NEXT:    s_and_b32 s4, s7, 0xffff
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x44, v0
; SI-NEXT:    v_or_b32_e32 v1, s4, v1
; SI-NEXT:    s_and_b32 s4, s6, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s12, 16
; SI-NEXT:    buffer_store_dword v3, v2, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v2, vcc, 0x48, v0
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    buffer_store_dword v1, v2, s[0:3], 0 offen
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x4c, v0
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_mov_b32_e32 v1, s4
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB41_4:
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $sgpr45
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $sgpr44
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $sgpr43
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $sgpr42
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $sgpr41
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $sgpr40
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $sgpr15
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $sgpr14
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $sgpr13
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $sgpr12
; SI-NEXT:    s_branch .LBB41_2
;
; VI-LABEL: bitcast_v10i64_to_v40i16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    v_readfirstlane_b32 s11, v0
; VI-NEXT:    v_readfirstlane_b32 s10, v1
; VI-NEXT:    v_readfirstlane_b32 s9, v2
; VI-NEXT:    v_readfirstlane_b32 s8, v3
; VI-NEXT:    v_readfirstlane_b32 s6, v4
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_readfirstlane_b32 s7, v5
; VI-NEXT:    s_cbranch_scc0 .LBB41_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s12, s7, 16
; VI-NEXT:    s_lshr_b32 s13, s6, 16
; VI-NEXT:    s_lshr_b32 s14, s8, 16
; VI-NEXT:    s_lshr_b32 s15, s9, 16
; VI-NEXT:    s_lshr_b32 s40, s10, 16
; VI-NEXT:    s_lshr_b32 s41, s11, 16
; VI-NEXT:    s_lshr_b32 s42, s29, 16
; VI-NEXT:    s_lshr_b32 s43, s28, 16
; VI-NEXT:    s_lshr_b32 s44, s27, 16
; VI-NEXT:    s_lshr_b32 s45, s26, 16
; VI-NEXT:    s_lshr_b32 s46, s25, 16
; VI-NEXT:    s_lshr_b32 s47, s24, 16
; VI-NEXT:    s_lshr_b32 s56, s23, 16
; VI-NEXT:    s_lshr_b32 s57, s22, 16
; VI-NEXT:    s_lshr_b32 s58, s21, 16
; VI-NEXT:    s_lshr_b32 s59, s20, 16
; VI-NEXT:    s_lshr_b32 s60, s19, 16
; VI-NEXT:    s_lshr_b32 s61, s18, 16
; VI-NEXT:    s_lshr_b32 s62, s17, 16
; VI-NEXT:    s_lshr_b32 s63, s16, 16
; VI-NEXT:    s_cbranch_execnz .LBB41_3
; VI-NEXT:  .LBB41_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s6, s6, 3
; VI-NEXT:    s_addc_u32 s7, s7, 0
; VI-NEXT:    s_add_u32 s9, s9, 3
; VI-NEXT:    s_addc_u32 s8, s8, 0
; VI-NEXT:    s_add_u32 s11, s11, 3
; VI-NEXT:    s_addc_u32 s10, s10, 0
; VI-NEXT:    s_add_u32 s28, s28, 3
; VI-NEXT:    s_addc_u32 s29, s29, 0
; VI-NEXT:    s_add_u32 s26, s26, 3
; VI-NEXT:    s_addc_u32 s27, s27, 0
; VI-NEXT:    s_add_u32 s24, s24, 3
; VI-NEXT:    s_addc_u32 s25, s25, 0
; VI-NEXT:    s_add_u32 s22, s22, 3
; VI-NEXT:    s_addc_u32 s23, s23, 0
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:    s_lshr_b32 s12, s7, 16
; VI-NEXT:    s_lshr_b32 s13, s6, 16
; VI-NEXT:    s_lshr_b32 s14, s8, 16
; VI-NEXT:    s_lshr_b32 s15, s9, 16
; VI-NEXT:    s_lshr_b32 s40, s10, 16
; VI-NEXT:    s_lshr_b32 s41, s11, 16
; VI-NEXT:    s_lshr_b32 s42, s29, 16
; VI-NEXT:    s_lshr_b32 s43, s28, 16
; VI-NEXT:    s_lshr_b32 s44, s27, 16
; VI-NEXT:    s_lshr_b32 s45, s26, 16
; VI-NEXT:    s_lshr_b32 s46, s25, 16
; VI-NEXT:    s_lshr_b32 s47, s24, 16
; VI-NEXT:    s_lshr_b32 s56, s23, 16
; VI-NEXT:    s_lshr_b32 s57, s22, 16
; VI-NEXT:    s_lshr_b32 s58, s21, 16
; VI-NEXT:    s_lshr_b32 s59, s20, 16
; VI-NEXT:    s_lshr_b32 s60, s19, 16
; VI-NEXT:    s_lshr_b32 s61, s18, 16
; VI-NEXT:    s_lshr_b32 s62, s17, 16
; VI-NEXT:    s_lshr_b32 s63, s16, 16
; VI-NEXT:  .LBB41_3: ; %end
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s63, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s16, s62, 16
; VI-NEXT:    s_or_b32 s5, s5, s16
; VI-NEXT:    s_and_b32 s16, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s17, s61, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s17, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s18, s60, 16
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s18, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s19, s59, 16
; VI-NEXT:    s_or_b32 s18, s18, s19
; VI-NEXT:    s_and_b32 s19, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s20, s58, 16
; VI-NEXT:    s_or_b32 s19, s19, s20
; VI-NEXT:    s_and_b32 s20, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s21, s57, 16
; VI-NEXT:    s_or_b32 s20, s20, s21
; VI-NEXT:    s_and_b32 s21, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s22, s56, 16
; VI-NEXT:    s_or_b32 s21, s21, s22
; VI-NEXT:    s_and_b32 s22, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s23, s47, 16
; VI-NEXT:    s_or_b32 s22, s22, s23
; VI-NEXT:    s_and_b32 s23, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s24, s46, 16
; VI-NEXT:    s_or_b32 s23, s23, s24
; VI-NEXT:    s_and_b32 s24, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s25, s45, 16
; VI-NEXT:    s_or_b32 s24, s24, s25
; VI-NEXT:    s_and_b32 s25, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s26, s44, 16
; VI-NEXT:    s_or_b32 s25, s25, s26
; VI-NEXT:    s_and_b32 s26, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s27, s43, 16
; VI-NEXT:    s_or_b32 s26, s26, s27
; VI-NEXT:    s_and_b32 s27, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s28, s42, 16
; VI-NEXT:    s_or_b32 s27, s27, s28
; VI-NEXT:    s_and_b32 s11, 0xffff, s11
; VI-NEXT:    s_lshl_b32 s28, s41, 16
; VI-NEXT:    s_or_b32 s11, s11, s28
; VI-NEXT:    s_and_b32 s10, 0xffff, s10
; VI-NEXT:    s_lshl_b32 s28, s40, 16
; VI-NEXT:    s_and_b32 s9, 0xffff, s9
; VI-NEXT:    s_lshl_b32 s15, s15, 16
; VI-NEXT:    s_and_b32 s8, 0xffff, s8
; VI-NEXT:    s_lshl_b32 s14, s14, 16
; VI-NEXT:    s_and_b32 s6, 0xffff, s6
; VI-NEXT:    s_lshl_b32 s13, s13, 16
; VI-NEXT:    s_and_b32 s7, 0xffff, s7
; VI-NEXT:    s_lshl_b32 s12, s12, 16
; VI-NEXT:    s_or_b32 s10, s10, s28
; VI-NEXT:    s_or_b32 s9, s9, s15
; VI-NEXT:    s_or_b32 s8, s8, s14
; VI-NEXT:    s_or_b32 s6, s6, s13
; VI-NEXT:    s_or_b32 s7, s7, s12
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    v_mov_b32_e32 v3, s17
; VI-NEXT:    v_mov_b32_e32 v4, s18
; VI-NEXT:    v_mov_b32_e32 v5, s19
; VI-NEXT:    v_mov_b32_e32 v6, s20
; VI-NEXT:    v_mov_b32_e32 v7, s21
; VI-NEXT:    v_mov_b32_e32 v8, s22
; VI-NEXT:    v_mov_b32_e32 v9, s23
; VI-NEXT:    v_mov_b32_e32 v10, s24
; VI-NEXT:    v_mov_b32_e32 v11, s25
; VI-NEXT:    v_mov_b32_e32 v12, s26
; VI-NEXT:    v_mov_b32_e32 v13, s27
; VI-NEXT:    v_mov_b32_e32 v14, s11
; VI-NEXT:    v_mov_b32_e32 v15, s10
; VI-NEXT:    v_mov_b32_e32 v16, s9
; VI-NEXT:    v_mov_b32_e32 v17, s8
; VI-NEXT:    v_mov_b32_e32 v18, s6
; VI-NEXT:    v_mov_b32_e32 v19, s7
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB41_4:
; VI-NEXT:    ; implicit-def: $sgpr63
; VI-NEXT:    ; implicit-def: $sgpr62
; VI-NEXT:    ; implicit-def: $sgpr61
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr59
; VI-NEXT:    ; implicit-def: $sgpr58
; VI-NEXT:    ; implicit-def: $sgpr57
; VI-NEXT:    ; implicit-def: $sgpr56
; VI-NEXT:    ; implicit-def: $sgpr47
; VI-NEXT:    ; implicit-def: $sgpr46
; VI-NEXT:    ; implicit-def: $sgpr45
; VI-NEXT:    ; implicit-def: $sgpr44
; VI-NEXT:    ; implicit-def: $sgpr43
; VI-NEXT:    ; implicit-def: $sgpr42
; VI-NEXT:    ; implicit-def: $sgpr41
; VI-NEXT:    ; implicit-def: $sgpr40
; VI-NEXT:    ; implicit-def: $sgpr15
; VI-NEXT:    ; implicit-def: $sgpr14
; VI-NEXT:    ; implicit-def: $sgpr13
; VI-NEXT:    ; implicit-def: $sgpr12
; VI-NEXT:    s_branch .LBB41_2
;
; GFX9-LABEL: bitcast_v10i64_to_v40i16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    v_readfirstlane_b32 s6, v0
; GFX9-NEXT:    v_readfirstlane_b32 s7, v1
; GFX9-NEXT:    v_readfirstlane_b32 s8, v2
; GFX9-NEXT:    v_readfirstlane_b32 s9, v3
; GFX9-NEXT:    v_readfirstlane_b32 s10, v4
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_readfirstlane_b32 s11, v5
; GFX9-NEXT:    s_cbranch_scc0 .LBB41_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s12, s11, 16
; GFX9-NEXT:    s_lshr_b32 s13, s10, 16
; GFX9-NEXT:    s_lshr_b32 s14, s9, 16
; GFX9-NEXT:    s_lshr_b32 s15, s8, 16
; GFX9-NEXT:    s_lshr_b32 s40, s7, 16
; GFX9-NEXT:    s_lshr_b32 s41, s6, 16
; GFX9-NEXT:    s_lshr_b32 s42, s29, 16
; GFX9-NEXT:    s_lshr_b32 s43, s28, 16
; GFX9-NEXT:    s_lshr_b32 s44, s27, 16
; GFX9-NEXT:    s_lshr_b32 s45, s26, 16
; GFX9-NEXT:    s_lshr_b32 s46, s25, 16
; GFX9-NEXT:    s_lshr_b32 s47, s24, 16
; GFX9-NEXT:    s_lshr_b32 s56, s23, 16
; GFX9-NEXT:    s_lshr_b32 s57, s22, 16
; GFX9-NEXT:    s_lshr_b32 s58, s21, 16
; GFX9-NEXT:    s_lshr_b32 s59, s20, 16
; GFX9-NEXT:    s_lshr_b32 s60, s19, 16
; GFX9-NEXT:    s_lshr_b32 s61, s18, 16
; GFX9-NEXT:    s_lshr_b32 s62, s17, 16
; GFX9-NEXT:    s_lshr_b32 s63, s16, 16
; GFX9-NEXT:    s_cbranch_execnz .LBB41_3
; GFX9-NEXT:  .LBB41_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s10, s10, 3
; GFX9-NEXT:    s_addc_u32 s11, s11, 0
; GFX9-NEXT:    s_add_u32 s8, s8, 3
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_add_u32 s6, s6, 3
; GFX9-NEXT:    s_addc_u32 s7, s7, 0
; GFX9-NEXT:    s_add_u32 s28, s28, 3
; GFX9-NEXT:    s_addc_u32 s29, s29, 0
; GFX9-NEXT:    s_add_u32 s26, s26, 3
; GFX9-NEXT:    s_addc_u32 s27, s27, 0
; GFX9-NEXT:    s_add_u32 s24, s24, 3
; GFX9-NEXT:    s_addc_u32 s25, s25, 0
; GFX9-NEXT:    s_add_u32 s22, s22, 3
; GFX9-NEXT:    s_addc_u32 s23, s23, 0
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:    s_lshr_b32 s12, s11, 16
; GFX9-NEXT:    s_lshr_b32 s13, s10, 16
; GFX9-NEXT:    s_lshr_b32 s14, s9, 16
; GFX9-NEXT:    s_lshr_b32 s15, s8, 16
; GFX9-NEXT:    s_lshr_b32 s40, s7, 16
; GFX9-NEXT:    s_lshr_b32 s41, s6, 16
; GFX9-NEXT:    s_lshr_b32 s42, s29, 16
; GFX9-NEXT:    s_lshr_b32 s43, s28, 16
; GFX9-NEXT:    s_lshr_b32 s44, s27, 16
; GFX9-NEXT:    s_lshr_b32 s45, s26, 16
; GFX9-NEXT:    s_lshr_b32 s46, s25, 16
; GFX9-NEXT:    s_lshr_b32 s47, s24, 16
; GFX9-NEXT:    s_lshr_b32 s56, s23, 16
; GFX9-NEXT:    s_lshr_b32 s57, s22, 16
; GFX9-NEXT:    s_lshr_b32 s58, s21, 16
; GFX9-NEXT:    s_lshr_b32 s59, s20, 16
; GFX9-NEXT:    s_lshr_b32 s60, s19, 16
; GFX9-NEXT:    s_lshr_b32 s61, s18, 16
; GFX9-NEXT:    s_lshr_b32 s62, s17, 16
; GFX9-NEXT:    s_lshr_b32 s63, s16, 16
; GFX9-NEXT:  .LBB41_3: ; %end
; GFX9-NEXT:    s_pack_ll_b32_b16 s4, s16, s63
; GFX9-NEXT:    s_pack_ll_b32_b16 s5, s17, s62
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s18, s61
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s19, s60
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s20, s59
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s21, s58
; GFX9-NEXT:    s_pack_ll_b32_b16 s20, s22, s57
; GFX9-NEXT:    s_pack_ll_b32_b16 s21, s23, s56
; GFX9-NEXT:    s_pack_ll_b32_b16 s22, s24, s47
; GFX9-NEXT:    s_pack_ll_b32_b16 s23, s25, s46
; GFX9-NEXT:    s_pack_ll_b32_b16 s24, s26, s45
; GFX9-NEXT:    s_pack_ll_b32_b16 s25, s27, s44
; GFX9-NEXT:    s_pack_ll_b32_b16 s26, s28, s43
; GFX9-NEXT:    s_pack_ll_b32_b16 s27, s29, s42
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s6, s41
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s7, s40
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s8, s15
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s9, s14
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s10, s13
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s11, s12
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s16
; GFX9-NEXT:    v_mov_b32_e32 v3, s17
; GFX9-NEXT:    v_mov_b32_e32 v4, s18
; GFX9-NEXT:    v_mov_b32_e32 v5, s19
; GFX9-NEXT:    v_mov_b32_e32 v6, s20
; GFX9-NEXT:    v_mov_b32_e32 v7, s21
; GFX9-NEXT:    v_mov_b32_e32 v8, s22
; GFX9-NEXT:    v_mov_b32_e32 v9, s23
; GFX9-NEXT:    v_mov_b32_e32 v10, s24
; GFX9-NEXT:    v_mov_b32_e32 v11, s25
; GFX9-NEXT:    v_mov_b32_e32 v12, s26
; GFX9-NEXT:    v_mov_b32_e32 v13, s27
; GFX9-NEXT:    v_mov_b32_e32 v14, s6
; GFX9-NEXT:    v_mov_b32_e32 v15, s7
; GFX9-NEXT:    v_mov_b32_e32 v16, s8
; GFX9-NEXT:    v_mov_b32_e32 v17, s9
; GFX9-NEXT:    v_mov_b32_e32 v18, s10
; GFX9-NEXT:    v_mov_b32_e32 v19, s11
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB41_4:
; GFX9-NEXT:    ; implicit-def: $sgpr63
; GFX9-NEXT:    ; implicit-def: $sgpr62
; GFX9-NEXT:    ; implicit-def: $sgpr61
; GFX9-NEXT:    ; implicit-def: $sgpr60
; GFX9-NEXT:    ; implicit-def: $sgpr59
; GFX9-NEXT:    ; implicit-def: $sgpr58
; GFX9-NEXT:    ; implicit-def: $sgpr57
; GFX9-NEXT:    ; implicit-def: $sgpr56
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr46
; GFX9-NEXT:    ; implicit-def: $sgpr45
; GFX9-NEXT:    ; implicit-def: $sgpr44
; GFX9-NEXT:    ; implicit-def: $sgpr43
; GFX9-NEXT:    ; implicit-def: $sgpr42
; GFX9-NEXT:    ; implicit-def: $sgpr41
; GFX9-NEXT:    ; implicit-def: $sgpr40
; GFX9-NEXT:    ; implicit-def: $sgpr15
; GFX9-NEXT:    ; implicit-def: $sgpr14
; GFX9-NEXT:    ; implicit-def: $sgpr13
; GFX9-NEXT:    ; implicit-def: $sgpr12
; GFX9-NEXT:    s_branch .LBB41_2
;
; GFX11-LABEL: bitcast_v10i64_to_v40i16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-NEXT:    v_readfirstlane_b32 s5, v0
; GFX11-NEXT:    v_readfirstlane_b32 s4, v1
; GFX11-NEXT:    s_mov_b32 s58, 0
; GFX11-NEXT:    s_and_b32 s6, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB41_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s6, s4, 16
; GFX11-NEXT:    s_lshr_b32 s7, s5, 16
; GFX11-NEXT:    s_lshr_b32 s8, s29, 16
; GFX11-NEXT:    s_lshr_b32 s9, s28, 16
; GFX11-NEXT:    s_lshr_b32 s10, s27, 16
; GFX11-NEXT:    s_lshr_b32 s11, s26, 16
; GFX11-NEXT:    s_lshr_b32 s12, s25, 16
; GFX11-NEXT:    s_lshr_b32 s13, s24, 16
; GFX11-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-NEXT:    s_lshr_b32 s15, s22, 16
; GFX11-NEXT:    s_lshr_b32 s40, s21, 16
; GFX11-NEXT:    s_lshr_b32 s41, s20, 16
; GFX11-NEXT:    s_lshr_b32 s42, s19, 16
; GFX11-NEXT:    s_lshr_b32 s43, s18, 16
; GFX11-NEXT:    s_lshr_b32 s44, s17, 16
; GFX11-NEXT:    s_lshr_b32 s45, s16, 16
; GFX11-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-NEXT:    s_lshr_b32 s47, s2, 16
; GFX11-NEXT:    s_lshr_b32 s56, s1, 16
; GFX11-NEXT:    s_lshr_b32 s57, s0, 16
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s58
; GFX11-NEXT:    s_cbranch_vccnz .LBB41_3
; GFX11-NEXT:  .LBB41_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s5, s5, 3
; GFX11-NEXT:    s_addc_u32 s4, s4, 0
; GFX11-NEXT:    s_add_u32 s28, s28, 3
; GFX11-NEXT:    s_addc_u32 s29, s29, 0
; GFX11-NEXT:    s_add_u32 s26, s26, 3
; GFX11-NEXT:    s_addc_u32 s27, s27, 0
; GFX11-NEXT:    s_add_u32 s24, s24, 3
; GFX11-NEXT:    s_addc_u32 s25, s25, 0
; GFX11-NEXT:    s_add_u32 s22, s22, 3
; GFX11-NEXT:    s_addc_u32 s23, s23, 0
; GFX11-NEXT:    s_add_u32 s20, s20, 3
; GFX11-NEXT:    s_addc_u32 s21, s21, 0
; GFX11-NEXT:    s_add_u32 s18, s18, 3
; GFX11-NEXT:    s_addc_u32 s19, s19, 0
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:    s_lshr_b32 s6, s4, 16
; GFX11-NEXT:    s_lshr_b32 s7, s5, 16
; GFX11-NEXT:    s_lshr_b32 s8, s29, 16
; GFX11-NEXT:    s_lshr_b32 s9, s28, 16
; GFX11-NEXT:    s_lshr_b32 s10, s27, 16
; GFX11-NEXT:    s_lshr_b32 s11, s26, 16
; GFX11-NEXT:    s_lshr_b32 s12, s25, 16
; GFX11-NEXT:    s_lshr_b32 s13, s24, 16
; GFX11-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-NEXT:    s_lshr_b32 s15, s22, 16
; GFX11-NEXT:    s_lshr_b32 s40, s21, 16
; GFX11-NEXT:    s_lshr_b32 s41, s20, 16
; GFX11-NEXT:    s_lshr_b32 s42, s19, 16
; GFX11-NEXT:    s_lshr_b32 s43, s18, 16
; GFX11-NEXT:    s_lshr_b32 s44, s17, 16
; GFX11-NEXT:    s_lshr_b32 s45, s16, 16
; GFX11-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-NEXT:    s_lshr_b32 s47, s2, 16
; GFX11-NEXT:    s_lshr_b32 s56, s1, 16
; GFX11-NEXT:    s_lshr_b32 s57, s0, 16
; GFX11-NEXT:  .LBB41_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_pack_ll_b32_b16 s0, s0, s57
; GFX11-NEXT:    s_pack_ll_b32_b16 s1, s1, s56
; GFX11-NEXT:    s_pack_ll_b32_b16 s2, s2, s47
; GFX11-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-NEXT:    s_pack_ll_b32_b16 s16, s16, s45
; GFX11-NEXT:    s_pack_ll_b32_b16 s17, s17, s44
; GFX11-NEXT:    s_pack_ll_b32_b16 s18, s18, s43
; GFX11-NEXT:    s_pack_ll_b32_b16 s19, s19, s42
; GFX11-NEXT:    s_pack_ll_b32_b16 s20, s20, s41
; GFX11-NEXT:    s_pack_ll_b32_b16 s21, s21, s40
; GFX11-NEXT:    s_pack_ll_b32_b16 s15, s22, s15
; GFX11-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-NEXT:    s_pack_ll_b32_b16 s13, s24, s13
; GFX11-NEXT:    s_pack_ll_b32_b16 s12, s25, s12
; GFX11-NEXT:    s_pack_ll_b32_b16 s11, s26, s11
; GFX11-NEXT:    s_pack_ll_b32_b16 s10, s27, s10
; GFX11-NEXT:    s_pack_ll_b32_b16 s9, s28, s9
; GFX11-NEXT:    s_pack_ll_b32_b16 s8, s29, s8
; GFX11-NEXT:    s_pack_ll_b32_b16 s5, s5, s7
; GFX11-NEXT:    s_pack_ll_b32_b16 s4, s4, s6
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s15 :: v_dual_mov_b32 v11, s14
; GFX11-NEXT:    v_dual_mov_b32 v12, s13 :: v_dual_mov_b32 v13, s12
; GFX11-NEXT:    v_dual_mov_b32 v14, s11 :: v_dual_mov_b32 v15, s10
; GFX11-NEXT:    v_dual_mov_b32 v16, s9 :: v_dual_mov_b32 v17, s8
; GFX11-NEXT:    v_dual_mov_b32 v18, s5 :: v_dual_mov_b32 v19, s4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB41_4:
; GFX11-NEXT:    ; implicit-def: $sgpr57
; GFX11-NEXT:    ; implicit-def: $sgpr56
; GFX11-NEXT:    ; implicit-def: $sgpr47
; GFX11-NEXT:    ; implicit-def: $sgpr46
; GFX11-NEXT:    ; implicit-def: $sgpr45
; GFX11-NEXT:    ; implicit-def: $sgpr44
; GFX11-NEXT:    ; implicit-def: $sgpr43
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr41
; GFX11-NEXT:    ; implicit-def: $sgpr40
; GFX11-NEXT:    ; implicit-def: $sgpr15
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    ; implicit-def: $sgpr13
; GFX11-NEXT:    ; implicit-def: $sgpr12
; GFX11-NEXT:    ; implicit-def: $sgpr11
; GFX11-NEXT:    ; implicit-def: $sgpr10
; GFX11-NEXT:    ; implicit-def: $sgpr9
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr7
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    s_branch .LBB41_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <10 x i64> %a, splat (i64 3)
  %a2 = bitcast <10 x i64> %a1 to <40 x i16>
  br label %end

cmp.false:
  %a3 = bitcast <10 x i64> %a to <40 x i16>
  br label %end

end:
  %phi = phi <40 x i16> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <40 x i16> %phi
}

define <10 x i64> @bitcast_v40i16_to_v10i64(<40 x i16> %a, i32 %b) {
; SI-LABEL: bitcast_v40i16_to_v10i64:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:100 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:96 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v63, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v30, off, s[0:3], s32 offset:104 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v28, off, s[0:3], s32 offset:108 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v26, off, s[0:3], s32 offset:112 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v24, off, s[0:3], s32 offset:116 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v22, off, s[0:3], s32 offset:124 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v52, v6
; SI-NEXT:    v_mov_b32_e32 v53, v4
; SI-NEXT:    v_mov_b32_e32 v54, v2
; SI-NEXT:    v_mov_b32_e32 v55, v0
; SI-NEXT:    buffer_load_dword v0, off, s[0:3], s32
; SI-NEXT:    buffer_load_dword v2, off, s[0:3], s32 offset:36
; SI-NEXT:    buffer_load_dword v4, off, s[0:3], s32 offset:32
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:28
; SI-NEXT:    v_mov_b32_e32 v49, v12
; SI-NEXT:    v_mov_b32_e32 v50, v10
; SI-NEXT:    v_mov_b32_e32 v51, v8
; SI-NEXT:    v_mov_b32_e32 v37, v20
; SI-NEXT:    v_mov_b32_e32 v38, v18
; SI-NEXT:    v_mov_b32_e32 v39, v16
; SI-NEXT:    v_mov_b32_e32 v48, v14
; SI-NEXT:    v_lshlrev_b32_e32 v42, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v41, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v36, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v35, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v40, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v34, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v33, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v32, 16, v15
; SI-NEXT:    s_waitcnt expcnt(5)
; SI-NEXT:    v_lshlrev_b32_e32 v63, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v62, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v61, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v60, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v59, 16, v25
; SI-NEXT:    v_lshlrev_b32_e32 v58, 16, v27
; SI-NEXT:    v_lshlrev_b32_e32 v57, 16, v29
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:4
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_lshlrev_b32_e32 v56, 16, v0
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v2
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v4
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    buffer_store_dword v6, off, s[0:3], s32 offset:120 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v6, off, s[0:3], s32 offset:24
; SI-NEXT:    buffer_load_dword v8, off, s[0:3], s32 offset:8
; SI-NEXT:    buffer_load_dword v10, off, s[0:3], s32 offset:16
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:20
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_lshlrev_b32_e32 v45, 16, v6
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_lshlrev_b32_e32 v47, 16, v8
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_lshlrev_b32_e32 v46, 16, v10
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:128 ; 4-byte Folded Spill
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:12
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    buffer_store_dword v12, off, s[0:3], s32 offset:132 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB42_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v55
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v54
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v53
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v52
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v51
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v50
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v49
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v48
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v39
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v38
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v37
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v43
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    v_or_b32_e32 v0, v0, v42
; SI-NEXT:    v_or_b32_e32 v1, v1, v41
; SI-NEXT:    v_or_b32_e32 v2, v2, v36
; SI-NEXT:    v_or_b32_e32 v3, v3, v35
; SI-NEXT:    v_or_b32_e32 v4, v4, v40
; SI-NEXT:    v_or_b32_e32 v5, v5, v34
; SI-NEXT:    v_or_b32_e32 v6, v6, v33
; SI-NEXT:    v_or_b32_e32 v7, v7, v32
; SI-NEXT:    v_or_b32_e32 v8, v8, v63
; SI-NEXT:    v_or_b32_e32 v9, v9, v62
; SI-NEXT:    v_or_b32_e32 v10, v10, v61
; SI-NEXT:    v_or_b32_e32 v16, v16, v47
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; kill: killed $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr63
; SI-NEXT:    ; implicit-def: $vgpr62
; SI-NEXT:    ; implicit-def: $vgpr61
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    s_waitcnt vmcnt(4)
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    s_waitcnt vmcnt(3)
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    s_waitcnt vmcnt(2)
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    s_waitcnt vmcnt(1)
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_or_b32_e32 v11, v11, v60
; SI-NEXT:    v_or_b32_e32 v12, v12, v59
; SI-NEXT:    v_or_b32_e32 v13, v13, v58
; SI-NEXT:    v_or_b32_e32 v14, v14, v57
; SI-NEXT:    v_or_b32_e32 v15, v15, v56
; SI-NEXT:    v_or_b32_e32 v17, v17, v46
; SI-NEXT:    v_or_b32_e32 v18, v18, v45
; SI-NEXT:    v_or_b32_e32 v19, v19, v44
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:  .LBB42_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB42_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    buffer_load_dword v11, off, s[0:3], s32 offset:124 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:116 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:108 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:104 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:132 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:128 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:120 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:112 ; 4-byte Folded Reload
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v55
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v54
; SI-NEXT:    v_add_i32_e32 v2, vcc, 3, v53
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v52
; SI-NEXT:    v_add_i32_e32 v4, vcc, 3, v51
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v50
; SI-NEXT:    v_add_i32_e32 v6, vcc, 3, v49
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v48
; SI-NEXT:    v_add_i32_e32 v8, vcc, 3, v39
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v38
; SI-NEXT:    v_add_i32_e32 v10, vcc, 3, v37
; SI-NEXT:    v_add_i32_e32 v16, vcc, 3, v43
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; SI-NEXT:    v_and_b32_e32 v2, 0xffff, v2
; SI-NEXT:    v_and_b32_e32 v3, 0xffff, v3
; SI-NEXT:    v_and_b32_e32 v4, 0xffff, v4
; SI-NEXT:    v_and_b32_e32 v5, 0xffff, v5
; SI-NEXT:    v_and_b32_e32 v6, 0xffff, v6
; SI-NEXT:    v_and_b32_e32 v7, 0xffff, v7
; SI-NEXT:    v_and_b32_e32 v8, 0xffff, v8
; SI-NEXT:    v_and_b32_e32 v9, 0xffff, v9
; SI-NEXT:    v_and_b32_e32 v10, 0xffff, v10
; SI-NEXT:    v_and_b32_e32 v16, 0xffff, v16
; SI-NEXT:    v_or_b32_e32 v0, v42, v0
; SI-NEXT:    s_mov_b32 s6, 0x30000
; SI-NEXT:    v_or_b32_e32 v1, v41, v1
; SI-NEXT:    v_or_b32_e32 v2, v36, v2
; SI-NEXT:    v_or_b32_e32 v3, v35, v3
; SI-NEXT:    v_or_b32_e32 v4, v40, v4
; SI-NEXT:    v_or_b32_e32 v5, v34, v5
; SI-NEXT:    v_or_b32_e32 v6, v33, v6
; SI-NEXT:    v_or_b32_e32 v7, v32, v7
; SI-NEXT:    v_or_b32_e32 v8, v63, v8
; SI-NEXT:    v_or_b32_e32 v9, v62, v9
; SI-NEXT:    v_or_b32_e32 v10, v61, v10
; SI-NEXT:    v_or_b32_e32 v16, v47, v16
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v1, vcc, s6, v1
; SI-NEXT:    v_add_i32_e32 v2, vcc, s6, v2
; SI-NEXT:    v_add_i32_e32 v3, vcc, s6, v3
; SI-NEXT:    v_add_i32_e32 v4, vcc, s6, v4
; SI-NEXT:    v_add_i32_e32 v5, vcc, s6, v5
; SI-NEXT:    v_add_i32_e32 v6, vcc, s6, v6
; SI-NEXT:    v_add_i32_e32 v7, vcc, s6, v7
; SI-NEXT:    v_add_i32_e32 v8, vcc, s6, v8
; SI-NEXT:    v_add_i32_e32 v9, vcc, s6, v9
; SI-NEXT:    v_add_i32_e32 v10, vcc, s6, v10
; SI-NEXT:    v_add_i32_e32 v16, vcc, s6, v16
; SI-NEXT:    s_waitcnt vmcnt(7)
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    s_waitcnt vmcnt(6)
; SI-NEXT:    v_add_i32_e32 v12, vcc, 3, v12
; SI-NEXT:    s_waitcnt vmcnt(5)
; SI-NEXT:    v_add_i32_e32 v14, vcc, 3, v14
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_add_i32_e32 v18, vcc, 3, v18
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_and_b32_e32 v11, 0xffff, v11
; SI-NEXT:    v_and_b32_e32 v12, 0xffff, v12
; SI-NEXT:    v_and_b32_e32 v13, 0xffff, v13
; SI-NEXT:    v_and_b32_e32 v14, 0xffff, v14
; SI-NEXT:    v_and_b32_e32 v15, 0xffff, v15
; SI-NEXT:    v_and_b32_e32 v17, 0xffff, v17
; SI-NEXT:    v_and_b32_e32 v18, 0xffff, v18
; SI-NEXT:    v_and_b32_e32 v19, 0xffff, v19
; SI-NEXT:    v_or_b32_e32 v11, v60, v11
; SI-NEXT:    v_or_b32_e32 v12, v59, v12
; SI-NEXT:    v_or_b32_e32 v13, v58, v13
; SI-NEXT:    v_or_b32_e32 v14, v57, v14
; SI-NEXT:    v_or_b32_e32 v15, v56, v15
; SI-NEXT:    v_or_b32_e32 v17, v46, v17
; SI-NEXT:    v_or_b32_e32 v18, v45, v18
; SI-NEXT:    v_or_b32_e32 v19, v44, v19
; SI-NEXT:    v_add_i32_e32 v11, vcc, s6, v11
; SI-NEXT:    v_add_i32_e32 v12, vcc, s6, v12
; SI-NEXT:    v_add_i32_e32 v13, vcc, s6, v13
; SI-NEXT:    v_add_i32_e32 v14, vcc, s6, v14
; SI-NEXT:    v_add_i32_e32 v15, vcc, s6, v15
; SI-NEXT:    v_add_i32_e32 v17, vcc, s6, v17
; SI-NEXT:    v_add_i32_e32 v18, vcc, s6, v18
; SI-NEXT:    v_add_i32_e32 v19, vcc, s6, v19
; SI-NEXT:  .LBB42_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    buffer_load_dword v63, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:96 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:100 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v40i16_to_v10i64:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; VI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 ; 4-byte Folded Spill
; VI-NEXT:    v_mov_b32_e32 v32, v19
; VI-NEXT:    v_mov_b32_e32 v33, v18
; VI-NEXT:    v_mov_b32_e32 v34, v17
; VI-NEXT:    v_mov_b32_e32 v35, v16
; VI-NEXT:    v_mov_b32_e32 v36, v15
; VI-NEXT:    v_mov_b32_e32 v37, v14
; VI-NEXT:    v_mov_b32_e32 v38, v13
; VI-NEXT:    v_mov_b32_e32 v39, v12
; VI-NEXT:    v_mov_b32_e32 v48, v11
; VI-NEXT:    v_mov_b32_e32 v49, v10
; VI-NEXT:    v_mov_b32_e32 v50, v9
; VI-NEXT:    v_mov_b32_e32 v51, v8
; VI-NEXT:    v_mov_b32_e32 v52, v7
; VI-NEXT:    v_mov_b32_e32 v53, v6
; VI-NEXT:    v_mov_b32_e32 v54, v5
; VI-NEXT:    v_mov_b32_e32 v55, v4
; VI-NEXT:    v_mov_b32_e32 v40, v3
; VI-NEXT:    v_mov_b32_e32 v41, v2
; VI-NEXT:    v_mov_b32_e32 v42, v1
; VI-NEXT:    v_mov_b32_e32 v43, v0
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB42_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_mov_b32_e32 v19, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v19, v43 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v19, v42 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v19, v41 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v3, v19, v40 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v4, v19, v55 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v5, v19, v54 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v6, v19, v53 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v7, v19, v52 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v8, v19, v51 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v9, v19, v50 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v10, v19, v49 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v11, v19, v48 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v12, v19, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v13, v19, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v14, v19, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v15, v19, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v16, v19, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v17, v19, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v18, v19, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v19, v19, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v0, v43, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v42, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v41, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v40, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v55, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v54, v5 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v53, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v52, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v51, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v50, v9 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v49, v10 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v48, v11 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v39, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v38, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v37, v14 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v36, v15 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v35, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v34, v17 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v33, v18 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v32, v19 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    ; implicit-def: $vgpr43
; VI-NEXT:    ; implicit-def: $vgpr42
; VI-NEXT:    ; implicit-def: $vgpr41
; VI-NEXT:    ; implicit-def: $vgpr40
; VI-NEXT:    ; implicit-def: $vgpr55
; VI-NEXT:    ; implicit-def: $vgpr54
; VI-NEXT:    ; implicit-def: $vgpr53
; VI-NEXT:    ; implicit-def: $vgpr52
; VI-NEXT:    ; implicit-def: $vgpr51
; VI-NEXT:    ; implicit-def: $vgpr50
; VI-NEXT:    ; implicit-def: $vgpr49
; VI-NEXT:    ; implicit-def: $vgpr48
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:  .LBB42_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB42_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_mov_b32_e32 v19, 3
; VI-NEXT:    v_add_u16_e32 v0, 3, v43
; VI-NEXT:    v_add_u16_sdwa v1, v43, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v0, v0, v1
; VI-NEXT:    v_add_u16_e32 v1, 3, v42
; VI-NEXT:    v_add_u16_sdwa v2, v42, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v1, v1, v2
; VI-NEXT:    v_add_u16_e32 v2, 3, v41
; VI-NEXT:    v_add_u16_sdwa v3, v41, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v2, v2, v3
; VI-NEXT:    v_add_u16_e32 v3, 3, v40
; VI-NEXT:    v_add_u16_sdwa v4, v40, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v3, v3, v4
; VI-NEXT:    v_add_u16_e32 v4, 3, v55
; VI-NEXT:    v_add_u16_sdwa v5, v55, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v4, v4, v5
; VI-NEXT:    v_add_u16_e32 v5, 3, v54
; VI-NEXT:    v_add_u16_sdwa v6, v54, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v5, v5, v6
; VI-NEXT:    v_add_u16_e32 v6, 3, v53
; VI-NEXT:    v_add_u16_sdwa v7, v53, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v6, v6, v7
; VI-NEXT:    v_add_u16_e32 v7, 3, v52
; VI-NEXT:    v_add_u16_sdwa v8, v52, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v7, v7, v8
; VI-NEXT:    v_add_u16_e32 v8, 3, v51
; VI-NEXT:    v_add_u16_sdwa v9, v51, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v8, v8, v9
; VI-NEXT:    v_add_u16_e32 v9, 3, v50
; VI-NEXT:    v_add_u16_sdwa v10, v50, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v9, v9, v10
; VI-NEXT:    v_add_u16_e32 v10, 3, v49
; VI-NEXT:    v_add_u16_sdwa v11, v49, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v10, v10, v11
; VI-NEXT:    v_add_u16_e32 v11, 3, v48
; VI-NEXT:    v_add_u16_sdwa v12, v48, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v11, v11, v12
; VI-NEXT:    v_add_u16_e32 v12, 3, v39
; VI-NEXT:    v_add_u16_sdwa v13, v39, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v12, v12, v13
; VI-NEXT:    v_add_u16_e32 v13, 3, v38
; VI-NEXT:    v_add_u16_sdwa v14, v38, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v13, v13, v14
; VI-NEXT:    v_add_u16_e32 v14, 3, v37
; VI-NEXT:    v_add_u16_sdwa v15, v37, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v14, v14, v15
; VI-NEXT:    v_add_u16_e32 v15, 3, v36
; VI-NEXT:    v_add_u16_sdwa v16, v36, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v15, v15, v16
; VI-NEXT:    v_add_u16_e32 v16, 3, v35
; VI-NEXT:    v_add_u16_sdwa v17, v35, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v16, v16, v17
; VI-NEXT:    v_add_u16_e32 v17, 3, v34
; VI-NEXT:    v_add_u16_sdwa v18, v34, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v17, v17, v18
; VI-NEXT:    v_add_u16_e32 v18, 3, v33
; VI-NEXT:    v_add_u16_sdwa v20, v33, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v18, v18, v20
; VI-NEXT:    v_add_u16_e32 v20, 3, v32
; VI-NEXT:    v_add_u16_sdwa v19, v32, v19 dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; VI-NEXT:    v_or_b32_e32 v19, v20, v19
; VI-NEXT:  .LBB42_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; VI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v40i16_to_v10i64:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v19
; GFX9-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX9-NEXT:    buffer_store_dword v63, off, s[0:3], s32 ; 4-byte Folded Spill
; GFX9-NEXT:    v_mov_b32_e32 v33, v18
; GFX9-NEXT:    v_mov_b32_e32 v43, v0
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v32
; GFX9-NEXT:    v_mov_b32_e32 v34, v17
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:64 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v33
; GFX9-NEXT:    v_mov_b32_e32 v35, v16
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:68 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v34
; GFX9-NEXT:    v_mov_b32_e32 v36, v15
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:72 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v35
; GFX9-NEXT:    v_mov_b32_e32 v37, v14
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:76 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v36
; GFX9-NEXT:    v_mov_b32_e32 v38, v13
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:80 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v37
; GFX9-NEXT:    v_mov_b32_e32 v39, v12
; GFX9-NEXT:    v_mov_b32_e32 v48, v11
; GFX9-NEXT:    v_mov_b32_e32 v49, v10
; GFX9-NEXT:    v_mov_b32_e32 v50, v9
; GFX9-NEXT:    v_mov_b32_e32 v51, v8
; GFX9-NEXT:    v_mov_b32_e32 v52, v7
; GFX9-NEXT:    v_mov_b32_e32 v53, v6
; GFX9-NEXT:    v_mov_b32_e32 v54, v5
; GFX9-NEXT:    v_mov_b32_e32 v55, v4
; GFX9-NEXT:    v_mov_b32_e32 v40, v3
; GFX9-NEXT:    v_mov_b32_e32 v41, v2
; GFX9-NEXT:    v_mov_b32_e32 v42, v1
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:84 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v38
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:88 ; 4-byte Folded Spill
; GFX9-NEXT:    v_lshrrev_b32_e32 v0, 16, v39
; GFX9-NEXT:    v_lshrrev_b32_e32 v60, 16, v48
; GFX9-NEXT:    v_lshrrev_b32_e32 v61, 16, v49
; GFX9-NEXT:    v_lshrrev_b32_e32 v62, 16, v50
; GFX9-NEXT:    v_lshrrev_b32_e32 v63, 16, v51
; GFX9-NEXT:    v_lshrrev_b32_e32 v44, 16, v52
; GFX9-NEXT:    v_lshrrev_b32_e32 v45, 16, v53
; GFX9-NEXT:    v_lshrrev_b32_e32 v46, 16, v54
; GFX9-NEXT:    v_lshrrev_b32_e32 v47, 16, v55
; GFX9-NEXT:    v_lshrrev_b32_e32 v56, 16, v40
; GFX9-NEXT:    v_lshrrev_b32_e32 v57, 16, v41
; GFX9-NEXT:    v_lshrrev_b32_e32 v58, 16, v42
; GFX9-NEXT:    v_lshrrev_b32_e32 v59, 16, v43
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    buffer_store_dword v0, off, s[0:3], s32 offset:92 ; 4-byte Folded Spill
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB42_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 16, v39
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 16, v38
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v37
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 16, v36
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    v_lshrrev_b32_e32 v16, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v18, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v19, 16, v32
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    v_perm_b32 v0, v59, v43, s6
; GFX9-NEXT:    v_perm_b32 v1, v58, v42, s6
; GFX9-NEXT:    v_perm_b32 v2, v57, v41, s6
; GFX9-NEXT:    v_perm_b32 v3, v56, v40, s6
; GFX9-NEXT:    v_perm_b32 v4, v47, v55, s6
; GFX9-NEXT:    v_perm_b32 v5, v46, v54, s6
; GFX9-NEXT:    v_perm_b32 v6, v45, v53, s6
; GFX9-NEXT:    v_perm_b32 v7, v44, v52, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v51, s6
; GFX9-NEXT:    v_perm_b32 v9, v62, v50, s6
; GFX9-NEXT:    v_perm_b32 v10, v61, v49, s6
; GFX9-NEXT:    v_perm_b32 v11, v60, v48, s6
; GFX9-NEXT:    v_perm_b32 v12, v12, v39, s6
; GFX9-NEXT:    v_perm_b32 v13, v13, v38, s6
; GFX9-NEXT:    v_perm_b32 v14, v14, v37, s6
; GFX9-NEXT:    v_perm_b32 v15, v15, v36, s6
; GFX9-NEXT:    v_perm_b32 v16, v16, v35, s6
; GFX9-NEXT:    v_perm_b32 v17, v17, v34, s6
; GFX9-NEXT:    v_perm_b32 v18, v18, v33, s6
; GFX9-NEXT:    v_perm_b32 v19, v19, v32, s6
; GFX9-NEXT:    ; implicit-def: $vgpr43
; GFX9-NEXT:    ; implicit-def: $vgpr42
; GFX9-NEXT:    ; implicit-def: $vgpr41
; GFX9-NEXT:    ; implicit-def: $vgpr40
; GFX9-NEXT:    ; implicit-def: $vgpr55
; GFX9-NEXT:    ; implicit-def: $vgpr54
; GFX9-NEXT:    ; implicit-def: $vgpr53
; GFX9-NEXT:    ; implicit-def: $vgpr52
; GFX9-NEXT:    ; implicit-def: $vgpr51
; GFX9-NEXT:    ; implicit-def: $vgpr50
; GFX9-NEXT:    ; implicit-def: $vgpr49
; GFX9-NEXT:    ; implicit-def: $vgpr48
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    ; kill: killed $vgpr20
; GFX9-NEXT:    ; implicit-def: $vgpr60
; GFX9-NEXT:    ; implicit-def: $vgpr61
; GFX9-NEXT:    ; implicit-def: $vgpr62
; GFX9-NEXT:    ; implicit-def: $vgpr63
; GFX9-NEXT:    ; implicit-def: $vgpr44
; GFX9-NEXT:    ; implicit-def: $vgpr45
; GFX9-NEXT:    ; implicit-def: $vgpr46
; GFX9-NEXT:    ; implicit-def: $vgpr47
; GFX9-NEXT:    ; implicit-def: $vgpr56
; GFX9-NEXT:    ; implicit-def: $vgpr57
; GFX9-NEXT:    ; implicit-def: $vgpr58
; GFX9-NEXT:    ; implicit-def: $vgpr59
; GFX9-NEXT:  .LBB42_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB42_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    buffer_load_dword v12, off, s[0:3], s32 offset:92 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v13, off, s[0:3], s32 offset:88 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v14, off, s[0:3], s32 offset:84 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v15, off, s[0:3], s32 offset:80 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v16, off, s[0:3], s32 offset:76 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v17, off, s[0:3], s32 offset:72 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v18, off, s[0:3], s32 offset:68 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v19, off, s[0:3], s32 offset:64 ; 4-byte Folded Reload
; GFX9-NEXT:    s_mov_b32 s6, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v59, v43, s6
; GFX9-NEXT:    v_perm_b32 v1, v58, v42, s6
; GFX9-NEXT:    v_perm_b32 v2, v57, v41, s6
; GFX9-NEXT:    v_perm_b32 v3, v56, v40, s6
; GFX9-NEXT:    v_perm_b32 v4, v47, v55, s6
; GFX9-NEXT:    v_perm_b32 v5, v46, v54, s6
; GFX9-NEXT:    v_perm_b32 v6, v45, v53, s6
; GFX9-NEXT:    v_perm_b32 v7, v44, v52, s6
; GFX9-NEXT:    v_perm_b32 v8, v63, v51, s6
; GFX9-NEXT:    v_perm_b32 v9, v62, v50, s6
; GFX9-NEXT:    v_perm_b32 v10, v61, v49, s6
; GFX9-NEXT:    v_perm_b32 v11, v60, v48, s6
; GFX9-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    s_waitcnt vmcnt(7)
; GFX9-NEXT:    v_perm_b32 v12, v12, v39, s6
; GFX9-NEXT:    s_waitcnt vmcnt(6)
; GFX9-NEXT:    v_perm_b32 v13, v13, v38, s6
; GFX9-NEXT:    s_waitcnt vmcnt(5)
; GFX9-NEXT:    v_perm_b32 v14, v14, v37, s6
; GFX9-NEXT:    s_waitcnt vmcnt(4)
; GFX9-NEXT:    v_perm_b32 v15, v15, v36, s6
; GFX9-NEXT:    s_waitcnt vmcnt(3)
; GFX9-NEXT:    v_perm_b32 v16, v16, v35, s6
; GFX9-NEXT:    s_waitcnt vmcnt(2)
; GFX9-NEXT:    v_perm_b32 v17, v17, v34, s6
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_perm_b32 v18, v18, v33, s6
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v19, v19, v32, s6
; GFX9-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB42_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    buffer_load_dword v63, off, s[0:3], s32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v62, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v61, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v60, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:52 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:56 ; 4-byte Folded Reload
; GFX9-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:60 ; 4-byte Folded Reload
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v40i16_to_v10i64:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB42_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:  .LBB42_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v40i16_to_v10i64:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v3
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v37, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v38, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v39, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v48, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v36, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v35, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v34, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v33, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v32, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v31, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v30, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v29, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v28, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v27, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v26, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v25, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v24, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v23, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v22, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v21, v19, 0x5040100
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB42_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v0, v0, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v1, v1, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v2, v2, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v3, v3, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v4, v4, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v5, v5, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v6, v6, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v7, v7, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v8, v8, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v9, v9, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v10, v10, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v11, v11, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v12, v12, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v13, v13, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:  .LBB42_2: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <40 x i16> %a, splat (i16 3)
  %a2 = bitcast <40 x i16> %a1 to <10 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <40 x i16> %a to <10 x i64>
  br label %end

end:
  %phi = phi <10 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x i64> %phi
}

define inreg <10 x i64> @bitcast_v40i16_to_v10i64_scalar(<40 x i16> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v40i16_to_v10i64_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v26
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    v_mov_b32_e32 v32, v24
; SI-NEXT:    v_mov_b32_e32 v33, v22
; SI-NEXT:    v_mov_b32_e32 v34, v20
; SI-NEXT:    v_mov_b32_e32 v35, v18
; SI-NEXT:    v_mov_b32_e32 v36, v16
; SI-NEXT:    v_mov_b32_e32 v37, v14
; SI-NEXT:    v_mov_b32_e32 v38, v12
; SI-NEXT:    v_mov_b32_e32 v39, v10
; SI-NEXT:    v_mov_b32_e32 v48, v8
; SI-NEXT:    v_mov_b32_e32 v49, v6
; SI-NEXT:    v_mov_b32_e32 v50, v4
; SI-NEXT:    v_mov_b32_e32 v51, v2
; SI-NEXT:    v_mov_b32_e32 v52, v0
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshlrev_b32_e32 v57, 16, v1
; SI-NEXT:    v_lshlrev_b32_e32 v56, 16, v3
; SI-NEXT:    v_lshlrev_b32_e32 v47, 16, v5
; SI-NEXT:    v_lshlrev_b32_e32 v46, 16, v7
; SI-NEXT:    v_lshlrev_b32_e32 v45, 16, v9
; SI-NEXT:    v_lshlrev_b32_e32 v44, 16, v11
; SI-NEXT:    v_lshlrev_b32_e32 v43, 16, v13
; SI-NEXT:    v_lshlrev_b32_e32 v42, 16, v15
; SI-NEXT:    v_lshlrev_b32_e32 v41, 16, v17
; SI-NEXT:    v_lshlrev_b32_e32 v40, 16, v19
; SI-NEXT:    v_lshlrev_b32_e32 v55, 16, v21
; SI-NEXT:    v_lshlrev_b32_e32 v54, 16, v23
; SI-NEXT:    v_lshlrev_b32_e32 v53, 16, v25
; SI-NEXT:    s_cbranch_scc0 .LBB43_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v52
; SI-NEXT:    v_or_b32_e32 v7, v0, v57
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v51
; SI-NEXT:    v_or_b32_e32 v8, v0, v56
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v50
; SI-NEXT:    v_or_b32_e32 v9, v0, v47
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v49
; SI-NEXT:    v_or_b32_e32 v10, v0, v46
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v48
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    v_or_b32_e32 v11, v0, v45
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v39
; SI-NEXT:    s_or_b32 s4, s4, s5
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    v_or_b32_e32 v12, v0, v44
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v38
; SI-NEXT:    s_or_b32 s5, s5, s6
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    v_or_b32_e32 v13, v0, v43
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v37
; SI-NEXT:    s_or_b32 s6, s6, s7
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    v_or_b32_e32 v14, v0, v42
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v36
; SI-NEXT:    s_or_b32 s7, s7, s8
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    v_or_b32_e32 v15, v0, v41
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v35
; SI-NEXT:    s_or_b32 s8, s8, s9
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    v_or_b32_e32 v16, v0, v40
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v34
; SI-NEXT:    s_or_b32 s9, s9, s10
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_or_b32_e32 v17, v0, v55
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v33
; SI-NEXT:    s_or_b32 s10, s10, s11
; SI-NEXT:    v_or_b32_e32 v18, v0, v54
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v32
; SI-NEXT:    v_or_b32_e32 v19, v0, v53
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:    s_cbranch_execnz .LBB43_3
; SI-NEXT:  .LBB43_2: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v52
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v57, v0
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v51
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v56, v0
; SI-NEXT:    v_add_i32_e32 v8, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v50
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v47, v0
; SI-NEXT:    v_add_i32_e32 v9, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v49
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v46, v0
; SI-NEXT:    v_add_i32_e32 v10, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v48
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v45, v0
; SI-NEXT:    v_add_i32_e32 v11, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v39
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v44, v0
; SI-NEXT:    v_add_i32_e32 v12, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v38
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v43, v0
; SI-NEXT:    v_add_i32_e32 v13, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v37
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v42, v0
; SI-NEXT:    v_add_i32_e32 v14, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v36
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    v_or_b32_e32 v0, v41, v0
; SI-NEXT:    v_add_i32_e32 v15, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v35
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s16, s16, 3
; SI-NEXT:    v_or_b32_e32 v0, v40, v0
; SI-NEXT:    s_and_b32 s4, s16, 0xffff
; SI-NEXT:    s_lshl_b32 s5, s17, 16
; SI-NEXT:    s_add_i32 s18, s18, 3
; SI-NEXT:    v_add_i32_e32 v16, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v34
; SI-NEXT:    s_or_b32 s4, s5, s4
; SI-NEXT:    s_and_b32 s5, s18, 0xffff
; SI-NEXT:    s_lshl_b32 s6, s19, 16
; SI-NEXT:    s_add_i32 s20, s20, 3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_or_b32 s5, s6, s5
; SI-NEXT:    s_and_b32 s6, s20, 0xffff
; SI-NEXT:    s_lshl_b32 s7, s21, 16
; SI-NEXT:    s_add_i32 s22, s22, 3
; SI-NEXT:    v_or_b32_e32 v0, v55, v0
; SI-NEXT:    s_or_b32 s6, s7, s6
; SI-NEXT:    s_and_b32 s7, s22, 0xffff
; SI-NEXT:    s_lshl_b32 s8, s23, 16
; SI-NEXT:    s_add_i32 s24, s24, 3
; SI-NEXT:    v_add_i32_e32 v17, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v33
; SI-NEXT:    s_or_b32 s7, s8, s7
; SI-NEXT:    s_and_b32 s8, s24, 0xffff
; SI-NEXT:    s_lshl_b32 s9, s25, 16
; SI-NEXT:    s_add_i32 s26, s26, 3
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_or_b32 s8, s9, s8
; SI-NEXT:    s_and_b32 s9, s26, 0xffff
; SI-NEXT:    s_lshl_b32 s10, s27, 16
; SI-NEXT:    s_add_i32 s28, s28, 3
; SI-NEXT:    v_or_b32_e32 v0, v54, v0
; SI-NEXT:    s_or_b32 s9, s10, s9
; SI-NEXT:    s_and_b32 s10, s28, 0xffff
; SI-NEXT:    s_lshl_b32 s11, s29, 16
; SI-NEXT:    v_add_i32_e32 v18, vcc, 0x30000, v0
; SI-NEXT:    v_add_i32_e32 v0, vcc, 3, v32
; SI-NEXT:    s_or_b32 s10, s11, s10
; SI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; SI-NEXT:    s_add_i32 s4, s4, 0x30000
; SI-NEXT:    s_add_i32 s5, s5, 0x30000
; SI-NEXT:    s_add_i32 s6, s6, 0x30000
; SI-NEXT:    s_add_i32 s7, s7, 0x30000
; SI-NEXT:    s_add_i32 s8, s8, 0x30000
; SI-NEXT:    s_add_i32 s9, s9, 0x30000
; SI-NEXT:    s_add_i32 s10, s10, 0x30000
; SI-NEXT:    v_or_b32_e32 v0, v53, v0
; SI-NEXT:    v_add_i32_e32 v19, vcc, 0x30000, v0
; SI-NEXT:    v_mov_b32_e32 v0, s4
; SI-NEXT:    v_mov_b32_e32 v1, s5
; SI-NEXT:    v_mov_b32_e32 v2, s6
; SI-NEXT:    v_mov_b32_e32 v3, s7
; SI-NEXT:    v_mov_b32_e32 v4, s8
; SI-NEXT:    v_mov_b32_e32 v5, s9
; SI-NEXT:    v_mov_b32_e32 v6, s10
; SI-NEXT:  .LBB43_3: ; %end
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB43_4:
; SI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; SI-NEXT:    s_branch .LBB43_2
;
; VI-LABEL: bitcast_v40i16_to_v10i64_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s6, s29, 16
; VI-NEXT:    s_lshr_b32 s7, s28, 16
; VI-NEXT:    s_lshr_b32 s8, s27, 16
; VI-NEXT:    s_lshr_b32 s9, s26, 16
; VI-NEXT:    s_lshr_b32 s10, s25, 16
; VI-NEXT:    s_lshr_b32 s11, s24, 16
; VI-NEXT:    s_lshr_b32 s12, s23, 16
; VI-NEXT:    s_lshr_b32 s13, s22, 16
; VI-NEXT:    s_lshr_b32 s14, s21, 16
; VI-NEXT:    s_lshr_b32 s15, s20, 16
; VI-NEXT:    s_lshr_b32 s40, s19, 16
; VI-NEXT:    s_lshr_b32 s41, s18, 16
; VI-NEXT:    s_lshr_b32 s42, s17, 16
; VI-NEXT:    s_lshr_b32 s43, s16, 16
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    v_mov_b32_e32 v32, v5
; VI-NEXT:    v_mov_b32_e32 v33, v4
; VI-NEXT:    v_mov_b32_e32 v34, v3
; VI-NEXT:    v_mov_b32_e32 v35, v2
; VI-NEXT:    v_mov_b32_e32 v36, v1
; VI-NEXT:    v_mov_b32_e32 v37, v0
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    s_cbranch_scc0 .LBB43_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s43, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s44, s42, 16
; VI-NEXT:    s_or_b32 s5, s5, s44
; VI-NEXT:    s_and_b32 s44, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s45, s41, 16
; VI-NEXT:    s_or_b32 s44, s44, s45
; VI-NEXT:    s_and_b32 s45, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s46, s40, 16
; VI-NEXT:    s_or_b32 s45, s45, s46
; VI-NEXT:    s_and_b32 s46, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s47, s15, 16
; VI-NEXT:    s_or_b32 s46, s46, s47
; VI-NEXT:    s_and_b32 s47, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s56, s14, 16
; VI-NEXT:    s_or_b32 s47, s47, s56
; VI-NEXT:    s_and_b32 s56, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s57, s13, 16
; VI-NEXT:    s_or_b32 s56, s56, s57
; VI-NEXT:    s_and_b32 s57, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s58, s12, 16
; VI-NEXT:    s_or_b32 s57, s57, s58
; VI-NEXT:    s_and_b32 s58, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s59, s11, 16
; VI-NEXT:    s_or_b32 s58, s58, s59
; VI-NEXT:    s_and_b32 s59, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s60, s10, 16
; VI-NEXT:    v_mov_b32_e32 v0, 16
; VI-NEXT:    s_or_b32 s59, s59, s60
; VI-NEXT:    s_and_b32 s60, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s61, s9, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s60, s60, s61
; VI-NEXT:    s_and_b32 s61, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s62, s8, 16
; VI-NEXT:    v_or_b32_sdwa v14, v37, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s61, s61, s62
; VI-NEXT:    s_and_b32 s62, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s63, s7, 16
; VI-NEXT:    v_or_b32_sdwa v16, v35, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s62, s62, s63
; VI-NEXT:    s_and_b32 s63, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s72, s6, 16
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v0, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_or_b32_sdwa v17, v34, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v0, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    v_lshlrev_b32_sdwa v0, v0, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s63, s63, s72
; VI-NEXT:    v_or_b32_sdwa v15, v36, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v33, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v32, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s44
; VI-NEXT:    v_mov_b32_e32 v3, s45
; VI-NEXT:    v_mov_b32_e32 v4, s46
; VI-NEXT:    v_mov_b32_e32 v5, s47
; VI-NEXT:    v_mov_b32_e32 v6, s56
; VI-NEXT:    v_mov_b32_e32 v7, s57
; VI-NEXT:    v_mov_b32_e32 v8, s58
; VI-NEXT:    v_mov_b32_e32 v9, s59
; VI-NEXT:    v_mov_b32_e32 v10, s60
; VI-NEXT:    v_mov_b32_e32 v11, s61
; VI-NEXT:    v_mov_b32_e32 v12, s62
; VI-NEXT:    v_mov_b32_e32 v13, s63
; VI-NEXT:    s_cbranch_execnz .LBB43_3
; VI-NEXT:  .LBB43_2: ; %cmp.true
; VI-NEXT:    s_add_i32 s16, s16, 3
; VI-NEXT:    s_and_b32 s4, s16, 0xffff
; VI-NEXT:    s_lshl_b32 s5, s43, 16
; VI-NEXT:    s_add_i32 s17, s17, 3
; VI-NEXT:    s_or_b32 s4, s5, s4
; VI-NEXT:    s_and_b32 s5, s17, 0xffff
; VI-NEXT:    s_lshl_b32 s16, s42, 16
; VI-NEXT:    s_add_i32 s18, s18, 3
; VI-NEXT:    s_or_b32 s5, s16, s5
; VI-NEXT:    s_and_b32 s16, s18, 0xffff
; VI-NEXT:    s_lshl_b32 s17, s41, 16
; VI-NEXT:    s_add_i32 s19, s19, 3
; VI-NEXT:    s_or_b32 s16, s17, s16
; VI-NEXT:    s_and_b32 s17, s19, 0xffff
; VI-NEXT:    s_lshl_b32 s18, s40, 16
; VI-NEXT:    s_add_i32 s20, s20, 3
; VI-NEXT:    v_mov_b32_e32 v1, 16
; VI-NEXT:    s_or_b32 s17, s18, s17
; VI-NEXT:    s_and_b32 s18, s20, 0xffff
; VI-NEXT:    s_lshl_b32 s15, s15, 16
; VI-NEXT:    s_add_i32 s21, s21, 3
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v37
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s15, s15, s18
; VI-NEXT:    s_and_b32 s18, s21, 0xffff
; VI-NEXT:    s_lshl_b32 s14, s14, 16
; VI-NEXT:    s_add_i32 s22, s22, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v36
; VI-NEXT:    v_lshlrev_b32_sdwa v3, v1, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s14, s14, s18
; VI-NEXT:    s_and_b32 s18, s22, 0xffff
; VI-NEXT:    s_lshl_b32 s13, s13, 16
; VI-NEXT:    s_add_i32 s23, s23, 3
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s13, s13, s18
; VI-NEXT:    s_and_b32 s18, s23, 0xffff
; VI-NEXT:    s_lshl_b32 s12, s12, 16
; VI-NEXT:    s_add_i32 s24, s24, 3
; VI-NEXT:    v_add_u32_e32 v14, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v15, vcc, 0x30000, v2
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v35
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s12, s12, s18
; VI-NEXT:    s_and_b32 s18, s24, 0xffff
; VI-NEXT:    s_lshl_b32 s11, s11, 16
; VI-NEXT:    s_add_i32 s25, s25, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s11, s11, s18
; VI-NEXT:    s_and_b32 s18, s25, 0xffff
; VI-NEXT:    s_lshl_b32 s10, s10, 16
; VI-NEXT:    s_add_i32 s26, s26, 3
; VI-NEXT:    v_add_u32_e32 v16, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v34
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s10, s10, s18
; VI-NEXT:    s_and_b32 s18, s26, 0xffff
; VI-NEXT:    s_lshl_b32 s9, s9, 16
; VI-NEXT:    s_add_i32 s27, s27, 3
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s9, s9, s18
; VI-NEXT:    s_and_b32 s18, s27, 0xffff
; VI-NEXT:    s_lshl_b32 s8, s8, 16
; VI-NEXT:    s_add_i32 s28, s28, 3
; VI-NEXT:    s_or_b32 s8, s8, s18
; VI-NEXT:    s_and_b32 s18, s28, 0xffff
; VI-NEXT:    s_lshl_b32 s7, s7, 16
; VI-NEXT:    s_add_i32 s29, s29, 3
; VI-NEXT:    v_add_u32_e32 v17, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v33
; VI-NEXT:    v_lshlrev_b32_sdwa v2, v1, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_or_b32 s7, s7, s18
; VI-NEXT:    s_and_b32 s18, s29, 0xffff
; VI-NEXT:    s_lshl_b32 s6, s6, 16
; VI-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    s_or_b32 s6, s6, s18
; VI-NEXT:    v_add_u32_e32 v18, vcc, 0x30000, v0
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v32
; VI-NEXT:    v_lshlrev_b32_sdwa v1, v1, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_1
; VI-NEXT:    s_add_i32 s4, s4, 0x30000
; VI-NEXT:    s_add_i32 s5, s5, 0x30000
; VI-NEXT:    s_add_i32 s16, s16, 0x30000
; VI-NEXT:    s_add_i32 s17, s17, 0x30000
; VI-NEXT:    s_add_i32 s15, s15, 0x30000
; VI-NEXT:    s_add_i32 s14, s14, 0x30000
; VI-NEXT:    s_add_i32 s13, s13, 0x30000
; VI-NEXT:    s_add_i32 s12, s12, 0x30000
; VI-NEXT:    s_add_i32 s11, s11, 0x30000
; VI-NEXT:    s_add_i32 s10, s10, 0x30000
; VI-NEXT:    s_add_i32 s9, s9, 0x30000
; VI-NEXT:    s_add_i32 s8, s8, 0x30000
; VI-NEXT:    s_add_i32 s7, s7, 0x30000
; VI-NEXT:    s_add_i32 s6, s6, 0x30000
; VI-NEXT:    v_or_b32_sdwa v0, v1, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:WORD_0
; VI-NEXT:    v_add_u32_e32 v19, vcc, 0x30000, v0
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    v_mov_b32_e32 v3, s17
; VI-NEXT:    v_mov_b32_e32 v4, s15
; VI-NEXT:    v_mov_b32_e32 v5, s14
; VI-NEXT:    v_mov_b32_e32 v6, s13
; VI-NEXT:    v_mov_b32_e32 v7, s12
; VI-NEXT:    v_mov_b32_e32 v8, s11
; VI-NEXT:    v_mov_b32_e32 v9, s10
; VI-NEXT:    v_mov_b32_e32 v10, s9
; VI-NEXT:    v_mov_b32_e32 v11, s8
; VI-NEXT:    v_mov_b32_e32 v12, s7
; VI-NEXT:    v_mov_b32_e32 v13, s6
; VI-NEXT:  .LBB43_3: ; %end
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB43_4:
; VI-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; VI-NEXT:    s_branch .LBB43_2
;
; GFX9-LABEL: bitcast_v40i16_to_v10i64_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v32, v5
; GFX9-NEXT:    v_mov_b32_e32 v33, v4
; GFX9-NEXT:    v_mov_b32_e32 v34, v3
; GFX9-NEXT:    v_mov_b32_e32 v35, v2
; GFX9-NEXT:    v_mov_b32_e32 v36, v1
; GFX9-NEXT:    v_mov_b32_e32 v37, v0
; GFX9-NEXT:    s_lshr_b32 s40, s29, 16
; GFX9-NEXT:    s_lshr_b32 s41, s28, 16
; GFX9-NEXT:    s_lshr_b32 s42, s27, 16
; GFX9-NEXT:    s_lshr_b32 s43, s26, 16
; GFX9-NEXT:    s_lshr_b32 s15, s25, 16
; GFX9-NEXT:    s_lshr_b32 s14, s24, 16
; GFX9-NEXT:    s_lshr_b32 s13, s23, 16
; GFX9-NEXT:    s_lshr_b32 s12, s22, 16
; GFX9-NEXT:    s_lshr_b32 s11, s21, 16
; GFX9-NEXT:    s_lshr_b32 s10, s20, 16
; GFX9-NEXT:    s_lshr_b32 s9, s19, 16
; GFX9-NEXT:    s_lshr_b32 s8, s18, 16
; GFX9-NEXT:    s_lshr_b32 s7, s17, 16
; GFX9-NEXT:    s_lshr_b32 s6, s16, 16
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v32
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v33
; GFX9-NEXT:    v_lshrrev_b32_e32 v48, 16, v34
; GFX9-NEXT:    v_lshrrev_b32_e32 v49, 16, v35
; GFX9-NEXT:    v_lshrrev_b32_e32 v50, 16, v36
; GFX9-NEXT:    v_lshrrev_b32_e32 v51, 16, v37
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s16, s6
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s17, s7
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s18, s8
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s19, s9
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s20, s10
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s21, s11
; GFX9-NEXT:    s_pack_ll_b32_b16 s12, s22, s12
; GFX9-NEXT:    s_pack_ll_b32_b16 s13, s23, s13
; GFX9-NEXT:    s_pack_ll_b32_b16 s14, s24, s14
; GFX9-NEXT:    s_pack_ll_b32_b16 s15, s25, s15
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s26, s43
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s27, s42
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s28, s41
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s29, s40
; GFX9-NEXT:    s_cbranch_scc0 .LBB43_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v37
; GFX9-NEXT:    v_lshl_or_b32 v14, v51, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v36
; GFX9-NEXT:    v_lshl_or_b32 v15, v50, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v35
; GFX9-NEXT:    v_lshl_or_b32 v16, v49, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v34
; GFX9-NEXT:    v_lshl_or_b32 v17, v48, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v33
; GFX9-NEXT:    v_lshl_or_b32 v18, v39, 16, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 0xffff, v32
; GFX9-NEXT:    v_lshl_or_b32 v19, v38, 16, v0
; GFX9-NEXT:    v_mov_b32_e32 v0, s6
; GFX9-NEXT:    v_mov_b32_e32 v1, s7
; GFX9-NEXT:    v_mov_b32_e32 v2, s8
; GFX9-NEXT:    v_mov_b32_e32 v3, s9
; GFX9-NEXT:    v_mov_b32_e32 v4, s10
; GFX9-NEXT:    v_mov_b32_e32 v5, s11
; GFX9-NEXT:    v_mov_b32_e32 v6, s12
; GFX9-NEXT:    v_mov_b32_e32 v7, s13
; GFX9-NEXT:    v_mov_b32_e32 v8, s14
; GFX9-NEXT:    v_mov_b32_e32 v9, s15
; GFX9-NEXT:    v_mov_b32_e32 v10, s16
; GFX9-NEXT:    v_mov_b32_e32 v11, s17
; GFX9-NEXT:    v_mov_b32_e32 v12, s18
; GFX9-NEXT:    v_mov_b32_e32 v13, s19
; GFX9-NEXT:    s_cbranch_execnz .LBB43_3
; GFX9-NEXT:  .LBB43_2: ; %cmp.true
; GFX9-NEXT:    v_and_b32_e32 v14, 0xffff, v37
; GFX9-NEXT:    v_and_b32_e32 v15, 0xffff, v36
; GFX9-NEXT:    v_and_b32_e32 v16, 0xffff, v35
; GFX9-NEXT:    v_and_b32_e32 v17, 0xffff, v34
; GFX9-NEXT:    v_and_b32_e32 v18, 0xffff, v33
; GFX9-NEXT:    v_and_b32_e32 v19, 0xffff, v32
; GFX9-NEXT:    v_lshl_or_b32 v14, v51, 16, v14
; GFX9-NEXT:    v_lshl_or_b32 v15, v50, 16, v15
; GFX9-NEXT:    v_lshl_or_b32 v16, v49, 16, v16
; GFX9-NEXT:    v_lshl_or_b32 v17, v48, 16, v17
; GFX9-NEXT:    v_lshl_or_b32 v18, v39, 16, v18
; GFX9-NEXT:    v_lshl_or_b32 v19, v38, 16, v19
; GFX9-NEXT:    v_pk_add_u16 v0, s6, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v1, s7, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v2, s8, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v3, s9, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v4, s10, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v5, s11, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v6, s12, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v7, s13, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v8, s14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v9, s15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v10, s16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v11, s17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v12, s18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v13, s19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v14, v14, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v15, v15, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v16, v16, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v17, v17, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX9-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX9-NEXT:  .LBB43_3: ; %end
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB43_4:
; GFX9-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX9-NEXT:    s_branch .LBB43_2
;
; GFX11-TRUE16-LABEL: bitcast_v40i16_to_v10i64_scalar:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.h, 0
; GFX11-TRUE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v32.l, v1.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.l, v0.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v35, 0xffff, v0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v33.h, v32.h
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v34, 0xffff, v1
; GFX11-TRUE16-NEXT:    s_lshr_b32 s41, s29, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s42, s28, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s43, s27, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s44, s26, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s45, s25, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s15, s24, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s13, s22, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s12, s21, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s11, s20, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s10, s19, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s9, s18, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s8, s17, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s7, s16, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s6, s2, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-TRUE16-NEXT:    s_lshr_b32 s4, s0, 16
; GFX11-TRUE16-NEXT:    s_mov_b32 s40, 0
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s4, s0, s4
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s5, s1, s5
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s6, s2, s6
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s7, s16, s7
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s8, s17, s8
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s9, s18, s9
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s10, s19, s10
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s11, s20, s11
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s12, s21, s12
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s13, s22, s13
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s15, s24, s15
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s16, s25, s45
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s17, s26, s44
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s0, s27, s43
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s1, s28, s42
; GFX11-TRUE16-NEXT:    s_pack_ll_b32_b16 s2, s29, s41
; GFX11-TRUE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-TRUE16-NEXT:    s_cbranch_scc0 .LBB43_4
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s3
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v4, s7 :: v_dual_mov_b32 v5, s8
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v6, s9 :: v_dual_mov_b32 v7, s10
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v8, s11 :: v_dual_mov_b32 v9, s12
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v10, s13 :: v_dual_mov_b32 v11, s14
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v12, s15 :: v_dual_mov_b32 v13, s16
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v14, s17 :: v_dual_mov_b32 v15, s0
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v16, s1 :: v_dual_mov_b32 v17, s2
; GFX11-TRUE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s40
; GFX11-TRUE16-NEXT:    s_cbranch_vccnz .LBB43_3
; GFX11-TRUE16-NEXT:  .LBB43_2: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-TRUE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v0, s4, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v1, s5, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v2, s6, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v4, s7, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v5, s8, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v6, s9, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v7, s10, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v8, s11, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v9, s12, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v10, s13, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v11, s14, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v12, s15, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v13, s16, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v14, s17, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v15, s0, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v16, s1, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v17, s2, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-TRUE16-NEXT:  .LBB43_3: ; %end
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-TRUE16-NEXT:  .LBB43_4:
; GFX11-TRUE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-TRUE16-NEXT:    s_branch .LBB43_2
;
; GFX11-FAKE16-LABEL: bitcast_v40i16_to_v10i64_scalar:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v35, 0xffff, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v34, 0xffff, v1
; GFX11-FAKE16-NEXT:    s_lshr_b32 s41, s29, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s42, s28, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s43, s27, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s44, s26, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s45, s25, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s15, s24, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s13, s22, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s12, s21, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s11, s20, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s10, s19, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s9, s18, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s8, s17, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s7, s16, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s6, s2, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s5, s1, 16
; GFX11-FAKE16-NEXT:    s_lshr_b32 s4, s0, 16
; GFX11-FAKE16-NEXT:    s_mov_b32 s40, 0
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s4, s0, s4
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s5, s1, s5
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s6, s2, s6
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s7, s16, s7
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s8, s17, s8
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s9, s18, s9
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s10, s19, s10
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s11, s20, s11
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s12, s21, s12
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s13, s22, s13
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s15, s24, s15
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s16, s25, s45
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s17, s26, s44
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s0, s27, s43
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s1, s28, s42
; GFX11-FAKE16-NEXT:    s_pack_ll_b32_b16 s2, s29, s41
; GFX11-FAKE16-NEXT:    s_and_b32 s47, vcc_lo, exec_lo
; GFX11-FAKE16-NEXT:    s_cbranch_scc0 .LBB43_4
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v0, s4 :: v_dual_mov_b32 v1, s5
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v2, s6 :: v_dual_mov_b32 v3, s3
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v4, s7 :: v_dual_mov_b32 v5, s8
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v6, s9 :: v_dual_mov_b32 v7, s10
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v8, s11 :: v_dual_mov_b32 v9, s12
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v10, s13 :: v_dual_mov_b32 v11, s14
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v12, s15 :: v_dual_mov_b32 v13, s16
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v14, s17 :: v_dual_mov_b32 v15, s0
; GFX11-FAKE16-NEXT:    v_dual_mov_b32 v16, s1 :: v_dual_mov_b32 v17, s2
; GFX11-FAKE16-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s40
; GFX11-FAKE16-NEXT:    s_cbranch_vccnz .LBB43_3
; GFX11-FAKE16-NEXT:  .LBB43_2: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v18, v33, 16, v35
; GFX11-FAKE16-NEXT:    v_lshl_or_b32 v19, v32, 16, v34
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v0, s4, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v1, s5, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v2, s6, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v3, s3, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v4, s7, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v5, s8, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v6, s9, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v7, s10, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v8, s11, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v9, s12, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v10, s13, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v11, s14, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v12, s15, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v13, s16, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v14, s17, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v15, s0, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v16, s1, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v17, s2, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v18, v18, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:    v_pk_add_u16 v19, v19, 3 op_sel_hi:[1,0]
; GFX11-FAKE16-NEXT:  .LBB43_3: ; %end
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
; GFX11-FAKE16-NEXT:  .LBB43_4:
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr0_vgpr1_vgpr2_vgpr3_vgpr4_vgpr5_vgpr6_vgpr7_vgpr8_vgpr9_vgpr10_vgpr11_vgpr12_vgpr13_vgpr14_vgpr15_vgpr16_vgpr17_vgpr18_vgpr19_vgpr20_vgpr21_vgpr22_vgpr23_vgpr24_vgpr25_vgpr26_vgpr27_vgpr28_vgpr29_vgpr30_vgpr31
; GFX11-FAKE16-NEXT:    s_branch .LBB43_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <40 x i16> %a, splat (i16 3)
  %a2 = bitcast <40 x i16> %a1 to <10 x i64>
  br label %end

cmp.false:
  %a3 = bitcast <40 x i16> %a to <10 x i64>
  br label %end

end:
  %phi = phi <10 x i64> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <10 x i64> %phi
}

define <40 x half> @bitcast_v10i64_to_v40f16(<10 x i64> %a, i32 %b) {
; SI-LABEL: bitcast_v10i64_to_v40f16:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v21
; SI-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:48 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:44 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:40 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v43, off, s[0:3], s32 offset:36 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v44, off, s[0:3], s32 offset:32 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v45, off, s[0:3], s32 offset:28 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v46, off, s[0:3], s32 offset:24 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v47, off, s[0:3], s32 offset:20 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v56, off, s[0:3], s32 offset:16 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v57, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v58, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v59, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; SI-NEXT:    buffer_store_dword v60, off, s[0:3], s32 ; 4-byte Folded Spill
; SI-NEXT:    ; implicit-def: $vgpr59
; SI-NEXT:    ; implicit-def: $vgpr60
; SI-NEXT:    ; implicit-def: $vgpr57
; SI-NEXT:    ; implicit-def: $vgpr58
; SI-NEXT:    ; implicit-def: $vgpr47
; SI-NEXT:    ; implicit-def: $vgpr56
; SI-NEXT:    ; implicit-def: $vgpr45
; SI-NEXT:    ; implicit-def: $vgpr46
; SI-NEXT:    ; implicit-def: $vgpr44
; SI-NEXT:    ; implicit-def: $vgpr43
; SI-NEXT:    ; implicit-def: $vgpr42
; SI-NEXT:    ; implicit-def: $vgpr41
; SI-NEXT:    ; implicit-def: $vgpr40
; SI-NEXT:    ; implicit-def: $vgpr55
; SI-NEXT:    ; implicit-def: $vgpr54
; SI-NEXT:    ; implicit-def: $vgpr53
; SI-NEXT:    ; implicit-def: $vgpr52
; SI-NEXT:    ; implicit-def: $vgpr51
; SI-NEXT:    ; implicit-def: $vgpr50
; SI-NEXT:    ; implicit-def: $vgpr49
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; SI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB44_2
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v32, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v34, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v36, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v39, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v49, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v51, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v53, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v55, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v41, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v43, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v4
; SI-NEXT:    s_waitcnt expcnt(6)
; SI-NEXT:    v_cvt_f32_f16_e32 v46, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v3
; SI-NEXT:    s_waitcnt expcnt(4)
; SI-NEXT:    v_cvt_f32_f16_e32 v56, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v21, 16, v20
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v19
; SI-NEXT:    s_waitcnt expcnt(2)
; SI-NEXT:    v_cvt_f32_f16_e32 v58, v23
; SI-NEXT:    v_lshrrev_b32_e32 v23, 16, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f32_f16_e32 v60, v23
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v33, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v35, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v37, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v38, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v48, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v50, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v52, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v54, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v40, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v42, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v44, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v45, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v47, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v57, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v59, v1
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:  .LBB44_2: ; %Flow
; SI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; SI-NEXT:    s_cbranch_execz .LBB44_4
; SI-NEXT:  ; %bb.3: ; %cmp.true
; SI-NEXT:    v_add_i32_e32 v1, vcc, 3, v1
; SI-NEXT:    v_addc_u32_e32 v2, vcc, 0, v2, vcc
; SI-NEXT:    v_add_i32_e32 v3, vcc, 3, v3
; SI-NEXT:    v_addc_u32_e32 v4, vcc, 0, v4, vcc
; SI-NEXT:    v_add_i32_e32 v5, vcc, 3, v5
; SI-NEXT:    v_addc_u32_e32 v6, vcc, 0, v6, vcc
; SI-NEXT:    v_add_i32_e32 v7, vcc, 3, v7
; SI-NEXT:    v_addc_u32_e32 v8, vcc, 0, v8, vcc
; SI-NEXT:    v_add_i32_e32 v9, vcc, 3, v9
; SI-NEXT:    v_addc_u32_e32 v10, vcc, 0, v10, vcc
; SI-NEXT:    v_add_i32_e32 v11, vcc, 3, v11
; SI-NEXT:    v_addc_u32_e32 v12, vcc, 0, v12, vcc
; SI-NEXT:    v_add_i32_e32 v13, vcc, 3, v13
; SI-NEXT:    v_addc_u32_e32 v14, vcc, 0, v14, vcc
; SI-NEXT:    v_add_i32_e32 v15, vcc, 3, v15
; SI-NEXT:    v_addc_u32_e32 v16, vcc, 0, v16, vcc
; SI-NEXT:    v_add_i32_e32 v17, vcc, 3, v17
; SI-NEXT:    v_addc_u32_e32 v18, vcc, 0, v18, vcc
; SI-NEXT:    v_add_i32_e32 v19, vcc, 3, v19
; SI-NEXT:    v_addc_u32_e32 v20, vcc, 0, v20, vcc
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_lshrrev_b32_e32 v60, 16, v1
; SI-NEXT:    v_lshrrev_b32_e32 v58, 16, v2
; SI-NEXT:    v_lshrrev_b32_e32 v56, 16, v3
; SI-NEXT:    v_lshrrev_b32_e32 v46, 16, v4
; SI-NEXT:    v_lshrrev_b32_e32 v43, 16, v5
; SI-NEXT:    v_lshrrev_b32_e32 v41, 16, v6
; SI-NEXT:    v_lshrrev_b32_e32 v55, 16, v7
; SI-NEXT:    v_lshrrev_b32_e32 v53, 16, v8
; SI-NEXT:    v_lshrrev_b32_e32 v51, 16, v9
; SI-NEXT:    v_lshrrev_b32_e32 v49, 16, v10
; SI-NEXT:    v_lshrrev_b32_e32 v39, 16, v11
; SI-NEXT:    v_lshrrev_b32_e32 v36, 16, v12
; SI-NEXT:    v_lshrrev_b32_e32 v34, 16, v13
; SI-NEXT:    v_lshrrev_b32_e32 v32, 16, v14
; SI-NEXT:    v_lshrrev_b32_e32 v30, 16, v15
; SI-NEXT:    v_lshrrev_b32_e32 v28, 16, v16
; SI-NEXT:    v_lshrrev_b32_e32 v26, 16, v17
; SI-NEXT:    v_lshrrev_b32_e32 v24, 16, v18
; SI-NEXT:    v_lshrrev_b32_e32 v22, 16, v19
; SI-NEXT:    v_lshrrev_b32_e32 v21, 16, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v23, v20
; SI-NEXT:    v_cvt_f32_f16_e32 v25, v19
; SI-NEXT:    v_cvt_f32_f16_e32 v27, v18
; SI-NEXT:    v_cvt_f32_f16_e32 v29, v17
; SI-NEXT:    v_cvt_f32_f16_e32 v31, v16
; SI-NEXT:    v_cvt_f32_f16_e32 v33, v15
; SI-NEXT:    v_cvt_f32_f16_e32 v35, v14
; SI-NEXT:    v_cvt_f32_f16_e32 v37, v13
; SI-NEXT:    v_cvt_f32_f16_e32 v38, v12
; SI-NEXT:    v_cvt_f32_f16_e32 v48, v11
; SI-NEXT:    v_cvt_f32_f16_e32 v50, v10
; SI-NEXT:    v_cvt_f32_f16_e32 v52, v9
; SI-NEXT:    v_cvt_f32_f16_e32 v54, v8
; SI-NEXT:    v_cvt_f32_f16_e32 v40, v7
; SI-NEXT:    v_cvt_f32_f16_e32 v42, v6
; SI-NEXT:    v_cvt_f32_f16_e32 v44, v5
; SI-NEXT:    v_cvt_f32_f16_e32 v45, v4
; SI-NEXT:    v_cvt_f32_f16_e32 v47, v3
; SI-NEXT:    v_cvt_f32_f16_e32 v57, v2
; SI-NEXT:    v_cvt_f32_f16_e32 v59, v1
; SI-NEXT:    v_cvt_f32_f16_e32 v21, v21
; SI-NEXT:    v_cvt_f32_f16_e32 v22, v22
; SI-NEXT:    v_cvt_f32_f16_e32 v24, v24
; SI-NEXT:    v_cvt_f32_f16_e32 v26, v26
; SI-NEXT:    v_cvt_f32_f16_e32 v28, v28
; SI-NEXT:    v_cvt_f32_f16_e32 v30, v30
; SI-NEXT:    v_cvt_f32_f16_e32 v32, v32
; SI-NEXT:    v_cvt_f32_f16_e32 v34, v34
; SI-NEXT:    v_cvt_f32_f16_e32 v36, v36
; SI-NEXT:    v_cvt_f32_f16_e32 v39, v39
; SI-NEXT:    v_cvt_f32_f16_e32 v49, v49
; SI-NEXT:    v_cvt_f32_f16_e32 v51, v51
; SI-NEXT:    v_cvt_f32_f16_e32 v53, v53
; SI-NEXT:    v_cvt_f32_f16_e32 v55, v55
; SI-NEXT:    v_cvt_f32_f16_e32 v41, v41
; SI-NEXT:    v_cvt_f32_f16_e32 v43, v43
; SI-NEXT:    v_cvt_f32_f16_e32 v46, v46
; SI-NEXT:    v_cvt_f32_f16_e32 v56, v56
; SI-NEXT:    v_cvt_f32_f16_e32 v58, v58
; SI-NEXT:    v_cvt_f32_f16_e32 v60, v60
; SI-NEXT:  .LBB44_4: ; %end
; SI-NEXT:    s_or_b64 exec, exec, s[4:5]
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v60
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v59
; SI-NEXT:    v_cvt_f16_f32_e32 v3, v58
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v57
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v1, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v2, v4, v2
; SI-NEXT:    buffer_store_dword v2, v1, s[0:3], 0 offen
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v56
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v47
; SI-NEXT:    v_add_i32_e32 v3, vcc, 8, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v46
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v45
; SI-NEXT:    v_add_i32_e32 v3, vcc, 12, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v43
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v44
; SI-NEXT:    v_add_i32_e32 v3, vcc, 16, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v41
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v42
; SI-NEXT:    v_add_i32_e32 v3, vcc, 20, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v55
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v40
; SI-NEXT:    v_add_i32_e32 v3, vcc, 24, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v53
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v54
; SI-NEXT:    v_add_i32_e32 v3, vcc, 28, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v51
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v52
; SI-NEXT:    v_add_i32_e32 v3, vcc, 32, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v49
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v50
; SI-NEXT:    v_add_i32_e32 v3, vcc, 36, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v39
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v48
; SI-NEXT:    v_add_i32_e32 v3, vcc, 40, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v38
; SI-NEXT:    v_add_i32_e32 v3, vcc, 44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v34
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v37
; SI-NEXT:    v_add_i32_e32 v3, vcc, 48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v32
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v35
; SI-NEXT:    v_add_i32_e32 v3, vcc, 52, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v30
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v33
; SI-NEXT:    v_add_i32_e32 v3, vcc, 56, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v31
; SI-NEXT:    v_add_i32_e32 v3, vcc, 60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v29
; SI-NEXT:    v_add_i32_e32 v3, vcc, 64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v27
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v25
; SI-NEXT:    v_add_i32_e32 v3, vcc, 0x48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v3, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v21
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v23
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x4c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    buffer_load_dword v60, off, s[0:3], s32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v59, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v58, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v57, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v56, off, s[0:3], s32 offset:16 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v47, off, s[0:3], s32 offset:20 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v46, off, s[0:3], s32 offset:24 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v45, off, s[0:3], s32 offset:28 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v44, off, s[0:3], s32 offset:32 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v43, off, s[0:3], s32 offset:36 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:40 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:44 ; 4-byte Folded Reload
; SI-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:48 ; 4-byte Folded Reload
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
;
; VI-LABEL: bitcast_v10i64_to_v40f16:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; VI-NEXT:    ; implicit-def: $vgpr39
; VI-NEXT:    ; implicit-def: $vgpr38
; VI-NEXT:    ; implicit-def: $vgpr37
; VI-NEXT:    ; implicit-def: $vgpr36
; VI-NEXT:    ; implicit-def: $vgpr35
; VI-NEXT:    ; implicit-def: $vgpr34
; VI-NEXT:    ; implicit-def: $vgpr33
; VI-NEXT:    ; implicit-def: $vgpr32
; VI-NEXT:    ; implicit-def: $vgpr31
; VI-NEXT:    ; implicit-def: $vgpr30
; VI-NEXT:    ; implicit-def: $vgpr29
; VI-NEXT:    ; implicit-def: $vgpr28
; VI-NEXT:    ; implicit-def: $vgpr27
; VI-NEXT:    ; implicit-def: $vgpr26
; VI-NEXT:    ; implicit-def: $vgpr25
; VI-NEXT:    ; implicit-def: $vgpr24
; VI-NEXT:    ; implicit-def: $vgpr23
; VI-NEXT:    ; implicit-def: $vgpr22
; VI-NEXT:    ; implicit-def: $vgpr21
; VI-NEXT:    ; implicit-def: $vgpr20
; VI-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; VI-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB44_2
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; VI-NEXT:  .LBB44_2: ; %Flow
; VI-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; VI-NEXT:    s_cbranch_execz .LBB44_4
; VI-NEXT:  ; %bb.3: ; %cmp.true
; VI-NEXT:    v_add_u32_e32 v18, vcc, 3, v18
; VI-NEXT:    v_addc_u32_e32 v19, vcc, 0, v19, vcc
; VI-NEXT:    v_add_u32_e32 v16, vcc, 3, v16
; VI-NEXT:    v_addc_u32_e32 v17, vcc, 0, v17, vcc
; VI-NEXT:    v_add_u32_e32 v14, vcc, 3, v14
; VI-NEXT:    v_addc_u32_e32 v15, vcc, 0, v15, vcc
; VI-NEXT:    v_add_u32_e32 v12, vcc, 3, v12
; VI-NEXT:    v_addc_u32_e32 v13, vcc, 0, v13, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 3, v10
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v11, vcc
; VI-NEXT:    v_add_u32_e32 v8, vcc, 3, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v6, vcc, 3, v6
; VI-NEXT:    v_addc_u32_e32 v7, vcc, 0, v7, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 3, v4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_add_u32_e32 v2, vcc, 3, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 3, v0
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; VI-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; VI-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; VI-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; VI-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; VI-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; VI-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; VI-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; VI-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; VI-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; VI-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; VI-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; VI-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; VI-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; VI-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; VI-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; VI-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; VI-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; VI-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; VI-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; VI-NEXT:  .LBB44_4: ; %end
; VI-NEXT:    s_or_b64 exec, exec, s[4:5]
; VI-NEXT:    v_lshlrev_b32_e32 v39, 16, v39
; VI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; VI-NEXT:    v_lshlrev_b32_e32 v37, 16, v37
; VI-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; VI-NEXT:    v_lshlrev_b32_e32 v35, 16, v35
; VI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; VI-NEXT:    v_lshlrev_b32_e32 v33, 16, v33
; VI-NEXT:    v_lshlrev_b32_e32 v32, 16, v32
; VI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; VI-NEXT:    v_lshlrev_b32_e32 v30, 16, v30
; VI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; VI-NEXT:    v_lshlrev_b32_e32 v28, 16, v28
; VI-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; VI-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; VI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; VI-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; VI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; VI-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; VI-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; VI-NEXT:    v_lshlrev_b32_e32 v20, 16, v20
; VI-NEXT:    v_or_b32_sdwa v0, v0, v39 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v1, v1, v38 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v2, v2, v37 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v3, v3, v36 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v35 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v5, v5, v34 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v6, v6, v33 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v7, v7, v32 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v8, v8, v31 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v9, v9, v30 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v10, v10, v29 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v11, v11, v28 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v12, v12, v27 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v13, v13, v26 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v14, v14, v25 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v15, v15, v24 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v16, v16, v23 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v17, v17, v22 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v18, v18, v21 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v19, v19, v20 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_setpc_b64 s[30:31]
;
; GFX9-LABEL: bitcast_v10i64_to_v40f16:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v20
; GFX9-NEXT:    ; implicit-def: $vgpr39
; GFX9-NEXT:    ; implicit-def: $vgpr38
; GFX9-NEXT:    ; implicit-def: $vgpr37
; GFX9-NEXT:    ; implicit-def: $vgpr36
; GFX9-NEXT:    ; implicit-def: $vgpr35
; GFX9-NEXT:    ; implicit-def: $vgpr34
; GFX9-NEXT:    ; implicit-def: $vgpr33
; GFX9-NEXT:    ; implicit-def: $vgpr32
; GFX9-NEXT:    ; implicit-def: $vgpr31
; GFX9-NEXT:    ; implicit-def: $vgpr30
; GFX9-NEXT:    ; implicit-def: $vgpr29
; GFX9-NEXT:    ; implicit-def: $vgpr28
; GFX9-NEXT:    ; implicit-def: $vgpr27
; GFX9-NEXT:    ; implicit-def: $vgpr26
; GFX9-NEXT:    ; implicit-def: $vgpr25
; GFX9-NEXT:    ; implicit-def: $vgpr24
; GFX9-NEXT:    ; implicit-def: $vgpr23
; GFX9-NEXT:    ; implicit-def: $vgpr22
; GFX9-NEXT:    ; implicit-def: $vgpr21
; GFX9-NEXT:    ; implicit-def: $vgpr20
; GFX9-NEXT:    s_and_saveexec_b64 s[4:5], vcc
; GFX9-NEXT:    s_xor_b64 s[4:5], exec, s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB44_2
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX9-NEXT:  .LBB44_2: ; %Flow
; GFX9-NEXT:    s_andn2_saveexec_b64 s[4:5], s[4:5]
; GFX9-NEXT:    s_cbranch_execz .LBB44_4
; GFX9-NEXT:  ; %bb.3: ; %cmp.true
; GFX9-NEXT:    v_add_co_u32_e32 v18, vcc, 3, v18
; GFX9-NEXT:    v_addc_co_u32_e32 v19, vcc, 0, v19, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v16, vcc, 3, v16
; GFX9-NEXT:    v_addc_co_u32_e32 v17, vcc, 0, v17, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v14, vcc, 3, v14
; GFX9-NEXT:    v_addc_co_u32_e32 v15, vcc, 0, v15, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v12, vcc, 3, v12
; GFX9-NEXT:    v_addc_co_u32_e32 v13, vcc, 0, v13, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v10, vcc, 3, v10
; GFX9-NEXT:    v_addc_co_u32_e32 v11, vcc, 0, v11, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v8, vcc, 3, v8
; GFX9-NEXT:    v_addc_co_u32_e32 v9, vcc, 0, v9, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v6, vcc, 3, v6
; GFX9-NEXT:    v_addc_co_u32_e32 v7, vcc, 0, v7, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v4, vcc, 3, v4
; GFX9-NEXT:    v_addc_co_u32_e32 v5, vcc, 0, v5, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v2, vcc, 3, v2
; GFX9-NEXT:    v_addc_co_u32_e32 v3, vcc, 0, v3, vcc
; GFX9-NEXT:    v_add_co_u32_e32 v0, vcc, 3, v0
; GFX9-NEXT:    v_addc_co_u32_e32 v1, vcc, 0, v1, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX9-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX9-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX9-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX9-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX9-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX9-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX9-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX9-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX9-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX9-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX9-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX9-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX9-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX9-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX9-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX9-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX9-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX9-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX9-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX9-NEXT:  .LBB44_4: ; %end
; GFX9-NEXT:    s_or_b64 exec, exec, s[4:5]
; GFX9-NEXT:    s_mov_b32 s4, 0x5040100
; GFX9-NEXT:    v_perm_b32 v0, v39, v0, s4
; GFX9-NEXT:    v_perm_b32 v1, v38, v1, s4
; GFX9-NEXT:    v_perm_b32 v2, v37, v2, s4
; GFX9-NEXT:    v_perm_b32 v3, v36, v3, s4
; GFX9-NEXT:    v_perm_b32 v4, v35, v4, s4
; GFX9-NEXT:    v_perm_b32 v5, v34, v5, s4
; GFX9-NEXT:    v_perm_b32 v6, v33, v6, s4
; GFX9-NEXT:    v_perm_b32 v7, v32, v7, s4
; GFX9-NEXT:    v_perm_b32 v8, v31, v8, s4
; GFX9-NEXT:    v_perm_b32 v9, v30, v9, s4
; GFX9-NEXT:    v_perm_b32 v10, v29, v10, s4
; GFX9-NEXT:    v_perm_b32 v11, v28, v11, s4
; GFX9-NEXT:    v_perm_b32 v12, v27, v12, s4
; GFX9-NEXT:    v_perm_b32 v13, v26, v13, s4
; GFX9-NEXT:    v_perm_b32 v14, v25, v14, s4
; GFX9-NEXT:    v_perm_b32 v15, v24, v15, s4
; GFX9-NEXT:    v_perm_b32 v16, v23, v16, s4
; GFX9-NEXT:    v_perm_b32 v17, v22, v17, s4
; GFX9-NEXT:    v_perm_b32 v18, v21, v18, s4
; GFX9-NEXT:    v_perm_b32 v19, v20, v19, s4
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: bitcast_v10i64_to_v40f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    s_mov_b32 s0, exec_lo
; GFX11-TRUE16-NEXT:    v_cmpx_ne_u32_e32 0, v20
; GFX11-TRUE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-TRUE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-TRUE16-NEXT:    s_cbranch_execz .LBB44_2
; GFX11-TRUE16-NEXT:  ; %bb.1: ; %cmp.true
; GFX11-TRUE16-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-TRUE16-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-TRUE16-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-TRUE16-NEXT:  .LBB44_2: ; %end
; GFX11-TRUE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: bitcast_v10i64_to_v40f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr39
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr38
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr37
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr36
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr35
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr34
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr33
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr32
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr31
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr30
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr29
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr28
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr27
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr26
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr25
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr24
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr23
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr22
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr21
; GFX11-FAKE16-NEXT:    ; implicit-def: $vgpr20
; GFX11-FAKE16-NEXT:    s_and_saveexec_b32 s0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-FAKE16-NEXT:    s_xor_b32 s0, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB44_2
; GFX11-FAKE16-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX11-FAKE16-NEXT:  .LBB44_2: ; %Flow
; GFX11-FAKE16-NEXT:    s_and_not1_saveexec_b32 s0, s0
; GFX11-FAKE16-NEXT:    s_cbranch_execz .LBB44_4
; GFX11-FAKE16-NEXT:  ; %bb.3: ; %cmp.true
; GFX11-FAKE16-NEXT:    v_add_co_u32 v18, vcc_lo, v18, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v19, null, 0, v19, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v16, vcc_lo, v16, 3
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v17, null, 0, v17, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v14, vcc_lo, v14, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v15, null, 0, v15, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v12, vcc_lo, v12, 3
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v13, null, 0, v13, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v10, vcc_lo, v10, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v11, null, 0, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v8, vcc_lo, v8, 3
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v9, null, 0, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v6, vcc_lo, v6, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v7, null, 0, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v4, vcc_lo, v4, 3
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v5, null, 0, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v2, vcc_lo, v2, 3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v3, null, 0, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_add_co_u32 v0, vcc_lo, v0, 3
; GFX11-FAKE16-NEXT:    v_add_co_ci_u32_e64 v1, null, 0, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v20, 16, v19
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v18
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v17
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v23, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v29, 16, v10
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v30, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v31, 16, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v32, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v37, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v38, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v0
; GFX11-FAKE16-NEXT:  .LBB44_4: ; %end
; GFX11-FAKE16-NEXT:    s_or_b32 exec_lo, exec_lo, s0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v39, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v38, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v37, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v36, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v35, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v34, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v33, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v32, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v31, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v30, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v29, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v28, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v27, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v26, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v25, v14, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v24, v15, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v16, v23, v16, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v17, v22, v17, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v18, v21, v18, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v19, v20, v19, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <10 x i64> %a, splat (i64 3)
  %a2 = bitcast <10 x i64> %a1 to <40 x half>
  br label %end

cmp.false:
  %a3 = bitcast <10 x i64> %a to <40 x half>
  br label %end

end:
  %phi = phi <40 x half> [ %a2, %cmp.true ], [ %a3, %cmp.false ]
  ret <40 x half> %phi
}

define inreg <40 x half> @bitcast_v10i64_to_v40f16_scalar(<10 x i64> inreg %a, i32 inreg %b) {
; SI-LABEL: bitcast_v10i64_to_v40f16_scalar:
; SI:       ; %bb.0:
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; SI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v7
; SI-NEXT:    v_readfirstlane_b32 s10, v1
; SI-NEXT:    v_readfirstlane_b32 s11, v2
; SI-NEXT:    v_readfirstlane_b32 s7, v3
; SI-NEXT:    v_readfirstlane_b32 s8, v4
; SI-NEXT:    v_readfirstlane_b32 s6, v5
; SI-NEXT:    s_and_b64 s[4:5], vcc, exec
; SI-NEXT:    v_readfirstlane_b32 s9, v6
; SI-NEXT:    s_cbranch_scc0 .LBB45_4
; SI-NEXT:  ; %bb.1: ; %cmp.false
; SI-NEXT:    s_lshr_b32 s4, s9, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s4
; SI-NEXT:    s_lshr_b32 s4, s6, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s4
; SI-NEXT:    s_lshr_b32 s4, s8, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s4
; SI-NEXT:    s_lshr_b32 s4, s7, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s4
; SI-NEXT:    s_lshr_b32 s4, s11, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s4
; SI-NEXT:    s_lshr_b32 s4, s10, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s4
; SI-NEXT:    s_lshr_b32 s4, s29, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s4
; SI-NEXT:    s_lshr_b32 s4, s28, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s4
; SI-NEXT:    s_lshr_b32 s4, s27, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v16, s4
; SI-NEXT:    s_lshr_b32 s4, s26, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v19, s4
; SI-NEXT:    s_lshr_b32 s4, s25, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v21, s4
; SI-NEXT:    s_lshr_b32 s4, s24, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v23, s4
; SI-NEXT:    s_lshr_b32 s4, s23, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v25, s4
; SI-NEXT:    s_lshr_b32 s4, s22, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v27, s4
; SI-NEXT:    s_lshr_b32 s4, s21, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v29, s4
; SI-NEXT:    s_lshr_b32 s4, s20, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v31, s4
; SI-NEXT:    s_lshr_b32 s4, s19, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v34, s4
; SI-NEXT:    s_lshr_b32 s4, s18, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v36, s4
; SI-NEXT:    s_lshr_b32 s4, s17, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v38, s4
; SI-NEXT:    s_lshr_b32 s4, s16, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v48, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s9
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s8
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s11
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s10
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s29
; SI-NEXT:    v_cvt_f32_f16_e32 v17, s28
; SI-NEXT:    v_cvt_f32_f16_e32 v18, s27
; SI-NEXT:    v_cvt_f32_f16_e32 v20, s26
; SI-NEXT:    v_cvt_f32_f16_e32 v22, s25
; SI-NEXT:    v_cvt_f32_f16_e32 v24, s24
; SI-NEXT:    v_cvt_f32_f16_e32 v26, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v28, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v30, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v32, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v33, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v35, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v37, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v39, s16
; SI-NEXT:    s_cbranch_execnz .LBB45_3
; SI-NEXT:  .LBB45_2: ; %cmp.true
; SI-NEXT:    s_add_u32 s4, s16, 3
; SI-NEXT:    s_addc_u32 s5, s17, 0
; SI-NEXT:    s_lshr_b32 s12, s4, 16
; SI-NEXT:    s_lshr_b32 s13, s5, 16
; SI-NEXT:    s_add_u32 s14, s18, 3
; SI-NEXT:    s_addc_u32 s15, s19, 0
; SI-NEXT:    s_lshr_b32 s16, s14, 16
; SI-NEXT:    s_lshr_b32 s17, s15, 16
; SI-NEXT:    s_add_u32 s18, s20, 3
; SI-NEXT:    s_addc_u32 s19, s21, 0
; SI-NEXT:    s_lshr_b32 s20, s18, 16
; SI-NEXT:    s_lshr_b32 s21, s19, 16
; SI-NEXT:    s_add_u32 s22, s22, 3
; SI-NEXT:    s_addc_u32 s23, s23, 0
; SI-NEXT:    s_lshr_b32 s40, s22, 16
; SI-NEXT:    s_lshr_b32 s41, s23, 16
; SI-NEXT:    s_add_u32 s24, s24, 3
; SI-NEXT:    s_addc_u32 s25, s25, 0
; SI-NEXT:    s_lshr_b32 s42, s24, 16
; SI-NEXT:    s_lshr_b32 s43, s25, 16
; SI-NEXT:    s_add_u32 s26, s26, 3
; SI-NEXT:    s_addc_u32 s27, s27, 0
; SI-NEXT:    s_lshr_b32 s44, s26, 16
; SI-NEXT:    s_lshr_b32 s45, s27, 16
; SI-NEXT:    s_add_u32 s28, s28, 3
; SI-NEXT:    s_addc_u32 s29, s29, 0
; SI-NEXT:    s_lshr_b32 s46, s28, 16
; SI-NEXT:    s_lshr_b32 s47, s29, 16
; SI-NEXT:    s_add_u32 s10, s10, 3
; SI-NEXT:    s_addc_u32 s11, s11, 0
; SI-NEXT:    s_lshr_b32 s56, s10, 16
; SI-NEXT:    s_lshr_b32 s57, s11, 16
; SI-NEXT:    s_add_u32 s7, s7, 3
; SI-NEXT:    s_addc_u32 s8, s8, 0
; SI-NEXT:    s_lshr_b32 s58, s7, 16
; SI-NEXT:    s_lshr_b32 s59, s8, 16
; SI-NEXT:    s_add_u32 s6, s6, 3
; SI-NEXT:    s_addc_u32 s9, s9, 0
; SI-NEXT:    s_lshr_b32 s60, s6, 16
; SI-NEXT:    s_lshr_b32 s61, s9, 16
; SI-NEXT:    v_cvt_f32_f16_e32 v3, s9
; SI-NEXT:    v_cvt_f32_f16_e32 v5, s6
; SI-NEXT:    v_cvt_f32_f16_e32 v7, s8
; SI-NEXT:    v_cvt_f32_f16_e32 v9, s7
; SI-NEXT:    v_cvt_f32_f16_e32 v11, s11
; SI-NEXT:    v_cvt_f32_f16_e32 v13, s10
; SI-NEXT:    v_cvt_f32_f16_e32 v15, s29
; SI-NEXT:    v_cvt_f32_f16_e32 v17, s28
; SI-NEXT:    v_cvt_f32_f16_e32 v18, s27
; SI-NEXT:    v_cvt_f32_f16_e32 v20, s26
; SI-NEXT:    v_cvt_f32_f16_e32 v22, s25
; SI-NEXT:    v_cvt_f32_f16_e32 v24, s24
; SI-NEXT:    v_cvt_f32_f16_e32 v26, s23
; SI-NEXT:    v_cvt_f32_f16_e32 v28, s22
; SI-NEXT:    v_cvt_f32_f16_e32 v30, s19
; SI-NEXT:    v_cvt_f32_f16_e32 v32, s18
; SI-NEXT:    v_cvt_f32_f16_e32 v33, s15
; SI-NEXT:    v_cvt_f32_f16_e32 v35, s14
; SI-NEXT:    v_cvt_f32_f16_e32 v37, s5
; SI-NEXT:    v_cvt_f32_f16_e32 v39, s4
; SI-NEXT:    v_cvt_f32_f16_e32 v1, s61
; SI-NEXT:    v_cvt_f32_f16_e32 v2, s60
; SI-NEXT:    v_cvt_f32_f16_e32 v4, s59
; SI-NEXT:    v_cvt_f32_f16_e32 v6, s58
; SI-NEXT:    v_cvt_f32_f16_e32 v8, s57
; SI-NEXT:    v_cvt_f32_f16_e32 v10, s56
; SI-NEXT:    v_cvt_f32_f16_e32 v12, s47
; SI-NEXT:    v_cvt_f32_f16_e32 v14, s46
; SI-NEXT:    v_cvt_f32_f16_e32 v16, s45
; SI-NEXT:    v_cvt_f32_f16_e32 v19, s44
; SI-NEXT:    v_cvt_f32_f16_e32 v21, s43
; SI-NEXT:    v_cvt_f32_f16_e32 v23, s42
; SI-NEXT:    v_cvt_f32_f16_e32 v25, s41
; SI-NEXT:    v_cvt_f32_f16_e32 v27, s40
; SI-NEXT:    v_cvt_f32_f16_e32 v29, s21
; SI-NEXT:    v_cvt_f32_f16_e32 v31, s20
; SI-NEXT:    v_cvt_f32_f16_e32 v34, s17
; SI-NEXT:    v_cvt_f32_f16_e32 v36, s16
; SI-NEXT:    v_cvt_f32_f16_e32 v38, s13
; SI-NEXT:    v_cvt_f32_f16_e32 v48, s12
; SI-NEXT:  .LBB45_3: ; %end
; SI-NEXT:    v_cvt_f16_f32_e32 v48, v48
; SI-NEXT:    v_cvt_f16_f32_e32 v39, v39
; SI-NEXT:    v_cvt_f16_f32_e32 v38, v38
; SI-NEXT:    v_cvt_f16_f32_e32 v37, v37
; SI-NEXT:    v_cvt_f16_f32_e32 v36, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v35, v35
; SI-NEXT:    v_cvt_f16_f32_e32 v34, v34
; SI-NEXT:    v_lshlrev_b32_e32 v48, 16, v48
; SI-NEXT:    v_cvt_f16_f32_e32 v33, v33
; SI-NEXT:    v_cvt_f16_f32_e32 v31, v31
; SI-NEXT:    v_or_b32_e32 v39, v39, v48
; SI-NEXT:    v_lshlrev_b32_e32 v38, 16, v38
; SI-NEXT:    v_cvt_f16_f32_e32 v32, v32
; SI-NEXT:    v_cvt_f16_f32_e32 v29, v29
; SI-NEXT:    buffer_store_dword v39, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v39, vcc, 4, v0
; SI-NEXT:    v_or_b32_e32 v37, v37, v38
; SI-NEXT:    v_lshlrev_b32_e32 v36, 16, v36
; SI-NEXT:    v_cvt_f16_f32_e32 v30, v30
; SI-NEXT:    v_cvt_f16_f32_e32 v27, v27
; SI-NEXT:    buffer_store_dword v37, v39, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v37, vcc, 8, v0
; SI-NEXT:    v_or_b32_e32 v35, v35, v36
; SI-NEXT:    v_lshlrev_b32_e32 v34, 16, v34
; SI-NEXT:    v_cvt_f16_f32_e32 v28, v28
; SI-NEXT:    v_cvt_f16_f32_e32 v25, v25
; SI-NEXT:    buffer_store_dword v35, v37, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v35, vcc, 12, v0
; SI-NEXT:    v_or_b32_e32 v33, v33, v34
; SI-NEXT:    v_lshlrev_b32_e32 v31, 16, v31
; SI-NEXT:    v_cvt_f16_f32_e32 v26, v26
; SI-NEXT:    v_cvt_f16_f32_e32 v23, v23
; SI-NEXT:    buffer_store_dword v33, v35, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v33, vcc, 16, v0
; SI-NEXT:    v_or_b32_e32 v31, v32, v31
; SI-NEXT:    v_lshlrev_b32_e32 v29, 16, v29
; SI-NEXT:    v_cvt_f16_f32_e32 v24, v24
; SI-NEXT:    v_cvt_f16_f32_e32 v21, v21
; SI-NEXT:    buffer_store_dword v31, v33, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v31, vcc, 20, v0
; SI-NEXT:    v_or_b32_e32 v29, v30, v29
; SI-NEXT:    v_lshlrev_b32_e32 v27, 16, v27
; SI-NEXT:    v_cvt_f16_f32_e32 v22, v22
; SI-NEXT:    v_cvt_f16_f32_e32 v19, v19
; SI-NEXT:    buffer_store_dword v29, v31, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v29, vcc, 24, v0
; SI-NEXT:    v_or_b32_e32 v27, v28, v27
; SI-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; SI-NEXT:    v_cvt_f16_f32_e32 v20, v20
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v16
; SI-NEXT:    buffer_store_dword v27, v29, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v27, vcc, 28, v0
; SI-NEXT:    v_or_b32_e32 v25, v26, v25
; SI-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; SI-NEXT:    v_cvt_f16_f32_e32 v18, v18
; SI-NEXT:    buffer_store_dword v25, v27, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v25, vcc, 32, v0
; SI-NEXT:    v_or_b32_e32 v23, v24, v23
; SI-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; SI-NEXT:    buffer_store_dword v23, v25, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v23, vcc, 36, v0
; SI-NEXT:    v_or_b32_e32 v21, v22, v21
; SI-NEXT:    v_lshlrev_b32_e32 v19, 16, v19
; SI-NEXT:    buffer_store_dword v21, v23, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v21, vcc, 40, v0
; SI-NEXT:    v_or_b32_e32 v19, v20, v19
; SI-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; SI-NEXT:    buffer_store_dword v19, v21, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_add_i32_e32 v19, vcc, 44, v0
; SI-NEXT:    v_or_b32_e32 v16, v18, v16
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; SI-NEXT:    buffer_store_dword v16, v19, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v16, v17
; SI-NEXT:    v_add_i32_e32 v17, vcc, 48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; SI-NEXT:    v_or_b32_e32 v14, v16, v14
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; SI-NEXT:    buffer_store_dword v14, v17, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v14, v15
; SI-NEXT:    v_add_i32_e32 v15, vcc, 52, v0
; SI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; SI-NEXT:    v_or_b32_e32 v12, v14, v12
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; SI-NEXT:    buffer_store_dword v12, v15, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v12, v13
; SI-NEXT:    v_add_i32_e32 v13, vcc, 56, v0
; SI-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; SI-NEXT:    v_or_b32_e32 v10, v12, v10
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; SI-NEXT:    buffer_store_dword v10, v13, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v10, v11
; SI-NEXT:    v_add_i32_e32 v11, vcc, 60, v0
; SI-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; SI-NEXT:    v_or_b32_e32 v8, v10, v8
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v6
; SI-NEXT:    buffer_store_dword v8, v11, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v8, v9
; SI-NEXT:    v_add_i32_e32 v9, vcc, 64, v0
; SI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; SI-NEXT:    v_or_b32_e32 v6, v8, v6
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v4
; SI-NEXT:    buffer_store_dword v6, v9, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v6, v7
; SI-NEXT:    v_add_i32_e32 v7, vcc, 0x44, v0
; SI-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; SI-NEXT:    v_or_b32_e32 v4, v6, v4
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; SI-NEXT:    buffer_store_dword v4, v7, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v4, v5
; SI-NEXT:    v_add_i32_e32 v5, vcc, 0x48, v0
; SI-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; SI-NEXT:    v_or_b32_e32 v2, v4, v2
; SI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; SI-NEXT:    buffer_store_dword v2, v5, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt expcnt(0)
; SI-NEXT:    v_cvt_f16_f32_e32 v2, v3
; SI-NEXT:    v_add_i32_e32 v0, vcc, 0x4c, v0
; SI-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; SI-NEXT:    v_or_b32_e32 v1, v2, v1
; SI-NEXT:    buffer_store_dword v1, v0, s[0:3], 0 offen
; SI-NEXT:    s_waitcnt vmcnt(0) expcnt(0)
; SI-NEXT:    s_setpc_b64 s[30:31]
; SI-NEXT:  .LBB45_4:
; SI-NEXT:    ; implicit-def: $vgpr39
; SI-NEXT:    ; implicit-def: $vgpr48
; SI-NEXT:    ; implicit-def: $vgpr37
; SI-NEXT:    ; implicit-def: $vgpr38
; SI-NEXT:    ; implicit-def: $vgpr35
; SI-NEXT:    ; implicit-def: $vgpr36
; SI-NEXT:    ; implicit-def: $vgpr33
; SI-NEXT:    ; implicit-def: $vgpr34
; SI-NEXT:    ; implicit-def: $vgpr32
; SI-NEXT:    ; implicit-def: $vgpr31
; SI-NEXT:    ; implicit-def: $vgpr30
; SI-NEXT:    ; implicit-def: $vgpr29
; SI-NEXT:    ; implicit-def: $vgpr28
; SI-NEXT:    ; implicit-def: $vgpr27
; SI-NEXT:    ; implicit-def: $vgpr26
; SI-NEXT:    ; implicit-def: $vgpr25
; SI-NEXT:    ; implicit-def: $vgpr24
; SI-NEXT:    ; implicit-def: $vgpr23
; SI-NEXT:    ; implicit-def: $vgpr22
; SI-NEXT:    ; implicit-def: $vgpr21
; SI-NEXT:    ; implicit-def: $vgpr20
; SI-NEXT:    ; implicit-def: $vgpr19
; SI-NEXT:    ; implicit-def: $vgpr18
; SI-NEXT:    ; implicit-def: $vgpr16
; SI-NEXT:    ; implicit-def: $vgpr17
; SI-NEXT:    ; implicit-def: $vgpr14
; SI-NEXT:    ; implicit-def: $vgpr15
; SI-NEXT:    ; implicit-def: $vgpr12
; SI-NEXT:    ; implicit-def: $vgpr13
; SI-NEXT:    ; implicit-def: $vgpr10
; SI-NEXT:    ; implicit-def: $vgpr11
; SI-NEXT:    ; implicit-def: $vgpr8
; SI-NEXT:    ; implicit-def: $vgpr9
; SI-NEXT:    ; implicit-def: $vgpr6
; SI-NEXT:    ; implicit-def: $vgpr7
; SI-NEXT:    ; implicit-def: $vgpr4
; SI-NEXT:    ; implicit-def: $vgpr5
; SI-NEXT:    ; implicit-def: $vgpr2
; SI-NEXT:    ; implicit-def: $vgpr3
; SI-NEXT:    ; implicit-def: $vgpr1
; SI-NEXT:    s_branch .LBB45_2
;
; VI-LABEL: bitcast_v10i64_to_v40f16_scalar:
; VI:       ; %bb.0:
; VI-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; VI-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; VI-NEXT:    v_readfirstlane_b32 s11, v0
; VI-NEXT:    v_readfirstlane_b32 s10, v1
; VI-NEXT:    v_readfirstlane_b32 s9, v2
; VI-NEXT:    v_readfirstlane_b32 s8, v3
; VI-NEXT:    v_readfirstlane_b32 s6, v4
; VI-NEXT:    s_and_b64 s[4:5], vcc, exec
; VI-NEXT:    v_readfirstlane_b32 s7, v5
; VI-NEXT:    s_cbranch_scc0 .LBB45_4
; VI-NEXT:  ; %bb.1: ; %cmp.false
; VI-NEXT:    s_lshr_b32 s12, s7, 16
; VI-NEXT:    s_lshr_b32 s13, s6, 16
; VI-NEXT:    s_lshr_b32 s14, s8, 16
; VI-NEXT:    s_lshr_b32 s15, s9, 16
; VI-NEXT:    s_lshr_b32 s40, s10, 16
; VI-NEXT:    s_lshr_b32 s41, s11, 16
; VI-NEXT:    s_lshr_b32 s42, s29, 16
; VI-NEXT:    s_lshr_b32 s43, s28, 16
; VI-NEXT:    s_lshr_b32 s44, s27, 16
; VI-NEXT:    s_lshr_b32 s45, s26, 16
; VI-NEXT:    s_lshr_b32 s46, s25, 16
; VI-NEXT:    s_lshr_b32 s47, s24, 16
; VI-NEXT:    s_lshr_b32 s56, s23, 16
; VI-NEXT:    s_lshr_b32 s57, s22, 16
; VI-NEXT:    s_lshr_b32 s58, s21, 16
; VI-NEXT:    s_lshr_b32 s59, s20, 16
; VI-NEXT:    s_lshr_b32 s60, s19, 16
; VI-NEXT:    s_lshr_b32 s61, s18, 16
; VI-NEXT:    s_lshr_b32 s62, s17, 16
; VI-NEXT:    s_lshr_b32 s63, s16, 16
; VI-NEXT:    s_cbranch_execnz .LBB45_3
; VI-NEXT:  .LBB45_2: ; %cmp.true
; VI-NEXT:    s_add_u32 s6, s6, 3
; VI-NEXT:    s_addc_u32 s7, s7, 0
; VI-NEXT:    s_add_u32 s9, s9, 3
; VI-NEXT:    s_addc_u32 s8, s8, 0
; VI-NEXT:    s_add_u32 s11, s11, 3
; VI-NEXT:    s_addc_u32 s10, s10, 0
; VI-NEXT:    s_add_u32 s28, s28, 3
; VI-NEXT:    s_addc_u32 s29, s29, 0
; VI-NEXT:    s_add_u32 s26, s26, 3
; VI-NEXT:    s_addc_u32 s27, s27, 0
; VI-NEXT:    s_add_u32 s24, s24, 3
; VI-NEXT:    s_addc_u32 s25, s25, 0
; VI-NEXT:    s_add_u32 s22, s22, 3
; VI-NEXT:    s_addc_u32 s23, s23, 0
; VI-NEXT:    s_add_u32 s20, s20, 3
; VI-NEXT:    s_addc_u32 s21, s21, 0
; VI-NEXT:    s_add_u32 s18, s18, 3
; VI-NEXT:    s_addc_u32 s19, s19, 0
; VI-NEXT:    s_add_u32 s16, s16, 3
; VI-NEXT:    s_addc_u32 s17, s17, 0
; VI-NEXT:    s_lshr_b32 s12, s7, 16
; VI-NEXT:    s_lshr_b32 s13, s6, 16
; VI-NEXT:    s_lshr_b32 s14, s8, 16
; VI-NEXT:    s_lshr_b32 s15, s9, 16
; VI-NEXT:    s_lshr_b32 s40, s10, 16
; VI-NEXT:    s_lshr_b32 s41, s11, 16
; VI-NEXT:    s_lshr_b32 s42, s29, 16
; VI-NEXT:    s_lshr_b32 s43, s28, 16
; VI-NEXT:    s_lshr_b32 s44, s27, 16
; VI-NEXT:    s_lshr_b32 s45, s26, 16
; VI-NEXT:    s_lshr_b32 s46, s25, 16
; VI-NEXT:    s_lshr_b32 s47, s24, 16
; VI-NEXT:    s_lshr_b32 s56, s23, 16
; VI-NEXT:    s_lshr_b32 s57, s22, 16
; VI-NEXT:    s_lshr_b32 s58, s21, 16
; VI-NEXT:    s_lshr_b32 s59, s20, 16
; VI-NEXT:    s_lshr_b32 s60, s19, 16
; VI-NEXT:    s_lshr_b32 s61, s18, 16
; VI-NEXT:    s_lshr_b32 s62, s17, 16
; VI-NEXT:    s_lshr_b32 s63, s16, 16
; VI-NEXT:  .LBB45_3: ; %end
; VI-NEXT:    s_and_b32 s4, 0xffff, s16
; VI-NEXT:    s_lshl_b32 s5, s63, 16
; VI-NEXT:    s_or_b32 s4, s4, s5
; VI-NEXT:    s_and_b32 s5, 0xffff, s17
; VI-NEXT:    s_lshl_b32 s16, s62, 16
; VI-NEXT:    s_or_b32 s5, s5, s16
; VI-NEXT:    s_and_b32 s16, 0xffff, s18
; VI-NEXT:    s_lshl_b32 s17, s61, 16
; VI-NEXT:    s_or_b32 s16, s16, s17
; VI-NEXT:    s_and_b32 s17, 0xffff, s19
; VI-NEXT:    s_lshl_b32 s18, s60, 16
; VI-NEXT:    s_or_b32 s17, s17, s18
; VI-NEXT:    s_and_b32 s18, 0xffff, s20
; VI-NEXT:    s_lshl_b32 s19, s59, 16
; VI-NEXT:    s_or_b32 s18, s18, s19
; VI-NEXT:    s_and_b32 s19, 0xffff, s21
; VI-NEXT:    s_lshl_b32 s20, s58, 16
; VI-NEXT:    s_or_b32 s19, s19, s20
; VI-NEXT:    s_and_b32 s20, 0xffff, s22
; VI-NEXT:    s_lshl_b32 s21, s57, 16
; VI-NEXT:    s_or_b32 s20, s20, s21
; VI-NEXT:    s_and_b32 s21, 0xffff, s23
; VI-NEXT:    s_lshl_b32 s22, s56, 16
; VI-NEXT:    s_or_b32 s21, s21, s22
; VI-NEXT:    s_and_b32 s22, 0xffff, s24
; VI-NEXT:    s_lshl_b32 s23, s47, 16
; VI-NEXT:    s_or_b32 s22, s22, s23
; VI-NEXT:    s_and_b32 s23, 0xffff, s25
; VI-NEXT:    s_lshl_b32 s24, s46, 16
; VI-NEXT:    s_or_b32 s23, s23, s24
; VI-NEXT:    s_and_b32 s24, 0xffff, s26
; VI-NEXT:    s_lshl_b32 s25, s45, 16
; VI-NEXT:    s_or_b32 s24, s24, s25
; VI-NEXT:    s_and_b32 s25, 0xffff, s27
; VI-NEXT:    s_lshl_b32 s26, s44, 16
; VI-NEXT:    s_or_b32 s25, s25, s26
; VI-NEXT:    s_and_b32 s26, 0xffff, s28
; VI-NEXT:    s_lshl_b32 s27, s43, 16
; VI-NEXT:    s_or_b32 s26, s26, s27
; VI-NEXT:    s_and_b32 s27, 0xffff, s29
; VI-NEXT:    s_lshl_b32 s28, s42, 16
; VI-NEXT:    s_or_b32 s27, s27, s28
; VI-NEXT:    s_and_b32 s11, 0xffff, s11
; VI-NEXT:    s_lshl_b32 s28, s41, 16
; VI-NEXT:    s_or_b32 s11, s11, s28
; VI-NEXT:    s_and_b32 s10, 0xffff, s10
; VI-NEXT:    s_lshl_b32 s28, s40, 16
; VI-NEXT:    s_and_b32 s9, 0xffff, s9
; VI-NEXT:    s_lshl_b32 s15, s15, 16
; VI-NEXT:    s_and_b32 s8, 0xffff, s8
; VI-NEXT:    s_lshl_b32 s14, s14, 16
; VI-NEXT:    s_and_b32 s6, 0xffff, s6
; VI-NEXT:    s_lshl_b32 s13, s13, 16
; VI-NEXT:    s_and_b32 s7, 0xffff, s7
; VI-NEXT:    s_lshl_b32 s12, s12, 16
; VI-NEXT:    s_or_b32 s10, s10, s28
; VI-NEXT:    s_or_b32 s9, s9, s15
; VI-NEXT:    s_or_b32 s8, s8, s14
; VI-NEXT:    s_or_b32 s6, s6, s13
; VI-NEXT:    s_or_b32 s7, s7, s12
; VI-NEXT:    v_mov_b32_e32 v0, s4
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_mov_b32_e32 v2, s16
; VI-NEXT:    v_mov_b32_e32 v3, s17
; VI-NEXT:    v_mov_b32_e32 v4, s18
; VI-NEXT:    v_mov_b32_e32 v5, s19
; VI-NEXT:    v_mov_b32_e32 v6, s20
; VI-NEXT:    v_mov_b32_e32 v7, s21
; VI-NEXT:    v_mov_b32_e32 v8, s22
; VI-NEXT:    v_mov_b32_e32 v9, s23
; VI-NEXT:    v_mov_b32_e32 v10, s24
; VI-NEXT:    v_mov_b32_e32 v11, s25
; VI-NEXT:    v_mov_b32_e32 v12, s26
; VI-NEXT:    v_mov_b32_e32 v13, s27
; VI-NEXT:    v_mov_b32_e32 v14, s11
; VI-NEXT:    v_mov_b32_e32 v15, s10
; VI-NEXT:    v_mov_b32_e32 v16, s9
; VI-NEXT:    v_mov_b32_e32 v17, s8
; VI-NEXT:    v_mov_b32_e32 v18, s6
; VI-NEXT:    v_mov_b32_e32 v19, s7
; VI-NEXT:    s_setpc_b64 s[30:31]
; VI-NEXT:  .LBB45_4:
; VI-NEXT:    ; implicit-def: $sgpr63
; VI-NEXT:    ; implicit-def: $sgpr62
; VI-NEXT:    ; implicit-def: $sgpr61
; VI-NEXT:    ; implicit-def: $sgpr60
; VI-NEXT:    ; implicit-def: $sgpr59
; VI-NEXT:    ; implicit-def: $sgpr58
; VI-NEXT:    ; implicit-def: $sgpr57
; VI-NEXT:    ; implicit-def: $sgpr56
; VI-NEXT:    ; implicit-def: $sgpr47
; VI-NEXT:    ; implicit-def: $sgpr46
; VI-NEXT:    ; implicit-def: $sgpr45
; VI-NEXT:    ; implicit-def: $sgpr44
; VI-NEXT:    ; implicit-def: $sgpr43
; VI-NEXT:    ; implicit-def: $sgpr42
; VI-NEXT:    ; implicit-def: $sgpr41
; VI-NEXT:    ; implicit-def: $sgpr40
; VI-NEXT:    ; implicit-def: $sgpr15
; VI-NEXT:    ; implicit-def: $sgpr14
; VI-NEXT:    ; implicit-def: $sgpr13
; VI-NEXT:    ; implicit-def: $sgpr12
; VI-NEXT:    s_branch .LBB45_2
;
; GFX9-LABEL: bitcast_v10i64_to_v40f16_scalar:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_cmp_ne_u32_e32 vcc, 0, v6
; GFX9-NEXT:    v_readfirstlane_b32 s6, v0
; GFX9-NEXT:    v_readfirstlane_b32 s7, v1
; GFX9-NEXT:    v_readfirstlane_b32 s8, v2
; GFX9-NEXT:    v_readfirstlane_b32 s9, v3
; GFX9-NEXT:    v_readfirstlane_b32 s10, v4
; GFX9-NEXT:    s_and_b64 s[4:5], vcc, exec
; GFX9-NEXT:    v_readfirstlane_b32 s11, v5
; GFX9-NEXT:    s_cbranch_scc0 .LBB45_4
; GFX9-NEXT:  ; %bb.1: ; %cmp.false
; GFX9-NEXT:    s_lshr_b32 s12, s11, 16
; GFX9-NEXT:    s_lshr_b32 s13, s10, 16
; GFX9-NEXT:    s_lshr_b32 s14, s9, 16
; GFX9-NEXT:    s_lshr_b32 s15, s8, 16
; GFX9-NEXT:    s_lshr_b32 s40, s7, 16
; GFX9-NEXT:    s_lshr_b32 s41, s6, 16
; GFX9-NEXT:    s_lshr_b32 s42, s29, 16
; GFX9-NEXT:    s_lshr_b32 s43, s28, 16
; GFX9-NEXT:    s_lshr_b32 s44, s27, 16
; GFX9-NEXT:    s_lshr_b32 s45, s26, 16
; GFX9-NEXT:    s_lshr_b32 s46, s25, 16
; GFX9-NEXT:    s_lshr_b32 s47, s24, 16
; GFX9-NEXT:    s_lshr_b32 s56, s23, 16
; GFX9-NEXT:    s_lshr_b32 s57, s22, 16
; GFX9-NEXT:    s_lshr_b32 s58, s21, 16
; GFX9-NEXT:    s_lshr_b32 s59, s20, 16
; GFX9-NEXT:    s_lshr_b32 s60, s19, 16
; GFX9-NEXT:    s_lshr_b32 s61, s18, 16
; GFX9-NEXT:    s_lshr_b32 s62, s17, 16
; GFX9-NEXT:    s_lshr_b32 s63, s16, 16
; GFX9-NEXT:    s_cbranch_execnz .LBB45_3
; GFX9-NEXT:  .LBB45_2: ; %cmp.true
; GFX9-NEXT:    s_add_u32 s10, s10, 3
; GFX9-NEXT:    s_addc_u32 s11, s11, 0
; GFX9-NEXT:    s_add_u32 s8, s8, 3
; GFX9-NEXT:    s_addc_u32 s9, s9, 0
; GFX9-NEXT:    s_add_u32 s6, s6, 3
; GFX9-NEXT:    s_addc_u32 s7, s7, 0
; GFX9-NEXT:    s_add_u32 s28, s28, 3
; GFX9-NEXT:    s_addc_u32 s29, s29, 0
; GFX9-NEXT:    s_add_u32 s26, s26, 3
; GFX9-NEXT:    s_addc_u32 s27, s27, 0
; GFX9-NEXT:    s_add_u32 s24, s24, 3
; GFX9-NEXT:    s_addc_u32 s25, s25, 0
; GFX9-NEXT:    s_add_u32 s22, s22, 3
; GFX9-NEXT:    s_addc_u32 s23, s23, 0
; GFX9-NEXT:    s_add_u32 s20, s20, 3
; GFX9-NEXT:    s_addc_u32 s21, s21, 0
; GFX9-NEXT:    s_add_u32 s18, s18, 3
; GFX9-NEXT:    s_addc_u32 s19, s19, 0
; GFX9-NEXT:    s_add_u32 s16, s16, 3
; GFX9-NEXT:    s_addc_u32 s17, s17, 0
; GFX9-NEXT:    s_lshr_b32 s12, s11, 16
; GFX9-NEXT:    s_lshr_b32 s13, s10, 16
; GFX9-NEXT:    s_lshr_b32 s14, s9, 16
; GFX9-NEXT:    s_lshr_b32 s15, s8, 16
; GFX9-NEXT:    s_lshr_b32 s40, s7, 16
; GFX9-NEXT:    s_lshr_b32 s41, s6, 16
; GFX9-NEXT:    s_lshr_b32 s42, s29, 16
; GFX9-NEXT:    s_lshr_b32 s43, s28, 16
; GFX9-NEXT:    s_lshr_b32 s44, s27, 16
; GFX9-NEXT:    s_lshr_b32 s45, s26, 16
; GFX9-NEXT:    s_lshr_b32 s46, s25, 16
; GFX9-NEXT:    s_lshr_b32 s47, s24, 16
; GFX9-NEXT:    s_lshr_b32 s56, s23, 16
; GFX9-NEXT:    s_lshr_b32 s57, s22, 16
; GFX9-NEXT:    s_lshr_b32 s58, s21, 16
; GFX9-NEXT:    s_lshr_b32 s59, s20, 16
; GFX9-NEXT:    s_lshr_b32 s60, s19, 16
; GFX9-NEXT:    s_lshr_b32 s61, s18, 16
; GFX9-NEXT:    s_lshr_b32 s62, s17, 16
; GFX9-NEXT:    s_lshr_b32 s63, s16, 16
; GFX9-NEXT:  .LBB45_3: ; %end
; GFX9-NEXT:    s_pack_ll_b32_b16 s4, s16, s63
; GFX9-NEXT:    s_pack_ll_b32_b16 s5, s17, s62
; GFX9-NEXT:    s_pack_ll_b32_b16 s16, s18, s61
; GFX9-NEXT:    s_pack_ll_b32_b16 s17, s19, s60
; GFX9-NEXT:    s_pack_ll_b32_b16 s18, s20, s59
; GFX9-NEXT:    s_pack_ll_b32_b16 s19, s21, s58
; GFX9-NEXT:    s_pack_ll_b32_b16 s20, s22, s57
; GFX9-NEXT:    s_pack_ll_b32_b16 s21, s23, s56
; GFX9-NEXT:    s_pack_ll_b32_b16 s22, s24, s47
; GFX9-NEXT:    s_pack_ll_b32_b16 s23, s25, s46
; GFX9-NEXT:    s_pack_ll_b32_b16 s24, s26, s45
; GFX9-NEXT:    s_pack_ll_b32_b16 s25, s27, s44
; GFX9-NEXT:    s_pack_ll_b32_b16 s26, s28, s43
; GFX9-NEXT:    s_pack_ll_b32_b16 s27, s29, s42
; GFX9-NEXT:    s_pack_ll_b32_b16 s6, s6, s41
; GFX9-NEXT:    s_pack_ll_b32_b16 s7, s7, s40
; GFX9-NEXT:    s_pack_ll_b32_b16 s8, s8, s15
; GFX9-NEXT:    s_pack_ll_b32_b16 s9, s9, s14
; GFX9-NEXT:    s_pack_ll_b32_b16 s10, s10, s13
; GFX9-NEXT:    s_pack_ll_b32_b16 s11, s11, s12
; GFX9-NEXT:    v_mov_b32_e32 v0, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s5
; GFX9-NEXT:    v_mov_b32_e32 v2, s16
; GFX9-NEXT:    v_mov_b32_e32 v3, s17
; GFX9-NEXT:    v_mov_b32_e32 v4, s18
; GFX9-NEXT:    v_mov_b32_e32 v5, s19
; GFX9-NEXT:    v_mov_b32_e32 v6, s20
; GFX9-NEXT:    v_mov_b32_e32 v7, s21
; GFX9-NEXT:    v_mov_b32_e32 v8, s22
; GFX9-NEXT:    v_mov_b32_e32 v9, s23
; GFX9-NEXT:    v_mov_b32_e32 v10, s24
; GFX9-NEXT:    v_mov_b32_e32 v11, s25
; GFX9-NEXT:    v_mov_b32_e32 v12, s26
; GFX9-NEXT:    v_mov_b32_e32 v13, s27
; GFX9-NEXT:    v_mov_b32_e32 v14, s6
; GFX9-NEXT:    v_mov_b32_e32 v15, s7
; GFX9-NEXT:    v_mov_b32_e32 v16, s8
; GFX9-NEXT:    v_mov_b32_e32 v17, s9
; GFX9-NEXT:    v_mov_b32_e32 v18, s10
; GFX9-NEXT:    v_mov_b32_e32 v19, s11
; GFX9-NEXT:    s_setpc_b64 s[30:31]
; GFX9-NEXT:  .LBB45_4:
; GFX9-NEXT:    ; implicit-def: $sgpr63
; GFX9-NEXT:    ; implicit-def: $sgpr62
; GFX9-NEXT:    ; implicit-def: $sgpr61
; GFX9-NEXT:    ; implicit-def: $sgpr60
; GFX9-NEXT:    ; implicit-def: $sgpr59
; GFX9-NEXT:    ; implicit-def: $sgpr58
; GFX9-NEXT:    ; implicit-def: $sgpr57
; GFX9-NEXT:    ; implicit-def: $sgpr56
; GFX9-NEXT:    ; implicit-def: $sgpr47
; GFX9-NEXT:    ; implicit-def: $sgpr46
; GFX9-NEXT:    ; implicit-def: $sgpr45
; GFX9-NEXT:    ; implicit-def: $sgpr44
; GFX9-NEXT:    ; implicit-def: $sgpr43
; GFX9-NEXT:    ; implicit-def: $sgpr42
; GFX9-NEXT:    ; implicit-def: $sgpr41
; GFX9-NEXT:    ; implicit-def: $sgpr40
; GFX9-NEXT:    ; implicit-def: $sgpr15
; GFX9-NEXT:    ; implicit-def: $sgpr14
; GFX9-NEXT:    ; implicit-def: $sgpr13
; GFX9-NEXT:    ; implicit-def: $sgpr12
; GFX9-NEXT:    s_branch .LBB45_2
;
; GFX11-LABEL: bitcast_v10i64_to_v40f16_scalar:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_ne_u32_e32 vcc_lo, 0, v2
; GFX11-NEXT:    v_readfirstlane_b32 s5, v0
; GFX11-NEXT:    v_readfirstlane_b32 s4, v1
; GFX11-NEXT:    s_mov_b32 s58, 0
; GFX11-NEXT:    s_and_b32 s6, vcc_lo, exec_lo
; GFX11-NEXT:    s_cbranch_scc0 .LBB45_4
; GFX11-NEXT:  ; %bb.1: ; %cmp.false
; GFX11-NEXT:    s_lshr_b32 s6, s4, 16
; GFX11-NEXT:    s_lshr_b32 s7, s5, 16
; GFX11-NEXT:    s_lshr_b32 s8, s29, 16
; GFX11-NEXT:    s_lshr_b32 s9, s28, 16
; GFX11-NEXT:    s_lshr_b32 s10, s27, 16
; GFX11-NEXT:    s_lshr_b32 s11, s26, 16
; GFX11-NEXT:    s_lshr_b32 s12, s25, 16
; GFX11-NEXT:    s_lshr_b32 s13, s24, 16
; GFX11-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-NEXT:    s_lshr_b32 s15, s22, 16
; GFX11-NEXT:    s_lshr_b32 s40, s21, 16
; GFX11-NEXT:    s_lshr_b32 s41, s20, 16
; GFX11-NEXT:    s_lshr_b32 s42, s19, 16
; GFX11-NEXT:    s_lshr_b32 s43, s18, 16
; GFX11-NEXT:    s_lshr_b32 s44, s17, 16
; GFX11-NEXT:    s_lshr_b32 s45, s16, 16
; GFX11-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-NEXT:    s_lshr_b32 s47, s2, 16
; GFX11-NEXT:    s_lshr_b32 s56, s1, 16
; GFX11-NEXT:    s_lshr_b32 s57, s0, 16
; GFX11-NEXT:    s_and_not1_b32 vcc_lo, exec_lo, s58
; GFX11-NEXT:    s_cbranch_vccnz .LBB45_3
; GFX11-NEXT:  .LBB45_2: ; %cmp.true
; GFX11-NEXT:    s_add_u32 s5, s5, 3
; GFX11-NEXT:    s_addc_u32 s4, s4, 0
; GFX11-NEXT:    s_add_u32 s28, s28, 3
; GFX11-NEXT:    s_addc_u32 s29, s29, 0
; GFX11-NEXT:    s_add_u32 s26, s26, 3
; GFX11-NEXT:    s_addc_u32 s27, s27, 0
; GFX11-NEXT:    s_add_u32 s24, s24, 3
; GFX11-NEXT:    s_addc_u32 s25, s25, 0
; GFX11-NEXT:    s_add_u32 s22, s22, 3
; GFX11-NEXT:    s_addc_u32 s23, s23, 0
; GFX11-NEXT:    s_add_u32 s20, s20, 3
; GFX11-NEXT:    s_addc_u32 s21, s21, 0
; GFX11-NEXT:    s_add_u32 s18, s18, 3
; GFX11-NEXT:    s_addc_u32 s19, s19, 0
; GFX11-NEXT:    s_add_u32 s16, s16, 3
; GFX11-NEXT:    s_addc_u32 s17, s17, 0
; GFX11-NEXT:    s_add_u32 s2, s2, 3
; GFX11-NEXT:    s_addc_u32 s3, s3, 0
; GFX11-NEXT:    s_add_u32 s0, s0, 3
; GFX11-NEXT:    s_addc_u32 s1, s1, 0
; GFX11-NEXT:    s_lshr_b32 s6, s4, 16
; GFX11-NEXT:    s_lshr_b32 s7, s5, 16
; GFX11-NEXT:    s_lshr_b32 s8, s29, 16
; GFX11-NEXT:    s_lshr_b32 s9, s28, 16
; GFX11-NEXT:    s_lshr_b32 s10, s27, 16
; GFX11-NEXT:    s_lshr_b32 s11, s26, 16
; GFX11-NEXT:    s_lshr_b32 s12, s25, 16
; GFX11-NEXT:    s_lshr_b32 s13, s24, 16
; GFX11-NEXT:    s_lshr_b32 s14, s23, 16
; GFX11-NEXT:    s_lshr_b32 s15, s22, 16
; GFX11-NEXT:    s_lshr_b32 s40, s21, 16
; GFX11-NEXT:    s_lshr_b32 s41, s20, 16
; GFX11-NEXT:    s_lshr_b32 s42, s19, 16
; GFX11-NEXT:    s_lshr_b32 s43, s18, 16
; GFX11-NEXT:    s_lshr_b32 s44, s17, 16
; GFX11-NEXT:    s_lshr_b32 s45, s16, 16
; GFX11-NEXT:    s_lshr_b32 s46, s3, 16
; GFX11-NEXT:    s_lshr_b32 s47, s2, 16
; GFX11-NEXT:    s_lshr_b32 s56, s1, 16
; GFX11-NEXT:    s_lshr_b32 s57, s0, 16
; GFX11-NEXT:  .LBB45_3: ; %end
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_pack_ll_b32_b16 s0, s0, s57
; GFX11-NEXT:    s_pack_ll_b32_b16 s1, s1, s56
; GFX11-NEXT:    s_pack_ll_b32_b16 s2, s2, s47
; GFX11-NEXT:    s_pack_ll_b32_b16 s3, s3, s46
; GFX11-NEXT:    s_pack_ll_b32_b16 s16, s16, s45
; GFX11-NEXT:    s_pack_ll_b32_b16 s17, s17, s44
; GFX11-NEXT:    s_pack_ll_b32_b16 s18, s18, s43
; GFX11-NEXT:    s_pack_ll_b32_b16 s19, s19, s42
; GFX11-NEXT:    s_pack_ll_b32_b16 s20, s20, s41
; GFX11-NEXT:    s_pack_ll_b32_b16 s21, s21, s40
; GFX11-NEXT:    s_pack_ll_b32_b16 s15, s22, s15
; GFX11-NEXT:    s_pack_ll_b32_b16 s14, s23, s14
; GFX11-NEXT:    s_pack_ll_b32_b16 s13, s24, s13
; GFX11-NEXT:    s_pack_ll_b32_b16 s12, s25, s12
; GFX11-NEXT:    s_pack_ll_b32_b16 s11, s26, s11
; GFX11-NEXT:    s_pack_ll_b32_b16 s10, s27, s10
; GFX11-NEXT:    s_pack_ll_b32_b16 s9, s28, s9
; GFX11-NEXT:    s_pack_ll_b32_b16 s8, s29, s8
; GFX11-NEXT:    s_pack_ll_b32_b16 s5, s5, s7
; GFX11-NEXT:    s_pack_ll_b32_b16 s4, s4, s6
; GFX11-NEXT:    v_dual_mov_b32 v0, s0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    v_dual_mov_b32 v2, s2 :: v_dual_mov_b32 v3, s3
; GFX11-NEXT:    v_dual_mov_b32 v4, s16 :: v_dual_mov_b32 v5, s17
; GFX11-NEXT:    v_dual_mov_b32 v6, s18 :: v_dual_mov_b32 v7, s19
; GFX11-NEXT:    v_dual_mov_b32 v8, s20 :: v_dual_mov_b32 v9, s21
; GFX11-NEXT:    v_dual_mov_b32 v10, s15 :: v_dual_mov_b32 v11, s14
; GFX11-NEXT:    v_dual_mov_b32 v12, s13 :: v_dual_mov_b32 v13, s12
; GFX11-NEXT:    v_dual_mov_b32 v14, s11 :: v_dual_mov_b32 v15, s10
; GFX11-NEXT:    v_dual_mov_b32 v16, s9 :: v_dual_mov_b32 v17, s8
; GFX11-NEXT:    v_dual_mov_b32 v18, s5 :: v_dual_mov_b32 v19, s4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
; GFX11-NEXT:  .LBB45_4:
; GFX11-NEXT:    ; implicit-def: $sgpr57
; GFX11-NEXT:    ; implicit-def: $sgpr56
; GFX11-NEXT:    ; implicit-def: $sgpr47
; GFX11-NEXT:    ; implicit-def: $sgpr46
; GFX11-NEXT:    ; implicit-def: $sgpr45
; GFX11-NEXT:    ; implicit-def: $sgpr44
; GFX11-NEXT:    ; implicit-def: $sgpr43
; GFX11-NEXT:    ; implicit-def: $sgpr42
; GFX11-NEXT:    ; implicit-def: $sgpr41
; GFX11-NEXT:    ; implicit-def: $sgpr40
; GFX11-NEXT:    ; implicit-def: $sgpr15
; GFX11-NEXT:    ; implicit-def: $sgpr14
; GFX11-NEXT:    ; implicit-def: $sgpr13
; GFX11-NEXT:    ; implicit-def: $sgpr12
; GFX11-NEXT:    ; implicit-def: $sgpr11
; GFX11-NEXT:    ; implicit-def: $sgpr10
; GFX11-NEXT:    ; implicit-def: $sgpr9
; GFX11-NEXT:    ; implicit-def: $sgpr8
; GFX11-NEXT:    ; implicit-def: $sgpr7
; GFX11-NEXT:    ; implicit-def: $sgpr6
; GFX11-NEXT:    s_branch .LBB45_2
  %cmp = icmp eq i32 %b, 0
  br i1 %cmp, label %cmp.true, label %cmp.false

cmp.true:
  %a1 = add <10 x i64> %a, splat (i64 3)
  %a2 = bi