; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=fiji < %s | FileCheck -enable-var-scope -check-prefixes=GCN %s

define amdgpu_kernel void @float4_inselt(ptr addrspace(1) %out, <4 x float> %vec, i32 %sel) {
; GCN-LABEL: float4_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x44
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x34
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_lg_u32 s6, 3
; GCN-NEXT:    v_mov_b32_e32 v0, s3
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s6, 2
; GCN-NEXT:    v_cndmask_b32_e32 v3, 1.0, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s6, 1
; GCN-NEXT:    v_cndmask_b32_e32 v2, 1.0, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v0, s1
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s6, 0
; GCN-NEXT:    v_cndmask_b32_e32 v1, 1.0, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    v_mov_b32_e32 v4, s4
; GCN-NEXT:    v_cndmask_b32_e32 v0, 1.0, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v5, s5
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <4 x float> %vec, float 1.000000e+00, i32 %sel
  store <4 x float> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @float4_inselt_undef(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: float4_inselt_undef:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v0, 1.0
; GCN-NEXT:    v_mov_b32_e32 v1, v0
; GCN-NEXT:    v_mov_b32_e32 v2, v0
; GCN-NEXT:    v_mov_b32_e32 v3, v0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v5, s1
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <4 x float> poison, float 1.000000e+00, i32 %sel
  store <4 x float> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @int4_inselt(ptr addrspace(1) %out, <4 x i32> %vec, i32 %sel) {
; GCN-LABEL: int4_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x44
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x34
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_lg_u32 s6, 3
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 2
; GCN-NEXT:    s_cselect_b32 s2, s2, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 1
; GCN-NEXT:    s_cselect_b32 s1, s1, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 0
; GCN-NEXT:    s_cselect_b32 s0, s0, 1
; GCN-NEXT:    v_mov_b32_e32 v4, s4
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    v_mov_b32_e32 v3, s3
; GCN-NEXT:    v_mov_b32_e32 v5, s5
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <4 x i32> %vec, i32 1, i32 %sel
  store <4 x i32> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @float2_inselt(ptr addrspace(1) %out, <2 x float> %vec, i32 %sel) {
; GCN-LABEL: float2_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_lg_u32 s2, 1
; GCN-NEXT:    v_mov_b32_e32 v0, s1
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 0
; GCN-NEXT:    v_cndmask_b32_e32 v1, 1.0, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    v_mov_b32_e32 v2, s4
; GCN-NEXT:    v_cndmask_b32_e32 v0, 1.0, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v3, s5
; GCN-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <2 x float> %vec, float 1.000000e+00, i32 %sel
  store <2 x float> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @float8_inselt(ptr addrspace(1) %out, <8 x float> %vec, i32 %sel) {
; GCN-LABEL: float8_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x44
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x64
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s8
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    s_add_u32 s2, s0, 16
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    v_mov_b32_e32 v1, s9
; GCN-NEXT:    v_mov_b32_e32 v2, s10
; GCN-NEXT:    v_mov_b32_e32 v3, s11
; GCN-NEXT:    v_mov_b32_e32 v4, s12
; GCN-NEXT:    v_mov_b32_e32 v5, s13
; GCN-NEXT:    v_mov_b32_e32 v6, s14
; GCN-NEXT:    v_mov_b32_e32 v7, s15
; GCN-NEXT:    v_mov_b32_e32 v9, s3
; GCN-NEXT:    v_movreld_b32_e32 v0, 1.0
; GCN-NEXT:    v_mov_b32_e32 v8, s2
; GCN-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v5, s1
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <8 x float> %vec, float 1.000000e+00, i32 %sel
  store <8 x float> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @float16_inselt(ptr addrspace(1) %out, <16 x float> %vec, i32 %sel) {
; GCN-LABEL: float16_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_load_dword s4, s[4:5], 0xa4
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s8
; GCN-NEXT:    s_add_u32 s2, s0, 48
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    v_mov_b32_e32 v17, s3
; GCN-NEXT:    v_mov_b32_e32 v1, s9
; GCN-NEXT:    v_mov_b32_e32 v2, s10
; GCN-NEXT:    v_mov_b32_e32 v3, s11
; GCN-NEXT:    v_mov_b32_e32 v4, s12
; GCN-NEXT:    v_mov_b32_e32 v5, s13
; GCN-NEXT:    v_mov_b32_e32 v6, s14
; GCN-NEXT:    v_mov_b32_e32 v7, s15
; GCN-NEXT:    v_mov_b32_e32 v8, s16
; GCN-NEXT:    v_mov_b32_e32 v9, s17
; GCN-NEXT:    v_mov_b32_e32 v10, s18
; GCN-NEXT:    v_mov_b32_e32 v11, s19
; GCN-NEXT:    v_mov_b32_e32 v12, s20
; GCN-NEXT:    v_mov_b32_e32 v13, s21
; GCN-NEXT:    v_mov_b32_e32 v14, s22
; GCN-NEXT:    v_mov_b32_e32 v15, s23
; GCN-NEXT:    s_mov_b32 m0, s4
; GCN-NEXT:    v_mov_b32_e32 v16, s2
; GCN-NEXT:    s_add_u32 s2, s0, 32
; GCN-NEXT:    v_movreld_b32_e32 v0, 1.0
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[16:17], v[12:15]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v13, s3
; GCN-NEXT:    v_mov_b32_e32 v12, s2
; GCN-NEXT:    s_add_u32 s2, s0, 16
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[12:13], v[8:11]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v9, s3
; GCN-NEXT:    v_mov_b32_e32 v8, s2
; GCN-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v5, s1
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <16 x float> %vec, float 1.000000e+00, i32 %sel
  store <16 x float> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @float32_inselt(ptr addrspace(1) %out, <32 x float> %vec, i32 %sel) {
; GCN-LABEL: float32_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x124
; GCN-NEXT:    s_load_dwordx16 s[36:51], s[4:5], 0xa4
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0xe4
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s36
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    s_add_u32 s2, s0, 0x70
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    v_mov_b32_e32 v33, s3
; GCN-NEXT:    v_mov_b32_e32 v1, s37
; GCN-NEXT:    v_mov_b32_e32 v2, s38
; GCN-NEXT:    v_mov_b32_e32 v3, s39
; GCN-NEXT:    v_mov_b32_e32 v4, s40
; GCN-NEXT:    v_mov_b32_e32 v5, s41
; GCN-NEXT:    v_mov_b32_e32 v6, s42
; GCN-NEXT:    v_mov_b32_e32 v7, s43
; GCN-NEXT:    v_mov_b32_e32 v8, s44
; GCN-NEXT:    v_mov_b32_e32 v9, s45
; GCN-NEXT:    v_mov_b32_e32 v10, s46
; GCN-NEXT:    v_mov_b32_e32 v11, s47
; GCN-NEXT:    v_mov_b32_e32 v12, s48
; GCN-NEXT:    v_mov_b32_e32 v13, s49
; GCN-NEXT:    v_mov_b32_e32 v14, s50
; GCN-NEXT:    v_mov_b32_e32 v15, s51
; GCN-NEXT:    v_mov_b32_e32 v16, s8
; GCN-NEXT:    v_mov_b32_e32 v17, s9
; GCN-NEXT:    v_mov_b32_e32 v18, s10
; GCN-NEXT:    v_mov_b32_e32 v19, s11
; GCN-NEXT:    v_mov_b32_e32 v20, s12
; GCN-NEXT:    v_mov_b32_e32 v21, s13
; GCN-NEXT:    v_mov_b32_e32 v22, s14
; GCN-NEXT:    v_mov_b32_e32 v23, s15
; GCN-NEXT:    v_mov_b32_e32 v24, s16
; GCN-NEXT:    v_mov_b32_e32 v25, s17
; GCN-NEXT:    v_mov_b32_e32 v26, s18
; GCN-NEXT:    v_mov_b32_e32 v27, s19
; GCN-NEXT:    v_mov_b32_e32 v28, s20
; GCN-NEXT:    v_mov_b32_e32 v29, s21
; GCN-NEXT:    v_mov_b32_e32 v30, s22
; GCN-NEXT:    v_mov_b32_e32 v31, s23
; GCN-NEXT:    v_mov_b32_e32 v32, s2
; GCN-NEXT:    s_add_u32 s2, s0, 0x60
; GCN-NEXT:    v_movreld_b32_e32 v0, 1.0
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[32:33], v[28:31]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v29, s3
; GCN-NEXT:    v_mov_b32_e32 v28, s2
; GCN-NEXT:    s_add_u32 s2, s0, 0x50
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[28:29], v[24:27]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v25, s3
; GCN-NEXT:    v_mov_b32_e32 v24, s2
; GCN-NEXT:    s_add_u32 s2, s0, 64
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[24:25], v[20:23]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v21, s3
; GCN-NEXT:    v_mov_b32_e32 v20, s2
; GCN-NEXT:    s_add_u32 s2, s0, 48
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[20:21], v[16:19]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v17, s3
; GCN-NEXT:    v_mov_b32_e32 v16, s2
; GCN-NEXT:    s_add_u32 s2, s0, 32
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[16:17], v[12:15]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v13, s3
; GCN-NEXT:    v_mov_b32_e32 v12, s2
; GCN-NEXT:    s_add_u32 s2, s0, 16
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[12:13], v[8:11]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v9, s3
; GCN-NEXT:    v_mov_b32_e32 v8, s2
; GCN-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v5, s1
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <32 x float> %vec, float 1.000000e+00, i32 %sel
  store <32 x float> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @half4_inselt(ptr addrspace(1) %out, <4 x half> %vec, i32 %sel) {
; GCN-LABEL: half4_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x34
; GCN-NEXT:    s_mov_b32 s4, 0x3c003c00
; GCN-NEXT:    s_mov_b32 s5, s4
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_xor_b64 s[4:5], s[2:3], s[4:5]
; GCN-NEXT:    s_lshl_b32 s6, s6, 4
; GCN-NEXT:    s_lshl_b64 s[6:7], 0xffff, s6
; GCN-NEXT:    s_and_b64 s[4:5], s[4:5], s[6:7]
; GCN-NEXT:    s_xor_b64 s[2:3], s[4:5], s[2:3]
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v3, s3
; GCN-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <4 x half> %vec, half 1.000000e+00, i32 %sel
  store <4 x half> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @half2_inselt(ptr addrspace(1) %out, <2 x half> %vec, i32 %sel) {
; GCN-LABEL: half2_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 s3, s3, 4
; GCN-NEXT:    s_xor_b32 s4, s2, 0x3c003c00
; GCN-NEXT:    s_lshl_b32 s3, 0xffff, s3
; GCN-NEXT:    s_and_b32 s3, s4, s3
; GCN-NEXT:    s_xor_b32 s2, s3, s2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <2 x half> %vec, half 1.000000e+00, i32 %sel
  store <2 x half> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @half8_inselt(ptr addrspace(1) %out, <8 x half> %vec, i32 %sel) {
; GCN-LABEL: half8_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x34
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x44
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v0, 0x3c00
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshr_b32 s7, s3, 16
; GCN-NEXT:    s_cmp_lg_u32 s6, 7
; GCN-NEXT:    v_mov_b32_e32 v1, s7
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s6, 6
; GCN-NEXT:    v_cndmask_b32_sdwa v1, v0, v1, vcc dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GCN-NEXT:    v_mov_b32_e32 v2, s3
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_lshr_b32 s3, s2, 16
; GCN-NEXT:    v_cndmask_b32_e32 v2, v0, v2, vcc
; GCN-NEXT:    s_cmp_lg_u32 s6, 5
; GCN-NEXT:    v_or_b32_sdwa v3, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s6, 4
; GCN-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_lshr_b32 s2, s1, 16
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GCN-NEXT:    v_cndmask_b32_e32 v2, v0, v2, vcc
; GCN-NEXT:    s_cmp_lg_u32 s6, 3
; GCN-NEXT:    v_or_b32_sdwa v2, v2, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GCN-NEXT:    v_mov_b32_e32 v1, s2
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s6, 2
; GCN-NEXT:    v_cndmask_b32_e32 v1, v0, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v4, s1
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_lshr_b32 s1, s0, 16
; GCN-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GCN-NEXT:    v_cndmask_b32_e32 v4, v0, v4, vcc
; GCN-NEXT:    s_cmp_lg_u32 s6, 1
; GCN-NEXT:    v_or_b32_sdwa v1, v4, v1 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GCN-NEXT:    v_mov_b32_e32 v4, s1
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s6, 0
; GCN-NEXT:    v_cndmask_b32_e32 v4, v0, v4, vcc
; GCN-NEXT:    v_mov_b32_e32 v5, s0
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; GCN-NEXT:    v_or_b32_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GCN-NEXT:    v_mov_b32_e32 v4, s4
; GCN-NEXT:    v_mov_b32_e32 v5, s5
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <8 x half> %vec, half 1.000000e+00, i32 %sel
  store <8 x half> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @short2_inselt(ptr addrspace(1) %out, <2 x i16> %vec, i32 %sel) {
; GCN-LABEL: short2_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 s3, s3, 4
; GCN-NEXT:    s_xor_b32 s4, s2, 0x10001
; GCN-NEXT:    s_lshl_b32 s3, 0xffff, s3
; GCN-NEXT:    s_and_b32 s3, s4, s3
; GCN-NEXT:    s_xor_b32 s2, s3, s2
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <2 x i16> %vec, i16 1, i32 %sel
  store <2 x i16> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @short4_inselt(ptr addrspace(1) %out, <4 x i16> %vec, i32 %sel) {
; GCN-LABEL: short4_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x34
; GCN-NEXT:    s_mov_b32 s4, 0x10001
; GCN-NEXT:    s_mov_b32 s5, s4
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_xor_b64 s[4:5], s[2:3], s[4:5]
; GCN-NEXT:    s_lshl_b32 s6, s6, 4
; GCN-NEXT:    s_lshl_b64 s[6:7], 0xffff, s6
; GCN-NEXT:    s_and_b64 s[4:5], s[4:5], s[6:7]
; GCN-NEXT:    s_xor_b64 s[2:3], s[4:5], s[2:3]
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v3, s3
; GCN-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <4 x i16> %vec, i16 1, i32 %sel
  store <4 x i16> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @byte8_inselt(ptr addrspace(1) %out, <8 x i8> %vec, i32 %sel) {
; GCN-LABEL: byte8_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x34
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_xor_b32 s5, s3, 0x1010101
; GCN-NEXT:    s_lshl_b32 s6, s6, 3
; GCN-NEXT:    s_xor_b32 s4, s2, 0x1010101
; GCN-NEXT:    s_lshl_b64 s[6:7], 0xff, s6
; GCN-NEXT:    s_and_b64 s[4:5], s[4:5], s[6:7]
; GCN-NEXT:    s_xor_b64 s[2:3], s[4:5], s[2:3]
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v3, s3
; GCN-NEXT:    flat_store_dwordx2 v[0:1], v[2:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <8 x i8> %vec, i8 1, i32 %sel
  store <8 x i8> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @byte16_inselt(ptr addrspace(1) %out, <16 x i8> %vec, i32 %sel) {
; GCN-LABEL: byte16_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x34
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x44
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshr_b32 s7, s3, 24
; GCN-NEXT:    s_cmp_lg_u32 s6, 15
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_lshr_b32 s8, s3, 16
; GCN-NEXT:    s_lshl_b32 s7, s7, 8
; GCN-NEXT:    s_cmp_lg_u32 s6, 14
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_and_b32 s8, s8, 0xff
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_lshr_b32 s9, s3, 8
; GCN-NEXT:    s_lshl_b32 s7, s7, 16
; GCN-NEXT:    s_cmp_lg_u32 s6, 13
; GCN-NEXT:    s_cselect_b32 s8, s9, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 8
; GCN-NEXT:    s_cmp_lg_u32 s6, 12
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_and_b32 s3, s3, 0xff
; GCN-NEXT:    s_or_b32 s3, s3, s8
; GCN-NEXT:    s_and_b32 s3, s3, 0xffff
; GCN-NEXT:    s_or_b32 s3, s3, s7
; GCN-NEXT:    s_lshr_b32 s7, s2, 24
; GCN-NEXT:    s_cmp_lg_u32 s6, 11
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 8
; GCN-NEXT:    s_lshr_b32 s8, s2, 16
; GCN-NEXT:    s_cmp_lg_u32 s6, 10
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_and_b32 s8, s8, 0xff
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_lshl_b32 s7, s7, 16
; GCN-NEXT:    s_lshr_b32 s8, s2, 8
; GCN-NEXT:    s_cmp_lg_u32 s6, 9
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 8
; GCN-NEXT:    s_cmp_lg_u32 s6, 8
; GCN-NEXT:    s_cselect_b32 s2, s2, 1
; GCN-NEXT:    s_and_b32 s2, s2, 0xff
; GCN-NEXT:    s_or_b32 s2, s2, s8
; GCN-NEXT:    s_and_b32 s2, s2, 0xffff
; GCN-NEXT:    s_or_b32 s2, s2, s7
; GCN-NEXT:    s_lshr_b32 s7, s1, 24
; GCN-NEXT:    s_cmp_lg_u32 s6, 7
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 8
; GCN-NEXT:    s_lshr_b32 s8, s1, 16
; GCN-NEXT:    s_cmp_lg_u32 s6, 6
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_and_b32 s8, s8, 0xff
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_lshl_b32 s7, s7, 16
; GCN-NEXT:    s_lshr_b32 s8, s1, 8
; GCN-NEXT:    s_cmp_lg_u32 s6, 5
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 8
; GCN-NEXT:    s_cmp_lg_u32 s6, 4
; GCN-NEXT:    s_cselect_b32 s1, s1, 1
; GCN-NEXT:    s_and_b32 s1, s1, 0xff
; GCN-NEXT:    s_or_b32 s1, s1, s8
; GCN-NEXT:    s_and_b32 s1, s1, 0xffff
; GCN-NEXT:    s_or_b32 s1, s1, s7
; GCN-NEXT:    s_lshr_b32 s7, s0, 24
; GCN-NEXT:    s_cmp_lg_u32 s6, 3
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 8
; GCN-NEXT:    s_lshr_b32 s8, s0, 16
; GCN-NEXT:    s_cmp_lg_u32 s6, 2
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_and_b32 s8, s8, 0xff
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_lshl_b32 s7, s7, 16
; GCN-NEXT:    s_lshr_b32 s8, s0, 8
; GCN-NEXT:    s_cmp_lg_u32 s6, 1
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 8
; GCN-NEXT:    s_cmp_lg_u32 s6, 0
; GCN-NEXT:    s_cselect_b32 s0, s0, 1
; GCN-NEXT:    s_and_b32 s0, s0, 0xff
; GCN-NEXT:    s_or_b32 s0, s0, s8
; GCN-NEXT:    s_and_b32 s0, s0, 0xffff
; GCN-NEXT:    s_or_b32 s0, s0, s7
; GCN-NEXT:    v_mov_b32_e32 v4, s4
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    v_mov_b32_e32 v3, s3
; GCN-NEXT:    v_mov_b32_e32 v5, s5
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <16 x i8> %vec, i8 1, i32 %sel
  store <16 x i8> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @double2_inselt(ptr addrspace(1) %out, <2 x double> %vec, i32 %sel) {
; GCN-LABEL: double2_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x44
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x34
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_eq_u32 s6, 1
; GCN-NEXT:    s_cselect_b32 s3, 0x3ff00000, s3
; GCN-NEXT:    s_cselect_b32 s2, 0, s2
; GCN-NEXT:    s_cmp_eq_u32 s6, 0
; GCN-NEXT:    s_cselect_b32 s1, 0x3ff00000, s1
; GCN-NEXT:    s_cselect_b32 s0, 0, s0
; GCN-NEXT:    v_mov_b32_e32 v4, s4
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    v_mov_b32_e32 v3, s3
; GCN-NEXT:    v_mov_b32_e32 v5, s5
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <2 x double> %vec, double 1.000000e+00, i32 %sel
  store <2 x double> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @double5_inselt(ptr addrspace(1) %out, <5 x double> %vec, i32 %sel) {
; GCN-LABEL: double5_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s12, s[4:5], 0xa4
; GCN-NEXT:    s_load_dwordx2 s[8:9], s[4:5], 0x84
; GCN-NEXT:    s_load_dwordx2 s[10:11], s[4:5], 0x24
; GCN-NEXT:    s_load_dwordx8 s[0:7], s[4:5], 0x64
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_eq_u32 s12, 4
; GCN-NEXT:    s_cselect_b32 s9, 0x3ff00000, s9
; GCN-NEXT:    s_cselect_b32 s8, 0, s8
; GCN-NEXT:    s_cmp_eq_u32 s12, 1
; GCN-NEXT:    s_cselect_b32 s3, 0x3ff00000, s3
; GCN-NEXT:    s_cselect_b32 s2, 0, s2
; GCN-NEXT:    s_cmp_eq_u32 s12, 0
; GCN-NEXT:    s_cselect_b32 s13, 0x3ff00000, s1
; GCN-NEXT:    s_cselect_b32 s14, 0, s0
; GCN-NEXT:    s_cmp_eq_u32 s12, 3
; GCN-NEXT:    s_cselect_b32 s0, 0x3ff00000, s7
; GCN-NEXT:    s_cselect_b32 s1, 0, s6
; GCN-NEXT:    s_cmp_eq_u32 s12, 2
; GCN-NEXT:    s_cselect_b32 s5, 0x3ff00000, s5
; GCN-NEXT:    s_cselect_b32 s4, 0, s4
; GCN-NEXT:    v_mov_b32_e32 v3, s0
; GCN-NEXT:    s_add_u32 s0, s10, 16
; GCN-NEXT:    v_mov_b32_e32 v2, s1
; GCN-NEXT:    s_addc_u32 s1, s11, 0
; GCN-NEXT:    v_mov_b32_e32 v5, s1
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    v_mov_b32_e32 v1, s5
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    v_mov_b32_e32 v4, s10
; GCN-NEXT:    s_add_u32 s0, s10, 32
; GCN-NEXT:    v_mov_b32_e32 v0, s14
; GCN-NEXT:    v_mov_b32_e32 v1, s13
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    v_mov_b32_e32 v3, s3
; GCN-NEXT:    v_mov_b32_e32 v5, s11
; GCN-NEXT:    s_addc_u32 s1, s11, 0
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v3, s1
; GCN-NEXT:    v_mov_b32_e32 v0, s8
; GCN-NEXT:    v_mov_b32_e32 v1, s9
; GCN-NEXT:    v_mov_b32_e32 v2, s0
; GCN-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <5 x double> %vec, double 1.000000e+00, i32 %sel
  store <5 x double> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @double8_inselt(ptr addrspace(1) %out, <8 x double> %vec, i32 %sel) {
; GCN-LABEL: double8_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s2, s[4:5], 0xa4
; GCN-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0x64
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v16, 0x3ff00000
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 m0, s2, 1
; GCN-NEXT:    v_mov_b32_e32 v0, s8
; GCN-NEXT:    v_mov_b32_e32 v1, s9
; GCN-NEXT:    v_mov_b32_e32 v2, s10
; GCN-NEXT:    v_mov_b32_e32 v3, s11
; GCN-NEXT:    v_mov_b32_e32 v4, s12
; GCN-NEXT:    v_mov_b32_e32 v5, s13
; GCN-NEXT:    v_mov_b32_e32 v6, s14
; GCN-NEXT:    v_mov_b32_e32 v7, s15
; GCN-NEXT:    v_mov_b32_e32 v8, s16
; GCN-NEXT:    v_mov_b32_e32 v9, s17
; GCN-NEXT:    v_mov_b32_e32 v10, s18
; GCN-NEXT:    v_mov_b32_e32 v11, s19
; GCN-NEXT:    v_mov_b32_e32 v12, s20
; GCN-NEXT:    v_mov_b32_e32 v13, s21
; GCN-NEXT:    v_mov_b32_e32 v14, s22
; GCN-NEXT:    v_mov_b32_e32 v15, s23
; GCN-NEXT:    s_add_u32 s2, s0, 48
; GCN-NEXT:    v_movreld_b32_e32 v0, 0
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    v_movreld_b32_e32 v1, v16
; GCN-NEXT:    v_mov_b32_e32 v17, s3
; GCN-NEXT:    v_mov_b32_e32 v16, s2
; GCN-NEXT:    s_add_u32 s2, s0, 32
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[16:17], v[12:15]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v13, s3
; GCN-NEXT:    v_mov_b32_e32 v12, s2
; GCN-NEXT:    s_add_u32 s2, s0, 16
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[12:13], v[8:11]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v9, s3
; GCN-NEXT:    v_mov_b32_e32 v8, s2
; GCN-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v5, s1
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <8 x double> %vec, double 1.000000e+00, i32 %sel
  store <8 x double> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @double7_inselt(ptr addrspace(1) %out, <7 x double> %vec, i32 %sel) {
; GCN-LABEL: double7_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx8 s[8:15], s[4:5], 0x64
; GCN-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x24
; GCN-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x94
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x84
; GCN-NEXT:    v_mov_b32_e32 v16, 0x3ff00000
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s8
; GCN-NEXT:    v_mov_b32_e32 v1, s9
; GCN-NEXT:    v_mov_b32_e32 v2, s10
; GCN-NEXT:    v_mov_b32_e32 v8, s0
; GCN-NEXT:    s_load_dword s0, s[4:5], 0xa4
; GCN-NEXT:    v_mov_b32_e32 v3, s11
; GCN-NEXT:    v_mov_b32_e32 v4, s12
; GCN-NEXT:    v_mov_b32_e32 v5, s13
; GCN-NEXT:    v_mov_b32_e32 v6, s14
; GCN-NEXT:    v_mov_b32_e32 v7, s15
; GCN-NEXT:    v_mov_b32_e32 v9, s1
; GCN-NEXT:    v_mov_b32_e32 v10, s2
; GCN-NEXT:    v_mov_b32_e32 v11, s3
; GCN-NEXT:    v_mov_b32_e32 v12, s16
; GCN-NEXT:    v_mov_b32_e32 v13, s17
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 m0, s0, 1
; GCN-NEXT:    v_movreld_b32_e32 v0, 0
; GCN-NEXT:    s_add_u32 s0, s6, 16
; GCN-NEXT:    v_movreld_b32_e32 v1, v16
; GCN-NEXT:    s_addc_u32 s1, s7, 0
; GCN-NEXT:    v_mov_b32_e32 v15, s1
; GCN-NEXT:    v_mov_b32_e32 v14, s0
; GCN-NEXT:    flat_store_dwordx4 v[14:15], v[4:7]
; GCN-NEXT:    s_add_u32 s0, s6, 48
; GCN-NEXT:    v_mov_b32_e32 v4, s6
; GCN-NEXT:    v_mov_b32_e32 v5, s7
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_addc_u32 s1, s7, 0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    s_add_u32 s0, s6, 32
; GCN-NEXT:    flat_store_dwordx2 v[0:1], v[12:13]
; GCN-NEXT:    s_addc_u32 s1, s7, 0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_store_dwordx4 v[0:1], v[8:11]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <7 x double> %vec, double 1.000000e+00, i32 %sel
  store <7 x double> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @double16_inselt(ptr addrspace(1) %out, <16 x double> %vec, i32 %sel) {
; GCN-LABEL: double16_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s0, s[4:5], 0x124
; GCN-NEXT:    s_load_dwordx16 s[36:51], s[4:5], 0xa4
; GCN-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0xe4
; GCN-NEXT:    v_mov_b32_e32 v32, 0x3ff00000
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s36
; GCN-NEXT:    s_lshl_b32 m0, s0, 1
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v1, s37
; GCN-NEXT:    v_mov_b32_e32 v2, s38
; GCN-NEXT:    v_mov_b32_e32 v3, s39
; GCN-NEXT:    v_mov_b32_e32 v4, s40
; GCN-NEXT:    v_mov_b32_e32 v5, s41
; GCN-NEXT:    v_mov_b32_e32 v6, s42
; GCN-NEXT:    v_mov_b32_e32 v7, s43
; GCN-NEXT:    v_mov_b32_e32 v8, s44
; GCN-NEXT:    v_mov_b32_e32 v9, s45
; GCN-NEXT:    v_mov_b32_e32 v10, s46
; GCN-NEXT:    v_mov_b32_e32 v11, s47
; GCN-NEXT:    v_mov_b32_e32 v12, s48
; GCN-NEXT:    v_mov_b32_e32 v13, s49
; GCN-NEXT:    v_mov_b32_e32 v14, s50
; GCN-NEXT:    v_mov_b32_e32 v15, s51
; GCN-NEXT:    v_mov_b32_e32 v16, s8
; GCN-NEXT:    v_mov_b32_e32 v17, s9
; GCN-NEXT:    v_mov_b32_e32 v18, s10
; GCN-NEXT:    v_mov_b32_e32 v19, s11
; GCN-NEXT:    v_mov_b32_e32 v20, s12
; GCN-NEXT:    v_mov_b32_e32 v21, s13
; GCN-NEXT:    v_mov_b32_e32 v22, s14
; GCN-NEXT:    v_mov_b32_e32 v23, s15
; GCN-NEXT:    v_mov_b32_e32 v24, s16
; GCN-NEXT:    v_mov_b32_e32 v25, s17
; GCN-NEXT:    v_mov_b32_e32 v26, s18
; GCN-NEXT:    v_mov_b32_e32 v27, s19
; GCN-NEXT:    v_mov_b32_e32 v28, s20
; GCN-NEXT:    v_mov_b32_e32 v29, s21
; GCN-NEXT:    v_mov_b32_e32 v30, s22
; GCN-NEXT:    v_mov_b32_e32 v31, s23
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_add_u32 s2, s0, 0x70
; GCN-NEXT:    v_movreld_b32_e32 v0, 0
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    v_movreld_b32_e32 v1, v32
; GCN-NEXT:    v_mov_b32_e32 v33, s3
; GCN-NEXT:    v_mov_b32_e32 v32, s2
; GCN-NEXT:    s_add_u32 s2, s0, 0x60
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[32:33], v[28:31]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v29, s3
; GCN-NEXT:    v_mov_b32_e32 v28, s2
; GCN-NEXT:    s_add_u32 s2, s0, 0x50
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[28:29], v[24:27]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v25, s3
; GCN-NEXT:    v_mov_b32_e32 v24, s2
; GCN-NEXT:    s_add_u32 s2, s0, 64
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[24:25], v[20:23]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v21, s3
; GCN-NEXT:    v_mov_b32_e32 v20, s2
; GCN-NEXT:    s_add_u32 s2, s0, 48
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[20:21], v[16:19]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v17, s3
; GCN-NEXT:    v_mov_b32_e32 v16, s2
; GCN-NEXT:    s_add_u32 s2, s0, 32
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[16:17], v[12:15]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v13, s3
; GCN-NEXT:    v_mov_b32_e32 v12, s2
; GCN-NEXT:    s_add_u32 s2, s0, 16
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[12:13], v[8:11]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v9, s3
; GCN-NEXT:    v_mov_b32_e32 v8, s2
; GCN-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v5, s1
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <16 x double> %vec, double 1.000000e+00, i32 %sel
  store <16 x double> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @double15_inselt(ptr addrspace(1) %out, <15 x double> %vec, i32 %sel) {
; GCN-LABEL: double15_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx16 s[8:23], s[4:5], 0xa4
; GCN-NEXT:    s_load_dwordx2 s[6:7], s[4:5], 0x114
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x104
; GCN-NEXT:    s_load_dwordx8 s[24:31], s[4:5], 0xe4
; GCN-NEXT:    v_mov_b32_e32 v32, 0x3ff00000
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v0, s8
; GCN-NEXT:    v_mov_b32_e32 v1, s9
; GCN-NEXT:    v_mov_b32_e32 v24, s0
; GCN-NEXT:    s_load_dword s0, s[4:5], 0x124
; GCN-NEXT:    v_mov_b32_e32 v25, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s10
; GCN-NEXT:    v_mov_b32_e32 v3, s11
; GCN-NEXT:    v_mov_b32_e32 v4, s12
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 m0, s0, 1
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v5, s13
; GCN-NEXT:    v_mov_b32_e32 v6, s14
; GCN-NEXT:    v_mov_b32_e32 v7, s15
; GCN-NEXT:    v_mov_b32_e32 v8, s16
; GCN-NEXT:    v_mov_b32_e32 v9, s17
; GCN-NEXT:    v_mov_b32_e32 v10, s18
; GCN-NEXT:    v_mov_b32_e32 v11, s19
; GCN-NEXT:    v_mov_b32_e32 v12, s20
; GCN-NEXT:    v_mov_b32_e32 v13, s21
; GCN-NEXT:    v_mov_b32_e32 v14, s22
; GCN-NEXT:    v_mov_b32_e32 v15, s23
; GCN-NEXT:    v_mov_b32_e32 v16, s24
; GCN-NEXT:    v_mov_b32_e32 v17, s25
; GCN-NEXT:    v_mov_b32_e32 v18, s26
; GCN-NEXT:    v_mov_b32_e32 v19, s27
; GCN-NEXT:    v_mov_b32_e32 v20, s28
; GCN-NEXT:    v_mov_b32_e32 v21, s29
; GCN-NEXT:    v_mov_b32_e32 v22, s30
; GCN-NEXT:    v_mov_b32_e32 v23, s31
; GCN-NEXT:    v_mov_b32_e32 v26, s2
; GCN-NEXT:    v_mov_b32_e32 v27, s3
; GCN-NEXT:    v_mov_b32_e32 v28, s6
; GCN-NEXT:    v_mov_b32_e32 v29, s7
; GCN-NEXT:    v_movreld_b32_e32 v0, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_add_u32 s2, s0, 0x50
; GCN-NEXT:    v_movreld_b32_e32 v1, v32
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    v_mov_b32_e32 v31, s3
; GCN-NEXT:    v_mov_b32_e32 v30, s2
; GCN-NEXT:    s_add_u32 s2, s0, 64
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[30:31], v[20:23]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v21, s3
; GCN-NEXT:    v_mov_b32_e32 v20, s2
; GCN-NEXT:    s_add_u32 s2, s0, 48
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[20:21], v[16:19]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v17, s3
; GCN-NEXT:    v_mov_b32_e32 v16, s2
; GCN-NEXT:    s_add_u32 s2, s0, 32
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[16:17], v[12:15]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v13, s3
; GCN-NEXT:    v_mov_b32_e32 v12, s2
; GCN-NEXT:    s_add_u32 s2, s0, 16
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    flat_store_dwordx4 v[12:13], v[8:11]
; GCN-NEXT:    s_nop 0
; GCN-NEXT:    v_mov_b32_e32 v9, s3
; GCN-NEXT:    v_mov_b32_e32 v8, s2
; GCN-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; GCN-NEXT:    s_add_u32 s2, s0, 0x70
; GCN-NEXT:    v_mov_b32_e32 v5, s1
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_addc_u32 s3, s1, 0
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s3
; GCN-NEXT:    s_add_u32 s0, s0, 0x60
; GCN-NEXT:    flat_store_dwordx2 v[0:1], v[28:29]
; GCN-NEXT:    s_addc_u32 s1, s1, 0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_store_dwordx4 v[0:1], v[24:27]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <15 x double> %vec, double 1.000000e+00, i32 %sel
  store <15 x double> %v, ptr addrspace(1) %out
  ret void
}

; FIXME: Fold out s_or_b32 s2, 0, s3
define amdgpu_kernel void @bit4_inselt(ptr addrspace(1) %out, <4 x i1> %vec, i32 %sel) {
; GCN-LABEL: bit4_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_mov_b32 s12, SCRATCH_RSRC_DWORD0
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x24
; GCN-NEXT:    s_mov_b32 s13, SCRATCH_RSRC_DWORD1
; GCN-NEXT:    s_mov_b32 s14, -1
; GCN-NEXT:    s_mov_b32 s15, 0xe80000
; GCN-NEXT:    s_add_u32 s12, s12, s11
; GCN-NEXT:    s_addc_u32 s13, s13, 0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s6, s2, 0x10003
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    s_bfe_u32 s5, s2, 0x20002
; GCN-NEXT:    buffer_store_byte v0, off, s[12:15], 0
; GCN-NEXT:    v_mov_b32_e32 v0, s6
; GCN-NEXT:    s_bfe_u32 s4, s2, 0x10001
; GCN-NEXT:    buffer_store_byte v0, off, s[12:15], 0 offset:3
; GCN-NEXT:    v_mov_b32_e32 v0, s5
; GCN-NEXT:    s_and_b32 s3, s3, 3
; GCN-NEXT:    buffer_store_byte v0, off, s[12:15], 0 offset:2
; GCN-NEXT:    v_mov_b32_e32 v0, s4
; GCN-NEXT:    v_or_b32_e64 v1, s3, 0
; GCN-NEXT:    buffer_store_byte v0, off, s[12:15], 0 offset:1
; GCN-NEXT:    v_mov_b32_e32 v0, 1
; GCN-NEXT:    buffer_store_byte v0, v1, s[12:15], 0 offen
; GCN-NEXT:    buffer_load_ubyte v0, off, s[12:15], 0
; GCN-NEXT:    buffer_load_ubyte v1, off, s[12:15], 0 offset:1
; GCN-NEXT:    buffer_load_ubyte v2, off, s[12:15], 0 offset:2
; GCN-NEXT:    buffer_load_ubyte v3, off, s[12:15], 0 offset:3
; GCN-NEXT:    s_waitcnt vmcnt(3)
; GCN-NEXT:    v_and_b32_e32 v0, 1, v0
; GCN-NEXT:    s_waitcnt vmcnt(2)
; GCN-NEXT:    v_and_b32_e32 v1, 1, v1
; GCN-NEXT:    s_waitcnt vmcnt(1)
; GCN-NEXT:    v_and_b32_e32 v2, 1, v2
; GCN-NEXT:    v_lshlrev_b16_e32 v1, 1, v1
; GCN-NEXT:    v_lshlrev_b16_e32 v2, 2, v2
; GCN-NEXT:    v_or_b32_e32 v0, v0, v1
; GCN-NEXT:    s_waitcnt vmcnt(0)
; GCN-NEXT:    v_lshlrev_b16_e32 v3, 3, v3
; GCN-NEXT:    v_or_b32_e32 v0, v0, v2
; GCN-NEXT:    v_or_b32_e32 v0, v0, v3
; GCN-NEXT:    v_and_b32_e32 v2, 15, v0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_store_byte v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <4 x i1> %vec, i1 1, i32 %sel
  store <4 x i1> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @bit128_inselt(ptr addrspace(1) %out, <128 x i1> %vec, i32 %sel) {
; GCN-LABEL: bit128_inselt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx4 s[0:3], s[4:5], 0x34
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x44
; GCN-NEXT:    s_load_dwordx2 s[4:5], s[4:5], 0x24
; GCN-NEXT:    ; implicit-def: $vgpr6 : SGPR spill to VGPR lane
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_bfe_u32 s9, s0, 0xf0001
; GCN-NEXT:    s_lshr_b32 s42, s1, 16
; GCN-NEXT:    v_writelane_b32 v6, s4, 0
; GCN-NEXT:    v_writelane_b32 v6, s5, 1
; GCN-NEXT:    s_lshr_b32 s4, s0, 16
; GCN-NEXT:    v_writelane_b32 v6, s4, 2
; GCN-NEXT:    s_lshr_b32 s4, s0, 17
; GCN-NEXT:    v_writelane_b32 v6, s4, 3
; GCN-NEXT:    s_lshr_b32 s4, s0, 18
; GCN-NEXT:    v_writelane_b32 v6, s4, 4
; GCN-NEXT:    s_lshr_b32 s4, s0, 19
; GCN-NEXT:    v_writelane_b32 v6, s4, 5
; GCN-NEXT:    s_lshr_b32 s4, s0, 20
; GCN-NEXT:    v_writelane_b32 v6, s4, 6
; GCN-NEXT:    s_lshr_b32 s4, s0, 21
; GCN-NEXT:    v_writelane_b32 v6, s4, 7
; GCN-NEXT:    s_lshr_b32 s4, s0, 22
; GCN-NEXT:    v_writelane_b32 v6, s4, 8
; GCN-NEXT:    s_lshr_b32 s4, s0, 23
; GCN-NEXT:    v_writelane_b32 v6, s4, 9
; GCN-NEXT:    s_lshr_b32 s4, s0, 24
; GCN-NEXT:    v_writelane_b32 v6, s4, 10
; GCN-NEXT:    s_lshr_b32 s4, s0, 25
; GCN-NEXT:    v_writelane_b32 v6, s4, 11
; GCN-NEXT:    s_lshr_b32 s4, s0, 26
; GCN-NEXT:    v_writelane_b32 v6, s4, 12
; GCN-NEXT:    s_lshr_b32 s4, s0, 27
; GCN-NEXT:    v_writelane_b32 v6, s4, 13
; GCN-NEXT:    s_lshr_b32 s4, s0, 28
; GCN-NEXT:    v_writelane_b32 v6, s4, 14
; GCN-NEXT:    s_lshr_b32 s4, s0, 29
; GCN-NEXT:    v_writelane_b32 v6, s4, 15
; GCN-NEXT:    s_lshr_b32 s4, s0, 30
; GCN-NEXT:    v_writelane_b32 v6, s4, 16
; GCN-NEXT:    s_lshr_b32 s4, s0, 31
; GCN-NEXT:    v_writelane_b32 v6, s4, 17
; GCN-NEXT:    v_writelane_b32 v6, s9, 18
; GCN-NEXT:    s_bfe_u32 s9, s0, 0xe0002
; GCN-NEXT:    v_writelane_b32 v6, s9, 19
; GCN-NEXT:    s_bfe_u32 s9, s0, 0xd0003
; GCN-NEXT:    v_writelane_b32 v6, s9, 20
; GCN-NEXT:    s_bfe_u32 s9, s0, 0xc0004
; GCN-NEXT:    v_writelane_b32 v6, s9, 21
; GCN-NEXT:    s_bfe_u32 s9, s0, 0xb0005
; GCN-NEXT:    v_writelane_b32 v6, s9, 22
; GCN-NEXT:    s_bfe_u32 s9, s0, 0xa0006
; GCN-NEXT:    v_writelane_b32 v6, s9, 23
; GCN-NEXT:    s_bfe_u32 s9, s0, 0x90007
; GCN-NEXT:    v_writelane_b32 v6, s9, 24
; GCN-NEXT:    s_bfe_u32 s9, s0, 0x80008
; GCN-NEXT:    v_writelane_b32 v6, s9, 25
; GCN-NEXT:    s_bfe_u32 s9, s0, 0x70009
; GCN-NEXT:    v_writelane_b32 v6, s9, 26
; GCN-NEXT:    s_bfe_u32 s9, s0, 0x6000a
; GCN-NEXT:    v_writelane_b32 v6, s9, 27
; GCN-NEXT:    s_bfe_u32 s9, s0, 0x5000b
; GCN-NEXT:    v_writelane_b32 v6, s9, 28
; GCN-NEXT:    s_bfe_u32 s9, s0, 0x4000c
; GCN-NEXT:    v_writelane_b32 v6, s9, 29
; GCN-NEXT:    s_bfe_u32 s9, s0, 0x3000d
; GCN-NEXT:    v_writelane_b32 v6, s9, 30
; GCN-NEXT:    s_bfe_u32 s9, s0, 0x2000e
; GCN-NEXT:    v_writelane_b32 v6, s9, 31
; GCN-NEXT:    s_bfe_u32 s9, s0, 0x1000f
; GCN-NEXT:    v_writelane_b32 v6, s9, 32
; GCN-NEXT:    s_bfe_u32 s9, s1, 0xf0001
; GCN-NEXT:    s_lshr_b32 s43, s1, 17
; GCN-NEXT:    s_lshr_b32 s45, s1, 18
; GCN-NEXT:    s_lshr_b32 s47, s1, 19
; GCN-NEXT:    s_lshr_b32 s50, s1, 20
; GCN-NEXT:    s_lshr_b32 s51, s1, 21
; GCN-NEXT:    s_lshr_b32 s53, s1, 22
; GCN-NEXT:    s_lshr_b32 s55, s1, 23
; GCN-NEXT:    s_lshr_b32 s58, s1, 24
; GCN-NEXT:    s_lshr_b32 s59, s1, 25
; GCN-NEXT:    s_lshr_b32 s61, s1, 26
; GCN-NEXT:    s_lshr_b32 s63, s1, 27
; GCN-NEXT:    s_lshr_b32 s66, s1, 28
; GCN-NEXT:    s_lshr_b32 s67, s1, 29
; GCN-NEXT:    s_lshr_b32 s68, s1, 30
; GCN-NEXT:    s_lshr_b32 s69, s1, 31
; GCN-NEXT:    s_lshr_b32 s73, s2, 16
; GCN-NEXT:    s_lshr_b32 s74, s2, 17
; GCN-NEXT:    s_lshr_b32 s77, s2, 18
; GCN-NEXT:    s_lshr_b32 s78, s2, 19
; GCN-NEXT:    s_lshr_b32 s81, s2, 20
; GCN-NEXT:    s_lshr_b32 s82, s2, 21
; GCN-NEXT:    s_lshr_b32 s84, s2, 22
; GCN-NEXT:    s_lshr_b32 s86, s2, 23
; GCN-NEXT:    s_lshr_b32 s89, s2, 24
; GCN-NEXT:    s_lshr_b32 s90, s2, 25
; GCN-NEXT:    s_lshr_b32 s93, s2, 26
; GCN-NEXT:    s_lshr_b32 s94, s2, 27
; GCN-NEXT:    s_lshr_b32 vcc_hi, s2, 28
; GCN-NEXT:    s_lshr_b32 s39, s2, 29
; GCN-NEXT:    s_lshr_b32 s38, s2, 30
; GCN-NEXT:    s_lshr_b32 s37, s2, 31
; GCN-NEXT:    s_lshr_b32 s33, s3, 16
; GCN-NEXT:    s_lshr_b32 s31, s3, 17
; GCN-NEXT:    s_lshr_b32 s28, s3, 18
; GCN-NEXT:    s_lshr_b32 s27, s3, 19
; GCN-NEXT:    s_lshr_b32 s24, s3, 20
; GCN-NEXT:    s_lshr_b32 s23, s3, 21
; GCN-NEXT:    s_lshr_b32 s20, s3, 22
; GCN-NEXT:    s_lshr_b32 s19, s3, 23
; GCN-NEXT:    s_lshr_b32 s16, s3, 24
; GCN-NEXT:    s_lshr_b32 s15, s3, 25
; GCN-NEXT:    s_lshr_b32 s12, s3, 26
; GCN-NEXT:    s_lshr_b32 s11, s3, 27
; GCN-NEXT:    s_lshr_b32 s8, s3, 28
; GCN-NEXT:    s_lshr_b32 s7, s3, 29
; GCN-NEXT:    s_lshr_b32 s5, s3, 30
; GCN-NEXT:    s_lshr_b32 s4, s3, 31
; GCN-NEXT:    v_writelane_b32 v6, s9, 33
; GCN-NEXT:    s_bfe_u32 s40, s1, 0xe0002
; GCN-NEXT:    s_bfe_u32 s41, s1, 0xd0003
; GCN-NEXT:    s_bfe_u32 s44, s1, 0xc0004
; GCN-NEXT:    s_bfe_u32 s46, s1, 0xb0005
; GCN-NEXT:    s_bfe_u32 s48, s1, 0xa0006
; GCN-NEXT:    s_bfe_u32 s49, s1, 0x90007
; GCN-NEXT:    s_bfe_u32 s52, s1, 0x80008
; GCN-NEXT:    s_bfe_u32 s54, s1, 0x70009
; GCN-NEXT:    s_bfe_u32 s56, s1, 0x6000a
; GCN-NEXT:    s_bfe_u32 s57, s1, 0x5000b
; GCN-NEXT:    s_bfe_u32 s60, s1, 0x4000c
; GCN-NEXT:    s_bfe_u32 s62, s1, 0x3000d
; GCN-NEXT:    s_bfe_u32 s64, s1, 0x2000e
; GCN-NEXT:    s_bfe_u32 s65, s1, 0x1000f
; GCN-NEXT:    s_bfe_u32 s70, s2, 0xf0001
; GCN-NEXT:    s_bfe_u32 s71, s2, 0xe0002
; GCN-NEXT:    s_bfe_u32 s72, s2, 0xd0003
; GCN-NEXT:    s_bfe_u32 s75, s2, 0xc0004
; GCN-NEXT:    s_bfe_u32 s76, s2, 0xb0005
; GCN-NEXT:    s_bfe_u32 s79, s2, 0xa0006
; GCN-NEXT:    s_bfe_u32 s80, s2, 0x90007
; GCN-NEXT:    s_bfe_u32 s83, s2, 0x80008
; GCN-NEXT:    s_bfe_u32 s85, s2, 0x70009
; GCN-NEXT:    s_bfe_u32 s87, s2, 0x6000a
; GCN-NEXT:    s_bfe_u32 s88, s2, 0x5000b
; GCN-NEXT:    s_bfe_u32 s91, s2, 0x4000c
; GCN-NEXT:    s_bfe_u32 s92, s2, 0x3000d
; GCN-NEXT:    s_bfe_u32 s95, s2, 0x2000e
; GCN-NEXT:    s_bfe_u32 vcc_lo, s2, 0x1000f
; GCN-NEXT:    s_bfe_u32 s36, s3, 0xf0001
; GCN-NEXT:    s_bfe_u32 s35, s3, 0xe0002
; GCN-NEXT:    s_bfe_u32 s34, s3, 0xd0003
; GCN-NEXT:    s_bfe_u32 s30, s3, 0xc0004
; GCN-NEXT:    s_bfe_u32 s29, s3, 0xb0005
; GCN-NEXT:    s_bfe_u32 s26, s3, 0xa0006
; GCN-NEXT:    s_bfe_u32 s25, s3, 0x90007
; GCN-NEXT:    s_bfe_u32 s22, s3, 0x80008
; GCN-NEXT:    s_bfe_u32 s21, s3, 0x70009
; GCN-NEXT:    s_bfe_u32 s18, s3, 0x6000a
; GCN-NEXT:    s_bfe_u32 s17, s3, 0x5000b
; GCN-NEXT:    s_bfe_u32 s14, s3, 0x4000c
; GCN-NEXT:    s_bfe_u32 s13, s3, 0x3000d
; GCN-NEXT:    s_bfe_u32 s10, s3, 0x2000e
; GCN-NEXT:    s_bfe_u32 s9, s3, 0x1000f
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x7f
; GCN-NEXT:    s_cselect_b32 s4, s4, 1
; GCN-NEXT:    s_lshl_b32 s4, s4, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x7e
; GCN-NEXT:    s_cselect_b32 s5, s5, 1
; GCN-NEXT:    s_and_b32 s5, s5, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 2
; GCN-NEXT:    s_or_b32 s4, s4, s5
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x7d
; GCN-NEXT:    s_cselect_b32 s5, s7, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x7c
; GCN-NEXT:    s_cselect_b32 s7, s8, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_and_b32 s5, s5, 3
; GCN-NEXT:    s_or_b32 s4, s5, s4
; GCN-NEXT:    s_lshl_b32 s4, s4, 12
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x7b
; GCN-NEXT:    s_cselect_b32 s5, s11, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x7a
; GCN-NEXT:    s_cselect_b32 s7, s12, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 2
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x79
; GCN-NEXT:    s_cselect_b32 s7, s15, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x78
; GCN-NEXT:    s_cselect_b32 s8, s16, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 3
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_and_b32 s5, s5, 15
; GCN-NEXT:    s_lshl_b32 s5, s5, 8
; GCN-NEXT:    s_or_b32 s4, s4, s5
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x77
; GCN-NEXT:    s_cselect_b32 s5, s19, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x76
; GCN-NEXT:    s_cselect_b32 s7, s20, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 2
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x75
; GCN-NEXT:    s_cselect_b32 s7, s23, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x74
; GCN-NEXT:    s_cselect_b32 s8, s24, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 3
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_lshl_b32 s5, s5, 4
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x73
; GCN-NEXT:    s_cselect_b32 s7, s27, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x72
; GCN-NEXT:    s_cselect_b32 s8, s28, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 2
; GCN-NEXT:    s_or_b32 s7, s7, s8
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x71
; GCN-NEXT:    s_cselect_b32 s8, s31, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x70
; GCN-NEXT:    s_cselect_b32 s11, s33, 1
; GCN-NEXT:    s_and_b32 s11, s11, 1
; GCN-NEXT:    s_or_b32 s8, s11, s8
; GCN-NEXT:    s_and_b32 s8, s8, 3
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 15
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_and_b32 s5, s5, 0xff
; GCN-NEXT:    s_or_b32 s4, s5, s4
; GCN-NEXT:    s_lshl_b32 s4, s4, 16
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x6f
; GCN-NEXT:    s_cselect_b32 s5, s9, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x6e
; GCN-NEXT:    s_cselect_b32 s7, s10, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 2
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x6d
; GCN-NEXT:    s_cselect_b32 s7, s13, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x6c
; GCN-NEXT:    s_cselect_b32 s8, s14, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 3
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_lshl_b32 s5, s5, 12
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x6b
; GCN-NEXT:    s_cselect_b32 s7, s17, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x6a
; GCN-NEXT:    s_cselect_b32 s8, s18, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 2
; GCN-NEXT:    s_or_b32 s7, s7, s8
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x69
; GCN-NEXT:    s_cselect_b32 s8, s21, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x68
; GCN-NEXT:    s_cselect_b32 s9, s22, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s8, s9, s8
; GCN-NEXT:    s_and_b32 s8, s8, 3
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 15
; GCN-NEXT:    s_lshl_b32 s7, s7, 8
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x67
; GCN-NEXT:    s_cselect_b32 s7, s25, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x66
; GCN-NEXT:    s_cselect_b32 s8, s26, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 2
; GCN-NEXT:    s_or_b32 s7, s7, s8
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x65
; GCN-NEXT:    s_cselect_b32 s8, s29, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x64
; GCN-NEXT:    s_cselect_b32 s9, s30, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s8, s9, s8
; GCN-NEXT:    s_and_b32 s8, s8, 3
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_lshl_b32 s7, s7, 4
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x63
; GCN-NEXT:    s_cselect_b32 s8, s34, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x62
; GCN-NEXT:    s_cselect_b32 s9, s35, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_lshl_b32 s9, s9, 2
; GCN-NEXT:    s_or_b32 s8, s8, s9
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x60
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_and_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x61
; GCN-NEXT:    s_cselect_b32 s9, s36, 1
; GCN-NEXT:    s_lshl_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s3, s3, s9
; GCN-NEXT:    s_and_b32 s3, s3, 3
; GCN-NEXT:    s_or_b32 s3, s3, s8
; GCN-NEXT:    s_and_b32 s3, s3, 15
; GCN-NEXT:    s_or_b32 s3, s3, s7
; GCN-NEXT:    s_and_b32 s3, s3, 0xff
; GCN-NEXT:    s_or_b32 s3, s3, s5
; GCN-NEXT:    s_and_b32 s3, s3, 0xffff
; GCN-NEXT:    s_or_b32 s3, s3, s4
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x5f
; GCN-NEXT:    s_cselect_b32 s4, s37, 1
; GCN-NEXT:    s_lshl_b32 s4, s4, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x5e
; GCN-NEXT:    s_cselect_b32 s5, s38, 1
; GCN-NEXT:    s_and_b32 s5, s5, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 2
; GCN-NEXT:    s_or_b32 s4, s4, s5
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x5d
; GCN-NEXT:    s_cselect_b32 s5, s39, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x5c
; GCN-NEXT:    s_cselect_b32 s7, vcc_hi, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_and_b32 s5, s5, 3
; GCN-NEXT:    s_or_b32 s4, s5, s4
; GCN-NEXT:    s_lshl_b32 s4, s4, 12
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x5b
; GCN-NEXT:    s_cselect_b32 s5, s94, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x5a
; GCN-NEXT:    s_cselect_b32 s7, s93, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 2
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x59
; GCN-NEXT:    s_cselect_b32 s7, s90, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x58
; GCN-NEXT:    s_cselect_b32 s8, s89, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 3
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_and_b32 s5, s5, 15
; GCN-NEXT:    s_lshl_b32 s5, s5, 8
; GCN-NEXT:    s_or_b32 s4, s4, s5
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x57
; GCN-NEXT:    s_cselect_b32 s5, s86, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x56
; GCN-NEXT:    s_cselect_b32 s7, s84, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 2
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x55
; GCN-NEXT:    s_cselect_b32 s7, s82, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x54
; GCN-NEXT:    s_cselect_b32 s8, s81, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 3
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_lshl_b32 s5, s5, 4
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x53
; GCN-NEXT:    s_cselect_b32 s7, s78, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x52
; GCN-NEXT:    s_cselect_b32 s8, s77, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 2
; GCN-NEXT:    s_or_b32 s7, s7, s8
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x51
; GCN-NEXT:    s_cselect_b32 s8, s74, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x50
; GCN-NEXT:    s_cselect_b32 s9, s73, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s8, s9, s8
; GCN-NEXT:    s_and_b32 s8, s8, 3
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 15
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_and_b32 s5, s5, 0xff
; GCN-NEXT:    s_or_b32 s4, s5, s4
; GCN-NEXT:    s_lshl_b32 s4, s4, 16
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x4f
; GCN-NEXT:    s_cselect_b32 s5, vcc_lo, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x4e
; GCN-NEXT:    s_cselect_b32 s7, s95, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 2
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x4d
; GCN-NEXT:    s_cselect_b32 s7, s92, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x4c
; GCN-NEXT:    s_cselect_b32 s8, s91, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 3
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_lshl_b32 s5, s5, 12
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x4b
; GCN-NEXT:    s_cselect_b32 s7, s88, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x4a
; GCN-NEXT:    s_cselect_b32 s8, s87, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 2
; GCN-NEXT:    s_or_b32 s7, s7, s8
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x49
; GCN-NEXT:    s_cselect_b32 s8, s85, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x48
; GCN-NEXT:    s_cselect_b32 s9, s83, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s8, s9, s8
; GCN-NEXT:    s_and_b32 s8, s8, 3
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 15
; GCN-NEXT:    s_lshl_b32 s7, s7, 8
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x47
; GCN-NEXT:    s_cselect_b32 s7, s80, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x46
; GCN-NEXT:    s_cselect_b32 s8, s79, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 2
; GCN-NEXT:    s_or_b32 s7, s7, s8
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x45
; GCN-NEXT:    s_cselect_b32 s8, s76, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x44
; GCN-NEXT:    s_cselect_b32 s9, s75, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s8, s9, s8
; GCN-NEXT:    s_and_b32 s8, s8, 3
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_lshl_b32 s7, s7, 4
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x43
; GCN-NEXT:    s_cselect_b32 s8, s72, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 3
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x42
; GCN-NEXT:    s_cselect_b32 s9, s71, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_lshl_b32 s9, s9, 2
; GCN-NEXT:    s_or_b32 s8, s8, s9
; GCN-NEXT:    s_cmp_lg_u32 s6, 64
; GCN-NEXT:    s_cselect_b32 s2, s2, 1
; GCN-NEXT:    s_and_b32 s2, s2, 1
; GCN-NEXT:    s_cmpk_lg_i32 s6, 0x41
; GCN-NEXT:    s_cselect_b32 s9, s70, 1
; GCN-NEXT:    s_lshl_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s2, s2, s9
; GCN-NEXT:    s_and_b32 s2, s2, 3
; GCN-NEXT:    s_or_b32 s2, s2, s8
; GCN-NEXT:    s_and_b32 s2, s2, 15
; GCN-NEXT:    s_or_b32 s2, s2, s7
; GCN-NEXT:    s_and_b32 s2, s2, 0xff
; GCN-NEXT:    s_or_b32 s2, s2, s5
; GCN-NEXT:    s_and_b32 s2, s2, 0xffff
; GCN-NEXT:    s_or_b32 s2, s2, s4
; GCN-NEXT:    s_cmp_lg_u32 s6, 63
; GCN-NEXT:    s_cselect_b32 s4, s69, 1
; GCN-NEXT:    s_lshl_b32 s4, s4, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 62
; GCN-NEXT:    s_cselect_b32 s5, s68, 1
; GCN-NEXT:    s_and_b32 s5, s5, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 2
; GCN-NEXT:    s_or_b32 s4, s4, s5
; GCN-NEXT:    s_cmp_lg_u32 s6, 61
; GCN-NEXT:    s_cselect_b32 s5, s67, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 60
; GCN-NEXT:    s_cselect_b32 s7, s66, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_and_b32 s5, s5, 3
; GCN-NEXT:    s_or_b32 s4, s5, s4
; GCN-NEXT:    s_lshl_b32 s4, s4, 12
; GCN-NEXT:    s_cmp_lg_u32 s6, 59
; GCN-NEXT:    s_cselect_b32 s5, s63, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 58
; GCN-NEXT:    s_cselect_b32 s7, s61, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 2
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmp_lg_u32 s6, 57
; GCN-NEXT:    s_cselect_b32 s7, s59, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 56
; GCN-NEXT:    s_cselect_b32 s8, s58, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 3
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_and_b32 s5, s5, 15
; GCN-NEXT:    s_lshl_b32 s5, s5, 8
; GCN-NEXT:    s_or_b32 s4, s4, s5
; GCN-NEXT:    s_cmp_lg_u32 s6, 55
; GCN-NEXT:    s_cselect_b32 s5, s55, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 54
; GCN-NEXT:    s_cselect_b32 s7, s53, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 2
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmp_lg_u32 s6, 53
; GCN-NEXT:    s_cselect_b32 s7, s51, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 52
; GCN-NEXT:    s_cselect_b32 s8, s50, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 3
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_lshl_b32 s5, s5, 4
; GCN-NEXT:    s_cmp_lg_u32 s6, 51
; GCN-NEXT:    s_cselect_b32 s7, s47, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 50
; GCN-NEXT:    s_cselect_b32 s8, s45, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 2
; GCN-NEXT:    s_or_b32 s7, s7, s8
; GCN-NEXT:    s_cmp_lg_u32 s6, 49
; GCN-NEXT:    s_cselect_b32 s8, s43, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 48
; GCN-NEXT:    s_cselect_b32 s9, s42, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s8, s9, s8
; GCN-NEXT:    s_and_b32 s8, s8, 3
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 15
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_and_b32 s5, s5, 0xff
; GCN-NEXT:    s_or_b32 s4, s5, s4
; GCN-NEXT:    s_lshl_b32 s4, s4, 16
; GCN-NEXT:    s_cmp_lg_u32 s6, 47
; GCN-NEXT:    s_cselect_b32 s5, s65, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 46
; GCN-NEXT:    s_cselect_b32 s7, s64, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 2
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmp_lg_u32 s6, 45
; GCN-NEXT:    s_cselect_b32 s7, s62, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 44
; GCN-NEXT:    s_cselect_b32 s8, s60, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 3
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_lshl_b32 s5, s5, 12
; GCN-NEXT:    s_cmp_lg_u32 s6, 43
; GCN-NEXT:    s_cselect_b32 s7, s57, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 42
; GCN-NEXT:    s_cselect_b32 s8, s56, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 2
; GCN-NEXT:    s_or_b32 s7, s7, s8
; GCN-NEXT:    s_cmp_lg_u32 s6, 41
; GCN-NEXT:    s_cselect_b32 s8, s54, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 40
; GCN-NEXT:    s_cselect_b32 s9, s52, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s8, s9, s8
; GCN-NEXT:    s_and_b32 s8, s8, 3
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 15
; GCN-NEXT:    s_lshl_b32 s7, s7, 8
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmp_lg_u32 s6, 39
; GCN-NEXT:    s_cselect_b32 s7, s49, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 38
; GCN-NEXT:    s_cselect_b32 s8, s48, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 2
; GCN-NEXT:    s_or_b32 s7, s7, s8
; GCN-NEXT:    s_cmp_lg_u32 s6, 37
; GCN-NEXT:    s_cselect_b32 s8, s46, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 36
; GCN-NEXT:    s_cselect_b32 s9, s44, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s8, s9, s8
; GCN-NEXT:    s_and_b32 s8, s8, 3
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_lshl_b32 s7, s7, 4
; GCN-NEXT:    s_cmp_lg_u32 s6, 35
; GCN-NEXT:    s_cselect_b32 s8, s41, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 34
; GCN-NEXT:    s_cselect_b32 s9, s40, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_lshl_b32 s9, s9, 2
; GCN-NEXT:    s_or_b32 s8, s8, s9
; GCN-NEXT:    s_cmp_lg_u32 s6, 32
; GCN-NEXT:    s_cselect_b32 s1, s1, 1
; GCN-NEXT:    s_and_b32 s1, s1, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 33
; GCN-NEXT:    v_readlane_b32 s9, v6, 33
; GCN-NEXT:    s_cselect_b32 s9, s9, 1
; GCN-NEXT:    s_lshl_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s1, s1, s9
; GCN-NEXT:    s_and_b32 s1, s1, 3
; GCN-NEXT:    s_or_b32 s1, s1, s8
; GCN-NEXT:    s_and_b32 s1, s1, 15
; GCN-NEXT:    s_or_b32 s1, s1, s7
; GCN-NEXT:    s_and_b32 s1, s1, 0xff
; GCN-NEXT:    s_or_b32 s1, s1, s5
; GCN-NEXT:    s_and_b32 s1, s1, 0xffff
; GCN-NEXT:    s_or_b32 s1, s1, s4
; GCN-NEXT:    s_cmp_lg_u32 s6, 31
; GCN-NEXT:    v_readlane_b32 s4, v6, 17
; GCN-NEXT:    s_cselect_b32 s4, s4, 1
; GCN-NEXT:    s_lshl_b32 s4, s4, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 30
; GCN-NEXT:    v_readlane_b32 s5, v6, 16
; GCN-NEXT:    s_cselect_b32 s5, s5, 1
; GCN-NEXT:    s_and_b32 s5, s5, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 2
; GCN-NEXT:    s_or_b32 s4, s4, s5
; GCN-NEXT:    s_cmp_lg_u32 s6, 29
; GCN-NEXT:    v_readlane_b32 s5, v6, 15
; GCN-NEXT:    s_cselect_b32 s5, s5, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 28
; GCN-NEXT:    v_readlane_b32 s7, v6, 14
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_and_b32 s5, s5, 3
; GCN-NEXT:    s_or_b32 s4, s5, s4
; GCN-NEXT:    s_lshl_b32 s4, s4, 12
; GCN-NEXT:    s_cmp_lg_u32 s6, 27
; GCN-NEXT:    v_readlane_b32 s5, v6, 13
; GCN-NEXT:    s_cselect_b32 s5, s5, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 26
; GCN-NEXT:    v_readlane_b32 s7, v6, 12
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 2
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmp_lg_u32 s6, 25
; GCN-NEXT:    v_readlane_b32 s7, v6, 11
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 24
; GCN-NEXT:    v_readlane_b32 s8, v6, 10
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 3
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_and_b32 s5, s5, 15
; GCN-NEXT:    s_lshl_b32 s5, s5, 8
; GCN-NEXT:    s_or_b32 s4, s4, s5
; GCN-NEXT:    s_cmp_lg_u32 s6, 23
; GCN-NEXT:    v_readlane_b32 s5, v6, 9
; GCN-NEXT:    s_cselect_b32 s5, s5, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 22
; GCN-NEXT:    v_readlane_b32 s7, v6, 8
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 2
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmp_lg_u32 s6, 21
; GCN-NEXT:    v_readlane_b32 s7, v6, 7
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 20
; GCN-NEXT:    v_readlane_b32 s8, v6, 6
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 3
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_lshl_b32 s5, s5, 4
; GCN-NEXT:    s_cmp_lg_u32 s6, 19
; GCN-NEXT:    v_readlane_b32 s7, v6, 5
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 18
; GCN-NEXT:    v_readlane_b32 s8, v6, 4
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 2
; GCN-NEXT:    s_or_b32 s7, s7, s8
; GCN-NEXT:    s_cmp_lg_u32 s6, 17
; GCN-NEXT:    v_readlane_b32 s8, v6, 3
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 16
; GCN-NEXT:    v_readlane_b32 s9, v6, 2
; GCN-NEXT:    s_cselect_b32 s9, s9, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s8, s9, s8
; GCN-NEXT:    s_and_b32 s8, s8, 3
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 15
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_and_b32 s5, s5, 0xff
; GCN-NEXT:    s_or_b32 s4, s5, s4
; GCN-NEXT:    s_lshl_b32 s4, s4, 16
; GCN-NEXT:    s_cmp_lg_u32 s6, 15
; GCN-NEXT:    v_readlane_b32 s5, v6, 32
; GCN-NEXT:    s_cselect_b32 s5, s5, 1
; GCN-NEXT:    s_lshl_b32 s5, s5, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 14
; GCN-NEXT:    v_readlane_b32 s7, v6, 31
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_and_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 2
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmp_lg_u32 s6, 13
; GCN-NEXT:    v_readlane_b32 s7, v6, 30
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 12
; GCN-NEXT:    v_readlane_b32 s8, v6, 29
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 3
; GCN-NEXT:    s_or_b32 s5, s7, s5
; GCN-NEXT:    s_lshl_b32 s5, s5, 12
; GCN-NEXT:    s_cmp_lg_u32 s6, 11
; GCN-NEXT:    v_readlane_b32 s7, v6, 28
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 10
; GCN-NEXT:    v_readlane_b32 s8, v6, 27
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 2
; GCN-NEXT:    s_or_b32 s7, s7, s8
; GCN-NEXT:    s_cmp_lg_u32 s6, 9
; GCN-NEXT:    v_readlane_b32 s8, v6, 26
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 8
; GCN-NEXT:    v_readlane_b32 s9, v6, 25
; GCN-NEXT:    s_cselect_b32 s9, s9, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s8, s9, s8
; GCN-NEXT:    s_and_b32 s8, s8, 3
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_and_b32 s7, s7, 15
; GCN-NEXT:    s_lshl_b32 s7, s7, 8
; GCN-NEXT:    s_or_b32 s5, s5, s7
; GCN-NEXT:    s_cmp_lg_u32 s6, 7
; GCN-NEXT:    v_readlane_b32 s7, v6, 24
; GCN-NEXT:    s_cselect_b32 s7, s7, 1
; GCN-NEXT:    s_lshl_b32 s7, s7, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 6
; GCN-NEXT:    v_readlane_b32 s8, v6, 23
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_and_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 2
; GCN-NEXT:    s_or_b32 s7, s7, s8
; GCN-NEXT:    s_cmp_lg_u32 s6, 5
; GCN-NEXT:    v_readlane_b32 s8, v6, 22
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 4
; GCN-NEXT:    v_readlane_b32 s9, v6, 21
; GCN-NEXT:    s_cselect_b32 s9, s9, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_or_b32 s8, s9, s8
; GCN-NEXT:    s_and_b32 s8, s8, 3
; GCN-NEXT:    s_or_b32 s7, s8, s7
; GCN-NEXT:    s_lshl_b32 s7, s7, 4
; GCN-NEXT:    s_cmp_lg_u32 s6, 3
; GCN-NEXT:    v_readlane_b32 s8, v6, 20
; GCN-NEXT:    s_cselect_b32 s8, s8, 1
; GCN-NEXT:    s_lshl_b32 s8, s8, 3
; GCN-NEXT:    s_cmp_lg_u32 s6, 2
; GCN-NEXT:    v_readlane_b32 s9, v6, 19
; GCN-NEXT:    s_cselect_b32 s9, s9, 1
; GCN-NEXT:    s_and_b32 s9, s9, 1
; GCN-NEXT:    s_lshl_b32 s9, s9, 2
; GCN-NEXT:    s_or_b32 s8, s8, s9
; GCN-NEXT:    s_cmp_lg_u32 s6, 0
; GCN-NEXT:    s_cselect_b32 s0, s0, 1
; GCN-NEXT:    s_and_b32 s0, s0, 1
; GCN-NEXT:    s_cmp_lg_u32 s6, 1
; GCN-NEXT:    v_readlane_b32 s6, v6, 18
; GCN-NEXT:    s_cselect_b32 s6, s6, 1
; GCN-NEXT:    s_lshl_b32 s6, s6, 1
; GCN-NEXT:    s_or_b32 s0, s0, s6
; GCN-NEXT:    s_and_b32 s0, s0, 3
; GCN-NEXT:    s_or_b32 s0, s0, s8
; GCN-NEXT:    s_and_b32 s0, s0, 15
; GCN-NEXT:    s_or_b32 s0, s0, s7
; GCN-NEXT:    s_and_b32 s0, s0, 0xff
; GCN-NEXT:    s_or_b32 s0, s0, s5
; GCN-NEXT:    s_and_b32 s0, s0, 0xffff
; GCN-NEXT:    s_or_b32 s0, s0, s4
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_readlane_b32 s0, v6, 0
; GCN-NEXT:    v_readlane_b32 s1, v6, 1
; GCN-NEXT:    v_mov_b32_e32 v5, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    v_mov_b32_e32 v3, s3
; GCN-NEXT:    v_mov_b32_e32 v4, s0
; GCN-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; GCN-NEXT:    s_endpgm
entry:
  %v = insertelement <128 x i1> %vec, i1 1, i32 %sel
  store <128 x i1> %v, ptr addrspace(1) %out
  ret void
}

define amdgpu_ps <32 x float> @float32_inselt_vec(<32 x float> %vec, i32 %sel) {
; GCN-LABEL: float32_inselt_vec:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 1, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[0:1], 2, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[2:3], 3, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[4:5], 4, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[6:7], 5, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[8:9], 6, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[10:11], 7, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[12:13], 8, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[14:15], 9, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[16:17], 10, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[18:19], 11, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[20:21], 12, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[22:23], 13, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[24:25], 14, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[26:27], 15, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[28:29], 16, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[30:31], 17, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[34:35], 18, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[36:37], 19, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[38:39], 20, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[40:41], 21, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[42:43], 22, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[44:45], 23, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[46:47], 24, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[48:49], 25, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[50:51], 26, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[52:53], 27, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[54:55], 28, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[56:57], 29, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[58:59], 30, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[60:61], 31, v32
; GCN-NEXT:    v_cmp_ne_u32_e64 s[62:63], 0, v32
; GCN-NEXT:    v_cndmask_b32_e64 v0, 1.0, v0, s[62:63]
; GCN-NEXT:    v_cndmask_b32_e32 v1, 1.0, v1, vcc
; GCN-NEXT:    v_cndmask_b32_e64 v2, 1.0, v2, s[0:1]
; GCN-NEXT:    v_cndmask_b32_e64 v3, 1.0, v3, s[2:3]
; GCN-NEXT:    v_cndmask_b32_e64 v4, 1.0, v4, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e64 v5, 1.0, v5, s[6:7]
; GCN-NEXT:    v_cndmask_b32_e64 v6, 1.0, v6, s[8:9]
; GCN-NEXT:    v_cndmask_b32_e64 v7, 1.0, v7, s[10:11]
; GCN-NEXT:    v_cndmask_b32_e64 v8, 1.0, v8, s[12:13]
; GCN-NEXT:    v_cndmask_b32_e64 v9, 1.0, v9, s[14:15]
; GCN-NEXT:    v_cndmask_b32_e64 v10, 1.0, v10, s[16:17]
; GCN-NEXT:    v_cndmask_b32_e64 v11, 1.0, v11, s[18:19]
; GCN-NEXT:    v_cndmask_b32_e64 v12, 1.0, v12, s[20:21]
; GCN-NEXT:    v_cndmask_b32_e64 v13, 1.0, v13, s[22:23]
; GCN-NEXT:    v_cndmask_b32_e64 v14, 1.0, v14, s[24:25]
; GCN-NEXT:    v_cndmask_b32_e64 v15, 1.0, v15, s[26:27]
; GCN-NEXT:    v_cndmask_b32_e64 v16, 1.0, v16, s[28:29]
; GCN-NEXT:    v_cndmask_b32_e64 v17, 1.0, v17, s[30:31]
; GCN-NEXT:    v_cndmask_b32_e64 v18, 1.0, v18, s[34:35]
; GCN-NEXT:    v_cndmask_b32_e64 v19, 1.0, v19, s[36:37]
; GCN-NEXT:    v_cndmask_b32_e64 v20, 1.0, v20, s[38:39]
; GCN-NEXT:    v_cndmask_b32_e64 v21, 1.0, v21, s[40:41]
; GCN-NEXT:    v_cndmask_b32_e64 v22, 1.0, v22, s[42:43]
; GCN-NEXT:    v_cndmask_b32_e64 v23, 1.0, v23, s[44:45]
; GCN-NEXT:    v_cndmask_b32_e64 v24, 1.0, v24, s[46:47]
; GCN-NEXT:    v_cndmask_b32_e64 v25, 1.0, v25, s[48:49]
; GCN-NEXT:    v_cndmask_b32_e64 v26, 1.0, v26, s[50:51]
; GCN-NEXT:    v_cndmask_b32_e64 v27, 1.0, v27, s[52:53]
; GCN-NEXT:    v_cndmask_b32_e64 v28, 1.0, v28, s[54:55]
; GCN-NEXT:    v_cndmask_b32_e64 v29, 1.0, v29, s[56:57]
; GCN-NEXT:    v_cndmask_b32_e64 v30, 1.0, v30, s[58:59]
; GCN-NEXT:    v_cndmask_b32_e64 v31, 1.0, v31, s[60:61]
; GCN-NEXT:    ; return to shader part epilog
entry:
  %v = insertelement <32 x float> %vec, float 1.000000e+00, i32 %sel
  ret <32 x float> %v
}

define <8 x double> @double8_inselt_vec(<8 x double> %vec, i32 %sel) {
; GCN-LABEL: double8_inselt_vec:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 0, v16
; GCN-NEXT:    v_mov_b32_e32 v17, 0x3ff00000
; GCN-NEXT:    v_cndmask_b32_e64 v0, v0, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v1, v1, v17, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v16
; GCN-NEXT:    v_cndmask_b32_e64 v2, v2, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v17, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 2, v16
; GCN-NEXT:    v_cndmask_b32_e64 v4, v4, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v5, v5, v17, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 3, v16
; GCN-NEXT:    v_cndmask_b32_e64 v6, v6, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v7, v7, v17, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 4, v16
; GCN-NEXT:    v_cndmask_b32_e64 v8, v8, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v9, v9, v17, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 5, v16
; GCN-NEXT:    v_cndmask_b32_e64 v10, v10, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v11, v11, v17, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 6, v16
; GCN-NEXT:    v_cndmask_b32_e64 v12, v12, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v13, v13, v17, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 7, v16
; GCN-NEXT:    v_cndmask_b32_e64 v14, v14, 0, vcc
; GCN-NEXT:    v_cndmask_b32_e32 v15, v15, v17, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
entry:
  %v = insertelement <8 x double> %vec, double 1.000000e+00, i32 %sel
  ret <8 x double> %v
}
