; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx700 < %s | FileCheck -check-prefix=GFX7 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx803 < %s | FileCheck -check-prefix=GFX8 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefixes=GFX9,GFX900 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx950 < %s | FileCheck -check-prefixes=GFX9,GFX950 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1030 < %s | FileCheck -check-prefix=GFX10 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-FAKE16 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1200 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-TRUE16 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1200 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX12,GFX12-FAKE16 %s

define bfloat @v_maximumnum_bf16(bfloat %x, bfloat %y) {
; GFX7-LABEL: v_maximumnum_bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_bf16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v2, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_bf16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v2, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v0.h, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v0.h, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v1.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v1.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v2.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_bf16:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v1.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v0.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v0.h, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v1.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v1.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v2.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_bf16:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call bfloat @llvm.maximumnum.bf16(bfloat %x, bfloat %y)
  ret bfloat %result
}

define bfloat @v_maximumnum_bf16_nnan(bfloat %x, bfloat %y) {
; GFX7-LABEL: v_maximumnum_bf16_nnan:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_bf16_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_bf16_nnan:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_bf16_nnan:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_bf16_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_bf16_nnan:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v1.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v2.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_bf16_nnan:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_lshlrev_b32 v3, 16, v2
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_bf16_nnan:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v1.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v2.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_bf16_nnan:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v2, v0 :: v_dual_lshlrev_b32 v3, 16, v2
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan bfloat @llvm.maximumnum.bf16(bfloat %x, bfloat %y)
  ret bfloat %result
}

define <2 x bfloat> @v_maximumnum_v2bf16(<2 x bfloat> %x, <2 x bfloat> %y) {
; GFX7-LABEL: v_maximumnum_v2bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_v2bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX8-NEXT:    v_cndmask_b32_sdwa v3, v0, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v2
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v2, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v4, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_v2bf16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX900-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX900-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX900-NEXT:    v_cndmask_b32_sdwa v3, v0, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v2
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v2, v3, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v4, v3, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX900-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v2, v0, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_v2bf16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX950-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX950-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX950-NEXT:    v_cndmask_b32_sdwa v3, v0, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX950-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v2
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v2, v3, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v4, v3, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_perm_b32 v0, v2, v0, s0
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v2bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX10-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX10-NEXT:    v_cndmask_b32_sdwa v6, v0, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v2, v6, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v7
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v3, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v5, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc_lo
; GFX10-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_v2bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v3, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v4, v4
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v5, v5
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v0.h, v1.h, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v1.h, v2.l, s1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v0.l, s2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v3.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v4, v6
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v5, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v3.l, v2.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v1.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v5.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v2.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v3.l, s1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v6
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v0.h, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_v2bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v4, v3 :: v_dual_lshlrev_b32 v5, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v2, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v1, v0 :: v_dual_lshlrev_b32 v4, 16, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v4, v5
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v3, v2 :: v_dual_lshlrev_b32 v7, 16, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v1, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_lshlrev_b32 v7, 16, v5
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_v2bf16:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v3, v3
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v4, v4
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v5, v5
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v0.h, v1.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s0
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v1.h, v2.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v0.l, s2
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v2.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v3.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v1.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v3.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v4, v6
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v5, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v3.l, v2.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v1.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v4.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v5.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v2.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v3.l, s1
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v6
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v0.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_v2bf16:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v4, v3 :: v_dual_lshlrev_b32 v5, 16, v0
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v2, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v1, v0 :: v_dual_lshlrev_b32 v4, 16, v2
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v4, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v3, v2 :: v_dual_lshlrev_b32 v7, 16, v1
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v7
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_lshlrev_b32 v7, 16, v5
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x bfloat> @llvm.maximumnum.v2bf16(<2 x bfloat> %x, <2 x bfloat> %y)
  ret <2 x bfloat> %result
}

define <2 x bfloat> @v_maximumnum_v2bf16_nnan(<2 x bfloat> %x, <2 x bfloat> %y) {
; GFX7-LABEL: v_maximumnum_v2bf16_nnan:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_v2bf16_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX8-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX8-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_sdwa v0, v3, v0, vcc dst_sel:WORD_1 dst_unused:UNUSED_PAD src0_sel:DWORD src1_sel:DWORD
; GFX8-NEXT:    v_or_b32_sdwa v0, v2, v0 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_v2bf16_nnan:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX900-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX900-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX900-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX900-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v0, v2, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_v2bf16_nnan:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v2
; GFX950-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX950-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX950-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX950-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX950-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_perm_b32 v0, v0, v2, s0
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v2bf16_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX10-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX10-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v7, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v3, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v5, v7, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX10-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_v2bf16_nnan:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v0.h
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.h
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v5, v4
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v1.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v1.h, v0.h, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v1.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v2.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v3.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, v0.h, s1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v1.h, s2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v5
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, v0.h, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_v2bf16_nnan:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v7, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v3, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v5, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_v2bf16_nnan:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v0.h
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.h
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v2
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v5, v4
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v1.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v1.h, v0.h, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v1.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v2.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v3.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, v0.h, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v1.h, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v5
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, v0.h, s0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_v2bf16_nnan:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v4
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v7, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v3, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v5, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan <2 x bfloat> @llvm.maximumnum.v2bf16(<2 x bfloat> %x, <2 x bfloat> %y)
  ret <2 x bfloat> %result
}

define <3 x bfloat> @v_maximumnum_v3bf16(<3 x bfloat> %x, <3 x bfloat> %y) {
; GFX7-LABEL: v_maximumnum_v3bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v5
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v4
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_v3bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX8-NEXT:    v_cndmask_b32_sdwa v5, v0, v4, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v3, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_v3bf16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX900-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX900-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX900-NEXT:    v_cndmask_b32_sdwa v5, v0, v4, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v3, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v4, v0, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_v3bf16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX950-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX950-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX950-NEXT:    v_cndmask_b32_sdwa v5, v0, v4, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX950-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v7
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v3, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_perm_b32 v0, v4, v0, s0
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v3bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v2
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v3
; GFX10-NEXT:    v_cndmask_b32_sdwa v10, v0, v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v5, v10, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v4, v10, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v3, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v5, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v8, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v5, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v7, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v7, v1, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_v3bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v6, v6
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v8, v8
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v5, v5
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v0.h, v2.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v9, v9
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v2.h, v4.l, s1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v4.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v1.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v8
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v4.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v7, v10
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s3, v9, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v5.l, v4.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v3.l, v1.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v5.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v2.l, v0.l, s3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v4.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v7.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v7.l, v1.l, s2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v8.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v5.l, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v8.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v4
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v5
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v9
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v0.h, s1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v8.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v7.l, v1.l, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_v3bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v6, v5 :: v_dual_and_b32 v7, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v4 :: v_dual_lshlrev_b32 v6, 16, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v2 :: v_dual_lshlrev_b32 v9, 16, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v8, v10
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v5, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v1 :: v_dual_lshlrev_b32 v10, 16, v6
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v4, v5 :: v_dual_lshlrev_b32 v7, 16, v0
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v10
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v3, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v6, v1 :: v_dual_lshlrev_b32 v2, 16, v6
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v4, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc_lo
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_v3bf16:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v3
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v2
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v6, v6
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v8, v8
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v5, v5
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v0.h, v2.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v9, v9
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s2
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v2.h, v4.l, s1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v4.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v1.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v5.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v3.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v2.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v8
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v4.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v7, v10
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s3, v9, v11
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v5.l, v4.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v3.l, v1.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v5.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v2.l, v0.l, s3
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v4.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v6.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v7.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v7.l, v1.l, s2
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v8.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v5.l, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v8.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v4
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v5
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v9
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v0.h, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v8.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v7.l, v1.l, s0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_v3bf16:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v6, v5 :: v_dual_and_b32 v7, 0xffff0000, v2
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v4 :: v_dual_lshlrev_b32 v6, 16, v1
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v2 :: v_dual_lshlrev_b32 v9, 16, v3
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v2
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v8, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v5, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v1 :: v_dual_lshlrev_b32 v10, 16, v6
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v4, v5 :: v_dual_lshlrev_b32 v7, 16, v0
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v8
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v7
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v6, v1 :: v_dual_lshlrev_b32 v2, 16, v6
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v4, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc_lo
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call <3 x bfloat> @llvm.maximumnum.v3bf16(<3 x bfloat> %x, <3 x bfloat> %y)
  ret <3 x bfloat> %result
}

define <3 x bfloat> @v_maximumnum_v3bf16_nnan(<3 x bfloat> %x, <3 x bfloat> %y) {
; GFX7-LABEL: v_maximumnum_v3bf16_nnan:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v5
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v4
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_v3bf16_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v3, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX8-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v5, 16, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v6, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v3, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v6, vcc
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_v3bf16_nnan:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v3, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX900-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v3, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v4, v2, vcc
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX900-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX900-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX900-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX900-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v2, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v0, v3, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_v3bf16_nnan:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX950-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v3, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v3, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v4, v2, vcc
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX950-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX950-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GFX950-NEXT:    v_and_b32_e32 v4, 0xffff0000, v2
; GFX950-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v2, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX950-NEXT:    v_perm_b32 v0, v0, v3, s0
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v3bf16_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX10-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX10-NEXT:    v_and_b32_e32 v9, 0xffff0000, v0
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v6
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 16, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v3, v1, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v8
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v11, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v5, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v7, v11, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v5, v7, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_v3bf16_nnan:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v4
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v1.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v7, v6
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v3.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s3, v9, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v3.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v2.l, v0.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v0.h
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v2.h, v0.h, s3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v4.l, v1.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v5.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v6.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v0.h, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v2.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v2.h, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v8
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v0.h, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v4.l, v1.l, s1
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_v3bf16_nnan:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v3, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v8
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v11, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v5, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v7, v11, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v5, v7 :: v_dual_lshlrev_b32 v9, 16, v4
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_v3bf16_nnan:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v0
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v4
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v1.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v7, v6
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v3.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s3, v9, v8
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v3.l, v1.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v2.l, v0.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v0.h
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v2.h, v0.h, s3
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v4.l, v1.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v4.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v5.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v6.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v8
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v0.h, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v2.h
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v2.h, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v8
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v0.h, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v4.l, v1.l, s1
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_v3bf16_nnan:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v6
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v11, v10, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v5, v10, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v7, v11, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v5, v7 :: v_dual_lshlrev_b32 v9, 16, v4
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan <3 x bfloat> @llvm.maximumnum.v3bf16(<3 x bfloat> %x, <3 x bfloat> %y)
  ret <3 x bfloat> %result
}

define <4 x bfloat> @v_maximumnum_v4bf16(<4 x bfloat> %x, <4 x bfloat> %y) {
; GFX7-LABEL: v_maximumnum_v4bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v6
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v7, 1.0, v7
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v3, v3, v7
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v5
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_v4bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v7, 0xffff0000, v3
; GFX8-NEXT:    v_cndmask_b32_sdwa v5, v1, v4, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v7, v6, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v6, v5, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v6, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v5, v6, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v1
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v3, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_v4bf16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX900-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX900-NEXT:    v_and_b32_e32 v7, 0xffff0000, v3
; GFX900-NEXT:    v_cndmask_b32_sdwa v5, v1, v4, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX900-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX900-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX900-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v7, v6, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v6, v5, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v6, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v5, v6, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v1
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v3, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v5, v0, s4
; GFX900-NEXT:    v_perm_b32 v1, v4, v1, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_v4bf16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX950-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX950-NEXT:    v_and_b32_e32 v7, 0xffff0000, v3
; GFX950-NEXT:    v_cndmask_b32_sdwa v5, v1, v4, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX950-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v7
; GFX950-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX950-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX950-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v7, v6, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v6, v5, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v8
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v6, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v5, v6, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v6
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v3, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX950-NEXT:    v_perm_b32 v1, v4, v1, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_perm_b32 v0, v5, v0, s0
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v4bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 16, v0
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 16, v0
; GFX10-NEXT:    v_and_b32_e32 v9, 0xffff0000, v2
; GFX10-NEXT:    v_cndmask_b32_sdwa v10, v1, v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v12, 16, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v5, v10, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v8, v7, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v8, v14
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v5, v10, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v7, v4, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v8, v10, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 16, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v9, v5, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v7, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v8, v5, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v8, v9
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v3, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v4, v7, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v8, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_perm_b32 v0, v4, v0, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v8, v1, vcc_lo
; GFX10-NEXT:    v_perm_b32 v1, v5, v1, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_v4bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v5, v5
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v6, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v8, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v1.h, v3.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v0.h, v2.h, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v3.h, v4.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v4.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s4, v10, v10
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s3, v9, v9
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v11, v11
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v2.h, v6.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s4
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v6.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v4.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v1.l, s3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v10, v8
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v1.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v0.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v5.l, v4.l, s2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v3.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v2.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v9, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v8.l, v4.l, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v15
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v7.l, v6.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v8.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v11, v12
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v7.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v4.l, v6.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v14
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v5.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v4.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v3.l, v1.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v2.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v10
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v1.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.h, v1.h, v7.l, s2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v5.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v5.l, v1.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v3.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v10
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v8.l, v0.h, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v2.h, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v5.l, v1.l, s1
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_v4bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v8, 16, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v6, v5 :: v_dual_and_b32 v7, 0xffff0000, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v5, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v10, v11
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v5, v4 :: v_dual_and_b32 v9, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v8, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v10, v4 :: v_dual_lshlrev_b32 v13, 16, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v7, v6 :: v_dual_lshlrev_b32 v14, 16, v0
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v4, v5 :: v_dual_lshlrev_b32 v9, 16, v7
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v10
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v0
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v10, v4 :: v_dual_lshlrev_b32 v5, 16, v6
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v7, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v5, v6, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v3, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v2
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v10
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v8, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v2 :: v_dual_lshlrev_b32 v3, 16, v7
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v6 :: v_dual_lshlrev_b32 v2, 16, v8
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v8, v1, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_v4bf16:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v5, v5
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v6, v6
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v8, v8
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v1.h, v3.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v0.h, v2.h, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v3
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v2
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v3.h, v4.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v4.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s4, v10, v10
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s3, v9, v9
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v11, v11
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v5.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v2.h, v6.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s4
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v6.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v4.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v1.l, s3
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v10, v8
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v7.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v1.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v0.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v5.l, v4.l, s2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v3.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v2.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v9, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v12
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v8.l, v4.l, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v15
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v7.l, v6.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v5.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v8.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v11, v12
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v7.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v4.l, v6.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v13
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v14
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v5.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v4.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v3.l, v1.l, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v2.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v10
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v1.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.h, v1.h, v7.l, s2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v6.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v5.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v5.l, v1.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v3.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v10
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v8.l, v0.h, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v2.h, s2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v5.l, v1.l, s1
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_v4bf16:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v8, 16, v0
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v1
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v6, v5 :: v_dual_and_b32 v7, 0xffff0000, v3
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v5, v4, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v5
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v10, v11
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v5, v4 :: v_dual_and_b32 v9, 0xffff0000, v2
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v8, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v10, v4 :: v_dual_lshlrev_b32 v13, 16, v3
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v7, v6 :: v_dual_lshlrev_b32 v14, 16, v0
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v4, v5 :: v_dual_lshlrev_b32 v9, 16, v7
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v10
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v10, v4 :: v_dual_lshlrev_b32 v5, 16, v6
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v9
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v7, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v5, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v8
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v2
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v8, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v2 :: v_dual_lshlrev_b32 v3, 16, v7
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v6 :: v_dual_lshlrev_b32 v2, 16, v8
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v8, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x bfloat> @llvm.maximumnum.v4bf16(<4 x bfloat> %x, <4 x bfloat> %y)
  ret <4 x bfloat> %result
}

define <4 x bfloat> @v_maximumnum_v4bf16_nnan(<4 x bfloat> %x, <4 x bfloat> %y) {
; GFX7-LABEL: v_maximumnum_v4bf16_nnan:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v6
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v7, 1.0, v7
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v3, v3, v7
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v5
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_v4bf16_nnan:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v4, 0xffff0000, v3
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v7, v6, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v4, v6, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v3, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-NEXT:    v_and_b32_e32 v3, 0xffff0000, v2
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v7, v6, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v3, v6, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v5, v7, vcc
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v5, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_v4bf16_nnan:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v3, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v4, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v5, v3, vcc
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX900-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX900-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX900-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX900-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v3, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v3, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v5, v2, vcc
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v5, vcc
; GFX900-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX900-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX900-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX900-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v2, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v0, v3, s4
; GFX900-NEXT:    v_perm_b32 v1, v1, v4, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_v4bf16_nnan:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX950-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v3, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v4, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v5, v3, vcc
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX950-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX950-NEXT:    v_lshrrev_b32_e32 v1, 16, v1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX950-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX950-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v3, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v3
; GFX950-NEXT:    v_perm_b32 v1, v1, v4, s0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v3, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v5, v2, vcc
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX950-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX950-NEXT:    v_lshrrev_b32_e32 v0, 16, v0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v5, vcc
; GFX950-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX950-NEXT:    v_lshrrev_b32_e32 v2, 16, v2
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v2, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc
; GFX950-NEXT:    v_perm_b32 v0, v0, v3, s0
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v4bf16_nnan:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX10-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v2
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v4
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 16, v0
; GFX10-NEXT:    v_and_b32_e32 v11, 0xffff0000, v2
; GFX10-NEXT:    v_and_b32_e32 v12, 0xffff0000, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v3, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v6
; GFX10-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v5, v8, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v10, v9
; GFX10-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v6, v8, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v4, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v8, v5, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v9, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v7
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v9, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v6, v5, vcc_lo
; GFX10-NEXT:    v_perm_b32 v1, v3, v1, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_v4bf16_nnan:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v5, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s4, v7, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v3.l, v1.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v3.h, v1.h, s4
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s4, v6, v8
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.h
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v4.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v4.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v10, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v2.l, v0.l, s4
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v0.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v2.h, v0.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v5.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.h
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v8
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v3.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s3, 0, v3.h
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v5.l, v1.h, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, v0.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.h
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v1.h, v3.h, s3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v2.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v4.l, v1.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, v0.h, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v5.l, v1.h, s2
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_v4bf16_nnan:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v3, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v1, v3 :: v_dual_lshlrev_b32 v10, 16, v0
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v5, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v4, v1 :: v_dual_and_b32 v12, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v10, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v6, v8, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v11
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v4, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v8, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v9, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v7
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v4 :: v_dual_lshlrev_b32 v4, 16, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v9, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v6, v5, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v3, v1, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_v4bf16_nnan:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v5, v4
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v0
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s4, v7, v6
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v3.l, v1.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v3.h, v1.h, s4
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s4, v6, v8
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.h
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v4.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v4.l, v1.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v10, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v2.l, v0.l, s4
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v0.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v2.h, v0.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v5.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.h
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v8
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v6.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v3.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s3, 0, v3.h
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v5.l, v1.h, s2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v2.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, v0.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.h
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v1.h, v3.h, s3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v8
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v2.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v7
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v4.l, v1.l, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v3.l, v0.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v5.l, v1.h, s2
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_v4bf16_nnan:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v2
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v4
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v4, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v1, v3 :: v_dual_lshlrev_b32 v10, 16, v0
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v6
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v5, v8, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v4, v1 :: v_dual_and_b32 v12, 0xffff0000, v0
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v10, v9
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff0000, v2
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v6, v8, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v11
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v4, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v8, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v9, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v7
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v4 :: v_dual_lshlrev_b32 v4, 16, v6
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v9, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v6, v5, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX12-FAKE16-NEXT:    v_perm_b32 v1, v3, v1, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call nnan <4 x bfloat> @llvm.maximumnum.v4bf16(<4 x bfloat> %x, <4 x bfloat> %y)
  ret <4 x bfloat> %result
}

define <6 x bfloat> @v_maximumnum_v6bf16(<6 x bfloat> %x, <6 x bfloat> %y) {
; GFX7-LABEL: v_maximumnum_v6bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v6
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v7, 1.0, v7
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v8, 1.0, v8
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v9, 1.0, v9
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v10, 1.0, v10
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_mul_f32_e32 v11, 1.0, v11
; GFX7-NEXT:    v_and_b32_e32 v11, 0xffff0000, v11
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    v_and_b32_e32 v10, 0xffff0000, v10
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v9, 0xffff0000, v9
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v5, v5, v11
; GFX7-NEXT:    v_max_f32_e32 v4, v4, v10
; GFX7-NEXT:    v_max_f32_e32 v3, v3, v9
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v8
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v7
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v6
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_v6bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 16, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_and_b32_e32 v9, 0xffff0000, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v8, v7, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v7, v6, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v7
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v8, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v7, v6, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v8, v6, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v8
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v7
; GFX8-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v8, v6, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v8, 16, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX8-NEXT:    v_and_b32_e32 v10, 0xffff0000, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v9, v8, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v8, v7, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v7
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 16, v8
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v9, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v8, v7, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v9, v7, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v7, v8, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v8
; GFX8-NEXT:    v_and_b32_e32 v8, 0xffff0000, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v9, v7, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 16, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 16, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX8-NEXT:    v_and_b32_e32 v11, 0xffff0000, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v10, v9, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v9, v8, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 16, v8
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 16, v9
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v10, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v9, v8, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v10, v8, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v10
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v9
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v10, v8, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v5, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 16, v2
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v10, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v5, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v9, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v9
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v9, v2, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v9, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v4, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v3, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v8
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_v6bf16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX900-NEXT:    v_lshrrev_b32_e32 v7, 16, v5
; GFX900-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX900-NEXT:    v_and_b32_e32 v9, 0xffff0000, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v8, v7, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v7, v6, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX900-NEXT:    v_lshlrev_b32_e32 v9, 16, v7
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v8, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v7, v6, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v8, v6, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v8
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v7
; GFX900-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v8, v6, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v8, 16, v4
; GFX900-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX900-NEXT:    v_and_b32_e32 v10, 0xffff0000, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v9, v8, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v8, v7, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v9, 16, v7
; GFX900-NEXT:    v_lshlrev_b32_e32 v10, 16, v8
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v9, v10
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v8, v7, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v9, v7, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v7, v8, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v8
; GFX900-NEXT:    v_and_b32_e32 v8, 0xffff0000, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v9, v7, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v9, 16, v3
; GFX900-NEXT:    v_lshrrev_b32_e32 v10, 16, v0
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX900-NEXT:    v_and_b32_e32 v11, 0xffff0000, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v10, v9, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v9, v8, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v10, 16, v8
; GFX900-NEXT:    v_lshlrev_b32_e32 v11, 16, v9
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v10, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v9, v8, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v10, v8, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v9, 16, v10
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v9
; GFX900-NEXT:    v_lshlrev_b32_e32 v9, 16, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v10, v8, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX900-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v5, v2, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v10, 16, v2
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v10, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v5, v2, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v9, v2, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v9
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v9, v2, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v4, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX900-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v9, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v4, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX900-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX900-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v0, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v3, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v8, v0, s4
; GFX900-NEXT:    v_perm_b32 v1, v7, v1, s4
; GFX900-NEXT:    v_perm_b32 v2, v6, v2, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_v6bf16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX950-NEXT:    v_lshrrev_b32_e32 v7, 16, v5
; GFX950-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX950-NEXT:    v_and_b32_e32 v9, 0xffff0000, v5
; GFX950-NEXT:    v_and_b32_e32 v10, 0xffff0000, v4
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v8, v7, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX950-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX950-NEXT:    v_and_b32_e32 v11, 0xffff0000, v3
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v7, v6, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v9, 16, v7
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v8, v9
; GFX950-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; GFX950-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v7, v6, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v8, v6, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v8
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v7
; GFX950-NEXT:    v_and_b32_e32 v7, 0xffff0000, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v8, v6, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v8, 16, v4
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v9, v8, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX950-NEXT:    v_lshlrev_b32_e32 v9, 16, v7
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v8, v7, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v10, 16, v8
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v9, v10
; GFX950-NEXT:    v_lshrrev_b32_e32 v10, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v8, v7, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v9, v7, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v7, v8, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v8
; GFX950-NEXT:    v_and_b32_e32 v8, 0xffff0000, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v9, v7, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v9, 16, v3
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v10, v9, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX950-NEXT:    v_lshlrev_b32_e32 v10, 16, v8
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v9, v8, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v11, 16, v9
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v10, v11
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v10, v9, v8, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v10, v8, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v9, 16, v10
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v9
; GFX950-NEXT:    v_lshlrev_b32_e32 v9, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v10, v8, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX950-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX950-NEXT:    v_lshlrev_b32_e32 v10, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v5, v2, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v10, v9
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v5, v2, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v9, v2, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v9
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v9, v2, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX950-NEXT:    v_perm_b32 v2, v6, v2, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v4, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v9, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v4, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX950-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX950-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX950-NEXT:    v_perm_b32 v1, v7, v1, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v0, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v4
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v3, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc
; GFX950-NEXT:    v_perm_b32 v0, v8, v0, s0
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v6bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 16, v5
; GFX10-NEXT:    v_and_b32_e32 v8, 0xffff0000, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 16, v4
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 16, v1
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX10-NEXT:    v_and_b32_e32 v13, 0xffff0000, v0
; GFX10-NEXT:    v_and_b32_e32 v11, 0xffff0000, v4
; GFX10-NEXT:    v_lshrrev_b32_e32 v14, 16, v3
; GFX10-NEXT:    v_cndmask_b32_sdwa v12, v2, v7, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX10-NEXT:    v_lshrrev_b32_e32 v15, 16, v0
; GFX10-NEXT:    v_and_b32_e32 v8, 0xffff0000, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v7, v12, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v16, 16, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v10, v9, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 16, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v13, v15, v14, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v15, 16, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v9, v6, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v10, v16
; GFX10-NEXT:    v_lshlrev_b32_e32 v16, 16, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v7, v12, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v12, v10, v12, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v14, v13, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v12, v7, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v16
; GFX10-NEXT:    v_lshlrev_b32_e32 v12, 16, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v9, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v14
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v10, v7, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v11, v6, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v15, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v12, 16, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v8, v13, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v6, v9, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v10, v13, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v11, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v9, v8, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v10, v8, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 16, v1
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v5, v2, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v12, 16, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v4, v1, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v0, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v9
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v5, v2, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v4, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v9, v2, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v13, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v3, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v10, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v11, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v10
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v10, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v5
; GFX10-NEXT:    v_perm_b32 v1, v6, v1, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v11, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_perm_b32 v0, v8, v0, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v9, v2, vcc_lo
; GFX10-NEXT:    v_perm_b32 v2, v7, v2, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_v6bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v5
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v7, v7
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff0000, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v9, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v2.h, v5.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v5
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v10, v10
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v5.h, v6.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v1.h, v4.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v6.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v12, v12
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v7.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v9.l, v4.h, v8.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v13, v13
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v8.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v9.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v5.l, s0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v10.l, v0.h, v3.h, s2
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v13, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v14
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s3, 0, v8.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v6.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s4, 0, v9.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v11.l, v7.l, v6.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v12, v13
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v12.l, v3.h, v10.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v10.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v11.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v13.l, v9.l, v8.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v16.l, v12.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.h, v11.l, v6.l, s2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v15
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.h, v13.l, v8.l, s3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v13.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.h, v2.h, v7.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.h, v5.h, v9.l, s4
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v0
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v2.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v8, v8
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v9, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v15
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v14, v16
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.h, v11.l, v2.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v2.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v4.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v8, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v3.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v9, v9
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v12.l, v10.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v10.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v4.l, v1.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v0.l, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v10.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v1.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v11, v7
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v3.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v0.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v12.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v6.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v5.l, v2.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v12.l, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v10, v9
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v7.l, v2.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v14, v11
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v7.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s3, 0, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v4.l, v1.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v1.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v3.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v2.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v2.l, v1.l, s1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v8.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v4.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v8.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.h, v1.h, v5.l, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v4.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v3.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v10
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v11
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v9
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v13.l, v5.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v0.h, s3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v8.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v2.l, v1.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v7.l, v3.h, s2
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_v6bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v14, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v15, 16, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v8, v7, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 16, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v7, v6, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff0000, v4
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v8, v10, v9 :: v_dual_lshlrev_b32 v13, 16, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v12, 16, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v7, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v8
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v9, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v10, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v12, v15, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff0000, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v10
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v15, v12 :: v_dual_lshlrev_b32 v14, 16, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v14
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v12
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v9, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v6, v10, v6 :: v_dual_lshlrev_b32 v13, 16, v11
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v8, v11, v8 :: v_dual_lshlrev_b32 v15, 16, v7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v14, v15
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v7, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v10, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v11, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v9, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v10, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v2 :: v_dual_lshlrev_b32 v10, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v4
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v3 :: v_dual_lshlrev_b32 v11, 16, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v0 :: v_dual_lshlrev_b32 v12, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v9
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v5, v2 :: v_dual_lshlrev_b32 v10, 16, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v10
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v4, v1 :: v_dual_lshlrev_b32 v11, 16, v3
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v9, v2 :: v_dual_lshlrev_b32 v13, 16, v0
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v13, v11
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v3, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v10, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v11, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v1, v4 :: v_dual_lshlrev_b32 v4, 16, v10
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v3 :: v_dual_lshlrev_b32 v3, 16, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v11
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v10, v1, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v11, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v7, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v9, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v8, v1, 0x5040100
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v6, v2, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_v6bf16:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v5
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v1
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v4
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v7, v7
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff0000, v3
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v9, v9
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v2.h, v5.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v5
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v10, v10
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v5.h, v6.l, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v1.h, v4.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v6.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v12, v12
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v7.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v9.l, v4.h, v8.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v13, v13
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v8.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v9.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v5.l, s0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v10.l, v0.h, v3.h, s2
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v13, v11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v14
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s3, 0, v8.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v6.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s4, 0, v9.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v11.l, v7.l, v6.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v12, v13
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v12.l, v3.h, v10.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v10.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v11.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v13.l, v9.l, v8.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v16.l, v12.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.h, v11.l, v6.l, s2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v15
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.h, v13.l, v8.l, s3
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v13.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.h, v2.h, v7.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.h, v5.h, v9.l, s4
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v0
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v2.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v8, v8
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v9, v9
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v3
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v15
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v14, v16
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.h, v11.l, v2.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v5.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v2.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v4.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v8, v8
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v3.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v9, v9
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v12.l, v10.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v10.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v4.l, v1.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v0.l, s2
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v10.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v1.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v11, v7
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v4.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v3.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v0.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v12.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v6.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v5.l, v2.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v2.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v12.l, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v10, v9
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v7.l, v2.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v14, v11
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v7.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s3, 0, v8
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v4.l, v1.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v3.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v5.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v2.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v2.l, v1.l, s1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v8.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v4.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v8.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.h, v1.h, v5.l, s2
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v4.l, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v3.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v10
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v11
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v9
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v13.l, v5.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v0.h, s3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v8.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v2.l, v1.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v7.l, v3.h, s2
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_v6bf16:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v5
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v1
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v14, 0xffff0000, v0
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v5
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v15, 16, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v8, v7, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 16, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v7, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff0000, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v8, v10, v9 :: v_dual_lshlrev_b32 v13, 16, v7
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v13
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v12, 16, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v7, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v9, v8, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v10, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v12, v15, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff0000, v3
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v15, v12 :: v_dual_lshlrev_b32 v14, 16, v9
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v14
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v12
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v9, v8, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v6, v10, v6 :: v_dual_lshlrev_b32 v13, 16, v11
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v8, v11, v8 :: v_dual_lshlrev_b32 v15, 16, v7
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v14, v15
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v7, v12, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v10, v12, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v11, v8, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v9, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v11
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v10, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v2 :: v_dual_lshlrev_b32 v10, 16, v1
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v3 :: v_dual_lshlrev_b32 v11, 16, v2
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v3
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v0 :: v_dual_lshlrev_b32 v12, 16, v1
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v5, v2 :: v_dual_lshlrev_b32 v10, 16, v4
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v4, v1 :: v_dual_lshlrev_b32 v11, 16, v3
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v9, v2 :: v_dual_lshlrev_b32 v13, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v13, v11
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v3, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v10, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v11, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v1, v4 :: v_dual_lshlrev_b32 v4, 16, v10
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v3 :: v_dual_lshlrev_b32 v3, 16, v9
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v11
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v10, v1, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v11, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v7, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v9, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_perm_b32 v1, v8, v1, 0x5040100
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v2, v6, v2, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call <6 x bfloat> @llvm.maximumnum.v6bf16(<6 x bfloat> %x, <6 x bfloat> %y)
  ret <6 x bfloat> %result
}

define <8 x bfloat> @v_maximumnum_v8bf16(<8 x bfloat> %x, <8 x bfloat> %y) {
; GFX7-LABEL: v_maximumnum_v8bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v8, 1.0, v8
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v9, 1.0, v9
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v10, 1.0, v10
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v11, 1.0, v11
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v12, 1.0, v12
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_mul_f32_e32 v13, 1.0, v13
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v6
; GFX7-NEXT:    v_mul_f32_e32 v14, 1.0, v14
; GFX7-NEXT:    v_mul_f32_e32 v7, 1.0, v7
; GFX7-NEXT:    v_mul_f32_e32 v15, 1.0, v15
; GFX7-NEXT:    v_and_b32_e32 v15, 0xffff0000, v15
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX7-NEXT:    v_and_b32_e32 v14, 0xffff0000, v14
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX7-NEXT:    v_and_b32_e32 v13, 0xffff0000, v13
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    v_and_b32_e32 v12, 0xffff0000, v12
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v11, 0xffff0000, v11
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v10, 0xffff0000, v10
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v9, 0xffff0000, v9
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v7, v7, v15
; GFX7-NEXT:    v_max_f32_e32 v6, v6, v14
; GFX7-NEXT:    v_max_f32_e32 v5, v5, v13
; GFX7-NEXT:    v_max_f32_e32 v4, v4, v12
; GFX7-NEXT:    v_max_f32_e32 v3, v3, v11
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v10
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v9
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v8
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_v8bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v8, 0xffff0000, v3
; GFX8-NEXT:    v_lshrrev_b32_e32 v9, 16, v7
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 16, v3
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX8-NEXT:    v_and_b32_e32 v11, 0xffff0000, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v10, v9, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v9, v8, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 16, v8
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 16, v9
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v10, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v9, v8, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v10, v8, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v10
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v9
; GFX8-NEXT:    v_and_b32_e32 v9, 0xffff0000, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v10, v8, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v10, 16, v6
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX8-NEXT:    v_and_b32_e32 v12, 0xffff0000, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v11, v10, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v10, v9, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 16, v9
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 16, v10
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v11, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v11, v10, v9, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v11, v9, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v9, v10, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 16, v11
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v10
; GFX8-NEXT:    v_and_b32_e32 v10, 0xffff0000, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v11, v9, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v11, 16, v5
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 16, v1
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX8-NEXT:    v_and_b32_e32 v13, 0xffff0000, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v12, v11, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v13, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v11, v11, v10, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 16, v10
; GFX8-NEXT:    v_lshlrev_b32_e32 v13, 16, v11
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v12, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v12, v11, v10, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v12, v10, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v10, v11, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 16, v12
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v11
; GFX8-NEXT:    v_and_b32_e32 v11, 0xffff0000, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v12, v10, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v12, 16, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v13, 16, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX8-NEXT:    v_and_b32_e32 v14, 0xffff0000, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v11, v13, v12, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v14, v14
; GFX8-NEXT:    v_cndmask_b32_e32 v12, v12, v11, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v13, 16, v11
; GFX8-NEXT:    v_lshlrev_b32_e32 v14, 16, v12
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v13, v14
; GFX8-NEXT:    v_cndmask_b32_e32 v13, v12, v11, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v11, v13, v11, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v11, v11, v12, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v12
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 16, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v11, v13, v11, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v7, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; GFX8-NEXT:    v_lshlrev_b32_e32 v13, 16, v3
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v13, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v12, v7, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v12
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v7
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v6, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v12, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v6, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v7, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v7, v2, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v5, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v1
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v5, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v4, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v11
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v10
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v9
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v8
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v4 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_v8bf16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_and_b32_e32 v8, 0xffff0000, v3
; GFX900-NEXT:    v_lshrrev_b32_e32 v9, 16, v7
; GFX900-NEXT:    v_lshrrev_b32_e32 v10, 16, v3
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX900-NEXT:    v_and_b32_e32 v11, 0xffff0000, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v10, v9, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v9, v8, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v10, 16, v8
; GFX900-NEXT:    v_lshlrev_b32_e32 v11, 16, v9
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v10, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v9, v8, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v10, v8, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v9, 16, v10
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v9
; GFX900-NEXT:    v_and_b32_e32 v9, 0xffff0000, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v10, v8, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v10, 16, v6
; GFX900-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX900-NEXT:    v_and_b32_e32 v12, 0xffff0000, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v11, v10, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v10, v9, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v11, 16, v9
; GFX900-NEXT:    v_lshlrev_b32_e32 v12, 16, v10
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v11, v12
; GFX900-NEXT:    v_cndmask_b32_e32 v11, v10, v9, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v11, v9, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v10
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v9, v10, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v10, 16, v11
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v10
; GFX900-NEXT:    v_and_b32_e32 v10, 0xffff0000, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v11, v9, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v11, 16, v5
; GFX900-NEXT:    v_lshrrev_b32_e32 v12, 16, v1
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX900-NEXT:    v_and_b32_e32 v13, 0xffff0000, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v12, v11, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v13, v13
; GFX900-NEXT:    v_cndmask_b32_e32 v11, v11, v10, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v12, 16, v10
; GFX900-NEXT:    v_lshlrev_b32_e32 v13, 16, v11
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v12, v13
; GFX900-NEXT:    v_cndmask_b32_e32 v12, v11, v10, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v10
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v12, v10, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v10, v11, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v11, 16, v12
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v11
; GFX900-NEXT:    v_and_b32_e32 v11, 0xffff0000, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v12, v10, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v12, 16, v4
; GFX900-NEXT:    v_lshrrev_b32_e32 v13, 16, v0
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX900-NEXT:    v_and_b32_e32 v14, 0xffff0000, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v11, v13, v12, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v14, v14
; GFX900-NEXT:    v_cndmask_b32_e32 v12, v12, v11, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v13, 16, v11
; GFX900-NEXT:    v_lshlrev_b32_e32 v14, 16, v12
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v13, v14
; GFX900-NEXT:    v_cndmask_b32_e32 v13, v12, v11, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v11, v13, v11, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v12
; GFX900-NEXT:    v_cndmask_b32_e32 v11, v11, v12, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v12
; GFX900-NEXT:    v_lshlrev_b32_e32 v12, 16, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v11, v13, v11, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX900-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v7, v3, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; GFX900-NEXT:    v_lshlrev_b32_e32 v13, 16, v3
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v13, v12
; GFX900-NEXT:    v_cndmask_b32_e32 v12, v7, v3, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v12
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v7
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v6, v2, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v6
; GFX900-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v12, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v6, v2, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v7, v2, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v7, v2, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v5, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v1
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v5, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v4, v0, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v4, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v11, v0, s4
; GFX900-NEXT:    v_perm_b32 v1, v10, v1, s4
; GFX900-NEXT:    v_perm_b32 v2, v9, v2, s4
; GFX900-NEXT:    v_perm_b32 v3, v8, v3, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_v8bf16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_and_b32_e32 v8, 0xffff0000, v3
; GFX950-NEXT:    v_lshrrev_b32_e32 v9, 16, v7
; GFX950-NEXT:    v_lshrrev_b32_e32 v10, 16, v3
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX950-NEXT:    v_and_b32_e32 v11, 0xffff0000, v7
; GFX950-NEXT:    v_and_b32_e32 v12, 0xffff0000, v6
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v10, v9, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX950-NEXT:    v_lshlrev_b32_e32 v10, 16, v8
; GFX950-NEXT:    v_and_b32_e32 v13, 0xffff0000, v5
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v9, v8, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v11, 16, v9
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v10, v11
; GFX950-NEXT:    v_lshrrev_b32_e32 v11, 16, v2
; GFX950-NEXT:    v_and_b32_e32 v14, 0xffff0000, v4
; GFX950-NEXT:    v_cndmask_b32_e32 v10, v9, v8, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX950-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v10, v8, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v9, 16, v10
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v9
; GFX950-NEXT:    v_and_b32_e32 v9, 0xffff0000, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v10, v8, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v10, 16, v6
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v11, v10, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX950-NEXT:    v_lshlrev_b32_e32 v11, 16, v9
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v10, v10, v9, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v12, 16, v10
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v11, v12
; GFX950-NEXT:    v_lshrrev_b32_e32 v12, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v11, v10, v9, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v11, v9, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v10
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v9, v10, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v10, 16, v11
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v10
; GFX950-NEXT:    v_and_b32_e32 v10, 0xffff0000, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v11, v9, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v11, 16, v5
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v10, v12, v11, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v13, v13
; GFX950-NEXT:    v_lshlrev_b32_e32 v12, 16, v10
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v11, v11, v10, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v13, 16, v11
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v12, v13
; GFX950-NEXT:    v_lshrrev_b32_e32 v13, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v12, v11, v10, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v10
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v10, v12, v10, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v11
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v10, v10, v11, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v11, 16, v12
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v11
; GFX950-NEXT:    v_and_b32_e32 v11, 0xffff0000, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v10, v12, v10, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v12, 16, v4
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v11, v13, v12, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v14, v14
; GFX950-NEXT:    v_lshlrev_b32_e32 v13, 16, v11
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v12, v12, v11, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v14, 16, v12
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v13, v14
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v13, v12, v11, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v11
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v11, v13, v11, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v12
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v11, v11, v12, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v12
; GFX950-NEXT:    v_lshlrev_b32_e32 v12, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v11, v13, v11, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX950-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX950-NEXT:    v_lshlrev_b32_e32 v13, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v7, v3, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v13, v12
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v12, v7, v3, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v12
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v7
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v6
; GFX950-NEXT:    v_perm_b32 v3, v8, v3, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX950-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v6, v2, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v6
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v12, v7
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v6, v2, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v7, v2, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v7, v2, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX950-NEXT:    v_perm_b32 v2, v9, v2, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v5, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v6
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v5, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX950-NEXT:    v_perm_b32 v1, v10, v1, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v4, v0, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v4
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v4, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v4, 16, v5
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v4
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc
; GFX950-NEXT:    v_perm_b32 v0, v11, v0, s0
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v8bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v8, 0xffff0000, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 16, v7
; GFX10-NEXT:    v_lshrrev_b32_e32 v10, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v11, 0xffff0000, v7
; GFX10-NEXT:    v_lshrrev_b32_e32 v12, 16, v2
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX10-NEXT:    v_and_b32_e32 v15, 0xffff0000, v6
; GFX10-NEXT:    v_lshrrev_b32_e32 v16, 16, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v17, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v10, v9, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX10-NEXT:    v_and_b32_e32 v10, 0xffff0000, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v11, 16, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 16, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v9, v8, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v12, v11, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v13, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v10
; GFX10-NEXT:    v_and_b32_e32 v13, 0xffff0000, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v12, v9, v8, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v11, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX10-NEXT:    v_lshlrev_b32_e32 v15, 16, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v12, v8, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v14, v15
; GFX10-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; GFX10-NEXT:    v_and_b32_e32 v15, 0xffff0000, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v14, v11, v10, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 16, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v18, 16, v14
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v9, v16, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v14, v10, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX10-NEXT:    v_cndmask_b32_e32 v15, v16, v9, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX10-NEXT:    v_and_b32_e32 v13, 0xffff0000, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v16, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v12, v8, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v12, 16, v15
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v10, v11, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v9
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v15, v9, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX10-NEXT:    v_and_b32_e32 v13, 0xffff0000, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v12, v17, v16, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v18
; GFX10-NEXT:    v_lshlrev_b32_e32 v17, 16, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v14, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v11, v9, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v13, v16, v12, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v15
; GFX10-NEXT:    v_lshlrev_b32_e32 v16, 16, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v9, v15, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v15, 16, v12
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v15, v16
; GFX10-NEXT:    v_lshlrev_b32_e32 v16, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v15, v13, v12, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX10-NEXT:    v_lshlrev_b32_e32 v17, 16, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v7, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v11, v9, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v15, v12, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v12, 16, v7
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v11, v13, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v14, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 16, v15
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v12, v7, v3, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v16, v16
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v16, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 16, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v15, v11, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v15, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v6, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 16, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX10-NEXT:    v_lshlrev_b32_e32 v15, 16, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX10-NEXT:    v_lshlrev_b32_e32 v17, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v5, v1, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v16, v14
; GFX10-NEXT:    v_cndmask_b32_e32 v14, v6, v2, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 16, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v4, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v16, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v14, v2, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v15, v13
; GFX10-NEXT:    v_lshlrev_b32_e32 v15, 16, v14
; GFX10-NEXT:    v_cndmask_b32_e32 v13, v5, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v17, v16
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v4, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v13, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v15
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v14, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v5
; GFX10-NEXT:    v_perm_b32 v2, v10, v2, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_perm_b32 v0, v11, v0, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v13, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX10-NEXT:    v_perm_b32 v1, v9, v1, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc_lo
; GFX10-NEXT:    v_perm_b32 v3, v8, v3, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_v8bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v7
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff0000, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v12, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v9, v9
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v10, v10
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff0000, v5
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v14, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v3.h, v7.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v9.l, v2.h, v6.h, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v13, v13
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v16, 0xffff0000, v4
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v10.l, v7.h, v8.l, s1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v8.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v11.l, v6.h, v9.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v10.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v11.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v14, v14
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v12.l, v1.h, v5.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s4, 0, v9.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v15, v17
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v14.l, v5.h, v12.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s3, v13, v18
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v12.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v10.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v13.l, v10.l, v8.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v11.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v15.l, v11.l, v9.l, s3
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v20.l, v14.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v13.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v13.l, v8.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v19.l, v15.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.h, v15.l, v9.l, s4
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v8.l, v10.l, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v19
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v9.l, v8.h, v11.l, s2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v17
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v20
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v18
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v10
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v10.l, v0.h, v4.h, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v16, v16
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v11, v17
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.h, v13.l, v8.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v9.h, v15.l, v9.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v4.h, v10.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v9.l, v14.l, v12.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v11, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v7
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v8.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v7.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v11, v11
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v16.l, v9.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.h, v9.l, v12.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v14.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v7.l, v3.l, s0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v16
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v13, v15
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.h, v3.h, v14.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v7.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v12, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v3.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v11.l, v8.l, v10.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v10.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v6.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v12, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v14
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.h, v11.l, v10.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v8.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v6.l, v2.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v12, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.h, v3.h, v8.l, s1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v11.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v6.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v7.l, v3.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v13, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v5
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v2.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v14, v14
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v4
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v5.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v13, v13
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.h, v9.l, v2.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v4.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v14, v14
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v1.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v10
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s3, v15, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v8.l, v3.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v4.l, v0.l, s1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v1.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v6.l, v2.l, s3
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v0.h, v7.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v8.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v2.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v14, v13
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v6.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v5.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v7
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v3.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.h, v0.h, v6.l, s1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v4.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v2.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v2.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v7.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v7.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v0.h, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v3.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v13
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v6
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s3, 0, v10
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v11.l, v3.h, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v1.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v9.l, v4.l, v4.h, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v8.l, v1.h, s3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v7.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v1, v2 :: v_dual_mov_b32 v2, v9
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v3, v8
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_v8bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v12, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v16, 16, v5
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff0000, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v17, 16, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v10, v9, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v11, 16, v6
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v9, v8 :: v_dual_and_b32 v10, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v9
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v12, v11, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v13, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v15, 0xffff0000, v6
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v10
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v9, v8, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v11, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v8, v12, v8 :: v_dual_and_b32 v13, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v8, v8, v9 :: v_dual_lshlrev_b32 v15, 16, v11
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v14, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v14, v11, v10 :: v_dual_and_b32 v15, 0xffff0000, v5
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v9, v16, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v14, v10 :: v_dual_lshlrev_b32 v13, 16, v12
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v15, v16, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v16, 16, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v12, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v15
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v10, v11 :: v_dual_lshlrev_b32 v11, 16, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v12
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v11, v15, v9 :: v_dual_lshlrev_b32 v18, 16, v14
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v12, v17, v16 :: v_dual_lshlrev_b32 v17, 16, v7
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v18
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v14, v10 :: v_dual_and_b32 v13, 0xffff0000, v4
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v11, v9 :: v_dual_lshlrev_b32 v14, 16, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v13, v16, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v15
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v9, v15 :: v_dual_lshlrev_b32 v16, 16, v13
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v12
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v15, v16
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v11
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v15, v13, v12 :: v_dual_lshlrev_b32 v16, 16, v2
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v7, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v14
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v11, v9 :: v_dual_lshlrev_b32 v14, 16, v3
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v11, v15, v12 :: v_dual_lshlrev_b32 v12, 16, v7
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v13
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v11, v13, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v14, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v7, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v16, v16
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v2, v6 :: v_dual_lshlrev_b32 v13, 16, v15
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v12, v3 :: v_dual_lshlrev_b32 v16, 16, v2
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v15, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v6, v6, v2 :: v_dual_lshlrev_b32 v15, 16, v0
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v7 :: v_dual_lshlrev_b32 v14, 16, v6
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v5, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v16, v14
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v14, v6, v2 :: v_dual_lshlrev_b32 v7, 16, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v4
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v4, v0 :: v_dual_lshlrev_b32 v13, 16, v5
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v4
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v14, v2 :: v_dual_lshlrev_b32 v15, 16, v1
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v15, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v14
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v13, v5, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v17, v16
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v4, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v13, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v4 :: v_dual_lshlrev_b32 v5, 16, v6
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v15
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v14, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v10, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v13
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v11, v0, 0x5040100
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v13, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v9, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v8, v3, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_v8bf16:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v3
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v9, 0xffff0000, v2
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v10, 0xffff0000, v7
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v11, 0xffff0000, v6
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v12, 0xffff0000, v1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v9, v9
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v10, v10
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v13, 0xffff0000, v5
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v14, 0xffff0000, v0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v3.h, v7.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v9.l, v2.h, v6.h, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v13, v13
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v16, 0xffff0000, v4
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v10.l, v7.h, v8.l, s1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v8.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v11.l, v6.h, v9.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v9.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v10.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v11.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v14, v14
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v12
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v12.l, v1.h, v5.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s4, 0, v9.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v15, v17
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v14.l, v5.h, v12.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s3, v13, v18
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v12.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v10.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v13.l, v10.l, v8.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v11.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v15.l, v11.l, v9.l, s3
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v20.l, v14.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v13.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v13.l, v8.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v19.l, v15.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.h, v15.l, v9.l, s4
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v8.l, v10.l, s0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v19
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v9.l, v8.h, v11.l, s2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v17
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v20
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v18
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v10
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v10.l, v0.h, v4.h, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v16, v16
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v11, v17
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.h, v13.l, v8.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v9.h, v15.l, v9.l, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v4.h, v10.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v9.l, v14.l, v12.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v11, v11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v7
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v10.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v8.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v7.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v11, v11
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v16.l, v9.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.h, v9.l, v12.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v14.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v7.l, v3.l, s0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v16
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v13, v15
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.h, v3.h, v14.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v7.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v12, v12
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v6
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v3.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v11
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v11.l, v8.l, v10.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v10.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v6.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v12, v12
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v14
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.h, v11.l, v10.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v8.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v6.l, v2.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v12, v13
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.h, v3.h, v8.l, s1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v11.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v6.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v7.l, v3.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v13, v13
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v5
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v2.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v14, v14
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v4
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v5.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v13, v13
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.h, v9.l, v2.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v15
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v4.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v14, v14
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v1.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v10
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s3, v15, v12
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v8.l, v3.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v4.l, v0.l, s1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v5.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v1.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v3.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v6.l, v2.l, s3
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v2.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v14
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v0.h, v7.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v10
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v8.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v2.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v14, v13
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v6.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v5.l, v1.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v7
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v3.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.h, v0.h, v6.l, s1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v4.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v2.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v2.l, v1.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v7.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v7.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v0.h, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v3.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v13
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v6
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s3, 0, v10
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v12
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v11.l, v3.h, s2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v1.l, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v9.l, v4.l, v4.h, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v8.l, v1.h, s3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v7.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_dual_mov_b32 v1, v2 :: v_dual_mov_b32 v2, v9
; GFX12-TRUE16-NEXT:    v_mov_b32_e32 v3, v8
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_v8bf16:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v8, 0xffff0000, v3
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 16, v7
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v10, 16, v3
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v12, 16, v2
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v16, 16, v5
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v11, 0xffff0000, v7
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v17, 16, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v10, v9, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v11, 16, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v9, v8 :: v_dual_and_b32 v10, 0xffff0000, v2
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v8
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v12, v11, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v13, v14
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v15, 0xffff0000, v6
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v9, v8, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v11, v10, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v8, v12, v8 :: v_dual_and_b32 v13, 0xffff0000, v1
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v8, v8, v9 :: v_dual_lshlrev_b32 v15, 16, v11
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v14, v15
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v14, v11, v10 :: v_dual_and_b32 v15, 0xffff0000, v5
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v9, v16, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v14, v10 :: v_dual_lshlrev_b32 v13, 16, v12
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v15, v16, v9, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v13, 0xffff0000, v0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v16, 16, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v12, v8, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v15
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v10, v11 :: v_dual_lshlrev_b32 v11, 16, v9
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v12
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v11, v15, v9 :: v_dual_lshlrev_b32 v18, 16, v14
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v12, v17, v16 :: v_dual_lshlrev_b32 v17, 16, v7
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v18
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v14, v10 :: v_dual_and_b32 v13, 0xffff0000, v4
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v11, v9 :: v_dual_lshlrev_b32 v14, 16, v3
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v13, v16, v12, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v15
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v9, v15 :: v_dual_lshlrev_b32 v16, 16, v13
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v12
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v15, v16
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v11
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v15, v13, v12 :: v_dual_lshlrev_b32 v16, 16, v2
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v7, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v14
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v11, v9 :: v_dual_lshlrev_b32 v14, 16, v3
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v11, v15, v12 :: v_dual_lshlrev_b32 v12, 16, v7
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v11, v13, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v14, v12
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v7, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v16, v16
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v2, v6 :: v_dual_lshlrev_b32 v13, 16, v15
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v12, v3 :: v_dual_lshlrev_b32 v16, 16, v2
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v15, v11, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v6, v6, v2 :: v_dual_lshlrev_b32 v15, 16, v0
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v7 :: v_dual_lshlrev_b32 v14, 16, v6
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v17, v17
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v5, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v16, v14
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v14, v6, v2 :: v_dual_lshlrev_b32 v7, 16, v12
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v4
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v4, v0 :: v_dual_lshlrev_b32 v13, 16, v5
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v14, v2 :: v_dual_lshlrev_b32 v15, 16, v1
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v15, v13
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v14
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v13, v5, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v17, v16
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v4, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v13, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v4 :: v_dual_lshlrev_b32 v5, 16, v6
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v15
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v14, v2, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v5
; GFX12-FAKE16-NEXT:    v_perm_b32 v2, v10, v2, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v13
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v11, v0, 0x5040100
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v13, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v1, v9, v1, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_perm_b32 v3, v8, v3, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call <8 x bfloat> @llvm.maximumnum.v8bf16(<8 x bfloat> %x, <8 x bfloat> %y)
  ret <8 x bfloat> %result
}

define <16 x bfloat> @v_maximumnum_v16bf16(<16 x bfloat> %x, <16 x bfloat> %y) {
; GFX7-LABEL: v_maximumnum_v16bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v11, 1.0, v11
; GFX7-NEXT:    v_mul_f32_e32 v27, 1.0, v27
; GFX7-NEXT:    v_and_b32_e32 v27, 0xffff0000, v27
; GFX7-NEXT:    v_and_b32_e32 v11, 0xffff0000, v11
; GFX7-NEXT:    v_max_f32_e32 v11, v11, v27
; GFX7-NEXT:    buffer_load_dword v27, off, s[0:3], s32
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v6
; GFX7-NEXT:    v_mul_f32_e32 v22, 1.0, v22
; GFX7-NEXT:    v_and_b32_e32 v22, 0xffff0000, v22
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX7-NEXT:    v_mul_f32_e32 v14, 1.0, v14
; GFX7-NEXT:    v_mul_f32_e32 v30, 1.0, v30
; GFX7-NEXT:    v_mul_f32_e32 v13, 1.0, v13
; GFX7-NEXT:    v_mul_f32_e32 v29, 1.0, v29
; GFX7-NEXT:    v_mul_f32_e32 v12, 1.0, v12
; GFX7-NEXT:    v_mul_f32_e32 v28, 1.0, v28
; GFX7-NEXT:    v_mul_f32_e32 v10, 1.0, v10
; GFX7-NEXT:    v_mul_f32_e32 v26, 1.0, v26
; GFX7-NEXT:    v_mul_f32_e32 v9, 1.0, v9
; GFX7-NEXT:    v_mul_f32_e32 v25, 1.0, v25
; GFX7-NEXT:    v_mul_f32_e32 v8, 1.0, v8
; GFX7-NEXT:    v_mul_f32_e32 v24, 1.0, v24
; GFX7-NEXT:    v_mul_f32_e32 v7, 1.0, v7
; GFX7-NEXT:    v_mul_f32_e32 v23, 1.0, v23
; GFX7-NEXT:    v_mul_f32_e32 v15, 1.0, v15
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_max_f32_e32 v6, v6, v22
; GFX7-NEXT:    v_mul_f32_e32 v21, 1.0, v21
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v20, 1.0, v20
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v19, 1.0, v19
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v18, 1.0, v18
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v17, 1.0, v17
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v16, 1.0, v16
; GFX7-NEXT:    v_and_b32_e32 v30, 0xffff0000, v30
; GFX7-NEXT:    v_and_b32_e32 v14, 0xffff0000, v14
; GFX7-NEXT:    v_and_b32_e32 v29, 0xffff0000, v29
; GFX7-NEXT:    v_and_b32_e32 v13, 0xffff0000, v13
; GFX7-NEXT:    v_and_b32_e32 v28, 0xffff0000, v28
; GFX7-NEXT:    v_and_b32_e32 v12, 0xffff0000, v12
; GFX7-NEXT:    v_and_b32_e32 v26, 0xffff0000, v26
; GFX7-NEXT:    v_and_b32_e32 v10, 0xffff0000, v10
; GFX7-NEXT:    v_and_b32_e32 v25, 0xffff0000, v25
; GFX7-NEXT:    v_and_b32_e32 v9, 0xffff0000, v9
; GFX7-NEXT:    v_and_b32_e32 v24, 0xffff0000, v24
; GFX7-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; GFX7-NEXT:    v_and_b32_e32 v23, 0xffff0000, v23
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX7-NEXT:    v_and_b32_e32 v15, 0xffff0000, v15
; GFX7-NEXT:    v_and_b32_e32 v21, 0xffff0000, v21
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    v_and_b32_e32 v20, 0xffff0000, v20
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v19, 0xffff0000, v19
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v18, 0xffff0000, v18
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v17, 0xffff0000, v17
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v16, 0xffff0000, v16
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v14, v14, v30
; GFX7-NEXT:    v_max_f32_e32 v13, v13, v29
; GFX7-NEXT:    v_max_f32_e32 v12, v12, v28
; GFX7-NEXT:    v_max_f32_e32 v10, v10, v26
; GFX7-NEXT:    v_max_f32_e32 v9, v9, v25
; GFX7-NEXT:    v_max_f32_e32 v8, v8, v24
; GFX7-NEXT:    v_max_f32_e32 v7, v7, v23
; GFX7-NEXT:    v_max_f32_e32 v5, v5, v21
; GFX7-NEXT:    v_max_f32_e32 v4, v4, v20
; GFX7-NEXT:    v_max_f32_e32 v3, v3, v19
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v18
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v17
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v16
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v22, 1.0, v27
; GFX7-NEXT:    v_and_b32_e32 v22, 0xffff0000, v22
; GFX7-NEXT:    v_max_f32_e32 v15, v15, v22
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX7-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; GFX7-NEXT:    v_and_b32_e32 v9, 0xffff0000, v9
; GFX7-NEXT:    v_and_b32_e32 v10, 0xffff0000, v10
; GFX7-NEXT:    v_and_b32_e32 v11, 0xffff0000, v11
; GFX7-NEXT:    v_and_b32_e32 v12, 0xffff0000, v12
; GFX7-NEXT:    v_and_b32_e32 v13, 0xffff0000, v13
; GFX7-NEXT:    v_and_b32_e32 v14, 0xffff0000, v14
; GFX7-NEXT:    v_and_b32_e32 v15, 0xffff0000, v15
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_v16bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v16, 0xffff0000, v7
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX8-NEXT:    v_lshrrev_b32_e32 v16, 16, v15
; GFX8-NEXT:    v_lshrrev_b32_e32 v17, 16, v7
; GFX8-NEXT:    v_and_b32_e32 v19, 0xffff0000, v15
; GFX8-NEXT:    v_cndmask_b32_e32 v17, v17, v16, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v19, v19
; GFX8-NEXT:    v_cndmask_b32_e32 v16, v16, v17, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v18, 16, v17
; GFX8-NEXT:    v_lshlrev_b32_e32 v19, 16, v16
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v18, v19
; GFX8-NEXT:    v_cndmask_b32_e32 v18, v16, v17, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v17
; GFX8-NEXT:    v_cndmask_b32_e32 v17, v18, v17, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v16
; GFX8-NEXT:    v_cndmask_b32_e32 v16, v17, v16, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v17, 16, v18
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v17
; GFX8-NEXT:    v_and_b32_e32 v17, 0xffff0000, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v16, v18, v16, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v17, v17
; GFX8-NEXT:    v_lshrrev_b32_e32 v17, 16, v14
; GFX8-NEXT:    v_lshrrev_b32_e32 v18, 16, v6
; GFX8-NEXT:    v_and_b32_e32 v20, 0xffff0000, v14
; GFX8-NEXT:    v_cndmask_b32_e32 v18, v18, v17, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v20, v20
; GFX8-NEXT:    v_cndmask_b32_e32 v17, v17, v18, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v19, 16, v18
; GFX8-NEXT:    v_lshlrev_b32_e32 v20, 16, v17
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v19, v20
; GFX8-NEXT:    v_cndmask_b32_e32 v19, v17, v18, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v18
; GFX8-NEXT:    v_cndmask_b32_e32 v18, v19, v18, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v17
; GFX8-NEXT:    v_cndmask_b32_e32 v17, v18, v17, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v18, 16, v19
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v18
; GFX8-NEXT:    v_and_b32_e32 v18, 0xffff0000, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v17, v19, v17, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v18, v18
; GFX8-NEXT:    v_lshrrev_b32_e32 v18, 16, v13
; GFX8-NEXT:    v_lshrrev_b32_e32 v19, 16, v5
; GFX8-NEXT:    v_and_b32_e32 v21, 0xffff0000, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v19, v19, v18, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v21, v21
; GFX8-NEXT:    v_cndmask_b32_e32 v18, v18, v19, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v20, 16, v19
; GFX8-NEXT:    v_lshlrev_b32_e32 v21, 16, v18
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v20, v21
; GFX8-NEXT:    v_cndmask_b32_e32 v20, v18, v19, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v19
; GFX8-NEXT:    v_cndmask_b32_e32 v19, v20, v19, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v18
; GFX8-NEXT:    v_cndmask_b32_e32 v18, v19, v18, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v19, 16, v20
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v19
; GFX8-NEXT:    v_and_b32_e32 v19, 0xffff0000, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v18, v20, v18, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v19, v19
; GFX8-NEXT:    v_lshrrev_b32_e32 v19, 16, v12
; GFX8-NEXT:    v_lshrrev_b32_e32 v20, 16, v4
; GFX8-NEXT:    v_and_b32_e32 v22, 0xffff0000, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v20, v20, v19, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v22, v22
; GFX8-NEXT:    v_cndmask_b32_e32 v19, v19, v20, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v21, 16, v20
; GFX8-NEXT:    v_lshlrev_b32_e32 v22, 16, v19
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v21, v22
; GFX8-NEXT:    v_cndmask_b32_e32 v21, v19, v20, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v20
; GFX8-NEXT:    v_cndmask_b32_e32 v20, v21, v20, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v19
; GFX8-NEXT:    v_cndmask_b32_e32 v19, v20, v19, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v20, 16, v21
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v20
; GFX8-NEXT:    v_and_b32_e32 v20, 0xffff0000, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v19, v21, v19, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v20, v20
; GFX8-NEXT:    v_lshrrev_b32_e32 v20, 16, v11
; GFX8-NEXT:    v_lshrrev_b32_e32 v21, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v23, 0xffff0000, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v21, v21, v20, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v23, v23
; GFX8-NEXT:    v_cndmask_b32_e32 v20, v20, v21, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v22, 16, v21
; GFX8-NEXT:    v_lshlrev_b32_e32 v23, 16, v20
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v22, v23
; GFX8-NEXT:    v_cndmask_b32_e32 v22, v20, v21, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v21
; GFX8-NEXT:    v_cndmask_b32_e32 v21, v22, v21, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v20
; GFX8-NEXT:    v_cndmask_b32_e32 v20, v21, v20, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v21, 16, v22
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v21
; GFX8-NEXT:    v_and_b32_e32 v21, 0xffff0000, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v20, v22, v20, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v21, v21
; GFX8-NEXT:    v_lshrrev_b32_e32 v21, 16, v10
; GFX8-NEXT:    v_lshrrev_b32_e32 v22, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v24, 0xffff0000, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v22, v22, v21, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX8-NEXT:    v_cndmask_b32_e32 v21, v21, v22, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v23, 16, v22
; GFX8-NEXT:    v_lshlrev_b32_e32 v24, 16, v21
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v23, v24
; GFX8-NEXT:    v_cndmask_b32_e32 v23, v21, v22, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v22
; GFX8-NEXT:    v_cndmask_b32_e32 v22, v23, v22, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v21
; GFX8-NEXT:    v_cndmask_b32_e32 v21, v22, v21, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v22, 16, v23
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v22
; GFX8-NEXT:    v_and_b32_e32 v22, 0xffff0000, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v21, v23, v21, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v22, v22
; GFX8-NEXT:    v_lshrrev_b32_e32 v22, 16, v9
; GFX8-NEXT:    v_lshrrev_b32_e32 v23, 16, v1
; GFX8-NEXT:    v_and_b32_e32 v25, 0xffff0000, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v23, v23, v22, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v25, v25
; GFX8-NEXT:    v_cndmask_b32_e32 v22, v22, v23, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v24, 16, v23
; GFX8-NEXT:    v_lshlrev_b32_e32 v25, 16, v22
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v24, v25
; GFX8-NEXT:    v_cndmask_b32_e32 v24, v22, v23, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v23
; GFX8-NEXT:    v_cndmask_b32_e32 v23, v24, v23, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v22
; GFX8-NEXT:    v_cndmask_b32_e32 v22, v23, v22, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v23, 16, v24
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v23
; GFX8-NEXT:    v_and_b32_e32 v23, 0xffff0000, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v22, v24, v22, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v23, v23
; GFX8-NEXT:    v_lshrrev_b32_e32 v23, 16, v8
; GFX8-NEXT:    v_lshrrev_b32_e32 v24, 16, v0
; GFX8-NEXT:    v_and_b32_e32 v26, 0xffff0000, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v24, v24, v23, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v26, v26
; GFX8-NEXT:    v_cndmask_b32_e32 v23, v23, v24, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v25, 16, v24
; GFX8-NEXT:    v_lshlrev_b32_e32 v26, 16, v23
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v25, v26
; GFX8-NEXT:    v_cndmask_b32_e32 v25, v23, v24, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v24
; GFX8-NEXT:    v_cndmask_b32_e32 v24, v25, v24, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v23
; GFX8-NEXT:    v_cndmask_b32_e32 v23, v24, v23, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v24
; GFX8-NEXT:    v_lshlrev_b32_e32 v24, 16, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v23, v25, v23, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX8-NEXT:    v_lshlrev_b32_e32 v24, 16, v15
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v7, v15, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX8-NEXT:    v_cndmask_b32_e32 v15, v15, v7, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v24, 16, v15
; GFX8-NEXT:    v_lshlrev_b32_e32 v25, 16, v7
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v25, v24
; GFX8-NEXT:    v_cndmask_b32_e32 v24, v15, v7, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v24, v7, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v15
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v7, v15, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v15, 16, v24
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v15
; GFX8-NEXT:    v_lshlrev_b32_e32 v15, 16, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v24, v7, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v15, v15
; GFX8-NEXT:    v_lshlrev_b32_e32 v15, 16, v14
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v6, v14, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v15, v15
; GFX8-NEXT:    v_cndmask_b32_e32 v14, v14, v6, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v15, 16, v14
; GFX8-NEXT:    v_lshlrev_b32_e32 v24, 16, v6
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v24, v15
; GFX8-NEXT:    v_cndmask_b32_e32 v15, v14, v6, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v15, v6, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v14
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v6, v14, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v14, 16, v15
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v14
; GFX8-NEXT:    v_lshlrev_b32_e32 v14, 16, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v15, v6, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v14, v14
; GFX8-NEXT:    v_lshlrev_b32_e32 v14, 16, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v5, v13, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v14, v14
; GFX8-NEXT:    v_cndmask_b32_e32 v13, v13, v5, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v14, 16, v13
; GFX8-NEXT:    v_lshlrev_b32_e32 v15, 16, v5
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v15, v14
; GFX8-NEXT:    v_cndmask_b32_e32 v14, v13, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v14, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v5, v13, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v13, 16, v14
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v13
; GFX8-NEXT:    v_lshlrev_b32_e32 v13, 16, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v14, v5, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v13, v13
; GFX8-NEXT:    v_lshlrev_b32_e32 v13, 16, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v12, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v13, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v12, v12, v4, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v13, 16, v12
; GFX8-NEXT:    v_lshlrev_b32_e32 v14, 16, v4
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v14, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v13, v12, v4, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v13, v4, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v12, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v12
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 16, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v13, v4, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 16, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v11, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v11, v11, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 16, v11
; GFX8-NEXT:    v_lshlrev_b32_e32 v13, 16, v3
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v13, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v12, v11, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v11, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 16, v12
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v11
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v10, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v10, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX8-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v12, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v11, v10, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v11, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v10, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 16, v11
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v10
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v11, v2, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 16, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v9, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 16, v9
; GFX8-NEXT:    v_lshlrev_b32_e32 v11, 16, v1
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v11, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v9, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v10, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v10
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v9
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v10, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v8, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v9, 16, v8
; GFX8-NEXT:    v_lshlrev_b32_e32 v10, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v10, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v8, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v9, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v23
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v22
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v21
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v20
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v19
; GFX8-NEXT:    v_or_b32_sdwa v4, v4, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v18
; GFX8-NEXT:    v_or_b32_sdwa v5, v5, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v17
; GFX8-NEXT:    v_or_b32_sdwa v6, v6, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v16
; GFX8-NEXT:    v_or_b32_sdwa v7, v7, v8 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_v16bf16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_and_b32_e32 v16, 0xffff0000, v7
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX900-NEXT:    v_lshrrev_b32_e32 v16, 16, v15
; GFX900-NEXT:    v_lshrrev_b32_e32 v17, 16, v7
; GFX900-NEXT:    v_and_b32_e32 v19, 0xffff0000, v15
; GFX900-NEXT:    v_cndmask_b32_e32 v17, v17, v16, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v19, v19
; GFX900-NEXT:    v_cndmask_b32_e32 v16, v16, v17, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v18, 16, v17
; GFX900-NEXT:    v_lshlrev_b32_e32 v19, 16, v16
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v18, v19
; GFX900-NEXT:    v_cndmask_b32_e32 v18, v16, v17, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v17
; GFX900-NEXT:    v_cndmask_b32_e32 v17, v18, v17, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v16
; GFX900-NEXT:    v_cndmask_b32_e32 v16, v17, v16, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v17, 16, v18
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v17
; GFX900-NEXT:    v_and_b32_e32 v17, 0xffff0000, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v16, v18, v16, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v17, v17
; GFX900-NEXT:    v_lshrrev_b32_e32 v17, 16, v14
; GFX900-NEXT:    v_lshrrev_b32_e32 v18, 16, v6
; GFX900-NEXT:    v_and_b32_e32 v20, 0xffff0000, v14
; GFX900-NEXT:    v_cndmask_b32_e32 v18, v18, v17, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v20, v20
; GFX900-NEXT:    v_cndmask_b32_e32 v17, v17, v18, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v19, 16, v18
; GFX900-NEXT:    v_lshlrev_b32_e32 v20, 16, v17
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v19, v20
; GFX900-NEXT:    v_cndmask_b32_e32 v19, v17, v18, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v18
; GFX900-NEXT:    v_cndmask_b32_e32 v18, v19, v18, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v17
; GFX900-NEXT:    v_cndmask_b32_e32 v17, v18, v17, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v18, 16, v19
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v18
; GFX900-NEXT:    v_and_b32_e32 v18, 0xffff0000, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v17, v19, v17, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v18, v18
; GFX900-NEXT:    v_lshrrev_b32_e32 v18, 16, v13
; GFX900-NEXT:    v_lshrrev_b32_e32 v19, 16, v5
; GFX900-NEXT:    v_and_b32_e32 v21, 0xffff0000, v13
; GFX900-NEXT:    v_cndmask_b32_e32 v19, v19, v18, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v21, v21
; GFX900-NEXT:    v_cndmask_b32_e32 v18, v18, v19, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v20, 16, v19
; GFX900-NEXT:    v_lshlrev_b32_e32 v21, 16, v18
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v20, v21
; GFX900-NEXT:    v_cndmask_b32_e32 v20, v18, v19, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v19
; GFX900-NEXT:    v_cndmask_b32_e32 v19, v20, v19, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v18
; GFX900-NEXT:    v_cndmask_b32_e32 v18, v19, v18, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v19, 16, v20
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v19
; GFX900-NEXT:    v_and_b32_e32 v19, 0xffff0000, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v18, v20, v18, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v19, v19
; GFX900-NEXT:    v_lshrrev_b32_e32 v19, 16, v12
; GFX900-NEXT:    v_lshrrev_b32_e32 v20, 16, v4
; GFX900-NEXT:    v_and_b32_e32 v22, 0xffff0000, v12
; GFX900-NEXT:    v_cndmask_b32_e32 v20, v20, v19, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v22, v22
; GFX900-NEXT:    v_cndmask_b32_e32 v19, v19, v20, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v21, 16, v20
; GFX900-NEXT:    v_lshlrev_b32_e32 v22, 16, v19
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v21, v22
; GFX900-NEXT:    v_cndmask_b32_e32 v21, v19, v20, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v20
; GFX900-NEXT:    v_cndmask_b32_e32 v20, v21, v20, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v19
; GFX900-NEXT:    v_cndmask_b32_e32 v19, v20, v19, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v20, 16, v21
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v20
; GFX900-NEXT:    v_and_b32_e32 v20, 0xffff0000, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v19, v21, v19, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v20, v20
; GFX900-NEXT:    v_lshrrev_b32_e32 v20, 16, v11
; GFX900-NEXT:    v_lshrrev_b32_e32 v21, 16, v3
; GFX900-NEXT:    v_and_b32_e32 v23, 0xffff0000, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v21, v21, v20, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v23, v23
; GFX900-NEXT:    v_cndmask_b32_e32 v20, v20, v21, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v22, 16, v21
; GFX900-NEXT:    v_lshlrev_b32_e32 v23, 16, v20
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v22, v23
; GFX900-NEXT:    v_cndmask_b32_e32 v22, v20, v21, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v21
; GFX900-NEXT:    v_cndmask_b32_e32 v21, v22, v21, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v20
; GFX900-NEXT:    v_cndmask_b32_e32 v20, v21, v20, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v21, 16, v22
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v21
; GFX900-NEXT:    v_and_b32_e32 v21, 0xffff0000, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v20, v22, v20, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v21, v21
; GFX900-NEXT:    v_lshrrev_b32_e32 v21, 16, v10
; GFX900-NEXT:    v_lshrrev_b32_e32 v22, 16, v2
; GFX900-NEXT:    v_and_b32_e32 v24, 0xffff0000, v10
; GFX900-NEXT:    v_cndmask_b32_e32 v22, v22, v21, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX900-NEXT:    v_cndmask_b32_e32 v21, v21, v22, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v23, 16, v22
; GFX900-NEXT:    v_lshlrev_b32_e32 v24, 16, v21
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v23, v24
; GFX900-NEXT:    v_cndmask_b32_e32 v23, v21, v22, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v22
; GFX900-NEXT:    v_cndmask_b32_e32 v22, v23, v22, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v21
; GFX900-NEXT:    v_cndmask_b32_e32 v21, v22, v21, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v22, 16, v23
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v22
; GFX900-NEXT:    v_and_b32_e32 v22, 0xffff0000, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v21, v23, v21, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v22, v22
; GFX900-NEXT:    v_lshrrev_b32_e32 v22, 16, v9
; GFX900-NEXT:    v_lshrrev_b32_e32 v23, 16, v1
; GFX900-NEXT:    v_and_b32_e32 v25, 0xffff0000, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v23, v23, v22, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v25, v25
; GFX900-NEXT:    v_cndmask_b32_e32 v22, v22, v23, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v24, 16, v23
; GFX900-NEXT:    v_lshlrev_b32_e32 v25, 16, v22
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v24, v25
; GFX900-NEXT:    v_cndmask_b32_e32 v24, v22, v23, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v23
; GFX900-NEXT:    v_cndmask_b32_e32 v23, v24, v23, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v22
; GFX900-NEXT:    v_cndmask_b32_e32 v22, v23, v22, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v23, 16, v24
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v23
; GFX900-NEXT:    v_and_b32_e32 v23, 0xffff0000, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v22, v24, v22, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v23, v23
; GFX900-NEXT:    v_lshrrev_b32_e32 v23, 16, v8
; GFX900-NEXT:    v_lshrrev_b32_e32 v24, 16, v0
; GFX900-NEXT:    v_and_b32_e32 v26, 0xffff0000, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v24, v24, v23, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v26, v26
; GFX900-NEXT:    v_cndmask_b32_e32 v23, v23, v24, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v25, 16, v24
; GFX900-NEXT:    v_lshlrev_b32_e32 v26, 16, v23
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v25, v26
; GFX900-NEXT:    v_cndmask_b32_e32 v25, v23, v24, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v24
; GFX900-NEXT:    v_cndmask_b32_e32 v24, v25, v24, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v23
; GFX900-NEXT:    v_cndmask_b32_e32 v23, v24, v23, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v24
; GFX900-NEXT:    v_lshlrev_b32_e32 v24, 16, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v23, v25, v23, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX900-NEXT:    v_lshlrev_b32_e32 v24, 16, v15
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v7, v15, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX900-NEXT:    v_cndmask_b32_e32 v15, v15, v7, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v24, 16, v15
; GFX900-NEXT:    v_lshlrev_b32_e32 v25, 16, v7
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v25, v24
; GFX900-NEXT:    v_cndmask_b32_e32 v24, v15, v7, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v24, v7, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v15
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v7, v15, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v15, 16, v24
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v15
; GFX900-NEXT:    v_lshlrev_b32_e32 v15, 16, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v24, v7, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v15, v15
; GFX900-NEXT:    v_lshlrev_b32_e32 v15, 16, v14
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v6, v14, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v15, v15
; GFX900-NEXT:    v_cndmask_b32_e32 v14, v14, v6, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v15, 16, v14
; GFX900-NEXT:    v_lshlrev_b32_e32 v24, 16, v6
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v24, v15
; GFX900-NEXT:    v_cndmask_b32_e32 v15, v14, v6, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v15, v6, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v14
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v6, v14, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v14, 16, v15
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v14
; GFX900-NEXT:    v_lshlrev_b32_e32 v14, 16, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v15, v6, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v14, v14
; GFX900-NEXT:    v_lshlrev_b32_e32 v14, 16, v13
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v5, v13, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v14, v14
; GFX900-NEXT:    v_cndmask_b32_e32 v13, v13, v5, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v14, 16, v13
; GFX900-NEXT:    v_lshlrev_b32_e32 v15, 16, v5
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v15, v14
; GFX900-NEXT:    v_cndmask_b32_e32 v14, v13, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v14, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v13
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v5, v13, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v13, 16, v14
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v13
; GFX900-NEXT:    v_lshlrev_b32_e32 v13, 16, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v14, v5, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v13, v13
; GFX900-NEXT:    v_lshlrev_b32_e32 v13, 16, v12
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v4, v12, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v13, v13
; GFX900-NEXT:    v_cndmask_b32_e32 v12, v12, v4, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v13, 16, v12
; GFX900-NEXT:    v_lshlrev_b32_e32 v14, 16, v4
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v14, v13
; GFX900-NEXT:    v_cndmask_b32_e32 v13, v12, v4, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v13, v4, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v12
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v4, v12, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v12
; GFX900-NEXT:    v_lshlrev_b32_e32 v12, 16, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v13, v4, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX900-NEXT:    v_lshlrev_b32_e32 v12, 16, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v11, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX900-NEXT:    v_cndmask_b32_e32 v11, v11, v3, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v12, 16, v11
; GFX900-NEXT:    v_lshlrev_b32_e32 v13, 16, v3
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v13, v12
; GFX900-NEXT:    v_cndmask_b32_e32 v12, v11, v3, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v11, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v11, 16, v12
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v11
; GFX900-NEXT:    v_lshlrev_b32_e32 v11, 16, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX900-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v10, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v10, v2, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX900-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v12, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v11, v10, v2, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v11, v2, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v10
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v10, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v10, 16, v11
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v10
; GFX900-NEXT:    v_lshlrev_b32_e32 v10, 16, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v11, v2, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX900-NEXT:    v_lshlrev_b32_e32 v10, 16, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v9, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v10, 16, v9
; GFX900-NEXT:    v_lshlrev_b32_e32 v11, 16, v1
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v11, v10
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v9, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v10, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v9, 16, v10
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v9
; GFX900-NEXT:    v_lshlrev_b32_e32 v9, 16, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v10, v1, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX900-NEXT:    v_lshlrev_b32_e32 v9, 16, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v8, v0, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v9, 16, v8
; GFX900-NEXT:    v_lshlrev_b32_e32 v10, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v10, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v8, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v9, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v9, v0, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v23, v0, s4
; GFX900-NEXT:    v_perm_b32 v1, v22, v1, s4
; GFX900-NEXT:    v_perm_b32 v2, v21, v2, s4
; GFX900-NEXT:    v_perm_b32 v3, v20, v3, s4
; GFX900-NEXT:    v_perm_b32 v4, v19, v4, s4
; GFX900-NEXT:    v_perm_b32 v5, v18, v5, s4
; GFX900-NEXT:    v_perm_b32 v6, v17, v6, s4
; GFX900-NEXT:    v_perm_b32 v7, v16, v7, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_v16bf16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_and_b32_e32 v16, 0xffff0000, v7
; GFX950-NEXT:    v_lshrrev_b32_e32 v17, 16, v15
; GFX950-NEXT:    v_lshrrev_b32_e32 v18, 16, v7
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v16, v16
; GFX950-NEXT:    v_and_b32_e32 v19, 0xffff0000, v15
; GFX950-NEXT:    v_and_b32_e32 v20, 0xffff0000, v14
; GFX950-NEXT:    v_cndmask_b32_e32 v16, v18, v17, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v19, v19
; GFX950-NEXT:    v_lshlrev_b32_e32 v18, 16, v16
; GFX950-NEXT:    v_and_b32_e32 v21, 0xffff0000, v13
; GFX950-NEXT:    v_cndmask_b32_e32 v17, v17, v16, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v19, 16, v17
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v18, v19
; GFX950-NEXT:    v_lshrrev_b32_e32 v19, 16, v6
; GFX950-NEXT:    v_and_b32_e32 v22, 0xffff0000, v12
; GFX950-NEXT:    v_cndmask_b32_e32 v18, v17, v16, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v16
; GFX950-NEXT:    v_and_b32_e32 v23, 0xffff0000, v11
; GFX950-NEXT:    v_and_b32_e32 v24, 0xffff0000, v10
; GFX950-NEXT:    v_cndmask_b32_e32 v16, v18, v16, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v17
; GFX950-NEXT:    v_and_b32_e32 v25, 0xffff0000, v9
; GFX950-NEXT:    v_and_b32_e32 v26, 0xffff0000, v8
; GFX950-NEXT:    v_cndmask_b32_e32 v16, v16, v17, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v17, 16, v18
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v17
; GFX950-NEXT:    v_and_b32_e32 v17, 0xffff0000, v6
; GFX950-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-NEXT:    v_cndmask_b32_e32 v16, v18, v16, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v18, 16, v14
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v17, v17
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v17, v19, v18, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v20, v20
; GFX950-NEXT:    v_lshlrev_b32_e32 v19, 16, v17
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v18, v18, v17, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v20, 16, v18
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v19, v20
; GFX950-NEXT:    v_lshrrev_b32_e32 v20, 16, v5
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v19, v18, v17, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v17
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v17, v19, v17, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v18
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v17, v17, v18, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v18, 16, v19
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v18
; GFX950-NEXT:    v_and_b32_e32 v18, 0xffff0000, v5
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v17, v19, v17, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v19, 16, v13
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v18, v18
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v18, v20, v19, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v21, v21
; GFX950-NEXT:    v_lshlrev_b32_e32 v20, 16, v18
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v19, v19, v18, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v21, 16, v19
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v20, v21
; GFX950-NEXT:    v_lshrrev_b32_e32 v21, 16, v4
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v20, v19, v18, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v18
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v18, v20, v18, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v19
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v18, v18, v19, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v19, 16, v20
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v19
; GFX950-NEXT:    v_and_b32_e32 v19, 0xffff0000, v4
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v18, v20, v18, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v20, 16, v12
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v19, v19
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v19, v21, v20, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v22, v22
; GFX950-NEXT:    v_lshlrev_b32_e32 v21, 16, v19
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v20, v20, v19, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v22, 16, v20
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v21, v22
; GFX950-NEXT:    v_lshrrev_b32_e32 v22, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v21, v20, v19, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v19
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v19, v21, v19, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v20
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v19, v19, v20, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v20, 16, v21
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v20
; GFX950-NEXT:    v_and_b32_e32 v20, 0xffff0000, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v19, v21, v19, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v21, 16, v11
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v20, v20
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v20, v22, v21, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v23, v23
; GFX950-NEXT:    v_lshlrev_b32_e32 v22, 16, v20
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v21, v21, v20, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v23, 16, v21
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v22, v23
; GFX950-NEXT:    v_lshrrev_b32_e32 v23, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v22, v21, v20, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v20
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v20, v22, v20, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v21
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v20, v20, v21, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v21, 16, v22
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v21
; GFX950-NEXT:    v_and_b32_e32 v21, 0xffff0000, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v20, v22, v20, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v22, 16, v10
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v21, v21
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v21, v23, v22, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX950-NEXT:    v_lshlrev_b32_e32 v23, 16, v21
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v22, v22, v21, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v24, 16, v22
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v23, v24
; GFX950-NEXT:    v_lshrrev_b32_e32 v24, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v23, v22, v21, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v21
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v21, v23, v21, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v22
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v21, v21, v22, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v22, 16, v23
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v22
; GFX950-NEXT:    v_and_b32_e32 v22, 0xffff0000, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v21, v23, v21, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v23, 16, v9
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v22, v22
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v22, v24, v23, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v25, v25
; GFX950-NEXT:    v_lshlrev_b32_e32 v24, 16, v22
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v23, v23, v22, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v25, 16, v23
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v24, v25
; GFX950-NEXT:    v_lshrrev_b32_e32 v25, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v24, v23, v22, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v22
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v22, v24, v22, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v23
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v22, v22, v23, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v23, 16, v24
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v23
; GFX950-NEXT:    v_and_b32_e32 v23, 0xffff0000, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v22, v24, v22, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v24, 16, v8
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v23, v23
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v23, v25, v24, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v26, v26
; GFX950-NEXT:    v_lshlrev_b32_e32 v25, 16, v23
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v24, v24, v23, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v26, 16, v24
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v25, v26
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v25, v24, v23, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v23
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v23, v25, v23, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v24
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v23, v23, v24, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v24
; GFX950-NEXT:    v_lshlrev_b32_e32 v24, 16, v7
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v23, v25, v23, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX950-NEXT:    v_lshlrev_b32_e32 v24, 16, v15
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v7, v15, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX950-NEXT:    v_lshlrev_b32_e32 v25, 16, v7
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v15, v15, v7, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v24, 16, v15
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v25, v24
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v24, v15, v7, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v24, v7, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v15
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v7, v15, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v15, 16, v24
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v15
; GFX950-NEXT:    v_lshlrev_b32_e32 v15, 16, v6
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v24, v7, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v15, v15
; GFX950-NEXT:    v_lshlrev_b32_e32 v15, 16, v14
; GFX950-NEXT:    v_perm_b32 v7, v16, v7, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v6, v14, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v15, v15
; GFX950-NEXT:    v_lshlrev_b32_e32 v24, 16, v6
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v14, v14, v6, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v15, 16, v14
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v24, v15
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v15, v14, v6, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v15, v6, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v14
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v6, v14, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v14, 16, v15
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v14
; GFX950-NEXT:    v_lshlrev_b32_e32 v14, 16, v5
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v15, v6, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v14, v14
; GFX950-NEXT:    v_lshlrev_b32_e32 v14, 16, v13
; GFX950-NEXT:    v_perm_b32 v6, v17, v6, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v5, v13, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v14, v14
; GFX950-NEXT:    v_lshlrev_b32_e32 v15, 16, v5
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v13, v13, v5, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v14, 16, v13
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v15, v14
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v14, v13, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v14, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v13
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v5, v13, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v13, 16, v14
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v13
; GFX950-NEXT:    v_lshlrev_b32_e32 v13, 16, v4
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v14, v5, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v13, v13
; GFX950-NEXT:    v_lshlrev_b32_e32 v13, 16, v12
; GFX950-NEXT:    v_perm_b32 v5, v18, v5, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v4, v12, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v13, v13
; GFX950-NEXT:    v_lshlrev_b32_e32 v14, 16, v4
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v12, v12, v4, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v13, 16, v12
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v14, v13
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v13, v12, v4, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v13, v4, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v12
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v4, v12, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v12
; GFX950-NEXT:    v_lshlrev_b32_e32 v12, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v13, v4, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX950-NEXT:    v_lshlrev_b32_e32 v12, 16, v11
; GFX950-NEXT:    v_perm_b32 v4, v19, v4, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v11, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v12, v12
; GFX950-NEXT:    v_lshlrev_b32_e32 v13, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v11, v11, v3, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v12, 16, v11
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v13, v12
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v12, v11, v3, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v11
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v11, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v11, 16, v12
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v11
; GFX950-NEXT:    v_lshlrev_b32_e32 v11, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v12, v3, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX950-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX950-NEXT:    v_perm_b32 v3, v20, v3, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v10, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v11, v11
; GFX950-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v10, v10, v2, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v12, v11
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v11, v10, v2, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v11, v2, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v10
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v10, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v10, 16, v11
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v10
; GFX950-NEXT:    v_lshlrev_b32_e32 v10, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v11, v2, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX950-NEXT:    v_lshlrev_b32_e32 v10, 16, v9
; GFX950-NEXT:    v_perm_b32 v2, v21, v2, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v10, v10
; GFX950-NEXT:    v_lshlrev_b32_e32 v11, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v9, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v10, 16, v9
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v11, v10
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v10, v9, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v10, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v9, 16, v10
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v9
; GFX950-NEXT:    v_lshlrev_b32_e32 v9, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v10, v1, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX950-NEXT:    v_lshlrev_b32_e32 v9, 16, v8
; GFX950-NEXT:    v_perm_b32 v1, v22, v1, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v9, v9
; GFX950-NEXT:    v_lshlrev_b32_e32 v10, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v8, v0, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v9, 16, v8
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v10, v9
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v8, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v9, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v8
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v9, v0, vcc
; GFX950-NEXT:    v_perm_b32 v0, v23, v0, s0
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v16bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v16, 0xffff0000, v7
; GFX10-NEXT:    v_lshrrev_b32_e32 v17, 16, v15
; GFX10-NEXT:    v_lshrrev_b32_e32 v18, 16, v7
; GFX10-NEXT:    v_and_b32_e32 v19, 0xffff0000, v15
; GFX10-NEXT:    v_and_b32_e32 v20, 0xffff0000, v6
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v16, v16
; GFX10-NEXT:    v_lshrrev_b32_e32 v21, 16, v14
; GFX10-NEXT:    v_lshrrev_b32_e32 v22, 16, v6
; GFX10-NEXT:    v_and_b32_e32 v23, 0xffff0000, v13
; GFX10-NEXT:    v_lshrrev_b32_e32 v24, 16, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v16, v18, v17, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX10-NEXT:    v_lshrrev_b32_e32 v25, 16, v4
; GFX10-NEXT:    v_and_b32_e32 v26, 0xffff0000, v12
; GFX10-NEXT:    v_lshrrev_b32_e32 v28, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v18, 16, v16
; GFX10-NEXT:    v_cndmask_b32_e32 v17, v17, v16, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v19, 16, v17
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v18, v19
; GFX10-NEXT:    v_and_b32_e32 v19, 0xffff0000, v14
; GFX10-NEXT:    v_cndmask_b32_e32 v18, v17, v16, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX10-NEXT:    v_cndmask_b32_e32 v20, v22, v21, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v16
; GFX10-NEXT:    v_cndmask_b32_e32 v16, v18, v16, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX10-NEXT:    v_cndmask_b32_e32 v19, v21, v20, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v17
; GFX10-NEXT:    v_lshlrev_b32_e32 v21, 16, v20
; GFX10-NEXT:    v_lshlrev_b32_e32 v22, 16, v19
; GFX10-NEXT:    v_cndmask_b32_e32 v16, v16, v17, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v17, 16, v18
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v17
; GFX10-NEXT:    v_cndmask_b32_e32 v16, v18, v16, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v21, v22
; GFX10-NEXT:    v_and_b32_e32 v18, 0xffff0000, v5
; GFX10-NEXT:    v_lshrrev_b32_e32 v21, 16, v13
; GFX10-NEXT:    v_lshrrev_b32_e32 v22, 16, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v17, v19, v20, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v20
; GFX10-NEXT:    v_cndmask_b32_e32 v20, v17, v20, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX10-NEXT:    v_cndmask_b32_e32 v18, v22, v21, vcc_lo
; GFX10-NEXT:    v_and_b32_e32 v22, 0xffff0000, v4
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX10-NEXT:    v_lshlrev_b32_e32 v23, 16, v18
; GFX10-NEXT:    v_cndmask_b32_e32 v21, v21, v18, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX10-NEXT:    v_cndmask_b32_e32 v22, v25, v24, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v19
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v21
; GFX10-NEXT:    v_cndmask_b32_e32 v19, v20, v19, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v26, v26
; GFX10-NEXT:    v_cndmask_b32_e32 v20, v24, v22, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v23, v25
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v17
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v22
; GFX10-NEXT:    v_lshlrev_b32_e32 v26, 16, v20
; GFX10-NEXT:    v_cndmask_b32_e32 v23, v21, v18, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v18
; GFX10-NEXT:    v_cndmask_b32_e32 v18, v23, v18, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX10-NEXT:    v_and_b32_e32 v24, 0xffff0000, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v17, v17, v19, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v26
; GFX10-NEXT:    v_lshrrev_b32_e32 v25, 16, v11
; GFX10-NEXT:    v_lshrrev_b32_e32 v26, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v19, v20, v22, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v21
; GFX10-NEXT:    v_lshlrev_b32_e32 v27, 16, v19
; GFX10-NEXT:    v_cndmask_b32_e32 v18, v18, v21, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v21, 16, v23
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v22
; GFX10-NEXT:    v_cndmask_b32_e32 v22, v19, v22, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v21
; GFX10-NEXT:    v_cndmask_b32_e32 v18, v23, v18, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v20
; GFX10-NEXT:    v_and_b32_e32 v23, 0xffff0000, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v20, v22, v20, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX10-NEXT:    v_and_b32_e32 v22, 0xffff0000, v11
; GFX10-NEXT:    v_lshrrev_b32_e32 v24, 16, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v21, v26, v25, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX10-NEXT:    v_lshrrev_b32_e32 v26, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v22, v25, v21, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX10-NEXT:    v_and_b32_e32 v25, 0xffff0000, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v23, v26, v24, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v27
; GFX10-NEXT:    v_lshlrev_b32_e32 v26, 16, v22
; GFX10-NEXT:    v_lshrrev_b32_e32 v27, 16, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v19, v19, v20, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v20, 16, v21
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX10-NEXT:    v_and_b32_e32 v25, 0xffff0000, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v24, v24, v23, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v20, v26
; GFX10-NEXT:    v_lshlrev_b32_e32 v26, 16, v23
; GFX10-NEXT:    v_lshlrev_b32_e32 v29, 16, v24
; GFX10-NEXT:    v_cndmask_b32_e32 v20, v22, v21, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX10-NEXT:    v_cndmask_b32_e32 v25, v28, v27, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v21
; GFX10-NEXT:    v_and_b32_e32 v28, 0xffff0000, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v21, v20, v21, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v26, v29
; GFX10-NEXT:    v_lshlrev_b32_e32 v29, 16, v20
; GFX10-NEXT:    v_cndmask_b32_e32 v26, v24, v23, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v28, v28
; GFX10-NEXT:    v_cndmask_b32_e32 v27, v27, v25, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v22
; GFX10-NEXT:    v_lshlrev_b32_e32 v28, 16, v27
; GFX10-NEXT:    v_cndmask_b32_e32 v21, v21, v22, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v23
; GFX10-NEXT:    v_cndmask_b32_e32 v22, v26, v23, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v23, 16, v25
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v24
; GFX10-NEXT:    v_cndmask_b32_e32 v22, v22, v24, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v23, v28
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v26
; GFX10-NEXT:    v_lshlrev_b32_e32 v28, 16, v15
; GFX10-NEXT:    v_cndmask_b32_e32 v23, v27, v25, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v29
; GFX10-NEXT:    v_cndmask_b32_e32 v20, v20, v21, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX10-NEXT:    v_and_b32_e32 v24, 0xffff0000, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v21, v26, v22, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v25
; GFX10-NEXT:    v_lshrrev_b32_e32 v26, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v22, v23, v25, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v27
; GFX10-NEXT:    v_lshrrev_b32_e32 v25, 16, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v22, v22, v27, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v27, 16, v7
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX10-NEXT:    v_cndmask_b32_e32 v24, v26, v25, vcc_lo
; GFX10-NEXT:    v_and_b32_e32 v26, 0xffff0000, v8
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v27, v27
; GFX10-NEXT:    v_lshlrev_b32_e32 v27, 16, v23
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v7, v15, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v26, v26
; GFX10-NEXT:    v_lshlrev_b32_e32 v26, 16, v24
; GFX10-NEXT:    v_lshlrev_b32_e32 v29, 16, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v25, v25, v24, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v28, v28
; GFX10-NEXT:    v_cndmask_b32_e32 v15, v15, v7, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v27
; GFX10-NEXT:    v_lshlrev_b32_e32 v27, 16, v25
; GFX10-NEXT:    v_lshlrev_b32_e32 v28, 16, v15
; GFX10-NEXT:    v_cndmask_b32_e32 v22, v23, v22, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v23, 16, v6
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX10-NEXT:    v_lshlrev_b32_e32 v23, 16, v14
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v6, v14, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v26, v27
; GFX10-NEXT:    v_cndmask_b32_e32 v26, v25, v24, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v29, v28
; GFX10-NEXT:    v_lshlrev_b32_e32 v28, 16, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v27, v15, v7, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX10-NEXT:    v_cndmask_b32_e32 v14, v14, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v24
; GFX10-NEXT:    v_cndmask_b32_e32 v23, v26, v24, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v14
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v27, v7, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v25
; GFX10-NEXT:    v_cndmask_b32_e32 v23, v23, v25, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v15
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v26
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v7, v15, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v28, v24
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v27
; GFX10-NEXT:    v_cndmask_b32_e32 v15, v14, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v25
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v23, v26, v23, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v15, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v27, v7, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v14
; GFX10-NEXT:    v_perm_b32 v7, v16, v7, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v6, v14, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v15
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v5, v13, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v15, v6, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX10-NEXT:    v_lshlrev_b32_e32 v15, 16, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v5
; GFX10-NEXT:    v_perm_b32 v6, v17, v6, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v13, v13, v5, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v4, v12, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v12, v12, v4, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v11, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v15, v13, v5, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v11, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v15, v5, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v14, v12, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v5, v13, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 16, v15
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v14, v4, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX10-NEXT:    v_cndmask_b32_e32 v24, v11, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 16, v14
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v15, v5, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v15, 16, v24
; GFX10-NEXT:    v_perm_b32 v5, v18, v5, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v4, v12, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v12, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v24, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v11, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v12, 16, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v15
; GFX10-NEXT:    v_lshlrev_b32_e32 v15, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v24, v3, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v9
; GFX10-NEXT:    v_perm_b32 v3, v20, v3, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v10, v2, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v12, 16, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX10-NEXT:    v_lshlrev_b32_e32 v15, 16, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v9, v1, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX10-NEXT:    v_lshlrev_b32_e32 v12, 16, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v8, v0, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v15, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v15, 16, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v10, v2, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v24, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v12, v9, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v11, v2, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v15
; GFX10-NEXT:    v_cndmask_b32_e32 v15, v8, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v12, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 16, v15
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v15, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v12
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v12, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v10
; GFX10-NEXT:    v_perm_b32 v1, v22, v1, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v15, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX10-NEXT:    v_perm_b32 v0, v23, v0, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v11, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX10-NEXT:    v_perm_b32 v2, v21, v2, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v14, v4, vcc_lo
; GFX10-NEXT:    v_perm_b32 v4, v19, v4, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_v16bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v16, v7 :: v_dual_mov_b32 v17, v6
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v18, v5
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v15
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v20, 0xffff0000, v14
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v16
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v17
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v23, 0xffff0000, v13
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v23, v23
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v16.h, v15.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v19.l, v5.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v15.h, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v19
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v6.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v17.h, v14.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v20, 0xffff0000, v18
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v19.l, v14.h, v7.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v22, v21
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v7.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v23.l, v19.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v20.l, v18.h, v13.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v21.l, v6.l, v5.l, s0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v22
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v22.l, v13.h, v20.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v21.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v21.l, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v24, v23
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v26.l, v22.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v20.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v6.l, s1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v4
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v23.l, v19.l, v7.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v26
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v19.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.h, v23.l, v7.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.h, v21.l, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v12
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v23.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v24, v25
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v4.h, v12.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v22.l, v20.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v20.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.h, v5.h, v19.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v12.h, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v21
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v6.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v19.l, v6.l, v20.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v20.l, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v7.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v24, v24
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v11
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v22.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v20
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v20.l, v3.h, v11.h, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v24, v24
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.h, v23.l, v5.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v26, v21
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.h, v19.l, v22.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v21.l, v11.h, v20.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v20.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v19.l, v7.l, v5.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v23.l, v21.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.h, v6.l, v5.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v19.l, v5.l, s0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v19.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v7.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v22, v23
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v2.h, v10.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v25
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v22.l, v21.l, v20.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v20.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v7.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v10.h, v6.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v23
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v23.l, v6.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v20.l, v22.l, v20.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v24, v24
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v9
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v26.l, v22.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v23
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v23.l, v1.h, v9.h, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v24, v24
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v21.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v26
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v19.h, v19.l, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v9.h, v23.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v19.l, v20.l, v21.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v27, v25
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v23.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v24.l, v5.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v6.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v20.h, v22.l, v19.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v22, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v20.l, v7.l, v6.l, s2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v7.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v22, 0xffff0000, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v20.l, v6.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v20.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v21, v24
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v19.l, v0.h, v8.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v6.l, v7.l, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v21.l, v5.l, v23.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v23.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v8.h, v19.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v16
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v24
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v21.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v16.h, v21.l, v23.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v23.l, v19.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v24.l, v7.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v22, v22
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v15
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v16.l, v16.l, v15.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v22, v22
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v25
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v15.h, v20.l, v6.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v23, v24
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v16.h, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v15.l, v16.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v22
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v17
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v15.l, v7.l, v19.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v19.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v23.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v24.l, v16.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v22, v22
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v14
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v15.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v17.l, v17.l, v14.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v22, v22
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v16.h, v15.l, v19.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v25
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v24, v23
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v14.l, v14.l, v17.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v14.h, v21.l, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v16.h, v7.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v22
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v17.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v14.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v18
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v6.l, v16.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v16.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v16.h, v15.l, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v13
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v7.l, v16.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v6.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v22, v21
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v15.l, v18.l, v13.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v24.l, v7.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v6.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v16.l, v14.l, v17.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v17.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v13.l, v15.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v4
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v24
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v16.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.h, v16.l, v17.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v14.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v13, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v12
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v18
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v15.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v4.l, v12.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v13, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v21
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.h, v4.h, v14.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v12.l, v12.l, v4.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v7.l, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v18, v17
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v12.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v4.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v13, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v6.l, v15.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v11.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v13, v13
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v5.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v15.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v18, v17
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v11.l, v11.l, v3.l, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v21
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v3.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.h, v5.l, v15.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v17, v17
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v11.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v10
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v10.l, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v17, v17
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v21
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.h, v3.h, v6.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v13.l, v12.l, v4.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v4.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v16.l, v4.h, s0
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v17, v18
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.h, v13.l, v4.l, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v10.l, v2.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v10.l, v11.l, v3.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v18, v18
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v9
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v21, v21
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v2.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v4.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v2.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v9.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v18, v18
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v8.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v21, v21
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v12.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v9.l, v9.l, v1.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v10.l, v3.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v8.l, v0.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.h, v3.h, v12.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v22, v17
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v1.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v3.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v0.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v4.l, v2.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v11.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v10.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v18, v17
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v8.l, v2.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v22, v21
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v4.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v9.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v13.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v11.l, v3.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v1.h, v4.l, s1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v8.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v11.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v2.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v11.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v9.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v3.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v18
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v21
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v4
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v17
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s3, 0, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v16.l, v11.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v14.l, v2.l, v1.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v15.l, v8.l, v1.h, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v20.l, v10.l, v0.h, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v19.l, v13.l, v2.h, s3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v0, v16 :: v_dual_mov_b32 v1, v14
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v2, v15 :: v_dual_mov_b32 v3, v20
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v4, v19
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_v16bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v16, 0xffff0000, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v17, 16, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v18, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v12
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v16, v16
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v19, 0xffff0000, v15
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v20, 0xffff0000, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v16, v18, v17, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v23, 0xffff0000, v13
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v16
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v17, v17, v16, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v17
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v18, v19
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v17, v16, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v20, v22, v21 :: v_dual_and_b32 v19, 0xffff0000, v14
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v16
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v16, v18, v16, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v19, v21, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v20
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v19
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v16, v16, v17 :: v_dual_lshlrev_b32 v17, 16, v18
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v17
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v16, v18, v16, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v21, v22
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v5
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v17, v19, v20 :: v_dual_and_b32 v18, 0xffff0000, v5
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v17, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v22, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v22, 0xffff0000, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v18
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v21, v21, v18, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v26, 0xffff0000, v12
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v22, v25, v24 :: v_dual_lshlrev_b32 v25, 16, v21
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v19
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v19, v20, v19, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v26, v26
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v24, v22, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v23, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v22
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v23, v21, v18 :: v_dual_lshlrev_b32 v26, 16, v20
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v18
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v23, v18, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v17, v17, v19, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v19, v20, v22, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v21
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v18, v18, v21 :: v_dual_lshlrev_b32 v27, 16, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v23
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v22
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v19, v22, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v21
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v23, v18, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v20, v22, v20 :: v_dual_and_b32 v23, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v10
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v21, v26, v25 :: v_dual_and_b32 v22, 0xffff0000, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v25, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v25, 0xffff0000, v10
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v23, v26, v24, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v9
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v19, v19, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v24, v24, v23 :: v_dual_and_b32 v25, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v24
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v21
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v22
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v20, v26
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v22, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v25, v28, v27, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v23
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v21
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v21, v20, v21, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v26, v29
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v26, v24, v23 :: v_dual_lshlrev_b32 v29, 16, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v28, 0xffff0000, v9
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v28, v28
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v27, v27, v25, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v22
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v21, v21, v22 :: v_dual_lshlrev_b32 v28, 16, v27
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v23
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v22, v26, v23 :: v_dual_lshlrev_b32 v23, 16, v25
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v24
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v22, v24, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v23, v28
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v23, v27, v25 :: v_dual_lshlrev_b32 v24, 16, v26
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v29
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v20, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v21, v26, v22 :: v_dual_and_b32 v24, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v25
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v23, v25, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v27
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v8
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v22, v27, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v7
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v24, v26, v25, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v27, v27
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v23
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v7, v15 :: v_dual_and_b32 v26, 0xffff0000, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v15
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v26, v26
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v25, v25, v24, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v28, v28
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v15, v15, v7 :: v_dual_lshlrev_b32 v26, 16, v24
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v27
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v22, v23, v22 :: v_dual_lshlrev_b32 v27, 16, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v6
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v14, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v15
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v26, v27
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v26, v25, v24 :: v_dual_lshlrev_b32 v23, 16, v14
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v29, v28
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v27, v15, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v14, v14, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v24
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v23, v26, v24, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v27, v7 :: v_dual_lshlrev_b32 v24, 16, v14
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v25
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v23, v23, v25, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v26
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v7, v15 :: v_dual_lshlrev_b32 v28, 16, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v28, v24
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v15, v14, v6 :: v_dual_lshlrev_b32 v24, 16, v27
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v13
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v23, v26, v23, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v15, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v27, v7 :: v_dual_lshlrev_b32 v24, 16, v5
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v14
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v16, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v14, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v13 :: v_dual_lshlrev_b32 v24, 16, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v15
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v14
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v15, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v5
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v17, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v13, v13, v5 :: v_dual_lshlrev_b32 v14, 16, v12
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v13
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v12, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v15, v13, v5 :: v_dual_lshlrev_b32 v24, 16, v12
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v11
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v11, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v4
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v15, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v11
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v14, v12, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v13
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v5, v13, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v14, v4 :: v_dual_lshlrev_b32 v13, 16, v15
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v24, v11, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v14
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v15, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v18, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v24, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v11 :: v_dual_lshlrev_b32 v12, 16, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v2, v10 :: v_dual_lshlrev_b32 v15, 16, v24
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v15
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v24, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v20, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v10, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v1
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v8 :: v_dual_lshlrev_b32 v11, 16, v9
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v9, v1 :: v_dual_lshlrev_b32 v12, 16, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v8, v8, v0 :: v_dual_lshlrev_b32 v15, 16, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v9
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v15, v11
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v10, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v24, v12
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v9, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v11, v2 :: v_dual_lshlrev_b32 v15, 16, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v0
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v15
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v15, v8, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v12, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v15, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v12
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v15
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v12, v1 :: v_dual_lshlrev_b32 v8, 16, v11
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v10
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v22, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v15, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v23, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v11, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v21, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v14, v4, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v19, v4, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_v16bf16:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_dual_mov_b32 v16, v7 :: v_dual_mov_b32 v17, v6
; GFX12-TRUE16-NEXT:    v_mov_b32_e32 v18, v5
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v15
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v20, 0xffff0000, v14
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v16
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v17
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v23, 0xffff0000, v13
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v23, v23
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v16.h, v15.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v19.l, v5.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v15.h, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v19
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v6.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v17.h, v14.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v20, 0xffff0000, v18
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v19.l, v14.h, v7.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v22, v21
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v7.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v23.l, v19.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v20.l, v18.h, v13.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v21.l, v6.l, v5.l, s0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v22
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v22.l, v13.h, v20.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v6.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v21.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v21.l, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v24, v23
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v26.l, v22.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v7.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v20.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v6.l, s1
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v4
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v23.l, v19.l, v7.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v26
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v19.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.h, v23.l, v7.l, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.h, v21.l, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v12
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v23.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v24, v25
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v4.h, v12.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v22.l, v20.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v20.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.h, v5.h, v19.l, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v12.h, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v21
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v6.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v19.l, v6.l, v20.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v20.l, v5.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v7.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v24, v24
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v11
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v22.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v20
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v20.l, v3.h, v11.h, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v24, v24
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.h, v23.l, v5.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v26, v21
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.h, v19.l, v22.l, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v21.l, v11.h, v20.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v20.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v19.l, v7.l, v5.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v5.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v23.l, v21.l
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.h, v6.l, v5.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v19.l, v5.l, s0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v10
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v19.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v7.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v22, v23
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v2.h, v10.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v25
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v22.l, v21.l, v20.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v20.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v7.l, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v10.h, v6.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v23
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v23.l, v6.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v20.l, v22.l, v20.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v24, v24
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v9
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v26.l, v22.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v7.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v23
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v23.l, v1.h, v9.h, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v24, v24
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v21.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v26
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v19.h, v19.l, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v9.h, v23.l, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v19.l, v20.l, v21.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v27, v25
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v23.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v24.l, v5.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v6.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v20.h, v22.l, v19.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v22, 0xffff0000, v0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v20.l, v7.l, v6.l, s2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v7.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v22, 0xffff0000, v8
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v20.l, v6.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v20.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v21, v24
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v19.l, v0.h, v8.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v6.l, v7.l, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v21.l, v5.l, v23.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v23.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v8.h, v19.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v16
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v24
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v21.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v16.h, v21.l, v23.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v23.l, v19.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v24.l, v7.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v22, v22
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v15
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v16.l, v16.l, v15.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v22, v22
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v25
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v15.h, v20.l, v6.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v23, v24
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v16.h, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v15.l, v16.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v22
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v17
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v15.l, v7.l, v19.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v19.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v23.l, v6.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v24.l, v16.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v22, v22
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v14
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v15.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v23
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v17.l, v17.l, v14.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v22, v22
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v16.h, v15.l, v19.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v7.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v25
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v24, v23
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v14.l, v14.l, v17.l, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v14.h, v21.l, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v16.h, v7.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v22
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v17.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v14.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v18
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v6.l, v16.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v16.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v16.h, v15.l, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v13
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v7.l, v16.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v6.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v22, v21
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v15.l, v18.l, v13.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v24.l, v7.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v6.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v16.l, v14.l, v17.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v17.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v13.l, v15.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v4
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v24
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v16.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.h, v16.l, v17.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v14.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v13, v13
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v12
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v18
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v6.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v15.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v4.l, v12.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v13, v13
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v21
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.h, v4.h, v14.l, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v12.l, v12.l, v4.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v13
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v7.l, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v18, v17
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v12.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v4.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v13, v13
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v11
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v6.l, v15.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v11.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v13, v13
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v5.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v15.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v18, v17
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v11.l, v11.l, v3.l, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v21
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v3.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.h, v5.l, v15.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v17, v17
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v11.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v10
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v10.l, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v17, v17
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v21
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.h, v3.h, v6.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v13.l, v12.l, v4.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v4.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v16.l, v4.h, s0
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v17, v18
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.h, v13.l, v4.l, s2
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v10.l, v2.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v10.l, v11.l, v3.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v18, v18
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v9
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v21, v21
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v8
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v2.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v4.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v2.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v9.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v18, v18
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v8.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v21, v21
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v12.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v9.l, v9.l, v1.l, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v10.l, v3.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v8.l, v0.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.h, v3.h, v12.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v22, v17
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v9.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v1.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v3.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v0.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v4.l, v2.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v2.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v22
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v11.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v10.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v18, v17
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v8.l, v2.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v22, v21
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v4.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v11
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v9.l, v1.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v13.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v11.l, v3.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v1.h, v4.l, s1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v8.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v18.l, v11.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v2.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v2.l, v1.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v11.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v18
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v21
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v9.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v3.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v18
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v21
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v4
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v17
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s3, 0, v12
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v16.l, v11.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v14.l, v2.l, v1.l, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v15.l, v8.l, v1.h, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v20.l, v10.l, v0.h, s2
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v19.l, v13.l, v2.h, s3
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_dual_mov_b32 v0, v16 :: v_dual_mov_b32 v1, v14
; GFX12-TRUE16-NEXT:    v_dual_mov_b32 v2, v15 :: v_dual_mov_b32 v3, v20
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_mov_b32_e32 v4, v19
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_v16bf16:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v14
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v16, 0xffff0000, v7
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v17, 16, v15
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v18, 16, v7
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v6
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v12
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v16, v16
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v19, 0xffff0000, v15
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v4
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v28, 16, v1
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v20, 0xffff0000, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v16, v18, v17, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v23, 0xffff0000, v13
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v16
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v17, v17, v16, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v17
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v18, v19
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v17, v16, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v20, v22, v21 :: v_dual_and_b32 v19, 0xffff0000, v14
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v16
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v16, v18, v16, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v19, v21, v20, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v17
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v20
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v19
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v16, v16, v17 :: v_dual_lshlrev_b32 v17, 16, v18
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v17
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v16, v18, v16, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v21, v22
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v21, 16, v13
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v22, 16, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v17, v19, v20 :: v_dual_and_b32 v18, 0xffff0000, v5
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v20
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v17, v20, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v18, v18
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v22, v21, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v22, 0xffff0000, v4
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v18
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v21, v21, v18, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v26, 0xffff0000, v12
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v22, v25, v24 :: v_dual_lshlrev_b32 v25, 16, v21
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v19
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v19, v20, v19, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v26, v26
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v24, v22, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v23, v25
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v17
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v22
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v23, v21, v18 :: v_dual_lshlrev_b32 v26, 16, v20
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v18
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v23, v18, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v17, v17, v19, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v26
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v11
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v19, v20, v22, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v21
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v18, v18, v21 :: v_dual_lshlrev_b32 v27, 16, v19
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v23
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v22
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v19, v22, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v21
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v23, v18, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v20
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v20, v22, v20 :: v_dual_and_b32 v23, 0xffff0000, v2
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v24, 0xffff0000, v3
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v24, 16, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v21, v26, v25 :: v_dual_and_b32 v22, 0xffff0000, v11
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v2
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v25, v21, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v25, 0xffff0000, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v23, v26, v24, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v27
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v27, 16, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v19, v19, v20, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v24, v24, v23 :: v_dual_and_b32 v25, 0xffff0000, v1
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v24
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v21
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v22
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v20, v26
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v22, v21, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v25, v28, v27, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v23
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v21
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v21, v20, v21, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v26, v29
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v26, v24, v23 :: v_dual_lshlrev_b32 v29, 16, v20
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v28, 0xffff0000, v9
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v28, v28
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v27, v27, v25, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v22
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v21, v21, v22 :: v_dual_lshlrev_b32 v28, 16, v27
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v23
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v22, v26, v23 :: v_dual_lshlrev_b32 v23, 16, v25
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v24
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v22, v24, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v23, v28
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v23, v27, v25 :: v_dual_lshlrev_b32 v24, 16, v26
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v29
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v20, v21, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v21, v26, v22 :: v_dual_and_b32 v24, 0xffff0000, v0
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v25
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v26, 16, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v23, v25, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v27
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v25, 16, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v22, v27, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v7
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v24, v26, v25, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v27, v27
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v23
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v7, v15 :: v_dual_and_b32 v26, 0xffff0000, v8
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v7
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v15
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v26, v26
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v25, v25, v24, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v28, v28
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v15, v15, v7 :: v_dual_lshlrev_b32 v26, 16, v24
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v27
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v22, v23, v22 :: v_dual_lshlrev_b32 v27, 16, v25
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v6
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v14, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v15
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v26, v27
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v26, v25, v24 :: v_dual_lshlrev_b32 v23, 16, v14
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v29, v28
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v27, v15, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v14, v14, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v24
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v23, v26, v24, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v27, v7 :: v_dual_lshlrev_b32 v24, 16, v14
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v25
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v23, v23, v25, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v15
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v26
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v7, v15 :: v_dual_lshlrev_b32 v28, 16, v6
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v28, v24
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v15, v14, v6 :: v_dual_lshlrev_b32 v24, 16, v27
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v25
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v23, v26, v23, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v15, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v27, v7 :: v_dual_lshlrev_b32 v24, 16, v5
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v14
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v7, v16, v7, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v14, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v13 :: v_dual_lshlrev_b32 v24, 16, v4
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v15
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v14
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v15, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v3
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v5
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v6, v17, v6, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v13, v13, v5 :: v_dual_lshlrev_b32 v14, 16, v12
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v12, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v12, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v11, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v15, v13, v5 :: v_dual_lshlrev_b32 v24, 16, v12
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v11
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v11, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v4
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v15, v5, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v3
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v11
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v14, v12, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v5, v13, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v14, v4 :: v_dual_lshlrev_b32 v13, 16, v15
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v24, v11, v3, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v14
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v15, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12
; GFX12-FAKE16-NEXT:    v_perm_b32 v5, v18, v5, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v12, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v24, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v11 :: v_dual_lshlrev_b32 v12, 16, v2
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v2, v10 :: v_dual_lshlrev_b32 v15, 16, v24
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v15
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v24, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v0
; GFX12-FAKE16-NEXT:    v_perm_b32 v3, v20, v3, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v10, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v1
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v8 :: v_dual_lshlrev_b32 v11, 16, v9
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v9, v1 :: v_dual_lshlrev_b32 v12, 16, v8
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v10
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v8, v8, v0 :: v_dual_lshlrev_b32 v15, 16, v2
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v9
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v15, v11
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v10, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v24, v12
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v9, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v11, v2 :: v_dual_lshlrev_b32 v15, 16, v8
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v15
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v15, v8, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v12, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v10, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v15, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v12
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v8, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v15
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v12, v1 :: v_dual_lshlrev_b32 v8, 16, v11
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v10
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v1, v22, v1, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v15, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v23, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v11, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v13
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v2, v21, v2, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v14, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_perm_b32 v4, v19, v4, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call <16 x bfloat> @llvm.maximumnum.v16bf16(<16 x bfloat> %x, <16 x bfloat> %y)
  ret <16 x bfloat> %result
}

define <32 x bfloat> @v_maximumnum_v32bf16(<32 x bfloat> %x, <32 x bfloat> %y) {
; GFX7-LABEL: v_maximumnum_v32bf16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    buffer_load_dword v31, off, s[0:3], s32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:128
; GFX7-NEXT:    v_mul_f32_e32 v30, 1.0, v30
; GFX7-NEXT:    v_and_b32_e32 v30, 0xffff0000, v30
; GFX7-NEXT:    v_mul_f32_e32 v29, 1.0, v29
; GFX7-NEXT:    v_and_b32_e32 v29, 0xffff0000, v29
; GFX7-NEXT:    v_mul_f32_e32 v28, 1.0, v28
; GFX7-NEXT:    v_and_b32_e32 v28, 0xffff0000, v28
; GFX7-NEXT:    v_mul_f32_e32 v27, 1.0, v27
; GFX7-NEXT:    v_and_b32_e32 v27, 0xffff0000, v27
; GFX7-NEXT:    v_mul_f32_e32 v26, 1.0, v26
; GFX7-NEXT:    v_and_b32_e32 v26, 0xffff0000, v26
; GFX7-NEXT:    v_mul_f32_e32 v25, 1.0, v25
; GFX7-NEXT:    v_and_b32_e32 v25, 0xffff0000, v25
; GFX7-NEXT:    v_mul_f32_e32 v24, 1.0, v24
; GFX7-NEXT:    v_and_b32_e32 v24, 0xffff0000, v24
; GFX7-NEXT:    v_mul_f32_e32 v23, 1.0, v23
; GFX7-NEXT:    v_and_b32_e32 v23, 0xffff0000, v23
; GFX7-NEXT:    v_mul_f32_e32 v22, 1.0, v22
; GFX7-NEXT:    v_and_b32_e32 v22, 0xffff0000, v22
; GFX7-NEXT:    v_mul_f32_e32 v21, 1.0, v21
; GFX7-NEXT:    v_and_b32_e32 v21, 0xffff0000, v21
; GFX7-NEXT:    v_mul_f32_e32 v20, 1.0, v20
; GFX7-NEXT:    v_and_b32_e32 v20, 0xffff0000, v20
; GFX7-NEXT:    v_mul_f32_e32 v19, 1.0, v19
; GFX7-NEXT:    v_and_b32_e32 v19, 0xffff0000, v19
; GFX7-NEXT:    v_mul_f32_e32 v18, 1.0, v18
; GFX7-NEXT:    v_and_b32_e32 v18, 0xffff0000, v18
; GFX7-NEXT:    v_mul_f32_e32 v17, 1.0, v17
; GFX7-NEXT:    v_and_b32_e32 v17, 0xffff0000, v17
; GFX7-NEXT:    v_mul_f32_e32 v16, 1.0, v16
; GFX7-NEXT:    v_and_b32_e32 v16, 0xffff0000, v16
; GFX7-NEXT:    v_mul_f32_e32 v15, 1.0, v15
; GFX7-NEXT:    v_and_b32_e32 v15, 0xffff0000, v15
; GFX7-NEXT:    v_mul_f32_e32 v14, 1.0, v14
; GFX7-NEXT:    v_and_b32_e32 v14, 0xffff0000, v14
; GFX7-NEXT:    v_mul_f32_e32 v13, 1.0, v13
; GFX7-NEXT:    v_and_b32_e32 v13, 0xffff0000, v13
; GFX7-NEXT:    v_mul_f32_e32 v12, 1.0, v12
; GFX7-NEXT:    v_and_b32_e32 v12, 0xffff0000, v12
; GFX7-NEXT:    v_mul_f32_e32 v11, 1.0, v11
; GFX7-NEXT:    v_and_b32_e32 v11, 0xffff0000, v11
; GFX7-NEXT:    v_mul_f32_e32 v10, 1.0, v10
; GFX7-NEXT:    v_and_b32_e32 v10, 0xffff0000, v10
; GFX7-NEXT:    v_mul_f32_e32 v9, 1.0, v9
; GFX7-NEXT:    v_and_b32_e32 v9, 0xffff0000, v9
; GFX7-NEXT:    v_mul_f32_e32 v8, 1.0, v8
; GFX7-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; GFX7-NEXT:    v_mul_f32_e32 v7, 1.0, v7
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v6
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    s_waitcnt vmcnt(1)
; GFX7-NEXT:    v_mul_f32_e32 v31, 1.0, v31
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_and_b32_e32 v31, 0xffff0000, v31
; GFX7-NEXT:    v_max_f32_e32 v31, v31, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:124
; GFX7-NEXT:    v_and_b32_e32 v31, 0xffff0000, v31
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v30, v30, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:120
; GFX7-NEXT:    v_and_b32_e32 v30, 0xffff0000, v30
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v29, v29, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:116
; GFX7-NEXT:    v_and_b32_e32 v29, 0xffff0000, v29
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v28, v28, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:112
; GFX7-NEXT:    v_and_b32_e32 v28, 0xffff0000, v28
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v27, v27, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:108
; GFX7-NEXT:    v_and_b32_e32 v27, 0xffff0000, v27
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v26, v26, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:104
; GFX7-NEXT:    v_and_b32_e32 v26, 0xffff0000, v26
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v25, v25, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:100
; GFX7-NEXT:    v_and_b32_e32 v25, 0xffff0000, v25
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v24, v24, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:96
; GFX7-NEXT:    v_and_b32_e32 v24, 0xffff0000, v24
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v23, v23, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:92
; GFX7-NEXT:    v_and_b32_e32 v23, 0xffff0000, v23
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v22, v22, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:88
; GFX7-NEXT:    v_and_b32_e32 v22, 0xffff0000, v22
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v21, v21, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:84
; GFX7-NEXT:    v_and_b32_e32 v21, 0xffff0000, v21
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v20, v20, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:80
; GFX7-NEXT:    v_and_b32_e32 v20, 0xffff0000, v20
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v19, v19, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:76
; GFX7-NEXT:    v_and_b32_e32 v19, 0xffff0000, v19
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v18, v18, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:72
; GFX7-NEXT:    v_and_b32_e32 v18, 0xffff0000, v18
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v17, v17, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:68
; GFX7-NEXT:    v_and_b32_e32 v17, 0xffff0000, v17
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v16, v16, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:64
; GFX7-NEXT:    v_and_b32_e32 v16, 0xffff0000, v16
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v15, v15, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:60
; GFX7-NEXT:    v_and_b32_e32 v15, 0xffff0000, v15
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v14, v14, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:56
; GFX7-NEXT:    v_and_b32_e32 v14, 0xffff0000, v14
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v13, v13, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:52
; GFX7-NEXT:    v_and_b32_e32 v13, 0xffff0000, v13
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v12, v12, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:48
; GFX7-NEXT:    v_and_b32_e32 v12, 0xffff0000, v12
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v11, v11, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:44
; GFX7-NEXT:    v_and_b32_e32 v11, 0xffff0000, v11
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v10, v10, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:40
; GFX7-NEXT:    v_and_b32_e32 v10, 0xffff0000, v10
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v9, v9, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:36
; GFX7-NEXT:    v_and_b32_e32 v9, 0xffff0000, v9
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v8, v8, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:32
; GFX7-NEXT:    v_and_b32_e32 v8, 0xffff0000, v8
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v7, v7, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:28
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v6, v6, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:24
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v5, v5, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:20
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v4, v4, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:16
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v3, v3, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:12
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:8
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v32
; GFX7-NEXT:    buffer_load_dword v32, off, s[0:3], s32 offset:4
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    s_waitcnt vmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v32, 1.0, v32
; GFX7-NEXT:    v_and_b32_e32 v32, 0xffff0000, v32
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v32
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_v32bf16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    buffer_load_dword v55, off, s[0:3], s32
; GFX8-NEXT:    v_and_b32_e32 v31, 0xffff0000, v14
; GFX8-NEXT:    v_lshrrev_b32_e32 v34, 16, v30
; GFX8-NEXT:    v_lshrrev_b32_e32 v35, 16, v14
; GFX8-NEXT:    v_and_b32_e32 v37, 0xffff0000, v13
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v31, v31
; GFX8-NEXT:    v_and_b32_e32 v36, 0xffff0000, v30
; GFX8-NEXT:    v_lshrrev_b32_e32 v38, 16, v29
; GFX8-NEXT:    v_lshrrev_b32_e32 v39, 16, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v31, v35, v34, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v37, v37
; GFX8-NEXT:    v_and_b32_e32 v48, 0xffff0000, v29
; GFX8-NEXT:    v_cndmask_b32_e32 v35, v39, v38, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v36, v36
; GFX8-NEXT:    v_cndmask_b32_e32 v34, v34, v31, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v48, v48
; GFX8-NEXT:    v_lshlrev_b32_e32 v37, 16, v31
; GFX8-NEXT:    v_cndmask_b32_e32 v38, v38, v35, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v39, 16, v34
; GFX8-NEXT:    v_lshlrev_b32_e32 v36, 16, v35
; GFX8-NEXT:    v_lshlrev_b32_e32 v48, 16, v38
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v37, v39
; GFX8-NEXT:    v_cndmask_b32_e32 v37, v34, v31, vcc
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v36, v48
; GFX8-NEXT:    v_cndmask_b32_e32 v36, v38, v35, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v31
; GFX8-NEXT:    v_cndmask_b32_e32 v31, v37, v31, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v35
; GFX8-NEXT:    v_cndmask_b32_e32 v35, v36, v35, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v34
; GFX8-NEXT:    v_lshlrev_b32_e32 v39, 16, v37
; GFX8-NEXT:    v_cndmask_b32_e32 v31, v31, v34, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v38
; GFX8-NEXT:    v_and_b32_e32 v32, 0xffff0000, v15
; GFX8-NEXT:    v_cndmask_b32_e32 v34, v35, v38, vcc
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v39
; GFX8-NEXT:    v_lshrrev_b32_e32 v33, 16, v15
; GFX8-NEXT:    v_cndmask_b32_e32 v31, v37, v31, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v32, v32
; GFX8-NEXT:    v_lshlrev_b32_e32 v48, 16, v36
; GFX8-NEXT:    v_and_b32_e32 v38, 0xffff0000, v27
; GFX8-NEXT:    v_and_b32_e32 v39, 0xffff0000, v26
; GFX8-NEXT:    v_and_b32_e32 v49, 0xffff0000, v24
; GFX8-NEXT:    v_and_b32_e32 v50, 0xffff0000, v23
; GFX8-NEXT:    v_and_b32_e32 v51, 0xffff0000, v22
; GFX8-NEXT:    v_and_b32_e32 v52, 0xffff0000, v21
; GFX8-NEXT:    v_and_b32_e32 v53, 0xffff0000, v20
; GFX8-NEXT:    v_and_b32_e32 v54, 0xffff0000, v19
; GFX8-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX8-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX8-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX8-NEXT:    v_and_b32_e32 v40, 0xffff0000, v18
; GFX8-NEXT:    v_and_b32_e32 v41, 0xffff0000, v17
; GFX8-NEXT:    v_and_b32_e32 v42, 0xffff0000, v16
; GFX8-NEXT:    s_waitcnt vmcnt(3)
; GFX8-NEXT:    v_lshrrev_b32_e32 v35, 16, v55
; GFX8-NEXT:    v_and_b32_e32 v37, 0xffff0000, v55
; GFX8-NEXT:    v_cndmask_b32_e32 v32, v33, v35, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v37, v37
; GFX8-NEXT:    v_cndmask_b32_e32 v35, v35, v32, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v33, 16, v32
; GFX8-NEXT:    v_lshlrev_b32_e32 v37, 16, v35
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v33, v37
; GFX8-NEXT:    v_cndmask_b32_e32 v33, v35, v32, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v32
; GFX8-NEXT:    v_cndmask_b32_e32 v32, v33, v32, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v37, 16, v33
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v35
; GFX8-NEXT:    v_cndmask_b32_e32 v32, v32, v35, vcc
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v37
; GFX8-NEXT:    v_cndmask_b32_e32 v32, v33, v32, vcc
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v48
; GFX8-NEXT:    v_cndmask_b32_e32 v33, v36, v34, vcc
; GFX8-NEXT:    v_and_b32_e32 v34, 0xffff0000, v12
; GFX8-NEXT:    v_lshrrev_b32_e32 v35, 16, v28
; GFX8-NEXT:    v_lshrrev_b32_e32 v36, 16, v12
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v34, v34
; GFX8-NEXT:    v_and_b32_e32 v37, 0xffff0000, v28
; GFX8-NEXT:    v_cndmask_b32_e32 v34, v36, v35, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v37, v37
; GFX8-NEXT:    v_cndmask_b32_e32 v35, v35, v34, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v36, 16, v34
; GFX8-NEXT:    v_lshlrev_b32_e32 v37, 16, v35
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v36, v37
; GFX8-NEXT:    v_cndmask_b32_e32 v36, v35, v34, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v34
; GFX8-NEXT:    v_cndmask_b32_e32 v34, v36, v34, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v35
; GFX8-NEXT:    v_cndmask_b32_e32 v34, v34, v35, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v35, 16, v36
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v35
; GFX8-NEXT:    v_and_b32_e32 v35, 0xffff0000, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v34, v36, v34, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v36, 16, v27
; GFX8-NEXT:    v_lshrrev_b32_e32 v37, 16, v11
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v35, v35
; GFX8-NEXT:    v_cndmask_b32_e32 v35, v37, v36, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v38, v38
; GFX8-NEXT:    v_cndmask_b32_e32 v36, v36, v35, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v37, 16, v35
; GFX8-NEXT:    v_lshlrev_b32_e32 v38, 16, v36
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v37, v38
; GFX8-NEXT:    v_cndmask_b32_e32 v37, v36, v35, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v35
; GFX8-NEXT:    v_cndmask_b32_e32 v35, v37, v35, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v36
; GFX8-NEXT:    v_cndmask_b32_e32 v35, v35, v36, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v36, 16, v37
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v36
; GFX8-NEXT:    v_and_b32_e32 v36, 0xffff0000, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v35, v37, v35, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v37, 16, v26
; GFX8-NEXT:    v_lshrrev_b32_e32 v38, 16, v10
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v36, v36
; GFX8-NEXT:    v_cndmask_b32_e32 v36, v38, v37, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v39, v39
; GFX8-NEXT:    v_cndmask_b32_e32 v37, v37, v36, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v38, 16, v36
; GFX8-NEXT:    v_lshlrev_b32_e32 v39, 16, v37
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v38, v39
; GFX8-NEXT:    v_cndmask_b32_e32 v38, v37, v36, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v36
; GFX8-NEXT:    v_cndmask_b32_e32 v36, v38, v36, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v37
; GFX8-NEXT:    v_cndmask_b32_e32 v36, v36, v37, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v37, 16, v38
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v37
; GFX8-NEXT:    v_and_b32_e32 v37, 0xffff0000, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v36, v38, v36, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v38, 16, v25
; GFX8-NEXT:    v_lshrrev_b32_e32 v39, 16, v9
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v37, v37
; GFX8-NEXT:    v_and_b32_e32 v48, 0xffff0000, v25
; GFX8-NEXT:    v_cndmask_b32_e32 v37, v39, v38, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v48, v48
; GFX8-NEXT:    v_cndmask_b32_e32 v38, v38, v37, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v39, 16, v37
; GFX8-NEXT:    v_lshlrev_b32_e32 v48, 16, v38
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v39, v48
; GFX8-NEXT:    v_cndmask_b32_e32 v39, v38, v37, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v37
; GFX8-NEXT:    v_cndmask_b32_e32 v37, v39, v37, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v38
; GFX8-NEXT:    v_cndmask_b32_e32 v37, v37, v38, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v38, 16, v39
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v38
; GFX8-NEXT:    v_and_b32_e32 v38, 0xffff0000, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v37, v39, v37, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v39, 16, v24
; GFX8-NEXT:    v_lshrrev_b32_e32 v48, 16, v8
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v38, v38
; GFX8-NEXT:    v_cndmask_b32_e32 v38, v48, v39, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v49, v49
; GFX8-NEXT:    v_cndmask_b32_e32 v39, v39, v38, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v48, 16, v38
; GFX8-NEXT:    v_lshlrev_b32_e32 v49, 16, v39
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v48, v49
; GFX8-NEXT:    v_cndmask_b32_e32 v48, v39, v38, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v38
; GFX8-NEXT:    v_cndmask_b32_e32 v38, v48, v38, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v39
; GFX8-NEXT:    v_cndmask_b32_e32 v38, v38, v39, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v39, 16, v48
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v39
; GFX8-NEXT:    v_and_b32_e32 v39, 0xffff0000, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v38, v48, v38, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v48, 16, v23
; GFX8-NEXT:    v_lshrrev_b32_e32 v49, 16, v7
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v39, v39
; GFX8-NEXT:    v_cndmask_b32_e32 v39, v49, v48, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v50, v50
; GFX8-NEXT:    v_cndmask_b32_e32 v48, v48, v39, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v49, 16, v39
; GFX8-NEXT:    v_lshlrev_b32_e32 v50, 16, v48
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v49, v50
; GFX8-NEXT:    v_cndmask_b32_e32 v49, v48, v39, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v39
; GFX8-NEXT:    v_cndmask_b32_e32 v39, v49, v39, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v48
; GFX8-NEXT:    v_cndmask_b32_e32 v39, v39, v48, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v48, 16, v49
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v48
; GFX8-NEXT:    v_and_b32_e32 v48, 0xffff0000, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v39, v49, v39, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v49, 16, v22
; GFX8-NEXT:    v_lshrrev_b32_e32 v50, 16, v6
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v48, v48
; GFX8-NEXT:    v_cndmask_b32_e32 v48, v50, v49, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v51, v51
; GFX8-NEXT:    v_cndmask_b32_e32 v49, v49, v48, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v50, 16, v48
; GFX8-NEXT:    v_lshlrev_b32_e32 v51, 16, v49
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v50, v51
; GFX8-NEXT:    v_cndmask_b32_e32 v50, v49, v48, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v48
; GFX8-NEXT:    v_cndmask_b32_e32 v48, v50, v48, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v49
; GFX8-NEXT:    v_cndmask_b32_e32 v48, v48, v49, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v49, 16, v50
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v49
; GFX8-NEXT:    v_and_b32_e32 v49, 0xffff0000, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v48, v50, v48, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v50, 16, v21
; GFX8-NEXT:    v_lshrrev_b32_e32 v51, 16, v5
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v49, v49
; GFX8-NEXT:    v_cndmask_b32_e32 v49, v51, v50, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v52, v52
; GFX8-NEXT:    v_cndmask_b32_e32 v50, v50, v49, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v51, 16, v49
; GFX8-NEXT:    v_lshlrev_b32_e32 v52, 16, v50
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v51, v52
; GFX8-NEXT:    v_cndmask_b32_e32 v51, v50, v49, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v49
; GFX8-NEXT:    v_cndmask_b32_e32 v49, v51, v49, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v50
; GFX8-NEXT:    v_cndmask_b32_e32 v49, v49, v50, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v50, 16, v51
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v50
; GFX8-NEXT:    v_and_b32_e32 v50, 0xffff0000, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v49, v51, v49, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v51, 16, v20
; GFX8-NEXT:    v_lshrrev_b32_e32 v52, 16, v4
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v50, v50
; GFX8-NEXT:    v_cndmask_b32_e32 v50, v52, v51, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v53, v53
; GFX8-NEXT:    v_cndmask_b32_e32 v51, v51, v50, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v52, 16, v50
; GFX8-NEXT:    v_lshlrev_b32_e32 v53, 16, v51
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v52, v53
; GFX8-NEXT:    v_cndmask_b32_e32 v52, v51, v50, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v50
; GFX8-NEXT:    v_cndmask_b32_e32 v50, v52, v50, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v51
; GFX8-NEXT:    v_cndmask_b32_e32 v50, v50, v51, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v51, 16, v52
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v51
; GFX8-NEXT:    v_and_b32_e32 v51, 0xffff0000, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v50, v52, v50, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v52, 16, v19
; GFX8-NEXT:    v_lshrrev_b32_e32 v53, 16, v3
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v51, v51
; GFX8-NEXT:    v_cndmask_b32_e32 v51, v53, v52, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v54, v54
; GFX8-NEXT:    v_cndmask_b32_e32 v52, v52, v51, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v53, 16, v51
; GFX8-NEXT:    v_lshlrev_b32_e32 v54, 16, v52
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v53, v54
; GFX8-NEXT:    v_cndmask_b32_e32 v53, v52, v51, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v51
; GFX8-NEXT:    v_cndmask_b32_e32 v51, v53, v51, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v52
; GFX8-NEXT:    v_cndmask_b32_e32 v51, v51, v52, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v52, 16, v53
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v52
; GFX8-NEXT:    v_and_b32_e32 v52, 0xffff0000, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v51, v53, v51, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v53, 16, v18
; GFX8-NEXT:    v_lshrrev_b32_e32 v54, 16, v2
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v52, v52
; GFX8-NEXT:    v_cndmask_b32_e32 v52, v54, v53, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v40, v40
; GFX8-NEXT:    v_cndmask_b32_e32 v53, v53, v52, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v54, 16, v52
; GFX8-NEXT:    v_lshlrev_b32_e32 v40, 16, v53
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v54, v40
; GFX8-NEXT:    v_cndmask_b32_e32 v54, v53, v52, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v52
; GFX8-NEXT:    v_cndmask_b32_e32 v52, v54, v52, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v53
; GFX8-NEXT:    v_cndmask_b32_e32 v52, v52, v53, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v53, 16, v54
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v53
; GFX8-NEXT:    v_and_b32_e32 v53, 0xffff0000, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v52, v54, v52, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v54, 16, v17
; GFX8-NEXT:    v_lshrrev_b32_e32 v40, 16, v1
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v53, v53
; GFX8-NEXT:    v_cndmask_b32_e32 v53, v40, v54, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v41, v41
; GFX8-NEXT:    v_cndmask_b32_e32 v54, v54, v53, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v40, 16, v53
; GFX8-NEXT:    v_lshlrev_b32_e32 v41, 16, v54
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v40, v41
; GFX8-NEXT:    v_cndmask_b32_e32 v40, v54, v53, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v53
; GFX8-NEXT:    v_cndmask_b32_e32 v53, v40, v53, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v54
; GFX8-NEXT:    v_cndmask_b32_e32 v53, v53, v54, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v54, 16, v40
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v54
; GFX8-NEXT:    v_and_b32_e32 v54, 0xffff0000, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v53, v40, v53, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v40, 16, v16
; GFX8-NEXT:    v_lshrrev_b32_e32 v41, 16, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v54, v54
; GFX8-NEXT:    v_cndmask_b32_e32 v54, v41, v40, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v42, v42
; GFX8-NEXT:    v_cndmask_b32_e32 v40, v40, v54, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v41, 16, v54
; GFX8-NEXT:    v_lshlrev_b32_e32 v42, 16, v40
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v41, v42
; GFX8-NEXT:    v_cndmask_b32_e32 v41, v40, v54, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v54
; GFX8-NEXT:    v_cndmask_b32_e32 v54, v41, v54, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v40
; GFX8-NEXT:    v_cndmask_b32_e32 v54, v54, v40, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v40, 16, v41
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v40
; GFX8-NEXT:    v_lshlrev_b32_e32 v40, 16, v15
; GFX8-NEXT:    v_cndmask_b32_e32 v54, v41, v54, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v40, v40
; GFX8-NEXT:    v_lshlrev_b32_e32 v40, 16, v55
; GFX8-NEXT:    v_cndmask_b32_e32 v15, v15, v55, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v40, v40
; GFX8-NEXT:    v_cndmask_b32_e32 v55, v55, v15, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v40, 16, v55
; GFX8-NEXT:    v_lshlrev_b32_e32 v41, 16, v15
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v41, v40
; GFX8-NEXT:    v_cndmask_b32_e32 v40, v55, v15, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v15
; GFX8-NEXT:    v_cndmask_b32_e32 v15, v40, v15, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v55
; GFX8-NEXT:    v_cndmask_b32_e32 v15, v15, v55, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v55, 16, v40
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v55
; GFX8-NEXT:    v_lshlrev_b32_e32 v55, 16, v14
; GFX8-NEXT:    v_cndmask_b32_e32 v15, v40, v15, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v55, v55
; GFX8-NEXT:    v_lshlrev_b32_e32 v55, 16, v30
; GFX8-NEXT:    v_cndmask_b32_e32 v14, v14, v30, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v55, v55
; GFX8-NEXT:    v_cndmask_b32_e32 v30, v30, v14, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v55, 16, v30
; GFX8-NEXT:    v_lshlrev_b32_e32 v40, 16, v14
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v40, v55
; GFX8-NEXT:    v_cndmask_b32_e32 v55, v30, v14, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v14
; GFX8-NEXT:    v_cndmask_b32_e32 v14, v55, v14, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v30
; GFX8-NEXT:    v_cndmask_b32_e32 v14, v14, v30, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v30, 16, v55
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v30
; GFX8-NEXT:    v_lshlrev_b32_e32 v30, 16, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v14, v55, v14, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v30, v30
; GFX8-NEXT:    v_lshlrev_b32_e32 v30, 16, v29
; GFX8-NEXT:    v_cndmask_b32_e32 v13, v13, v29, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v30, v30
; GFX8-NEXT:    v_cndmask_b32_e32 v29, v29, v13, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v30, 16, v29
; GFX8-NEXT:    v_lshlrev_b32_e32 v55, 16, v13
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v55, v30
; GFX8-NEXT:    v_cndmask_b32_e32 v30, v29, v13, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v13
; GFX8-NEXT:    v_cndmask_b32_e32 v13, v30, v13, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v29
; GFX8-NEXT:    v_cndmask_b32_e32 v13, v13, v29, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v29, 16, v30
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v29
; GFX8-NEXT:    v_lshlrev_b32_e32 v29, 16, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v13, v30, v13, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v29, v29
; GFX8-NEXT:    v_lshlrev_b32_e32 v29, 16, v28
; GFX8-NEXT:    v_cndmask_b32_e32 v12, v12, v28, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v29, v29
; GFX8-NEXT:    v_cndmask_b32_e32 v28, v28, v12, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v29, 16, v28
; GFX8-NEXT:    v_lshlrev_b32_e32 v30, 16, v12
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v30, v29
; GFX8-NEXT:    v_cndmask_b32_e32 v29, v28, v12, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v12
; GFX8-NEXT:    v_cndmask_b32_e32 v12, v29, v12, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v28
; GFX8-NEXT:    v_cndmask_b32_e32 v12, v12, v28, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v28, 16, v29
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v28
; GFX8-NEXT:    v_lshlrev_b32_e32 v28, 16, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v12, v29, v12, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v28, v28
; GFX8-NEXT:    v_lshlrev_b32_e32 v28, 16, v27
; GFX8-NEXT:    v_cndmask_b32_e32 v11, v11, v27, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v28, v28
; GFX8-NEXT:    v_cndmask_b32_e32 v27, v27, v11, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v28, 16, v27
; GFX8-NEXT:    v_lshlrev_b32_e32 v29, 16, v11
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v29, v28
; GFX8-NEXT:    v_cndmask_b32_e32 v28, v27, v11, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v11
; GFX8-NEXT:    v_cndmask_b32_e32 v11, v28, v11, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v27
; GFX8-NEXT:    v_cndmask_b32_e32 v11, v11, v27, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v27, 16, v28
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v27
; GFX8-NEXT:    v_lshlrev_b32_e32 v27, 16, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v11, v28, v11, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v27, v27
; GFX8-NEXT:    v_lshlrev_b32_e32 v27, 16, v26
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v10, v26, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v27, v27
; GFX8-NEXT:    v_cndmask_b32_e32 v26, v26, v10, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v27, 16, v26
; GFX8-NEXT:    v_lshlrev_b32_e32 v28, 16, v10
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v28, v27
; GFX8-NEXT:    v_cndmask_b32_e32 v27, v26, v10, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v10
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v27, v10, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v26
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v10, v26, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v26, 16, v27
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v26
; GFX8-NEXT:    v_lshlrev_b32_e32 v26, 16, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v10, v27, v10, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v26, v26
; GFX8-NEXT:    v_lshlrev_b32_e32 v26, 16, v25
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v9, v25, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v26, v26
; GFX8-NEXT:    v_cndmask_b32_e32 v25, v25, v9, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v26, 16, v25
; GFX8-NEXT:    v_lshlrev_b32_e32 v27, 16, v9
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v27, v26
; GFX8-NEXT:    v_cndmask_b32_e32 v26, v25, v9, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v26, v9, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v25
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v9, v25, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v25, 16, v26
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v25
; GFX8-NEXT:    v_lshlrev_b32_e32 v25, 16, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v9, v26, v9, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v25, v25
; GFX8-NEXT:    v_lshlrev_b32_e32 v25, 16, v24
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v8, v24, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v25, v25
; GFX8-NEXT:    v_cndmask_b32_e32 v24, v24, v8, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v25, 16, v24
; GFX8-NEXT:    v_lshlrev_b32_e32 v26, 16, v8
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v26, v25
; GFX8-NEXT:    v_cndmask_b32_e32 v25, v24, v8, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v25, v8, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v24
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v8, v24, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v24
; GFX8-NEXT:    v_lshlrev_b32_e32 v24, 16, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v8, v25, v8, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX8-NEXT:    v_lshlrev_b32_e32 v24, 16, v23
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v7, v23, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX8-NEXT:    v_cndmask_b32_e32 v23, v23, v7, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v24, 16, v23
; GFX8-NEXT:    v_lshlrev_b32_e32 v25, 16, v7
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v25, v24
; GFX8-NEXT:    v_cndmask_b32_e32 v24, v23, v7, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v24, v7, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v23
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v7, v23, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v23, 16, v24
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v23
; GFX8-NEXT:    v_lshlrev_b32_e32 v23, 16, v6
; GFX8-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX8-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX8-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v24, v7, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v23, v23
; GFX8-NEXT:    v_lshlrev_b32_e32 v23, 16, v22
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v6, v22, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v23, v23
; GFX8-NEXT:    v_cndmask_b32_e32 v22, v22, v6, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v23, 16, v22
; GFX8-NEXT:    v_lshlrev_b32_e32 v24, 16, v6
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v24, v23
; GFX8-NEXT:    v_cndmask_b32_e32 v23, v22, v6, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v23, v6, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v22
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v6, v22, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v22, 16, v23
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v22
; GFX8-NEXT:    v_lshlrev_b32_e32 v22, 16, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v23, v6, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v22, v22
; GFX8-NEXT:    v_lshlrev_b32_e32 v22, 16, v21
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v5, v21, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v22, v22
; GFX8-NEXT:    v_cndmask_b32_e32 v21, v21, v5, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v22, 16, v21
; GFX8-NEXT:    v_lshlrev_b32_e32 v23, 16, v5
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v23, v22
; GFX8-NEXT:    v_cndmask_b32_e32 v22, v21, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v22, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v21
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v5, v21, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v21, 16, v22
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v21
; GFX8-NEXT:    v_lshlrev_b32_e32 v21, 16, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v22, v5, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v21, v21
; GFX8-NEXT:    v_lshlrev_b32_e32 v21, 16, v20
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v20, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v21, v21
; GFX8-NEXT:    v_cndmask_b32_e32 v20, v20, v4, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v21, 16, v20
; GFX8-NEXT:    v_lshlrev_b32_e32 v22, 16, v4
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v22, v21
; GFX8-NEXT:    v_cndmask_b32_e32 v21, v20, v4, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v21, v4, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v20
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v20, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v20, 16, v21
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v20
; GFX8-NEXT:    v_lshlrev_b32_e32 v20, 16, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v21, v4, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v20, v20
; GFX8-NEXT:    v_lshlrev_b32_e32 v20, 16, v19
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v19, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v20, v20
; GFX8-NEXT:    v_cndmask_b32_e32 v19, v19, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v20, 16, v19
; GFX8-NEXT:    v_lshlrev_b32_e32 v21, 16, v3
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v21, v20
; GFX8-NEXT:    v_cndmask_b32_e32 v20, v19, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v20, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v19
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v19, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v19, 16, v20
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v19
; GFX8-NEXT:    v_lshlrev_b32_e32 v19, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v20, v3, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v19, v19
; GFX8-NEXT:    v_lshlrev_b32_e32 v19, 16, v18
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v18, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v19, v19
; GFX8-NEXT:    v_cndmask_b32_e32 v18, v18, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v19, 16, v18
; GFX8-NEXT:    v_lshlrev_b32_e32 v20, 16, v2
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v20, v19
; GFX8-NEXT:    v_cndmask_b32_e32 v19, v18, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v19, v2, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v18
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v18, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v18, 16, v19
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v18
; GFX8-NEXT:    v_lshlrev_b32_e32 v18, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v19, v2, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v18, v18
; GFX8-NEXT:    v_lshlrev_b32_e32 v18, 16, v17
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v17, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v18, v18
; GFX8-NEXT:    v_cndmask_b32_e32 v17, v17, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v18, 16, v17
; GFX8-NEXT:    v_lshlrev_b32_e32 v19, 16, v1
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v19, v18
; GFX8-NEXT:    v_cndmask_b32_e32 v18, v17, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v18, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v17
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v17, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v17, 16, v18
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v17
; GFX8-NEXT:    v_lshlrev_b32_e32 v17, 16, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v18, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v17, v17
; GFX8-NEXT:    v_lshlrev_b32_e32 v17, 16, v16
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v17, v17
; GFX8-NEXT:    v_cndmask_b32_e32 v16, v16, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v17, 16, v16
; GFX8-NEXT:    v_lshlrev_b32_e32 v18, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v18, v17
; GFX8-NEXT:    v_cndmask_b32_e32 v17, v16, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v16
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v17
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v16
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v17, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v54
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v53
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v52
; GFX8-NEXT:    v_or_b32_sdwa v2, v2, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v51
; GFX8-NEXT:    v_or_b32_sdwa v3, v3, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v50
; GFX8-NEXT:    v_or_b32_sdwa v4, v4, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v49
; GFX8-NEXT:    v_or_b32_sdwa v5, v5, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v48
; GFX8-NEXT:    v_or_b32_sdwa v6, v6, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v39
; GFX8-NEXT:    v_or_b32_sdwa v7, v7, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v38
; GFX8-NEXT:    v_or_b32_sdwa v8, v8, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v37
; GFX8-NEXT:    v_or_b32_sdwa v9, v9, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v36
; GFX8-NEXT:    v_or_b32_sdwa v10, v10, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v35
; GFX8-NEXT:    v_or_b32_sdwa v11, v11, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v34
; GFX8-NEXT:    v_or_b32_sdwa v12, v12, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v33
; GFX8-NEXT:    v_or_b32_sdwa v13, v13, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v31
; GFX8-NEXT:    v_or_b32_sdwa v14, v14, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v16, 16, v32
; GFX8-NEXT:    v_or_b32_sdwa v15, v15, v16 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_waitcnt vmcnt(0)
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_v32bf16:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    buffer_load_dword v55, off, s[0:3], s32
; GFX900-NEXT:    v_and_b32_e32 v31, 0xffff0000, v14
; GFX900-NEXT:    v_lshrrev_b32_e32 v34, 16, v30
; GFX900-NEXT:    v_lshrrev_b32_e32 v35, 16, v14
; GFX900-NEXT:    v_and_b32_e32 v37, 0xffff0000, v13
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v31, v31
; GFX900-NEXT:    v_and_b32_e32 v36, 0xffff0000, v30
; GFX900-NEXT:    v_lshrrev_b32_e32 v38, 16, v29
; GFX900-NEXT:    v_lshrrev_b32_e32 v39, 16, v13
; GFX900-NEXT:    v_cndmask_b32_e32 v31, v35, v34, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v37, v37
; GFX900-NEXT:    v_and_b32_e32 v48, 0xffff0000, v29
; GFX900-NEXT:    v_cndmask_b32_e32 v35, v39, v38, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v36, v36
; GFX900-NEXT:    v_cndmask_b32_e32 v34, v34, v31, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v48, v48
; GFX900-NEXT:    v_lshlrev_b32_e32 v37, 16, v31
; GFX900-NEXT:    v_cndmask_b32_e32 v38, v38, v35, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v39, 16, v34
; GFX900-NEXT:    v_lshlrev_b32_e32 v36, 16, v35
; GFX900-NEXT:    v_lshlrev_b32_e32 v48, 16, v38
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v37, v39
; GFX900-NEXT:    v_cndmask_b32_e32 v37, v34, v31, vcc
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v36, v48
; GFX900-NEXT:    v_cndmask_b32_e32 v36, v38, v35, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v31
; GFX900-NEXT:    v_cndmask_b32_e32 v31, v37, v31, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v35
; GFX900-NEXT:    v_cndmask_b32_e32 v35, v36, v35, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v34
; GFX900-NEXT:    v_lshlrev_b32_e32 v39, 16, v37
; GFX900-NEXT:    v_cndmask_b32_e32 v31, v31, v34, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v38
; GFX900-NEXT:    v_and_b32_e32 v32, 0xffff0000, v15
; GFX900-NEXT:    v_cndmask_b32_e32 v34, v35, v38, vcc
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v39
; GFX900-NEXT:    v_lshrrev_b32_e32 v33, 16, v15
; GFX900-NEXT:    v_cndmask_b32_e32 v31, v37, v31, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v32, v32
; GFX900-NEXT:    v_lshlrev_b32_e32 v48, 16, v36
; GFX900-NEXT:    v_and_b32_e32 v38, 0xffff0000, v27
; GFX900-NEXT:    v_and_b32_e32 v39, 0xffff0000, v26
; GFX900-NEXT:    v_and_b32_e32 v49, 0xffff0000, v24
; GFX900-NEXT:    v_and_b32_e32 v50, 0xffff0000, v23
; GFX900-NEXT:    v_and_b32_e32 v51, 0xffff0000, v22
; GFX900-NEXT:    v_and_b32_e32 v52, 0xffff0000, v21
; GFX900-NEXT:    v_and_b32_e32 v53, 0xffff0000, v20
; GFX900-NEXT:    v_and_b32_e32 v54, 0xffff0000, v19
; GFX900-NEXT:    buffer_store_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Spill
; GFX900-NEXT:    buffer_store_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Spill
; GFX900-NEXT:    buffer_store_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Spill
; GFX900-NEXT:    v_and_b32_e32 v40, 0xffff0000, v18
; GFX900-NEXT:    v_and_b32_e32 v41, 0xffff0000, v17
; GFX900-NEXT:    v_and_b32_e32 v42, 0xffff0000, v16
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    s_waitcnt vmcnt(3)
; GFX900-NEXT:    v_lshrrev_b32_e32 v35, 16, v55
; GFX900-NEXT:    v_and_b32_e32 v37, 0xffff0000, v55
; GFX900-NEXT:    v_cndmask_b32_e32 v32, v33, v35, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v37, v37
; GFX900-NEXT:    v_cndmask_b32_e32 v35, v35, v32, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v33, 16, v32
; GFX900-NEXT:    v_lshlrev_b32_e32 v37, 16, v35
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v33, v37
; GFX900-NEXT:    v_cndmask_b32_e32 v33, v35, v32, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v32
; GFX900-NEXT:    v_cndmask_b32_e32 v32, v33, v32, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v37, 16, v33
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v35
; GFX900-NEXT:    v_cndmask_b32_e32 v32, v32, v35, vcc
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v37
; GFX900-NEXT:    v_cndmask_b32_e32 v32, v33, v32, vcc
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v48
; GFX900-NEXT:    v_cndmask_b32_e32 v33, v36, v34, vcc
; GFX900-NEXT:    v_and_b32_e32 v34, 0xffff0000, v12
; GFX900-NEXT:    v_lshrrev_b32_e32 v35, 16, v28
; GFX900-NEXT:    v_lshrrev_b32_e32 v36, 16, v12
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v34, v34
; GFX900-NEXT:    v_and_b32_e32 v37, 0xffff0000, v28
; GFX900-NEXT:    v_cndmask_b32_e32 v34, v36, v35, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v37, v37
; GFX900-NEXT:    v_cndmask_b32_e32 v35, v35, v34, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v36, 16, v34
; GFX900-NEXT:    v_lshlrev_b32_e32 v37, 16, v35
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v36, v37
; GFX900-NEXT:    v_cndmask_b32_e32 v36, v35, v34, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v34
; GFX900-NEXT:    v_cndmask_b32_e32 v34, v36, v34, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v35
; GFX900-NEXT:    v_cndmask_b32_e32 v34, v34, v35, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v35, 16, v36
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v35
; GFX900-NEXT:    v_and_b32_e32 v35, 0xffff0000, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v34, v36, v34, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v36, 16, v27
; GFX900-NEXT:    v_lshrrev_b32_e32 v37, 16, v11
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v35, v35
; GFX900-NEXT:    v_cndmask_b32_e32 v35, v37, v36, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v38, v38
; GFX900-NEXT:    v_cndmask_b32_e32 v36, v36, v35, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v37, 16, v35
; GFX900-NEXT:    v_lshlrev_b32_e32 v38, 16, v36
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v37, v38
; GFX900-NEXT:    v_cndmask_b32_e32 v37, v36, v35, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v35
; GFX900-NEXT:    v_cndmask_b32_e32 v35, v37, v35, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v36
; GFX900-NEXT:    v_cndmask_b32_e32 v35, v35, v36, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v36, 16, v37
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v36
; GFX900-NEXT:    v_and_b32_e32 v36, 0xffff0000, v10
; GFX900-NEXT:    v_cndmask_b32_e32 v35, v37, v35, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v37, 16, v26
; GFX900-NEXT:    v_lshrrev_b32_e32 v38, 16, v10
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v36, v36
; GFX900-NEXT:    v_cndmask_b32_e32 v36, v38, v37, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v39, v39
; GFX900-NEXT:    v_cndmask_b32_e32 v37, v37, v36, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v38, 16, v36
; GFX900-NEXT:    v_lshlrev_b32_e32 v39, 16, v37
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v38, v39
; GFX900-NEXT:    v_cndmask_b32_e32 v38, v37, v36, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v36
; GFX900-NEXT:    v_cndmask_b32_e32 v36, v38, v36, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v37
; GFX900-NEXT:    v_cndmask_b32_e32 v36, v36, v37, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v37, 16, v38
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v37
; GFX900-NEXT:    v_and_b32_e32 v37, 0xffff0000, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v36, v38, v36, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v38, 16, v25
; GFX900-NEXT:    v_lshrrev_b32_e32 v39, 16, v9
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v37, v37
; GFX900-NEXT:    v_and_b32_e32 v48, 0xffff0000, v25
; GFX900-NEXT:    v_cndmask_b32_e32 v37, v39, v38, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v48, v48
; GFX900-NEXT:    v_cndmask_b32_e32 v38, v38, v37, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v39, 16, v37
; GFX900-NEXT:    v_lshlrev_b32_e32 v48, 16, v38
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v39, v48
; GFX900-NEXT:    v_cndmask_b32_e32 v39, v38, v37, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v37
; GFX900-NEXT:    v_cndmask_b32_e32 v37, v39, v37, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v38
; GFX900-NEXT:    v_cndmask_b32_e32 v37, v37, v38, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v38, 16, v39
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v38
; GFX900-NEXT:    v_and_b32_e32 v38, 0xffff0000, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v37, v39, v37, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v39, 16, v24
; GFX900-NEXT:    v_lshrrev_b32_e32 v48, 16, v8
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v38, v38
; GFX900-NEXT:    v_cndmask_b32_e32 v38, v48, v39, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v49, v49
; GFX900-NEXT:    v_cndmask_b32_e32 v39, v39, v38, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v48, 16, v38
; GFX900-NEXT:    v_lshlrev_b32_e32 v49, 16, v39
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v48, v49
; GFX900-NEXT:    v_cndmask_b32_e32 v48, v39, v38, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v38
; GFX900-NEXT:    v_cndmask_b32_e32 v38, v48, v38, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v39
; GFX900-NEXT:    v_cndmask_b32_e32 v38, v38, v39, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v39, 16, v48
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v39
; GFX900-NEXT:    v_and_b32_e32 v39, 0xffff0000, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v38, v48, v38, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v48, 16, v23
; GFX900-NEXT:    v_lshrrev_b32_e32 v49, 16, v7
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v39, v39
; GFX900-NEXT:    v_cndmask_b32_e32 v39, v49, v48, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v50, v50
; GFX900-NEXT:    v_cndmask_b32_e32 v48, v48, v39, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v49, 16, v39
; GFX900-NEXT:    v_lshlrev_b32_e32 v50, 16, v48
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v49, v50
; GFX900-NEXT:    v_cndmask_b32_e32 v49, v48, v39, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v39
; GFX900-NEXT:    v_cndmask_b32_e32 v39, v49, v39, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v48
; GFX900-NEXT:    v_cndmask_b32_e32 v39, v39, v48, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v48, 16, v49
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v48
; GFX900-NEXT:    v_and_b32_e32 v48, 0xffff0000, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v39, v49, v39, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v49, 16, v22
; GFX900-NEXT:    v_lshrrev_b32_e32 v50, 16, v6
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v48, v48
; GFX900-NEXT:    v_cndmask_b32_e32 v48, v50, v49, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v51, v51
; GFX900-NEXT:    v_cndmask_b32_e32 v49, v49, v48, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v50, 16, v48
; GFX900-NEXT:    v_lshlrev_b32_e32 v51, 16, v49
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v50, v51
; GFX900-NEXT:    v_cndmask_b32_e32 v50, v49, v48, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v48
; GFX900-NEXT:    v_cndmask_b32_e32 v48, v50, v48, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v49
; GFX900-NEXT:    v_cndmask_b32_e32 v48, v48, v49, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v49, 16, v50
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v49
; GFX900-NEXT:    v_and_b32_e32 v49, 0xffff0000, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v48, v50, v48, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v50, 16, v21
; GFX900-NEXT:    v_lshrrev_b32_e32 v51, 16, v5
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v49, v49
; GFX900-NEXT:    v_cndmask_b32_e32 v49, v51, v50, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v52, v52
; GFX900-NEXT:    v_cndmask_b32_e32 v50, v50, v49, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v51, 16, v49
; GFX900-NEXT:    v_lshlrev_b32_e32 v52, 16, v50
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v51, v52
; GFX900-NEXT:    v_cndmask_b32_e32 v51, v50, v49, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v49
; GFX900-NEXT:    v_cndmask_b32_e32 v49, v51, v49, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v50
; GFX900-NEXT:    v_cndmask_b32_e32 v49, v49, v50, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v50, 16, v51
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v50
; GFX900-NEXT:    v_and_b32_e32 v50, 0xffff0000, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v49, v51, v49, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v51, 16, v20
; GFX900-NEXT:    v_lshrrev_b32_e32 v52, 16, v4
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v50, v50
; GFX900-NEXT:    v_cndmask_b32_e32 v50, v52, v51, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v53, v53
; GFX900-NEXT:    v_cndmask_b32_e32 v51, v51, v50, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v52, 16, v50
; GFX900-NEXT:    v_lshlrev_b32_e32 v53, 16, v51
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v52, v53
; GFX900-NEXT:    v_cndmask_b32_e32 v52, v51, v50, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v50
; GFX900-NEXT:    v_cndmask_b32_e32 v50, v52, v50, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v51
; GFX900-NEXT:    v_cndmask_b32_e32 v50, v50, v51, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v51, 16, v52
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v51
; GFX900-NEXT:    v_and_b32_e32 v51, 0xffff0000, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v50, v52, v50, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v52, 16, v19
; GFX900-NEXT:    v_lshrrev_b32_e32 v53, 16, v3
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v51, v51
; GFX900-NEXT:    v_cndmask_b32_e32 v51, v53, v52, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v54, v54
; GFX900-NEXT:    v_cndmask_b32_e32 v52, v52, v51, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v53, 16, v51
; GFX900-NEXT:    v_lshlrev_b32_e32 v54, 16, v52
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v53, v54
; GFX900-NEXT:    v_cndmask_b32_e32 v53, v52, v51, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v51
; GFX900-NEXT:    v_cndmask_b32_e32 v51, v53, v51, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v52
; GFX900-NEXT:    v_cndmask_b32_e32 v51, v51, v52, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v52, 16, v53
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v52
; GFX900-NEXT:    v_and_b32_e32 v52, 0xffff0000, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v51, v53, v51, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v53, 16, v18
; GFX900-NEXT:    v_lshrrev_b32_e32 v54, 16, v2
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v52, v52
; GFX900-NEXT:    v_cndmask_b32_e32 v52, v54, v53, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v40, v40
; GFX900-NEXT:    v_cndmask_b32_e32 v53, v53, v52, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v54, 16, v52
; GFX900-NEXT:    v_lshlrev_b32_e32 v40, 16, v53
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v54, v40
; GFX900-NEXT:    v_cndmask_b32_e32 v54, v53, v52, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v52
; GFX900-NEXT:    v_cndmask_b32_e32 v52, v54, v52, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v53
; GFX900-NEXT:    v_cndmask_b32_e32 v52, v52, v53, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v53, 16, v54
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v53
; GFX900-NEXT:    v_and_b32_e32 v53, 0xffff0000, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v52, v54, v52, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v54, 16, v17
; GFX900-NEXT:    v_lshrrev_b32_e32 v40, 16, v1
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v53, v53
; GFX900-NEXT:    v_cndmask_b32_e32 v53, v40, v54, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v41, v41
; GFX900-NEXT:    v_cndmask_b32_e32 v54, v54, v53, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v40, 16, v53
; GFX900-NEXT:    v_lshlrev_b32_e32 v41, 16, v54
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v40, v41
; GFX900-NEXT:    v_cndmask_b32_e32 v40, v54, v53, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v53
; GFX900-NEXT:    v_cndmask_b32_e32 v53, v40, v53, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v54
; GFX900-NEXT:    v_cndmask_b32_e32 v53, v53, v54, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v54, 16, v40
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v54
; GFX900-NEXT:    v_and_b32_e32 v54, 0xffff0000, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v53, v40, v53, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v40, 16, v16
; GFX900-NEXT:    v_lshrrev_b32_e32 v41, 16, v0
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v54, v54
; GFX900-NEXT:    v_cndmask_b32_e32 v54, v41, v40, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v42, v42
; GFX900-NEXT:    v_cndmask_b32_e32 v40, v40, v54, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v41, 16, v54
; GFX900-NEXT:    v_lshlrev_b32_e32 v42, 16, v40
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v41, v42
; GFX900-NEXT:    v_cndmask_b32_e32 v41, v40, v54, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v54
; GFX900-NEXT:    v_cndmask_b32_e32 v54, v41, v54, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v40
; GFX900-NEXT:    v_cndmask_b32_e32 v54, v54, v40, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v40, 16, v41
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v40
; GFX900-NEXT:    v_lshlrev_b32_e32 v40, 16, v15
; GFX900-NEXT:    v_cndmask_b32_e32 v54, v41, v54, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v40, v40
; GFX900-NEXT:    v_lshlrev_b32_e32 v40, 16, v55
; GFX900-NEXT:    v_cndmask_b32_e32 v15, v15, v55, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v40, v40
; GFX900-NEXT:    v_cndmask_b32_e32 v55, v55, v15, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v40, 16, v55
; GFX900-NEXT:    v_lshlrev_b32_e32 v41, 16, v15
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v41, v40
; GFX900-NEXT:    v_cndmask_b32_e32 v40, v55, v15, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v15
; GFX900-NEXT:    v_cndmask_b32_e32 v15, v40, v15, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v55
; GFX900-NEXT:    v_cndmask_b32_e32 v15, v15, v55, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v55, 16, v40
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v55
; GFX900-NEXT:    v_lshlrev_b32_e32 v55, 16, v14
; GFX900-NEXT:    v_cndmask_b32_e32 v15, v40, v15, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v55, v55
; GFX900-NEXT:    v_lshlrev_b32_e32 v55, 16, v30
; GFX900-NEXT:    v_cndmask_b32_e32 v14, v14, v30, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v55, v55
; GFX900-NEXT:    v_cndmask_b32_e32 v30, v30, v14, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v55, 16, v30
; GFX900-NEXT:    v_lshlrev_b32_e32 v40, 16, v14
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v40, v55
; GFX900-NEXT:    v_cndmask_b32_e32 v55, v30, v14, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v14
; GFX900-NEXT:    v_cndmask_b32_e32 v14, v55, v14, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v30
; GFX900-NEXT:    v_cndmask_b32_e32 v14, v14, v30, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v30, 16, v55
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v30
; GFX900-NEXT:    v_lshlrev_b32_e32 v30, 16, v13
; GFX900-NEXT:    v_cndmask_b32_e32 v14, v55, v14, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v30, v30
; GFX900-NEXT:    v_lshlrev_b32_e32 v30, 16, v29
; GFX900-NEXT:    v_cndmask_b32_e32 v13, v13, v29, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v30, v30
; GFX900-NEXT:    v_cndmask_b32_e32 v29, v29, v13, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v30, 16, v29
; GFX900-NEXT:    v_lshlrev_b32_e32 v55, 16, v13
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v55, v30
; GFX900-NEXT:    v_cndmask_b32_e32 v30, v29, v13, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v13
; GFX900-NEXT:    v_cndmask_b32_e32 v13, v30, v13, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v29
; GFX900-NEXT:    v_cndmask_b32_e32 v13, v13, v29, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v29, 16, v30
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v29
; GFX900-NEXT:    v_lshlrev_b32_e32 v29, 16, v12
; GFX900-NEXT:    v_cndmask_b32_e32 v13, v30, v13, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v29, v29
; GFX900-NEXT:    v_lshlrev_b32_e32 v29, 16, v28
; GFX900-NEXT:    v_cndmask_b32_e32 v12, v12, v28, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v29, v29
; GFX900-NEXT:    v_cndmask_b32_e32 v28, v28, v12, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v29, 16, v28
; GFX900-NEXT:    v_lshlrev_b32_e32 v30, 16, v12
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v30, v29
; GFX900-NEXT:    v_cndmask_b32_e32 v29, v28, v12, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v12
; GFX900-NEXT:    v_cndmask_b32_e32 v12, v29, v12, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v28
; GFX900-NEXT:    v_cndmask_b32_e32 v12, v12, v28, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v28, 16, v29
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v28
; GFX900-NEXT:    v_lshlrev_b32_e32 v28, 16, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v12, v29, v12, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v28, v28
; GFX900-NEXT:    v_lshlrev_b32_e32 v28, 16, v27
; GFX900-NEXT:    v_cndmask_b32_e32 v11, v11, v27, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v28, v28
; GFX900-NEXT:    v_cndmask_b32_e32 v27, v27, v11, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v28, 16, v27
; GFX900-NEXT:    v_lshlrev_b32_e32 v29, 16, v11
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v29, v28
; GFX900-NEXT:    v_cndmask_b32_e32 v28, v27, v11, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v11
; GFX900-NEXT:    v_cndmask_b32_e32 v11, v28, v11, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v27
; GFX900-NEXT:    v_cndmask_b32_e32 v11, v11, v27, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v27, 16, v28
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v27
; GFX900-NEXT:    v_lshlrev_b32_e32 v27, 16, v10
; GFX900-NEXT:    v_cndmask_b32_e32 v11, v28, v11, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v27, v27
; GFX900-NEXT:    v_lshlrev_b32_e32 v27, 16, v26
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v10, v26, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v27, v27
; GFX900-NEXT:    v_cndmask_b32_e32 v26, v26, v10, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v27, 16, v26
; GFX900-NEXT:    v_lshlrev_b32_e32 v28, 16, v10
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v28, v27
; GFX900-NEXT:    v_cndmask_b32_e32 v27, v26, v10, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v10
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v27, v10, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v26
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v10, v26, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v26, 16, v27
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v26
; GFX900-NEXT:    v_lshlrev_b32_e32 v26, 16, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v10, v27, v10, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v26, v26
; GFX900-NEXT:    v_lshlrev_b32_e32 v26, 16, v25
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v9, v25, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v26, v26
; GFX900-NEXT:    v_cndmask_b32_e32 v25, v25, v9, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v26, 16, v25
; GFX900-NEXT:    v_lshlrev_b32_e32 v27, 16, v9
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v27, v26
; GFX900-NEXT:    v_cndmask_b32_e32 v26, v25, v9, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v26, v9, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v25
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v9, v25, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v25, 16, v26
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v25
; GFX900-NEXT:    v_lshlrev_b32_e32 v25, 16, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v9, v26, v9, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v25, v25
; GFX900-NEXT:    v_lshlrev_b32_e32 v25, 16, v24
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v8, v24, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v25, v25
; GFX900-NEXT:    v_cndmask_b32_e32 v24, v24, v8, vcc
; GFX900-NEXT:    buffer_load_dword v42, off, s[0:3], s32 offset:4 ; 4-byte Folded Reload
; GFX900-NEXT:    buffer_load_dword v41, off, s[0:3], s32 offset:8 ; 4-byte Folded Reload
; GFX900-NEXT:    buffer_load_dword v40, off, s[0:3], s32 offset:12 ; 4-byte Folded Reload
; GFX900-NEXT:    v_lshlrev_b32_e32 v25, 16, v24
; GFX900-NEXT:    v_lshlrev_b32_e32 v26, 16, v8
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v26, v25
; GFX900-NEXT:    v_cndmask_b32_e32 v25, v24, v8, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v25, v8, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v24
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v8, v24, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v24
; GFX900-NEXT:    v_lshlrev_b32_e32 v24, 16, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v8, v25, v8, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX900-NEXT:    v_lshlrev_b32_e32 v24, 16, v23
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v7, v23, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX900-NEXT:    v_cndmask_b32_e32 v23, v23, v7, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v24, 16, v23
; GFX900-NEXT:    v_lshlrev_b32_e32 v25, 16, v7
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v25, v24
; GFX900-NEXT:    v_cndmask_b32_e32 v24, v23, v7, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v24, v7, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v23
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v7, v23, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v23, 16, v24
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v23
; GFX900-NEXT:    v_lshlrev_b32_e32 v23, 16, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v24, v7, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v23, v23
; GFX900-NEXT:    v_lshlrev_b32_e32 v23, 16, v22
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v6, v22, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v23, v23
; GFX900-NEXT:    v_cndmask_b32_e32 v22, v22, v6, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v23, 16, v22
; GFX900-NEXT:    v_lshlrev_b32_e32 v24, 16, v6
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v24, v23
; GFX900-NEXT:    v_cndmask_b32_e32 v23, v22, v6, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v23, v6, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v22
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v6, v22, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v22, 16, v23
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v22
; GFX900-NEXT:    v_lshlrev_b32_e32 v22, 16, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v23, v6, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v22, v22
; GFX900-NEXT:    v_lshlrev_b32_e32 v22, 16, v21
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v5, v21, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v22, v22
; GFX900-NEXT:    v_cndmask_b32_e32 v21, v21, v5, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v22, 16, v21
; GFX900-NEXT:    v_lshlrev_b32_e32 v23, 16, v5
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v23, v22
; GFX900-NEXT:    v_cndmask_b32_e32 v22, v21, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v22, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v21
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v5, v21, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v21, 16, v22
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v21
; GFX900-NEXT:    v_lshlrev_b32_e32 v21, 16, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v22, v5, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v21, v21
; GFX900-NEXT:    v_lshlrev_b32_e32 v21, 16, v20
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v4, v20, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v21, v21
; GFX900-NEXT:    v_cndmask_b32_e32 v20, v20, v4, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v21, 16, v20
; GFX900-NEXT:    v_lshlrev_b32_e32 v22, 16, v4
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v22, v21
; GFX900-NEXT:    v_cndmask_b32_e32 v21, v20, v4, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v21, v4, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v20
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v4, v20, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v20, 16, v21
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v20
; GFX900-NEXT:    v_lshlrev_b32_e32 v20, 16, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v21, v4, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v20, v20
; GFX900-NEXT:    v_lshlrev_b32_e32 v20, 16, v19
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v19, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v20, v20
; GFX900-NEXT:    v_cndmask_b32_e32 v19, v19, v3, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v20, 16, v19
; GFX900-NEXT:    v_lshlrev_b32_e32 v21, 16, v3
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v21, v20
; GFX900-NEXT:    v_cndmask_b32_e32 v20, v19, v3, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v20, v3, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v19
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v19, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v19, 16, v20
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v19
; GFX900-NEXT:    v_lshlrev_b32_e32 v19, 16, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v20, v3, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v19, v19
; GFX900-NEXT:    v_lshlrev_b32_e32 v19, 16, v18
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v18, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v19, v19
; GFX900-NEXT:    v_cndmask_b32_e32 v18, v18, v2, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v19, 16, v18
; GFX900-NEXT:    v_lshlrev_b32_e32 v20, 16, v2
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v20, v19
; GFX900-NEXT:    v_cndmask_b32_e32 v19, v18, v2, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v19, v2, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v18
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v18, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v18, 16, v19
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v18
; GFX900-NEXT:    v_lshlrev_b32_e32 v18, 16, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v19, v2, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v18, v18
; GFX900-NEXT:    v_lshlrev_b32_e32 v18, 16, v17
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v17, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v18, v18
; GFX900-NEXT:    v_cndmask_b32_e32 v17, v17, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v18, 16, v17
; GFX900-NEXT:    v_lshlrev_b32_e32 v19, 16, v1
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v19, v18
; GFX900-NEXT:    v_cndmask_b32_e32 v18, v17, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v18, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v17
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v17, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v17, 16, v18
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v17
; GFX900-NEXT:    v_lshlrev_b32_e32 v17, 16, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v18, v1, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v17, v17
; GFX900-NEXT:    v_lshlrev_b32_e32 v17, 16, v16
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v17, v17
; GFX900-NEXT:    v_cndmask_b32_e32 v16, v16, v0, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v17, 16, v16
; GFX900-NEXT:    v_lshlrev_b32_e32 v18, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v18, v17
; GFX900-NEXT:    v_cndmask_b32_e32 v17, v16, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v17, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v16
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v16, 16, v17
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v16
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v17, v0, vcc
; GFX900-NEXT:    v_perm_b32 v0, v54, v0, s4
; GFX900-NEXT:    v_perm_b32 v1, v53, v1, s4
; GFX900-NEXT:    v_perm_b32 v2, v52, v2, s4
; GFX900-NEXT:    v_perm_b32 v3, v51, v3, s4
; GFX900-NEXT:    v_perm_b32 v4, v50, v4, s4
; GFX900-NEXT:    v_perm_b32 v5, v49, v5, s4
; GFX900-NEXT:    v_perm_b32 v6, v48, v6, s4
; GFX900-NEXT:    v_perm_b32 v7, v39, v7, s4
; GFX900-NEXT:    v_perm_b32 v8, v38, v8, s4
; GFX900-NEXT:    v_perm_b32 v9, v37, v9, s4
; GFX900-NEXT:    v_perm_b32 v10, v36, v10, s4
; GFX900-NEXT:    v_perm_b32 v11, v35, v11, s4
; GFX900-NEXT:    v_perm_b32 v12, v34, v12, s4
; GFX900-NEXT:    v_perm_b32 v13, v33, v13, s4
; GFX900-NEXT:    v_perm_b32 v14, v31, v14, s4
; GFX900-NEXT:    v_perm_b32 v15, v32, v15, s4
; GFX900-NEXT:    s_waitcnt vmcnt(0)
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_v32bf16:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    scratch_load_dword v50, off, s32
; GFX950-NEXT:    v_and_b32_e32 v31, 0xffff0000, v14
; GFX950-NEXT:    v_lshrrev_b32_e32 v34, 16, v30
; GFX950-NEXT:    v_lshrrev_b32_e32 v35, 16, v14
; GFX950-NEXT:    v_and_b32_e32 v37, 0xffff0000, v13
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v31, v31
; GFX950-NEXT:    v_and_b32_e32 v36, 0xffff0000, v30
; GFX950-NEXT:    v_lshrrev_b32_e32 v38, 16, v29
; GFX950-NEXT:    v_lshrrev_b32_e32 v39, 16, v13
; GFX950-NEXT:    v_cndmask_b32_e32 v31, v35, v34, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v37, v37
; GFX950-NEXT:    v_and_b32_e32 v48, 0xffff0000, v29
; GFX950-NEXT:    v_lshlrev_b32_e32 v37, 16, v31
; GFX950-NEXT:    v_cndmask_b32_e32 v35, v39, v38, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v36, v36
; GFX950-NEXT:    v_lshlrev_b32_e32 v36, 16, v35
; GFX950-NEXT:    v_and_b32_e32 v32, 0xffff0000, v15
; GFX950-NEXT:    v_cndmask_b32_e32 v34, v34, v31, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v48, v48
; GFX950-NEXT:    v_lshlrev_b32_e32 v39, 16, v34
; GFX950-NEXT:    v_lshrrev_b32_e32 v33, 16, v15
; GFX950-NEXT:    v_cndmask_b32_e32 v38, v38, v35, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v48, 16, v38
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v37, v39
; GFX950-NEXT:    v_and_b32_e32 v49, 0xffff0000, v24
; GFX950-NEXT:    v_and_b32_e32 v51, 0xffff0000, v23
; GFX950-NEXT:    v_cndmask_b32_e32 v37, v34, v31, vcc
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v36, v48
; GFX950-NEXT:    v_lshlrev_b32_e32 v39, 16, v37
; GFX950-NEXT:    v_and_b32_e32 v52, 0xffff0000, v22
; GFX950-NEXT:    v_cndmask_b32_e32 v36, v38, v35, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v31
; GFX950-NEXT:    v_lshlrev_b32_e32 v48, 16, v36
; GFX950-NEXT:    v_and_b32_e32 v53, 0xffff0000, v21
; GFX950-NEXT:    v_cndmask_b32_e32 v31, v37, v31, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v35
; GFX950-NEXT:    v_and_b32_e32 v54, 0xffff0000, v20
; GFX950-NEXT:    v_and_b32_e32 v55, 0xffff0000, v19
; GFX950-NEXT:    v_cndmask_b32_e32 v35, v36, v35, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v34
; GFX950-NEXT:    v_accvgpr_write_b32 a0, v40 ; Reload Reuse
; GFX950-NEXT:    v_and_b32_e32 v40, 0xffff0000, v18
; GFX950-NEXT:    v_cndmask_b32_e32 v31, v31, v34, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v38
; GFX950-NEXT:    v_accvgpr_write_b32 a1, v41 ; Reload Reuse
; GFX950-NEXT:    v_and_b32_e32 v41, 0xffff0000, v17
; GFX950-NEXT:    v_cndmask_b32_e32 v34, v35, v38, vcc
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v39
; GFX950-NEXT:    v_and_b32_e32 v38, 0xffff0000, v27
; GFX950-NEXT:    v_and_b32_e32 v39, 0xffff0000, v26
; GFX950-NEXT:    v_cndmask_b32_e32 v31, v37, v31, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v32, v32
; GFX950-NEXT:    v_accvgpr_write_b32 a2, v42 ; Reload Reuse
; GFX950-NEXT:    v_and_b32_e32 v42, 0xffff0000, v16
; GFX950-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-NEXT:    s_waitcnt vmcnt(0)
; GFX950-NEXT:    v_lshrrev_b32_e32 v35, 16, v50
; GFX950-NEXT:    v_and_b32_e32 v37, 0xffff0000, v50
; GFX950-NEXT:    v_cndmask_b32_e32 v32, v33, v35, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v37, v37
; GFX950-NEXT:    v_lshlrev_b32_e32 v33, 16, v32
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v35, v35, v32, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v37, 16, v35
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v33, v37
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v33, v35, v32, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v32
; GFX950-NEXT:    v_lshlrev_b32_e32 v37, 16, v33
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v32, v33, v32, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v35
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v32, v32, v35, vcc
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v37
; GFX950-NEXT:    v_lshrrev_b32_e32 v35, 16, v28
; GFX950-NEXT:    v_and_b32_e32 v37, 0xffff0000, v28
; GFX950-NEXT:    v_cndmask_b32_e32 v32, v33, v32, vcc
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v48
; GFX950-NEXT:    v_and_b32_e32 v48, 0xffff0000, v25
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v33, v36, v34, vcc
; GFX950-NEXT:    v_and_b32_e32 v34, 0xffff0000, v12
; GFX950-NEXT:    v_lshrrev_b32_e32 v36, 16, v12
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v34, v34
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v34, v36, v35, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v37, v37
; GFX950-NEXT:    v_lshlrev_b32_e32 v36, 16, v34
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v35, v35, v34, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v37, 16, v35
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v36, v37
; GFX950-NEXT:    v_lshrrev_b32_e32 v37, 16, v11
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v36, v35, v34, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v34
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v34, v36, v34, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v35
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v34, v34, v35, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v35, 16, v36
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v35
; GFX950-NEXT:    v_and_b32_e32 v35, 0xffff0000, v11
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v34, v36, v34, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v36, 16, v27
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v35, v35
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v35, v37, v36, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v38, v38
; GFX950-NEXT:    v_lshlrev_b32_e32 v37, 16, v35
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v36, v36, v35, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v38, 16, v36
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v37, v38
; GFX950-NEXT:    v_lshrrev_b32_e32 v38, 16, v10
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v37, v36, v35, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v35
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v35, v37, v35, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v36
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v35, v35, v36, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v36, 16, v37
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v36
; GFX950-NEXT:    v_and_b32_e32 v36, 0xffff0000, v10
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v35, v37, v35, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v37, 16, v26
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v36, v36
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v36, v38, v37, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v39, v39
; GFX950-NEXT:    v_lshlrev_b32_e32 v38, 16, v36
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v37, v37, v36, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v39, 16, v37
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v38, v39
; GFX950-NEXT:    v_lshrrev_b32_e32 v39, 16, v9
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v38, v37, v36, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v36
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v36, v38, v36, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v37
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v36, v36, v37, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v37, 16, v38
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v37
; GFX950-NEXT:    v_and_b32_e32 v37, 0xffff0000, v9
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v36, v38, v36, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v38, 16, v25
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v37, v37
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v37, v39, v38, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v48, v48
; GFX950-NEXT:    v_lshlrev_b32_e32 v39, 16, v37
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v38, v38, v37, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v48, 16, v38
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v39, v48
; GFX950-NEXT:    v_lshrrev_b32_e32 v48, 16, v8
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v39, v38, v37, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v37
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v37, v39, v37, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v38
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v37, v37, v38, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v38, 16, v39
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v38
; GFX950-NEXT:    v_and_b32_e32 v38, 0xffff0000, v8
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v37, v39, v37, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v39, 16, v24
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v38, v38
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v38, v48, v39, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v49, v49
; GFX950-NEXT:    v_lshlrev_b32_e32 v48, 16, v38
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v39, v39, v38, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v49, 16, v39
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v48, v49
; GFX950-NEXT:    v_lshrrev_b32_e32 v49, 16, v7
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v48, v39, v38, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v38
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v38, v48, v38, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v39
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v38, v38, v39, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v39, 16, v48
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v39
; GFX950-NEXT:    v_and_b32_e32 v39, 0xffff0000, v7
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v38, v48, v38, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v48, 16, v23
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v39, v39
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v39, v49, v48, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v51, v51
; GFX950-NEXT:    v_lshlrev_b32_e32 v49, 16, v39
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v48, v48, v39, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v51, 16, v48
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v49, v51
; GFX950-NEXT:    v_lshrrev_b32_e32 v51, 16, v6
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v49, v48, v39, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v39
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v39, v49, v39, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v48
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v39, v39, v48, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v48, 16, v49
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v48
; GFX950-NEXT:    v_and_b32_e32 v48, 0xffff0000, v6
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v39, v49, v39, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v49, 16, v22
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v48, v48
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v48, v51, v49, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v52, v52
; GFX950-NEXT:    v_lshlrev_b32_e32 v51, 16, v48
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v49, v49, v48, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v52, 16, v49
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v51, v52
; GFX950-NEXT:    v_lshrrev_b32_e32 v52, 16, v5
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v51, v49, v48, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v48
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v48, v51, v48, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v49
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v48, v48, v49, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v49, 16, v51
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v49
; GFX950-NEXT:    v_and_b32_e32 v49, 0xffff0000, v5
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v48, v51, v48, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v51, 16, v21
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v49, v49
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v49, v52, v51, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v53, v53
; GFX950-NEXT:    v_lshlrev_b32_e32 v52, 16, v49
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v51, v51, v49, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v53, 16, v51
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v52, v53
; GFX950-NEXT:    v_lshrrev_b32_e32 v53, 16, v4
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v52, v51, v49, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v49
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v49, v52, v49, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v51
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v49, v49, v51, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v51, 16, v52
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v51
; GFX950-NEXT:    v_and_b32_e32 v51, 0xffff0000, v4
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v49, v52, v49, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v52, 16, v20
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v51, v51
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v51, v53, v52, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v54, v54
; GFX950-NEXT:    v_lshlrev_b32_e32 v53, 16, v51
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v52, v52, v51, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v54, 16, v52
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v53, v54
; GFX950-NEXT:    v_lshrrev_b32_e32 v54, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v53, v52, v51, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v51
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v51, v53, v51, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v52
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v51, v51, v52, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v52, 16, v53
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v52
; GFX950-NEXT:    v_and_b32_e32 v52, 0xffff0000, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v51, v53, v51, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v53, 16, v19
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v52, v52
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v52, v54, v53, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v55, v55
; GFX950-NEXT:    v_lshlrev_b32_e32 v54, 16, v52
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v53, v53, v52, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v55, 16, v53
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v54, v55
; GFX950-NEXT:    v_lshrrev_b32_e32 v55, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v54, v53, v52, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v52
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v52, v54, v52, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v53
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v52, v52, v53, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v53, 16, v54
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v53
; GFX950-NEXT:    v_and_b32_e32 v53, 0xffff0000, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v52, v54, v52, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v54, 16, v18
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v53, v53
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v53, v55, v54, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v40, v40
; GFX950-NEXT:    v_lshlrev_b32_e32 v55, 16, v53
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v54, v54, v53, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v40, 16, v54
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v55, v40
; GFX950-NEXT:    v_lshrrev_b32_e32 v40, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v55, v54, v53, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v53
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v53, v55, v53, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v54
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v53, v53, v54, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v54, 16, v55
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v54
; GFX950-NEXT:    v_and_b32_e32 v54, 0xffff0000, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v53, v55, v53, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v55, 16, v17
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v54, v54
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v54, v40, v55, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v41, v41
; GFX950-NEXT:    v_lshlrev_b32_e32 v40, 16, v54
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v55, v55, v54, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v41, 16, v55
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v40, v41
; GFX950-NEXT:    v_lshrrev_b32_e32 v41, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v40, v55, v54, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v54
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v54, v40, v54, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v55
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v54, v54, v55, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v55, 16, v40
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v55
; GFX950-NEXT:    v_and_b32_e32 v55, 0xffff0000, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v54, v40, v54, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v40, 16, v16
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v55, v55
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v55, v41, v40, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v42, v42
; GFX950-NEXT:    v_lshlrev_b32_e32 v41, 16, v55
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v40, v40, v55, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v42, 16, v40
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v41, v42
; GFX950-NEXT:    v_accvgpr_read_b32 v42, a2 ; Reload Reuse
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v41, v40, v55, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v55
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v55, v41, v55, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v40
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v55, v55, v40, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v40, 16, v41
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v40
; GFX950-NEXT:    v_lshlrev_b32_e32 v40, 16, v15
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v55, v41, v55, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v40, v40
; GFX950-NEXT:    v_lshlrev_b32_e32 v40, 16, v50
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v15, v15, v50, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v40, v40
; GFX950-NEXT:    v_lshlrev_b32_e32 v41, 16, v15
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v50, v50, v15, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v40, 16, v50
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v41, v40
; GFX950-NEXT:    v_accvgpr_read_b32 v41, a1 ; Reload Reuse
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v40, v50, v15, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v15
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v15, v40, v15, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v50
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v15, v15, v50, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v50, 16, v40
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v50
; GFX950-NEXT:    v_lshlrev_b32_e32 v50, 16, v14
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v15, v40, v15, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v50, v50
; GFX950-NEXT:    v_lshlrev_b32_e32 v50, 16, v30
; GFX950-NEXT:    v_perm_b32 v15, v32, v15, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v14, v14, v30, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v50, v50
; GFX950-NEXT:    v_lshlrev_b32_e32 v40, 16, v14
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v30, v30, v14, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v50, 16, v30
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v40, v50
; GFX950-NEXT:    v_accvgpr_read_b32 v40, a0 ; Reload Reuse
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v50, v30, v14, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v14
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v14, v50, v14, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v30
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v14, v14, v30, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v30, 16, v50
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v30
; GFX950-NEXT:    v_lshlrev_b32_e32 v30, 16, v13
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v14, v50, v14, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v30, v30
; GFX950-NEXT:    v_lshlrev_b32_e32 v30, 16, v29
; GFX950-NEXT:    v_perm_b32 v14, v31, v14, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v13, v13, v29, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v30, v30
; GFX950-NEXT:    v_lshlrev_b32_e32 v50, 16, v13
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v29, v29, v13, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v30, 16, v29
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v50, v30
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v30, v29, v13, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v13
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v13, v30, v13, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v29
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v13, v13, v29, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v29, 16, v30
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v29
; GFX950-NEXT:    v_lshlrev_b32_e32 v29, 16, v12
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v13, v30, v13, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v29, v29
; GFX950-NEXT:    v_lshlrev_b32_e32 v29, 16, v28
; GFX950-NEXT:    v_perm_b32 v13, v33, v13, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v12, v12, v28, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v29, v29
; GFX950-NEXT:    v_lshlrev_b32_e32 v30, 16, v12
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v28, v28, v12, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v29, 16, v28
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v30, v29
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v29, v28, v12, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v12
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v12, v29, v12, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v28
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v12, v12, v28, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v28, 16, v29
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v28
; GFX950-NEXT:    v_lshlrev_b32_e32 v28, 16, v11
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v12, v29, v12, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v28, v28
; GFX950-NEXT:    v_lshlrev_b32_e32 v28, 16, v27
; GFX950-NEXT:    v_perm_b32 v12, v34, v12, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v11, v11, v27, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v28, v28
; GFX950-NEXT:    v_lshlrev_b32_e32 v29, 16, v11
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v27, v27, v11, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v28, 16, v27
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v29, v28
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v28, v27, v11, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v11
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v11, v28, v11, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v27
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v11, v11, v27, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v27, 16, v28
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v27
; GFX950-NEXT:    v_lshlrev_b32_e32 v27, 16, v10
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v11, v28, v11, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v27, v27
; GFX950-NEXT:    v_lshlrev_b32_e32 v27, 16, v26
; GFX950-NEXT:    v_perm_b32 v11, v35, v11, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v10, v10, v26, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v27, v27
; GFX950-NEXT:    v_lshlrev_b32_e32 v28, 16, v10
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v26, v26, v10, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v27, 16, v26
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v28, v27
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v27, v26, v10, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v10
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v10, v27, v10, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v26
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v10, v10, v26, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v26, 16, v27
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v26
; GFX950-NEXT:    v_lshlrev_b32_e32 v26, 16, v9
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v10, v27, v10, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v26, v26
; GFX950-NEXT:    v_lshlrev_b32_e32 v26, 16, v25
; GFX950-NEXT:    v_perm_b32 v10, v36, v10, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v9, v25, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v26, v26
; GFX950-NEXT:    v_lshlrev_b32_e32 v27, 16, v9
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v25, v25, v9, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v26, 16, v25
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v27, v26
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v26, v25, v9, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v9
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v26, v9, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v25
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v9, v25, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v25, 16, v26
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v25
; GFX950-NEXT:    v_lshlrev_b32_e32 v25, 16, v8
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v9, v26, v9, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v25, v25
; GFX950-NEXT:    v_lshlrev_b32_e32 v25, 16, v24
; GFX950-NEXT:    v_perm_b32 v9, v37, v9, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v8, v24, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v25, v25
; GFX950-NEXT:    v_lshlrev_b32_e32 v26, 16, v8
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v24, v24, v8, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v25, 16, v24
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v26, v25
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v25, v24, v8, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v8
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v25, v8, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v24
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v8, v24, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v24, 16, v25
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v24
; GFX950-NEXT:    v_lshlrev_b32_e32 v24, 16, v7
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v8, v25, v8, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX950-NEXT:    v_lshlrev_b32_e32 v24, 16, v23
; GFX950-NEXT:    v_perm_b32 v8, v38, v8, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v7, v23, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v24, v24
; GFX950-NEXT:    v_lshlrev_b32_e32 v25, 16, v7
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v23, v23, v7, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v24, 16, v23
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v25, v24
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v24, v23, v7, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v7
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v24, v7, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v23
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v7, v23, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v23, 16, v24
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v23
; GFX950-NEXT:    v_lshlrev_b32_e32 v23, 16, v6
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v24, v7, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v23, v23
; GFX950-NEXT:    v_lshlrev_b32_e32 v23, 16, v22
; GFX950-NEXT:    v_perm_b32 v7, v39, v7, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v6, v22, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v23, v23
; GFX950-NEXT:    v_lshlrev_b32_e32 v24, 16, v6
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v22, v22, v6, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v23, 16, v22
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v24, v23
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v23, v22, v6, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v23, v6, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v22
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v6, v22, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v22, 16, v23
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v22
; GFX950-NEXT:    v_lshlrev_b32_e32 v22, 16, v5
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v23, v6, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v22, v22
; GFX950-NEXT:    v_lshlrev_b32_e32 v22, 16, v21
; GFX950-NEXT:    v_perm_b32 v6, v48, v6, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v5, v21, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v22, v22
; GFX950-NEXT:    v_lshlrev_b32_e32 v23, 16, v5
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v21, v21, v5, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v22, 16, v21
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v23, v22
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v22, v21, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v22, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v21
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v5, v21, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v21, 16, v22
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v21
; GFX950-NEXT:    v_lshlrev_b32_e32 v21, 16, v4
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v22, v5, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v21, v21
; GFX950-NEXT:    v_lshlrev_b32_e32 v21, 16, v20
; GFX950-NEXT:    v_perm_b32 v5, v49, v5, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v4, v20, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v21, v21
; GFX950-NEXT:    v_lshlrev_b32_e32 v22, 16, v4
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v20, v20, v4, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v21, 16, v20
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v22, v21
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v21, v20, v4, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v21, v4, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v20
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v4, v20, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v20, 16, v21
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v20
; GFX950-NEXT:    v_lshlrev_b32_e32 v20, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v21, v4, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v20, v20
; GFX950-NEXT:    v_lshlrev_b32_e32 v20, 16, v19
; GFX950-NEXT:    v_perm_b32 v4, v51, v4, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v19, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v20, v20
; GFX950-NEXT:    v_lshlrev_b32_e32 v21, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v19, v19, v3, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v20, 16, v19
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v21, v20
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v20, v19, v3, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v20, v3, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v19
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v19, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v19, 16, v20
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v19
; GFX950-NEXT:    v_lshlrev_b32_e32 v19, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v20, v3, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v19, v19
; GFX950-NEXT:    v_lshlrev_b32_e32 v19, 16, v18
; GFX950-NEXT:    v_perm_b32 v3, v52, v3, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v18, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v19, v19
; GFX950-NEXT:    v_lshlrev_b32_e32 v20, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v18, v18, v2, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v19, 16, v18
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v20, v19
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v19, v18, v2, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v19, v2, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v18
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v18, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v18, 16, v19
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v18
; GFX950-NEXT:    v_lshlrev_b32_e32 v18, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v19, v2, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v18, v18
; GFX950-NEXT:    v_lshlrev_b32_e32 v18, 16, v17
; GFX950-NEXT:    v_perm_b32 v2, v53, v2, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v17, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v18, v18
; GFX950-NEXT:    v_lshlrev_b32_e32 v19, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v17, v17, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v18, 16, v17
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v19, v18
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v18, v17, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v18, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v17
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v17, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v17, 16, v18
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v17
; GFX950-NEXT:    v_lshlrev_b32_e32 v17, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v18, v1, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v17, v17
; GFX950-NEXT:    v_lshlrev_b32_e32 v17, 16, v16
; GFX950-NEXT:    v_perm_b32 v1, v54, v1, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v17, v17
; GFX950-NEXT:    v_lshlrev_b32_e32 v18, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v16, v16, v0, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v17, 16, v16
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v18, v17
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v17, v16, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v17, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v16
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v16, 16, v17
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v16
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v17, v0, vcc
; GFX950-NEXT:    v_perm_b32 v0, v55, v0, s0
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v32bf16:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v31, 0xffff0000, v13
; GFX10-NEXT:    v_lshrrev_b32_e32 v35, 16, v29
; GFX10-NEXT:    v_lshrrev_b32_e32 v32, 16, v13
; GFX10-NEXT:    v_and_b32_e32 v33, 0xffff0000, v12
; GFX10-NEXT:    v_lshrrev_b32_e32 v38, 16, v28
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v31, v31
; GFX10-NEXT:    v_lshrrev_b32_e32 v34, 16, v12
; GFX10-NEXT:    v_and_b32_e32 v37, 0xffff0000, v11
; GFX10-NEXT:    v_and_b32_e32 v36, 0xffff0000, v29
; GFX10-NEXT:    v_lshrrev_b32_e32 v39, 16, v27
; GFX10-NEXT:    v_cndmask_b32_e32 v32, v32, v35, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v33, v33
; GFX10-NEXT:    v_lshrrev_b32_e32 v48, 16, v11
; GFX10-NEXT:    v_and_b32_e32 v49, 0xffff0000, v28
; GFX10-NEXT:    v_and_b32_e32 v51, 0xffff0000, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v31, 16, v32
; GFX10-NEXT:    v_cndmask_b32_e32 v34, v34, v38, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v37, v37
; GFX10-NEXT:    v_lshrrev_b32_e32 v52, 16, v26
; GFX10-NEXT:    v_lshrrev_b32_e32 v53, 16, v10
; GFX10-NEXT:    v_cmp_u_f32_e64 s6, v51, v51
; GFX10-NEXT:    v_lshrrev_b32_e32 v54, 16, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v33, v48, v39, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v36, v36
; GFX10-NEXT:    v_and_b32_e32 v48, 0xffff0000, v27
; GFX10-NEXT:    v_lshrrev_b32_e32 v64, 16, v23
; GFX10-NEXT:    v_lshrrev_b32_e32 v65, 16, v7
; GFX10-NEXT:    v_lshrrev_b32_e32 v66, 16, v22
; GFX10-NEXT:    v_cndmask_b32_e32 v37, v35, v32, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v49, v49
; GFX10-NEXT:    v_lshlrev_b32_e32 v49, 16, v33
; GFX10-NEXT:    v_lshrrev_b32_e32 v67, 16, v6
; GFX10-NEXT:    v_lshrrev_b32_e32 v70, 16, v4
; GFX10-NEXT:    v_and_b32_e32 v71, 0xffff0000, v20
; GFX10-NEXT:    v_cndmask_b32_e32 v36, v38, v34, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v48, v48
; GFX10-NEXT:    v_lshlrev_b32_e32 v38, 16, v37
; GFX10-NEXT:    v_lshrrev_b32_e32 v80, 16, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v85, 16, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v48, 16, v36
; GFX10-NEXT:    v_cndmask_b32_e32 v35, v39, v33, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v39, 16, v34
; GFX10-NEXT:    v_cmp_gt_f32_e64 s5, v31, v38
; GFX10-NEXT:    v_and_b32_e32 v31, 0xffff0000, v26
; GFX10-NEXT:    v_cndmask_b32_e64 v38, v53, v52, s6
; GFX10-NEXT:    v_lshlrev_b32_e32 v50, 16, v35
; GFX10-NEXT:    v_cmp_gt_f32_e64 s4, v39, v48
; GFX10-NEXT:    v_and_b32_e32 v39, 0xffff0000, v9
; GFX10-NEXT:    v_cmp_u_f32_e64 s6, v31, v31
; GFX10-NEXT:    v_and_b32_e32 v31, 0xffff0000, v25
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v49, v50
; GFX10-NEXT:    v_lshrrev_b32_e32 v49, 16, v25
; GFX10-NEXT:    v_lshrrev_b32_e32 v50, 16, v9
; GFX10-NEXT:    v_cndmask_b32_e64 v48, v52, v38, s6
; GFX10-NEXT:    v_cmp_u_f32_e64 s6, v39, v39
; GFX10-NEXT:    v_and_b32_e32 v52, 0xffff0000, v8
; GFX10-NEXT:    v_lshlrev_b32_e32 v51, 16, v38
; GFX10-NEXT:    v_lshrrev_b32_e32 v53, 16, v24
; GFX10-NEXT:    v_lshlrev_b32_e32 v55, 16, v48
; GFX10-NEXT:    v_cndmask_b32_e64 v39, v50, v49, s6
; GFX10-NEXT:    v_cmp_u_f32_e64 s6, v31, v31
; GFX10-NEXT:    v_lshlrev_b32_e32 v31, 16, v39
; GFX10-NEXT:    v_cndmask_b32_e64 v50, v49, v39, s6
; GFX10-NEXT:    v_cmp_u_f32_e64 s6, v52, v52
; GFX10-NEXT:    v_and_b32_e32 v52, 0xffff0000, v24
; GFX10-NEXT:    v_cndmask_b32_e64 v49, v54, v53, s6
; GFX10-NEXT:    v_cmp_gt_f32_e64 s6, v51, v55
; GFX10-NEXT:    v_and_b32_e32 v55, 0xffff0000, v7
; GFX10-NEXT:    v_cmp_u_f32_e64 s7, v52, v52
; GFX10-NEXT:    v_lshlrev_b32_e32 v51, 16, v50
; GFX10-NEXT:    v_lshlrev_b32_e32 v54, 16, v49
; GFX10-NEXT:    v_cndmask_b32_e64 v52, v53, v49, s7
; GFX10-NEXT:    v_and_b32_e32 v53, 0xffff0000, v23
; GFX10-NEXT:    v_cmp_u_f32_e64 s7, v55, v55
; GFX10-NEXT:    v_cmp_gt_f32_e64 s8, v31, v51
; GFX10-NEXT:    v_cndmask_b32_e64 v55, v65, v64, s7
; GFX10-NEXT:    v_and_b32_e32 v65, 0xffff0000, v6
; GFX10-NEXT:    v_cmp_u_f32_e64 s7, v53, v53
; GFX10-NEXT:    v_lshlrev_b32_e32 v68, 16, v55
; GFX10-NEXT:    v_cndmask_b32_e64 v53, v64, v55, s7
; GFX10-NEXT:    v_cmp_u_f32_e64 s7, v65, v65
; GFX10-NEXT:    v_and_b32_e32 v64, 0xffff0000, v22
; GFX10-NEXT:    v_lshlrev_b32_e32 v69, 16, v53
; GFX10-NEXT:    v_cndmask_b32_e64 v65, v67, v66, s7
; GFX10-NEXT:    v_lshlrev_b32_e32 v67, 16, v52
; GFX10-NEXT:    v_cmp_u_f32_e64 s7, v64, v64
; GFX10-NEXT:    v_lshlrev_b32_e32 v31, 16, v65
; GFX10-NEXT:    v_cmp_gt_f32_e64 s9, v54, v67
; GFX10-NEXT:    v_and_b32_e32 v54, 0xffff0000, v5
; GFX10-NEXT:    v_cndmask_b32_e64 v64, v66, v65, s7
; GFX10-NEXT:    v_cmp_gt_f32_e64 s7, v68, v69
; GFX10-NEXT:    v_lshrrev_b32_e32 v66, 16, v21
; GFX10-NEXT:    v_lshrrev_b32_e32 v67, 16, v5
; GFX10-NEXT:    v_and_b32_e32 v68, 0xffff0000, v4
; GFX10-NEXT:    v_cmp_u_f32_e64 s10, v54, v54
; GFX10-NEXT:    v_lshrrev_b32_e32 v69, 16, v20
; GFX10-NEXT:    v_lshlrev_b32_e32 v51, 16, v64
; GFX10-NEXT:    v_cndmask_b32_e64 v54, v67, v66, s10
; GFX10-NEXT:    v_and_b32_e32 v67, 0xffff0000, v21
; GFX10-NEXT:    v_cmp_u_f32_e64 s10, v68, v68
; GFX10-NEXT:    v_cndmask_b32_e64 v68, v70, v69, s10
; GFX10-NEXT:    v_cmp_u_f32_e64 s10, v67, v67
; GFX10-NEXT:    v_lshlrev_b32_e32 v70, 16, v54
; GFX10-NEXT:    v_lshlrev_b32_e32 v82, 16, v68
; GFX10-NEXT:    v_cndmask_b32_e64 v66, v66, v54, s10
; GFX10-NEXT:    v_cmp_u_f32_e64 s10, v71, v71
; GFX10-NEXT:    v_lshrrev_b32_e32 v71, 16, v19
; GFX10-NEXT:    v_lshlrev_b32_e32 v81, 16, v66
; GFX10-NEXT:    v_cndmask_b32_e64 v67, v69, v68, s10
; GFX10-NEXT:    v_and_b32_e32 v69, 0xffff0000, v3
; GFX10-NEXT:    v_cmp_gt_f32_e64 s11, v70, v81
; GFX10-NEXT:    v_lshlrev_b32_e32 v83, 16, v67
; GFX10-NEXT:    v_cmp_u_f32_e64 s10, v69, v69
; GFX10-NEXT:    v_and_b32_e32 v70, 0xffff0000, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v81, 16, v2
; GFX10-NEXT:    v_cmp_gt_f32_e64 s12, v82, v83
; GFX10-NEXT:    v_cndmask_b32_e64 v69, v80, v71, s10
; GFX10-NEXT:    v_cmp_gt_f32_e64 s10, v31, v51
; GFX10-NEXT:    v_and_b32_e32 v51, 0xffff0000, v19
; GFX10-NEXT:    v_lshrrev_b32_e32 v80, 16, v18
; GFX10-NEXT:    v_and_b32_e32 v82, 0xffff0000, v18
; GFX10-NEXT:    v_lshlrev_b32_e32 v31, 16, v69
; GFX10-NEXT:    v_cmp_u_f32_e64 s13, v51, v51
; GFX10-NEXT:    v_cndmask_b32_e64 v51, v71, v69, s13
; GFX10-NEXT:    v_cmp_u_f32_e64 s13, v70, v70
; GFX10-NEXT:    v_and_b32_e32 v71, 0xffff0000, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v83, 16, v51
; GFX10-NEXT:    v_cndmask_b32_e64 v70, v81, v80, s13
; GFX10-NEXT:    v_cmp_u_f32_e64 s13, v82, v82
; GFX10-NEXT:    v_lshrrev_b32_e32 v81, 16, v17
; GFX10-NEXT:    v_lshrrev_b32_e32 v82, 16, v1
; GFX10-NEXT:    v_cndmask_b32_e64 v80, v80, v70, s13
; GFX10-NEXT:    v_cmp_u_f32_e64 s13, v71, v71
; GFX10-NEXT:    v_and_b32_e32 v71, 0xffff0000, v17
; GFX10-NEXT:    v_cndmask_b32_e64 v82, v82, v81, s13
; GFX10-NEXT:    v_cmp_u_f32_e64 s14, v71, v71
; GFX10-NEXT:    v_cmp_gt_f32_e64 s13, v31, v83
; GFX10-NEXT:    v_lshlrev_b32_e32 v31, 16, v70
; GFX10-NEXT:    v_lshlrev_b32_e32 v83, 16, v80
; GFX10-NEXT:    v_cndmask_b32_e64 v71, v81, v82, s14
; GFX10-NEXT:    v_cmp_gt_f32_e64 s14, v31, v83
; GFX10-NEXT:    v_lshlrev_b32_e32 v31, 16, v82
; GFX10-NEXT:    v_lshlrev_b32_e32 v81, 16, v71
; GFX10-NEXT:    v_lshrrev_b32_e32 v83, 16, v0
; GFX10-NEXT:    v_cmp_gt_f32_e64 s15, v31, v81
; GFX10-NEXT:    v_and_b32_e32 v31, 0xffff0000, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v81, 16, v16
; GFX10-NEXT:    v_cmp_u_f32_e64 s16, v31, v31
; GFX10-NEXT:    v_and_b32_e32 v31, 0xffff0000, v16
; GFX10-NEXT:    v_cndmask_b32_e64 v83, v83, v81, s16
; GFX10-NEXT:    v_cmp_u_f32_e64 s16, v31, v31
; GFX10-NEXT:    v_lshlrev_b32_e32 v31, 16, v83
; GFX10-NEXT:    v_cndmask_b32_e64 v81, v81, v83, s16
; GFX10-NEXT:    v_lshlrev_b32_e32 v84, 16, v81
; GFX10-NEXT:    v_cmp_gt_f32_e64 s16, v31, v84
; GFX10-NEXT:    v_and_b32_e32 v31, 0xffff0000, v14
; GFX10-NEXT:    v_lshrrev_b32_e32 v84, 16, v30
; GFX10-NEXT:    v_cmp_u_f32_e64 s17, v31, v31
; GFX10-NEXT:    v_cndmask_b32_e64 v31, v85, v84, s17
; GFX10-NEXT:    v_and_b32_e32 v85, 0xffff0000, v30
; GFX10-NEXT:    v_cmp_u_f32_e64 s17, v85, v85
; GFX10-NEXT:    v_lshlrev_b32_e32 v85, 16, v31
; GFX10-NEXT:    v_cndmask_b32_e64 v84, v84, v31, s17
; GFX10-NEXT:    v_lshlrev_b32_e32 v86, 16, v84
; GFX10-NEXT:    v_cmp_gt_f32_e64 s17, v85, v86
; GFX10-NEXT:    v_lshrrev_b32_e32 v86, 16, v15
; GFX10-NEXT:    v_cndmask_b32_e64 v85, v84, v31, s17
; GFX10-NEXT:    v_cmp_eq_u16_e64 s17, 0, v31
; GFX10-NEXT:    v_cndmask_b32_e64 v31, v85, v31, s17
; GFX10-NEXT:    v_cmp_eq_u16_e64 s17, 0, v84
; GFX10-NEXT:    v_cndmask_b32_e64 v31, v31, v84, s17
; GFX10-NEXT:    v_lshlrev_b32_e32 v84, 16, v85
; GFX10-NEXT:    v_cmp_eq_f32_e64 s17, 0, v84
; GFX10-NEXT:    v_cndmask_b32_e64 v84, v37, v32, s5
; GFX10-NEXT:    v_cmp_eq_u16_e64 s5, 0, v32
; GFX10-NEXT:    v_cndmask_b32_e64 v31, v85, v31, s17
; GFX10-NEXT:    v_lshlrev_b32_e32 v85, 16, v15
; GFX10-NEXT:    v_cndmask_b32_e64 v32, v84, v32, s5
; GFX10-NEXT:    v_cmp_eq_u16_e64 s5, 0, v37
; GFX10-NEXT:    v_cndmask_b32_e64 v32, v32, v37, s5
; GFX10-NEXT:    v_cndmask_b32_e64 v37, v36, v34, s4
; GFX10-NEXT:    v_cmp_eq_u16_e64 s4, 0, v34
; GFX10-NEXT:    v_cmp_eq_u16_e64 s5, 0, v39
; GFX10-NEXT:    v_cndmask_b32_e64 v34, v37, v34, s4
; GFX10-NEXT:    v_cmp_eq_u16_e64 s4, 0, v36
; GFX10-NEXT:    v_cndmask_b32_e64 v34, v34, v36, s4
; GFX10-NEXT:    v_cndmask_b32_e32 v36, v35, v33, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v33
; GFX10-NEXT:    v_cmp_eq_u16_e64 s4, 0, v38
; GFX10-NEXT:    v_cndmask_b32_e32 v33, v36, v33, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v35
; GFX10-NEXT:    v_cndmask_b32_e32 v33, v33, v35, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v35, 16, v36
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v35
; GFX10-NEXT:    v_cndmask_b32_e64 v35, v48, v38, s6
; GFX10-NEXT:    v_cmp_eq_u16_e64 s6, 0, v49
; GFX10-NEXT:    v_cndmask_b32_e32 v33, v36, v33, vcc_lo
; GFX10-NEXT:    v_cndmask_b32_e64 v38, v35, v38, s4
; GFX10-NEXT:    v_cmp_eq_u16_e64 s4, 0, v48
; GFX10-NEXT:    v_cndmask_b32_e64 v38, v38, v48, s4
; GFX10-NEXT:    v_lshlrev_b32_e32 v48, 16, v35
; GFX10-NEXT:    v_cmp_eq_f32_e64 s4, 0, v48
; GFX10-NEXT:    v_cndmask_b32_e64 v48, v50, v39, s8
; GFX10-NEXT:    v_cmp_eq_u16_e64 s8, 0, v65
; GFX10-NEXT:    v_cndmask_b32_e64 v39, v48, v39, s5
; GFX10-NEXT:    v_cmp_eq_u16_e64 s5, 0, v50
; GFX10-NEXT:    v_cndmask_b32_e64 v39, v39, v50, s5
; GFX10-NEXT:    v_lshlrev_b32_e32 v50, 16, v48
; GFX10-NEXT:    v_cmp_eq_f32_e64 s5, 0, v50
; GFX10-NEXT:    v_cndmask_b32_e64 v50, v52, v49, s9
; GFX10-NEXT:    v_cmp_eq_u16_e64 s9, 0, v68
; GFX10-NEXT:    v_cndmask_b32_e64 v49, v50, v49, s6
; GFX10-NEXT:    v_cmp_eq_u16_e64 s6, 0, v52
; GFX10-NEXT:    v_cndmask_b32_e64 v49, v49, v52, s6
; GFX10-NEXT:    v_lshlrev_b32_e32 v52, 16, v50
; GFX10-NEXT:    v_cmp_eq_f32_e64 s6, 0, v52
; GFX10-NEXT:    v_cndmask_b32_e64 v52, v53, v55, s7
; GFX10-NEXT:    v_cmp_eq_u16_e64 s7, 0, v55
; GFX10-NEXT:    v_cndmask_b32_e64 v55, v52, v55, s7
; GFX10-NEXT:    v_cmp_eq_u16_e64 s7, 0, v53
; GFX10-NEXT:    v_cndmask_b32_e64 v53, v55, v53, s7
; GFX10-NEXT:    v_lshlrev_b32_e32 v55, 16, v52
; GFX10-NEXT:    v_cmp_eq_f32_e64 s7, 0, v55
; GFX10-NEXT:    v_cndmask_b32_e64 v55, v64, v65, s10
; GFX10-NEXT:    v_cmp_eq_u16_e64 s10, 0, v69
; GFX10-NEXT:    v_cndmask_b32_e64 v36, v52, v53, s7
; GFX10-NEXT:    v_cndmask_b32_e64 v65, v55, v65, s8
; GFX10-NEXT:    v_cmp_eq_u16_e64 s8, 0, v64
; GFX10-NEXT:    v_cndmask_b32_e64 v64, v65, v64, s8
; GFX10-NEXT:    v_cndmask_b32_e64 v65, v66, v54, s11
; GFX10-NEXT:    v_cmp_eq_u16_e64 s8, 0, v54
; GFX10-NEXT:    v_cndmask_b32_e64 v54, v65, v54, s8
; GFX10-NEXT:    v_cmp_eq_u16_e64 s8, 0, v66
; GFX10-NEXT:    v_cndmask_b32_e64 v54, v54, v66, s8
; GFX10-NEXT:    v_lshlrev_b32_e32 v66, 16, v65
; GFX10-NEXT:    v_cmp_eq_f32_e64 s8, 0, v66
; GFX10-NEXT:    v_cndmask_b32_e64 v66, v67, v68, s12
; GFX10-NEXT:    v_cndmask_b32_e64 v68, v66, v68, s9
; GFX10-NEXT:    v_cmp_eq_u16_e64 s9, 0, v67
; GFX10-NEXT:    v_cndmask_b32_e64 v67, v68, v67, s9
; GFX10-NEXT:    v_lshlrev_b32_e32 v68, 16, v66
; GFX10-NEXT:    v_cmp_eq_f32_e64 s9, 0, v68
; GFX10-NEXT:    v_cndmask_b32_e64 v68, v51, v69, s13
; GFX10-NEXT:    v_cndmask_b32_e64 v69, v68, v69, s10
; GFX10-NEXT:    v_cmp_eq_u16_e64 s10, 0, v51
; GFX10-NEXT:    v_cndmask_b32_e64 v51, v69, v51, s10
; GFX10-NEXT:    v_cndmask_b32_e64 v69, v80, v70, s14
; GFX10-NEXT:    v_cmp_eq_u16_e64 s10, 0, v70
; GFX10-NEXT:    v_cndmask_b32_e64 v70, v69, v70, s10
; GFX10-NEXT:    v_cmp_eq_u16_e64 s10, 0, v80
; GFX10-NEXT:    v_cndmask_b32_e64 v70, v70, v80, s10
; GFX10-NEXT:    v_cndmask_b32_e64 v80, v71, v82, s15
; GFX10-NEXT:    v_cmp_eq_u16_e64 s10, 0, v82
; GFX10-NEXT:    v_cndmask_b32_e64 v82, v80, v82, s10
; GFX10-NEXT:    v_cmp_eq_u16_e64 s10, 0, v71
; GFX10-NEXT:    v_cndmask_b32_e64 v71, v82, v71, s10
; GFX10-NEXT:    v_cndmask_b32_e64 v82, v81, v83, s16
; GFX10-NEXT:    v_cmp_eq_u16_e64 s10, 0, v83
; GFX10-NEXT:    v_lshlrev_b32_e32 v52, 16, v82
; GFX10-NEXT:    v_cndmask_b32_e64 v83, v82, v83, s10
; GFX10-NEXT:    v_cmp_eq_u16_e64 s10, 0, v81
; GFX10-NEXT:    v_cndmask_b32_e64 v81, v83, v81, s10
; GFX10-NEXT:    buffer_load_dword v83, off, s[0:3], s32
; GFX10-NEXT:    v_cmp_u_f32_e64 s10, v85, v85
; GFX10-NEXT:    v_lshlrev_b32_e32 v85, 16, v14
; GFX10-NEXT:    v_cmp_u_f32_e64 s11, v85, v85
; GFX10-NEXT:    v_cndmask_b32_e64 v85, v14, v30, s11
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v30
; GFX10-NEXT:    v_cmp_u_f32_e64 s11, v14, v14
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v84
; GFX10-NEXT:    v_cndmask_b32_e64 v87, v30, v85, s11
; GFX10-NEXT:    v_cmp_eq_f32_e64 s12, 0, v14
; GFX10-NEXT:    v_cndmask_b32_e64 v30, v35, v38, s4
; GFX10-NEXT:    v_cndmask_b32_e64 v35, v50, v49, s6
; GFX10-NEXT:    v_cndmask_b32_e64 v38, v65, v54, s8
; GFX10-NEXT:    v_lshlrev_b32_e32 v49, 16, v80
; GFX10-NEXT:    v_cndmask_b32_e64 v14, v84, v32, s12
; GFX10-NEXT:    v_lshlrev_b32_e32 v32, 16, v37
; GFX10-NEXT:    v_and_b32_e32 v84, 0xffff0000, v15
; GFX10-NEXT:    v_cmp_eq_f32_e64 s12, 0, v32
; GFX10-NEXT:    v_cndmask_b32_e64 v32, v37, v34, s12
; GFX10-NEXT:    v_lshlrev_b32_e32 v37, 16, v55
; GFX10-NEXT:    v_cndmask_b32_e64 v34, v48, v39, s5
; GFX10-NEXT:    v_lshlrev_b32_e32 v39, 16, v68
; GFX10-NEXT:    v_lshlrev_b32_e32 v48, 16, v69
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v37
; GFX10-NEXT:    v_cndmask_b32_e32 v37, v55, v64, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v84, v84
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshrrev_b32_e32 v50, 16, v83
; GFX10-NEXT:    v_and_b32_e32 v53, 0xffff0000, v83
; GFX10-NEXT:    v_lshlrev_b32_e32 v55, 16, v83
; GFX10-NEXT:    v_cndmask_b32_e64 v64, v15, v83, s10
; GFX10-NEXT:    v_cndmask_b32_e64 v15, v66, v67, s9
; GFX10-NEXT:    v_cndmask_b32_e32 v54, v86, v50, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v53, v53
; GFX10-NEXT:    v_lshlrev_b32_e32 v65, 16, v64
; GFX10-NEXT:    v_cndmask_b32_e32 v53, v50, v54, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX10-NEXT:    v_lshlrev_b32_e32 v50, 16, v54
; GFX10-NEXT:    v_cndmask_b32_e32 v55, v83, v64, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v39
; GFX10-NEXT:    v_lshlrev_b32_e32 v66, 16, v55
; GFX10-NEXT:    v_cndmask_b32_e32 v39, v68, v51, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v51, 16, v53
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v48
; GFX10-NEXT:    v_cndmask_b32_e32 v48, v69, v70, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v50, v51
; GFX10-NEXT:    v_cndmask_b32_e32 v51, v53, v54, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v65, v66
; GFX10-NEXT:    v_cndmask_b32_e32 v65, v55, v64, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v49
; GFX10-NEXT:    v_cndmask_b32_e32 v50, v80, v71, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v54
; GFX10-NEXT:    v_cndmask_b32_e32 v49, v51, v54, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v64
; GFX10-NEXT:    v_cndmask_b32_e32 v54, v65, v64, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v53
; GFX10-NEXT:    v_lshlrev_b32_e32 v64, 16, v51
; GFX10-NEXT:    v_cndmask_b32_e32 v49, v49, v53, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v55
; GFX10-NEXT:    v_lshlrev_b32_e32 v53, 16, v65
; GFX10-NEXT:    v_cndmask_b32_e32 v54, v54, v55, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v64
; GFX10-NEXT:    v_lshlrev_b32_e32 v55, 16, v13
; GFX10-NEXT:    v_lshlrev_b32_e32 v64, 16, v29
; GFX10-NEXT:    v_cndmask_b32_e32 v49, v51, v49, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v52
; GFX10-NEXT:    v_cndmask_b32_e32 v52, v82, v81, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v53
; GFX10-NEXT:    v_lshlrev_b32_e32 v53, 16, v87
; GFX10-NEXT:    v_cndmask_b32_e32 v51, v65, v54, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v54, 16, v85
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX10-NEXT:    v_lshlrev_b32_e32 v55, 16, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v13, v13, v29, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v54, v53
; GFX10-NEXT:    v_lshlrev_b32_e32 v54, 16, v28
; GFX10-NEXT:    v_lshlrev_b32_e32 v65, 16, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v53, v87, v85, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v64, v64
; GFX10-NEXT:    v_cndmask_b32_e32 v29, v29, v13, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX10-NEXT:    v_lshlrev_b32_e32 v64, 16, v29
; GFX10-NEXT:    v_cndmask_b32_e32 v12, v12, v28, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v85
; GFX10-NEXT:    v_lshlrev_b32_e32 v66, 16, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v55, v53, v85, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v54, v54
; GFX10-NEXT:    v_cndmask_b32_e32 v54, v28, v12, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v87
; GFX10-NEXT:    v_cndmask_b32_e32 v28, v55, v87, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v65, v64
; GFX10-NEXT:    v_lshlrev_b32_e32 v64, 16, v53
; GFX10-NEXT:    v_lshlrev_b32_e32 v65, 16, v54
; GFX10-NEXT:    v_cndmask_b32_e32 v55, v29, v13, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v13, v55, v13, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v64
; GFX10-NEXT:    v_lshlrev_b32_e32 v64, 16, v55
; GFX10-NEXT:    v_cndmask_b32_e32 v28, v53, v28, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v66, v65
; GFX10-NEXT:    v_lshlrev_b32_e32 v65, 16, v27
; GFX10-NEXT:    v_cndmask_b32_e32 v53, v54, v12, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v29
; GFX10-NEXT:    v_cndmask_b32_e32 v13, v13, v29, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v29, 16, v11
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v12, v53, v12, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v29, v29
; GFX10-NEXT:    v_lshlrev_b32_e32 v29, 16, v53
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v11, v27, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v54
; GFX10-NEXT:    v_cndmask_b32_e32 v12, v12, v54, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v65, v65
; GFX10-NEXT:    v_lshlrev_b32_e32 v54, 16, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v27, v27, v11, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v64
; GFX10-NEXT:    v_cndmask_b32_e32 v13, v55, v13, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v29
; GFX10-NEXT:    v_lshlrev_b32_e32 v29, 16, v27
; GFX10-NEXT:    v_lshlrev_b32_e32 v55, 16, v26
; GFX10-NEXT:    v_perm_b32 v13, v14, v13, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v12, v53, v12, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v53, 16, v11
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v54, v54
; GFX10-NEXT:    v_lshlrev_b32_e32 v54, 16, v9
; GFX10-NEXT:    v_perm_b32 v14, v31, v28, 0x5040100
; GFX10-NEXT:    v_perm_b32 v12, v32, v12, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v10, v26, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v53, v29
; GFX10-NEXT:    v_lshlrev_b32_e32 v53, 16, v25
; GFX10-NEXT:    v_cndmask_b32_e32 v29, v27, v11, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX10-NEXT:    v_lshlrev_b32_e32 v55, 16, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v26, v26, v10, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v54, v54
; GFX10-NEXT:    v_lshlrev_b32_e32 v54, 16, v26
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v9, v25, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v29, v11, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v53, v53
; GFX10-NEXT:    v_cndmask_b32_e32 v25, v25, v9, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v27
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v11, v27, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v27, 16, v29
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v55, v54
; GFX10-NEXT:    v_lshlrev_b32_e32 v54, 16, v25
; GFX10-NEXT:    v_lshlrev_b32_e32 v55, 16, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v53, v26, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v27
; GFX10-NEXT:    v_cndmask_b32_e32 v11, v29, v11, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v29, 16, v53
; GFX10-NEXT:    v_perm_b32 v11, v33, v11, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v53, v10, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v55, v54
; GFX10-NEXT:    v_cndmask_b32_e32 v27, v25, v9, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v26
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v10, v26, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX10-NEXT:    v_lshlrev_b32_e32 v26, 16, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v27, v9, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v29
; GFX10-NEXT:    v_lshlrev_b32_e32 v29, 16, v23
; GFX10-NEXT:    v_cndmask_b32_e32 v10, v53, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v25
; GFX10-NEXT:    v_perm_b32 v10, v30, v10, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v9, v25, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v7
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v26, v26
; GFX10-NEXT:    v_lshlrev_b32_e32 v26, 16, v24
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v8, v24, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v27
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v7, v23, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v26, v26
; GFX10-NEXT:    v_lshlrev_b32_e32 v53, 16, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v24, v24, v8, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v29, v29
; GFX10-NEXT:    v_lshlrev_b32_e32 v26, 16, v24
; GFX10-NEXT:    v_cndmask_b32_e32 v23, v23, v7, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v25
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v29, 16, v23
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v27, v9, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v27, 16, v8
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v22
; GFX10-NEXT:    v_perm_b32 v9, v34, v9, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v6, v22, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v27, v26
; GFX10-NEXT:    v_cndmask_b32_e32 v26, v24, v8, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v53, v29
; GFX10-NEXT:    v_lshlrev_b32_e32 v29, 16, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v27, v23, v7, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX10-NEXT:    v_cndmask_b32_e32 v22, v22, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v22
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v26, v8, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v27, v7, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v24
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v8, v24, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v23
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v26
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v7, v23, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v29, v25
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v27
; GFX10-NEXT:    v_cndmask_b32_e32 v23, v22, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v26, v8, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX10-NEXT:    v_perm_b32 v8, v35, v8, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v23, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v25
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v21
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v27, v7, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v22
; GFX10-NEXT:    v_perm_b32 v7, v36, v7, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v6, v22, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v22, 16, v23
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v5, v21, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v22
; GFX10-NEXT:    v_lshlrev_b32_e32 v22, 16, v20
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v23, v6, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX10-NEXT:    v_lshlrev_b32_e32 v23, 16, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v5
; GFX10-NEXT:    v_perm_b32 v6, v37, v6, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v21, v21, v5, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v21
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v4, v20, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX10-NEXT:    v_lshlrev_b32_e32 v22, 16, v19
; GFX10-NEXT:    v_cndmask_b32_e32 v20, v20, v4, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v19, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v20
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v23, v21, v5, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX10-NEXT:    v_cndmask_b32_e32 v19, v19, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v23, v5, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v19
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v22, v20, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v21
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v5, v21, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v21, 16, v23
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v22, v4, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX10-NEXT:    v_cndmask_b32_e32 v24, v19, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v21
; GFX10-NEXT:    v_lshlrev_b32_e32 v21, 16, v22
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v23, v5, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v20
; GFX10-NEXT:    v_lshlrev_b32_e32 v23, 16, v24
; GFX10-NEXT:    v_perm_b32 v5, v38, v5, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v4, v20, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v20, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v24, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v19
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v19, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX10-NEXT:    v_lshlrev_b32_e32 v19, 16, v18
; GFX10-NEXT:    v_lshlrev_b32_e32 v20, 16, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v18, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v23
; GFX10-NEXT:    v_lshlrev_b32_e32 v23, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v24, v3, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX10-NEXT:    v_lshlrev_b32_e32 v19, 16, v17
; GFX10-NEXT:    v_perm_b32 v3, v39, v3, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v18, v18, v2, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX10-NEXT:    v_lshlrev_b32_e32 v20, 16, v16
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v17, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX10-NEXT:    v_lshlrev_b32_e32 v23, 16, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v24, 16, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX10-NEXT:    v_lshlrev_b32_e32 v19, 16, v18
; GFX10-NEXT:    v_lshlrev_b32_e32 v25, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v17, v17, v1, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX10-NEXT:    v_lshlrev_b32_e32 v20, 16, v17
; GFX10-NEXT:    v_cndmask_b32_e32 v16, v16, v0, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v23, v19
; GFX10-NEXT:    v_lshlrev_b32_e32 v23, 16, v16
; GFX10-NEXT:    v_cndmask_b32_e32 v19, v18, v2, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v24, v20
; GFX10-NEXT:    v_cndmask_b32_e32 v20, v17, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v19, v2, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v23
; GFX10-NEXT:    v_cndmask_b32_e32 v23, v16, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v20, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v18
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v18, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v18, 16, v23
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v23, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v17
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v17, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v17, 16, v20
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v16
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v17
; GFX10-NEXT:    v_lshlrev_b32_e32 v16, 16, v19
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v20, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v18
; GFX10-NEXT:    v_perm_b32 v1, v50, v1, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v23, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v16
; GFX10-NEXT:    v_perm_b32 v0, v52, v0, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v19, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v21
; GFX10-NEXT:    v_perm_b32 v2, v48, v2, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v22, v4, vcc_lo
; GFX10-NEXT:    v_perm_b32 v4, v15, v4, 0x5040100
; GFX10-NEXT:    v_perm_b32 v15, v49, v51, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_v32bf16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v33, 0xffff0000, v14
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v32, 0xffff0000, v15
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v34, 0xffff0000, v30
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v55, 0xffff0000, v7
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v85, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v33, v33
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v32, v32
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v34, v34
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v35, 0xffff0000, v13
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v37, 0xffff0000, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v32.l, v14.h, v30.h, s1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v39, 0xffff0000, v11
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v49, 0xffff0000, v10
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v51, 0xffff0000, v9
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v53, 0xffff0000, v8
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v54, 0xffff0000, v24
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v65, 0xffff0000, v6
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v67, 0xffff0000, v5
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v69, 0xffff0000, v4
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v71, 0xffff0000, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v86, 0xffff0000, v16
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s15, v55, v55
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s29, v85, v85
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v55.l, v30.h, v32.l, s2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v36, 0xffff0000, v29
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v38, 0xffff0000, v28
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v48, 0xffff0000, v27
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v50, 0xffff0000, v26
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v52, 0xffff0000, v25
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v64, 0xffff0000, v23
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v66, 0xffff0000, v22
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v68, 0xffff0000, v21
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v70, 0xffff0000, v20
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v80, 0xffff0000, v19
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v81, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v83, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s3, v35, v35
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s5, v37, v37
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s7, v39, v39
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s9, v49, v49
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s11, v51, v51
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s13, v53, v53
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s14, v54, v54
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s17, v65, v65
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s19, v67, v67
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s21, v69, v69
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s23, v71, v71
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s40, v86, v86
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v54.l, v0.h, v16.h, s29
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v86.l, v32.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v118.l, v55.l
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v82, 0xffff0000, v18
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v84, 0xffff0000, v17
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s4, v36, v36
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s6, v38, v38
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s8, v48, v48
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s10, v50, v50
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s12, v52, v52
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s16, v64, v64
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s18, v66, v66
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s20, v68, v68
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s22, v70, v70
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s24, v80, v80
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s25, v81, v81
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s27, v83, v83
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v33.l, v13.h, v29.h, s3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v34.l, v12.h, v28.h, s5
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v35.l, v11.h, v27.h, s7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v36.l, v10.h, v26.h, s9
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v37.l, v9.h, v25.h, s11
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v38.l, v8.h, v24.h, s13
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v39.l, v7.h, v23.h, s15
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v48.l, v6.h, v22.h, s17
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v49.l, v5.h, v21.h, s19
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v50.l, v4.h, v20.h, s21
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v51.l, v3.h, v19.h, s23
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v85.l, v16.h, v54.l, s40
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v86, 16, v86
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v118, 16, v118
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v87, 16, v15
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v96, 16, v14
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s26, v82, v82
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s28, v84, v84
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v52.l, v2.h, v18.h, s25
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v53.l, v1.h, v17.h, s27
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v64.l, v29.h, v33.l, s4
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v65.l, v28.h, v34.l, s6
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v66.l, v27.h, v35.l, s8
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v67.l, v26.h, v36.l, s10
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v68.l, v25.h, v37.l, s12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v69.l, v24.h, v38.l, s14
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v70.l, v23.h, v39.l, s16
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v71.l, v22.h, v48.l, s18
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v80.l, v21.h, v49.l, s20
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v81.l, v20.h, v50.l, s22
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v82.l, v19.h, v51.l, s24
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v116.l, v54.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s40, v86, v118
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v86.l, v85.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v97, 16, v30
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v87, v87
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s41, v96, v96
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v87.l, v33.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v96.l, v34.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v98.l, v36.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v101.l, v39.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v112.l, v50.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v113.l, v51.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v83.l, v18.h, v52.l, s26
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v84.l, v17.h, v53.l, s28
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v119.l, v64.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v128.l, v65.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v129.l, v66.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v130.l, v67.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v131.l, v68.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v132.l, v69.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v133.l, v70.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v134.l, v71.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v135.l, v80.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v144.l, v81.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v145.l, v82.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v116, 16, v116
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v86, 16, v86
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s42, v97, v97
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v14.l, v14.l, v30.l, s41
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v32.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v99.l, v37.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v114.l, v52.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v115.l, v53.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v87, 16, v87
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v96, 16, v96
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v98, 16, v98
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v101, 16, v101
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v112, 16, v112
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v113, 16, v113
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v146.l, v83.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v147.l, v84.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v118, 16, v119
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v119, 16, v128
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v128, 16, v129
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v129, 16, v130
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v130, 16, v131
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v131, 16, v132
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v132, 16, v133
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v133, 16, v134
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v134, 16, v135
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v135, 16, v144
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v144, 16, v145
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s63, v116, v86
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v86.l, v55.l, v32.l, s40
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v117, 16, v13
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v30.l, v30.l, v14.l, s42
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s16, 0, v55.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v99, 16, v99
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v114, 16, v114
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v115, 16, v115
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v145, 16, v146
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v146, 16, v147
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s42, v87, v118
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s43, v96, v119
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s45, v98, v129
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s56, v101, v132
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s59, v112, v135
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s60, v113, v144
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v13.h, v86.l, v32.l, s1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v118.l, v86.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s3, 0, v34.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v97.l, v35.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s5, 0, v36.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s8, 0, v39.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s11, 0, v50.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s12, 0, v51.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s46, v99, v130
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s61, v114, v145
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s62, v115, v146
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v96.l, v65.l, v34.l, s43
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v98.l, v67.l, v36.l, s45
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v101.l, v70.l, v39.l, s56
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v112.l, v81.l, v50.l, s59
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v113.l, v82.l, v51.l, s60
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v13.h, v13.h, v55.l, s16
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v118
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v33.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s6, 0, v37.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v102.l, v48.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s13, 0, v52.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s14, 0, v53.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v97, 16, v97
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s23, 0, v70.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s26, 0, v81.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v87.l, v64.l, v33.l, s42
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v99.l, v68.l, v37.l, s46
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v114.l, v83.l, v52.l, s61
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v115.l, v84.l, v53.l, s62
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v30.h, v96.l, v34.l, s3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v32.h, v98.l, v36.l, s5
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v34.l, v101.l, v39.l, s8
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v39.l, v101.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v35.h, v112.l, v50.l, s11
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v50.l, v112.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v36.l, v113.l, v51.l, s12
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v51.l, v113.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v55
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v100.l, v38.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v103.l, v49.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s15, 0, v54.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v102, 16, v102
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s44, v97, v128
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v116.l, v85.l, v54.l, s63
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v14.h, v87.l, v33.l, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v33.l, v99.l, v37.l, s6
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v36.h, v114.l, v52.l, s13
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v114.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v37.l, v115.l, v53.l, s14
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v115.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v34.l, v34.l, v70.l, s23
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v70, 16, v39
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v39.l, v35.h, v81.l, s26
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v81, 16, v50
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s4, 0, v35.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v100, 16, v100
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v103, 16, v103
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s57, v102, v133
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v97.l, v66.l, v35.l, s44
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v37.h, v116.l, v54.l, s15
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v54.l, v116.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v52
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v53, 16, v53
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s12, 0, v51
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s9, 0, v48.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s18, 0, v65.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s19, 0, v66.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s47, v100, v131
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s58, v103, v134
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v102.l, v71.l, v48.l, s57
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v128.l, v96.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v32.l, v97.l, v35.l, s4
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v129.l, v97.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v54
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s13, 0, v52
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s14, 0, v53
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s7, 0, v38.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s10, 0, v49.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s17, 0, v64.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s24, 0, v71.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v100.l, v69.l, v38.l, s47
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v103.l, v80.l, v49.l, s58
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v119.l, v87.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v34.h, v102.l, v48.l, s9
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v48.l, v102.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v30.h, v30.h, v65.l, s18
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v128
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v32.l, v32.l, v66.l, s19
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v66, 16, v129
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s25, 0, v80.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s41, 0, v85.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v33.h, v100.l, v38.l, s7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v35.l, v103.l, v49.l, s10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v49.l, v103.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v38.l, v14.h, v64.l, s17
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v64, 16, v119
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v38.h, v34.h, v71.l, s24
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v71, 16, v48
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s3, 0, v65
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s4, 0, v66
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v14.h, v86.l, v13.h, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v35.l, v35.l, v80.l, s25
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v80, 16, v49
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v49.l, v37.h, v85.l, s41
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v64
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s9, 0, v71
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v37.h, v96.l, v30.h, s3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v30.h, v97.l, v32.l, s4
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s20, 0, v67.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s21, 0, v68.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v130.l, v98.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v131.l, v99.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v13.h, v87.l, v38.l, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v35.h, v102.l, v38.h, s9
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v32.h, v32.h, v67.l, s20
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v67, 16, v130
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v33.l, v33.l, v68.l, s21
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v68, 16, v131
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s29, 0, v84.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s8, 0, v70
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s5, 0, v67
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s27, 0, v82.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s6, 0, v68
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v37.l, v37.l, v84.l, s29
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v34.h, v101.l, v34.l, s8
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s28, 0, v83.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s10, 0, v80
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v36.l, v36.l, v82.l, s27
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v49.h, v115.l, v37.l, s14
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s22, 0, v69.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v48.l, v36.h, v83.l, s28
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v36.h, v103.l, v35.l, s10
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v39.h, v113.l, v36.l, s12
; GFX11-TRUE16-NEXT:    v_mov_b16_e64 v132.l, v100.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v33.h, v33.h, v69.l, s22
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s11, 0, v81
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v48.h, v114.l, v48.l, s13
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v69, 16, v132
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s7, 0, v69
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v33.h, v100.l, v33.h, s7
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v55, 0xffff0000, v31
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v50.l, v15.h, v31.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v15.l, v15.l, v31.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v50.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v15.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v51.l, v31.h, v50.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v54
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v31
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v52
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v31.h, v98.l, v32.h, s5
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v51.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v32.h, v99.l, v33.l, s6
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v54, v54
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v53, 16, v53
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v31.l, v31.l, v15.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v50.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v52, v53
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v15.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v31.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v32.l, v51.l, v50.l, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v38, 16, v52
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v53, 16, v53
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v51.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v32.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v15.h, v32.l, v50.l, s0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v38, v53
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v38.h, v112.l, v39.l, s11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v52
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v15.h, v15.h, v51.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v33.l, v31.l, v15.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v51.l, v14.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v29
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v50
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v50.l, v30.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v33.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v15.l, v33.l, v15.l, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v15.h, v32.l, v15.h, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v117, v117
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v50
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v31.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v29.h, v116.l, v49.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v13.l, v13.l, v29.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v52, v52
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v53
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v51, v50
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v15.l, v15.l, v31.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v29.l, v29.l, v13.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v52
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v31.l, v30.l, v14.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v13.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v50, v50
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v51.l, v29.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v28
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v14.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v31.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v52
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v12.l, v12.l, v28.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v50, v50
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v12.h, v31.l, v14.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v30.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v53
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v52, v51
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v28.l, v28.l, v12.l, s1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v51.l, v12.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v12.h, v12.h, v30.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v50
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v30.l, v29.l, v13.l, s2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v50.l, v28.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v15.l, v33.l, v15.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v13.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v14.l, v31.l, v12.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v50
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v52, v52
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v27
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v30.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v11.h, v30.l, v13.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v51, v50
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v11.l, v11.l, v27.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v52, v52
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v53
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v29.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v31.l, v28.l, v12.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v12.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v27.l, v27.l, v11.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v50
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v10
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v11.h, v11.h, v29.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v10.h, v31.l, v12.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v27.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v51.l, v11.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v50, v50
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v26
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v28.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v31.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v10.l, v10.l, v26.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v50, v50
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v52
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v13.l, v30.l, v11.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v51, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v10.h, v10.h, v28.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v12.l, v26.l, v10.l, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v9
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v50
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v26.l, v27.l, v11.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v51.l, v10.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v50.l, v12.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v28, v28
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v25
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v26.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v50
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v9.l, v9.l, v25.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v28, v28
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v9.h, v26.l, v11.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v27.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v52
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v51, v50
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v11.l, v25.l, v9.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v37.l, v31.l, v10.h, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v9.h, v9.h, v27.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v28
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v25.l, v12.l, v10.l, s2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v27.l, v11.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v28.l, v9.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v10.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v30.l, v26.l, v9.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v27
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v28
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.h, v25.l, v10.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v50, v50
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v24
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v28.l, v25.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v27, v26
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v12.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v8.l, v24.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v28
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v10.l, v11.l, v9.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v9.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.h, v8.h, v12.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v12.l, v24.l, v8.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v7
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v26
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.h, v10.l, v9.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v26.l, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v12.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v24, v24
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v23
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v27.l, v10.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v7.l, v23.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v24, v24
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v11.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v27
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v31.l, v25.l, v8.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v26, v9
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v9.l, v23.l, v7.l, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v6
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.h, v7.h, v11.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v24
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v11.l, v12.l, v8.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v24.l, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v7.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v23, v23
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v22
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v26.l, v11.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v6.l, v22.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v23, v23
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.h, v11.l, v8.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v26
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v25, v24
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v22.l, v6.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v32.l, v10.l, v7.h, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.h, v6.h, v12.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v23
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v10.l, v9.l, v7.l, s2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v8.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v6.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v5
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v33.l, v11.l, v6.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v22
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.h, v10.l, v7.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v21
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v10.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v12, v11
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v9.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v21.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v22
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v8.l, v6.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v6.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.h, v5.h, v9.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v9.l, v21.l, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v4
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.h, v7.l, v6.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v7.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v11, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v20
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v8.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v4.l, v20.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v11, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v21
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v34.l, v10.l, v5.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v20.l, v4.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.h, v4.h, v8.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v9.l, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v6.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v10, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v19
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v20.l, v8.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v19.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v10, v10
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.h, v8.l, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v20
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v12, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v19.l, v3.l, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.h, v3.h, v9.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v3.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v5.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v11, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v18
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v9.l, v6.l, v4.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v4.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v18.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v11, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.h, v9.l, v4.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v6.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v35.l, v7.l, v4.h, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v18.l, v2.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v11, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v36.l, v8.l, v2.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.h, v3.h, v6.l, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v5.l, v3.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v10, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v17
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v11, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v16
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v9.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v4.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v2.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v17.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v10, v10
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v16.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v11, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v17.l, v1.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v3.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v16.l, v0.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v12, v8
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v1.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v7.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v16.l, v3.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v4.l, v2.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v5.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v6.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v8.l, v2.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v17, v16
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v4.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v5
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v7.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v3.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v1.h, v4.l, s1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v8.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v16.l, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v5.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v2.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v7.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v3.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v12
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v16
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v4
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v11
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s3, 0, v10
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v29.l, v5.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v49.l, v2.l, v1.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v48.l, v8.l, v1.h, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v39.l, v6.l, v0.h, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v38.l, v9.l, v2.h, s3
; GFX11-TRUE16-NEXT:    v_mov_b32_e32 v0, v29
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v1, v49 :: v_dual_mov_b32 v2, v48
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v3, v39 :: v_dual_mov_b32 v4, v38
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v5, v36 :: v_dual_mov_b32 v6, v35
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v7, v34 :: v_dual_mov_b32 v8, v33
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v9, v32 :: v_dual_mov_b32 v10, v31
; GFX11-TRUE16-NEXT:    v_dual_mov_b32 v11, v30 :: v_dual_mov_b32 v12, v37
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_v32bf16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v50, 0xffff0000, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 16, v28
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v12
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v29
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v13
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e64 s1, v50, v50
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v30
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v83, 16, v24
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v70, 0xffff0000, v9
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e64 v52, v52, v51, s1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v38, 0xffff0000, v13
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v80, 16, v9
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v103, 16, v21
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v82, 0xffff0000, v8
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v84, 16, v8
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e64 s0, v38, v38
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v87, 16, v23
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v86, 0xffff0000, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v96, 16, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v99, 16, v22
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e64 v48, v48, v39, s0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v34, 0xffff0000, v14
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v98, 0xffff0000, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v100, 16, v6
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v115, 16, v20
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v102, 0xffff0000, v5
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v34, v34
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v37, 0xffff0000, v30
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v112, 16, v5
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v119, 16, v19
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v114, 0xffff0000, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v36, v36, v35, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v70, v70
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v49, 0xffff0000, v29
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v116, 16, v4
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v131, 16, v18
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v118, 0xffff0000, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v70, v80, v71, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v82, v82
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v53, 0xffff0000, v28
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v128, 16, v3
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v130, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v132, 16, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v80, v84, v83, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v86, v86
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v69, 0xffff0000, v26
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v135, 16, v17
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v134, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v27
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v82, v96, v87, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v98, v98
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v81, 0xffff0000, v25
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v54, 0xffff0000, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v144, 16, v1
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v146, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v84, v100, v99, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v102, v102
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v85, 0xffff0000, v24
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v147, 16, v16
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v0
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e64 s2, v54, v54
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v86, v112, v103, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v114, v114
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v101, 0xffff0000, v22
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v14
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 16, v11
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 16, v26
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v96, v116, v115, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v118, v118
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v113, 0xffff0000, v21
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e64 v64, v64, v55, s2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v10
; GFX11-FAKE16-NEXT:    scratch_load_b32 v31, off, s32
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v98, v128, v119, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v130, v130
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v117, 0xffff0000, v20
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v15
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v100, v132, v131, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v134, v134
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v102, v144, v135 :: v_dual_and_b32 v133, 0xffff0000, v18
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v146, v146
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v145, 0xffff0000, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v112, 16, v96
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v34, v34, v147, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v54, v54
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v65, 0xffff0000, v27
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v54, v14, v30 :: v_dual_and_b32 v97, 0xffff0000, v23
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v37, v37
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v32, 0xffff0000, v15
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v129, 0xffff0000, v19
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v35, v35, v36, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v49, v49
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v39, v39, v48, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v53, v53
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v51, v51, v52, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v65, v65
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v116, 16, v100
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v55, v55, v64 :: v_dual_lshlrev_b32 v130, 16, v51
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v69, v69
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v66, 0xffff0000, v10
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v128, 16, v34
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e64 s3, v66, v66
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e64 v68, v68, v67, s3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v67, v67, v68, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v81, v81
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v68
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v81, 16, v80
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v71, v71, v70 :: v_dual_lshlrev_b32 v132, 16, v67
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v85, v85
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v83, v83, v80, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v97, v97
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v66, 16, v30
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v97, 16, v84
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v87, v87, v82 :: v_dual_lshlrev_b32 v134, 16, v83
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v101, v101
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v38, 0xffff0000, v16
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v99, v99, v84, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v113, v113
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v103, v103, v86 :: v_dual_lshlrev_b32 v144, 16, v99
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v117, v117
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v36
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v113, v115, v96, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v129, v129
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v85, 16, v82
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v115, v119, v98 :: v_dual_lshlrev_b32 v146, 16, v113
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v133, v133
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v37, 16, v48
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v117, v131, v100, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v145, v145
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v101, 16, v86
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v119, v135, v102, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v38, v38
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v38, v147, v34 :: v_dual_lshlrev_b32 v49, 16, v52
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v66, v66
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e64 s0, v49, v130
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v66, v30, v54 :: v_dual_lshlrev_b32 v53, 16, v64
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v30, 16, v35
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v14, v30
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v69, 16, v70
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v117
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v130, v35, v36 :: v_dual_lshlrev_b32 v129, 16, v39
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v37, v129
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e64 v129, v51, v52, s0
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v37, v39, v48 :: v_dual_lshlrev_b32 v118, 16, v102
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v131, 16, v55
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v53, v131
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v53, v55, v64 :: v_dual_lshlrev_b32 v50, 16, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v133, 16, v71
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v65, v132
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v65, v67, v68, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v69, v133
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v135, 16, v87
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v69, v71, v70 :: v_dual_lshlrev_b32 v132, 16, v65
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v81, v134
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v81, v83, v80, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v85, v135
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v145, 16, v103
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v85, v87, v82, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v97, v144
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v97, v99, v84 :: v_dual_lshlrev_b32 v114, 16, v98
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v101, v145
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v147, 16, v115
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v101, v103, v86 :: v_dual_lshlrev_b32 v144, 16, v97
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v112, v146
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v112, v113, v96, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v114, v147
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v30, 16, v119
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v49, 16, v38
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v114, v115, v98, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v116, v14
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v116, v117, v100, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v118, v30
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v118, v119, v102, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v128, v49
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v128, v38, v34, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v36
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v14, v130, v36, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v48
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v36, v37, v48, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v52
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v49, v129, v52, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v64
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v129
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v64, v53, v64, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v68
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v68, v65, v68, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v70
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v70, v69, v70, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v80
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v80, v81, v80, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v82
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v82, v85, v82, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v84
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v84, v97, v84, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v86
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v86, v101, v86, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v96
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v96, v112, v96, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v98
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v98, v114, v98 :: v_dual_lshlrev_b32 v131, 16, v53
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v100
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v100, v116, v100 :: v_dual_lshlrev_b32 v133, 16, v69
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v35
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v14, v14, v35 :: v_dual_lshlrev_b32 v135, 16, v85
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v102
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v35, v118, v102, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v39
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v36, v36, v39 :: v_dual_lshlrev_b32 v145, 16, v101
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v34
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v34, v128, v34, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v51
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v39, v49, v51, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v55
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v128
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v49, v64, v55, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v67
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v55, v68, v67, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v71
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v64, v70, v71 :: v_dual_lshlrev_b32 v147, 16, v114
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v83
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v67, v80, v83, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v87
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v68, v82, v87, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v99
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v70, v84, v99, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v103
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v71, v86, v103 :: v_dual_lshlrev_b32 v30, 16, v130
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v113
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v48, 16, v37
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v80, v96, v113, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v115
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v82, v98, v115, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v117
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v134, 16, v81
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v83, v100, v117, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v119
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v84, v35, v119, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v38
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v86, v34, v38, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v30
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v14, v130, v14, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v48
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v30, v37, v36, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v52
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v31
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v34, v129, v39, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v131
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v35, v53, v49, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v132
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v53, 0xffff0000, v31
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v36, v65, v55, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v133
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v37, v69, v64, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v134
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v38, v81, v67, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v135
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v39, v85, v68, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v144
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v48, v97, v70, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v145
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v49, v101, v71, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v50, v50
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v55, v15, v31, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v32, v32
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v32, 16, v31
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v148, 16, v116
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v55
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v33, v33, v52, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v146, 16, v112
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v33
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v146
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v15, v112, v80, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v53, v53
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v52, v52, v33, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v32, v32
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v102, 16, v118
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v53, v31, v55 :: v_dual_lshlrev_b32 v64, 16, v52
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v147
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v67, 16, v53
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v31, v114, v82, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v148
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v32, v116, v83, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v50, v64
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v64, v52, v33, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v65, v67
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v67, 16, v64
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v65, v53, v55, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v102
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v68, 16, v65
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v50, v118, v84, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v33
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v33, v64, v33, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v55
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v55, v65, v55, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v52
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v33, v33, v52, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v53
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v53, v55, v53, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v67
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v13
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v33, v64, v33, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v51
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v52, v128, v86, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v68
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v51, v65, v53, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v53, 16, v66
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v29
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v12
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v13, v13, v29 :: v_dual_lshlrev_b32 v64, 16, v54
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v64, v53
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v53, v66, v54, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v65, v65
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v13
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v29, v29, v13, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v28
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v64, 16, v29
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v12, v28, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v54
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v54, v53, v54, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v28, v28, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v66
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v54, v54, v66, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v65, v64
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v64, 16, v53
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v28
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v55, v29, v13 :: v_dual_lshlrev_b32 v66, 16, v12
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v13
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v13, v55, v13, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v64
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v53, v53, v54 :: v_dual_lshlrev_b32 v64, 16, v55
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v66, v65
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v27
; GFX11-FAKE16-NEXT:    v_perm_b32 v14, v14, v53, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v54, v28, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v29
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v13, v13, v29, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v11
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v54, v12, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v29, v29
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v10
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v11, v27, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v28
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v12, v28, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v65, v65
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v27, v27, v11 :: v_dual_lshlrev_b32 v28, 16, v54
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v64
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v13, v55, v13, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v28
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v26
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_perm_b32 v13, v30, v13, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v54, v12, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v29, v29
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v11
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v10, v26 :: v_dual_lshlrev_b32 v29, 16, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v27
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v54, v28
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v28, v27, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v26, v26, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v29, v29
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v25
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v9, v25, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v11, v28, v11 :: v_dual_lshlrev_b32 v54, 16, v26
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v29, v29
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v25, v25, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v27
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v11, v27, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v28
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v10
; GFX11-FAKE16-NEXT:    v_perm_b32 v12, v34, v12, 0x5040100
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v55, v54
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v9
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v29, v26, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v27
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v28, v11, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v29
; GFX11-FAKE16-NEXT:    v_perm_b32 v11, v35, v11, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v29, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v55, v54
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v27, v25, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v26
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v10, v26, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v27, v9, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v28
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v23
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v29, v10, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v25
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v9, v25 :: v_dual_lshlrev_b32 v26, 16, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v26, v26
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v8, v24, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v27
; GFX11-FAKE16-NEXT:    v_perm_b32 v10, v36, v10, 0x5040100
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v7, v23 :: v_dual_lshlrev_b32 v26, 16, v24
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v7
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v26, v26
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v24, v24, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v28, v28
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v23, v23, v7 :: v_dual_lshlrev_b32 v26, 16, v24
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v6
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v27, v9 :: v_dual_lshlrev_b32 v28, 16, v23
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v8
; GFX11-FAKE16-NEXT:    v_perm_b32 v9, v37, v9, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v22, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v27, v26
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v26, v24, v8 :: v_dual_lshlrev_b32 v25, 16, v22
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v29, v28
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v27, v23, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v22, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v26, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v27, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v24
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v8, v24, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v23
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v7, v23 :: v_dual_lshlrev_b32 v24, 16, v26
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v22
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v6
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v28, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v27
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v23, v22, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v26, v8, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v23, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v21
; GFX11-FAKE16-NEXT:    v_perm_b32 v8, v38, v8, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v27, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v22
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v7, v39, v7, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v22, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v21 :: v_dual_lshlrev_b32 v24, 16, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v23
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v22
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v20
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v23, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v21, v21, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v21
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v20, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v19, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v20
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v4
; GFX11-FAKE16-NEXT:    v_perm_b32 v6, v48, v6, 0x5040100
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v23, v21, v5 :: v_dual_lshlrev_b32 v22, 16, v19
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v19, v19, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v23, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v19
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v20, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v21
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v5, v21, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v22, v4 :: v_dual_lshlrev_b32 v21, 16, v23
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v24, v19, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v21
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v22
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v23, v5, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v20
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v5, v49, v5, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v20, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v24, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v19
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v19 :: v_dual_lshlrev_b32 v20, 16, v2
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v18
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v2, v18 :: v_dual_lshlrev_b32 v23, 16, v24
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v23
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v24, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v3, v31, v3, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v18, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v17, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v17
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v17, v17, v1 :: v_dual_lshlrev_b32 v20, 16, v16
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v16, v16, v0 :: v_dual_lshlrev_b32 v19, 16, v18
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v17
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v23, v19
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v19, v18, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v24, v20
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v17, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v19, v2 :: v_dual_lshlrev_b32 v23, 16, v16
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v0
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v23
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v23, v16, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v20, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v18
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v18, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v23, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v17
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v17, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v20
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v16
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v17
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v23
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v20, v1 :: v_dual_lshlrev_b32 v16, 16, v19
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v18
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v50, v1, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v23, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v16
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v52, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v19, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v21
; GFX11-FAKE16-NEXT:    v_perm_b32 v2, v32, v2, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v22, v4, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v4, v15, v4, 0x5040100
; GFX11-FAKE16-NEXT:    v_perm_b32 v15, v33, v51, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_v32bf16:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    scratch_load_b32 v31, off, s32
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v33, 0xffff0000, v14
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v32, 0xffff0000, v15
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v34, 0xffff0000, v30
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v55, 0xffff0000, v7
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v85, 0xffff0000, v0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v33, v33
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v32, v32
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v34, v34
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v35, 0xffff0000, v13
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v37, 0xffff0000, v12
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v32.l, v14.h, v30.h, s1
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v39, 0xffff0000, v11
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v49, 0xffff0000, v10
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v51, 0xffff0000, v9
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v53, 0xffff0000, v8
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v54, 0xffff0000, v24
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v65, 0xffff0000, v6
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v67, 0xffff0000, v5
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v69, 0xffff0000, v4
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v71, 0xffff0000, v3
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v86, 0xffff0000, v16
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s15, v55, v55
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s29, v85, v85
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v55.l, v30.h, v32.l, s2
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v36, 0xffff0000, v29
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v38, 0xffff0000, v28
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v48, 0xffff0000, v27
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v50, 0xffff0000, v26
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v52, 0xffff0000, v25
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v64, 0xffff0000, v23
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v66, 0xffff0000, v22
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v68, 0xffff0000, v21
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v70, 0xffff0000, v20
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v80, 0xffff0000, v19
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v81, 0xffff0000, v2
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v83, 0xffff0000, v1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s3, v35, v35
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s5, v37, v37
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s7, v39, v39
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s9, v49, v49
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s11, v51, v51
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s13, v53, v53
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s14, v54, v54
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s17, v65, v65
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s19, v67, v67
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s21, v69, v69
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s23, v71, v71
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s40, v86, v86
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v54.l, v0.h, v16.h, s29
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v86.l, v32.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v118.l, v55.l
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v82, 0xffff0000, v18
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v84, 0xffff0000, v17
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s4, v36, v36
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s6, v38, v38
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s8, v48, v48
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s10, v50, v50
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s12, v52, v52
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s16, v64, v64
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s18, v66, v66
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s20, v68, v68
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s22, v70, v70
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s24, v80, v80
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s25, v81, v81
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s27, v83, v83
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v33.l, v13.h, v29.h, s3
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v34.l, v12.h, v28.h, s5
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v35.l, v11.h, v27.h, s7
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v36.l, v10.h, v26.h, s9
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v37.l, v9.h, v25.h, s11
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v38.l, v8.h, v24.h, s13
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v39.l, v7.h, v23.h, s15
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v48.l, v6.h, v22.h, s17
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v49.l, v5.h, v21.h, s19
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v50.l, v4.h, v20.h, s21
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v51.l, v3.h, v19.h, s23
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v85.l, v16.h, v54.l, s40
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v86, 16, v86
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v118, 16, v118
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v87, 16, v15
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v96, 16, v14
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s26, v82, v82
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s28, v84, v84
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v52.l, v2.h, v18.h, s25
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v53.l, v1.h, v17.h, s27
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v64.l, v29.h, v33.l, s4
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v65.l, v28.h, v34.l, s6
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v66.l, v27.h, v35.l, s8
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v67.l, v26.h, v36.l, s10
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v68.l, v25.h, v37.l, s12
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v69.l, v24.h, v38.l, s14
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v70.l, v23.h, v39.l, s16
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v71.l, v22.h, v48.l, s18
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v80.l, v21.h, v49.l, s20
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v81.l, v20.h, v50.l, s22
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v82.l, v19.h, v51.l, s24
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v116.l, v54.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s40, v86, v118
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v86.l, v85.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v97, 16, v30
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v87, v87
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s41, v96, v96
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v87.l, v33.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v96.l, v34.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v98.l, v36.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v101.l, v39.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v112.l, v50.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v113.l, v51.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v83.l, v18.h, v52.l, s26
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v84.l, v17.h, v53.l, s28
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v119.l, v64.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v128.l, v65.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v129.l, v66.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v130.l, v67.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v131.l, v68.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v132.l, v69.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v133.l, v70.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v134.l, v71.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v135.l, v80.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v144.l, v81.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v145.l, v82.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v116, 16, v116
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v86, 16, v86
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s42, v97, v97
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v14.l, v14.l, v30.l, s41
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v32.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v99.l, v37.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v114.l, v52.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v115.l, v53.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v87, 16, v87
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v96, 16, v96
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v98, 16, v98
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v101, 16, v101
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v112, 16, v112
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v113, 16, v113
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v146.l, v83.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v147.l, v84.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v118, 16, v119
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v119, 16, v128
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v128, 16, v129
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v129, 16, v130
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v130, 16, v131
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v131, 16, v132
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v132, 16, v133
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v133, 16, v134
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v134, 16, v135
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v135, 16, v144
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v144, 16, v145
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s63, v116, v86
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v86.l, v55.l, v32.l, s40
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v117, 16, v13
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v30.l, v30.l, v14.l, s42
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s16, 0, v55.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v99, 16, v99
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v114, 16, v114
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v115, 16, v115
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v145, 16, v146
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v146, 16, v147
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s42, v87, v118
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s43, v96, v119
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s45, v98, v129
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s56, v101, v132
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s59, v112, v135
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s60, v113, v144
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v13.h, v86.l, v32.l, s1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v118.l, v86.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s3, 0, v34.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v97.l, v35.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s5, 0, v36.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s8, 0, v39.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s11, 0, v50.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s12, 0, v51.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s46, v99, v130
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s61, v114, v145
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s62, v115, v146
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v96.l, v65.l, v34.l, s43
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v98.l, v67.l, v36.l, s45
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v101.l, v70.l, v39.l, s56
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v112.l, v81.l, v50.l, s59
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v113.l, v82.l, v51.l, s60
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v13.h, v13.h, v55.l, s16
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v118
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v33.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s6, 0, v37.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v102.l, v48.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s13, 0, v52.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s14, 0, v53.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v97, 16, v97
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s23, 0, v70.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s26, 0, v81.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v87.l, v64.l, v33.l, s42
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v99.l, v68.l, v37.l, s46
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v114.l, v83.l, v52.l, s61
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v115.l, v84.l, v53.l, s62
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v30.h, v96.l, v34.l, s3
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v32.h, v98.l, v36.l, s5
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v34.l, v101.l, v39.l, s8
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v39.l, v101.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v35.h, v112.l, v50.l, s11
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v50.l, v112.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v36.l, v113.l, v51.l, s12
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v51.l, v113.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v55
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v100.l, v38.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v103.l, v49.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s15, 0, v54.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v102, 16, v102
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s44, v97, v128
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v116.l, v85.l, v54.l, s63
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v14.h, v87.l, v33.l, s2
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v33.l, v99.l, v37.l, s6
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v36.h, v114.l, v52.l, s13
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v114.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v37.l, v115.l, v53.l, s14
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v115.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v34.l, v34.l, v70.l, s23
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v70, 16, v39
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v39.l, v35.h, v81.l, s26
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v81, 16, v50
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s4, 0, v35.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v100, 16, v100
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v103, 16, v103
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s57, v102, v133
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v97.l, v66.l, v35.l, s44
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v37.h, v116.l, v54.l, s15
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v54.l, v116.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v52
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v53, 16, v53
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s12, 0, v51
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s9, 0, v48.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s18, 0, v65.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s19, 0, v66.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s47, v100, v131
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s58, v103, v134
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v102.l, v71.l, v48.l, s57
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v128.l, v96.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v32.l, v97.l, v35.l, s4
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v129.l, v97.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v54
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s13, 0, v52
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s14, 0, v53
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s7, 0, v38.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s10, 0, v49.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s17, 0, v64.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s24, 0, v71.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v100.l, v69.l, v38.l, s47
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v103.l, v80.l, v49.l, s58
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v119.l, v87.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v34.h, v102.l, v48.l, s9
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v48.l, v102.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v30.h, v30.h, v65.l, s18
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v128
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v32.l, v32.l, v66.l, s19
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v66, 16, v129
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s25, 0, v80.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s41, 0, v85.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v33.h, v100.l, v38.l, s7
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v35.l, v103.l, v49.l, s10
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v49.l, v103.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v38.l, v14.h, v64.l, s17
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v64, 16, v119
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v38.h, v34.h, v71.l, s24
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v71, 16, v48
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s3, 0, v65
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s4, 0, v66
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v14.h, v86.l, v13.h, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v35.l, v35.l, v80.l, s25
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v80, 16, v49
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v49.l, v37.h, v85.l, s41
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v64
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s9, 0, v71
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v37.h, v96.l, v30.h, s3
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v30.h, v97.l, v32.l, s4
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s20, 0, v67.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s21, 0, v68.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v130.l, v98.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v131.l, v99.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v13.h, v87.l, v38.l, s2
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v35.h, v102.l, v38.h, s9
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v32.h, v32.h, v67.l, s20
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v67, 16, v130
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v33.l, v33.l, v68.l, s21
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v68, 16, v131
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s29, 0, v84.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s8, 0, v70
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s5, 0, v67
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s27, 0, v82.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s6, 0, v68
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v37.l, v37.l, v84.l, s29
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v34.h, v101.l, v34.l, s8
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s28, 0, v83.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s10, 0, v80
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v36.l, v36.l, v82.l, s27
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v49.h, v115.l, v37.l, s14
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s22, 0, v69.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v48.l, v36.h, v83.l, s28
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v36.h, v103.l, v35.l, s10
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v39.h, v113.l, v36.l, s12
; GFX12-TRUE16-NEXT:    v_mov_b16_e64 v132.l, v100.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v33.h, v33.h, v69.l, s22
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s11, 0, v81
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v48.h, v114.l, v48.l, s13
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v69, 16, v132
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s7, 0, v69
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v33.h, v100.l, v33.h, s7
; GFX12-TRUE16-NEXT:    s_wait_loadcnt 0x0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v55, 0xffff0000, v31
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v50.l, v15.h, v31.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v15.l, v15.l, v31.l, s0
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v50.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v15.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v51.l, v31.h, v50.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v54
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v31
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v52
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v31.h, v98.l, v32.h, s5
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v51.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v32.h, v99.l, v33.l, s6
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v54, v54
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v53, 16, v53
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v31.l, v31.l, v15.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v50.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v52, v53
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v15.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v31.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v32.l, v51.l, v50.l, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v38, 16, v52
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v53, 16, v53
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v51.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v32.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v15.h, v32.l, v50.l, s0
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v38, v53
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v38.h, v112.l, v39.l, s11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v52
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v15.h, v15.h, v51.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v33.l, v31.l, v15.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v51.l, v14.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v29
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v50
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v50.l, v30.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v33.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v15.l, v33.l, v15.l, s2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v15.h, v32.l, v15.h, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v117, v117
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v50
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v31.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v29.h, v116.l, v49.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v13.l, v13.l, v29.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v52, v52
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v53
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v51, v50
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v12
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v15.l, v15.l, v31.l, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v29.l, v29.l, v13.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v52
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v31.l, v30.l, v14.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v13.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v50, v50
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v51.l, v29.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v28
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v14.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v31.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v52
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v12.l, v12.l, v28.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v50, v50
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v12.h, v31.l, v14.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v30.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v53
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v52, v51
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v28.l, v28.l, v12.l, s1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v51.l, v12.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v12.h, v12.h, v30.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v50
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v30.l, v29.l, v13.l, s2
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v50.l, v28.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v11
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v15.l, v33.l, v15.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v13.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v14.l, v31.l, v12.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v50
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v52, v52
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v27
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v53.l, v30.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v11.h, v30.l, v13.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v51, v50
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v11.l, v11.l, v27.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v52, v52
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v53
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v29.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v31.l, v28.l, v12.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v12.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v27.l, v27.l, v11.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v50
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v10
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v11.h, v11.h, v29.l, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v10.h, v31.l, v12.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v27.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v51.l, v11.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v50, v50
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v26
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v28.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v31.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v10.l, v10.l, v26.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v50, v50
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v52
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v13.l, v30.l, v11.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v51, v12
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v10.h, v10.h, v28.l, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v12.l, v26.l, v10.l, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v9
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v50
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v26.l, v27.l, v11.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v51.l, v10.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v50.l, v12.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v28, v28
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v25
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v52.l, v26.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v50
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v51
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v9.l, v9.l, v25.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v28, v28
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v9.h, v26.l, v11.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v27.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v52
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v51, v50
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v11.l, v25.l, v9.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v37.l, v31.l, v10.h, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v9.h, v9.h, v27.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v28
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v25.l, v12.l, v10.l, s2
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v27.l, v11.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v28.l, v9.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v10.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v8
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v30.l, v26.l, v9.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v27
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v28
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.h, v25.l, v10.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v50, v50
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v24
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v28.l, v25.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v27, v26
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v12.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v8.l, v24.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v10, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v28
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v10.l, v11.l, v9.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v9.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.h, v8.h, v12.l, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v12.l, v24.l, v8.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v7
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v26
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.h, v10.l, v9.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v26.l, v8.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v12.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v24, v24
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v23
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v27.l, v10.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v26, 16, v26
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v7.l, v23.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v24, v24
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v11.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v27
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v31.l, v25.l, v8.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v26, v9
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v9.l, v23.l, v7.l, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v6
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.h, v7.h, v11.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v24
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v11.l, v12.l, v8.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v24.l, v9.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v25.l, v7.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v23, v23
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v22
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v26.l, v11.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v24
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v25
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v6.l, v22.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v23, v23
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.h, v11.l, v8.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v26
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v25, v24
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v22.l, v6.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v32.l, v10.l, v7.h, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.h, v6.h, v12.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v23
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v10.l, v9.l, v7.l, s2
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v8.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v6.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v7.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v5
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v33.l, v11.l, v6.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v12
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v22
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.h, v10.l, v7.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v21
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v22.l, v10.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v12, v11
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v9.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v5.l, v21.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v22
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v8.l, v6.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v6.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.h, v5.h, v9.l, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v9.l, v21.l, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v4
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.h, v7.l, v6.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v5.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v9.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v21.l, v7.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v11, v11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v20
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v8.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v4.l, v20.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v11, v11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v21
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v34.l, v10.l, v5.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v6
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v20.l, v4.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.h, v4.h, v8.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v11
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v9.l, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v4.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v6.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v10, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v19
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v20.l, v8.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v19.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v10, v10
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.h, v8.l, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v20
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v12, v11
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v19.l, v3.l, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.h, v3.h, v9.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v10
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v3.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v5.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v11, v11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v18
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v9.l, v6.l, v4.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v4.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v18.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v11, v11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v12
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.h, v9.l, v4.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v6.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v35.l, v7.l, v4.h, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v18.l, v2.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v11, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v36.l, v8.l, v2.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.h, v3.h, v6.l, s2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v5.l, v3.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v10, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v17
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v11, v11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v16
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v9.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v4.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v2.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v17.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v10, v10
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v16.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v11, v11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v17.l, v1.l, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v3.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v16.l, v0.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v12, v8
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v1.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v7.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v17.l, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v16.l, v3.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v4.l, v2.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v2.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v17
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v5.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v6.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v12, v11
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v8.l, v2.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v17, v16
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v4.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v5
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v7.l, v1.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v3.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v1.h, v4.l, s1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v8.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v16.l, v2.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v5.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v2.l, v1.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v16, 16, v16
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v7.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v3.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v12
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v16
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v4
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v11
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s3, 0, v10
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v29.l, v5.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v49.l, v2.l, v1.l, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v48.l, v8.l, v1.h, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v39.l, v6.l, v0.h, s2
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v38.l, v9.l, v2.h, s3
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_dual_mov_b32 v0, v29 :: v_dual_mov_b32 v1, v49
; GFX12-TRUE16-NEXT:    v_dual_mov_b32 v2, v48 :: v_dual_mov_b32 v3, v39
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_dual_mov_b32 v4, v38 :: v_dual_mov_b32 v5, v36
; GFX12-TRUE16-NEXT:    v_dual_mov_b32 v6, v35 :: v_dual_mov_b32 v7, v34
; GFX12-TRUE16-NEXT:    v_dual_mov_b32 v8, v33 :: v_dual_mov_b32 v9, v32
; GFX12-TRUE16-NEXT:    v_dual_mov_b32 v10, v31 :: v_dual_mov_b32 v11, v30
; GFX12-TRUE16-NEXT:    v_mov_b32_e32 v12, v37
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_v32bf16:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v71, 16, v25
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v50, 0xffff0000, v12
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v51, 16, v28
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v12
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v39, 16, v29
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v48, 16, v13
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e64 s1, v50, v50
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v35, 16, v30
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v36, 16, v14
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v83, 16, v24
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v70, 0xffff0000, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e64 v52, v52, v51, s1
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v38, 0xffff0000, v13
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v80, 16, v9
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v103, 16, v21
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v82, 0xffff0000, v8
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v84, 16, v8
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e64 s0, v38, v38
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v87, 16, v23
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v86, 0xffff0000, v7
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v96, 16, v7
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v99, 16, v22
; GFX12-FAKE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e64 v48, v48, v39, s0
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v34, 0xffff0000, v14
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v98, 0xffff0000, v6
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v100, 16, v6
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v115, 16, v20
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v102, 0xffff0000, v5
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v34, v34
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v37, 0xffff0000, v30
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v112, 16, v5
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v119, 16, v19
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v114, 0xffff0000, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v36, v36, v35, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v70, v70
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v49, 0xffff0000, v29
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v116, 16, v4
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v131, 16, v18
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v118, 0xffff0000, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v70, v80, v71, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v82, v82
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v53, 0xffff0000, v28
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v128, 16, v3
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v130, 0xffff0000, v2
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v132, 16, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v80, v84, v83, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v86, v86
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v69, 0xffff0000, v26
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v135, 16, v17
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v134, 0xffff0000, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v55, 16, v27
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v82, v96, v87, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v98, v98
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v81, 0xffff0000, v25
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v54, 0xffff0000, v11
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v144, 16, v1
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v146, 0xffff0000, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v84, v100, v99, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v102, v102
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v85, 0xffff0000, v24
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v147, 16, v16
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v34, 16, v0
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e64 s2, v54, v54
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v86, v112, v103, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v114, v114
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v101, 0xffff0000, v22
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v14
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v64, 16, v11
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v67, 16, v26
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v96, v116, v115, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v118, v118
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v113, 0xffff0000, v21
; GFX12-FAKE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e64 v64, v64, v55, s2
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v68, 16, v10
; GFX12-FAKE16-NEXT:    scratch_load_b32 v31, off, s32
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v98, v128, v119, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v130, v130
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v117, 0xffff0000, v20
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v33, 16, v15
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v100, v132, v131, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v134, v134
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v102, v144, v135 :: v_dual_and_b32 v133, 0xffff0000, v18
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v146, v146
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v145, 0xffff0000, v17
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v112, 16, v96
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v34, v34, v147, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v54, v54
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v65, 0xffff0000, v27
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v54, v14, v30 :: v_dual_and_b32 v97, 0xffff0000, v23
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v37, v37
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v32, 0xffff0000, v15
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v129, 0xffff0000, v19
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v35, v35, v36, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v49, v49
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v39, v39, v48, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v53, v53
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v51, v51, v52, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v65, v65
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v116, 16, v100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v55, v55, v64 :: v_dual_lshlrev_b32 v130, 16, v51
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v69, v69
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v66, 0xffff0000, v10
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v128, 16, v34
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e64 s3, v66, v66
; GFX12-FAKE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e64 v68, v68, v67, s3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v67, v67, v68, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v81, v81
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v68
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v81, 16, v80
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v71, v71, v70 :: v_dual_lshlrev_b32 v132, 16, v67
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v85, v85
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v83, v83, v80, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v97, v97
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v66, 16, v30
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v97, 16, v84
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v87, v87, v82 :: v_dual_lshlrev_b32 v134, 16, v83
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v101, v101
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v38, 0xffff0000, v16
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v99, v99, v84, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v113, v113
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v103, v103, v86 :: v_dual_lshlrev_b32 v144, 16, v99
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v117, v117
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v36
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v113, v115, v96, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v129, v129
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v85, 16, v82
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v115, v119, v98 :: v_dual_lshlrev_b32 v146, 16, v113
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v133, v133
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v37, 16, v48
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v117, v131, v100, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v145, v145
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v101, 16, v86
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v119, v135, v102, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v38, v38
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v38, v147, v34 :: v_dual_lshlrev_b32 v49, 16, v52
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v66, v66
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e64 s0, v49, v130
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v66, v30, v54 :: v_dual_lshlrev_b32 v53, 16, v64
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v30, 16, v35
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v14, v30
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v69, 16, v70
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v14, 16, v117
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v130, v35, v36 :: v_dual_lshlrev_b32 v129, 16, v39
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v37, v129
; GFX12-FAKE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e64 v129, v51, v52, s0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v37, v39, v48 :: v_dual_lshlrev_b32 v118, 16, v102
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v131, 16, v55
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v53, v131
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v53, v55, v64 :: v_dual_lshlrev_b32 v50, 16, v15
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v133, 16, v71
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v65, v132
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v65, v67, v68, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v69, v133
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v135, 16, v87
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v69, v71, v70 :: v_dual_lshlrev_b32 v132, 16, v65
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v81, v134
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v81, v83, v80, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v85, v135
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v145, 16, v103
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v85, v87, v82, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v97, v144
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v97, v99, v84 :: v_dual_lshlrev_b32 v114, 16, v98
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v101, v145
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v147, 16, v115
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v101, v103, v86 :: v_dual_lshlrev_b32 v144, 16, v97
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v112, v146
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v112, v113, v96, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v114, v147
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v30, 16, v119
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v49, 16, v38
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v114, v115, v98, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v116, v14
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v116, v117, v100, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v118, v30
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v118, v119, v102, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v128, v49
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v128, v38, v34, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v36
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v14, v130, v36, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v48
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v36, v37, v48, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v52
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v49, v129, v52, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v64
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v52, 16, v129
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v64, v53, v64, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v68
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v68, v65, v68, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v70
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v70, v69, v70, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v80
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v80, v81, v80, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v82
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v82, v85, v82, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v84
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v84, v97, v84, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v86
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v86, v101, v86, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v96
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v96, v112, v96, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v98
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v98, v114, v98 :: v_dual_lshlrev_b32 v131, 16, v53
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v100, v116, v100 :: v_dual_lshlrev_b32 v133, 16, v69
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v35
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v14, v14, v35 :: v_dual_lshlrev_b32 v135, 16, v85
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v102
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v35, v118, v102, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v39
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v36, v36, v39 :: v_dual_lshlrev_b32 v145, 16, v101
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v34
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v34, v128, v34, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v51
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v39, v49, v51, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v55
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v51, 16, v128
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v49, v64, v55, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v67
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v55, v68, v67, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v71
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v64, v70, v71 :: v_dual_lshlrev_b32 v147, 16, v114
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v83
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v67, v80, v83, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v87
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v68, v82, v87, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v99
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v70, v84, v99, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v103
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v71, v86, v103 :: v_dual_lshlrev_b32 v30, 16, v130
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v113
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v48, 16, v37
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v80, v96, v113, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v115
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v82, v98, v115, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v117
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v134, 16, v81
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v83, v100, v117, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v119
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v84, v35, v119, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v38
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v86, v34, v38, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v30
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v14, v130, v14, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v48
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v30, v37, v36, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v52
; GFX12-FAKE16-NEXT:    s_wait_loadcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v52, 16, v31
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v34, v129, v39, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v131
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v35, v53, v49, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v132
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v53, 0xffff0000, v31
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v36, v65, v55, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v133
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v37, v69, v64, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v134
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v38, v81, v67, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v135
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v39, v85, v68, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v144
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v48, v97, v70, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v145
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v49, v101, v71, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v50, v50
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v55, v15, v31, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v32, v32
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v32, 16, v31
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v148, 16, v116
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v55
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v33, v33, v52, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v146, 16, v112
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v50, 16, v33
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v146
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v15, v112, v80, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v53, v53
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v52, v52, v33, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v32, v32
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v102, 16, v118
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v53, v31, v55 :: v_dual_lshlrev_b32 v64, 16, v52
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v147
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v67, 16, v53
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v31, v114, v82, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v148
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v32, v116, v83, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v50, v64
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v64, v52, v33, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v65, v67
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v67, 16, v64
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v65, v53, v55, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v102
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v68, 16, v65
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v50, v118, v84, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v33
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v33, v64, v33, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v55
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v55, v65, v55, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v52
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v33, v33, v52, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v53
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v53, v55, v53, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v67
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v33, v64, v33, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v51
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v52, v128, v86, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v68
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v51, v65, v53, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v53, 16, v66
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v29
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v12
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v13, v13, v29 :: v_dual_lshlrev_b32 v64, 16, v54
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v64, v53
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v53, v66, v54, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v65, v65
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v29, v29, v13, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v28
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v64, 16, v29
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v12, v28, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v54
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v54, v53, v54, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v28, v28, v12, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v66
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v54, v54, v66, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v65, v64
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v64, 16, v53
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v28
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v55, v29, v13 :: v_dual_lshlrev_b32 v66, 16, v12
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v13, v55, v13, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v64
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v53, v53, v54 :: v_dual_lshlrev_b32 v64, 16, v55
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v66, v65
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v65, 16, v27
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_perm_b32 v14, v14, v53, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v54, v28, v12, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v29
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v13, v13, v29, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v11
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v12
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v54, v12, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v29, v29
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v11, v27, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v28
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v12, v28, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v65, v65
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v27, v27, v11 :: v_dual_lshlrev_b32 v28, 16, v54
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v64
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v13, v55, v13, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v28
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v26
; GFX12-FAKE16-NEXT:    v_perm_b32 v13, v30, v13, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v12, v54, v12, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v29, v29
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v11
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v10, v26 :: v_dual_lshlrev_b32 v29, 16, v9
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v27
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v54, v28
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v28, v27, v11, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v55, v55
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v26, v26, v10, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v29, v29
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v25
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v9, v25, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v11
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v11, v28, v11 :: v_dual_lshlrev_b32 v54, 16, v26
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v29, v29
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v25, v25, v9, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v27
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v11, v27, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v28
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v10
; GFX12-FAKE16-NEXT:    v_perm_b32 v12, v34, v12, 0x5040100
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v55, v54
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v54, 16, v25
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v55, 16, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v29, v26, v10, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v27
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v11, v28, v11, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v29
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_perm_b32 v11, v35, v11, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v29, v10, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v55, v54
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v27, v25, v9, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v26
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v10, v26, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v9, v27, v9, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v28
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v23
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v10, v29, v10, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v25
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v9, v25 :: v_dual_lshlrev_b32 v26, 16, v8
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v7
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v26, v26
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v8, v24, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v27
; GFX12-FAKE16-NEXT:    v_perm_b32 v10, v36, v10, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v7, v23 :: v_dual_lshlrev_b32 v26, 16, v24
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v29, 16, v7
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v26, v26
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v24, v24, v8, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v28, v28
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v23, v23, v7 :: v_dual_lshlrev_b32 v26, 16, v24
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v25
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v9, v27, v9 :: v_dual_lshlrev_b32 v28, 16, v23
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v27, 16, v8
; GFX12-FAKE16-NEXT:    v_perm_b32 v9, v37, v9, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v22, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v27, v26
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v26, v24, v8 :: v_dual_lshlrev_b32 v25, 16, v22
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v29, v28
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v27, v23, v7, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v22, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v26, v8, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v27, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v24
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v8, v24, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v23
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v7, v23 :: v_dual_lshlrev_b32 v24, 16, v26
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v22
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v28, 16, v6
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v28, v25
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v27
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v23, v22, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v24
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v26, v8, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v23, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v25
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v21
; GFX12-FAKE16-NEXT:    v_perm_b32 v8, v38, v8, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v27, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v22
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v7, v39, v7, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v22, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v21 :: v_dual_lshlrev_b32 v24, 16, v4
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v23
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v22
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v22, 16, v20
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v23, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v25, v25
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v3
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v21, v21, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v24, v24
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v21
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v20, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v20, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v19, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v20
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v4
; GFX12-FAKE16-NEXT:    v_perm_b32 v6, v48, v6, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v23, v21, v5 :: v_dual_lshlrev_b32 v22, 16, v19
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v22, v22
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v19, v19, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v23, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v3
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v19
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v22, v20, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v21
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v5, v21, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v22, v4 :: v_dual_lshlrev_b32 v21, 16, v23
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v24
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v24, v19, v3, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v21
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v21, 16, v22
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v23, v5, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v20
; GFX12-FAKE16-NEXT:    v_perm_b32 v5, v49, v5, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v4, v20, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v24, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v19
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v19 :: v_dual_lshlrev_b32 v20, 16, v2
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v18
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v2, v18 :: v_dual_lshlrev_b32 v23, 16, v24
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v23
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v24, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v0
; GFX12-FAKE16-NEXT:    v_perm_b32 v3, v31, v3, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v18, v18, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v1
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v17, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v23, v23
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v19, 16, v17
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v24, 16, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v19, v19
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v17, v17, v1 :: v_dual_lshlrev_b32 v20, 16, v16
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v23, 16, v2
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v20, v20
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v16, v16, v0 :: v_dual_lshlrev_b32 v19, 16, v18
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v20, 16, v17
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v23, v19
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v19, v18, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v24, v20
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v20, v17, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v19, v2 :: v_dual_lshlrev_b32 v23, 16, v16
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v25, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v25, v23
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v23, v16, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v20, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v18
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v18, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v23, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v17
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v17, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v17, 16, v20
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v16
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v16, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v17
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v18, 16, v23
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v20, v1 :: v_dual_lshlrev_b32 v16, 16, v19
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v18
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v1, v50, v1, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v23, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v16
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v52, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v19, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v21
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v2, v32, v2, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v22, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_perm_b32 v4, v15, v4, 0x5040100
; GFX12-FAKE16-NEXT:    v_perm_b32 v15, v33, v51, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call <32 x bfloat> @llvm.maximumnum.v32bf16(<32 x bfloat> %x, <32 x bfloat> %y)
  ret <32 x bfloat> %result
}

define bfloat @v_maximumnum_bf16_no_ieee(bfloat %x, bfloat %y) #0 {
; GFX7-LABEL: v_maximumnum_bf16_no_ieee:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_bf16_no_ieee:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v3, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_bf16_no_ieee:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v2, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_bf16_no_ieee:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v2, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v1, 16, v2
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_bf16_no_ieee:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_bf16_no_ieee:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v0.h, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v0.h, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v1.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v1.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v2.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_bf16_no_ieee:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_bf16_no_ieee:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v0.h, v1.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v1, 16, v1
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v0.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v1, v1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v2.l, v0.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v0.h, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v1.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v1.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v3.l, v2.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v2.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_bf16_no_ieee:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v2, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call bfloat @llvm.maximumnum.bf16(bfloat %x, bfloat %y)
  ret bfloat %result
}

define <2 x bfloat> @v_maximumnum_v2bf16_no_ieee(<2 x bfloat> %x, <2 x bfloat> %y) #0 {
; GFX7-LABEL: v_maximumnum_v2bf16_no_ieee:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v3
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_v2bf16_no_ieee:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX8-NEXT:    v_cndmask_b32_sdwa v3, v0, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v2
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v2, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v4, v3, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_v2bf16_no_ieee:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX900-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX900-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX900-NEXT:    v_cndmask_b32_sdwa v3, v0, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v2
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v2, v3, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v4, v3, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX900-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v2, v0, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_v2bf16_no_ieee:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v2, v2
; GFX950-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX950-NEXT:    v_and_b32_e32 v5, 0xffff0000, v1
; GFX950-NEXT:    v_cndmask_b32_sdwa v3, v0, v2, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v4, 16, v3
; GFX950-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v2
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v2, v3, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v4, v3, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v3, v2, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v4
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v4, v2, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v1
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v4, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v1, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v1, 16, v3
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_perm_b32 v0, v2, v0, s0
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v2bf16_no_ieee:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v0
; GFX10-NEXT:    v_and_b32_e32 v3, 0xffff0000, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v2, 16, v1
; GFX10-NEXT:    v_cndmask_b32_sdwa v6, v0, v2, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v3, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v3, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v2, v6, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v7
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v1, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v3, v6, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v5, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v3, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v4, v0, vcc_lo
; GFX10-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_v2bf16_no_ieee:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v3, v3
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v4, v4
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v5, v5
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v0.h, v1.h, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v1.h, v2.l, s1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v0.l, s2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v2.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v3.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v1.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_4) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v4, v6
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v5, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v3.l, v2.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v1.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v4.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v5.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v2.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v3.l, s1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v6
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v0.h, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_v2bf16_no_ieee:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v4, v3 :: v_dual_lshlrev_b32 v5, 16, v0
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v2, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v1, v0 :: v_dual_lshlrev_b32 v4, 16, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v4, v5
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v3, v2 :: v_dual_lshlrev_b32 v7, 16, v1
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v1, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_lshlrev_b32 v7, 16, v5
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_v2bf16_no_ieee:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v3, v3
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v4, v4
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v5, v5
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v0.h, v1.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s0
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v1.h, v2.l, s1
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v0.l, s2
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v2.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v5.l, v0.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v3.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v1.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v5
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v3.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.l
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v4, v6
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s0, v5, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v3.l, v2.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_3) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v1.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v4.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v5.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v2.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v2, 16, v6
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v3.l, s1
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v1.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX12-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_3) | instid1(VALU_DEP_2)
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v6
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v0.h, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v5.l, v0.l, s0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_v2bf16_no_ieee:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v2, 0xffff0000, v0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v3, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v4, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v2, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v4, v3 :: v_dual_lshlrev_b32 v5, 16, v0
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v1
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v5, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v2, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v1, v0 :: v_dual_lshlrev_b32 v4, 16, v2
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v4, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v3, v2 :: v_dual_lshlrev_b32 v7, 16, v1
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v7
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v1, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v2, v4, v2 :: v_dual_lshlrev_b32 v7, 16, v5
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v4, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v1, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call <2 x bfloat> @llvm.maximumnum.v2bf16(<2 x bfloat> %x, <2 x bfloat> %y)
  ret <2 x bfloat> %result
}

define <3 x bfloat> @v_maximumnum_v3bf16_no_ieee(<3 x bfloat> %x, <3 x bfloat> %y) #0 {
; GFX7-LABEL: v_maximumnum_v3bf16_no_ieee:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v5
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v4
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v3
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_v3bf16_no_ieee:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX8-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX8-NEXT:    v_cndmask_b32_sdwa v5, v0, v4, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v3, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_v3bf16_no_ieee:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX900-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX900-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX900-NEXT:    v_cndmask_b32_sdwa v5, v0, v4, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v3, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v4, v0, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_v3bf16_no_ieee:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX950-NEXT:    v_lshrrev_b32_e32 v4, 16, v2
; GFX950-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX950-NEXT:    v_cndmask_b32_sdwa v5, v0, v4, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX950-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v7
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v3
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v3, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v5
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v5, v1, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v5, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_perm_b32 v0, v4, v0, s0
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v3bf16_no_ieee:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v2
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v3
; GFX10-NEXT:    v_cndmask_b32_sdwa v10, v0, v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v5, v10, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX10-NEXT:    v_lshlrev_b32_e32 v5, 16, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX10-NEXT:    v_lshlrev_b32_e32 v7, 16, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v4, v10, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v3, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v5, v10, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v8, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v5, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v4, 16, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v7, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v6, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_perm_b32 v0, v2, v0, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v7, v1, vcc_lo
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_v3bf16_no_ieee:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v3
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v2
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v6, v6
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v8, v8
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v5, v5
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v0.h, v2.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v9, v9
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v2.h, v4.l, s1
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v4.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v1.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v1.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v3.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v8
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v4.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v7, v10
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s3, v9, v11
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v5.l, v4.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v3.l, v1.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v5.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v2.l, v0.l, s3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v4.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v7.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v7.l, v1.l, s2
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v8.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v5.l, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v8.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v4
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v5
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v9
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v0.h, s1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v8.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v7.l, v1.l, s0
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_v3bf16_no_ieee:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v6, v5 :: v_dual_and_b32 v7, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v4 :: v_dual_lshlrev_b32 v6, 16, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v2 :: v_dual_lshlrev_b32 v9, 16, v3
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v8, v10
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v5, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v1 :: v_dual_lshlrev_b32 v10, 16, v6
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v4, v5 :: v_dual_lshlrev_b32 v7, 16, v0
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v10
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v7
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v3, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v6, v1 :: v_dual_lshlrev_b32 v2, 16, v6
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v4, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc_lo
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_v3bf16_no_ieee:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v3
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v2
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v6, v6
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v8, v8
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v5, v5
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v0.h, v2.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v9, v9
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s2
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v2.h, v4.l, s1
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v6.l, v4.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v1.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v1.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v5.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v3.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v2.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v6, v8
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v4.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v7, v10
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v1.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s3, v9, v11
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v5.l, v4.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v3.l, v1.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v5.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v2.l, v0.l, s3
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v4.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v4.l, v6.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v7.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v7.l, v1.l, s2
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v8.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v5.l, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v4, 16, v4
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v3.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v8.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v5, 16, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v4
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s0
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v5
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v9
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v6.l, v0.h, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v8.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v7.l, v1.l, s0
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_v3bf16_no_ieee:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v2
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v0
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v6, v5 :: v_dual_and_b32 v7, 0xffff0000, v2
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v4 :: v_dual_lshlrev_b32 v6, 16, v1
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v8, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v2 :: v_dual_lshlrev_b32 v9, 16, v3
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v2
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v5
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v8, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v5, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v3, v3, v1 :: v_dual_lshlrev_b32 v10, 16, v6
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v4, v5 :: v_dual_lshlrev_b32 v7, 16, v0
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v7, v8
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v7
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v1, v6, v1 :: v_dual_lshlrev_b32 v2, 16, v6
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v7
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v5, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v4, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc_lo
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call <3 x bfloat> @llvm.maximumnum.v3bf16(<3 x bfloat> %x, <3 x bfloat> %y)
  ret <3 x bfloat> %result
}

define <4 x bfloat> @v_maximumnum_v4bf16_no_ieee(<4 x bfloat> %x, <4 x bfloat> %y) #0 {
; GFX7-LABEL: v_maximumnum_v4bf16_no_ieee:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, 1.0, v0
; GFX7-NEXT:    v_mul_f32_e32 v4, 1.0, v4
; GFX7-NEXT:    v_mul_f32_e32 v1, 1.0, v1
; GFX7-NEXT:    v_mul_f32_e32 v5, 1.0, v5
; GFX7-NEXT:    v_mul_f32_e32 v2, 1.0, v2
; GFX7-NEXT:    v_mul_f32_e32 v6, 1.0, v6
; GFX7-NEXT:    v_mul_f32_e32 v3, 1.0, v3
; GFX7-NEXT:    v_mul_f32_e32 v7, 1.0, v7
; GFX7-NEXT:    v_and_b32_e32 v7, 0xffff0000, v7
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    v_and_b32_e32 v6, 0xffff0000, v6
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v5, 0xffff0000, v5
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v4, 0xffff0000, v4
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_max_f32_e32 v3, v3, v7
; GFX7-NEXT:    v_max_f32_e32 v2, v2, v6
; GFX7-NEXT:    v_max_f32_e32 v1, v1, v5
; GFX7-NEXT:    v_max_f32_e32 v0, v0, v4
; GFX7-NEXT:    v_and_b32_e32 v0, 0xffff0000, v0
; GFX7-NEXT:    v_and_b32_e32 v1, 0xffff0000, v1
; GFX7-NEXT:    v_and_b32_e32 v2, 0xffff0000, v2
; GFX7-NEXT:    v_and_b32_e32 v3, 0xffff0000, v3
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_maximumnum_v4bf16_no_ieee:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX8-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX8-NEXT:    v_and_b32_e32 v7, 0xffff0000, v3
; GFX8-NEXT:    v_cndmask_b32_sdwa v5, v1, v4, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v7
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX8-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX8-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX8-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX8-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v7, v6, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v6, v5, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX8-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v8
; GFX8-NEXT:    v_cndmask_b32_e32 v7, v6, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v5, v6, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v7, 16, v1
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v6
; GFX8-NEXT:    v_cndmask_b32_e32 v6, v3, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX8-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX8-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v3
; GFX8-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX8-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX8-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v5
; GFX8-NEXT:    v_or_b32_sdwa v0, v0, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 16, v4
; GFX8-NEXT:    v_or_b32_sdwa v1, v1, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX900-LABEL: v_maximumnum_v4bf16_no_ieee:
; GFX900:       ; %bb.0:
; GFX900-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX900-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX900-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX900-NEXT:    v_and_b32_e32 v7, 0xffff0000, v3
; GFX900-NEXT:    v_cndmask_b32_sdwa v5, v1, v4, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v7
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX900-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX900-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX900-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX900-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v7, v6, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v6, v5, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX900-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v8
; GFX900-NEXT:    v_cndmask_b32_e32 v7, v6, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v5, v6, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v7, 16, v1
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v6
; GFX900-NEXT:    v_cndmask_b32_e32 v6, v3, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX900-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX900-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v3
; GFX900-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX900-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX900-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX900-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX900-NEXT:    s_mov_b32 s4, 0x5040100
; GFX900-NEXT:    v_perm_b32 v0, v5, v0, s4
; GFX900-NEXT:    v_perm_b32 v1, v4, v1, s4
; GFX900-NEXT:    s_setpc_b64 s[30:31]
;
; GFX950-LABEL: v_maximumnum_v4bf16_no_ieee:
; GFX950:       ; %bb.0:
; GFX950-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX950-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v4, v4
; GFX950-NEXT:    v_lshrrev_b32_e32 v4, 16, v3
; GFX950-NEXT:    v_and_b32_e32 v7, 0xffff0000, v3
; GFX950-NEXT:    v_cndmask_b32_sdwa v5, v1, v4, vcc dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v7, v7
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v5
; GFX950-NEXT:    v_and_b32_e32 v8, 0xffff0000, v2
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v4, v5, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v4
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v7
; GFX950-NEXT:    v_lshrrev_b32_e32 v7, 16, v0
; GFX950-NEXT:    s_mov_b32 s0, 0x5040100
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v4, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v6, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v4
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v5, v4, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v5, 16, v6
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v5
; GFX950-NEXT:    v_and_b32_e32 v5, 0xffff0000, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc
; GFX950-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v5, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v7, v6, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v8, v8
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v5
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v6, v5, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v8, 16, v6
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v8
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v7, v6, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v5
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v6
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v5, v6, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v6
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v5, v7, v5, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v6, v6
; GFX950-NEXT:    v_lshlrev_b32_e32 v7, 16, v1
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v3
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v7, v6
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v6, v3, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v1
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v6
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v1, v6, v1, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX950-NEXT:    v_perm_b32 v1, v4, v1, s0
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-NEXT:    v_cmp_u_f32_e32 vcc, v3, v3
; GFX950-NEXT:    v_lshlrev_b32_e32 v6, 16, v0
; GFX950-NEXT:    s_nop 0
; GFX950-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v3, 16, v2
; GFX950-NEXT:    v_cmp_gt_f32_e32 vcc, v6, v3
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v3, v2, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v0
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_cmp_eq_u16_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc
; GFX950-NEXT:    v_lshlrev_b32_e32 v2, 16, v3
; GFX950-NEXT:    v_cmp_eq_f32_e32 vcc, 0, v2
; GFX950-NEXT:    s_nop 1
; GFX950-NEXT:    v_cndmask_b32_e32 v0, v3, v0, vcc
; GFX950-NEXT:    v_perm_b32 v0, v5, v0, s0
; GFX950-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: v_maximumnum_v4bf16_no_ieee:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX10-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX10-NEXT:    v_and_b32_e32 v6, 0xffff0000, v3
; GFX10-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; GFX10-NEXT:    v_lshrrev_b32_e32 v8, 16, v0
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_and_b32_e32 v4, 0xffff0000, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v1
; GFX10-NEXT:    v_lshlrev_b32_e32 v13, 16, v0
; GFX10-NEXT:    v_and_b32_e32 v9, 0xffff0000, v2
; GFX10-NEXT:    v_cndmask_b32_sdwa v10, v1, v5, vcc_lo dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_1 src1_sel:DWORD
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v12, 16, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v5, v10, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX10-NEXT:    v_lshlrev_b32_e32 v14, 16, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v8, v7, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v11, v11
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v8, v14
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v5, v10, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v7, v4, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX10-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v9, v8, v10, vcc_lo
; GFX10-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 16, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v9, v5, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v6
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v3
; GFX10-NEXT:    v_lshlrev_b32_e32 v11, 16, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v6, v7, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v10
; GFX10-NEXT:    v_lshlrev_b32_e32 v10, 16, v2
; GFX10-NEXT:    v_cndmask_b32_e32 v5, v8, v5, vcc_lo
; GFX10-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v8, v9
; GFX10-NEXT:    v_lshlrev_b32_e32 v9, 16, v6
; GFX10-NEXT:    v_cndmask_b32_e32 v8, v3, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v4, v7, vcc_lo
; GFX10-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v10
; GFX10-NEXT:    v_cndmask_b32_e32 v7, v2, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v8, v1, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX10-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_lshlrev_b32_e32 v3, 16, v7
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX10-NEXT:    v_lshlrev_b32_e32 v2, 16, v8
; GFX10-NEXT:    v_cndmask_b32_e32 v4, v6, v4, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX10-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX10-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX10-NEXT:    v_perm_b32 v0, v4, v0, 0x5040100
; GFX10-NEXT:    v_cndmask_b32_e32 v1, v8, v1, vcc_lo
; GFX10-NEXT:    v_perm_b32 v1, v5, v1, 0x5040100
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_maximumnum_v4bf16_no_ieee:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX11-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v5, v5
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v6, v6
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v0
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v8, v8
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v1.h, v3.h, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v0.h, v2.h, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v3
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v3.h, v4.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v4.l
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s4, v10, v10
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s3, v9, v9
; GFX11-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v11, v11
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v5.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v7.l, v2.h, v6.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s4
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v6.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v4.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v1.l, s3
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v0.l, s0
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v10, v8
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v7.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v1.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v0.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v8.l, v5.l, v4.l, s2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v3.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v2.l
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v9, v10
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v12
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v8.l, v4.l, s1
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v15
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v4.l, v7.l, v6.l, s2
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v5.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v8.l
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v11, v12
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v7.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v4.l, v6.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v13
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v14
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v5.l, s0
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v4.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v5.l, v3.l, v1.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v6.l, v2.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v10
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v1.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v2.h, v1.h, v7.l, s2
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v6.l
; GFX11-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v5.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v5.l, v1.l, s1
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v3.l
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX11-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v7
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s1
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, vcc_lo
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX11-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v10
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.h, v8.l, v0.h, s0
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v2.h, s2
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, vcc_lo
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-TRUE16-NEXT:    v_cndmask_b16 v1.l, v5.l, v1.l, s1
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_maximumnum_v4bf16_no_ieee:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v8, 16, v0
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v1
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v6, v5 :: v_dual_and_b32 v7, 0xffff0000, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX11-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; GFX11-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v4
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v5, v4, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v5
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v10, v11
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v5, v4 :: v_dual_and_b32 v9, 0xffff0000, v2
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v8, v7, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v10, v4 :: v_dual_lshlrev_b32 v13, 16, v3
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v7, v6 :: v_dual_lshlrev_b32 v14, 16, v0
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v2
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v4, v5 :: v_dual_lshlrev_b32 v9, 16, v7
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v10
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v0
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v10, v4 :: v_dual_lshlrev_b32 v5, 16, v6
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v9
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v7, v6, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v5, v6, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v8
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v3, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v2
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v10
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v2, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v8, v1, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_4) | instskip(SKIP_1) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX11-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v2 :: v_dual_lshlrev_b32 v3, 16, v7
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX11-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v6 :: v_dual_lshlrev_b32 v2, 16, v8
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_4)
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX11-FAKE16-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX11-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v8, v1, vcc_lo
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x5040100
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-TRUE16-LABEL: v_maximumnum_v4bf16_no_ieee:
; GFX12-TRUE16:       ; %bb.0:
; GFX12-TRUE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_expcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-TRUE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v5, 0xffff0000, v3
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX12-TRUE16-NEXT:    v_and_b32_e32 v7, 0xffff0000, v2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v1
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v5, v5
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s1, v6, v6
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v0
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s2, v8, v8
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v1.h, v3.h, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v0.h, v2.h, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v3
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v2
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v3.h, v4.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v7.l, v4.l
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s4, v10, v10
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s3, v9, v9
; GFX12-TRUE16-NEXT:    v_cmp_u_f32_e64 s0, v11, v11
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v8.l, v5.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v7.l, v2.h, v6.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, s4
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v8
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v6.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v4.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v3.l, v3.l, v1.l, s3
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.l, v2.l, v0.l, s0
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v10, v8
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v7.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v11.l, v1.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v12.l, v0.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v8.l, v5.l, v4.l, s2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v13.l, v3.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v15.l, v2.l
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s2, v9, v10
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v12
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v8.l, v4.l, s1
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v13
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v13, 16, v15
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v4.l, v7.l, v6.l, s2
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s0, 0, v5.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v14.l, v8.l
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e64 s1, v11, v12
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s2, 0, v7.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v4.l, v6.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v13
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v14
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v0.h, v5.l, s0
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v4.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v5.l, v3.l, v1.l, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v6.l, v2.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s0, 0, v10
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v1.l
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v2.h, v1.h, v7.l, s2
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v7, 16, v9
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v9.l, v6.l
; GFX12-TRUE16-NEXT:    v_mov_b16_e32 v10.l, v5.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v5.l, v1.l, s1
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e64 s1, 0, v3.l
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2.l
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v9
; GFX12-TRUE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v10
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s2, 0, v7
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v1.l, v3.l, s1
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v0.l, v2.l, vcc_lo
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX12-TRUE16-NEXT:    v_cmp_eq_f32_e64 s1, 0, v10
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.h, v8.l, v0.h, s0
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.h, v4.l, v2.h, s2
; GFX12-TRUE16-NEXT:    s_wait_alu 0xfffd
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v0.l, v6.l, v0.l, vcc_lo
; GFX12-TRUE16-NEXT:    s_wait_alu 0xf1ff
; GFX12-TRUE16-NEXT:    v_cndmask_b16 v1.l, v5.l, v1.l, s1
; GFX12-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-FAKE16-LABEL: v_maximumnum_v4bf16_no_ieee:
; GFX12-FAKE16:       ; %bb.0:
; GFX12-FAKE16-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_expcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_samplecnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_bvhcnt 0x0
; GFX12-FAKE16-NEXT:    s_wait_kmcnt 0x0
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v4, 0xffff0000, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v5, 16, v3
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v6, 16, v1
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v8, 16, v0
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v12, 16, v1
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v4, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v6, v5 :: v_dual_and_b32 v7, 0xffff0000, v3
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_2) | instid1(VALU_DEP_4)
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v7, v7
; GFX12-FAKE16-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; GFX12-FAKE16-NEXT:    v_and_b32_e32 v6, 0xffff0000, v0
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v5, v4, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v5
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v10, v11
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v10, v5, v4 :: v_dual_and_b32 v9, 0xffff0000, v2
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v6, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v8, v7, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v12, v12
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v4
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v10, v4 :: v_dual_lshlrev_b32 v13, 16, v3
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v9, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v7, v7, v6 :: v_dual_lshlrev_b32 v14, 16, v0
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v5
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v15, 16, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_4) | instid1(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v4, v5 :: v_dual_lshlrev_b32 v9, 16, v7
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v14, v14
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v0, v2, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v10
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v11, 16, v0
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v8
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v4, v10, v4 :: v_dual_lshlrev_b32 v5, 16, v6
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v13, v13
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v3, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v5, v9
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v5, v7, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_u_f32_e32 vcc_lo, v15, v15
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v8, 16, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v2, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v6
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v5, v6, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v9, v8
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v9, 16, v5
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v8, v3, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_lshlrev_b32_e32 v10, 16, v2
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v7
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v6, v6, v7, vcc_lo
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_gt_f32_e32 vcc_lo, v11, v10
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v7, v2, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v1
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v8, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v0
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v1, v3, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_u16_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v0, v0, v2 :: v_dual_lshlrev_b32 v3, 16, v7
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v9
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_dual_cndmask_b32 v5, v5, v6 :: v_dual_lshlrev_b32 v2, 16, v8
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_3) | instskip(SKIP_2) | instid1(VALU_DEP_3)
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v3
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v0, v7, v0, vcc_lo
; GFX12-FAKE16-NEXT:    v_cmp_eq_f32_e32 vcc_lo, 0, v2
; GFX12-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX12-FAKE16-NEXT:    v_perm_b32 v0, v5, v0, 0x5040100
; GFX12-FAKE16-NEXT:    s_wait_alu 0xfffd
; GFX12-FAKE16-NEXT:    v_cndmask_b32_e32 v1, v8, v1, vcc_lo
; GFX12-FAKE16-NEXT:    v_perm_b32 v1, v4, v1, 0x5040100
; GFX12-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %result = call <4 x bfloat> @llvm.maximumnum.v4bf16(<4 x bfloat> %x, <4 x bfloat> %y)
  ret <4 x bfloat> %result
}

attributes #0 = { "amdgpu-ieee"="false" }
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; GFX11: {{.*}}
; GFX12: {{.*}}
; GFX9: {{.*}}
