; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -mtriple amdgcn -passes=amdgpu-promote-alloca-to-vector -S < %s | FileCheck %s

; Skip promote-alloca in case of an index which is known to be out of bounds.

define amdgpu_kernel void @out_of_bounds() {
; CHECK-LABEL: define amdgpu_kernel void @out_of_bounds() {
; CHECK-NEXT:    [[PTR:%.*]] = freeze <4 x float> poison
; CHECK-NEXT:    [[TMP1:%.*]] = shufflevector <4 x float> [[PTR]], <4 x float> poison, <4 x i32> <i32 poison, i32 poison, i32 2, i32 3>
; CHECK-NEXT:    ret void
;
  %ptr = alloca [4 x float], align 4, addrspace(5)
  %elem_ptr = getelementptr [4 x float], ptr addrspace(5) %ptr, i32 0, i32 42
  call void @llvm.memcpy.p5.p5.i32(ptr addrspace(5) %ptr, ptr addrspace(5) %elem_ptr, i32 8, i1 false)
  ret void
}

define amdgpu_kernel void @memcpy_partially_out_of_bounds() {
; CHECK-LABEL: define amdgpu_kernel void @memcpy_partially_out_of_bounds() {
; CHECK-NEXT:    [[PTR:%.*]] = freeze <3 x float> poison
; CHECK-NEXT:    [[TMP1:%.*]] = shufflevector <3 x float> [[PTR]], <3 x float> poison, <3 x i32> <i32 2, i32 poison, i32 2>
; CHECK-NEXT:    ret void
;
  %ptr = alloca [3 x float], align 4, addrspace(5)
  %elem_ptr = getelementptr [3 x float], ptr addrspace(5) %ptr, i32 0, i32 2
  call void @llvm.memcpy.p5.p5.i32(ptr addrspace(5) %ptr, ptr addrspace(5) %elem_ptr, i32 8, i1 false)
  ret void
}

define amdgpu_kernel void @in_bounds() {
; CHECK-LABEL: define amdgpu_kernel void @in_bounds() {
; CHECK-NEXT:    [[PTR:%.*]] = freeze <4 x float> poison
; CHECK-NEXT:    [[TMP1:%.*]] = shufflevector <4 x float> [[PTR]], <4 x float> poison, <4 x i32> <i32 2, i32 3, i32 2, i32 3>
; CHECK-NEXT:    ret void
;
  %ptr = alloca [4 x float], align 4, addrspace(5)
  %elem_ptr = getelementptr [4 x float], ptr addrspace(5) %ptr, i32 0, i32 2
  call void @llvm.memcpy.p5.p5.i32(ptr addrspace(5) %ptr, ptr addrspace(5) %elem_ptr, i32 8, i1 false)
  ret void
}

declare void @llvm.memcpy.p5.p5.i32(ptr addrspace(5) writeonly captures(none), ptr addrspace(5) readonly captures(none), i32, i1 immarg) #0

attributes #0 = { nocallback nofree nounwind willreturn memory(argmem: readwrite) }
