; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv2_sf,+fpuv2_df | FileCheck %s --check-prefix=CHECK-FPUV2
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv3_sf,+fpuv3_df | FileCheck %s --check-prefix=CHECK-FPUV3

define void @test_load_store(ptr %p, ptr %q) nounwind {
; CHECK-FPUV2-LABEL: test_load_store:
; CHECK-FPUV2:       # %bb.0:
; CHECK-FPUV2-NEXT:    ld16.h a0, (a0, 0)
; CHECK-FPUV2-NEXT:    st16.h a0, (a1, 0)
; CHECK-FPUV2-NEXT:    rts16
;
; CHECK-FPUV3-LABEL: test_load_store:
; CHECK-FPUV3:       # %bb.0:
; CHECK-FPUV3-NEXT:    ld16.h a0, (a0, 0)
; CHECK-FPUV3-NEXT:    st16.h a0, (a1, 0)
; CHECK-FPUV3-NEXT:    rts16
  %a = load half, ptr %p
  store half %a, ptr %q
  ret void
}

define float @test_fpextend_float(ptr %p) nounwind {
; CHECK-FPUV2-LABEL: test_fpextend_float:
; CHECK-FPUV2:       # %bb.0:
; CHECK-FPUV2-NEXT:    subi16 sp, sp, 4
; CHECK-FPUV2-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CHECK-FPUV2-NEXT:    ld16.h a0, (a0, 0)
; CHECK-FPUV2-NEXT:    jsri32 [.LCPI1_0]
; CHECK-FPUV2-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CHECK-FPUV2-NEXT:    addi16 sp, sp, 4
; CHECK-FPUV2-NEXT:    rts16
; CHECK-FPUV2-NEXT:    .p2align 1
; CHECK-FPUV2-NEXT:  # %bb.1:
; CHECK-FPUV2-NEXT:    .p2align 2, 0x0
; CHECK-FPUV2-NEXT:  .LCPI1_0:
; CHECK-FPUV2-NEXT:    .long __extendhfsf2
;
; CHECK-FPUV3-LABEL: test_fpextend_float:
; CHECK-FPUV3:       # %bb.0:
; CHECK-FPUV3-NEXT:    subi16 sp, sp, 4
; CHECK-FPUV3-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CHECK-FPUV3-NEXT:    ld16.h a0, (a0, 0)
; CHECK-FPUV3-NEXT:    jsri32 [.LCPI1_0]
; CHECK-FPUV3-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CHECK-FPUV3-NEXT:    addi16 sp, sp, 4
; CHECK-FPUV3-NEXT:    rts16
; CHECK-FPUV3-NEXT:    .p2align 1
; CHECK-FPUV3-NEXT:  # %bb.1:
; CHECK-FPUV3-NEXT:    .p2align 2, 0x0
; CHECK-FPUV3-NEXT:  .LCPI1_0:
; CHECK-FPUV3-NEXT:    .long __extendhfsf2
  %a = load half, ptr %p
  %r = fpext half %a to float
  ret float %r
}

define double @test_fpextend_double(ptr %p) nounwind {
; CHECK-FPUV2-LABEL: test_fpextend_double:
; CHECK-FPUV2:       # %bb.0:
; CHECK-FPUV2-NEXT:    subi16 sp, sp, 4
; CHECK-FPUV2-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CHECK-FPUV2-NEXT:    ld16.h a0, (a0, 0)
; CHECK-FPUV2-NEXT:    jsri32 [.LCPI2_0]
; CHECK-FPUV2-NEXT:    fstod vr0, vr0
; CHECK-FPUV2-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CHECK-FPUV2-NEXT:    addi16 sp, sp, 4
; CHECK-FPUV2-NEXT:    rts16
; CHECK-FPUV2-NEXT:    .p2align 1
; CHECK-FPUV2-NEXT:  # %bb.1:
; CHECK-FPUV2-NEXT:    .p2align 2, 0x0
; CHECK-FPUV2-NEXT:  .LCPI2_0:
; CHECK-FPUV2-NEXT:    .long __extendhfsf2
;
; CHECK-FPUV3-LABEL: test_fpextend_double:
; CHECK-FPUV3:       # %bb.0:
; CHECK-FPUV3-NEXT:    subi16 sp, sp, 4
; CHECK-FPUV3-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CHECK-FPUV3-NEXT:    ld16.h a0, (a0, 0)
; CHECK-FPUV3-NEXT:    jsri32 [.LCPI2_0]
; CHECK-FPUV3-NEXT:    fstod vr0, vr0
; CHECK-FPUV3-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CHECK-FPUV3-NEXT:    addi16 sp, sp, 4
; CHECK-FPUV3-NEXT:    rts16
; CHECK-FPUV3-NEXT:    .p2align 1
; CHECK-FPUV3-NEXT:  # %bb.1:
; CHECK-FPUV3-NEXT:    .p2align 2, 0x0
; CHECK-FPUV3-NEXT:  .LCPI2_0:
; CHECK-FPUV3-NEXT:    .long __extendhfsf2
  %a = load half, ptr %p
  %r = fpext half %a to double
  ret double %r
}

define void @test_fptrunc_float(float %f, ptr %p) nounwind {
; CHECK-FPUV2-LABEL: test_fptrunc_float:
; CHECK-FPUV2:       # %bb.0:
; CHECK-FPUV2-NEXT:    subi16 sp, sp, 8
; CHECK-FPUV2-NEXT:    st16.w l0, (sp, 4) # 4-byte Folded Spill
; CHECK-FPUV2-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CHECK-FPUV2-NEXT:    mov16 l0, a0
; CHECK-FPUV2-NEXT:    jsri32 [.LCPI3_0]
; CHECK-FPUV2-NEXT:    st16.h a0, (l0, 0)
; CHECK-FPUV2-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CHECK-FPUV2-NEXT:    ld16.w l0, (sp, 4) # 4-byte Folded Reload
; CHECK-FPUV2-NEXT:    addi16 sp, sp, 8
; CHECK-FPUV2-NEXT:    rts16
; CHECK-FPUV2-NEXT:    .p2align 1
; CHECK-FPUV2-NEXT:  # %bb.1:
; CHECK-FPUV2-NEXT:    .p2align 2, 0x0
; CHECK-FPUV2-NEXT:  .LCPI3_0:
; CHECK-FPUV2-NEXT:    .long __truncsfhf2
;
; CHECK-FPUV3-LABEL: test_fptrunc_float:
; CHECK-FPUV3:       # %bb.0:
; CHECK-FPUV3-NEXT:    subi16 sp, sp, 8
; CHECK-FPUV3-NEXT:    st16.w l0, (sp, 4) # 4-byte Folded Spill
; CHECK-FPUV3-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CHECK-FPUV3-NEXT:    mov16 l0, a0
; CHECK-FPUV3-NEXT:    jsri32 [.LCPI3_0]
; CHECK-FPUV3-NEXT:    st16.h a0, (l0, 0)
; CHECK-FPUV3-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CHECK-FPUV3-NEXT:    ld16.w l0, (sp, 4) # 4-byte Folded Reload
; CHECK-FPUV3-NEXT:    addi16 sp, sp, 8
; CHECK-FPUV3-NEXT:    rts16
; CHECK-FPUV3-NEXT:    .p2align 1
; CHECK-FPUV3-NEXT:  # %bb.1:
; CHECK-FPUV3-NEXT:    .p2align 2, 0x0
; CHECK-FPUV3-NEXT:  .LCPI3_0:
; CHECK-FPUV3-NEXT:    .long __truncsfhf2
  %a = fptrunc float %f to half
  store half %a, ptr %p
  ret void
}

define void @test_fptrunc_double(double %d, ptr %p) nounwind {
; CHECK-FPUV2-LABEL: test_fptrunc_double:
; CHECK-FPUV2:       # %bb.0:
; CHECK-FPUV2-NEXT:    subi16 sp, sp, 8
; CHECK-FPUV2-NEXT:    st16.w l0, (sp, 4) # 4-byte Folded Spill
; CHECK-FPUV2-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CHECK-FPUV2-NEXT:    mov16 l0, a0
; CHECK-FPUV2-NEXT:    jsri32 [.LCPI4_0]
; CHECK-FPUV2-NEXT:    st16.h a0, (l0, 0)
; CHECK-FPUV2-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CHECK-FPUV2-NEXT:    ld16.w l0, (sp, 4) # 4-byte Folded Reload
; CHECK-FPUV2-NEXT:    addi16 sp, sp, 8
; CHECK-FPUV2-NEXT:    rts16
; CHECK-FPUV2-NEXT:    .p2align 1
; CHECK-FPUV2-NEXT:  # %bb.1:
; CHECK-FPUV2-NEXT:    .p2align 2, 0x0
; CHECK-FPUV2-NEXT:  .LCPI4_0:
; CHECK-FPUV2-NEXT:    .long __truncdfhf2
;
; CHECK-FPUV3-LABEL: test_fptrunc_double:
; CHECK-FPUV3:       # %bb.0:
; CHECK-FPUV3-NEXT:    subi16 sp, sp, 8
; CHECK-FPUV3-NEXT:    st16.w l0, (sp, 4) # 4-byte Folded Spill
; CHECK-FPUV3-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CHECK-FPUV3-NEXT:    mov16 l0, a0
; CHECK-FPUV3-NEXT:    jsri32 [.LCPI4_0]
; CHECK-FPUV3-NEXT:    st16.h a0, (l0, 0)
; CHECK-FPUV3-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CHECK-FPUV3-NEXT:    ld16.w l0, (sp, 4) # 4-byte Folded Reload
; CHECK-FPUV3-NEXT:    addi16 sp, sp, 8
; CHECK-FPUV3-NEXT:    rts16
; CHECK-FPUV3-NEXT:    .p2align 1
; CHECK-FPUV3-NEXT:  # %bb.1:
; CHECK-FPUV3-NEXT:    .p2align 2, 0x0
; CHECK-FPUV3-NEXT:  .LCPI4_0:
; CHECK-FPUV3-NEXT:    .long __truncdfhf2
  %a = fptrunc double %d to half
  store half %a, ptr %p
  ret void
}

define void @test_fadd(ptr %p, ptr %q) nounwind {
; CHECK-FPUV2-LABEL: test_fadd:
; CHECK-FPUV2:       # %bb.0:
; CHECK-FPUV2-NEXT:    subi16 sp, sp, 20
; CHECK-FPUV2-NEXT:    fstd vr8, (sp, 12) # 8-byte Folded Spill
; CHECK-FPUV2-NEXT:    st16.w l1, (sp, 8) # 4-byte Folded Spill
; CHECK-FPUV2-NEXT:    st16.w l0, (sp, 4) # 4-byte Folded Spill
; CHECK-FPUV2-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CHECK-FPUV2-NEXT:    mov16 l0, a1
; CHECK-FPUV2-NEXT:    mov16 l1, a0
; CHECK-FPUV2-NEXT:    ld16.h a0, (a0, 0)
; CHECK-FPUV2-NEXT:    jsri32 [.LCPI5_0]
; CHECK-FPUV2-NEXT:    fmovs vr8, vr0
; CHECK-FPUV2-NEXT:    ld16.h a0, (l0, 0)
; CHECK-FPUV2-NEXT:    jsri32 [.LCPI5_0]
; CHECK-FPUV2-NEXT:    fadds vr0, vr8, vr0
; CHECK-FPUV2-NEXT:    jsri32 [.LCPI5_1]
; CHECK-FPUV2-NEXT:    st16.h a0, (l1, 0)
; CHECK-FPUV2-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CHECK-FPUV2-NEXT:    ld16.w l0, (sp, 4) # 4-byte Folded Reload
; CHECK-FPUV2-NEXT:    ld16.w l1, (sp, 8) # 4-byte Folded Reload
; CHECK-FPUV2-NEXT:    fldd vr8, (sp, 12) # 8-byte Folded Reload
; CHECK-FPUV2-NEXT:    addi16 sp, sp, 20
; CHECK-FPUV2-NEXT:    rts16
; CHECK-FPUV2-NEXT:    .p2align 1
; CHECK-FPUV2-NEXT:  # %bb.1:
; CHECK-FPUV2-NEXT:    .p2align 2, 0x0
; CHECK-FPUV2-NEXT:  .LCPI5_0:
; CHECK-FPUV2-NEXT:    .long __extendhfsf2
; CHECK-FPUV2-NEXT:  .LCPI5_1:
; CHECK-FPUV2-NEXT:    .long __truncsfhf2
;
; CHECK-FPUV3-LABEL: test_fadd:
; CHECK-FPUV3:       # %bb.0:
; CHECK-FPUV3-NEXT:    subi16 sp, sp, 20
; CHECK-FPUV3-NEXT:    fst.64 vr8, (sp, 12) # 8-byte Folded Spill
; CHECK-FPUV3-NEXT:    st16.w l1, (sp, 8) # 4-byte Folded Spill
; CHECK-FPUV3-NEXT:    st16.w l0, (sp, 4) # 4-byte Folded Spill
; CHECK-FPUV3-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CHECK-FPUV3-NEXT:    mov16 l0, a1
; CHECK-FPUV3-NEXT:    mov16 l1, a0
; CHECK-FPUV3-NEXT:    ld16.h a0, (a0, 0)
; CHECK-FPUV3-NEXT:    jsri32 [.LCPI5_0]
; CHECK-FPUV3-NEXT:    fmov.32 vr8, vr0
; CHECK-FPUV3-NEXT:    ld16.h a0, (l0, 0)
; CHECK-FPUV3-NEXT:    jsri32 [.LCPI5_0]
; CHECK-FPUV3-NEXT:    fadd.32 vr0, vr8, vr0
; CHECK-FPUV3-NEXT:    jsri32 [.LCPI5_1]
; CHECK-FPUV3-NEXT:    st16.h a0, (l1, 0)
; CHECK-FPUV3-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CHECK-FPUV3-NEXT:    ld16.w l0, (sp, 4) # 4-byte Folded Reload
; CHECK-FPUV3-NEXT:    ld16.w l1, (sp, 8) # 4-byte Folded Reload
; CHECK-FPUV3-NEXT:    fld.64 vr8, (sp, 12) # 8-byte Folded Reload
; CHECK-FPUV3-NEXT:    addi16 sp, sp, 20
; CHECK-FPUV3-NEXT:    rts16
; CHECK-FPUV3-NEXT:    .p2align 1
; CHECK-FPUV3-NEXT:  # %bb.1:
; CHECK-FPUV3-NEXT:    .p2align 2, 0x0
; CHECK-FPUV3-NEXT:  .LCPI5_0:
; CHECK-FPUV3-NEXT:    .long __extendhfsf2
; CHECK-FPUV3-NEXT:  .LCPI5_1:
; CHECK-FPUV3-NEXT:    .long __truncsfhf2
  %a = load half, ptr %p
  %b = load half, ptr %q
  %r = fadd half %a, %b
  store half %r, ptr %p
  ret void
}

define void @test_fmul(ptr %p, ptr %q) nounwind {
; CHECK-FPUV2-LABEL: test_fmul:
; CHECK-FPUV2:       # %bb.0:
; CHECK-FPUV2-NEXT:    subi16 sp, sp, 20
; CHECK-FPUV2-NEXT:    fstd vr8, (sp, 12) # 8-byte Folded Spill
; CHECK-FPUV2-NEXT:    st16.w l1, (sp, 8) # 4-byte Folded Spill
; CHECK-FPUV2-NEXT:    st16.w l0, (sp, 4) # 4-byte Folded Spill
; CHECK-FPUV2-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CHECK-FPUV2-NEXT:    mov16 l0, a1
; CHECK-FPUV2-NEXT:    mov16 l1, a0
; CHECK-FPUV2-NEXT:    ld16.h a0, (a0, 0)
; CHECK-FPUV2-NEXT:    jsri32 [.LCPI6_0]
; CHECK-FPUV2-NEXT:    fmovs vr8, vr0
; CHECK-FPUV2-NEXT:    ld16.h a0, (l0, 0)
; CHECK-FPUV2-NEXT:    jsri32 [.LCPI6_0]
; CHECK-FPUV2-NEXT:    fmuls vr0, vr8, vr0
; CHECK-FPUV2-NEXT:    jsri32 [.LCPI6_1]
; CHECK-FPUV2-NEXT:    st16.h a0, (l1, 0)
; CHECK-FPUV2-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CHECK-FPUV2-NEXT:    ld16.w l0, (sp, 4) # 4-byte Folded Reload
; CHECK-FPUV2-NEXT:    ld16.w l1, (sp, 8) # 4-byte Folded Reload
; CHECK-FPUV2-NEXT:    fldd vr8, (sp, 12) # 8-byte Folded Reload
; CHECK-FPUV2-NEXT:    addi16 sp, sp, 20
; CHECK-FPUV2-NEXT:    rts16
; CHECK-FPUV2-NEXT:    .p2align 1
; CHECK-FPUV2-NEXT:  # %bb.1:
; CHECK-FPUV2-NEXT:    .p2align 2, 0x0
; CHECK-FPUV2-NEXT:  .LCPI6_0:
; CHECK-FPUV2-NEXT:    .long __extendhfsf2
; CHECK-FPUV2-NEXT:  .LCPI6_1:
; CHECK-FPUV2-NEXT:    .long __truncsfhf2
;
; CHECK-FPUV3-LABEL: test_fmul:
; CHECK-FPUV3:       # %bb.0:
; CHECK-FPUV3-NEXT:    subi16 sp, sp, 20
; CHECK-FPUV3-NEXT:    fst.64 vr8, (sp, 12) # 8-byte Folded Spill
; CHECK-FPUV3-NEXT:    st16.w l1, (sp, 8) # 4-byte Folded Spill
; CHECK-FPUV3-NEXT:    st16.w l0, (sp, 4) # 4-byte Folded Spill
; CHECK-FPUV3-NEXT:    st32.w lr, (sp, 0) # 4-byte Folded Spill
; CHECK-FPUV3-NEXT:    mov16 l0, a1
; CHECK-FPUV3-NEXT:    mov16 l1, a0
; CHECK-FPUV3-NEXT:    ld16.h a0, (a0, 0)
; CHECK-FPUV3-NEXT:    jsri32 [.LCPI6_0]
; CHECK-FPUV3-NEXT:    fmov.32 vr8, vr0
; CHECK-FPUV3-NEXT:    ld16.h a0, (l0, 0)
; CHECK-FPUV3-NEXT:    jsri32 [.LCPI6_0]
; CHECK-FPUV3-NEXT:    fmul.32 vr0, vr8, vr0
; CHECK-FPUV3-NEXT:    jsri32 [.LCPI6_1]
; CHECK-FPUV3-NEXT:    st16.h a0, (l1, 0)
; CHECK-FPUV3-NEXT:    ld32.w lr, (sp, 0) # 4-byte Folded Reload
; CHECK-FPUV3-NEXT:    ld16.w l0, (sp, 4) # 4-byte Folded Reload
; CHECK-FPUV3-NEXT:    ld16.w l1, (sp, 8) # 4-byte Folded Reload
; CHECK-FPUV3-NEXT:    fld.64 vr8, (sp, 12) # 8-byte Folded Reload
; CHECK-FPUV3-NEXT:    addi16 sp, sp, 20
; CHECK-FPUV3-NEXT:    rts16
; CHECK-FPUV3-NEXT:    .p2align 1
; CHECK-FPUV3-NEXT:  # %bb.1:
; CHECK-FPUV3-NEXT:    .p2align 2, 0x0
; CHECK-FPUV3-NEXT:  .LCPI6_0:
; CHECK-FPUV3-NEXT:    .long __extendhfsf2
; CHECK-FPUV3-NEXT:  .LCPI6_1:
; CHECK-FPUV3-NEXT:    .long __truncsfhf2
  %a = load half, ptr %p
  %b = load half, ptr %q
  %r = fmul half %a, %b
  store half %r, ptr %p
  ret void
}
