; RUN: llc -mtriple=hexagon < %s | FileCheck %s

; Check the individual vdeal shuffles for all 64 controls.
; Note: for shuffles with a single 2x2 transpose, vshuff is generated instead
; of vdeal. (For such cases vdeal and vshuff are equivalent.)

; This is an identity shuffle: there should not be any shuffling code emitted.
; CHECK-LABEL: vdeal_00:
; CHECK-NOT: vdeal(
define <128 x i8> @vdeal_00(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_01:
; CHECK: [[REG01:r[0-9]+]] = #1
; CHECK: vshuff(v1,v0,[[REG01]])
define <128 x i8> @vdeal_01(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 64, i32 2, i32 66, i32 4, i32 68, i32 6, i32 70, i32 8, i32 72, i32 10, i32 74, i32 12, i32 76, i32 14, i32 78, i32 16, i32 80, i32 18, i32 82, i32 20, i32 84, i32 22, i32 86, i32 24, i32 88, i32 26, i32 90, i32 28, i32 92, i32 30, i32 94, i32 32, i32 96, i32 34, i32 98, i32 36, i32 100, i32 38, i32 102, i32 40, i32 104, i32 42, i32 106, i32 44, i32 108, i32 46, i32 110, i32 48, i32 112, i32 50, i32 114, i32 52, i32 116, i32 54, i32 118, i32 56, i32 120, i32 58, i32 122, i32 60, i32 124, i32 62, i32 126, i32 1, i32 65, i32 3, i32 67, i32 5, i32 69, i32 7, i32 71, i32 9, i32 73, i32 11, i32 75, i32 13, i32 77, i32 15, i32 79, i32 17, i32 81, i32 19, i32 83, i32 21, i32 85, i32 23, i32 87, i32 25, i32 89, i32 27, i32 91, i32 29, i32 93, i32 31, i32 95, i32 33, i32 97, i32 35, i32 99, i32 37, i32 101, i32 39, i32 103, i32 41, i32 105, i32 43, i32 107, i32 45, i32 109, i32 47, i32 111, i32 49, i32 113, i32 51, i32 115, i32 53, i32 117, i32 55, i32 119, i32 57, i32 121, i32 59, i32 123, i32 61, i32 125, i32 63, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_02:
; CHECK: [[REG02:r[0-9]+]] = #2
; CHECK: vshuff(v1,v0,[[REG02]])
define <128 x i8> @vdeal_02(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 64, i32 65, i32 4, i32 5, i32 68, i32 69, i32 8, i32 9, i32 72, i32 73, i32 12, i32 13, i32 76, i32 77, i32 16, i32 17, i32 80, i32 81, i32 20, i32 21, i32 84, i32 85, i32 24, i32 25, i32 88, i32 89, i32 28, i32 29, i32 92, i32 93, i32 32, i32 33, i32 96, i32 97, i32 36, i32 37, i32 100, i32 101, i32 40, i32 41, i32 104, i32 105, i32 44, i32 45, i32 108, i32 109, i32 48, i32 49, i32 112, i32 113, i32 52, i32 53, i32 116, i32 117, i32 56, i32 57, i32 120, i32 121, i32 60, i32 61, i32 124, i32 125, i32 2, i32 3, i32 66, i32 67, i32 6, i32 7, i32 70, i32 71, i32 10, i32 11, i32 74, i32 75, i32 14, i32 15, i32 78, i32 79, i32 18, i32 19, i32 82, i32 83, i32 22, i32 23, i32 86, i32 87, i32 26, i32 27, i32 90, i32 91, i32 30, i32 31, i32 94, i32 95, i32 34, i32 35, i32 98, i32 99, i32 38, i32 39, i32 102, i32 103, i32 42, i32 43, i32 106, i32 107, i32 46, i32 47, i32 110, i32 111, i32 50, i32 51, i32 114, i32 115, i32 54, i32 55, i32 118, i32 119, i32 58, i32 59, i32 122, i32 123, i32 62, i32 63, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_03:
; CHECK: [[REG03:r[0-9]+]] = #3
; CHECK: vdeal(v1,v0,[[REG03]])
define <128 x i8> @vdeal_03(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 64, i32 66, i32 4, i32 6, i32 68, i32 70, i32 8, i32 10, i32 72, i32 74, i32 12, i32 14, i32 76, i32 78, i32 16, i32 18, i32 80, i32 82, i32 20, i32 22, i32 84, i32 86, i32 24, i32 26, i32 88, i32 90, i32 28, i32 30, i32 92, i32 94, i32 32, i32 34, i32 96, i32 98, i32 36, i32 38, i32 100, i32 102, i32 40, i32 42, i32 104, i32 106, i32 44, i32 46, i32 108, i32 110, i32 48, i32 50, i32 112, i32 114, i32 52, i32 54, i32 116, i32 118, i32 56, i32 58, i32 120, i32 122, i32 60, i32 62, i32 124, i32 126, i32 1, i32 3, i32 65, i32 67, i32 5, i32 7, i32 69, i32 71, i32 9, i32 11, i32 73, i32 75, i32 13, i32 15, i32 77, i32 79, i32 17, i32 19, i32 81, i32 83, i32 21, i32 23, i32 85, i32 87, i32 25, i32 27, i32 89, i32 91, i32 29, i32 31, i32 93, i32 95, i32 33, i32 35, i32 97, i32 99, i32 37, i32 39, i32 101, i32 103, i32 41, i32 43, i32 105, i32 107, i32 45, i32 47, i32 109, i32 111, i32 49, i32 51, i32 113, i32 115, i32 53, i32 55, i32 117, i32 119, i32 57, i32 59, i32 121, i32 123, i32 61, i32 63, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_04:
; CHECK: [[REG04:r[0-9]+]] = #4
; CHECK: vshuff(v1,v0,[[REG04]])
define <128 x i8> @vdeal_04(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 64, i32 65, i32 66, i32 67, i32 8, i32 9, i32 10, i32 11, i32 72, i32 73, i32 74, i32 75, i32 16, i32 17, i32 18, i32 19, i32 80, i32 81, i32 82, i32 83, i32 24, i32 25, i32 26, i32 27, i32 88, i32 89, i32 90, i32 91, i32 32, i32 33, i32 34, i32 35, i32 96, i32 97, i32 98, i32 99, i32 40, i32 41, i32 42, i32 43, i32 104, i32 105, i32 106, i32 107, i32 48, i32 49, i32 50, i32 51, i32 112, i32 113, i32 114, i32 115, i32 56, i32 57, i32 58, i32 59, i32 120, i32 121, i32 122, i32 123, i32 4, i32 5, i32 6, i32 7, i32 68, i32 69, i32 70, i32 71, i32 12, i32 13, i32 14, i32 15, i32 76, i32 77, i32 78, i32 79, i32 20, i32 21, i32 22, i32 23, i32 84, i32 85, i32 86, i32 87, i32 28, i32 29, i32 30, i32 31, i32 92, i32 93, i32 94, i32 95, i32 36, i32 37, i32 38, i32 39, i32 100, i32 101, i32 102, i32 103, i32 44, i32 45, i32 46, i32 47, i32 108, i32 109, i32 110, i32 111, i32 52, i32 53, i32 54, i32 55, i32 116, i32 117, i32 118, i32 119, i32 60, i32 61, i32 62, i32 63, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_05:
; CHECK: [[REG05:r[0-9]+]] = #5
; CHECK: vdeal(v1,v0,[[REG05]])
define <128 x i8> @vdeal_05(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 4, i32 2, i32 6, i32 64, i32 68, i32 66, i32 70, i32 8, i32 12, i32 10, i32 14, i32 72, i32 76, i32 74, i32 78, i32 16, i32 20, i32 18, i32 22, i32 80, i32 84, i32 82, i32 86, i32 24, i32 28, i32 26, i32 30, i32 88, i32 92, i32 90, i32 94, i32 32, i32 36, i32 34, i32 38, i32 96, i32 100, i32 98, i32 102, i32 40, i32 44, i32 42, i32 46, i32 104, i32 108, i32 106, i32 110, i32 48, i32 52, i32 50, i32 54, i32 112, i32 116, i32 114, i32 118, i32 56, i32 60, i32 58, i32 62, i32 120, i32 124, i32 122, i32 126, i32 1, i32 5, i32 3, i32 7, i32 65, i32 69, i32 67, i32 71, i32 9, i32 13, i32 11, i32 15, i32 73, i32 77, i32 75, i32 79, i32 17, i32 21, i32 19, i32 23, i32 81, i32 85, i32 83, i32 87, i32 25, i32 29, i32 27, i32 31, i32 89, i32 93, i32 91, i32 95, i32 33, i32 37, i32 35, i32 39, i32 97, i32 101, i32 99, i32 103, i32 41, i32 45, i32 43, i32 47, i32 105, i32 109, i32 107, i32 111, i32 49, i32 53, i32 51, i32 55, i32 113, i32 117, i32 115, i32 119, i32 57, i32 61, i32 59, i32 63, i32 121, i32 125, i32 123, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_06:
; CHECK: [[REG06:r[0-9]+]] = #6
; CHECK: vdeal(v1,v0,[[REG06]])
define <128 x i8> @vdeal_06(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 4, i32 5, i32 64, i32 65, i32 68, i32 69, i32 8, i32 9, i32 12, i32 13, i32 72, i32 73, i32 76, i32 77, i32 16, i32 17, i32 20, i32 21, i32 80, i32 81, i32 84, i32 85, i32 24, i32 25, i32 28, i32 29, i32 88, i32 89, i32 92, i32 93, i32 32, i32 33, i32 36, i32 37, i32 96, i32 97, i32 100, i32 101, i32 40, i32 41, i32 44, i32 45, i32 104, i32 105, i32 108, i32 109, i32 48, i32 49, i32 52, i32 53, i32 112, i32 113, i32 116, i32 117, i32 56, i32 57, i32 60, i32 61, i32 120, i32 121, i32 124, i32 125, i32 2, i32 3, i32 6, i32 7, i32 66, i32 67, i32 70, i32 71, i32 10, i32 11, i32 14, i32 15, i32 74, i32 75, i32 78, i32 79, i32 18, i32 19, i32 22, i32 23, i32 82, i32 83, i32 86, i32 87, i32 26, i32 27, i32 30, i32 31, i32 90, i32 91, i32 94, i32 95, i32 34, i32 35, i32 38, i32 39, i32 98, i32 99, i32 102, i32 103, i32 42, i32 43, i32 46, i32 47, i32 106, i32 107, i32 110, i32 111, i32 50, i32 51, i32 54, i32 55, i32 114, i32 115, i32 118, i32 119, i32 58, i32 59, i32 62, i32 63, i32 122, i32 123, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_07:
; CHECK: [[REG07:r[0-9]+]] = #7
; CHECK: vdeal(v1,v0,[[REG07]])
define <128 x i8> @vdeal_07(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 4, i32 6, i32 64, i32 66, i32 68, i32 70, i32 8, i32 10, i32 12, i32 14, i32 72, i32 74, i32 76, i32 78, i32 16, i32 18, i32 20, i32 22, i32 80, i32 82, i32 84, i32 86, i32 24, i32 26, i32 28, i32 30, i32 88, i32 90, i32 92, i32 94, i32 32, i32 34, i32 36, i32 38, i32 96, i32 98, i32 100, i32 102, i32 40, i32 42, i32 44, i32 46, i32 104, i32 106, i32 108, i32 110, i32 48, i32 50, i32 52, i32 54, i32 112, i32 114, i32 116, i32 118, i32 56, i32 58, i32 60, i32 62, i32 120, i32 122, i32 124, i32 126, i32 1, i32 3, i32 5, i32 7, i32 65, i32 67, i32 69, i32 71, i32 9, i32 11, i32 13, i32 15, i32 73, i32 75, i32 77, i32 79, i32 17, i32 19, i32 21, i32 23, i32 81, i32 83, i32 85, i32 87, i32 25, i32 27, i32 29, i32 31, i32 89, i32 91, i32 93, i32 95, i32 33, i32 35, i32 37, i32 39, i32 97, i32 99, i32 101, i32 103, i32 41, i32 43, i32 45, i32 47, i32 105, i32 107, i32 109, i32 111, i32 49, i32 51, i32 53, i32 55, i32 113, i32 115, i32 117, i32 119, i32 57, i32 59, i32 61, i32 63, i32 121, i32 123, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_08:
; CHECK: [[REG08:r[0-9]+]] = #8
; CHECK: vshuff(v1,v0,[[REG08]])
define <128 x i8> @vdeal_08(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_09:
; CHECK: [[REG09:r[0-9]+]] = #9
; CHECK: vdeal(v1,v0,[[REG09]])
define <128 x i8> @vdeal_09(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14, i32 64, i32 72, i32 66, i32 74, i32 68, i32 76, i32 70, i32 78, i32 16, i32 24, i32 18, i32 26, i32 20, i32 28, i32 22, i32 30, i32 80, i32 88, i32 82, i32 90, i32 84, i32 92, i32 86, i32 94, i32 32, i32 40, i32 34, i32 42, i32 36, i32 44, i32 38, i32 46, i32 96, i32 104, i32 98, i32 106, i32 100, i32 108, i32 102, i32 110, i32 48, i32 56, i32 50, i32 58, i32 52, i32 60, i32 54, i32 62, i32 112, i32 120, i32 114, i32 122, i32 116, i32 124, i32 118, i32 126, i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15, i32 65, i32 73, i32 67, i32 75, i32 69, i32 77, i32 71, i32 79, i32 17, i32 25, i32 19, i32 27, i32 21, i32 29, i32 23, i32 31, i32 81, i32 89, i32 83, i32 91, i32 85, i32 93, i32 87, i32 95, i32 33, i32 41, i32 35, i32 43, i32 37, i32 45, i32 39, i32 47, i32 97, i32 105, i32 99, i32 107, i32 101, i32 109, i32 103, i32 111, i32 49, i32 57, i32 51, i32 59, i32 53, i32 61, i32 55, i32 63, i32 113, i32 121, i32 115, i32 123, i32 117, i32 125, i32 119, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_0a:
; CHECK: [[REG0a:r[0-9]+]] = #10
; CHECK: vdeal(v1,v0,[[REG0a]])
define <128 x i8> @vdeal_0a(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 12, i32 13, i32 64, i32 65, i32 72, i32 73, i32 68, i32 69, i32 76, i32 77, i32 16, i32 17, i32 24, i32 25, i32 20, i32 21, i32 28, i32 29, i32 80, i32 81, i32 88, i32 89, i32 84, i32 85, i32 92, i32 93, i32 32, i32 33, i32 40, i32 41, i32 36, i32 37, i32 44, i32 45, i32 96, i32 97, i32 104, i32 105, i32 100, i32 101, i32 108, i32 109, i32 48, i32 49, i32 56, i32 57, i32 52, i32 53, i32 60, i32 61, i32 112, i32 113, i32 120, i32 121, i32 116, i32 117, i32 124, i32 125, i32 2, i32 3, i32 10, i32 11, i32 6, i32 7, i32 14, i32 15, i32 66, i32 67, i32 74, i32 75, i32 70, i32 71, i32 78, i32 79, i32 18, i32 19, i32 26, i32 27, i32 22, i32 23, i32 30, i32 31, i32 82, i32 83, i32 90, i32 91, i32 86, i32 87, i32 94, i32 95, i32 34, i32 35, i32 42, i32 43, i32 38, i32 39, i32 46, i32 47, i32 98, i32 99, i32 106, i32 107, i32 102, i32 103, i32 110, i32 111, i32 50, i32 51, i32 58, i32 59, i32 54, i32 55, i32 62, i32 63, i32 114, i32 115, i32 122, i32 123, i32 118, i32 119, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_0b:
; CHECK: [[REG0b:r[0-9]+]] = #11
; CHECK: vdeal(v1,v0,[[REG0b]])
define <128 x i8> @vdeal_0b(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 8, i32 10, i32 4, i32 6, i32 12, i32 14, i32 64, i32 66, i32 72, i32 74, i32 68, i32 70, i32 76, i32 78, i32 16, i32 18, i32 24, i32 26, i32 20, i32 22, i32 28, i32 30, i32 80, i32 82, i32 88, i32 90, i32 84, i32 86, i32 92, i32 94, i32 32, i32 34, i32 40, i32 42, i32 36, i32 38, i32 44, i32 46, i32 96, i32 98, i32 104, i32 106, i32 100, i32 102, i32 108, i32 110, i32 48, i32 50, i32 56, i32 58, i32 52, i32 54, i32 60, i32 62, i32 112, i32 114, i32 120, i32 122, i32 116, i32 118, i32 124, i32 126, i32 1, i32 3, i32 9, i32 11, i32 5, i32 7, i32 13, i32 15, i32 65, i32 67, i32 73, i32 75, i32 69, i32 71, i32 77, i32 79, i32 17, i32 19, i32 25, i32 27, i32 21, i32 23, i32 29, i32 31, i32 81, i32 83, i32 89, i32 91, i32 85, i32 87, i32 93, i32 95, i32 33, i32 35, i32 41, i32 43, i32 37, i32 39, i32 45, i32 47, i32 97, i32 99, i32 105, i32 107, i32 101, i32 103, i32 109, i32 111, i32 49, i32 51, i32 57, i32 59, i32 53, i32 55, i32 61, i32 63, i32 113, i32 115, i32 121, i32 123, i32 117, i32 119, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_0c:
; CHECK: [[REG0c:r[0-9]+]] = #12
; CHECK: vdeal(v1,v0,[[REG0c]])
define <128 x i8> @vdeal_0c(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 10, i32 11, i32 64, i32 65, i32 66, i32 67, i32 72, i32 73, i32 74, i32 75, i32 16, i32 17, i32 18, i32 19, i32 24, i32 25, i32 26, i32 27, i32 80, i32 81, i32 82, i32 83, i32 88, i32 89, i32 90, i32 91, i32 32, i32 33, i32 34, i32 35, i32 40, i32 41, i32 42, i32 43, i32 96, i32 97, i32 98, i32 99, i32 104, i32 105, i32 106, i32 107, i32 48, i32 49, i32 50, i32 51, i32 56, i32 57, i32 58, i32 59, i32 112, i32 113, i32 114, i32 115, i32 120, i32 121, i32 122, i32 123, i32 4, i32 5, i32 6, i32 7, i32 12, i32 13, i32 14, i32 15, i32 68, i32 69, i32 70, i32 71, i32 76, i32 77, i32 78, i32 79, i32 20, i32 21, i32 22, i32 23, i32 28, i32 29, i32 30, i32 31, i32 84, i32 85, i32 86, i32 87, i32 92, i32 93, i32 94, i32 95, i32 36, i32 37, i32 38, i32 39, i32 44, i32 45, i32 46, i32 47, i32 100, i32 101, i32 102, i32 103, i32 108, i32 109, i32 110, i32 111, i32 52, i32 53, i32 54, i32 55, i32 60, i32 61, i32 62, i32 63, i32 116, i32 117, i32 118, i32 119, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_0d:
; CHECK: [[REG0d:r[0-9]+]] = #13
; CHECK: vdeal(v1,v0,[[REG0d]])
define <128 x i8> @vdeal_0d(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 4, i32 2, i32 6, i32 8, i32 12, i32 10, i32 14, i32 64, i32 68, i32 66, i32 70, i32 72, i32 76, i32 74, i32 78, i32 16, i32 20, i32 18, i32 22, i32 24, i32 28, i32 26, i32 30, i32 80, i32 84, i32 82, i32 86, i32 88, i32 92, i32 90, i32 94, i32 32, i32 36, i32 34, i32 38, i32 40, i32 44, i32 42, i32 46, i32 96, i32 100, i32 98, i32 102, i32 104, i32 108, i32 106, i32 110, i32 48, i32 52, i32 50, i32 54, i32 56, i32 60, i32 58, i32 62, i32 112, i32 116, i32 114, i32 118, i32 120, i32 124, i32 122, i32 126, i32 1, i32 5, i32 3, i32 7, i32 9, i32 13, i32 11, i32 15, i32 65, i32 69, i32 67, i32 71, i32 73, i32 77, i32 75, i32 79, i32 17, i32 21, i32 19, i32 23, i32 25, i32 29, i32 27, i32 31, i32 81, i32 85, i32 83, i32 87, i32 89, i32 93, i32 91, i32 95, i32 33, i32 37, i32 35, i32 39, i32 41, i32 45, i32 43, i32 47, i32 97, i32 101, i32 99, i32 103, i32 105, i32 109, i32 107, i32 111, i32 49, i32 53, i32 51, i32 55, i32 57, i32 61, i32 59, i32 63, i32 113, i32 117, i32 115, i32 119, i32 121, i32 125, i32 123, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_0e:
; CHECK: [[REG0e:r[0-9]+]] = #14
; CHECK: vdeal(v1,v0,[[REG0e]])
define <128 x i8> @vdeal_0e(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 4, i32 5, i32 8, i32 9, i32 12, i32 13, i32 64, i32 65, i32 68, i32 69, i32 72, i32 73, i32 76, i32 77, i32 16, i32 17, i32 20, i32 21, i32 24, i32 25, i32 28, i32 29, i32 80, i32 81, i32 84, i32 85, i32 88, i32 89, i32 92, i32 93, i32 32, i32 33, i32 36, i32 37, i32 40, i32 41, i32 44, i32 45, i32 96, i32 97, i32 100, i32 101, i32 104, i32 105, i32 108, i32 109, i32 48, i32 49, i32 52, i32 53, i32 56, i32 57, i32 60, i32 61, i32 112, i32 113, i32 116, i32 117, i32 120, i32 121, i32 124, i32 125, i32 2, i32 3, i32 6, i32 7, i32 10, i32 11, i32 14, i32 15, i32 66, i32 67, i32 70, i32 71, i32 74, i32 75, i32 78, i32 79, i32 18, i32 19, i32 22, i32 23, i32 26, i32 27, i32 30, i32 31, i32 82, i32 83, i32 86, i32 87, i32 90, i32 91, i32 94, i32 95, i32 34, i32 35, i32 38, i32 39, i32 42, i32 43, i32 46, i32 47, i32 98, i32 99, i32 102, i32 103, i32 106, i32 107, i32 110, i32 111, i32 50, i32 51, i32 54, i32 55, i32 58, i32 59, i32 62, i32 63, i32 114, i32 115, i32 118, i32 119, i32 122, i32 123, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_0f:
; CHECK: [[REG0f:r[0-9]+]] = #15
; CHECK: vdeal(v1,v0,[[REG0f]])
define <128 x i8> @vdeal_0f(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 64, i32 66, i32 68, i32 70, i32 72, i32 74, i32 76, i32 78, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 80, i32 82, i32 84, i32 86, i32 88, i32 90, i32 92, i32 94, i32 32, i32 34, i32 36, i32 38, i32 40, i32 42, i32 44, i32 46, i32 96, i32 98, i32 100, i32 102, i32 104, i32 106, i32 108, i32 110, i32 48, i32 50, i32 52, i32 54, i32 56, i32 58, i32 60, i32 62, i32 112, i32 114, i32 116, i32 118, i32 120, i32 122, i32 124, i32 126, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 65, i32 67, i32 69, i32 71, i32 73, i32 75, i32 77, i32 79, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31, i32 81, i32 83, i32 85, i32 87, i32 89, i32 91, i32 93, i32 95, i32 33, i32 35, i32 37, i32 39, i32 41, i32 43, i32 45, i32 47, i32 97, i32 99, i32 101, i32 103, i32 105, i32 107, i32 109, i32 111, i32 49, i32 51, i32 53, i32 55, i32 57, i32 59, i32 61, i32 63, i32 113, i32 115, i32 117, i32 119, i32 121, i32 123, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_10:
; CHECK: [[REG10:r[0-9]+]] = #16
; CHECK: vshuff(v1,v0,[[REG10]])
define <128 x i8> @vdeal_10(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_11:
; CHECK: [[REG11:r[0-9]+]] = #17
; CHECK: vdeal(v1,v0,[[REG11]])
define <128 x i8> @vdeal_11(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 16, i32 2, i32 18, i32 4, i32 20, i32 6, i32 22, i32 8, i32 24, i32 10, i32 26, i32 12, i32 28, i32 14, i32 30, i32 64, i32 80, i32 66, i32 82, i32 68, i32 84, i32 70, i32 86, i32 72, i32 88, i32 74, i32 90, i32 76, i32 92, i32 78, i32 94, i32 32, i32 48, i32 34, i32 50, i32 36, i32 52, i32 38, i32 54, i32 40, i32 56, i32 42, i32 58, i32 44, i32 60, i32 46, i32 62, i32 96, i32 112, i32 98, i32 114, i32 100, i32 116, i32 102, i32 118, i32 104, i32 120, i32 106, i32 122, i32 108, i32 124, i32 110, i32 126, i32 1, i32 17, i32 3, i32 19, i32 5, i32 21, i32 7, i32 23, i32 9, i32 25, i32 11, i32 27, i32 13, i32 29, i32 15, i32 31, i32 65, i32 81, i32 67, i32 83, i32 69, i32 85, i32 71, i32 87, i32 73, i32 89, i32 75, i32 91, i32 77, i32 93, i32 79, i32 95, i32 33, i32 49, i32 35, i32 51, i32 37, i32 53, i32 39, i32 55, i32 41, i32 57, i32 43, i32 59, i32 45, i32 61, i32 47, i32 63, i32 97, i32 113, i32 99, i32 115, i32 101, i32 117, i32 103, i32 119, i32 105, i32 121, i32 107, i32 123, i32 109, i32 125, i32 111, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_12:
; CHECK: [[REG12:r[0-9]+]] = #18
; CHECK: vdeal(v1,v0,[[REG12]])
define <128 x i8> @vdeal_12(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 16, i32 17, i32 4, i32 5, i32 20, i32 21, i32 8, i32 9, i32 24, i32 25, i32 12, i32 13, i32 28, i32 29, i32 64, i32 65, i32 80, i32 81, i32 68, i32 69, i32 84, i32 85, i32 72, i32 73, i32 88, i32 89, i32 76, i32 77, i32 92, i32 93, i32 32, i32 33, i32 48, i32 49, i32 36, i32 37, i32 52, i32 53, i32 40, i32 41, i32 56, i32 57, i32 44, i32 45, i32 60, i32 61, i32 96, i32 97, i32 112, i32 113, i32 100, i32 101, i32 116, i32 117, i32 104, i32 105, i32 120, i32 121, i32 108, i32 109, i32 124, i32 125, i32 2, i32 3, i32 18, i32 19, i32 6, i32 7, i32 22, i32 23, i32 10, i32 11, i32 26, i32 27, i32 14, i32 15, i32 30, i32 31, i32 66, i32 67, i32 82, i32 83, i32 70, i32 71, i32 86, i32 87, i32 74, i32 75, i32 90, i32 91, i32 78, i32 79, i32 94, i32 95, i32 34, i32 35, i32 50, i32 51, i32 38, i32 39, i32 54, i32 55, i32 42, i32 43, i32 58, i32 59, i32 46, i32 47, i32 62, i32 63, i32 98, i32 99, i32 114, i32 115, i32 102, i32 103, i32 118, i32 119, i32 106, i32 107, i32 122, i32 123, i32 110, i32 111, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_13:
; CHECK: [[REG13:r[0-9]+]] = #19
; CHECK: vdeal(v1,v0,[[REG13]])
define <128 x i8> @vdeal_13(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 16, i32 18, i32 4, i32 6, i32 20, i32 22, i32 8, i32 10, i32 24, i32 26, i32 12, i32 14, i32 28, i32 30, i32 64, i32 66, i32 80, i32 82, i32 68, i32 70, i32 84, i32 86, i32 72, i32 74, i32 88, i32 90, i32 76, i32 78, i32 92, i32 94, i32 32, i32 34, i32 48, i32 50, i32 36, i32 38, i32 52, i32 54, i32 40, i32 42, i32 56, i32 58, i32 44, i32 46, i32 60, i32 62, i32 96, i32 98, i32 112, i32 114, i32 100, i32 102, i32 116, i32 118, i32 104, i32 106, i32 120, i32 122, i32 108, i32 110, i32 124, i32 126, i32 1, i32 3, i32 17, i32 19, i32 5, i32 7, i32 21, i32 23, i32 9, i32 11, i32 25, i32 27, i32 13, i32 15, i32 29, i32 31, i32 65, i32 67, i32 81, i32 83, i32 69, i32 71, i32 85, i32 87, i32 73, i32 75, i32 89, i32 91, i32 77, i32 79, i32 93, i32 95, i32 33, i32 35, i32 49, i32 51, i32 37, i32 39, i32 53, i32 55, i32 41, i32 43, i32 57, i32 59, i32 45, i32 47, i32 61, i32 63, i32 97, i32 99, i32 113, i32 115, i32 101, i32 103, i32 117, i32 119, i32 105, i32 107, i32 121, i32 123, i32 109, i32 111, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_14:
; CHECK: [[REG14:r[0-9]+]] = #20
; CHECK: vdeal(v1,v0,[[REG14]])
define <128 x i8> @vdeal_14(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 16, i32 17, i32 18, i32 19, i32 8, i32 9, i32 10, i32 11, i32 24, i32 25, i32 26, i32 27, i32 64, i32 65, i32 66, i32 67, i32 80, i32 81, i32 82, i32 83, i32 72, i32 73, i32 74, i32 75, i32 88, i32 89, i32 90, i32 91, i32 32, i32 33, i32 34, i32 35, i32 48, i32 49, i32 50, i32 51, i32 40, i32 41, i32 42, i32 43, i32 56, i32 57, i32 58, i32 59, i32 96, i32 97, i32 98, i32 99, i32 112, i32 113, i32 114, i32 115, i32 104, i32 105, i32 106, i32 107, i32 120, i32 121, i32 122, i32 123, i32 4, i32 5, i32 6, i32 7, i32 20, i32 21, i32 22, i32 23, i32 12, i32 13, i32 14, i32 15, i32 28, i32 29, i32 30, i32 31, i32 68, i32 69, i32 70, i32 71, i32 84, i32 85, i32 86, i32 87, i32 76, i32 77, i32 78, i32 79, i32 92, i32 93, i32 94, i32 95, i32 36, i32 37, i32 38, i32 39, i32 52, i32 53, i32 54, i32 55, i32 44, i32 45, i32 46, i32 47, i32 60, i32 61, i32 62, i32 63, i32 100, i32 101, i32 102, i32 103, i32 116, i32 117, i32 118, i32 119, i32 108, i32 109, i32 110, i32 111, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_15:
; CHECK: [[REG15:r[0-9]+]] = #21
; CHECK: vdeal(v1,v0,[[REG15]])
define <128 x i8> @vdeal_15(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 4, i32 2, i32 6, i32 16, i32 20, i32 18, i32 22, i32 8, i32 12, i32 10, i32 14, i32 24, i32 28, i32 26, i32 30, i32 64, i32 68, i32 66, i32 70, i32 80, i32 84, i32 82, i32 86, i32 72, i32 76, i32 74, i32 78, i32 88, i32 92, i32 90, i32 94, i32 32, i32 36, i32 34, i32 38, i32 48, i32 52, i32 50, i32 54, i32 40, i32 44, i32 42, i32 46, i32 56, i32 60, i32 58, i32 62, i32 96, i32 100, i32 98, i32 102, i32 112, i32 116, i32 114, i32 118, i32 104, i32 108, i32 106, i32 110, i32 120, i32 124, i32 122, i32 126, i32 1, i32 5, i32 3, i32 7, i32 17, i32 21, i32 19, i32 23, i32 9, i32 13, i32 11, i32 15, i32 25, i32 29, i32 27, i32 31, i32 65, i32 69, i32 67, i32 71, i32 81, i32 85, i32 83, i32 87, i32 73, i32 77, i32 75, i32 79, i32 89, i32 93, i32 91, i32 95, i32 33, i32 37, i32 35, i32 39, i32 49, i32 53, i32 51, i32 55, i32 41, i32 45, i32 43, i32 47, i32 57, i32 61, i32 59, i32 63, i32 97, i32 101, i32 99, i32 103, i32 113, i32 117, i32 115, i32 119, i32 105, i32 109, i32 107, i32 111, i32 121, i32 125, i32 123, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_16:
; CHECK: [[REG16:r[0-9]+]] = #22
; CHECK: vdeal(v1,v0,[[REG16]])
define <128 x i8> @vdeal_16(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 4, i32 5, i32 16, i32 17, i32 20, i32 21, i32 8, i32 9, i32 12, i32 13, i32 24, i32 25, i32 28, i32 29, i32 64, i32 65, i32 68, i32 69, i32 80, i32 81, i32 84, i32 85, i32 72, i32 73, i32 76, i32 77, i32 88, i32 89, i32 92, i32 93, i32 32, i32 33, i32 36, i32 37, i32 48, i32 49, i32 52, i32 53, i32 40, i32 41, i32 44, i32 45, i32 56, i32 57, i32 60, i32 61, i32 96, i32 97, i32 100, i32 101, i32 112, i32 113, i32 116, i32 117, i32 104, i32 105, i32 108, i32 109, i32 120, i32 121, i32 124, i32 125, i32 2, i32 3, i32 6, i32 7, i32 18, i32 19, i32 22, i32 23, i32 10, i32 11, i32 14, i32 15, i32 26, i32 27, i32 30, i32 31, i32 66, i32 67, i32 70, i32 71, i32 82, i32 83, i32 86, i32 87, i32 74, i32 75, i32 78, i32 79, i32 90, i32 91, i32 94, i32 95, i32 34, i32 35, i32 38, i32 39, i32 50, i32 51, i32 54, i32 55, i32 42, i32 43, i32 46, i32 47, i32 58, i32 59, i32 62, i32 63, i32 98, i32 99, i32 102, i32 103, i32 114, i32 115, i32 118, i32 119, i32 106, i32 107, i32 110, i32 111, i32 122, i32 123, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_17:
; CHECK: [[REG17:r[0-9]+]] = #23
; CHECK: vdeal(v1,v0,[[REG17]])
define <128 x i8> @vdeal_17(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 4, i32 6, i32 16, i32 18, i32 20, i32 22, i32 8, i32 10, i32 12, i32 14, i32 24, i32 26, i32 28, i32 30, i32 64, i32 66, i32 68, i32 70, i32 80, i32 82, i32 84, i32 86, i32 72, i32 74, i32 76, i32 78, i32 88, i32 90, i32 92, i32 94, i32 32, i32 34, i32 36, i32 38, i32 48, i32 50, i32 52, i32 54, i32 40, i32 42, i32 44, i32 46, i32 56, i32 58, i32 60, i32 62, i32 96, i32 98, i32 100, i32 102, i32 112, i32 114, i32 116, i32 118, i32 104, i32 106, i32 108, i32 110, i32 120, i32 122, i32 124, i32 126, i32 1, i32 3, i32 5, i32 7, i32 17, i32 19, i32 21, i32 23, i32 9, i32 11, i32 13, i32 15, i32 25, i32 27, i32 29, i32 31, i32 65, i32 67, i32 69, i32 71, i32 81, i32 83, i32 85, i32 87, i32 73, i32 75, i32 77, i32 79, i32 89, i32 91, i32 93, i32 95, i32 33, i32 35, i32 37, i32 39, i32 49, i32 51, i32 53, i32 55, i32 41, i32 43, i32 45, i32 47, i32 57, i32 59, i32 61, i32 63, i32 97, i32 99, i32 101, i32 103, i32 113, i32 115, i32 117, i32 119, i32 105, i32 107, i32 109, i32 111, i32 121, i32 123, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_18:
; CHECK: [[REG18:r[0-9]+]] = #24
; CHECK: vdeal(v1,v0,[[REG18]])
define <128 x i8> @vdeal_18(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_19:
; CHECK: [[REG19:r[0-9]+]] = #25
; CHECK: vdeal(v1,v0,[[REG19]])
define <128 x i8> @vdeal_19(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14, i32 16, i32 24, i32 18, i32 26, i32 20, i32 28, i32 22, i32 30, i32 64, i32 72, i32 66, i32 74, i32 68, i32 76, i32 70, i32 78, i32 80, i32 88, i32 82, i32 90, i32 84, i32 92, i32 86, i32 94, i32 32, i32 40, i32 34, i32 42, i32 36, i32 44, i32 38, i32 46, i32 48, i32 56, i32 50, i32 58, i32 52, i32 60, i32 54, i32 62, i32 96, i32 104, i32 98, i32 106, i32 100, i32 108, i32 102, i32 110, i32 112, i32 120, i32 114, i32 122, i32 116, i32 124, i32 118, i32 126, i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15, i32 17, i32 25, i32 19, i32 27, i32 21, i32 29, i32 23, i32 31, i32 65, i32 73, i32 67, i32 75, i32 69, i32 77, i32 71, i32 79, i32 81, i32 89, i32 83, i32 91, i32 85, i32 93, i32 87, i32 95, i32 33, i32 41, i32 35, i32 43, i32 37, i32 45, i32 39, i32 47, i32 49, i32 57, i32 51, i32 59, i32 53, i32 61, i32 55, i32 63, i32 97, i32 105, i32 99, i32 107, i32 101, i32 109, i32 103, i32 111, i32 113, i32 121, i32 115, i32 123, i32 117, i32 125, i32 119, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_1a:
; CHECK: [[REG1a:r[0-9]+]] = #26
; CHECK: vdeal(v1,v0,[[REG1a]])
define <128 x i8> @vdeal_1a(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 12, i32 13, i32 16, i32 17, i32 24, i32 25, i32 20, i32 21, i32 28, i32 29, i32 64, i32 65, i32 72, i32 73, i32 68, i32 69, i32 76, i32 77, i32 80, i32 81, i32 88, i32 89, i32 84, i32 85, i32 92, i32 93, i32 32, i32 33, i32 40, i32 41, i32 36, i32 37, i32 44, i32 45, i32 48, i32 49, i32 56, i32 57, i32 52, i32 53, i32 60, i32 61, i32 96, i32 97, i32 104, i32 105, i32 100, i32 101, i32 108, i32 109, i32 112, i32 113, i32 120, i32 121, i32 116, i32 117, i32 124, i32 125, i32 2, i32 3, i32 10, i32 11, i32 6, i32 7, i32 14, i32 15, i32 18, i32 19, i32 26, i32 27, i32 22, i32 23, i32 30, i32 31, i32 66, i32 67, i32 74, i32 75, i32 70, i32 71, i32 78, i32 79, i32 82, i32 83, i32 90, i32 91, i32 86, i32 87, i32 94, i32 95, i32 34, i32 35, i32 42, i32 43, i32 38, i32 39, i32 46, i32 47, i32 50, i32 51, i32 58, i32 59, i32 54, i32 55, i32 62, i32 63, i32 98, i32 99, i32 106, i32 107, i32 102, i32 103, i32 110, i32 111, i32 114, i32 115, i32 122, i32 123, i32 118, i32 119, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_1b:
; CHECK: [[REG1b:r[0-9]+]] = #27
; CHECK: vdeal(v1,v0,[[REG1b]])
define <128 x i8> @vdeal_1b(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 8, i32 10, i32 4, i32 6, i32 12, i32 14, i32 16, i32 18, i32 24, i32 26, i32 20, i32 22, i32 28, i32 30, i32 64, i32 66, i32 72, i32 74, i32 68, i32 70, i32 76, i32 78, i32 80, i32 82, i32 88, i32 90, i32 84, i32 86, i32 92, i32 94, i32 32, i32 34, i32 40, i32 42, i32 36, i32 38, i32 44, i32 46, i32 48, i32 50, i32 56, i32 58, i32 52, i32 54, i32 60, i32 62, i32 96, i32 98, i32 104, i32 106, i32 100, i32 102, i32 108, i32 110, i32 112, i32 114, i32 120, i32 122, i32 116, i32 118, i32 124, i32 126, i32 1, i32 3, i32 9, i32 11, i32 5, i32 7, i32 13, i32 15, i32 17, i32 19, i32 25, i32 27, i32 21, i32 23, i32 29, i32 31, i32 65, i32 67, i32 73, i32 75, i32 69, i32 71, i32 77, i32 79, i32 81, i32 83, i32 89, i32 91, i32 85, i32 87, i32 93, i32 95, i32 33, i32 35, i32 41, i32 43, i32 37, i32 39, i32 45, i32 47, i32 49, i32 51, i32 57, i32 59, i32 53, i32 55, i32 61, i32 63, i32 97, i32 99, i32 105, i32 107, i32 101, i32 103, i32 109, i32 111, i32 113, i32 115, i32 121, i32 123, i32 117, i32 119, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_1c:
; CHECK: [[REG1c:r[0-9]+]] = #28
; CHECK: vdeal(v1,v0,[[REG1c]])
define <128 x i8> @vdeal_1c(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 10, i32 11, i32 16, i32 17, i32 18, i32 19, i32 24, i32 25, i32 26, i32 27, i32 64, i32 65, i32 66, i32 67, i32 72, i32 73, i32 74, i32 75, i32 80, i32 81, i32 82, i32 83, i32 88, i32 89, i32 90, i32 91, i32 32, i32 33, i32 34, i32 35, i32 40, i32 41, i32 42, i32 43, i32 48, i32 49, i32 50, i32 51, i32 56, i32 57, i32 58, i32 59, i32 96, i32 97, i32 98, i32 99, i32 104, i32 105, i32 106, i32 107, i32 112, i32 113, i32 114, i32 115, i32 120, i32 121, i32 122, i32 123, i32 4, i32 5, i32 6, i32 7, i32 12, i32 13, i32 14, i32 15, i32 20, i32 21, i32 22, i32 23, i32 28, i32 29, i32 30, i32 31, i32 68, i32 69, i32 70, i32 71, i32 76, i32 77, i32 78, i32 79, i32 84, i32 85, i32 86, i32 87, i32 92, i32 93, i32 94, i32 95, i32 36, i32 37, i32 38, i32 39, i32 44, i32 45, i32 46, i32 47, i32 52, i32 53, i32 54, i32 55, i32 60, i32 61, i32 62, i32 63, i32 100, i32 101, i32 102, i32 103, i32 108, i32 109, i32 110, i32 111, i32 116, i32 117, i32 118, i32 119, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_1d:
; CHECK: [[REG1d:r[0-9]+]] = #29
; CHECK: vdeal(v1,v0,[[REG1d]])
define <128 x i8> @vdeal_1d(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 4, i32 2, i32 6, i32 8, i32 12, i32 10, i32 14, i32 16, i32 20, i32 18, i32 22, i32 24, i32 28, i32 26, i32 30, i32 64, i32 68, i32 66, i32 70, i32 72, i32 76, i32 74, i32 78, i32 80, i32 84, i32 82, i32 86, i32 88, i32 92, i32 90, i32 94, i32 32, i32 36, i32 34, i32 38, i32 40, i32 44, i32 42, i32 46, i32 48, i32 52, i32 50, i32 54, i32 56, i32 60, i32 58, i32 62, i32 96, i32 100, i32 98, i32 102, i32 104, i32 108, i32 106, i32 110, i32 112, i32 116, i32 114, i32 118, i32 120, i32 124, i32 122, i32 126, i32 1, i32 5, i32 3, i32 7, i32 9, i32 13, i32 11, i32 15, i32 17, i32 21, i32 19, i32 23, i32 25, i32 29, i32 27, i32 31, i32 65, i32 69, i32 67, i32 71, i32 73, i32 77, i32 75, i32 79, i32 81, i32 85, i32 83, i32 87, i32 89, i32 93, i32 91, i32 95, i32 33, i32 37, i32 35, i32 39, i32 41, i32 45, i32 43, i32 47, i32 49, i32 53, i32 51, i32 55, i32 57, i32 61, i32 59, i32 63, i32 97, i32 101, i32 99, i32 103, i32 105, i32 109, i32 107, i32 111, i32 113, i32 117, i32 115, i32 119, i32 121, i32 125, i32 123, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_1e:
; CHECK: [[REG1e:r[0-9]+]] = #30
; CHECK: vdeal(v1,v0,[[REG1e]])
define <128 x i8> @vdeal_1e(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 4, i32 5, i32 8, i32 9, i32 12, i32 13, i32 16, i32 17, i32 20, i32 21, i32 24, i32 25, i32 28, i32 29, i32 64, i32 65, i32 68, i32 69, i32 72, i32 73, i32 76, i32 77, i32 80, i32 81, i32 84, i32 85, i32 88, i32 89, i32 92, i32 93, i32 32, i32 33, i32 36, i32 37, i32 40, i32 41, i32 44, i32 45, i32 48, i32 49, i32 52, i32 53, i32 56, i32 57, i32 60, i32 61, i32 96, i32 97, i32 100, i32 101, i32 104, i32 105, i32 108, i32 109, i32 112, i32 113, i32 116, i32 117, i32 120, i32 121, i32 124, i32 125, i32 2, i32 3, i32 6, i32 7, i32 10, i32 11, i32 14, i32 15, i32 18, i32 19, i32 22, i32 23, i32 26, i32 27, i32 30, i32 31, i32 66, i32 67, i32 70, i32 71, i32 74, i32 75, i32 78, i32 79, i32 82, i32 83, i32 86, i32 87, i32 90, i32 91, i32 94, i32 95, i32 34, i32 35, i32 38, i32 39, i32 42, i32 43, i32 46, i32 47, i32 50, i32 51, i32 54, i32 55, i32 58, i32 59, i32 62, i32 63, i32 98, i32 99, i32 102, i32 103, i32 106, i32 107, i32 110, i32 111, i32 114, i32 115, i32 118, i32 119, i32 122, i32 123, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_1f:
; CHECK: [[REG1f:r[0-9]+]] = #31
; CHECK: vdeal(v1,v0,[[REG1f]])
define <128 x i8> @vdeal_1f(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 64, i32 66, i32 68, i32 70, i32 72, i32 74, i32 76, i32 78, i32 80, i32 82, i32 84, i32 86, i32 88, i32 90, i32 92, i32 94, i32 32, i32 34, i32 36, i32 38, i32 40, i32 42, i32 44, i32 46, i32 48, i32 50, i32 52, i32 54, i32 56, i32 58, i32 60, i32 62, i32 96, i32 98, i32 100, i32 102, i32 104, i32 106, i32 108, i32 110, i32 112, i32 114, i32 116, i32 118, i32 120, i32 122, i32 124, i32 126, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31, i32 65, i32 67, i32 69, i32 71, i32 73, i32 75, i32 77, i32 79, i32 81, i32 83, i32 85, i32 87, i32 89, i32 91, i32 93, i32 95, i32 33, i32 35, i32 37, i32 39, i32 41, i32 43, i32 45, i32 47, i32 49, i32 51, i32 53, i32 55, i32 57, i32 59, i32 61, i32 63, i32 97, i32 99, i32 101, i32 103, i32 105, i32 107, i32 109, i32 111, i32 113, i32 115, i32 117, i32 119, i32 121, i32 123, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_20:
; CHECK: [[REG20:r[0-9]+]] = #32
; CHECK: vshuff(v1,v0,[[REG20]])
define <128 x i8> @vdeal_20(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_21:
; CHECK: [[REG21:r[0-9]+]] = #33
; CHECK: vdeal(v1,v0,[[REG21]])
define <128 x i8> @vdeal_21(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 32, i32 2, i32 34, i32 4, i32 36, i32 6, i32 38, i32 8, i32 40, i32 10, i32 42, i32 12, i32 44, i32 14, i32 46, i32 16, i32 48, i32 18, i32 50, i32 20, i32 52, i32 22, i32 54, i32 24, i32 56, i32 26, i32 58, i32 28, i32 60, i32 30, i32 62, i32 64, i32 96, i32 66, i32 98, i32 68, i32 100, i32 70, i32 102, i32 72, i32 104, i32 74, i32 106, i32 76, i32 108, i32 78, i32 110, i32 80, i32 112, i32 82, i32 114, i32 84, i32 116, i32 86, i32 118, i32 88, i32 120, i32 90, i32 122, i32 92, i32 124, i32 94, i32 126, i32 1, i32 33, i32 3, i32 35, i32 5, i32 37, i32 7, i32 39, i32 9, i32 41, i32 11, i32 43, i32 13, i32 45, i32 15, i32 47, i32 17, i32 49, i32 19, i32 51, i32 21, i32 53, i32 23, i32 55, i32 25, i32 57, i32 27, i32 59, i32 29, i32 61, i32 31, i32 63, i32 65, i32 97, i32 67, i32 99, i32 69, i32 101, i32 71, i32 103, i32 73, i32 105, i32 75, i32 107, i32 77, i32 109, i32 79, i32 111, i32 81, i32 113, i32 83, i32 115, i32 85, i32 117, i32 87, i32 119, i32 89, i32 121, i32 91, i32 123, i32 93, i32 125, i32 95, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_22:
; CHECK: [[REG22:r[0-9]+]] = #34
; CHECK: vdeal(v1,v0,[[REG22]])
define <128 x i8> @vdeal_22(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 32, i32 33, i32 4, i32 5, i32 36, i32 37, i32 8, i32 9, i32 40, i32 41, i32 12, i32 13, i32 44, i32 45, i32 16, i32 17, i32 48, i32 49, i32 20, i32 21, i32 52, i32 53, i32 24, i32 25, i32 56, i32 57, i32 28, i32 29, i32 60, i32 61, i32 64, i32 65, i32 96, i32 97, i32 68, i32 69, i32 100, i32 101, i32 72, i32 73, i32 104, i32 105, i32 76, i32 77, i32 108, i32 109, i32 80, i32 81, i32 112, i32 113, i32 84, i32 85, i32 116, i32 117, i32 88, i32 89, i32 120, i32 121, i32 92, i32 93, i32 124, i32 125, i32 2, i32 3, i32 34, i32 35, i32 6, i32 7, i32 38, i32 39, i32 10, i32 11, i32 42, i32 43, i32 14, i32 15, i32 46, i32 47, i32 18, i32 19, i32 50, i32 51, i32 22, i32 23, i32 54, i32 55, i32 26, i32 27, i32 58, i32 59, i32 30, i32 31, i32 62, i32 63, i32 66, i32 67, i32 98, i32 99, i32 70, i32 71, i32 102, i32 103, i32 74, i32 75, i32 106, i32 107, i32 78, i32 79, i32 110, i32 111, i32 82, i32 83, i32 114, i32 115, i32 86, i32 87, i32 118, i32 119, i32 90, i32 91, i32 122, i32 123, i32 94, i32 95, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_23:
; CHECK: [[REG23:r[0-9]+]] = #35
; CHECK: vdeal(v1,v0,[[REG23]])
define <128 x i8> @vdeal_23(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 32, i32 34, i32 4, i32 6, i32 36, i32 38, i32 8, i32 10, i32 40, i32 42, i32 12, i32 14, i32 44, i32 46, i32 16, i32 18, i32 48, i32 50, i32 20, i32 22, i32 52, i32 54, i32 24, i32 26, i32 56, i32 58, i32 28, i32 30, i32 60, i32 62, i32 64, i32 66, i32 96, i32 98, i32 68, i32 70, i32 100, i32 102, i32 72, i32 74, i32 104, i32 106, i32 76, i32 78, i32 108, i32 110, i32 80, i32 82, i32 112, i32 114, i32 84, i32 86, i32 116, i32 118, i32 88, i32 90, i32 120, i32 122, i32 92, i32 94, i32 124, i32 126, i32 1, i32 3, i32 33, i32 35, i32 5, i32 7, i32 37, i32 39, i32 9, i32 11, i32 41, i32 43, i32 13, i32 15, i32 45, i32 47, i32 17, i32 19, i32 49, i32 51, i32 21, i32 23, i32 53, i32 55, i32 25, i32 27, i32 57, i32 59, i32 29, i32 31, i32 61, i32 63, i32 65, i32 67, i32 97, i32 99, i32 69, i32 71, i32 101, i32 103, i32 73, i32 75, i32 105, i32 107, i32 77, i32 79, i32 109, i32 111, i32 81, i32 83, i32 113, i32 115, i32 85, i32 87, i32 117, i32 119, i32 89, i32 91, i32 121, i32 123, i32 93, i32 95, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_24:
; CHECK: [[REG24:r[0-9]+]] = #36
; CHECK: vdeal(v1,v0,[[REG24]])
define <128 x i8> @vdeal_24(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 32, i32 33, i32 34, i32 35, i32 8, i32 9, i32 10, i32 11, i32 40, i32 41, i32 42, i32 43, i32 16, i32 17, i32 18, i32 19, i32 48, i32 49, i32 50, i32 51, i32 24, i32 25, i32 26, i32 27, i32 56, i32 57, i32 58, i32 59, i32 64, i32 65, i32 66, i32 67, i32 96, i32 97, i32 98, i32 99, i32 72, i32 73, i32 74, i32 75, i32 104, i32 105, i32 106, i32 107, i32 80, i32 81, i32 82, i32 83, i32 112, i32 113, i32 114, i32 115, i32 88, i32 89, i32 90, i32 91, i32 120, i32 121, i32 122, i32 123, i32 4, i32 5, i32 6, i32 7, i32 36, i32 37, i32 38, i32 39, i32 12, i32 13, i32 14, i32 15, i32 44, i32 45, i32 46, i32 47, i32 20, i32 21, i32 22, i32 23, i32 52, i32 53, i32 54, i32 55, i32 28, i32 29, i32 30, i32 31, i32 60, i32 61, i32 62, i32 63, i32 68, i32 69, i32 70, i32 71, i32 100, i32 101, i32 102, i32 103, i32 76, i32 77, i32 78, i32 79, i32 108, i32 109, i32 110, i32 111, i32 84, i32 85, i32 86, i32 87, i32 116, i32 117, i32 118, i32 119, i32 92, i32 93, i32 94, i32 95, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_25:
; CHECK: [[REG25:r[0-9]+]] = #37
; CHECK: vdeal(v1,v0,[[REG25]])
define <128 x i8> @vdeal_25(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 4, i32 2, i32 6, i32 32, i32 36, i32 34, i32 38, i32 8, i32 12, i32 10, i32 14, i32 40, i32 44, i32 42, i32 46, i32 16, i32 20, i32 18, i32 22, i32 48, i32 52, i32 50, i32 54, i32 24, i32 28, i32 26, i32 30, i32 56, i32 60, i32 58, i32 62, i32 64, i32 68, i32 66, i32 70, i32 96, i32 100, i32 98, i32 102, i32 72, i32 76, i32 74, i32 78, i32 104, i32 108, i32 106, i32 110, i32 80, i32 84, i32 82, i32 86, i32 112, i32 116, i32 114, i32 118, i32 88, i32 92, i32 90, i32 94, i32 120, i32 124, i32 122, i32 126, i32 1, i32 5, i32 3, i32 7, i32 33, i32 37, i32 35, i32 39, i32 9, i32 13, i32 11, i32 15, i32 41, i32 45, i32 43, i32 47, i32 17, i32 21, i32 19, i32 23, i32 49, i32 53, i32 51, i32 55, i32 25, i32 29, i32 27, i32 31, i32 57, i32 61, i32 59, i32 63, i32 65, i32 69, i32 67, i32 71, i32 97, i32 101, i32 99, i32 103, i32 73, i32 77, i32 75, i32 79, i32 105, i32 109, i32 107, i32 111, i32 81, i32 85, i32 83, i32 87, i32 113, i32 117, i32 115, i32 119, i32 89, i32 93, i32 91, i32 95, i32 121, i32 125, i32 123, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_26:
; CHECK: [[REG26:r[0-9]+]] = #38
; CHECK: vdeal(v1,v0,[[REG26]])
define <128 x i8> @vdeal_26(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 4, i32 5, i32 32, i32 33, i32 36, i32 37, i32 8, i32 9, i32 12, i32 13, i32 40, i32 41, i32 44, i32 45, i32 16, i32 17, i32 20, i32 21, i32 48, i32 49, i32 52, i32 53, i32 24, i32 25, i32 28, i32 29, i32 56, i32 57, i32 60, i32 61, i32 64, i32 65, i32 68, i32 69, i32 96, i32 97, i32 100, i32 101, i32 72, i32 73, i32 76, i32 77, i32 104, i32 105, i32 108, i32 109, i32 80, i32 81, i32 84, i32 85, i32 112, i32 113, i32 116, i32 117, i32 88, i32 89, i32 92, i32 93, i32 120, i32 121, i32 124, i32 125, i32 2, i32 3, i32 6, i32 7, i32 34, i32 35, i32 38, i32 39, i32 10, i32 11, i32 14, i32 15, i32 42, i32 43, i32 46, i32 47, i32 18, i32 19, i32 22, i32 23, i32 50, i32 51, i32 54, i32 55, i32 26, i32 27, i32 30, i32 31, i32 58, i32 59, i32 62, i32 63, i32 66, i32 67, i32 70, i32 71, i32 98, i32 99, i32 102, i32 103, i32 74, i32 75, i32 78, i32 79, i32 106, i32 107, i32 110, i32 111, i32 82, i32 83, i32 86, i32 87, i32 114, i32 115, i32 118, i32 119, i32 90, i32 91, i32 94, i32 95, i32 122, i32 123, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_27:
; CHECK: [[REG27:r[0-9]+]] = #39
; CHECK: vdeal(v1,v0,[[REG27]])
define <128 x i8> @vdeal_27(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 4, i32 6, i32 32, i32 34, i32 36, i32 38, i32 8, i32 10, i32 12, i32 14, i32 40, i32 42, i32 44, i32 46, i32 16, i32 18, i32 20, i32 22, i32 48, i32 50, i32 52, i32 54, i32 24, i32 26, i32 28, i32 30, i32 56, i32 58, i32 60, i32 62, i32 64, i32 66, i32 68, i32 70, i32 96, i32 98, i32 100, i32 102, i32 72, i32 74, i32 76, i32 78, i32 104, i32 106, i32 108, i32 110, i32 80, i32 82, i32 84, i32 86, i32 112, i32 114, i32 116, i32 118, i32 88, i32 90, i32 92, i32 94, i32 120, i32 122, i32 124, i32 126, i32 1, i32 3, i32 5, i32 7, i32 33, i32 35, i32 37, i32 39, i32 9, i32 11, i32 13, i32 15, i32 41, i32 43, i32 45, i32 47, i32 17, i32 19, i32 21, i32 23, i32 49, i32 51, i32 53, i32 55, i32 25, i32 27, i32 29, i32 31, i32 57, i32 59, i32 61, i32 63, i32 65, i32 67, i32 69, i32 71, i32 97, i32 99, i32 101, i32 103, i32 73, i32 75, i32 77, i32 79, i32 105, i32 107, i32 109, i32 111, i32 81, i32 83, i32 85, i32 87, i32 113, i32 115, i32 117, i32 119, i32 89, i32 91, i32 93, i32 95, i32 121, i32 123, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_28:
; CHECK: [[REG28:r[0-9]+]] = #40
; CHECK: vdeal(v1,v0,[[REG28]])
define <128 x i8> @vdeal_28(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_29:
; CHECK: [[REG29:r[0-9]+]] = #41
; CHECK: vdeal(v1,v0,[[REG29]])
define <128 x i8> @vdeal_29(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14, i32 32, i32 40, i32 34, i32 42, i32 36, i32 44, i32 38, i32 46, i32 16, i32 24, i32 18, i32 26, i32 20, i32 28, i32 22, i32 30, i32 48, i32 56, i32 50, i32 58, i32 52, i32 60, i32 54, i32 62, i32 64, i32 72, i32 66, i32 74, i32 68, i32 76, i32 70, i32 78, i32 96, i32 104, i32 98, i32 106, i32 100, i32 108, i32 102, i32 110, i32 80, i32 88, i32 82, i32 90, i32 84, i32 92, i32 86, i32 94, i32 112, i32 120, i32 114, i32 122, i32 116, i32 124, i32 118, i32 126, i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15, i32 33, i32 41, i32 35, i32 43, i32 37, i32 45, i32 39, i32 47, i32 17, i32 25, i32 19, i32 27, i32 21, i32 29, i32 23, i32 31, i32 49, i32 57, i32 51, i32 59, i32 53, i32 61, i32 55, i32 63, i32 65, i32 73, i32 67, i32 75, i32 69, i32 77, i32 71, i32 79, i32 97, i32 105, i32 99, i32 107, i32 101, i32 109, i32 103, i32 111, i32 81, i32 89, i32 83, i32 91, i32 85, i32 93, i32 87, i32 95, i32 113, i32 121, i32 115, i32 123, i32 117, i32 125, i32 119, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_2a:
; CHECK: [[REG2a:r[0-9]+]] = #42
; CHECK: vdeal(v1,v0,[[REG2a]])
define <128 x i8> @vdeal_2a(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 12, i32 13, i32 32, i32 33, i32 40, i32 41, i32 36, i32 37, i32 44, i32 45, i32 16, i32 17, i32 24, i32 25, i32 20, i32 21, i32 28, i32 29, i32 48, i32 49, i32 56, i32 57, i32 52, i32 53, i32 60, i32 61, i32 64, i32 65, i32 72, i32 73, i32 68, i32 69, i32 76, i32 77, i32 96, i32 97, i32 104, i32 105, i32 100, i32 101, i32 108, i32 109, i32 80, i32 81, i32 88, i32 89, i32 84, i32 85, i32 92, i32 93, i32 112, i32 113, i32 120, i32 121, i32 116, i32 117, i32 124, i32 125, i32 2, i32 3, i32 10, i32 11, i32 6, i32 7, i32 14, i32 15, i32 34, i32 35, i32 42, i32 43, i32 38, i32 39, i32 46, i32 47, i32 18, i32 19, i32 26, i32 27, i32 22, i32 23, i32 30, i32 31, i32 50, i32 51, i32 58, i32 59, i32 54, i32 55, i32 62, i32 63, i32 66, i32 67, i32 74, i32 75, i32 70, i32 71, i32 78, i32 79, i32 98, i32 99, i32 106, i32 107, i32 102, i32 103, i32 110, i32 111, i32 82, i32 83, i32 90, i32 91, i32 86, i32 87, i32 94, i32 95, i32 114, i32 115, i32 122, i32 123, i32 118, i32 119, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_2b:
; CHECK: [[REG2b:r[0-9]+]] = #43
; CHECK: vdeal(v1,v0,[[REG2b]])
define <128 x i8> @vdeal_2b(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 8, i32 10, i32 4, i32 6, i32 12, i32 14, i32 32, i32 34, i32 40, i32 42, i32 36, i32 38, i32 44, i32 46, i32 16, i32 18, i32 24, i32 26, i32 20, i32 22, i32 28, i32 30, i32 48, i32 50, i32 56, i32 58, i32 52, i32 54, i32 60, i32 62, i32 64, i32 66, i32 72, i32 74, i32 68, i32 70, i32 76, i32 78, i32 96, i32 98, i32 104, i32 106, i32 100, i32 102, i32 108, i32 110, i32 80, i32 82, i32 88, i32 90, i32 84, i32 86, i32 92, i32 94, i32 112, i32 114, i32 120, i32 122, i32 116, i32 118, i32 124, i32 126, i32 1, i32 3, i32 9, i32 11, i32 5, i32 7, i32 13, i32 15, i32 33, i32 35, i32 41, i32 43, i32 37, i32 39, i32 45, i32 47, i32 17, i32 19, i32 25, i32 27, i32 21, i32 23, i32 29, i32 31, i32 49, i32 51, i32 57, i32 59, i32 53, i32 55, i32 61, i32 63, i32 65, i32 67, i32 73, i32 75, i32 69, i32 71, i32 77, i32 79, i32 97, i32 99, i32 105, i32 107, i32 101, i32 103, i32 109, i32 111, i32 81, i32 83, i32 89, i32 91, i32 85, i32 87, i32 93, i32 95, i32 113, i32 115, i32 121, i32 123, i32 117, i32 119, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_2c:
; CHECK: [[REG2c:r[0-9]+]] = #44
; CHECK: vdeal(v1,v0,[[REG2c]])
define <128 x i8> @vdeal_2c(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 10, i32 11, i32 32, i32 33, i32 34, i32 35, i32 40, i32 41, i32 42, i32 43, i32 16, i32 17, i32 18, i32 19, i32 24, i32 25, i32 26, i32 27, i32 48, i32 49, i32 50, i32 51, i32 56, i32 57, i32 58, i32 59, i32 64, i32 65, i32 66, i32 67, i32 72, i32 73, i32 74, i32 75, i32 96, i32 97, i32 98, i32 99, i32 104, i32 105, i32 106, i32 107, i32 80, i32 81, i32 82, i32 83, i32 88, i32 89, i32 90, i32 91, i32 112, i32 113, i32 114, i32 115, i32 120, i32 121, i32 122, i32 123, i32 4, i32 5, i32 6, i32 7, i32 12, i32 13, i32 14, i32 15, i32 36, i32 37, i32 38, i32 39, i32 44, i32 45, i32 46, i32 47, i32 20, i32 21, i32 22, i32 23, i32 28, i32 29, i32 30, i32 31, i32 52, i32 53, i32 54, i32 55, i32 60, i32 61, i32 62, i32 63, i32 68, i32 69, i32 70, i32 71, i32 76, i32 77, i32 78, i32 79, i32 100, i32 101, i32 102, i32 103, i32 108, i32 109, i32 110, i32 111, i32 84, i32 85, i32 86, i32 87, i32 92, i32 93, i32 94, i32 95, i32 116, i32 117, i32 118, i32 119, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_2d:
; CHECK: [[REG2d:r[0-9]+]] = #45
; CHECK: vdeal(v1,v0,[[REG2d]])
define <128 x i8> @vdeal_2d(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 4, i32 2, i32 6, i32 8, i32 12, i32 10, i32 14, i32 32, i32 36, i32 34, i32 38, i32 40, i32 44, i32 42, i32 46, i32 16, i32 20, i32 18, i32 22, i32 24, i32 28, i32 26, i32 30, i32 48, i32 52, i32 50, i32 54, i32 56, i32 60, i32 58, i32 62, i32 64, i32 68, i32 66, i32 70, i32 72, i32 76, i32 74, i32 78, i32 96, i32 100, i32 98, i32 102, i32 104, i32 108, i32 106, i32 110, i32 80, i32 84, i32 82, i32 86, i32 88, i32 92, i32 90, i32 94, i32 112, i32 116, i32 114, i32 118, i32 120, i32 124, i32 122, i32 126, i32 1, i32 5, i32 3, i32 7, i32 9, i32 13, i32 11, i32 15, i32 33, i32 37, i32 35, i32 39, i32 41, i32 45, i32 43, i32 47, i32 17, i32 21, i32 19, i32 23, i32 25, i32 29, i32 27, i32 31, i32 49, i32 53, i32 51, i32 55, i32 57, i32 61, i32 59, i32 63, i32 65, i32 69, i32 67, i32 71, i32 73, i32 77, i32 75, i32 79, i32 97, i32 101, i32 99, i32 103, i32 105, i32 109, i32 107, i32 111, i32 81, i32 85, i32 83, i32 87, i32 89, i32 93, i32 91, i32 95, i32 113, i32 117, i32 115, i32 119, i32 121, i32 125, i32 123, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_2e:
; CHECK: [[REG2e:r[0-9]+]] = #46
; CHECK: vdeal(v1,v0,[[REG2e]])
define <128 x i8> @vdeal_2e(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 4, i32 5, i32 8, i32 9, i32 12, i32 13, i32 32, i32 33, i32 36, i32 37, i32 40, i32 41, i32 44, i32 45, i32 16, i32 17, i32 20, i32 21, i32 24, i32 25, i32 28, i32 29, i32 48, i32 49, i32 52, i32 53, i32 56, i32 57, i32 60, i32 61, i32 64, i32 65, i32 68, i32 69, i32 72, i32 73, i32 76, i32 77, i32 96, i32 97, i32 100, i32 101, i32 104, i32 105, i32 108, i32 109, i32 80, i32 81, i32 84, i32 85, i32 88, i32 89, i32 92, i32 93, i32 112, i32 113, i32 116, i32 117, i32 120, i32 121, i32 124, i32 125, i32 2, i32 3, i32 6, i32 7, i32 10, i32 11, i32 14, i32 15, i32 34, i32 35, i32 38, i32 39, i32 42, i32 43, i32 46, i32 47, i32 18, i32 19, i32 22, i32 23, i32 26, i32 27, i32 30, i32 31, i32 50, i32 51, i32 54, i32 55, i32 58, i32 59, i32 62, i32 63, i32 66, i32 67, i32 70, i32 71, i32 74, i32 75, i32 78, i32 79, i32 98, i32 99, i32 102, i32 103, i32 106, i32 107, i32 110, i32 111, i32 82, i32 83, i32 86, i32 87, i32 90, i32 91, i32 94, i32 95, i32 114, i32 115, i32 118, i32 119, i32 122, i32 123, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_2f:
; CHECK: [[REG2f:r[0-9]+]] = #47
; CHECK: vdeal(v1,v0,[[REG2f]])
define <128 x i8> @vdeal_2f(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 32, i32 34, i32 36, i32 38, i32 40, i32 42, i32 44, i32 46, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 48, i32 50, i32 52, i32 54, i32 56, i32 58, i32 60, i32 62, i32 64, i32 66, i32 68, i32 70, i32 72, i32 74, i32 76, i32 78, i32 96, i32 98, i32 100, i32 102, i32 104, i32 106, i32 108, i32 110, i32 80, i32 82, i32 84, i32 86, i32 88, i32 90, i32 92, i32 94, i32 112, i32 114, i32 116, i32 118, i32 120, i32 122, i32 124, i32 126, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 33, i32 35, i32 37, i32 39, i32 41, i32 43, i32 45, i32 47, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31, i32 49, i32 51, i32 53, i32 55, i32 57, i32 59, i32 61, i32 63, i32 65, i32 67, i32 69, i32 71, i32 73, i32 75, i32 77, i32 79, i32 97, i32 99, i32 101, i32 103, i32 105, i32 107, i32 109, i32 111, i32 81, i32 83, i32 85, i32 87, i32 89, i32 91, i32 93, i32 95, i32 113, i32 115, i32 117, i32 119, i32 121, i32 123, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_30:
; CHECK: [[REG30:r[0-9]+]] = #48
; CHECK: vdeal(v1,v0,[[REG30]])
define <128 x i8> @vdeal_30(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_31:
; CHECK: [[REG31:r[0-9]+]] = #49
; CHECK: vdeal(v1,v0,[[REG31]])
define <128 x i8> @vdeal_31(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 16, i32 2, i32 18, i32 4, i32 20, i32 6, i32 22, i32 8, i32 24, i32 10, i32 26, i32 12, i32 28, i32 14, i32 30, i32 32, i32 48, i32 34, i32 50, i32 36, i32 52, i32 38, i32 54, i32 40, i32 56, i32 42, i32 58, i32 44, i32 60, i32 46, i32 62, i32 64, i32 80, i32 66, i32 82, i32 68, i32 84, i32 70, i32 86, i32 72, i32 88, i32 74, i32 90, i32 76, i32 92, i32 78, i32 94, i32 96, i32 112, i32 98, i32 114, i32 100, i32 116, i32 102, i32 118, i32 104, i32 120, i32 106, i32 122, i32 108, i32 124, i32 110, i32 126, i32 1, i32 17, i32 3, i32 19, i32 5, i32 21, i32 7, i32 23, i32 9, i32 25, i32 11, i32 27, i32 13, i32 29, i32 15, i32 31, i32 33, i32 49, i32 35, i32 51, i32 37, i32 53, i32 39, i32 55, i32 41, i32 57, i32 43, i32 59, i32 45, i32 61, i32 47, i32 63, i32 65, i32 81, i32 67, i32 83, i32 69, i32 85, i32 71, i32 87, i32 73, i32 89, i32 75, i32 91, i32 77, i32 93, i32 79, i32 95, i32 97, i32 113, i32 99, i32 115, i32 101, i32 117, i32 103, i32 119, i32 105, i32 121, i32 107, i32 123, i32 109, i32 125, i32 111, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_32:
; CHECK: [[REG32:r[0-9]+]] = #50
; CHECK: vdeal(v1,v0,[[REG32]])
define <128 x i8> @vdeal_32(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 16, i32 17, i32 4, i32 5, i32 20, i32 21, i32 8, i32 9, i32 24, i32 25, i32 12, i32 13, i32 28, i32 29, i32 32, i32 33, i32 48, i32 49, i32 36, i32 37, i32 52, i32 53, i32 40, i32 41, i32 56, i32 57, i32 44, i32 45, i32 60, i32 61, i32 64, i32 65, i32 80, i32 81, i32 68, i32 69, i32 84, i32 85, i32 72, i32 73, i32 88, i32 89, i32 76, i32 77, i32 92, i32 93, i32 96, i32 97, i32 112, i32 113, i32 100, i32 101, i32 116, i32 117, i32 104, i32 105, i32 120, i32 121, i32 108, i32 109, i32 124, i32 125, i32 2, i32 3, i32 18, i32 19, i32 6, i32 7, i32 22, i32 23, i32 10, i32 11, i32 26, i32 27, i32 14, i32 15, i32 30, i32 31, i32 34, i32 35, i32 50, i32 51, i32 38, i32 39, i32 54, i32 55, i32 42, i32 43, i32 58, i32 59, i32 46, i32 47, i32 62, i32 63, i32 66, i32 67, i32 82, i32 83, i32 70, i32 71, i32 86, i32 87, i32 74, i32 75, i32 90, i32 91, i32 78, i32 79, i32 94, i32 95, i32 98, i32 99, i32 114, i32 115, i32 102, i32 103, i32 118, i32 119, i32 106, i32 107, i32 122, i32 123, i32 110, i32 111, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_33:
; CHECK: [[REG33:r[0-9]+]] = #51
; CHECK: vdeal(v1,v0,[[REG33]])
define <128 x i8> @vdeal_33(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 16, i32 18, i32 4, i32 6, i32 20, i32 22, i32 8, i32 10, i32 24, i32 26, i32 12, i32 14, i32 28, i32 30, i32 32, i32 34, i32 48, i32 50, i32 36, i32 38, i32 52, i32 54, i32 40, i32 42, i32 56, i32 58, i32 44, i32 46, i32 60, i32 62, i32 64, i32 66, i32 80, i32 82, i32 68, i32 70, i32 84, i32 86, i32 72, i32 74, i32 88, i32 90, i32 76, i32 78, i32 92, i32 94, i32 96, i32 98, i32 112, i32 114, i32 100, i32 102, i32 116, i32 118, i32 104, i32 106, i32 120, i32 122, i32 108, i32 110, i32 124, i32 126, i32 1, i32 3, i32 17, i32 19, i32 5, i32 7, i32 21, i32 23, i32 9, i32 11, i32 25, i32 27, i32 13, i32 15, i32 29, i32 31, i32 33, i32 35, i32 49, i32 51, i32 37, i32 39, i32 53, i32 55, i32 41, i32 43, i32 57, i32 59, i32 45, i32 47, i32 61, i32 63, i32 65, i32 67, i32 81, i32 83, i32 69, i32 71, i32 85, i32 87, i32 73, i32 75, i32 89, i32 91, i32 77, i32 79, i32 93, i32 95, i32 97, i32 99, i32 113, i32 115, i32 101, i32 103, i32 117, i32 119, i32 105, i32 107, i32 121, i32 123, i32 109, i32 111, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_34:
; CHECK: [[REG34:r[0-9]+]] = #52
; CHECK: vdeal(v1,v0,[[REG34]])
define <128 x i8> @vdeal_34(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 16, i32 17, i32 18, i32 19, i32 8, i32 9, i32 10, i32 11, i32 24, i32 25, i32 26, i32 27, i32 32, i32 33, i32 34, i32 35, i32 48, i32 49, i32 50, i32 51, i32 40, i32 41, i32 42, i32 43, i32 56, i32 57, i32 58, i32 59, i32 64, i32 65, i32 66, i32 67, i32 80, i32 81, i32 82, i32 83, i32 72, i32 73, i32 74, i32 75, i32 88, i32 89, i32 90, i32 91, i32 96, i32 97, i32 98, i32 99, i32 112, i32 113, i32 114, i32 115, i32 104, i32 105, i32 106, i32 107, i32 120, i32 121, i32 122, i32 123, i32 4, i32 5, i32 6, i32 7, i32 20, i32 21, i32 22, i32 23, i32 12, i32 13, i32 14, i32 15, i32 28, i32 29, i32 30, i32 31, i32 36, i32 37, i32 38, i32 39, i32 52, i32 53, i32 54, i32 55, i32 44, i32 45, i32 46, i32 47, i32 60, i32 61, i32 62, i32 63, i32 68, i32 69, i32 70, i32 71, i32 84, i32 85, i32 86, i32 87, i32 76, i32 77, i32 78, i32 79, i32 92, i32 93, i32 94, i32 95, i32 100, i32 101, i32 102, i32 103, i32 116, i32 117, i32 118, i32 119, i32 108, i32 109, i32 110, i32 111, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_35:
; CHECK: [[REG35:r[0-9]+]] = #53
; CHECK: vdeal(v1,v0,[[REG35]])
define <128 x i8> @vdeal_35(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 4, i32 2, i32 6, i32 16, i32 20, i32 18, i32 22, i32 8, i32 12, i32 10, i32 14, i32 24, i32 28, i32 26, i32 30, i32 32, i32 36, i32 34, i32 38, i32 48, i32 52, i32 50, i32 54, i32 40, i32 44, i32 42, i32 46, i32 56, i32 60, i32 58, i32 62, i32 64, i32 68, i32 66, i32 70, i32 80, i32 84, i32 82, i32 86, i32 72, i32 76, i32 74, i32 78, i32 88, i32 92, i32 90, i32 94, i32 96, i32 100, i32 98, i32 102, i32 112, i32 116, i32 114, i32 118, i32 104, i32 108, i32 106, i32 110, i32 120, i32 124, i32 122, i32 126, i32 1, i32 5, i32 3, i32 7, i32 17, i32 21, i32 19, i32 23, i32 9, i32 13, i32 11, i32 15, i32 25, i32 29, i32 27, i32 31, i32 33, i32 37, i32 35, i32 39, i32 49, i32 53, i32 51, i32 55, i32 41, i32 45, i32 43, i32 47, i32 57, i32 61, i32 59, i32 63, i32 65, i32 69, i32 67, i32 71, i32 81, i32 85, i32 83, i32 87, i32 73, i32 77, i32 75, i32 79, i32 89, i32 93, i32 91, i32 95, i32 97, i32 101, i32 99, i32 103, i32 113, i32 117, i32 115, i32 119, i32 105, i32 109, i32 107, i32 111, i32 121, i32 125, i32 123, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_36:
; CHECK: [[REG36:r[0-9]+]] = #54
; CHECK: vdeal(v1,v0,[[REG36]])
define <128 x i8> @vdeal_36(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 4, i32 5, i32 16, i32 17, i32 20, i32 21, i32 8, i32 9, i32 12, i32 13, i32 24, i32 25, i32 28, i32 29, i32 32, i32 33, i32 36, i32 37, i32 48, i32 49, i32 52, i32 53, i32 40, i32 41, i32 44, i32 45, i32 56, i32 57, i32 60, i32 61, i32 64, i32 65, i32 68, i32 69, i32 80, i32 81, i32 84, i32 85, i32 72, i32 73, i32 76, i32 77, i32 88, i32 89, i32 92, i32 93, i32 96, i32 97, i32 100, i32 101, i32 112, i32 113, i32 116, i32 117, i32 104, i32 105, i32 108, i32 109, i32 120, i32 121, i32 124, i32 125, i32 2, i32 3, i32 6, i32 7, i32 18, i32 19, i32 22, i32 23, i32 10, i32 11, i32 14, i32 15, i32 26, i32 27, i32 30, i32 31, i32 34, i32 35, i32 38, i32 39, i32 50, i32 51, i32 54, i32 55, i32 42, i32 43, i32 46, i32 47, i32 58, i32 59, i32 62, i32 63, i32 66, i32 67, i32 70, i32 71, i32 82, i32 83, i32 86, i32 87, i32 74, i32 75, i32 78, i32 79, i32 90, i32 91, i32 94, i32 95, i32 98, i32 99, i32 102, i32 103, i32 114, i32 115, i32 118, i32 119, i32 106, i32 107, i32 110, i32 111, i32 122, i32 123, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_37:
; CHECK: [[REG37:r[0-9]+]] = #55
; CHECK: vdeal(v1,v0,[[REG37]])
define <128 x i8> @vdeal_37(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 4, i32 6, i32 16, i32 18, i32 20, i32 22, i32 8, i32 10, i32 12, i32 14, i32 24, i32 26, i32 28, i32 30, i32 32, i32 34, i32 36, i32 38, i32 48, i32 50, i32 52, i32 54, i32 40, i32 42, i32 44, i32 46, i32 56, i32 58, i32 60, i32 62, i32 64, i32 66, i32 68, i32 70, i32 80, i32 82, i32 84, i32 86, i32 72, i32 74, i32 76, i32 78, i32 88, i32 90, i32 92, i32 94, i32 96, i32 98, i32 100, i32 102, i32 112, i32 114, i32 116, i32 118, i32 104, i32 106, i32 108, i32 110, i32 120, i32 122, i32 124, i32 126, i32 1, i32 3, i32 5, i32 7, i32 17, i32 19, i32 21, i32 23, i32 9, i32 11, i32 13, i32 15, i32 25, i32 27, i32 29, i32 31, i32 33, i32 35, i32 37, i32 39, i32 49, i32 51, i32 53, i32 55, i32 41, i32 43, i32 45, i32 47, i32 57, i32 59, i32 61, i32 63, i32 65, i32 67, i32 69, i32 71, i32 81, i32 83, i32 85, i32 87, i32 73, i32 75, i32 77, i32 79, i32 89, i32 91, i32 93, i32 95, i32 97, i32 99, i32 101, i32 103, i32 113, i32 115, i32 117, i32 119, i32 105, i32 107, i32 109, i32 111, i32 121, i32 123, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_38:
; CHECK: [[REG38:r[0-9]+]] = #56
; CHECK: vdeal(v1,v0,[[REG38]])
define <128 x i8> @vdeal_38(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 32, i32 33, i32 34, i32 35, i32 36, i32 37, i32 38, i32 39, i32 48, i32 49, i32 50, i32 51, i32 52, i32 53, i32 54, i32 55, i32 64, i32 65, i32 66, i32 67, i32 68, i32 69, i32 70, i32 71, i32 80, i32 81, i32 82, i32 83, i32 84, i32 85, i32 86, i32 87, i32 96, i32 97, i32 98, i32 99, i32 100, i32 101, i32 102, i32 103, i32 112, i32 113, i32 114, i32 115, i32 116, i32 117, i32 118, i32 119, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 40, i32 41, i32 42, i32 43, i32 44, i32 45, i32 46, i32 47, i32 56, i32 57, i32 58, i32 59, i32 60, i32 61, i32 62, i32 63, i32 72, i32 73, i32 74, i32 75, i32 76, i32 77, i32 78, i32 79, i32 88, i32 89, i32 90, i32 91, i32 92, i32 93, i32 94, i32 95, i32 104, i32 105, i32 106, i32 107, i32 108, i32 109, i32 110, i32 111, i32 120, i32 121, i32 122, i32 123, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_39:
; CHECK: [[REG39:r[0-9]+]] = #57
; CHECK: vdeal(v1,v0,[[REG39]])
define <128 x i8> @vdeal_39(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 8, i32 2, i32 10, i32 4, i32 12, i32 6, i32 14, i32 16, i32 24, i32 18, i32 26, i32 20, i32 28, i32 22, i32 30, i32 32, i32 40, i32 34, i32 42, i32 36, i32 44, i32 38, i32 46, i32 48, i32 56, i32 50, i32 58, i32 52, i32 60, i32 54, i32 62, i32 64, i32 72, i32 66, i32 74, i32 68, i32 76, i32 70, i32 78, i32 80, i32 88, i32 82, i32 90, i32 84, i32 92, i32 86, i32 94, i32 96, i32 104, i32 98, i32 106, i32 100, i32 108, i32 102, i32 110, i32 112, i32 120, i32 114, i32 122, i32 116, i32 124, i32 118, i32 126, i32 1, i32 9, i32 3, i32 11, i32 5, i32 13, i32 7, i32 15, i32 17, i32 25, i32 19, i32 27, i32 21, i32 29, i32 23, i32 31, i32 33, i32 41, i32 35, i32 43, i32 37, i32 45, i32 39, i32 47, i32 49, i32 57, i32 51, i32 59, i32 53, i32 61, i32 55, i32 63, i32 65, i32 73, i32 67, i32 75, i32 69, i32 77, i32 71, i32 79, i32 81, i32 89, i32 83, i32 91, i32 85, i32 93, i32 87, i32 95, i32 97, i32 105, i32 99, i32 107, i32 101, i32 109, i32 103, i32 111, i32 113, i32 121, i32 115, i32 123, i32 117, i32 125, i32 119, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_3a:
; CHECK: [[REG3a:r[0-9]+]] = #58
; CHECK: vdeal(v1,v0,[[REG3a]])
define <128 x i8> @vdeal_3a(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 8, i32 9, i32 4, i32 5, i32 12, i32 13, i32 16, i32 17, i32 24, i32 25, i32 20, i32 21, i32 28, i32 29, i32 32, i32 33, i32 40, i32 41, i32 36, i32 37, i32 44, i32 45, i32 48, i32 49, i32 56, i32 57, i32 52, i32 53, i32 60, i32 61, i32 64, i32 65, i32 72, i32 73, i32 68, i32 69, i32 76, i32 77, i32 80, i32 81, i32 88, i32 89, i32 84, i32 85, i32 92, i32 93, i32 96, i32 97, i32 104, i32 105, i32 100, i32 101, i32 108, i32 109, i32 112, i32 113, i32 120, i32 121, i32 116, i32 117, i32 124, i32 125, i32 2, i32 3, i32 10, i32 11, i32 6, i32 7, i32 14, i32 15, i32 18, i32 19, i32 26, i32 27, i32 22, i32 23, i32 30, i32 31, i32 34, i32 35, i32 42, i32 43, i32 38, i32 39, i32 46, i32 47, i32 50, i32 51, i32 58, i32 59, i32 54, i32 55, i32 62, i32 63, i32 66, i32 67, i32 74, i32 75, i32 70, i32 71, i32 78, i32 79, i32 82, i32 83, i32 90, i32 91, i32 86, i32 87, i32 94, i32 95, i32 98, i32 99, i32 106, i32 107, i32 102, i32 103, i32 110, i32 111, i32 114, i32 115, i32 122, i32 123, i32 118, i32 119, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_3b:
; CHECK: [[REG3b:r[0-9]+]] = #59
; CHECK: vdeal(v1,v0,[[REG3b]])
define <128 x i8> @vdeal_3b(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 8, i32 10, i32 4, i32 6, i32 12, i32 14, i32 16, i32 18, i32 24, i32 26, i32 20, i32 22, i32 28, i32 30, i32 32, i32 34, i32 40, i32 42, i32 36, i32 38, i32 44, i32 46, i32 48, i32 50, i32 56, i32 58, i32 52, i32 54, i32 60, i32 62, i32 64, i32 66, i32 72, i32 74, i32 68, i32 70, i32 76, i32 78, i32 80, i32 82, i32 88, i32 90, i32 84, i32 86, i32 92, i32 94, i32 96, i32 98, i32 104, i32 106, i32 100, i32 102, i32 108, i32 110, i32 112, i32 114, i32 120, i32 122, i32 116, i32 118, i32 124, i32 126, i32 1, i32 3, i32 9, i32 11, i32 5, i32 7, i32 13, i32 15, i32 17, i32 19, i32 25, i32 27, i32 21, i32 23, i32 29, i32 31, i32 33, i32 35, i32 41, i32 43, i32 37, i32 39, i32 45, i32 47, i32 49, i32 51, i32 57, i32 59, i32 53, i32 55, i32 61, i32 63, i32 65, i32 67, i32 73, i32 75, i32 69, i32 71, i32 77, i32 79, i32 81, i32 83, i32 89, i32 91, i32 85, i32 87, i32 93, i32 95, i32 97, i32 99, i32 105, i32 107, i32 101, i32 103, i32 109, i32 111, i32 113, i32 115, i32 121, i32 123, i32 117, i32 119, i32 125, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_3c:
; CHECK: [[REG3c:r[0-9]+]] = #60
; CHECK: vdeal(v1,v0,[[REG3c]])
define <128 x i8> @vdeal_3c(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 2, i32 3, i32 8, i32 9, i32 10, i32 11, i32 16, i32 17, i32 18, i32 19, i32 24, i32 25, i32 26, i32 27, i32 32, i32 33, i32 34, i32 35, i32 40, i32 41, i32 42, i32 43, i32 48, i32 49, i32 50, i32 51, i32 56, i32 57, i32 58, i32 59, i32 64, i32 65, i32 66, i32 67, i32 72, i32 73, i32 74, i32 75, i32 80, i32 81, i32 82, i32 83, i32 88, i32 89, i32 90, i32 91, i32 96, i32 97, i32 98, i32 99, i32 104, i32 105, i32 106, i32 107, i32 112, i32 113, i32 114, i32 115, i32 120, i32 121, i32 122, i32 123, i32 4, i32 5, i32 6, i32 7, i32 12, i32 13, i32 14, i32 15, i32 20, i32 21, i32 22, i32 23, i32 28, i32 29, i32 30, i32 31, i32 36, i32 37, i32 38, i32 39, i32 44, i32 45, i32 46, i32 47, i32 52, i32 53, i32 54, i32 55, i32 60, i32 61, i32 62, i32 63, i32 68, i32 69, i32 70, i32 71, i32 76, i32 77, i32 78, i32 79, i32 84, i32 85, i32 86, i32 87, i32 92, i32 93, i32 94, i32 95, i32 100, i32 101, i32 102, i32 103, i32 108, i32 109, i32 110, i32 111, i32 116, i32 117, i32 118, i32 119, i32 124, i32 125, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_3d:
; CHECK: [[REG3d:r[0-9]+]] = #61
; CHECK: vdeal(v1,v0,[[REG3d]])
define <128 x i8> @vdeal_3d(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 4, i32 2, i32 6, i32 8, i32 12, i32 10, i32 14, i32 16, i32 20, i32 18, i32 22, i32 24, i32 28, i32 26, i32 30, i32 32, i32 36, i32 34, i32 38, i32 40, i32 44, i32 42, i32 46, i32 48, i32 52, i32 50, i32 54, i32 56, i32 60, i32 58, i32 62, i32 64, i32 68, i32 66, i32 70, i32 72, i32 76, i32 74, i32 78, i32 80, i32 84, i32 82, i32 86, i32 88, i32 92, i32 90, i32 94, i32 96, i32 100, i32 98, i32 102, i32 104, i32 108, i32 106, i32 110, i32 112, i32 116, i32 114, i32 118, i32 120, i32 124, i32 122, i32 126, i32 1, i32 5, i32 3, i32 7, i32 9, i32 13, i32 11, i32 15, i32 17, i32 21, i32 19, i32 23, i32 25, i32 29, i32 27, i32 31, i32 33, i32 37, i32 35, i32 39, i32 41, i32 45, i32 43, i32 47, i32 49, i32 53, i32 51, i32 55, i32 57, i32 61, i32 59, i32 63, i32 65, i32 69, i32 67, i32 71, i32 73, i32 77, i32 75, i32 79, i32 81, i32 85, i32 83, i32 87, i32 89, i32 93, i32 91, i32 95, i32 97, i32 101, i32 99, i32 103, i32 105, i32 109, i32 107, i32 111, i32 113, i32 117, i32 115, i32 119, i32 121, i32 125, i32 123, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_3e:
; CHECK: [[REG3e:r[0-9]+]] = #62
; CHECK: vdeal(v1,v0,[[REG3e]])
define <128 x i8> @vdeal_3e(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 1, i32 4, i32 5, i32 8, i32 9, i32 12, i32 13, i32 16, i32 17, i32 20, i32 21, i32 24, i32 25, i32 28, i32 29, i32 32, i32 33, i32 36, i32 37, i32 40, i32 41, i32 44, i32 45, i32 48, i32 49, i32 52, i32 53, i32 56, i32 57, i32 60, i32 61, i32 64, i32 65, i32 68, i32 69, i32 72, i32 73, i32 76, i32 77, i32 80, i32 81, i32 84, i32 85, i32 88, i32 89, i32 92, i32 93, i32 96, i32 97, i32 100, i32 101, i32 104, i32 105, i32 108, i32 109, i32 112, i32 113, i32 116, i32 117, i32 120, i32 121, i32 124, i32 125, i32 2, i32 3, i32 6, i32 7, i32 10, i32 11, i32 14, i32 15, i32 18, i32 19, i32 22, i32 23, i32 26, i32 27, i32 30, i32 31, i32 34, i32 35, i32 38, i32 39, i32 42, i32 43, i32 46, i32 47, i32 50, i32 51, i32 54, i32 55, i32 58, i32 59, i32 62, i32 63, i32 66, i32 67, i32 70, i32 71, i32 74, i32 75, i32 78, i32 79, i32 82, i32 83, i32 86, i32 87, i32 90, i32 91, i32 94, i32 95, i32 98, i32 99, i32 102, i32 103, i32 106, i32 107, i32 110, i32 111, i32 114, i32 115, i32 118, i32 119, i32 122, i32 123, i32 126, i32 127>
  ret <128 x i8> %p
}

; CHECK-LABEL: vdeal_3f:
; CHECK: [[REG3f:r[0-9]+]] = #63
; CHECK: vdeal(v1,v0,[[REG3f]])
define <128 x i8> @vdeal_3f(<128 x i8> %v0, <128 x i8> %v1) #0 {
  %p = shufflevector <128 x i8> %v0, <128 x i8> undef, <128 x i32> < i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30, i32 32, i32 34, i32 36, i32 38, i32 40, i32 42, i32 44, i32 46, i32 48, i32 50, i32 52, i32 54, i32 56, i32 58, i32 60, i32 62, i32 64, i32 66, i32 68, i32 70, i32 72, i32 74, i32 76, i32 78, i32 80, i32 82, i32 84, i32 86, i32 88, i32 90, i32 92, i32 94, i32 96, i32 98, i32 100, i32 102, i32 104, i32 106, i32 108, i32 110, i32 112, i32 114, i32 116, i32 118, i32 120, i32 122, i32 124, i32 126, i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31, i32 33, i32 35, i32 37, i32 39, i32 41, i32 43, i32 45, i32 47, i32 49, i32 51, i32 53, i32 55, i32 57, i32 59, i32 61, i32 63, i32 65, i32 67, i32 69, i32 71, i32 73, i32 75, i32 77, i32 79, i32 81, i32 83, i32 85, i32 87, i32 89, i32 91, i32 93, i32 95, i32 97, i32 99, i32 101, i32 103, i32 105, i32 107, i32 109, i32 111, i32 113, i32 115, i32 117, i32 119, i32 121, i32 123, i32 125, i32 127>
  ret <128 x i8> %p
}

attributes #0 = { nounwind readnone "target-cpu"="hexagonv60" "target-features"="+hvx,+hvx-length64b" }
