; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 --mattr=+lasx < %s | FileCheck %s

define <32 x i8> @shuffle_to_xvslli_h_8(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvslli_h_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvslli.h $xr0, $xr0, 8
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 32, i32 0, i32 32, i32 2, i32 32, i32 4, i32 32, i32 6, i32 32, i32 8, i32 32, i32 10, i32 32, i32 12, i32 32, i32 14, i32 32, i32 16, i32 32, i32 18, i32 32, i32 20, i32 32, i32 22, i32 32, i32 24, i32 32, i32 26, i32 32, i32 28, i32 32, i32 30>
  ret <32 x i8> %shuffle
}

define <32 x i8> @shuffle_to_xvsrli_h_8(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvsrli_h_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvsrli.h $xr0, $xr0, 8
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 1, i32 32, i32 3, i32 32, i32 5, i32 32, i32 7, i32 32, i32 9, i32 32, i32 11, i32 32, i32 13, i32 32, i32 15, i32 32, i32 17, i32 32, i32 19, i32 32, i32 21, i32 32, i32 23, i32 32, i32 25, i32 32, i32 27, i32 32, i32 29, i32 32, i32 31, i32 32>
  ret <32 x i8> %shuffle
}

define <32 x i8> @shuffle_to_xvslli_w_8(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvslli_w_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvslli.w $xr0, $xr0, 8
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 32, i32 0, i32 1, i32 2, i32 32, i32 4, i32 5, i32 6, i32 32, i32 8, i32 9, i32 10, i32 32, i32 12, i32 13, i32 14, i32 32, i32 16, i32 17, i32 18, i32 32, i32 20, i32 21, i32 22, i32 32, i32 24, i32 25, i32 26, i32 32, i32 28, i32 29, i32 30>
  ret <32 x i8> %shuffle
}

define <32 x i8> @shuffle_to_xvsrli_w_8(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvsrli_w_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvsrli.w $xr0, $xr0, 8
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 1, i32 2, i32 3, i32 32, i32 5, i32 6, i32 7, i32 32, i32 9, i32 10, i32 11, i32 32, i32 13, i32 14, i32 15, i32 32, i32 17, i32 18, i32 19, i32 32, i32 21, i32 22, i32 23, i32 32, i32 25, i32 26, i32 27, i32 32, i32 29, i32 30, i32 31, i32 32>
  ret <32 x i8> %shuffle
}

define <16 x i16> @shuffle_to_xvslli_w_16(<16 x i16> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvslli_w_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvslli.w $xr0, $xr0, 16
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i16> %a, <16 x i16> zeroinitializer, <16 x i32> <i32 16, i32 0, i32 16, i32 2, i32 16, i32 4, i32 16, i32 6, i32 16, i32 8, i32 16, i32 10, i32 16, i32 12, i32 16, i32 14>
  ret <16 x i16> %shuffle
}

define <16 x i16> @shuffle_to_xvsrli_w_16(<16 x i16> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvsrli_w_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvsrli.w $xr0, $xr0, 16
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i16> %a, <16 x i16> zeroinitializer, <16 x i32> <i32 1, i32 16, i32 3, i32 16, i32 5, i32 16, i32 7, i32 16, i32 9, i32 16, i32 11, i32 16, i32 13, i32 16, i32 15, i32 16>
  ret <16 x i16> %shuffle
}

define <32 x i8> @shuffle_to_xvslli_w_24(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvslli_w_24:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvslli.w $xr0, $xr0, 24
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 32, i32 32, i32 32, i32 0, i32 32, i32 32, i32 32, i32 4, i32 32, i32 32, i32 32, i32 8, i32 32, i32 32, i32 32, i32 12, i32 32, i32 32, i32 32, i32 16, i32 32, i32 32, i32 32, i32 20, i32 32, i32 32, i32 32, i32 24, i32 32, i32 32, i32 32, i32 28>
  ret <32 x i8> %shuffle
}

define <32 x i8> @shuffle_to_xvsrli_w_24(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvsrli_w_24:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvsrli.w $xr0, $xr0, 24
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 3, i32 32, i32 32, i32 32, i32 7, i32 32, i32 32, i32 32, i32 11, i32 32, i32 32, i32 32, i32 15, i32 32, i32 32, i32 32, i32 19, i32 32, i32 32, i32 32, i32 23, i32 32, i32 32, i32 32, i32 27, i32 32, i32 32, i32 32, i32 31, i32 32, i32 32, i32 32>
  ret <32 x i8> %shuffle
}

define <32 x i8> @shuffle_to_xvslli_d_8(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvslli_d_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvslli.d $xr0, $xr0, 8
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 32, i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 32, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 32, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 32, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30>
  ret <32 x i8> %shuffle
}

define <32 x i8> @shuffle_to_xvsrli_d_8(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvsrli_d_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvsrli.d $xr0, $xr0, 8
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 32, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 32, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 32, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32>
  ret <32 x i8> %shuffle
}

define <16 x i16> @shuffle_to_xvslli_d_16(<16 x i16> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvslli_d_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvslli.d $xr0, $xr0, 16
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i16> %a, <16 x i16> zeroinitializer, <16 x i32> <i32 16, i32 0, i32 1, i32 2, i32 16, i32 4, i32 5, i32 6, i32 16, i32 8, i32 9, i32 10, i32 16, i32 12, i32 13, i32 14>
  ret <16 x i16> %shuffle
}

define <16 x i16> @shuffle_to_xvsrli_d_16(<16 x i16> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvsrli_d_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvsrli.d $xr0, $xr0, 16
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i16> %a, <16 x i16> zeroinitializer, <16 x i32> <i32 1, i32 2, i32 3, i32 16, i32 5, i32 6, i32 7, i32 16, i32 9, i32 10, i32 11, i32 16, i32 13, i32 14, i32 15, i32 16>
  ret <16 x i16> %shuffle
}

define <32 x i8> @shuffle_to_xvslli_d_24(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvslli_d_24:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvslli.d $xr0, $xr0, 24
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 32, i32 32, i32 32, i32 0, i32 1, i32 2, i32 3, i32 4, i32 32, i32 32, i32 32, i32 8, i32 9, i32 10, i32 11, i32 12, i32 32, i32 32, i32 32, i32 16, i32 17, i32 18, i32 19, i32 20, i32 32, i32 32, i32 32, i32 24, i32 25, i32 26, i32 27, i32 28>
  ret <32 x i8> %shuffle
}

define <32 x i8> @shuffle_to_xvsrli_d_24(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvsrli_d_24:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvsrli.d $xr0, $xr0, 24
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 3, i32 4, i32 5, i32 6, i32 7, i32 32, i32 32, i32 32, i32 11, i32 12, i32 13, i32 14, i32 15, i32 32, i32 32, i32 32, i32 19, i32 20, i32 21, i32 22, i32 23, i32 32, i32 32, i32 32, i32 27, i32 28, i32 29, i32 30, i32 31, i32 32, i32 32, i32 32>
  ret <32 x i8> %shuffle
}

define <8 x i32> @shuffle_to_xvslli_d_32(<8 x i32> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvslli_d_32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvslli.d $xr0, $xr0, 32
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> zeroinitializer, <8 x i32> <i32 8, i32 0, i32 8, i32 2, i32 8, i32 4, i32 8, i32 6>
  ret <8 x i32> %shuffle
}

define <8 x i32> @shuffle_to_xvsrli_d_32(<8 x i32> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvsrli_d_32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvsrli.d $xr0, $xr0, 32
; CHECK-NEXT:    ret
  %shuffle = shufflevector <8 x i32> %a, <8 x i32> zeroinitializer, <8 x i32> <i32 1, i32 8, i32 3, i32 8, i32 5, i32 8, i32 7, i32 8>
  ret <8 x i32> %shuffle
}

define <32 x i8> @shuffle_to_xvslli_d_40(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvslli_d_40:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvslli.d $xr0, $xr0, 40
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 32, i32 32, i32 32, i32 32, i32 32, i32 0, i32 1, i32 2, i32 32, i32 32, i32 32, i32 32, i32 32, i32 8, i32 9, i32 10, i32 32, i32 32, i32 32, i32 32, i32 32, i32 16, i32 17, i32 18, i32 32, i32 32, i32 32, i32 32, i32 32, i32 24, i32 25, i32 26>
  ret <32 x i8> %shuffle
}

define <32 x i8> @shuffle_to_xvsrli_d_40(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvsrli_d_40:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvsrli.d $xr0, $xr0, 40
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 5, i32 6, i32 7, i32 32, i32 32, i32 32, i32 32, i32 32, i32 13, i32 14, i32 15, i32 32, i32 32, i32 32, i32 32, i32 32, i32 21, i32 22, i32 23, i32 32, i32 32, i32 32, i32 32, i32 32, i32 29, i32 30, i32 31, i32 32, i32 32, i32 32, i32 32, i32 32>
  ret <32 x i8> %shuffle
}

define <16 x i16> @shuffle_to_xvslli_d_48(<16 x i16> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvslli_d_48:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvslli.d $xr0, $xr0, 48
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i16> %a, <16 x i16> zeroinitializer, <16 x i32> <i32 16, i32 16, i32 16, i32 0, i32 16, i32 16, i32 16, i32 4, i32 16, i32 16, i32 16, i32 8, i32 16, i32 16, i32 16, i32 12>
  ret <16 x i16> %shuffle
}

define <16 x i16> @shuffle_to_xvsrli_d_48(<16 x i16> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvsrli_d_48:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvsrli.d $xr0, $xr0, 48
; CHECK-NEXT:    ret
  %shuffle = shufflevector <16 x i16> %a, <16 x i16> zeroinitializer, <16 x i32> <i32 3, i32 16, i32 16, i32 16, i32 7, i32 16, i32 16, i32 16, i32 11, i32 16, i32 16, i32 16, i32 15, i32 16, i32 16, i32 16>
  ret <16 x i16> %shuffle
}

define <32 x i8> @shuffle_to_xvslli_d_56(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvslli_d_56:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvslli.d $xr0, $xr0, 56
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 0, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 8, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 16, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 24>
  ret <32 x i8> %shuffle
}

define <32 x i8> @shuffle_to_xvsrli_d_56(<32 x i8> %a) nounwind {
; CHECK-LABEL: shuffle_to_xvsrli_d_56:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xvsrli.d $xr0, $xr0, 56
; CHECK-NEXT:    ret
  %shuffle = shufflevector <32 x i8> %a, <32 x i8> zeroinitializer, <32 x i32> <i32 7, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 15, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 23, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 31, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32, i32 32>
  ret <32 x i8> %shuffle
}
