; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch32 < %s | FileCheck %s --check-prefix=LA32
; RUN: llc --mtriple=loongarch64 < %s | FileCheck %s --check-prefix=LA64

declare void @llvm.prefetch(ptr, i32, i32, i32) nounwind

define dso_local void @prefetch_no_offset(ptr %ptr) nounwind {
; LA32-LABEL: prefetch_no_offset:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    ret
;
; LA64-LABEL: prefetch_no_offset:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ret
entry:
  tail call void @llvm.prefetch(ptr %ptr, i32 0, i32 3, i32 0)
  ret void
}


define dso_local void @prefetch_with_offset(ptr %ptr) nounwind {
; LA32-LABEL: prefetch_with_offset:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    ret
;
; LA64-LABEL: prefetch_with_offset:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ret
entry:
  %addr = getelementptr i8, ptr %ptr, i64 200
  tail call void @llvm.prefetch(ptr %addr, i32 0, i32 3, i32 0)
  ret void
}
