; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=riscv32 -global-isel --stop-before=legalizer < %s -o - \
; RUN:   | FileCheck --check-prefix=RV32I %s
; RUN: llc -mtriple=riscv64 -global-isel --stop-before=legalizer < %s -o - \
; RUN:   | FileCheck --check-prefix=RV64I %s

declare i32 @foo(i32 noundef signext, ...)

define i32 @main() {
  ; RV32I-LABEL: name: main
  ; RV32I: bb.1.entry:
  ; RV32I-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; RV32I-NEXT:   [[C1:%[0-9]+]]:_(s32) = G_CONSTANT i32 1
  ; RV32I-NEXT:   [[C2:%[0-9]+]]:_(s32) = G_CONSTANT i32 2
  ; RV32I-NEXT:   [[C3:%[0-9]+]]:_(s32) = G_CONSTANT i32 3
  ; RV32I-NEXT:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %stack.0.retval
  ; RV32I-NEXT:   G_STORE [[C]](s32), [[FRAME_INDEX]](p0) :: (store (s32) into %ir.retval)
  ; RV32I-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $x2, implicit $x2
  ; RV32I-NEXT:   $x10 = COPY [[C]](s32)
  ; RV32I-NEXT:   $x11 = COPY [[C1]](s32)
  ; RV32I-NEXT:   $x12 = COPY [[C2]](s32)
  ; RV32I-NEXT:   $x13 = COPY [[C3]](s32)
  ; RV32I-NEXT:   PseudoCALL target-flags(riscv-call) @foo, csr_ilp32_lp64, implicit-def $x1, implicit $x10, implicit $x11, implicit $x12, implicit $x13, implicit-def $x10
  ; RV32I-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $x2, implicit $x2
  ; RV32I-NEXT:   [[COPY:%[0-9]+]]:_(s32) = COPY $x10
  ; RV32I-NEXT:   $x10 = COPY [[COPY]](s32)
  ; RV32I-NEXT:   PseudoRET implicit $x10
  ;
  ; RV64I-LABEL: name: main
  ; RV64I: bb.1.entry:
  ; RV64I-NEXT:   [[C:%[0-9]+]]:_(s32) = G_CONSTANT i32 0
  ; RV64I-NEXT:   [[FRAME_INDEX:%[0-9]+]]:_(p0) = G_FRAME_INDEX %stack.0.retval
  ; RV64I-NEXT:   G_STORE [[C]](s32), [[FRAME_INDEX]](p0) :: (store (s32) into %ir.retval)
  ; RV64I-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def $x2, implicit $x2
  ; RV64I-NEXT:   [[C1:%[0-9]+]]:_(s64) = G_CONSTANT i64 0
  ; RV64I-NEXT:   [[C2:%[0-9]+]]:_(s64) = G_CONSTANT i64 1
  ; RV64I-NEXT:   [[C3:%[0-9]+]]:_(s64) = G_CONSTANT i64 2
  ; RV64I-NEXT:   [[C4:%[0-9]+]]:_(s64) = G_CONSTANT i64 3
  ; RV64I-NEXT:   $x10 = COPY [[C1]](s64)
  ; RV64I-NEXT:   $x11 = COPY [[C2]](s64)
  ; RV64I-NEXT:   $x12 = COPY [[C3]](s64)
  ; RV64I-NEXT:   $x13 = COPY [[C4]](s64)
  ; RV64I-NEXT:   PseudoCALL target-flags(riscv-call) @foo, csr_ilp32_lp64, implicit-def $x1, implicit $x10, implicit $x11, implicit $x12, implicit $x13, implicit-def $x10
  ; RV64I-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def $x2, implicit $x2
  ; RV64I-NEXT:   [[COPY:%[0-9]+]]:_(s64) = COPY $x10
  ; RV64I-NEXT:   [[ASSERT_SEXT:%[0-9]+]]:_(s64) = G_ASSERT_SEXT [[COPY]], 32
  ; RV64I-NEXT:   $x10 = COPY [[ASSERT_SEXT]](s64)
  ; RV64I-NEXT:   PseudoRET implicit $x10
entry:
  %retval = alloca i32, align 4
  store i32 0, ptr %retval, align 4
  %call = call noundef signext i32 (i32, ...) @foo(i32 noundef signext 0, i32 noundef signext 1, i32 noundef signext 2, i32 noundef signext 3)
  ret i32 %call
}
