; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -global-merge-on-external=false \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -global-merge-on-external=false \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=CHECK-WEXTERN %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=CHECK-WEXTERN %s

@ig1 = internal global i32 0, align 4
@ig2 = internal global i32 0, align 4

@eg1 = dso_local global i32 0, align 4
@eg2 = dso_local global i32 0, align 4

; TODO: It would be better for code size to alter the first store below by
; first fully materialising .L_MergedGlobals in a1 and then storing to it with
; a 0 offset.

define void @f1(i32 %a) nounwind {
; CHECK-LABEL: f1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a1, %hi(eg1)
; CHECK-NEXT:    sw a0, %lo(eg1)(a1)
; CHECK-NEXT:    lui a1, %hi(.L_MergedGlobals)
; CHECK-NEXT:    sw a0, %lo(.L_MergedGlobals)(a1)
; CHECK-NEXT:    addi a1, a1, %lo(.L_MergedGlobals)
; CHECK-NEXT:    sw a0, 4(a1)
; CHECK-NEXT:    lui a1, %hi(eg2)
; CHECK-NEXT:    sw a0, %lo(eg2)(a1)
; CHECK-NEXT:    ret
;
; CHECK-WEXTERN-LABEL: f1:
; CHECK-WEXTERN:       # %bb.0:
; CHECK-WEXTERN-NEXT:    lui a1, %hi(.L_MergedGlobals)
; CHECK-WEXTERN-NEXT:    sw a0, %lo(.L_MergedGlobals)(a1)
; CHECK-WEXTERN-NEXT:    addi a1, a1, %lo(.L_MergedGlobals)
; CHECK-WEXTERN-NEXT:    sw a0, 4(a1)
; CHECK-WEXTERN-NEXT:    sw a0, 8(a1)
; CHECK-WEXTERN-NEXT:    sw a0, 12(a1)
; CHECK-WEXTERN-NEXT:    ret
  store i32 %a, ptr @ig1, align 4
  store i32 %a, ptr @ig2, align 4
  store i32 %a, ptr @eg1, align 4
  store i32 %a, ptr @eg2, align 4
  ret void
}
