; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -debug-entry-values -enable-misched=0 < %s | FileCheck %s

; Trivial patchpoint codegen
;
define i64 @trivial_patchpoint_codegen(i64 %p1, i64 %p2, i64 %p3, i64 %p4) {
; CHECK-LABEL: trivial_patchpoint_codegen:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    sd s0, 8(sp) # 8-byte Folded Spill
; CHECK-NEXT:    sd s1, 0(sp) # 8-byte Folded Spill
; CHECK-NEXT:    .cfi_offset s0, -8
; CHECK-NEXT:    .cfi_offset s1, -16
; CHECK-NEXT:    mv s0, a0
; CHECK-NEXT:  .Ltmp0:
; CHECK-NEXT:    lui ra, 3563
; CHECK-NEXT:    addi ra, ra, -577
; CHECK-NEXT:    slli ra, ra, 12
; CHECK-NEXT:    addi ra, ra, -259
; CHECK-NEXT:    slli ra, ra, 12
; CHECK-NEXT:    addi ra, ra, -1282
; CHECK-NEXT:    jalr ra
; CHECK-NEXT:    mv s1, a0
; CHECK-NEXT:    mv a0, s0
; CHECK-NEXT:    mv a1, s1
; CHECK-NEXT:  .Ltmp1:
; CHECK-NEXT:    lui ra, 3563
; CHECK-NEXT:    addi ra, ra, -577
; CHECK-NEXT:    slli ra, ra, 12
; CHECK-NEXT:    addi ra, ra, -259
; CHECK-NEXT:    slli ra, ra, 12
; CHECK-NEXT:    addi ra, ra, -1281
; CHECK-NEXT:    jalr ra
; CHECK-NEXT:    mv a0, s1
; CHECK-NEXT:    ld s0, 8(sp) # 8-byte Folded Reload
; CHECK-NEXT:    ld s1, 0(sp) # 8-byte Folded Reload
; CHECK-NEXT:    .cfi_restore s0
; CHECK-NEXT:    .cfi_restore s1
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NEXT:    ret
entry:
  %resolveCall2 = inttoptr i64 244837814094590 to i8*
  %result = tail call i64 (i64, i32, i8*, i32, ...) @llvm.experimental.patchpoint.i64(i64 2, i32 28, i8* %resolveCall2, i32 4, i64 %p1, i64 %p2, i64 %p3, i64 %p4)
  %resolveCall3 = inttoptr i64 244837814094591 to i8*
  tail call void (i64, i32, i8*, i32, ...) @llvm.experimental.patchpoint.void(i64 3, i32 28, i8* %resolveCall3, i32 2, i64 %p1, i64 %result)
  ret i64 %result
}

; Test small patchpoints that don't emit calls.
define void @small_patchpoint_codegen(i64 %p1, i64 %p2, i64 %p3, i64 %p4) {
; CHECK-LABEL: small_patchpoint_codegen:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:  .Ltmp2:
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    nop
; CHECK-NEXT:    ret
entry:
  %result = tail call i64 (i64, i32, ptr, i32, ...) @llvm.experimental.patchpoint.i64(i64 5, i32 20, ptr null, i32 2, i64 %p1, i64 %p2)
  ret void
}

declare void @llvm.experimental.stackmap(i64, i32, ...)
declare void @llvm.experimental.patchpoint.void(i64, i32, ptr, i32, ...)
declare i64 @llvm.experimental.patchpoint.i64(i64, i32, ptr, i32, ...)
