; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zfbfmin,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZFBFMIN-ZVFBFMIN
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZVFBFMIN
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zfbfmin,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZFBFMIN-ZVFBFMIN
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zvfbfmin -verify-machineinstrs < %s | FileCheck %s --check-prefixes=ZVFBFMIN

define <8 x bfloat> @splat_v8bf16(ptr %x, bfloat %y) {
; ZFBFMIN-ZVFBFMIN-LABEL: splat_v8bf16:
; ZFBFMIN-ZVFBFMIN:       # %bb.0:
; ZFBFMIN-ZVFBFMIN-NEXT:    fmv.x.h a0, fa0
; ZFBFMIN-ZVFBFMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZFBFMIN-ZVFBFMIN-NEXT:    vmv.v.x v8, a0
; ZFBFMIN-ZVFBFMIN-NEXT:    ret
;
; ZVFBFMIN-LABEL: splat_v8bf16:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFBFMIN-NEXT:    vmv.v.x v8, a0
; ZVFBFMIN-NEXT:    ret
  %a = insertelement <8 x bfloat> poison, bfloat %y, i32 0
  %b = shufflevector <8 x bfloat> %a, <8 x bfloat> poison, <8 x i32> zeroinitializer
  ret <8 x bfloat> %b
}

define <16 x bfloat> @splat_16bf16(ptr %x, bfloat %y) {
; ZFBFMIN-ZVFBFMIN-LABEL: splat_16bf16:
; ZFBFMIN-ZVFBFMIN:       # %bb.0:
; ZFBFMIN-ZVFBFMIN-NEXT:    fmv.x.h a0, fa0
; ZFBFMIN-ZVFBFMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZFBFMIN-ZVFBFMIN-NEXT:    vmv.v.x v8, a0
; ZFBFMIN-ZVFBFMIN-NEXT:    ret
;
; ZVFBFMIN-LABEL: splat_16bf16:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFBFMIN-NEXT:    vmv.v.x v8, a0
; ZVFBFMIN-NEXT:    ret
  %a = insertelement <16 x bfloat> poison, bfloat %y, i32 0
  %b = shufflevector <16 x bfloat> %a, <16 x bfloat> poison, <16 x i32> zeroinitializer
  ret <16 x bfloat> %b
}

define <64 x bfloat> @splat_64bf16(ptr %x, bfloat %y) {
; ZFBFMIN-ZVFBFMIN-LABEL: splat_64bf16:
; ZFBFMIN-ZVFBFMIN:       # %bb.0:
; ZFBFMIN-ZVFBFMIN-NEXT:    fmv.x.h a0, fa0
; ZFBFMIN-ZVFBFMIN-NEXT:    li a1, 64
; ZFBFMIN-ZVFBFMIN-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; ZFBFMIN-ZVFBFMIN-NEXT:    vmv.v.x v8, a0
; ZFBFMIN-ZVFBFMIN-NEXT:    ret
;
; ZVFBFMIN-LABEL: splat_64bf16:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    fmv.x.w a0, fa0
; ZVFBFMIN-NEXT:    li a1, 64
; ZVFBFMIN-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; ZVFBFMIN-NEXT:    vmv.v.x v8, a0
; ZVFBFMIN-NEXT:    ret
  %a = insertelement <64 x bfloat> poison, bfloat %y, i32 0
  %b = shufflevector <64 x bfloat> %a, <64 x bfloat> poison, <64 x i32> zeroinitializer
  ret <64 x bfloat> %b
}

define <8 x bfloat> @splat_zero_v8bf16(ptr %x) {
; ZFBFMIN-ZVFBFMIN-LABEL: splat_zero_v8bf16:
; ZFBFMIN-ZVFBFMIN:       # %bb.0:
; ZFBFMIN-ZVFBFMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZFBFMIN-ZVFBFMIN-NEXT:    vmv.v.i v8, 0
; ZFBFMIN-ZVFBFMIN-NEXT:    ret
;
; ZVFBFMIN-LABEL: splat_zero_v8bf16:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFBFMIN-NEXT:    vmv.v.i v8, 0
; ZVFBFMIN-NEXT:    ret
  ret <8 x bfloat> splat (bfloat 0.0)
}

define <16 x bfloat> @splat_zero_16bf16(ptr %x) {
; ZFBFMIN-ZVFBFMIN-LABEL: splat_zero_16bf16:
; ZFBFMIN-ZVFBFMIN:       # %bb.0:
; ZFBFMIN-ZVFBFMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZFBFMIN-ZVFBFMIN-NEXT:    vmv.v.i v8, 0
; ZFBFMIN-ZVFBFMIN-NEXT:    ret
;
; ZVFBFMIN-LABEL: splat_zero_16bf16:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFBFMIN-NEXT:    vmv.v.i v8, 0
; ZVFBFMIN-NEXT:    ret
  ret <16 x bfloat> splat (bfloat 0.0)
}

define <8 x bfloat> @splat_negzero_v8bf16(ptr %x) {
; ZFBFMIN-ZVFBFMIN-LABEL: splat_negzero_v8bf16:
; ZFBFMIN-ZVFBFMIN:       # %bb.0:
; ZFBFMIN-ZVFBFMIN-NEXT:    lui a0, 1048568
; ZFBFMIN-ZVFBFMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZFBFMIN-ZVFBFMIN-NEXT:    vmv.v.x v8, a0
; ZFBFMIN-ZVFBFMIN-NEXT:    ret
;
; ZVFBFMIN-LABEL: splat_negzero_v8bf16:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    lui a0, 1048568
; ZVFBFMIN-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; ZVFBFMIN-NEXT:    vmv.v.x v8, a0
; ZVFBFMIN-NEXT:    ret
  ret <8 x bfloat> splat (bfloat -0.0)
}

define <16 x bfloat> @splat_negzero_16bf16(ptr %x) {
; ZFBFMIN-ZVFBFMIN-LABEL: splat_negzero_16bf16:
; ZFBFMIN-ZVFBFMIN:       # %bb.0:
; ZFBFMIN-ZVFBFMIN-NEXT:    lui a0, 1048568
; ZFBFMIN-ZVFBFMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZFBFMIN-ZVFBFMIN-NEXT:    vmv.v.x v8, a0
; ZFBFMIN-ZVFBFMIN-NEXT:    ret
;
; ZVFBFMIN-LABEL: splat_negzero_16bf16:
; ZVFBFMIN:       # %bb.0:
; ZVFBFMIN-NEXT:    lui a0, 1048568
; ZVFBFMIN-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; ZVFBFMIN-NEXT:    vmv.v.x v8, a0
; ZVFBFMIN-NEXT:    ret
  ret <16 x bfloat> splat (bfloat -0.0)
}
