; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zvfh,+v -target-abi=ilp32d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zvfh,+v -target-abi=lp64d \
; RUN:     -verify-machineinstrs < %s | FileCheck %s

declare <2 x half> @llvm.experimental.constrained.fadd.v2f16(<2 x half>, <2 x half>, metadata, metadata)
define <2 x half> @vfadd_vv_v2f16(<2 x half> %va, <2 x half> %vb) strictfp {
; CHECK-LABEL: vfadd_vv_v2f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %vc = call <2 x half> @llvm.experimental.constrained.fadd.v2f16(<2 x half> %va, <2 x half> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <2 x half> %vc
}

define <2 x half> @vfadd_vf_v2f16(<2 x half> %va, half %b) strictfp {
; CHECK-LABEL: vfadd_vf_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x half> poison, half %b, i32 0
  %splat = shufflevector <2 x half> %head, <2 x half> poison, <2 x i32> zeroinitializer
  %vc = call <2 x half> @llvm.experimental.constrained.fadd.v2f16(<2 x half> %va, <2 x half> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <2 x half> %vc
}

declare <4 x half> @llvm.experimental.constrained.fadd.v4f16(<4 x half>, <4 x half>, metadata, metadata)
define <4 x half> @vfadd_vv_v4f16(<4 x half> %va, <4 x half> %vb) strictfp {
; CHECK-LABEL: vfadd_vv_v4f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %vc = call <4 x half> @llvm.experimental.constrained.fadd.v4f16(<4 x half> %va, <4 x half> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <4 x half> %vc
}

define <4 x half> @vfadd_vf_v4f16(<4 x half> %va, half %b) strictfp {
; CHECK-LABEL: vfadd_vf_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x half> poison, half %b, i32 0
  %splat = shufflevector <4 x half> %head, <4 x half> poison, <4 x i32> zeroinitializer
  %vc = call <4 x half> @llvm.experimental.constrained.fadd.v4f16(<4 x half> %va, <4 x half> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <4 x half> %vc
}

declare <8 x half> @llvm.experimental.constrained.fadd.v8f16(<8 x half>, <8 x half>, metadata, metadata)
define <8 x half> @vfadd_vv_v8f16(<8 x half> %va, <8 x half> %vb) strictfp {
; CHECK-LABEL: vfadd_vv_v8f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %vc = call <8 x half> @llvm.experimental.constrained.fadd.v8f16(<8 x half> %va, <8 x half> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <8 x half> %vc
}

define <8 x half> @vfadd_vf_v8f16(<8 x half> %va, half %b) strictfp {
; CHECK-LABEL: vfadd_vf_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x half> poison, half %b, i32 0
  %splat = shufflevector <8 x half> %head, <8 x half> poison, <8 x i32> zeroinitializer
  %vc = call <8 x half> @llvm.experimental.constrained.fadd.v8f16(<8 x half> %va, <8 x half> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <8 x half> %vc
}

declare <16 x half> @llvm.experimental.constrained.fadd.v16f16(<16 x half>, <16 x half>, metadata, metadata)
define <16 x half> @vfadd_vv_v16f16(<16 x half> %va, <16 x half> %vb) strictfp {
; CHECK-LABEL: vfadd_vv_v16f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %vc = call <16 x half> @llvm.experimental.constrained.fadd.v16f16(<16 x half> %va, <16 x half> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <16 x half> %vc
}

define <16 x half> @vfadd_vf_v16f16(<16 x half> %va, half %b) strictfp {
; CHECK-LABEL: vfadd_vf_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <16 x half> poison, half %b, i32 0
  %splat = shufflevector <16 x half> %head, <16 x half> poison, <16 x i32> zeroinitializer
  %vc = call <16 x half> @llvm.experimental.constrained.fadd.v16f16(<16 x half> %va, <16 x half> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <16 x half> %vc
}

declare <32 x half> @llvm.experimental.constrained.fadd.v32f16(<32 x half>, <32 x half>, metadata, metadata)
define <32 x half> @vfadd_vv_v32f16(<32 x half> %va, <32 x half> %vb) strictfp {
; CHECK-LABEL: vfadd_vv_v32f16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %vc = call <32 x half> @llvm.experimental.constrained.fadd.v32f16(<32 x half> %va, <32 x half> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <32 x half> %vc
}

define <32 x half> @vfadd_vf_v32f16(<32 x half> %va, half %b) strictfp {
; CHECK-LABEL: vfadd_vf_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <32 x half> poison, half %b, i32 0
  %splat = shufflevector <32 x half> %head, <32 x half> poison, <32 x i32> zeroinitializer
  %vc = call <32 x half> @llvm.experimental.constrained.fadd.v32f16(<32 x half> %va, <32 x half> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <32 x half> %vc
}

declare <2 x float> @llvm.experimental.constrained.fadd.v2f32(<2 x float>, <2 x float>, metadata, metadata)
define <2 x float> @vfadd_vv_v2f32(<2 x float> %va, <2 x float> %vb) strictfp {
; CHECK-LABEL: vfadd_vv_v2f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %vc = call <2 x float> @llvm.experimental.constrained.fadd.v2f32(<2 x float> %va, <2 x float> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <2 x float> %vc
}

define <2 x float> @vfadd_vf_v2f32(<2 x float> %va, float %b) strictfp {
; CHECK-LABEL: vfadd_vf_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x float> poison, float %b, i32 0
  %splat = shufflevector <2 x float> %head, <2 x float> poison, <2 x i32> zeroinitializer
  %vc = call <2 x float> @llvm.experimental.constrained.fadd.v2f32(<2 x float> %va, <2 x float> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <2 x float> %vc
}

declare <4 x float> @llvm.experimental.constrained.fadd.v4f32(<4 x float>, <4 x float>, metadata, metadata)
define <4 x float> @vfadd_vv_v4f32(<4 x float> %va, <4 x float> %vb) strictfp {
; CHECK-LABEL: vfadd_vv_v4f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %vc = call <4 x float> @llvm.experimental.constrained.fadd.v4f32(<4 x float> %va, <4 x float> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <4 x float> %vc
}

define <4 x float> @vfadd_vf_v4f32(<4 x float> %va, float %b) strictfp {
; CHECK-LABEL: vfadd_vf_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x float> poison, float %b, i32 0
  %splat = shufflevector <4 x float> %head, <4 x float> poison, <4 x i32> zeroinitializer
  %vc = call <4 x float> @llvm.experimental.constrained.fadd.v4f32(<4 x float> %va, <4 x float> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <4 x float> %vc
}

declare <8 x float> @llvm.experimental.constrained.fadd.v8f32(<8 x float>, <8 x float>, metadata, metadata)
define <8 x float> @vfadd_vv_v8f32(<8 x float> %va, <8 x float> %vb) strictfp {
; CHECK-LABEL: vfadd_vv_v8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %vc = call <8 x float> @llvm.experimental.constrained.fadd.v8f32(<8 x float> %va, <8 x float> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <8 x float> %vc
}

define <8 x float> @vfadd_vf_v8f32(<8 x float> %va, float %b) strictfp {
; CHECK-LABEL: vfadd_vf_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x float> poison, float %b, i32 0
  %splat = shufflevector <8 x float> %head, <8 x float> poison, <8 x i32> zeroinitializer
  %vc = call <8 x float> @llvm.experimental.constrained.fadd.v8f32(<8 x float> %va, <8 x float> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <8 x float> %vc
}

declare <16 x float> @llvm.experimental.constrained.fadd.v16f32(<16 x float>, <16 x float>, metadata, metadata)
define <16 x float> @vfadd_vv_v16f32(<16 x float> %va, <16 x float> %vb) strictfp {
; CHECK-LABEL: vfadd_vv_v16f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %vc = call <16 x float> @llvm.experimental.constrained.fadd.v16f32(<16 x float> %va, <16 x float> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <16 x float> %vc
}

define <16 x float> @vfadd_vf_v16f32(<16 x float> %va, float %b) strictfp {
; CHECK-LABEL: vfadd_vf_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <16 x float> poison, float %b, i32 0
  %splat = shufflevector <16 x float> %head, <16 x float> poison, <16 x i32> zeroinitializer
  %vc = call <16 x float> @llvm.experimental.constrained.fadd.v16f32(<16 x float> %va, <16 x float> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <16 x float> %vc
}

declare <2 x double> @llvm.experimental.constrained.fadd.v2f64(<2 x double>, <2 x double>, metadata, metadata)
define <2 x double> @vfadd_vv_v2f64(<2 x double> %va, <2 x double> %vb) strictfp {
; CHECK-LABEL: vfadd_vv_v2f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v9
; CHECK-NEXT:    ret
entry:
  %vc = call <2 x double> @llvm.experimental.constrained.fadd.v2f64(<2 x double> %va, <2 x double> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <2 x double> %vc
}

define <2 x double> @vfadd_vf_v2f64(<2 x double> %va, double %b) strictfp {
; CHECK-LABEL: vfadd_vf_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <2 x double> poison, double %b, i32 0
  %splat = shufflevector <2 x double> %head, <2 x double> poison, <2 x i32> zeroinitializer
  %vc = call <2 x double> @llvm.experimental.constrained.fadd.v2f64(<2 x double> %va, <2 x double> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <2 x double> %vc
}

declare <4 x double> @llvm.experimental.constrained.fadd.v4f64(<4 x double>, <4 x double>, metadata, metadata)
define <4 x double> @vfadd_vv_v4f64(<4 x double> %va, <4 x double> %vb) strictfp {
; CHECK-LABEL: vfadd_vv_v4f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v10
; CHECK-NEXT:    ret
entry:
  %vc = call <4 x double> @llvm.experimental.constrained.fadd.v4f64(<4 x double> %va, <4 x double> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <4 x double> %vc
}

define <4 x double> @vfadd_vf_v4f64(<4 x double> %va, double %b) strictfp {
; CHECK-LABEL: vfadd_vf_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <4 x double> poison, double %b, i32 0
  %splat = shufflevector <4 x double> %head, <4 x double> poison, <4 x i32> zeroinitializer
  %vc = call <4 x double> @llvm.experimental.constrained.fadd.v4f64(<4 x double> %va, <4 x double> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <4 x double> %vc
}

declare <8 x double> @llvm.experimental.constrained.fadd.v8f64(<8 x double>, <8 x double>, metadata, metadata)
define <8 x double> @vfadd_vv_v8f64(<8 x double> %va, <8 x double> %vb) strictfp {
; CHECK-LABEL: vfadd_vv_v8f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfadd.vv v8, v8, v12
; CHECK-NEXT:    ret
entry:
  %vc = call <8 x double> @llvm.experimental.constrained.fadd.v8f64(<8 x double> %va, <8 x double> %vb, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <8 x double> %vc
}

define <8 x double> @vfadd_vf_v8f64(<8 x double> %va, double %b) strictfp {
; CHECK-LABEL: vfadd_vf_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vfadd.vf v8, v8, fa0
; CHECK-NEXT:    ret
  %head = insertelement <8 x double> poison, double %b, i32 0
  %splat = shufflevector <8 x double> %head, <8 x double> poison, <8 x i32> zeroinitializer
  %vc = call <8 x double> @llvm.experimental.constrained.fadd.v8f64(<8 x double> %va, <8 x double> %splat, metadata !"round.dynamic", metadata !"fpexcept.ignore")
  ret <8 x double> %vc
}
