; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple=riscv32 -mattr=+m,+v,+zvfhmin,+zvfbfmin | FileCheck %s --check-prefixes=CHECK,V
; RUN: llc < %s -mtriple=riscv64 -mattr=+m,+v,+zvfhmin,+zvfbfmin | FileCheck %s --check-prefixes=CHECK,V
; RUN: llc < %s -mtriple=riscv64 -mattr=+m,+v,+zvfhmin,+zvfbfmin,+experimental-xrivosvizip | FileCheck %s --check-prefixes=CHECK,ZIP

; Integers

define {<vscale x 16 x i1>, <vscale x 16 x i1>} @vector_deinterleave_nxv16i1_nxv32i1(<vscale x 32 x i1> %vec) {
; V-LABEL: vector_deinterleave_nxv16i1_nxv32i1:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; V-NEXT:    vmv.v.i v10, 0
; V-NEXT:    csrr a0, vlenb
; V-NEXT:    vmerge.vim v8, v10, 1, v0
; V-NEXT:    srli a0, a0, 2
; V-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; V-NEXT:    vslidedown.vx v0, v0, a0
; V-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; V-NEXT:    vmerge.vim v10, v10, 1, v0
; V-NEXT:    vnsrl.wi v12, v8, 0
; V-NEXT:    vnsrl.wi v14, v8, 8
; V-NEXT:    vmsne.vi v0, v12, 0
; V-NEXT:    vmsne.vi v8, v14, 0
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv16i1_nxv32i1:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; ZIP-NEXT:    vmv.v.i v8, 0
; ZIP-NEXT:    csrr a0, vlenb
; ZIP-NEXT:    vmerge.vim v10, v8, 1, v0
; ZIP-NEXT:    srli a0, a0, 2
; ZIP-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; ZIP-NEXT:    vslidedown.vx v0, v0, a0
; ZIP-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; ZIP-NEXT:    vmerge.vim v8, v8, 1, v0
; ZIP-NEXT:    ri.vunzip2a.vv v12, v10, v8
; ZIP-NEXT:    ri.vunzip2b.vv v14, v10, v8
; ZIP-NEXT:    vmsne.vi v0, v12, 0
; ZIP-NEXT:    vmsne.vi v8, v14, 0
; ZIP-NEXT:    ret
%retval = call {<vscale x 16 x i1>, <vscale x 16 x i1>} @llvm.vector.deinterleave2.nxv32i1(<vscale x 32 x i1> %vec)
ret {<vscale x 16 x i1>, <vscale x 16 x i1>} %retval
}

define {<vscale x 16 x i8>, <vscale x 16 x i8>} @vector_deinterleave_nxv16i8_nxv32i8(<vscale x 32 x i8> %vec) {
; V-LABEL: vector_deinterleave_nxv16i8_nxv32i8:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; V-NEXT:    vnsrl.wi v12, v8, 0
; V-NEXT:    vnsrl.wi v14, v8, 8
; V-NEXT:    vmv.v.v v8, v12
; V-NEXT:    vmv.v.v v10, v14
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv16i8_nxv32i8:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v12, v8, v10
; ZIP-NEXT:    ri.vunzip2b.vv v14, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    vmv.v.v v10, v14
; ZIP-NEXT:    ret
%retval = call {<vscale x 16 x i8>, <vscale x 16 x i8>} @llvm.vector.deinterleave2.nxv32i8(<vscale x 32 x i8> %vec)
ret {<vscale x 16 x i8>, <vscale x 16 x i8>} %retval
}

define {<vscale x 8 x i16>, <vscale x 8 x i16>} @vector_deinterleave_nxv8i16_nxv16i16(<vscale x 16 x i16> %vec) {
; V-LABEL: vector_deinterleave_nxv8i16_nxv16i16:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; V-NEXT:    vnsrl.wi v12, v8, 0
; V-NEXT:    vnsrl.wi v14, v8, 16
; V-NEXT:    vmv.v.v v8, v12
; V-NEXT:    vmv.v.v v10, v14
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv8i16_nxv16i16:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v12, v8, v10
; ZIP-NEXT:    ri.vunzip2b.vv v14, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    vmv.v.v v10, v14
; ZIP-NEXT:    ret
%retval = call {<vscale x 8 x i16>, <vscale x 8 x i16>} @llvm.vector.deinterleave2.nxv16i16(<vscale x 16 x i16> %vec)
ret {<vscale x 8 x i16>, <vscale x 8 x i16>} %retval
}

define {<vscale x 4 x i32>, <vscale x 4 x i32>} @vector_deinterleave_nxv4i32_nxvv8i32(<vscale x 8 x i32> %vec) {
; V-LABEL: vector_deinterleave_nxv4i32_nxvv8i32:
; V:       # %bb.0:
; V-NEXT:    li a0, 32
; V-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; V-NEXT:    vnsrl.wx v12, v8, a0
; V-NEXT:    vnsrl.wi v14, v8, 0
; V-NEXT:    vmv.v.v v8, v14
; V-NEXT:    vmv.v.v v10, v12
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv4i32_nxvv8i32:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v12, v8, v10
; ZIP-NEXT:    ri.vunzip2b.vv v14, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    vmv.v.v v10, v14
; ZIP-NEXT:    ret
%retval = call {<vscale x 4 x i32>, <vscale x 4 x i32>} @llvm.vector.deinterleave2.nxv8i32(<vscale x 8 x i32> %vec)
ret {<vscale x 4 x i32>, <vscale x 4 x i32>} %retval
}

define {<vscale x 2 x i64>, <vscale x 2 x i64>} @vector_deinterleave_nxv2i64_nxv4i64(<vscale x 4 x i64> %vec) {
; V-LABEL: vector_deinterleave_nxv2i64_nxv4i64:
; V:       # %bb.0:
; V-NEXT:    li a0, 85
; V-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; V-NEXT:    vmv.v.x v16, a0
; V-NEXT:    li a0, 170
; V-NEXT:    vmv.v.x v20, a0
; V-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; V-NEXT:    vcompress.vm v12, v8, v16
; V-NEXT:    vcompress.vm v16, v8, v20
; V-NEXT:    vmv2r.v v8, v12
; V-NEXT:    vmv2r.v v10, v16
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv2i64_nxv4i64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v12, v8, v10
; ZIP-NEXT:    ri.vunzip2b.vv v14, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    vmv.v.v v10, v14
; ZIP-NEXT:    ret
%retval = call {<vscale x 2 x i64>, <vscale x 2 x i64>} @llvm.vector.deinterleave2.nxv4i64(<vscale x 4 x i64> %vec)
ret {<vscale x 2 x i64>, <vscale x 2 x i64>} %retval
}

define {<vscale x 4 x i64>, <vscale x 4 x i64>} @vector_deinterleave_nxv4i64_nxv8i64(<vscale x 8 x i64> %vec) {
; V-LABEL: vector_deinterleave_nxv4i64_nxv8i64:
; V:       # %bb.0:
; V-NEXT:    li a0, 85
; V-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; V-NEXT:    vmv.v.x v24, a0
; V-NEXT:    li a0, 170
; V-NEXT:    vmv.v.x v7, a0
; V-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; V-NEXT:    vcompress.vm v16, v8, v24
; V-NEXT:    vcompress.vm v24, v8, v7
; V-NEXT:    vmv4r.v v8, v16
; V-NEXT:    vmv4r.v v12, v24
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv4i64_nxv8i64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v16, v8, v12
; ZIP-NEXT:    ri.vunzip2b.vv v20, v8, v12
; ZIP-NEXT:    vmv.v.v v8, v16
; ZIP-NEXT:    vmv.v.v v12, v20
; ZIP-NEXT:    ret
%retval = call {<vscale x 4 x i64>, <vscale x 4 x i64>} @llvm.vector.deinterleave2.nxv8i64(<vscale x 8 x i64> %vec)
ret {<vscale x 4 x i64>, <vscale x 4 x i64>} %retval
}


define {<vscale x 64 x i1>, <vscale x 64 x i1>} @vector_deinterleave_nxv64i1_nxv128i1(<vscale x 128 x i1> %vec) {
; V-LABEL: vector_deinterleave_nxv64i1_nxv128i1:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; V-NEXT:    vmv.v.i v24, 0
; V-NEXT:    vmerge.vim v16, v24, 1, v0
; V-NEXT:    vmv1r.v v0, v8
; V-NEXT:    vmerge.vim v24, v24, 1, v0
; V-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; V-NEXT:    vnsrl.wi v8, v16, 0
; V-NEXT:    vnsrl.wi v0, v16, 8
; V-NEXT:    vnsrl.wi v12, v24, 0
; V-NEXT:    vnsrl.wi v4, v24, 8
; V-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; V-NEXT:    vmsne.vi v16, v8, 0
; V-NEXT:    vmsne.vi v8, v0, 0
; V-NEXT:    vmv1r.v v0, v16
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv64i1_nxv128i1:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; ZIP-NEXT:    vmv1r.v v9, v0
; ZIP-NEXT:    vmv1r.v v0, v8
; ZIP-NEXT:    vmv.v.i v24, 0
; ZIP-NEXT:    vmerge.vim v16, v24, 1, v0
; ZIP-NEXT:    vmv1r.v v0, v9
; ZIP-NEXT:    vmerge.vim v24, v24, 1, v0
; ZIP-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v12, v16, v20
; ZIP-NEXT:    ri.vunzip2b.vv v4, v16, v20
; ZIP-NEXT:    ri.vunzip2a.vv v8, v24, v28
; ZIP-NEXT:    ri.vunzip2b.vv v0, v24, v28
; ZIP-NEXT:    vsetvli a0, zero, e8, m8, ta, ma
; ZIP-NEXT:    vmsne.vi v16, v8, 0
; ZIP-NEXT:    vmsne.vi v8, v0, 0
; ZIP-NEXT:    vmv1r.v v0, v16
; ZIP-NEXT:    ret
%retval = call {<vscale x 64 x i1>, <vscale x 64 x i1>} @llvm.vector.deinterleave2.nxv128i1(<vscale x 128 x i1> %vec)
ret {<vscale x 64 x i1>, <vscale x 64 x i1>} %retval
}

define {<vscale x 64 x i8>, <vscale x 64 x i8>} @vector_deinterleave_nxv64i8_nxv128i8(<vscale x 128 x i8> %vec) {
; V-LABEL: vector_deinterleave_nxv64i8_nxv128i8:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; V-NEXT:    vmv8r.v v24, v8
; V-NEXT:    vnsrl.wi v8, v24, 0
; V-NEXT:    vnsrl.wi v0, v24, 8
; V-NEXT:    vnsrl.wi v12, v16, 0
; V-NEXT:    vnsrl.wi v4, v16, 8
; V-NEXT:    vmv8r.v v16, v0
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv64i8_nxv128i8:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e8, m4, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v28, v16, v20
; ZIP-NEXT:    ri.vunzip2b.vv v4, v16, v20
; ZIP-NEXT:    ri.vunzip2a.vv v24, v8, v12
; ZIP-NEXT:    ri.vunzip2b.vv v0, v8, v12
; ZIP-NEXT:    vmv8r.v v8, v24
; ZIP-NEXT:    vmv8r.v v16, v0
; ZIP-NEXT:    ret
%retval = call {<vscale x 64 x i8>, <vscale x 64 x i8>} @llvm.vector.deinterleave2.nxv128i8(<vscale x 128 x i8> %vec)
ret {<vscale x 64 x i8>, <vscale x 64 x i8>} %retval
}

define {<vscale x 32 x i16>, <vscale x 32 x i16>} @vector_deinterleave_nxv32i16_nxv64i16(<vscale x 64 x i16> %vec) {
; V-LABEL: vector_deinterleave_nxv32i16_nxv64i16:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; V-NEXT:    vmv8r.v v24, v8
; V-NEXT:    vnsrl.wi v8, v24, 0
; V-NEXT:    vnsrl.wi v0, v24, 16
; V-NEXT:    vnsrl.wi v12, v16, 0
; V-NEXT:    vnsrl.wi v4, v16, 16
; V-NEXT:    vmv8r.v v16, v0
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv32i16_nxv64i16:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v28, v16, v20
; ZIP-NEXT:    ri.vunzip2b.vv v4, v16, v20
; ZIP-NEXT:    ri.vunzip2a.vv v24, v8, v12
; ZIP-NEXT:    ri.vunzip2b.vv v0, v8, v12
; ZIP-NEXT:    vmv8r.v v8, v24
; ZIP-NEXT:    vmv8r.v v16, v0
; ZIP-NEXT:    ret
%retval = call {<vscale x 32 x i16>, <vscale x 32 x i16>} @llvm.vector.deinterleave2.nxv64i16(<vscale x 64 x i16> %vec)
ret {<vscale x 32 x i16>, <vscale x 32 x i16>} %retval
}

define {<vscale x 16 x i32>, <vscale x 16 x i32>} @vector_deinterleave_nxv16i32_nxvv32i32(<vscale x 32 x i32> %vec) {
; V-LABEL: vector_deinterleave_nxv16i32_nxvv32i32:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; V-NEXT:    vmv8r.v v24, v16
; V-NEXT:    li a0, 32
; V-NEXT:    vnsrl.wx v20, v24, a0
; V-NEXT:    vnsrl.wx v16, v8, a0
; V-NEXT:    vnsrl.wi v0, v8, 0
; V-NEXT:    vnsrl.wi v4, v24, 0
; V-NEXT:    vmv8r.v v8, v0
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv16i32_nxvv32i32:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v28, v16, v20
; ZIP-NEXT:    ri.vunzip2b.vv v4, v16, v20
; ZIP-NEXT:    ri.vunzip2a.vv v24, v8, v12
; ZIP-NEXT:    ri.vunzip2b.vv v0, v8, v12
; ZIP-NEXT:    vmv8r.v v8, v24
; ZIP-NEXT:    vmv8r.v v16, v0
; ZIP-NEXT:    ret
%retval = call {<vscale x 16 x i32>, <vscale x 16 x i32>} @llvm.vector.deinterleave2.nxv32i32(<vscale x 32 x i32> %vec)
ret {<vscale x 16 x i32>, <vscale x 16 x i32>} %retval
}

define {<vscale x 8 x i64>, <vscale x 8 x i64>} @vector_deinterleave_nxv8i64_nxv16i64(<vscale x 16 x i64> %vec) {
; V-LABEL: vector_deinterleave_nxv8i64_nxv16i64:
; V:       # %bb.0:
; V-NEXT:    addi sp, sp, -16
; V-NEXT:    .cfi_def_cfa_offset 16
; V-NEXT:    csrr a0, vlenb
; V-NEXT:    slli a0, a0, 4
; V-NEXT:    sub sp, sp, a0
; V-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x10, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 16 * vlenb
; V-NEXT:    li a0, 85
; V-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; V-NEXT:    vmv.v.x v7, a0
; V-NEXT:    li a0, 170
; V-NEXT:    vmv.v.x v6, a0
; V-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; V-NEXT:    vcompress.vm v24, v8, v7
; V-NEXT:    vmv1r.v v28, v7
; V-NEXT:    vmv1r.v v29, v6
; V-NEXT:    vcompress.vm v0, v8, v29
; V-NEXT:    vcompress.vm v8, v16, v28
; V-NEXT:    addi a0, sp, 16
; V-NEXT:    vs8r.v v8, (a0) # vscale x 64-byte Folded Spill
; V-NEXT:    vcompress.vm v8, v16, v29
; V-NEXT:    csrr a0, vlenb
; V-NEXT:    slli a0, a0, 3
; V-NEXT:    add a0, sp, a0
; V-NEXT:    addi a0, a0, 16
; V-NEXT:    vs8r.v v8, (a0) # vscale x 64-byte Folded Spill
; V-NEXT:    addi a0, sp, 16
; V-NEXT:    vl8r.v v8, (a0) # vscale x 64-byte Folded Reload
; V-NEXT:    vmv4r.v v28, v8
; V-NEXT:    csrr a0, vlenb
; V-NEXT:    slli a0, a0, 3
; V-NEXT:    add a0, sp, a0
; V-NEXT:    addi a0, a0, 16
; V-NEXT:    vl8r.v v8, (a0) # vscale x 64-byte Folded Reload
; V-NEXT:    vmv4r.v v4, v8
; V-NEXT:    vmv8r.v v8, v24
; V-NEXT:    vmv8r.v v16, v0
; V-NEXT:    csrr a0, vlenb
; V-NEXT:    slli a0, a0, 4
; V-NEXT:    add sp, sp, a0
; V-NEXT:    .cfi_def_cfa sp, 16
; V-NEXT:    addi sp, sp, 16
; V-NEXT:    .cfi_def_cfa_offset 0
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv8i64_nxv16i64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v28, v16, v20
; ZIP-NEXT:    ri.vunzip2b.vv v4, v16, v20
; ZIP-NEXT:    ri.vunzip2a.vv v24, v8, v12
; ZIP-NEXT:    ri.vunzip2b.vv v0, v8, v12
; ZIP-NEXT:    vmv8r.v v8, v24
; ZIP-NEXT:    vmv8r.v v16, v0
; ZIP-NEXT:    ret
%retval = call {<vscale x 8 x i64>, <vscale x 8 x i64>} @llvm.vector.deinterleave2.nxv16i64(<vscale x 16 x i64> %vec)
ret {<vscale x 8 x i64>, <vscale x 8 x i64>} %retval
}

define {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} @vector_deinterleave_nxv16i1_nxv48i1(<vscale x 48 x i1> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv16i1_nxv48i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v8, v0
; CHECK-NEXT:    vmv.v.i v10, 0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vmerge.vim v16, v10, 1, v0
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a1
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v18, v10, 1, v0
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v8, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v20, v10, 1, v0
; CHECK-NEXT:    vs8r.v v16, (a0)
; CHECK-NEXT:    vlseg3e8.v v8, (a0)
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    vmsne.vi v8, v10, 0
; CHECK-NEXT:    vmsne.vi v9, v12, 0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} @llvm.vector.deinterleave3.nxv48i1(<vscale x 48 x i1> %vec)
  ret {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} %retval
}


define {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} @vector_deinterleave_nxv16i8_nxv48i8(<vscale x 48 x i8> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv16i8_nxv48i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vlseg3e8.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} @llvm.vector.deinterleave3.nxv48i8(<vscale x 48 x i8> %vec)
  ret {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} %retval
}


define {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} @vector_deinterleave_nxv8i16_nxv24i16(<vscale x 24 x i16> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8i16_nxv24i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vlseg3e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} @llvm.vector.deinterleave3.nxv24i16(<vscale x 24 x i16> %vec)
  ret {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} %retval
}


define {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} @vector_deinterleave_nxv4i32_nxv12i32(<vscale x 12 x i32> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4i32_nxv12i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vlseg3e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} @llvm.vector.deinterleave3.nxv12i32(<vscale x 12 x i32> %vec)
  ret {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} %retval
}


define {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} @vector_deinterleave_nxv2i64_nxv6i64(<vscale x 6 x i64> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2i64_nxv6i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-NEXT:    vlseg3e64.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} @llvm.vector.deinterleave3.nxv6i64(<vscale x 6 x i64> %vec)
  ret {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} %retval
}

define {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} @vector_deinterleave_nxv16i1_nxv64i1(<vscale x 64 x i1> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv16i1_nxv64i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v8, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vmv.v.i v10, 0
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    sub a2, a0, a1
; CHECK-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a2
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    vsetvli a2, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v22, v10, 1, v0
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v8, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v20, v10, 1, v0
; CHECK-NEXT:    vmv1r.v v0, v8
; CHECK-NEXT:    vmerge.vim v16, v10, 1, v0
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v8, a1
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v18, v10, 1, v0
; CHECK-NEXT:    vs8r.v v16, (a0)
; CHECK-NEXT:    vlseg4e8.v v8, (a0)
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    vmsne.vi v8, v10, 0
; CHECK-NEXT:    vmsne.vi v9, v12, 0
; CHECK-NEXT:    vmsne.vi v10, v14, 0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} @llvm.vector.deinterleave4.nxv64i1(<vscale x 64 x i1> %vec)
  ret {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} %retval
}

define {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} @vector_deinterleave_nxv16i8_nxv64i8(<vscale x 64 x i8> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv16i8_nxv64i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vlseg4e8.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} @llvm.vector.deinterleave4.nxv48i8(<vscale x 64 x i8> %vec)
  ret {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} %retval
}

define {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} @vector_deinterleave_nxv8i16_nxv32i16(<vscale x 32 x i16> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8i16_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vlseg4e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} @llvm.vector.deinterleave4.nxv32i16(<vscale x 32 x i16> %vec)
  ret {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} %retval
}

define {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} @vector_deinterleave_nxv4i32_nxv16i32(<vscale x 16 x i32> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4i32_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vlseg4e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} @llvm.vector.deinterleave4.nxv16i32(<vscale x 16 x i32> %vec)
  ret {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} %retval
}

define {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} @vector_deinterleave_nxv2i64_nxv8i64(<vscale x 8 x i64> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2i64_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-NEXT:    vlseg4e64.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} @llvm.vector.deinterleave4.nxv8i64(<vscale x 8 x i64> %vec)
  ret {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} %retval
}

define {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} @vector_deinterleave_nxv16i1_nxv80i1(<vscale x 80 x i1> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv16i1_nxv80i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v9, v0
; CHECK-NEXT:    vmv.v.i v12, 0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vmerge.vim v16, v12, 1, v0
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a1
; CHECK-NEXT:    srli a2, a0, 1
; CHECK-NEXT:    vsetvli a3, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v18, v12, 1, v0
; CHECK-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v9, a2
; CHECK-NEXT:    sub a0, a0, a1
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v20, v12, 1, v0
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v9, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v14, v12, 1, v0
; CHECK-NEXT:    vmv1r.v v10, v15
; CHECK-NEXT:    vmv1r.v v0, v8
; CHECK-NEXT:    vmerge.vim v12, v12, 1, v0
; CHECK-NEXT:    vmv1r.v v11, v12
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v8, v21
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v9, v14
; CHECK-NEXT:    vs8r.v v16, (a0)
; CHECK-NEXT:    vmv1r.v v12, v13
; CHECK-NEXT:    vs8r.v v8, (a1)
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vlseg5e8.v v8, (a0)
; CHECK-NEXT:    vlseg5e8.v v14, (a1)
; CHECK-NEXT:    vmv2r.v v20, v8
; CHECK-NEXT:    vmv2r.v v22, v10
; CHECK-NEXT:    vmv1r.v v21, v14
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v20, 0
; CHECK-NEXT:    vmv1r.v v14, v9
; CHECK-NEXT:    vmsne.vi v8, v14, 0
; CHECK-NEXT:    vmv1r.v v23, v16
; CHECK-NEXT:    vmsne.vi v9, v22, 0
; CHECK-NEXT:    vmv1r.v v16, v11
; CHECK-NEXT:    vmsne.vi v10, v16, 0
; CHECK-NEXT:    vmv1r.v v13, v18
; CHECK-NEXT:    vmsne.vi v11, v12, 0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} @llvm.vector.deinterleave5.nxv80i1(<vscale x 80 x i1> %vec)
  ret {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} %retval
}


define {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} @vector_deinterleave_nxv16i8_nxv80i8(<vscale x 80 x i8> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv16i8_nxv80i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v26, v15
; CHECK-NEXT:    vmv1r.v v27, v16
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v24, v13
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v25, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v28, v17
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg5e8.v v12, (a0)
; CHECK-NEXT:    vlseg5e8.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v13
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v15
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} @llvm.vector.deinterleave5.nxv80i8(<vscale x 80 x i8> %vec)
  ret {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} %retval
}


define {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} @vector_deinterleave_nxv8i16_nxv40i16(<vscale x 40 x i16> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8i16_nxv40i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v26, v15
; CHECK-NEXT:    vmv1r.v v27, v16
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v24, v13
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v25, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v28, v17
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg5e16.v v12, (a0)
; CHECK-NEXT:    vlseg5e16.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v13
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v15
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} @llvm.vector.deinterleave5.nxv40i16(<vscale x 40 x i16> %vec)
  ret {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} %retval
}


define {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} @vector_deinterleave_nxv4i32_nxv20i32(<vscale x 20 x i32> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4i32_nxv20i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v26, v15
; CHECK-NEXT:    vmv1r.v v27, v16
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v24, v13
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v25, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v28, v17
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg5e32.v v12, (a0)
; CHECK-NEXT:    vlseg5e32.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v13
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v15
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} @llvm.vector.deinterleave5.nxv20i32(<vscale x 20 x i32> %vec)
  ret {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} %retval
}


define {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} @vector_deinterleave_nxv2i64_nxv10i64(<vscale x 10 x i64> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2i64_nxv10i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v26, v15
; CHECK-NEXT:    vmv1r.v v27, v16
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v24, v13
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v25, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v28, v17
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg5e64.v v12, (a0)
; CHECK-NEXT:    vlseg5e64.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v13
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v15
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} @llvm.vector.deinterleave5.nxv10i64(<vscale x 10 x i64> %vec)
  ret {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} %retval
}

define {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} @vector_deinterleave_nxv16i1_nxv96i1(<vscale x 96 x i1> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv16i1_nxv96i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v9, v0
; CHECK-NEXT:    vmv.v.i v10, 0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vmerge.vim v16, v10, 1, v0
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a1
; CHECK-NEXT:    srli a2, a0, 1
; CHECK-NEXT:    vsetvli a3, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v18, v10, 1, v0
; CHECK-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v9, a2
; CHECK-NEXT:    addi a2, sp, 16
; CHECK-NEXT:    sub a0, a0, a1
; CHECK-NEXT:    vsetvli a3, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v20, v10, 1, v0
; CHECK-NEXT:    vmv1r.v v0, v8
; CHECK-NEXT:    vmerge.vim v26, v10, 1, v0
; CHECK-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v9, a0
; CHECK-NEXT:    vs8r.v v16, (a2)
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v24, v10, 1, v0
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v8, a1
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v28, v10, 1, v0
; CHECK-NEXT:    vs8r.v v24, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vlseg6e8.v v16, (a2)
; CHECK-NEXT:    vlseg6e8.v v10, (a0)
; CHECK-NEXT:    vmv2r.v v8, v16
; CHECK-NEXT:    vmv2r.v v22, v18
; CHECK-NEXT:    vmv2r.v v24, v20
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    vmv1r.v v10, v17
; CHECK-NEXT:    vmsne.vi v8, v10, 0
; CHECK-NEXT:    vmv1r.v v23, v12
; CHECK-NEXT:    vmsne.vi v9, v22, 0
; CHECK-NEXT:    vmv1r.v v12, v19
; CHECK-NEXT:    vmsne.vi v10, v12, 0
; CHECK-NEXT:    vmv1r.v v25, v14
; CHECK-NEXT:    vmsne.vi v11, v24, 0
; CHECK-NEXT:    vmv1r.v v14, v21
; CHECK-NEXT:    vmsne.vi v12, v14, 0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} @llvm.vector.deinterleave6.nxv96i1(<vscale x 96 x i1> %vec)
  ret {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} %retval
}

define {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} @vector_deinterleave_nxv16i8_nxv96i8(<vscale x 96 x i8> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv16i8_nxv96i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv2r.v v28, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv2r.v v24, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv2r.v v26, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg6e8.v v24, (a0)
; CHECK-NEXT:    vlseg6e8.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v24
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v25
; CHECK-NEXT:    vmv2r.v v12, v26
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v27
; CHECK-NEXT:    vmv2r.v v16, v28
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv1r.v v22, v29
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    vmv2r.v v18, v22
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} @llvm.vector.deinterleave6.nxv96i8(<vscale x 96 x i8> %vec)
  ret {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} %retval
}

define {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} @vector_deinterleave_nxv8i16_nxv48i16(<vscale x 48 x i16> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8i16_nxv48i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv2r.v v28, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv2r.v v24, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv2r.v v26, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg6e16.v v24, (a0)
; CHECK-NEXT:    vlseg6e16.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v24
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v25
; CHECK-NEXT:    vmv2r.v v12, v26
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v27
; CHECK-NEXT:    vmv2r.v v16, v28
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv1r.v v22, v29
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    vmv2r.v v18, v22
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} @llvm.vector.deinterleave6.nxv48i16(<vscale x 48 x i16> %vec)
  ret {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} %retval
}

define {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} @vector_deinterleave_nxv4i32_nxv24i32(<vscale x 24 x i32> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4i32_nxv24i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv2r.v v28, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv2r.v v24, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv2r.v v26, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg6e32.v v24, (a0)
; CHECK-NEXT:    vlseg6e32.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v24
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v25
; CHECK-NEXT:    vmv2r.v v12, v26
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v27
; CHECK-NEXT:    vmv2r.v v16, v28
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv1r.v v22, v29
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    vmv2r.v v18, v22
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} @llvm.vector.deinterleave6.nxv24i32(<vscale x 24 x i32> %vec)
  ret {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} %retval
}

define {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} @vector_deinterleave_nxv2i64_nxv12i64(<vscale x 12 x i64> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2i64_nxv12i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmv2r.v v28, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv2r.v v24, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv2r.v v26, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg6e64.v v24, (a0)
; CHECK-NEXT:    vlseg6e64.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v24
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v25
; CHECK-NEXT:    vmv2r.v v12, v26
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v27
; CHECK-NEXT:    vmv2r.v v16, v28
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv1r.v v22, v29
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    vmv2r.v v18, v22
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} @llvm.vector.deinterleave6.nxv12i64(<vscale x 12 x i64> %vec)
  ret {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} %retval
}

define {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} @vector_deinterleave_nxv16i1_nxv112i1(<vscale x 112 x i1> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv16i1_nxv112i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v9, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vmv.v.i v12, 0
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    sub a2, a0, a1
; CHECK-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a2
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    vsetvli a2, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v22, v12, 1, v0
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v9, a0
; CHECK-NEXT:    vsetvli a2, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v20, v12, 1, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmerge.vim v16, v12, 1, v0
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v9, a1
; CHECK-NEXT:    vsetvli a2, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v18, v12, 1, v0
; CHECK-NEXT:    vmv1r.v v0, v8
; CHECK-NEXT:    vmerge.vim v14, v12, 1, v0
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v8, a1
; CHECK-NEXT:    vmv1r.v v10, v15
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v24, v12, 1, v0
; CHECK-NEXT:    vmv1r.v v11, v24
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v8, a0
; CHECK-NEXT:    vmv1r.v v8, v23
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v9, v14
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v14, v12, 1, v0
; CHECK-NEXT:    vmv1r.v v12, v25
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v13, v14
; CHECK-NEXT:    vs8r.v v16, (a0)
; CHECK-NEXT:    vmv1r.v v14, v15
; CHECK-NEXT:    vs8r.v v8, (a1)
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vlseg7e8.v v8, (a0)
; CHECK-NEXT:    vlseg7e8.v v16, (a1)
; CHECK-NEXT:    vmv2r.v v24, v8
; CHECK-NEXT:    vmv2r.v v26, v10
; CHECK-NEXT:    vmv2r.v v28, v12
; CHECK-NEXT:    vmv1r.v v25, v16
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v24, 0
; CHECK-NEXT:    vmv1r.v v16, v9
; CHECK-NEXT:    vmsne.vi v8, v16, 0
; CHECK-NEXT:    vmv1r.v v27, v18
; CHECK-NEXT:    vmsne.vi v9, v26, 0
; CHECK-NEXT:    vmv1r.v v18, v11
; CHECK-NEXT:    vmsne.vi v10, v18, 0
; CHECK-NEXT:    vmv1r.v v29, v20
; CHECK-NEXT:    vmsne.vi v11, v28, 0
; CHECK-NEXT:    vmv1r.v v20, v13
; CHECK-NEXT:    vmsne.vi v12, v20, 0
; CHECK-NEXT:    vmv1r.v v15, v22
; CHECK-NEXT:    vmsne.vi v13, v14, 0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} @llvm.vector.deinterleave7.nxv112i1(<vscale x 112 x i1> %vec)
  ret {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} %retval
}


define {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} @vector_deinterleave_nxv16i8_nxv112i8(<vscale x 112 x i8> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv16i8_nxv112i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v30, v21
; CHECK-NEXT:    vmv1r.v v28, v19
; CHECK-NEXT:    vmv1r.v v29, v20
; CHECK-NEXT:    vmv1r.v v26, v17
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v27, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v24, v15
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v25, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg7e8.v v14, (a0)
; CHECK-NEXT:    vlseg7e8.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v15
; CHECK-NEXT:    vmv2r.v v12, v16
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v17
; CHECK-NEXT:    vmv2r.v v16, v18
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v19
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} @llvm.vector.deinterleave7.nxv112i8(<vscale x 112 x i8> %vec)
  ret {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} %retval
}


define {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} @vector_deinterleave_nxv8i16_nxv56i16(<vscale x 56 x i16> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8i16_nxv56i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v30, v21
; CHECK-NEXT:    vmv1r.v v28, v19
; CHECK-NEXT:    vmv1r.v v29, v20
; CHECK-NEXT:    vmv1r.v v26, v17
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v27, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v24, v15
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v25, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg7e16.v v14, (a0)
; CHECK-NEXT:    vlseg7e16.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v15
; CHECK-NEXT:    vmv2r.v v12, v16
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v17
; CHECK-NEXT:    vmv2r.v v16, v18
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v19
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} @llvm.vector.deinterleave7.nxv56i16(<vscale x 56 x i16> %vec)
  ret {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} %retval
}


define {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} @vector_deinterleave_nxv4i32_nxv28i32(<vscale x 28 x i32> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4i32_nxv28i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v30, v21
; CHECK-NEXT:    vmv1r.v v28, v19
; CHECK-NEXT:    vmv1r.v v29, v20
; CHECK-NEXT:    vmv1r.v v26, v17
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v27, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v24, v15
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v25, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg7e32.v v14, (a0)
; CHECK-NEXT:    vlseg7e32.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v15
; CHECK-NEXT:    vmv2r.v v12, v16
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v17
; CHECK-NEXT:    vmv2r.v v16, v18
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v19
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} @llvm.vector.deinterleave7.nxv28i32(<vscale x 28 x i32> %vec)
  ret {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} %retval
}


define {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} @vector_deinterleave_nxv2i64_nxv14i64(<vscale x 14 x i64> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2i64_nxv14i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v30, v21
; CHECK-NEXT:    vmv1r.v v28, v19
; CHECK-NEXT:    vmv1r.v v29, v20
; CHECK-NEXT:    vmv1r.v v26, v17
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v27, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v24, v15
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v25, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg7e64.v v14, (a0)
; CHECK-NEXT:    vlseg7e64.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v15
; CHECK-NEXT:    vmv2r.v v12, v16
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v17
; CHECK-NEXT:    vmv2r.v v16, v18
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v19
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} @llvm.vector.deinterleave7.nxv14i64(<vscale x 14 x i64> %vec)
  ret {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} %retval
}

define {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} @vector_deinterleave_nxv16i1_nxv128i1(<vscale x 128 x i1> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv16i1_nxv128i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmv1r.v v9, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    vmv.v.i v10, 0
; CHECK-NEXT:    srli a1, a0, 2
; CHECK-NEXT:    sub a2, a0, a1
; CHECK-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v0, a2
; CHECK-NEXT:    srli a0, a0, 1
; CHECK-NEXT:    vsetvli a3, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v22, v10, 1, v0
; CHECK-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v9, a0
; CHECK-NEXT:    vsetvli a3, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v20, v10, 1, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmerge.vim v16, v10, 1, v0
; CHECK-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v9, a1
; CHECK-NEXT:    vsetvli a3, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v18, v10, 1, v0
; CHECK-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v8, a2
; CHECK-NEXT:    addi a2, sp, 16
; CHECK-NEXT:    vsetvli a3, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v30, v10, 1, v0
; CHECK-NEXT:    vsetvli a3, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v8, a0
; CHECK-NEXT:    vs8r.v v16, (a2)
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v28, v10, 1, v0
; CHECK-NEXT:    vmv1r.v v0, v8
; CHECK-NEXT:    vmerge.vim v24, v10, 1, v0
; CHECK-NEXT:    vsetvli a0, zero, e8, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v0, v8, a1
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmerge.vim v26, v10, 1, v0
; CHECK-NEXT:    vs8r.v v24, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vlseg8e8.v v18, (a2)
; CHECK-NEXT:    vlseg8e8.v v10, (a0)
; CHECK-NEXT:    vmv2r.v v8, v18
; CHECK-NEXT:    vmv2r.v v26, v20
; CHECK-NEXT:    vmv2r.v v28, v22
; CHECK-NEXT:    vmv2r.v v30, v24
; CHECK-NEXT:    vmv1r.v v9, v10
; CHECK-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; CHECK-NEXT:    vmsne.vi v0, v8, 0
; CHECK-NEXT:    vmv1r.v v10, v19
; CHECK-NEXT:    vmsne.vi v8, v10, 0
; CHECK-NEXT:    vmv1r.v v27, v12
; CHECK-NEXT:    vmsne.vi v9, v26, 0
; CHECK-NEXT:    vmv1r.v v12, v21
; CHECK-NEXT:    vmsne.vi v10, v12, 0
; CHECK-NEXT:    vmv1r.v v29, v14
; CHECK-NEXT:    vmsne.vi v11, v28, 0
; CHECK-NEXT:    vmv1r.v v14, v23
; CHECK-NEXT:    vmsne.vi v12, v14, 0
; CHECK-NEXT:    vmv1r.v v31, v16
; CHECK-NEXT:    vmsne.vi v13, v30, 0
; CHECK-NEXT:    vmv1r.v v16, v25
; CHECK-NEXT:    vmsne.vi v14, v16, 0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} @llvm.vector.deinterleave8.nxv128i1(<vscale x 128 x i1> %vec)
  ret {<vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>, <vscale x 16 x i1>} %retval
}

define {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} @vector_deinterleave_nxv16i8_nxv128i8(<vscale x 128 x i8> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv16i8_nxv128i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vs8r.v v16, (a1)
; CHECK-NEXT:    vsetvli a2, zero, e8, m1, ta, ma
; CHECK-NEXT:    vlseg8e8.v v0, (a0)
; CHECK-NEXT:    vlseg8e8.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v0
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v1
; CHECK-NEXT:    vmv2r.v v12, v2
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v3
; CHECK-NEXT:    vmv2r.v v16, v4
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v5
; CHECK-NEXT:    vmv2r.v v20, v6
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv1r.v v28, v7
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    vmv2r.v v22, v28
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} @llvm.vector.deinterleave8.nxv128i8(<vscale x 128 x i8> %vec)
  ret {<vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>, <vscale x 16 x i8>} %retval
}

define {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} @vector_deinterleave_nxv8i16_nxv64i16(<vscale x 64 x i16> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8i16_nxv64i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vs8r.v v16, (a1)
; CHECK-NEXT:    vsetvli a2, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg8e16.v v0, (a0)
; CHECK-NEXT:    vlseg8e16.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v0
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v1
; CHECK-NEXT:    vmv2r.v v12, v2
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v3
; CHECK-NEXT:    vmv2r.v v16, v4
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v5
; CHECK-NEXT:    vmv2r.v v20, v6
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv1r.v v28, v7
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    vmv2r.v v22, v28
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} @llvm.vector.deinterleave8.nxv64i16(<vscale x 64 x i16> %vec)
  ret {<vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>, <vscale x 8 x i16>} %retval
}

define {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} @vector_deinterleave_nxv4i32_nxv32i32(<vscale x 32 x i32> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4i32_nxv32i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vs8r.v v16, (a1)
; CHECK-NEXT:    vsetvli a2, zero, e32, m1, ta, ma
; CHECK-NEXT:    vlseg8e32.v v0, (a0)
; CHECK-NEXT:    vlseg8e32.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v0
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v1
; CHECK-NEXT:    vmv2r.v v12, v2
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v3
; CHECK-NEXT:    vmv2r.v v16, v4
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v5
; CHECK-NEXT:    vmv2r.v v20, v6
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv1r.v v28, v7
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    vmv2r.v v22, v28
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} @llvm.vector.deinterleave8.nxv32i32(<vscale x 32 x i32> %vec)
  ret {<vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>, <vscale x 4 x i32>} %retval
}

define {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} @vector_deinterleave_nxv2i64_nxv16i64(<vscale x 16 x i64> %vec) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2i64_nxv16i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vs8r.v v16, (a1)
; CHECK-NEXT:    vsetvli a2, zero, e64, m1, ta, ma
; CHECK-NEXT:    vlseg8e64.v v0, (a0)
; CHECK-NEXT:    vlseg8e64.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v0
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v1
; CHECK-NEXT:    vmv2r.v v12, v2
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v3
; CHECK-NEXT:    vmv2r.v v16, v4
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v5
; CHECK-NEXT:    vmv2r.v v20, v6
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv1r.v v28, v7
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    vmv2r.v v22, v28
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %retval = call {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} @llvm.vector.deinterleave8.nxv16i64(<vscale x 16 x i64> %vec)
  ret {<vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>, <vscale x 2 x i64>} %retval
}

; Floats

define {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @vector_deinterleave_nxv2bf16_nxv4bf16(<vscale x 4 x bfloat> %vec) {
; V-LABEL: vector_deinterleave_nxv2bf16_nxv4bf16:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; V-NEXT:    vnsrl.wi v10, v8, 0
; V-NEXT:    vnsrl.wi v9, v8, 16
; V-NEXT:    vmv1r.v v8, v10
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv2bf16_nxv4bf16:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v10, v8, v9
; ZIP-NEXT:    ri.vunzip2b.vv v9, v8, v11
; ZIP-NEXT:    vmv.v.v v8, v10
; ZIP-NEXT:    ret
%retval = call {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @llvm.vector.deinterleave2.nxv4bf16(<vscale x 4 x bfloat> %vec)
ret {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>} %retval
}

define {<vscale x 2 x half>, <vscale x 2 x half>} @vector_deinterleave_nxv2f16_nxv4f16(<vscale x 4 x half> %vec) {
; V-LABEL: vector_deinterleave_nxv2f16_nxv4f16:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e16, mf2, ta, ma
; V-NEXT:    vnsrl.wi v10, v8, 0
; V-NEXT:    vnsrl.wi v9, v8, 16
; V-NEXT:    vmv1r.v v8, v10
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv2f16_nxv4f16:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v10, v8, v9
; ZIP-NEXT:    ri.vunzip2b.vv v9, v8, v11
; ZIP-NEXT:    vmv.v.v v8, v10
; ZIP-NEXT:    ret
%retval = call {<vscale x 2 x half>, <vscale x 2 x half>} @llvm.vector.deinterleave2.nxv4f16(<vscale x 4 x half> %vec)
ret {<vscale x 2 x half>, <vscale x 2 x half>} %retval
}

define {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @vector_deinterleave_nxv4bf16_nxv8bf16(<vscale x 8 x bfloat> %vec) {
; V-LABEL: vector_deinterleave_nxv4bf16_nxv8bf16:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; V-NEXT:    vnsrl.wi v10, v8, 0
; V-NEXT:    vnsrl.wi v11, v8, 16
; V-NEXT:    vmv.v.v v8, v10
; V-NEXT:    vmv.v.v v9, v11
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv4bf16_nxv8bf16:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v10, v8, v9
; ZIP-NEXT:    ri.vunzip2b.vv v11, v8, v9
; ZIP-NEXT:    vmv.v.v v8, v10
; ZIP-NEXT:    vmv.v.v v9, v11
; ZIP-NEXT:    ret
%retval = call {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @llvm.vector.deinterleave2.nxv8bf16(<vscale x 8 x bfloat> %vec)
ret {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>} %retval
}

define {<vscale x 4 x half>, <vscale x 4 x half>} @vector_deinterleave_nxv4f16_nxv8f16(<vscale x 8 x half> %vec) {
; V-LABEL: vector_deinterleave_nxv4f16_nxv8f16:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; V-NEXT:    vnsrl.wi v10, v8, 0
; V-NEXT:    vnsrl.wi v11, v8, 16
; V-NEXT:    vmv.v.v v8, v10
; V-NEXT:    vmv.v.v v9, v11
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv4f16_nxv8f16:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v10, v8, v9
; ZIP-NEXT:    ri.vunzip2b.vv v11, v8, v9
; ZIP-NEXT:    vmv.v.v v8, v10
; ZIP-NEXT:    vmv.v.v v9, v11
; ZIP-NEXT:    ret
%retval = call {<vscale x 4 x half>, <vscale x 4 x half>} @llvm.vector.deinterleave2.nxv8f16(<vscale x 8 x half> %vec)
ret {<vscale x 4 x half>, <vscale x 4 x half>} %retval
}

define {<vscale x 2 x float>, <vscale x 2 x float>} @vector_deinterleave_nxv2f32_nxv4f32(<vscale x 4 x float> %vec) {
; V-LABEL: vector_deinterleave_nxv2f32_nxv4f32:
; V:       # %bb.0:
; V-NEXT:    li a0, 32
; V-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; V-NEXT:    vnsrl.wx v10, v8, a0
; V-NEXT:    vnsrl.wi v11, v8, 0
; V-NEXT:    vmv.v.v v8, v11
; V-NEXT:    vmv.v.v v9, v10
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv2f32_nxv4f32:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v10, v8, v9
; ZIP-NEXT:    ri.vunzip2b.vv v11, v8, v9
; ZIP-NEXT:    vmv.v.v v8, v10
; ZIP-NEXT:    vmv.v.v v9, v11
; ZIP-NEXT:    ret
%retval = call {<vscale x 2 x float>, <vscale x 2 x float>} @llvm.vector.deinterleave2.nxv4f32(<vscale x 4 x float> %vec)
ret {<vscale x 2 x float>, <vscale x 2 x float>} %retval
}

define {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @vector_deinterleave_nxv8bf16_nxv16bf16(<vscale x 16 x bfloat> %vec) {
; V-LABEL: vector_deinterleave_nxv8bf16_nxv16bf16:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; V-NEXT:    vnsrl.wi v12, v8, 0
; V-NEXT:    vnsrl.wi v14, v8, 16
; V-NEXT:    vmv.v.v v8, v12
; V-NEXT:    vmv.v.v v10, v14
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv8bf16_nxv16bf16:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v12, v8, v10
; ZIP-NEXT:    ri.vunzip2b.vv v14, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    vmv.v.v v10, v14
; ZIP-NEXT:    ret
%retval = call {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @llvm.vector.deinterleave2.nxv16bf16(<vscale x 16 x bfloat> %vec)
ret {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>} %retval
}

define {<vscale x 8 x half>, <vscale x 8 x half>} @vector_deinterleave_nxv8f16_nxv16f16(<vscale x 16 x half> %vec) {
; V-LABEL: vector_deinterleave_nxv8f16_nxv16f16:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; V-NEXT:    vnsrl.wi v12, v8, 0
; V-NEXT:    vnsrl.wi v14, v8, 16
; V-NEXT:    vmv.v.v v8, v12
; V-NEXT:    vmv.v.v v10, v14
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv8f16_nxv16f16:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v12, v8, v10
; ZIP-NEXT:    ri.vunzip2b.vv v14, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    vmv.v.v v10, v14
; ZIP-NEXT:    ret
%retval = call {<vscale x 8 x half>, <vscale x 8 x half>} @llvm.vector.deinterleave2.nxv16f16(<vscale x 16 x half> %vec)
ret {<vscale x 8 x half>, <vscale x 8 x half>} %retval
}

define {<vscale x 4 x float>, <vscale x 4 x float>} @vector_deinterleave_nxv4f32_nxv8f32(<vscale x 8 x float> %vec) {
; V-LABEL: vector_deinterleave_nxv4f32_nxv8f32:
; V:       # %bb.0:
; V-NEXT:    li a0, 32
; V-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; V-NEXT:    vnsrl.wx v12, v8, a0
; V-NEXT:    vnsrl.wi v14, v8, 0
; V-NEXT:    vmv.v.v v8, v14
; V-NEXT:    vmv.v.v v10, v12
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv4f32_nxv8f32:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v12, v8, v10
; ZIP-NEXT:    ri.vunzip2b.vv v14, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    vmv.v.v v10, v14
; ZIP-NEXT:    ret
%retval = call {<vscale x 4 x float>, <vscale x 4 x float>} @llvm.vector.deinterleave2.nxv8f32(<vscale x 8 x float> %vec)
ret  {<vscale x 4 x float>, <vscale x 4 x float>} %retval
}

define {<vscale x 2 x double>, <vscale x 2 x double>} @vector_deinterleave_nxv2f64_nxv4f64(<vscale x 4 x double> %vec) {
; V-LABEL: vector_deinterleave_nxv2f64_nxv4f64:
; V:       # %bb.0:
; V-NEXT:    li a0, 85
; V-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; V-NEXT:    vmv.v.x v16, a0
; V-NEXT:    li a0, 170
; V-NEXT:    vmv.v.x v20, a0
; V-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; V-NEXT:    vcompress.vm v12, v8, v16
; V-NEXT:    vcompress.vm v16, v8, v20
; V-NEXT:    vmv2r.v v8, v12
; V-NEXT:    vmv2r.v v10, v16
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv2f64_nxv4f64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v12, v8, v10
; ZIP-NEXT:    ri.vunzip2b.vv v14, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    vmv.v.v v10, v14
; ZIP-NEXT:    ret
%retval = call {<vscale x 2 x double>, <vscale x 2 x double>} @llvm.vector.deinterleave2.nxv4f64(<vscale x 4 x double> %vec)
ret {<vscale x 2 x double>, <vscale x 2 x double>} %retval
}


define {<vscale x 32 x bfloat>, <vscale x 32 x bfloat>} @vector_deinterleave_nxv32bf16_nxv64bf16(<vscale x 64 x bfloat> %vec) {
; V-LABEL: vector_deinterleave_nxv32bf16_nxv64bf16:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; V-NEXT:    vmv8r.v v24, v8
; V-NEXT:    vnsrl.wi v8, v24, 0
; V-NEXT:    vnsrl.wi v0, v24, 16
; V-NEXT:    vnsrl.wi v12, v16, 0
; V-NEXT:    vnsrl.wi v4, v16, 16
; V-NEXT:    vmv8r.v v16, v0
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv32bf16_nxv64bf16:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v28, v16, v20
; ZIP-NEXT:    ri.vunzip2b.vv v4, v16, v20
; ZIP-NEXT:    ri.vunzip2a.vv v24, v8, v12
; ZIP-NEXT:    ri.vunzip2b.vv v0, v8, v12
; ZIP-NEXT:    vmv8r.v v8, v24
; ZIP-NEXT:    vmv8r.v v16, v0
; ZIP-NEXT:    ret
%retval = call {<vscale x 32 x bfloat>, <vscale x 32 x bfloat>} @llvm.vector.deinterleave2.nxv64bf16(<vscale x 64 x bfloat> %vec)
ret {<vscale x 32 x bfloat>, <vscale x 32 x bfloat>} %retval
}

define {<vscale x 32 x half>, <vscale x 32 x half>} @vector_deinterleave_nxv32f16_nxv64f16(<vscale x 64 x half> %vec) {
; V-LABEL: vector_deinterleave_nxv32f16_nxv64f16:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; V-NEXT:    vmv8r.v v24, v8
; V-NEXT:    vnsrl.wi v8, v24, 0
; V-NEXT:    vnsrl.wi v0, v24, 16
; V-NEXT:    vnsrl.wi v12, v16, 0
; V-NEXT:    vnsrl.wi v4, v16, 16
; V-NEXT:    vmv8r.v v16, v0
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv32f16_nxv64f16:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v28, v16, v20
; ZIP-NEXT:    ri.vunzip2b.vv v4, v16, v20
; ZIP-NEXT:    ri.vunzip2a.vv v24, v8, v12
; ZIP-NEXT:    ri.vunzip2b.vv v0, v8, v12
; ZIP-NEXT:    vmv8r.v v8, v24
; ZIP-NEXT:    vmv8r.v v16, v0
; ZIP-NEXT:    ret
%retval = call {<vscale x 32 x half>, <vscale x 32 x half>} @llvm.vector.deinterleave2.nxv64f16(<vscale x 64 x half> %vec)
ret {<vscale x 32 x half>, <vscale x 32 x half>} %retval
}

define {<vscale x 16 x float>, <vscale x 16 x float>} @vector_deinterleave_nxv16f32_nxv32f32(<vscale x 32 x float> %vec) {
; V-LABEL: vector_deinterleave_nxv16f32_nxv32f32:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; V-NEXT:    vmv8r.v v24, v16
; V-NEXT:    li a0, 32
; V-NEXT:    vnsrl.wx v20, v24, a0
; V-NEXT:    vnsrl.wx v16, v8, a0
; V-NEXT:    vnsrl.wi v0, v8, 0
; V-NEXT:    vnsrl.wi v4, v24, 0
; V-NEXT:    vmv8r.v v8, v0
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv16f32_nxv32f32:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v28, v16, v20
; ZIP-NEXT:    ri.vunzip2b.vv v4, v16, v20
; ZIP-NEXT:    ri.vunzip2a.vv v24, v8, v12
; ZIP-NEXT:    ri.vunzip2b.vv v0, v8, v12
; ZIP-NEXT:    vmv8r.v v8, v24
; ZIP-NEXT:    vmv8r.v v16, v0
; ZIP-NEXT:    ret
%retval = call {<vscale x 16 x float>, <vscale x 16 x float>} @llvm.vector.deinterleave2.nxv32f32(<vscale x 32 x float> %vec)
ret  {<vscale x 16 x float>, <vscale x 16 x float>} %retval
}

define {<vscale x 8 x double>, <vscale x 8 x double>} @vector_deinterleave_nxv8f64_nxv16f64(<vscale x 16 x double> %vec) {
; V-LABEL: vector_deinterleave_nxv8f64_nxv16f64:
; V:       # %bb.0:
; V-NEXT:    addi sp, sp, -16
; V-NEXT:    .cfi_def_cfa_offset 16
; V-NEXT:    csrr a0, vlenb
; V-NEXT:    slli a0, a0, 4
; V-NEXT:    sub sp, sp, a0
; V-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x10, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 16 * vlenb
; V-NEXT:    li a0, 85
; V-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; V-NEXT:    vmv.v.x v7, a0
; V-NEXT:    li a0, 170
; V-NEXT:    vmv.v.x v6, a0
; V-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; V-NEXT:    vcompress.vm v24, v8, v7
; V-NEXT:    vmv1r.v v28, v7
; V-NEXT:    vmv1r.v v29, v6
; V-NEXT:    vcompress.vm v0, v8, v29
; V-NEXT:    vcompress.vm v8, v16, v28
; V-NEXT:    addi a0, sp, 16
; V-NEXT:    vs8r.v v8, (a0) # vscale x 64-byte Folded Spill
; V-NEXT:    vcompress.vm v8, v16, v29
; V-NEXT:    csrr a0, vlenb
; V-NEXT:    slli a0, a0, 3
; V-NEXT:    add a0, sp, a0
; V-NEXT:    addi a0, a0, 16
; V-NEXT:    vs8r.v v8, (a0) # vscale x 64-byte Folded Spill
; V-NEXT:    addi a0, sp, 16
; V-NEXT:    vl8r.v v8, (a0) # vscale x 64-byte Folded Reload
; V-NEXT:    vmv4r.v v28, v8
; V-NEXT:    csrr a0, vlenb
; V-NEXT:    slli a0, a0, 3
; V-NEXT:    add a0, sp, a0
; V-NEXT:    addi a0, a0, 16
; V-NEXT:    vl8r.v v8, (a0) # vscale x 64-byte Folded Reload
; V-NEXT:    vmv4r.v v4, v8
; V-NEXT:    vmv8r.v v8, v24
; V-NEXT:    vmv8r.v v16, v0
; V-NEXT:    csrr a0, vlenb
; V-NEXT:    slli a0, a0, 4
; V-NEXT:    add sp, sp, a0
; V-NEXT:    .cfi_def_cfa sp, 16
; V-NEXT:    addi sp, sp, 16
; V-NEXT:    .cfi_def_cfa_offset 0
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv8f64_nxv16f64:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v28, v16, v20
; ZIP-NEXT:    ri.vunzip2b.vv v4, v16, v20
; ZIP-NEXT:    ri.vunzip2a.vv v24, v8, v12
; ZIP-NEXT:    ri.vunzip2b.vv v0, v8, v12
; ZIP-NEXT:    vmv8r.v v8, v24
; ZIP-NEXT:    vmv8r.v v16, v0
; ZIP-NEXT:    ret
%retval = call {<vscale x 8 x double>, <vscale x 8 x double>} @llvm.vector.deinterleave2.nxv16f64(<vscale x 16 x double> %vec)
ret {<vscale x 8 x double>, <vscale x 8 x double>} %retval
}

define {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} @vector_deinterleave_nxv2f16_nxv6f16(<vscale x 6 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f16_nxv6f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v10, v8, a0
; CHECK-NEXT:    vslideup.vx v8, v10, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg3e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} @llvm.vector.deinterleave3.nxv6f16(<vscale x 6 x half> %arg)
  ret {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} %res
}

define {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} @vector_deinterleave_nxv4f16_nxv12f16(<vscale x 12 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4f16_nxv12f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg3e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} @llvm.vector.deinterleave3.nxv12f16(<vscale x 12 x half> %arg)
  ret {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} %res
}

define {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} @vector_deinterleave_nxv8f16_nxv24f16(<vscale x 24 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8f16_nxv24f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vlseg3e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} @llvm.vector.deinterleave3.nxv24f16(<vscale x 24 x half> %arg)
  ret {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} %res
}

define {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @vector_deinterleave_nxv2bf16_nxv6bf16(<vscale x 6 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2bf16_nxv6bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v10, v8, a0
; CHECK-NEXT:    vslideup.vx v8, v10, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg3e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @llvm.vector.deinterleave3.nxv6bf16(<vscale x 6 x bfloat> %arg)
  ret {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} %res
}

define {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @vector_deinterleave_nxv4bf16_nxv12bf16(<vscale x 12 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4bf16_nxv12bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg3e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @llvm.vector.deinterleave3.nxv12bf16(<vscale x 12 x bfloat> %arg)
  ret {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} %res
}

define {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @vector_deinterleave_nxv8bf16_nxv24bf16(<vscale x 24 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8bf16_nxv24bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vlseg3e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @llvm.vector.deinterleave3.nxv24bf16(<vscale x 24 x bfloat> %arg)
  ret {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} %res
}

define {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @vector_deinterleave_nxv1f32_nxv3f32(<vscale x 3 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f32_nxv3f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v10, v8, a0
; CHECK-NEXT:    vslideup.vx v8, v10, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg3e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @llvm.vector.deinterleave3.nxv3f32(<vscale x 3 x float> %arg)
  ret {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} %res
}

define {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} @vector_deinterleave_nxv2f32_nxv6f32(<vscale x 6 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f32_nxv6f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vlseg3e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} @llvm.vector.deinterleave3.nxv6f32(<vscale x 6 x float> %arg)
  ret {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} %res
}

define {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} @vector_deinterleave_nxv4f32_nxv12f32(<vscale x 12 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4f32_nxv12f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vlseg3e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} @llvm.vector.deinterleave3.nxv12f32(<vscale x 12 x float> %arg)
  ret {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} %res
}

define {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} @vector_deinterleave_nxv1f64_nxv3f64(<vscale x 3 x double> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f64_nxv3f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vlseg3e64.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} @llvm.vector.deinterleave3.nxv3f64(<vscale x 3 x double> %arg)
  ret {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} %res
}

define {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} @vector_deinterleave_nxv2f64_nxv6f64(<vscale x 6 x double> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f64_nxv6f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-NEXT:    vlseg3e64.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} @llvm.vector.deinterleave3.nxv6f64(<vscale x 6 x double> %arg)
  ret {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} %res
}

define {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} @vector_deinterleave_nxv2f16_nxv8f16(<vscale x 8 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f16_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg4e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} @llvm.vector.deinterleave4.nxv8f16(<vscale x 8 x half> %arg)
  ret {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} %res
}

define {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} @vector_deinterleave_nxv4f16_nxv16f16(<vscale x 16 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4f16_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg4e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} @llvm.vector.deinterleave4.nxv16f16(<vscale x 16 x half> %arg)
  ret {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} %res
}

define {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} @vector_deinterleave_nxv8f16_nxv32f16(<vscale x 32 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8f16_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vlseg4e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} @llvm.vector.deinterleave4.nxv32f16(<vscale x 32 x half> %arg)
  ret {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} %res
}

define {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @vector_deinterleave_nxv2bf16_nxv8bf16(<vscale x 8 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2bf16_nxv8bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg4e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @llvm.vector.deinterleave4.nxv8bf16(<vscale x 8 x bfloat> %arg)
  ret {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} %res
}

define {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @vector_deinterleave_nxv4bf16_nxv16bf16(<vscale x 16 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4bf16_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg4e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @llvm.vector.deinterleave4.nxv16bf16(<vscale x 16 x bfloat> %arg)
  ret {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} %res
}

define {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @vector_deinterleave_nxv8bf16_nxv32bf16(<vscale x 32 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8bf16_nxv32bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vlseg4e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @llvm.vector.deinterleave4.nxv32bf16(<vscale x 32 x bfloat> %arg)
  ret {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} %res
}

define {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @vector_deinterleave_nxv1f32_nxv4f32(<vscale x 4 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f32_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg4e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @llvm.vector.deinterleave4.nxv4f32(<vscale x 4 x float> %arg)
  ret {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} %res
}

define {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} @vector_deinterleave_nxv2f32_nxv8f32(<vscale x 8 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f32_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vlseg4e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} @llvm.vector.deinterleave4.nxv6f32(<vscale x 8 x float> %arg)
  ret {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} %res
}

define {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} @vector_deinterleave_nxv4f32_nxv16f32(<vscale x 16 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4f32_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vlseg4e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} @llvm.vector.deinterleave4.nxv16f32(<vscale x 16 x float> %arg)
  ret {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} %res
}

define {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} @vector_deinterleave_nxv1f64_nxv4f64(<vscale x 4 x double> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f64_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vlseg4e64.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} @llvm.vector.deinterleave4.nxv4f64(<vscale x 4 x double> %arg)
  ret {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} %res
}

define {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} @vector_deinterleave_nxv2f64_nxv8f64(<vscale x 8 x double> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f64_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-NEXT:    vlseg4e64.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} @llvm.vector.deinterleave4.nxv8f64(<vscale x 8 x double> %arg)
  ret {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} %res
}

define {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} @vector_deinterleave_nxv2f16_nxv10f16(<vscale x 10 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f16_nxv10f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v11, v9, a0
; CHECK-NEXT:    vslideup.vx v9, v11, a0
; CHECK-NEXT:    vslidedown.vx v11, v8, a0
; CHECK-NEXT:    vslideup.vx v8, v11, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg5e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} @llvm.vector.deinterleave5.nxv10f16(<vscale x 10 x half> %arg)
  ret {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} %res
}

define {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} @vector_deinterleave_nxv4f16_nxv20f16(<vscale x 20 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4f16_nxv20f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg5e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} @llvm.vector.deinterleave5.nxv20f16(<vscale x 20 x half> %arg)
  ret {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} %res
}

define {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} @vector_deinterleave_nxv8f16_nxv40f16(<vscale x 40 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8f16_nxv40f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v26, v15
; CHECK-NEXT:    vmv1r.v v27, v16
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v24, v13
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v25, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v28, v17
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg5e16.v v12, (a0)
; CHECK-NEXT:    vlseg5e16.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v13
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v15
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} @llvm.vector.deinterleave5.nxv40f16(<vscale x 40 x half> %arg)
  ret {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} %res
}

define {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @vector_deinterleave_nxv2bf16_nxv10bf16(<vscale x 10 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2bf16_nxv10bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v11, v9, a0
; CHECK-NEXT:    vslideup.vx v9, v11, a0
; CHECK-NEXT:    vslidedown.vx v11, v8, a0
; CHECK-NEXT:    vslideup.vx v8, v11, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg5e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @llvm.vector.deinterleave5.nxv10bf16(<vscale x 10 x bfloat> %arg)
  ret {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} %res
}

define {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @vector_deinterleave_nxv4bf16_nxv20bf16(<vscale x 20 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4bf16_nxv20bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg5e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @llvm.vector.deinterleave5.nxv20bf16(<vscale x 20 x bfloat> %arg)
  ret {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} %res
}

define {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @vector_deinterleave_nxv8bf16_nxv40bf16(<vscale x 40 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8bf16_nxv40bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v26, v15
; CHECK-NEXT:    vmv1r.v v27, v16
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v24, v13
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v25, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v28, v17
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg5e16.v v12, (a0)
; CHECK-NEXT:    vlseg5e16.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v13
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v15
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @llvm.vector.deinterleave5.nxv40bf16(<vscale x 40 x bfloat> %arg)
  ret {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} %res
}

define {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @vector_deinterleave_nxv1f32_nxv5f32(<vscale x 5 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f32_nxv5f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v11, v9, a0
; CHECK-NEXT:    vslideup.vx v9, v11, a0
; CHECK-NEXT:    vslidedown.vx v11, v8, a0
; CHECK-NEXT:    vslideup.vx v8, v11, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg5e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @llvm.vector.deinterleave5.nxv5f32(<vscale x 5 x float> %arg)
  ret {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} %res
}

define {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} @vector_deinterleave_nxv2f32_nxv10f32(<vscale x 10 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f32_nxv10f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vlseg5e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} @llvm.vector.deinterleave5.nxv10f32(<vscale x 10 x float> %arg)
  ret {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} %res
}

define {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} @vector_deinterleave_nxv4f32_nxv20f32(<vscale x 20 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4f32_nxv20f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v26, v15
; CHECK-NEXT:    vmv1r.v v27, v16
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v24, v13
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v25, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v28, v17
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg5e32.v v12, (a0)
; CHECK-NEXT:    vlseg5e32.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v13
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v15
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} @llvm.vector.deinterleave5.nxv20f32(<vscale x 20 x float> %arg)
  ret {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} %res
}

define {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} @vector_deinterleave_nxv1f64_nxv5f64(<vscale x 5 x double> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f64_nxv5f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vlseg5e64.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} @llvm.vector.deinterleave5.nxv5f64(<vscale x 5 x double> %arg)
  ret {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} %res
}

define {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} @vector_deinterleave_nxv2f64_nxv10f64(<vscale x 10 x double> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f64_nxv10f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v26, v15
; CHECK-NEXT:    vmv1r.v v27, v16
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v24, v13
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v25, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v28, v17
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg5e64.v v12, (a0)
; CHECK-NEXT:    vlseg5e64.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v12
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v13
; CHECK-NEXT:    vmv2r.v v12, v14
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v15
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} @llvm.vector.deinterleave5.nxv10f64(<vscale x 10 x double> %arg)
  ret {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} %res
}

define {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} @vector_deinterleave_nxv2f16_nxv12f16(<vscale x 12 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f16_nxv12f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v11, v9, a0
; CHECK-NEXT:    vslideup.vx v9, v11, a0
; CHECK-NEXT:    vslidedown.vx v11, v8, a0
; CHECK-NEXT:    vslideup.vx v8, v11, a0
; CHECK-NEXT:    vslidedown.vx v11, v10, a0
; CHECK-NEXT:    vslideup.vx v10, v11, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg6e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} @llvm.vector.deinterleave6.nxv12f16(<vscale x 12 x half> %arg)
  ret {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} %res
}

define {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} @vector_deinterleave_nxv4f16_nxv24f16(<vscale x 24 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4f16_nxv24f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg6e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} @llvm.vector.deinterleave6.nxv24f16(<vscale x 24 x half> %arg)
  ret {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} %res
}

define {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} @vector_deinterleave_nxv8f16_nxv48f16(<vscale x 48 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8f16_nxv48f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv2r.v v28, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv2r.v v24, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv2r.v v26, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg6e16.v v24, (a0)
; CHECK-NEXT:    vlseg6e16.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v24
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v25
; CHECK-NEXT:    vmv2r.v v12, v26
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v27
; CHECK-NEXT:    vmv2r.v v16, v28
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv1r.v v22, v29
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    vmv2r.v v18, v22
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} @llvm.vector.deinterleave6.nxv48f16(<vscale x 48 x half> %arg)
  ret {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} %res
}

define {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @vector_deinterleave_nxv2bf16_nxv12bf16(<vscale x 12 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2bf16_nxv12bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v11, v9, a0
; CHECK-NEXT:    vslideup.vx v9, v11, a0
; CHECK-NEXT:    vslidedown.vx v11, v8, a0
; CHECK-NEXT:    vslideup.vx v8, v11, a0
; CHECK-NEXT:    vslidedown.vx v11, v10, a0
; CHECK-NEXT:    vslideup.vx v10, v11, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg6e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @llvm.vector.deinterleave6.nxv12bf16(<vscale x 12 x bfloat> %arg)
  ret {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} %res
}

define {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @vector_deinterleave_nxv4bf16_nxv24bf16(<vscale x 24 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4bf16_nxv24bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg6e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @llvm.vector.deinterleave6.nxv24bf16(<vscale x 24 x bfloat> %arg)
  ret {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} %res
}

define {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @vector_deinterleave_nxv8bf16_nxv48bf16(<vscale x 48 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8bf16_nxv48bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv2r.v v28, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv2r.v v24, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv2r.v v26, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg6e16.v v24, (a0)
; CHECK-NEXT:    vlseg6e16.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v24
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v25
; CHECK-NEXT:    vmv2r.v v12, v26
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v27
; CHECK-NEXT:    vmv2r.v v16, v28
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv1r.v v22, v29
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    vmv2r.v v18, v22
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @llvm.vector.deinterleave6.nxv48bf16(<vscale x 48 x bfloat> %arg)
  ret {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} %res
}

define {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @vector_deinterleave_nxv1f32_nxv6f32(<vscale x 6 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f32_nxv6f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v11, v9, a0
; CHECK-NEXT:    vslideup.vx v9, v11, a0
; CHECK-NEXT:    vslidedown.vx v11, v8, a0
; CHECK-NEXT:    vslideup.vx v8, v11, a0
; CHECK-NEXT:    vslidedown.vx v11, v10, a0
; CHECK-NEXT:    vslideup.vx v10, v11, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg6e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @llvm.vector.deinterleave6.nxv6f32(<vscale x 6 x float> %arg)
  ret {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} %res
}

define {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} @vector_deinterleave_nxv2f32_nxv12f32(<vscale x 12 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f32_nxv12f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vlseg6e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} @llvm.vector.deinterleave6.nxv12f32(<vscale x 12 x float> %arg)
  ret {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} %res
}

define {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} @vector_deinterleave_nxv4f32_nxv24f32(<vscale x 24 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4f32_nxv24f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv2r.v v28, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv2r.v v24, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv2r.v v26, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg6e32.v v24, (a0)
; CHECK-NEXT:    vlseg6e32.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v24
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v25
; CHECK-NEXT:    vmv2r.v v12, v26
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v27
; CHECK-NEXT:    vmv2r.v v16, v28
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv1r.v v22, v29
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    vmv2r.v v18, v22
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} @llvm.vector.deinterleave6.nxv24f32(<vscale x 24 x float> %arg)
  ret {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} %res
}

define {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} @vector_deinterleave_nxv1f64_nxv6f64(<vscale x 6 x double> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f64_nxv6f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vlseg6e64.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} @llvm.vector.deinterleave6.nxv6f64(<vscale x 6 x double> %arg)
  ret {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} %res
}

define {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} @vector_deinterleave_nxv2f64_nxv12f64(<vscale x 12 x double> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f64_nxv12f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmv2r.v v28, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv2r.v v24, v14
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv2r.v v26, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg6e64.v v24, (a0)
; CHECK-NEXT:    vlseg6e64.v v18, (a1)
; CHECK-NEXT:    vmv2r.v v8, v24
; CHECK-NEXT:    vmv1r.v v9, v18
; CHECK-NEXT:    vmv1r.v v18, v25
; CHECK-NEXT:    vmv2r.v v12, v26
; CHECK-NEXT:    vmv1r.v v13, v20
; CHECK-NEXT:    vmv1r.v v20, v27
; CHECK-NEXT:    vmv2r.v v16, v28
; CHECK-NEXT:    vmv1r.v v17, v22
; CHECK-NEXT:    vmv1r.v v22, v29
; CHECK-NEXT:    vmv2r.v v10, v18
; CHECK-NEXT:    vmv2r.v v14, v20
; CHECK-NEXT:    vmv2r.v v18, v22
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} @llvm.vector.deinterleave6.nxv12f64(<vscale x 12 x double> %arg)
  ret {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} %res
}

define {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} @vector_deinterleave_nxv2f16_nxv14f16(<vscale x 14 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f16_nxv14f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v12, v9, a0
; CHECK-NEXT:    vslideup.vx v9, v12, a0
; CHECK-NEXT:    vslidedown.vx v12, v8, a0
; CHECK-NEXT:    vslideup.vx v8, v12, a0
; CHECK-NEXT:    vslidedown.vx v12, v10, a0
; CHECK-NEXT:    vslideup.vx v10, v12, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg7e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} @llvm.vector.deinterleave7.nxv14f16(<vscale x 14 x half> %arg)
  ret {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} %res
}

define {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} @vector_deinterleave_nxv4f16_nxv28f16(<vscale x 28 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4f16_nxv28f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg7e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} @llvm.vector.deinterleave7.nxv28f16(<vscale x 28 x half> %arg)
  ret {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} %res
}

define {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} @vector_deinterleave_nxv8f16_nxv56f16(<vscale x 56 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8f16_nxv56f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v30, v21
; CHECK-NEXT:    vmv1r.v v28, v19
; CHECK-NEXT:    vmv1r.v v29, v20
; CHECK-NEXT:    vmv1r.v v26, v17
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v27, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v24, v15
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v25, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg7e16.v v14, (a0)
; CHECK-NEXT:    vlseg7e16.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v15
; CHECK-NEXT:    vmv2r.v v12, v16
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v17
; CHECK-NEXT:    vmv2r.v v16, v18
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v19
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} @llvm.vector.deinterleave7.nxv56f16(<vscale x 56 x half> %arg)
  ret {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} %res
}

define {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @vector_deinterleave_nxv2bf16_nxv14bf16(<vscale x 14 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2bf16_nxv14bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    srli a0, a0, 2
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v12, v9, a0
; CHECK-NEXT:    vslideup.vx v9, v12, a0
; CHECK-NEXT:    vslidedown.vx v12, v8, a0
; CHECK-NEXT:    vslideup.vx v8, v12, a0
; CHECK-NEXT:    vslidedown.vx v12, v10, a0
; CHECK-NEXT:    vslideup.vx v10, v12, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg7e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @llvm.vector.deinterleave7.nxv14bf16(<vscale x 14 x bfloat> %arg)
  ret {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} %res
}

define {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @vector_deinterleave_nxv4bf16_nxv28bf16(<vscale x 28 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4bf16_nxv28bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg7e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @llvm.vector.deinterleave7.nxv28bf16(<vscale x 28 x bfloat> %arg)
  ret {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} %res
}

define {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @vector_deinterleave_nxv8bf16_nxv56bf16(<vscale x 56 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8bf16_nxv56bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v30, v21
; CHECK-NEXT:    vmv1r.v v28, v19
; CHECK-NEXT:    vmv1r.v v29, v20
; CHECK-NEXT:    vmv1r.v v26, v17
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v27, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v24, v15
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v25, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg7e16.v v14, (a0)
; CHECK-NEXT:    vlseg7e16.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v15
; CHECK-NEXT:    vmv2r.v v12, v16
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v17
; CHECK-NEXT:    vmv2r.v v16, v18
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v19
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @llvm.vector.deinterleave7.nxv56bf16(<vscale x 56 x bfloat> %arg)
  ret {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} %res
}

define {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @vector_deinterleave_nxv1f32_nxv7f32(<vscale x 7 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f32_nxv7f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    srli a0, a0, 3
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vslidedown.vx v12, v9, a0
; CHECK-NEXT:    vslideup.vx v9, v12, a0
; CHECK-NEXT:    vslidedown.vx v12, v8, a0
; CHECK-NEXT:    vslideup.vx v8, v12, a0
; CHECK-NEXT:    vslidedown.vx v12, v10, a0
; CHECK-NEXT:    vslideup.vx v10, v12, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg7e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @llvm.vector.deinterleave7.nxv7f32(<vscale x 7 x float> %arg)
  ret {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} %res
}

define {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} @vector_deinterleave_nxv2f32_nxv14f32(<vscale x 14 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f32_nxv14f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vlseg7e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} @llvm.vector.deinterleave7.nxv14f32(<vscale x 14 x float> %arg)
  ret {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} %res
}

define {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} @vector_deinterleave_nxv4f32_nxv28f32(<vscale x 28 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4f32_nxv28f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v30, v21
; CHECK-NEXT:    vmv1r.v v28, v19
; CHECK-NEXT:    vmv1r.v v29, v20
; CHECK-NEXT:    vmv1r.v v26, v17
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v27, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v24, v15
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v25, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg7e32.v v14, (a0)
; CHECK-NEXT:    vlseg7e32.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v15
; CHECK-NEXT:    vmv2r.v v12, v16
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v17
; CHECK-NEXT:    vmv2r.v v16, v18
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v19
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} @llvm.vector.deinterleave7.nxv28f32(<vscale x 28 x float> %arg)
  ret {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} %res
}

define {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} @vector_deinterleave_nxv1f64_nxv7f64(<vscale x 7 x double> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f64_nxv7f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vlseg7e64.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} @llvm.vector.deinterleave7.nxv7f64(<vscale x 7 x double> %arg)
  ret {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} %res
}

define {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} @vector_deinterleave_nxv2f64_nxv14f64(<vscale x 14 x double> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f64_nxv14f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    vsetvli a0, zero, e64, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v30, v21
; CHECK-NEXT:    vmv1r.v v28, v19
; CHECK-NEXT:    vmv1r.v v29, v20
; CHECK-NEXT:    vmv1r.v v26, v17
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vmv1r.v v27, v18
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vmv1r.v v24, v15
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vmv1r.v v25, v16
; CHECK-NEXT:    vs8r.v v24, (a1)
; CHECK-NEXT:    vlseg7e64.v v14, (a0)
; CHECK-NEXT:    vlseg7e64.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v14
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v15
; CHECK-NEXT:    vmv2r.v v12, v16
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v17
; CHECK-NEXT:    vmv2r.v v16, v18
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v19
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} @llvm.vector.deinterleave7.nxv14f64(<vscale x 14 x double> %arg)
  ret {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} %res
}

define {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} @vector_deinterleave_nxv2f16_nxv16f16(<vscale x 16 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f16_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg8e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} @llvm.vector.deinterleave8.nxv16f16(<vscale x 16 x half> %arg)
  ret {<vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>, <vscale x 2 x half>} %res
}

define {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} @vector_deinterleave_nxv4f16_nxv32f16(<vscale x 32 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4f16_nxv32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg8e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} @llvm.vector.deinterleave8.nxv32f16(<vscale x 32 x half> %arg)
  ret {<vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>, <vscale x 4 x half>} %res
}

define {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} @vector_deinterleave_nxv8f16_nxv64f16(<vscale x 64 x half> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8f16_nxv64f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vs8r.v v16, (a1)
; CHECK-NEXT:    vsetvli a2, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg8e16.v v0, (a0)
; CHECK-NEXT:    vlseg8e16.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v0
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v1
; CHECK-NEXT:    vmv2r.v v12, v2
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v3
; CHECK-NEXT:    vmv2r.v v16, v4
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v5
; CHECK-NEXT:    vmv2r.v v20, v6
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv1r.v v28, v7
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    vmv2r.v v22, v28
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} @llvm.vector.deinterleave8.nxv64f16(<vscale x 64 x half> %arg)
  ret {<vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>, <vscale x 8 x half>} %res
}

define {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @vector_deinterleave_nxv2bf16_nxv16bf16(<vscale x 16 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2bf16_nxv16bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vlseg8e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} @llvm.vector.deinterleave8.nxv16bf16(<vscale x 16 x bfloat> %arg)
  ret {<vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>, <vscale x 2 x bfloat>} %res
}

define {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @vector_deinterleave_nxv4bf16_nxv32bf16(<vscale x 32 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4bf16_nxv32bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg8e16.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} @llvm.vector.deinterleave8.nxv32bf16(<vscale x 32 x bfloat> %arg)
  ret {<vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>, <vscale x 4 x bfloat>} %res
}

define {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @vector_deinterleave_nxv8bf16_nxv64bf16(<vscale x 64 x bfloat> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv8bf16_nxv64bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vs8r.v v16, (a1)
; CHECK-NEXT:    vsetvli a2, zero, e16, m1, ta, ma
; CHECK-NEXT:    vlseg8e16.v v0, (a0)
; CHECK-NEXT:    vlseg8e16.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v0
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v1
; CHECK-NEXT:    vmv2r.v v12, v2
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v3
; CHECK-NEXT:    vmv2r.v v16, v4
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v5
; CHECK-NEXT:    vmv2r.v v20, v6
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv1r.v v28, v7
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    vmv2r.v v22, v28
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} @llvm.vector.deinterleave8.nxv64bf16(<vscale x 64 x bfloat> %arg)
  ret {<vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>, <vscale x 8 x bfloat>} %res
}

define {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @vector_deinterleave_nxv1f32_nxv8f32(<vscale x 8 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f32_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg8e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @llvm.vector.deinterleave8.nxv8f32(<vscale x 8 x float> %arg)
  ret {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} %res
}

define {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} @vector_deinterleave_nxv2f32_nxv16f32(<vscale x 16 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f32_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vlseg8e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} @llvm.vector.deinterleave8.nxv16f32(<vscale x 16 x float> %arg)
  ret {<vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>, <vscale x 2 x float>} %res
}

define {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} @vector_deinterleave_nxv4f32_nxv32f32(<vscale x 32 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv4f32_nxv32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vs8r.v v16, (a1)
; CHECK-NEXT:    vsetvli a2, zero, e32, m1, ta, ma
; CHECK-NEXT:    vlseg8e32.v v0, (a0)
; CHECK-NEXT:    vlseg8e32.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v0
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v1
; CHECK-NEXT:    vmv2r.v v12, v2
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v3
; CHECK-NEXT:    vmv2r.v v16, v4
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v5
; CHECK-NEXT:    vmv2r.v v20, v6
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv1r.v v28, v7
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    vmv2r.v v22, v28
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} @llvm.vector.deinterleave8.nxv32f32(<vscale x 32 x float> %arg)
  ret {<vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>, <vscale x 4 x float>} %res
}

define {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} @vector_deinterleave_nxv1f64_nxv8f64(<vscale x 8 x double> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f64_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vlseg8e64.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} @llvm.vector.deinterleave8.nxv8f64(<vscale x 8 x double> %arg)
  ret {<vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>, <vscale x 1 x double>} %res
}

define {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} @vector_deinterleave_nxv2f64_nxv16f64(<vscale x 16 x double> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv2f64_nxv16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    add a1, sp, a1
; CHECK-NEXT:    addi a1, a1, 16
; CHECK-NEXT:    vs8r.v v8, (a0)
; CHECK-NEXT:    vs8r.v v16, (a1)
; CHECK-NEXT:    vsetvli a2, zero, e64, m1, ta, ma
; CHECK-NEXT:    vlseg8e64.v v0, (a0)
; CHECK-NEXT:    vlseg8e64.v v22, (a1)
; CHECK-NEXT:    vmv2r.v v8, v0
; CHECK-NEXT:    vmv1r.v v9, v22
; CHECK-NEXT:    vmv1r.v v22, v1
; CHECK-NEXT:    vmv2r.v v12, v2
; CHECK-NEXT:    vmv1r.v v13, v24
; CHECK-NEXT:    vmv1r.v v24, v3
; CHECK-NEXT:    vmv2r.v v16, v4
; CHECK-NEXT:    vmv1r.v v17, v26
; CHECK-NEXT:    vmv1r.v v26, v5
; CHECK-NEXT:    vmv2r.v v20, v6
; CHECK-NEXT:    vmv1r.v v21, v28
; CHECK-NEXT:    vmv1r.v v28, v7
; CHECK-NEXT:    vmv2r.v v10, v22
; CHECK-NEXT:    vmv2r.v v14, v24
; CHECK-NEXT:    vmv2r.v v18, v26
; CHECK-NEXT:    vmv2r.v v22, v28
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} @llvm.vector.deinterleave8.nxv16f64(<vscale x 16 x double> %arg)
  ret {<vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>, <vscale x 2 x double>} %res
}

define <vscale x 16 x i8> @vector_deinterleave_nxv16i8_nxv32i8_oneactive(<vscale x 32 x i8> %vec) {
; V-LABEL: vector_deinterleave_nxv16i8_nxv32i8_oneactive:
; V:       # %bb.0:
; V-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; V-NEXT:    vnsrl.wi v12, v8, 0
; V-NEXT:    vmv.v.v v8, v12
; V-NEXT:    ret
;
; ZIP-LABEL: vector_deinterleave_nxv16i8_nxv32i8_oneactive:
; ZIP:       # %bb.0:
; ZIP-NEXT:    vsetvli a0, zero, e8, m2, ta, ma
; ZIP-NEXT:    ri.vunzip2a.vv v12, v8, v10
; ZIP-NEXT:    vmv.v.v v8, v12
; ZIP-NEXT:    ret
  %retval = call {<vscale x 16 x i8>, <vscale x 16 x i8>} @llvm.vector.deinterleave2.nxv32i8(<vscale x 32 x i8> %vec)
  %ext = extractvalue {<vscale x 16 x i8>, <vscale x 16 x i8>} %retval, 0
  ret <vscale x 16 x i8> %ext
}

define <vscale x 1 x float> @vector_deinterleave_nxv1f32_nxv8f32_oneactive(<vscale x 8 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f32_nxv8f32_oneactive:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg8e32.v v8, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @llvm.vector.deinterleave8.nxv8f32(<vscale x 8 x float> %arg)
  %ext = extractvalue {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} %res, 0
  ret <vscale x 1 x float> %ext
}

define <vscale x 1 x float> @vector_deinterleave_nxv1f32_nxv8f32_oneactive2(<vscale x 8 x float> %arg) nounwind {
; CHECK-LABEL: vector_deinterleave_nxv1f32_nxv8f32_oneactive2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    sub sp, sp, a0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs4r.v v8, (a0)
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vlseg8e32.v v3, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 2
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %res = call {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} @llvm.vector.deinterleave8.nxv8f32(<vscale x 8 x float> %arg)
  %ext = extractvalue {<vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>, <vscale x 1 x float>} %res, 5
  ret <vscale x 1 x float> %ext
}
