; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefixes=CHECK,RV64

declare <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i8(
  <vscale x 1 x i8>,
  <vscale x 1 x i8>,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_vv_nxv1i8_nxv1i8(<vscale x 1 x i8> %0, <vscale x 1 x i8> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i8(
    <vscale x 1 x i8> %0,
    <vscale x 1 x i8> %1,
    iXLen %2)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i8(
  <vscale x 1 x i1>,
  <vscale x 1 x i8>,
  <vscale x 1 x i8>,
  <vscale x 1 x i1>,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_mask_vv_nxv1i8_nxv1i8(<vscale x 1 x i1> %0, <vscale x 1 x i8> %1, <vscale x 1 x i8> %2, <vscale x 1 x i8> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv1i8_nxv1i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    vmsle.vv v11, v10, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i8(
    <vscale x 1 x i8> %1,
    <vscale x 1 x i8> %2,
    iXLen %4)
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i8(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i8> %2,
    <vscale x 1 x i8> %3,
    <vscale x 1 x i1> %mask,
    iXLen %4)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i8(
  <vscale x 2 x i8>,
  <vscale x 2 x i8>,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_vv_nxv2i8_nxv2i8(<vscale x 2 x i8> %0, <vscale x 2 x i8> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i8(
    <vscale x 2 x i8> %0,
    <vscale x 2 x i8> %1,
    iXLen %2)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i8(
  <vscale x 2 x i1>,
  <vscale x 2 x i8>,
  <vscale x 2 x i8>,
  <vscale x 2 x i1>,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_mask_vv_nxv2i8_nxv2i8(<vscale x 2 x i1> %0, <vscale x 2 x i8> %1, <vscale x 2 x i8> %2, <vscale x 2 x i8> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv2i8_nxv2i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    vmsle.vv v11, v10, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i8(
    <vscale x 2 x i8> %1,
    <vscale x 2 x i8> %2,
    iXLen %4)
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i8(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i8> %2,
    <vscale x 2 x i8> %3,
    <vscale x 2 x i1> %mask,
    iXLen %4)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i8(
  <vscale x 4 x i8>,
  <vscale x 4 x i8>,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_vv_nxv4i8_nxv4i8(<vscale x 4 x i8> %0, <vscale x 4 x i8> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i8(
    <vscale x 4 x i8> %0,
    <vscale x 4 x i8> %1,
    iXLen %2)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i8(
  <vscale x 4 x i1>,
  <vscale x 4 x i8>,
  <vscale x 4 x i8>,
  <vscale x 4 x i1>,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vv_nxv4i8_nxv4i8(<vscale x 4 x i1> %0, <vscale x 4 x i8> %1, <vscale x 4 x i8> %2, <vscale x 4 x i8> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv4i8_nxv4i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    vmsle.vv v11, v10, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i8(
    <vscale x 4 x i8> %1,
    <vscale x 4 x i8> %2,
    iXLen %4)
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i8(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i8> %2,
    <vscale x 4 x i8> %3,
    <vscale x 4 x i1> %mask,
    iXLen %4)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i8(
  <vscale x 8 x i8>,
  <vscale x 8 x i8>,
  iXLen);

define <vscale x 8 x i1> @intrinsic_vmsge_vv_nxv8i8_nxv8i8(<vscale x 8 x i8> %0, <vscale x 8 x i8> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i8(
    <vscale x 8 x i8> %0,
    <vscale x 8 x i8> %1,
    iXLen %2)

  ret <vscale x 8 x i1> %a
}

declare <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i8(
  <vscale x 8 x i1>,
  <vscale x 8 x i8>,
  <vscale x 8 x i8>,
  <vscale x 8 x i1>,
  iXLen);

define <vscale x 8 x i1> @intrinsic_vmsge_mask_vv_nxv8i8_nxv8i8(<vscale x 8 x i1> %0, <vscale x 8 x i8> %1, <vscale x 8 x i8> %2, <vscale x 8 x i8> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv8i8_nxv8i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    vmsle.vv v11, v10, v9, v0.t
; CHECK-NEXT:    vmv.v.v v0, v11
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i8(
    <vscale x 8 x i8> %1,
    <vscale x 8 x i8> %2,
    iXLen %4)
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i8(
    <vscale x 8 x i1> %0,
    <vscale x 8 x i8> %2,
    <vscale x 8 x i8> %3,
    <vscale x 8 x i1> %mask,
    iXLen %4)

  ret <vscale x 8 x i1> %a
}

declare <vscale x 16 x i1> @llvm.riscv.vmsge.nxv16i8(
  <vscale x 16 x i8>,
  <vscale x 16 x i8>,
  iXLen);

define <vscale x 16 x i1> @intrinsic_vmsge_vv_nxv16i8_nxv16i8(<vscale x 16 x i8> %0, <vscale x 16 x i8> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v10, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.nxv16i8(
    <vscale x 16 x i8> %0,
    <vscale x 16 x i8> %1,
    iXLen %2)

  ret <vscale x 16 x i1> %a
}

declare <vscale x 16 x i1> @llvm.riscv.vmsge.mask.nxv16i8(
  <vscale x 16 x i1>,
  <vscale x 16 x i8>,
  <vscale x 16 x i8>,
  <vscale x 16 x i1>,
  iXLen);

define <vscale x 16 x i1> @intrinsic_vmsge_mask_vv_nxv16i8_nxv16i8(<vscale x 16 x i1> %0, <vscale x 16 x i8> %1, <vscale x 16 x i8> %2, <vscale x 16 x i8> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv16i8_nxv16i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, mu
; CHECK-NEXT:    vmv1r.v v14, v0
; CHECK-NEXT:    vmsle.vv v0, v10, v8
; CHECK-NEXT:    vmsle.vv v14, v12, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v14
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 16 x i1> @llvm.riscv.vmsge.nxv16i8(
    <vscale x 16 x i8> %1,
    <vscale x 16 x i8> %2,
    iXLen %4)
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.mask.nxv16i8(
    <vscale x 16 x i1> %0,
    <vscale x 16 x i8> %2,
    <vscale x 16 x i8> %3,
    <vscale x 16 x i1> %mask,
    iXLen %4)

  ret <vscale x 16 x i1> %a
}

declare <vscale x 32 x i1> @llvm.riscv.vmsge.nxv32i8(
  <vscale x 32 x i8>,
  <vscale x 32 x i8>,
  iXLen);

define <vscale x 32 x i1> @intrinsic_vmsge_vv_nxv32i8_nxv32i8(<vscale x 32 x i8> %0, <vscale x 32 x i8> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv32i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v12, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 32 x i1> @llvm.riscv.vmsge.nxv32i8(
    <vscale x 32 x i8> %0,
    <vscale x 32 x i8> %1,
    iXLen %2)

  ret <vscale x 32 x i1> %a
}

declare <vscale x 32 x i1> @llvm.riscv.vmsge.mask.nxv32i8(
  <vscale x 32 x i1>,
  <vscale x 32 x i8>,
  <vscale x 32 x i8>,
  <vscale x 32 x i1>,
  iXLen);

define <vscale x 32 x i1> @intrinsic_vmsge_mask_vv_nxv32i8_nxv32i8(<vscale x 32 x i1> %0, <vscale x 32 x i8> %1, <vscale x 32 x i8> %2, <vscale x 32 x i8> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv32i8_nxv32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, mu
; CHECK-NEXT:    vmv1r.v v20, v0
; CHECK-NEXT:    vmsle.vv v0, v12, v8
; CHECK-NEXT:    vmsle.vv v20, v16, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v20
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 32 x i1> @llvm.riscv.vmsge.nxv32i8(
    <vscale x 32 x i8> %1,
    <vscale x 32 x i8> %2,
    iXLen %4)
  %a = call <vscale x 32 x i1> @llvm.riscv.vmsge.mask.nxv32i8(
    <vscale x 32 x i1> %0,
    <vscale x 32 x i8> %2,
    <vscale x 32 x i8> %3,
    <vscale x 32 x i1> %mask,
    iXLen %4)

  ret <vscale x 32 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i16(
  <vscale x 1 x i16>,
  <vscale x 1 x i16>,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_vv_nxv1i16_nxv1i16(<vscale x 1 x i16> %0, <vscale x 1 x i16> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i16(
    <vscale x 1 x i16> %0,
    <vscale x 1 x i16> %1,
    iXLen %2)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i16(
  <vscale x 1 x i1>,
  <vscale x 1 x i16>,
  <vscale x 1 x i16>,
  <vscale x 1 x i1>,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_mask_vv_nxv1i16_nxv1i16(<vscale x 1 x i1> %0, <vscale x 1 x i16> %1, <vscale x 1 x i16> %2, <vscale x 1 x i16> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv1i16_nxv1i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    vmsle.vv v11, v10, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i16(
    <vscale x 1 x i16> %1,
    <vscale x 1 x i16> %2,
    iXLen %4)
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i16(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i16> %2,
    <vscale x 1 x i16> %3,
    <vscale x 1 x i1> %mask,
    iXLen %4)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i16(
  <vscale x 2 x i16>,
  <vscale x 2 x i16>,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_vv_nxv2i16_nxv2i16(<vscale x 2 x i16> %0, <vscale x 2 x i16> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i16(
    <vscale x 2 x i16> %0,
    <vscale x 2 x i16> %1,
    iXLen %2)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i16(
  <vscale x 2 x i1>,
  <vscale x 2 x i16>,
  <vscale x 2 x i16>,
  <vscale x 2 x i1>,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_mask_vv_nxv2i16_nxv2i16(<vscale x 2 x i1> %0, <vscale x 2 x i16> %1, <vscale x 2 x i16> %2, <vscale x 2 x i16> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv2i16_nxv2i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    vmsle.vv v11, v10, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i16(
    <vscale x 2 x i16> %1,
    <vscale x 2 x i16> %2,
    iXLen %4)
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i16(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i16> %2,
    <vscale x 2 x i16> %3,
    <vscale x 2 x i1> %mask,
    iXLen %4)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i16(
  <vscale x 4 x i16>,
  <vscale x 4 x i16>,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_vv_nxv4i16_nxv4i16(<vscale x 4 x i16> %0, <vscale x 4 x i16> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i16(
    <vscale x 4 x i16> %0,
    <vscale x 4 x i16> %1,
    iXLen %2)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i16(
  <vscale x 4 x i1>,
  <vscale x 4 x i16>,
  <vscale x 4 x i16>,
  <vscale x 4 x i1>,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vv_nxv4i16_nxv4i16(<vscale x 4 x i1> %0, <vscale x 4 x i16> %1, <vscale x 4 x i16> %2, <vscale x 4 x i16> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv4i16_nxv4i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    vmsle.vv v11, v10, v9, v0.t
; CHECK-NEXT:    vmv.v.v v0, v11
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i16(
    <vscale x 4 x i16> %1,
    <vscale x 4 x i16> %2,
    iXLen %4)
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i16(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i16> %2,
    <vscale x 4 x i16> %3,
    <vscale x 4 x i1> %mask,
    iXLen %4)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i16(
  <vscale x 8 x i16>,
  <vscale x 8 x i16>,
  iXLen);

define <vscale x 8 x i1> @intrinsic_vmsge_vv_nxv8i16_nxv8i16(<vscale x 8 x i16> %0, <vscale x 8 x i16> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv8i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v10, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i16(
    <vscale x 8 x i16> %0,
    <vscale x 8 x i16> %1,
    iXLen %2)

  ret <vscale x 8 x i1> %a
}

declare <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i16(
  <vscale x 8 x i1>,
  <vscale x 8 x i16>,
  <vscale x 8 x i16>,
  <vscale x 8 x i1>,
  iXLen);

define <vscale x 8 x i1> @intrinsic_vmsge_mask_vv_nxv8i16_nxv8i16(<vscale x 8 x i1> %0, <vscale x 8 x i16> %1, <vscale x 8 x i16> %2, <vscale x 8 x i16> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv8i16_nxv8i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, mu
; CHECK-NEXT:    vmv1r.v v14, v0
; CHECK-NEXT:    vmsle.vv v0, v10, v8
; CHECK-NEXT:    vmsle.vv v14, v12, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v14
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i16(
    <vscale x 8 x i16> %1,
    <vscale x 8 x i16> %2,
    iXLen %4)
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i16(
    <vscale x 8 x i1> %0,
    <vscale x 8 x i16> %2,
    <vscale x 8 x i16> %3,
    <vscale x 8 x i1> %mask,
    iXLen %4)

  ret <vscale x 8 x i1> %a
}

declare <vscale x 16 x i1> @llvm.riscv.vmsge.nxv16i16(
  <vscale x 16 x i16>,
  <vscale x 16 x i16>,
  iXLen);

define <vscale x 16 x i1> @intrinsic_vmsge_vv_nxv16i16_nxv16i16(<vscale x 16 x i16> %0, <vscale x 16 x i16> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv16i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v12, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.nxv16i16(
    <vscale x 16 x i16> %0,
    <vscale x 16 x i16> %1,
    iXLen %2)

  ret <vscale x 16 x i1> %a
}

declare <vscale x 16 x i1> @llvm.riscv.vmsge.mask.nxv16i16(
  <vscale x 16 x i1>,
  <vscale x 16 x i16>,
  <vscale x 16 x i16>,
  <vscale x 16 x i1>,
  iXLen);

define <vscale x 16 x i1> @intrinsic_vmsge_mask_vv_nxv16i16_nxv16i16(<vscale x 16 x i1> %0, <vscale x 16 x i16> %1, <vscale x 16 x i16> %2, <vscale x 16 x i16> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv16i16_nxv16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vmv1r.v v20, v0
; CHECK-NEXT:    vmsle.vv v0, v12, v8
; CHECK-NEXT:    vmsle.vv v20, v16, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v20
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 16 x i1> @llvm.riscv.vmsge.nxv16i16(
    <vscale x 16 x i16> %1,
    <vscale x 16 x i16> %2,
    iXLen %4)
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.mask.nxv16i16(
    <vscale x 16 x i1> %0,
    <vscale x 16 x i16> %2,
    <vscale x 16 x i16> %3,
    <vscale x 16 x i1> %mask,
    iXLen %4)

  ret <vscale x 16 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i32(
  <vscale x 1 x i32>,
  <vscale x 1 x i32>,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_vv_nxv1i32_nxv1i32(<vscale x 1 x i32> %0, <vscale x 1 x i32> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i32(
    <vscale x 1 x i32> %0,
    <vscale x 1 x i32> %1,
    iXLen %2)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i32(
  <vscale x 1 x i1>,
  <vscale x 1 x i32>,
  <vscale x 1 x i32>,
  <vscale x 1 x i1>,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_mask_vv_nxv1i32_nxv1i32(<vscale x 1 x i1> %0, <vscale x 1 x i32> %1, <vscale x 1 x i32> %2, <vscale x 1 x i32> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv1i32_nxv1i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    vmsle.vv v11, v10, v9, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i32(
    <vscale x 1 x i32> %1,
    <vscale x 1 x i32> %2,
    iXLen %4)
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i32(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i32> %2,
    <vscale x 1 x i32> %3,
    <vscale x 1 x i1> %mask,
    iXLen %4)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i32(
  <vscale x 2 x i32>,
  <vscale x 2 x i32>,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_vv_nxv2i32_nxv2i32(<vscale x 2 x i32> %0, <vscale x 2 x i32> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i32(
    <vscale x 2 x i32> %0,
    <vscale x 2 x i32> %1,
    iXLen %2)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i32(
  <vscale x 2 x i1>,
  <vscale x 2 x i32>,
  <vscale x 2 x i32>,
  <vscale x 2 x i1>,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_mask_vv_nxv2i32_nxv2i32(<vscale x 2 x i1> %0, <vscale x 2 x i32> %1, <vscale x 2 x i32> %2, <vscale x 2 x i32> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv2i32_nxv2i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    vmsle.vv v11, v10, v9, v0.t
; CHECK-NEXT:    vmv.v.v v0, v11
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i32(
    <vscale x 2 x i32> %1,
    <vscale x 2 x i32> %2,
    iXLen %4)
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i32(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i32> %2,
    <vscale x 2 x i32> %3,
    <vscale x 2 x i1> %mask,
    iXLen %4)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i32(
  <vscale x 4 x i32>,
  <vscale x 4 x i32>,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_vv_nxv4i32_nxv4i32(<vscale x 4 x i32> %0, <vscale x 4 x i32> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v10, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i32(
    <vscale x 4 x i32> %0,
    <vscale x 4 x i32> %1,
    iXLen %2)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i32(
  <vscale x 4 x i1>,
  <vscale x 4 x i32>,
  <vscale x 4 x i32>,
  <vscale x 4 x i1>,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vv_nxv4i32_nxv4i32(<vscale x 4 x i1> %0, <vscale x 4 x i32> %1, <vscale x 4 x i32> %2, <vscale x 4 x i32> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv4i32_nxv4i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; CHECK-NEXT:    vmv1r.v v14, v0
; CHECK-NEXT:    vmsle.vv v0, v10, v8
; CHECK-NEXT:    vmsle.vv v14, v12, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v14
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i32(
    <vscale x 4 x i32> %1,
    <vscale x 4 x i32> %2,
    iXLen %4)
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i32(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i32> %2,
    <vscale x 4 x i32> %3,
    <vscale x 4 x i1> %mask,
    iXLen %4)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i32(
  <vscale x 8 x i32>,
  <vscale x 8 x i32>,
  iXLen);

define <vscale x 8 x i1> @intrinsic_vmsge_vv_nxv8i32_nxv8i32(<vscale x 8 x i32> %0, <vscale x 8 x i32> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv8i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v12, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i32(
    <vscale x 8 x i32> %0,
    <vscale x 8 x i32> %1,
    iXLen %2)

  ret <vscale x 8 x i1> %a
}

declare <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i32(
  <vscale x 8 x i1>,
  <vscale x 8 x i32>,
  <vscale x 8 x i32>,
  <vscale x 8 x i1>,
  iXLen);

define <vscale x 8 x i1> @intrinsic_vmsge_mask_vv_nxv8i32_nxv8i32(<vscale x 8 x i1> %0, <vscale x 8 x i32> %1, <vscale x 8 x i32> %2, <vscale x 8 x i32> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv8i32_nxv8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, mu
; CHECK-NEXT:    vmv1r.v v20, v0
; CHECK-NEXT:    vmsle.vv v0, v12, v8
; CHECK-NEXT:    vmsle.vv v20, v16, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v20
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i32(
    <vscale x 8 x i32> %1,
    <vscale x 8 x i32> %2,
    iXLen %4)
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i32(
    <vscale x 8 x i1> %0,
    <vscale x 8 x i32> %2,
    <vscale x 8 x i32> %3,
    <vscale x 8 x i1> %mask,
    iXLen %4)

  ret <vscale x 8 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i64(
  <vscale x 1 x i64>,
  <vscale x 1 x i64>,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_vv_nxv1i64_nxv1i64(<vscale x 1 x i64> %0, <vscale x 1 x i64> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i64(
    <vscale x 1 x i64> %0,
    <vscale x 1 x i64> %1,
    iXLen %2)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i64(
  <vscale x 1 x i1>,
  <vscale x 1 x i64>,
  <vscale x 1 x i64>,
  <vscale x 1 x i1>,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_mask_vv_nxv1i64_nxv1i64(<vscale x 1 x i1> %0, <vscale x 1 x i64> %1, <vscale x 1 x i64> %2, <vscale x 1 x i64> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv1i64_nxv1i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmsle.vv v0, v9, v8
; CHECK-NEXT:    vmsle.vv v11, v10, v9, v0.t
; CHECK-NEXT:    vmv.v.v v0, v11
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i64(
    <vscale x 1 x i64> %1,
    <vscale x 1 x i64> %2,
    iXLen %4)
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i64(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i64> %2,
    <vscale x 1 x i64> %3,
    <vscale x 1 x i1> %mask,
    iXLen %4)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i64(
  <vscale x 2 x i64>,
  <vscale x 2 x i64>,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_vv_nxv2i64_nxv2i64(<vscale x 2 x i64> %0, <vscale x 2 x i64> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv2i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v10, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i64(
    <vscale x 2 x i64> %0,
    <vscale x 2 x i64> %1,
    iXLen %2)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i64(
  <vscale x 2 x i1>,
  <vscale x 2 x i64>,
  <vscale x 2 x i64>,
  <vscale x 2 x i1>,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_mask_vv_nxv2i64_nxv2i64(<vscale x 2 x i1> %0, <vscale x 2 x i64> %1, <vscale x 2 x i64> %2, <vscale x 2 x i64> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv2i64_nxv2i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, mu
; CHECK-NEXT:    vmv1r.v v14, v0
; CHECK-NEXT:    vmsle.vv v0, v10, v8
; CHECK-NEXT:    vmsle.vv v14, v12, v10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v14
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i64(
    <vscale x 2 x i64> %1,
    <vscale x 2 x i64> %2,
    iXLen %4)
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i64(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i64> %2,
    <vscale x 2 x i64> %3,
    <vscale x 2 x i1> %mask,
    iXLen %4)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i64(
  <vscale x 4 x i64>,
  <vscale x 4 x i64>,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_vv_nxv4i64_nxv4i64(<vscale x 4 x i64> %0, <vscale x 4 x i64> %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vv_nxv4i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmsle.vv v0, v12, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i64(
    <vscale x 4 x i64> %0,
    <vscale x 4 x i64> %1,
    iXLen %2)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i64(
  <vscale x 4 x i1>,
  <vscale x 4 x i64>,
  <vscale x 4 x i64>,
  <vscale x 4 x i1>,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vv_nxv4i64_nxv4i64(<vscale x 4 x i1> %0, <vscale x 4 x i64> %1, <vscale x 4 x i64> %2, <vscale x 4 x i64> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vv_nxv4i64_nxv4i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; CHECK-NEXT:    vmv1r.v v20, v0
; CHECK-NEXT:    vmsle.vv v0, v12, v8
; CHECK-NEXT:    vmsle.vv v20, v16, v12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v20
; CHECK-NEXT:    ret
entry:
  %mask = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i64(
    <vscale x 4 x i64> %1,
    <vscale x 4 x i64> %2,
    iXLen %4)
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i64(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i64> %2,
    <vscale x 4 x i64> %3,
    <vscale x 4 x i1> %mask,
    iXLen %4)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i8.i8(
  <vscale x 1 x i8>,
  i8,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_vx_nxv1i8_i8(<vscale x 1 x i8> %0, i8 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv1i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i8.i8(
    <vscale x 1 x i8> %0,
    i8 %1,
    iXLen %2)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i8.i8(
  <vscale x 1 x i1>,
  <vscale x 1 x i8>,
  i8,
  <vscale x 1 x i1>,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_mask_vx_nxv1i8_i8(<vscale x 1 x i1> %0, <vscale x 1 x i8> %1, i8 %2, <vscale x 1 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv1i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmslt.vx v10, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v10, v9
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i8.i8(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i8> %1,
    i8 %2,
    <vscale x 1 x i1> %3,
    iXLen %4)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i8.i8(
  <vscale x 2 x i8>,
  i8,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_vx_nxv2i8_i8(<vscale x 2 x i8> %0, i8 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv2i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i8.i8(
    <vscale x 2 x i8> %0,
    i8 %1,
    iXLen %2)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i8.i8(
  <vscale x 2 x i1>,
  <vscale x 2 x i8>,
  i8,
  <vscale x 2 x i1>,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_mask_vx_nxv2i8_i8(<vscale x 2 x i1> %0, <vscale x 2 x i8> %1, i8 %2, <vscale x 2 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv2i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmslt.vx v10, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v10, v9
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i8.i8(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i8> %1,
    i8 %2,
    <vscale x 2 x i1> %3,
    iXLen %4)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i8.i8(
  <vscale x 4 x i8>,
  i8,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_vx_nxv4i8_i8(<vscale x 4 x i8> %0, i8 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv4i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i8.i8(
    <vscale x 4 x i8> %0,
    i8 %1,
    iXLen %2)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i8.i8(
  <vscale x 4 x i1>,
  <vscale x 4 x i8>,
  i8,
  <vscale x 4 x i1>,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vx_nxv4i8_i8(<vscale x 4 x i1> %0, <vscale x 4 x i8> %1, i8 %2, <vscale x 4 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv4i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmslt.vx v10, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v10, v9
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i8.i8(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i8> %1,
    i8 %2,
    <vscale x 4 x i1> %3,
    iXLen %4)

  ret <vscale x 4 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vx_nxv4i8_i8_1(<vscale x 4 x i1> %0, <vscale x 4 x i8> %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv4i8_i8_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    li a0, 99
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmsgt.vx v10, v8, a0, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i8.i8(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i8> %1,
    i8 100,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret <vscale x 4 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vx_nxv4i8_i8_2(<vscale x 4 x i1> %0, <vscale x 4 x i8> %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv4i8_i8_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmor.mm v0, v9, v0
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i8.i8(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i8> %1,
    i8 -128,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret <vscale x 4 x i1> %a
}


declare <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i8.i8(
  <vscale x 8 x i8>,
  i8,
  iXLen);

define <vscale x 8 x i1> @intrinsic_vmsge_vx_nxv8i8_i8(<vscale x 8 x i8> %0, i8 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv8i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i8.i8(
    <vscale x 8 x i8> %0,
    i8 %1,
    iXLen %2)

  ret <vscale x 8 x i1> %a
}

declare <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i8.i8(
  <vscale x 8 x i1>,
  <vscale x 8 x i8>,
  i8,
  <vscale x 8 x i1>,
  iXLen);

define <vscale x 8 x i1> @intrinsic_vmsge_mask_vx_nxv8i8_i8(<vscale x 8 x i1> %0, <vscale x 8 x i8> %1, i8 %2, <vscale x 8 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv8i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmslt.vx v10, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v10, v9
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i8.i8(
    <vscale x 8 x i1> %0,
    <vscale x 8 x i8> %1,
    i8 %2,
    <vscale x 8 x i1> %3,
    iXLen %4)

  ret <vscale x 8 x i1> %a
}

declare <vscale x 16 x i1> @llvm.riscv.vmsge.nxv16i8.i8(
  <vscale x 16 x i8>,
  i8,
  iXLen);

define <vscale x 16 x i1> @intrinsic_vmsge_vx_nxv16i8_i8(<vscale x 16 x i8> %0, i8 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv16i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vmslt.vx v10, v8, a0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.nxv16i8.i8(
    <vscale x 16 x i8> %0,
    i8 %1,
    iXLen %2)

  ret <vscale x 16 x i1> %a
}

declare <vscale x 16 x i1> @llvm.riscv.vmsge.mask.nxv16i8.i8(
  <vscale x 16 x i1>,
  <vscale x 16 x i8>,
  i8,
  <vscale x 16 x i1>,
  iXLen);

define <vscale x 16 x i1> @intrinsic_vmsge_mask_vx_nxv16i8_i8(<vscale x 16 x i1> %0, <vscale x 16 x i8> %1, i8 %2, <vscale x 16 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv16i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmslt.vx v11, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v11, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.mask.nxv16i8.i8(
    <vscale x 16 x i1> %0,
    <vscale x 16 x i8> %1,
    i8 %2,
    <vscale x 16 x i1> %3,
    iXLen %4)

  ret <vscale x 16 x i1> %a
}

declare <vscale x 32 x i1> @llvm.riscv.vmsge.nxv32i8.i8(
  <vscale x 32 x i8>,
  i8,
  iXLen);

define <vscale x 32 x i1> @intrinsic_vmsge_vx_nxv32i8_i8(<vscale x 32 x i8> %0, i8 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv32i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vmslt.vx v12, v8, a0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 32 x i1> @llvm.riscv.vmsge.nxv32i8.i8(
    <vscale x 32 x i8> %0,
    i8 %1,
    iXLen %2)

  ret <vscale x 32 x i1> %a
}

declare <vscale x 32 x i1> @llvm.riscv.vmsge.mask.nxv32i8.i8(
  <vscale x 32 x i1>,
  <vscale x 32 x i8>,
  i8,
  <vscale x 32 x i1>,
  iXLen);

define <vscale x 32 x i1> @intrinsic_vmsge_mask_vx_nxv32i8_i8(<vscale x 32 x i1> %0, <vscale x 32 x i8> %1, i8 %2, <vscale x 32 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv32i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, mu
; CHECK-NEXT:    vmv1r.v v13, v0
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmslt.vx v13, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v13, v12
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 32 x i1> @llvm.riscv.vmsge.mask.nxv32i8.i8(
    <vscale x 32 x i1> %0,
    <vscale x 32 x i8> %1,
    i8 %2,
    <vscale x 32 x i1> %3,
    iXLen %4)

  ret <vscale x 32 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i16.i16(
  <vscale x 1 x i16>,
  i16,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_vx_nxv1i16_i16(<vscale x 1 x i16> %0, i16 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv1i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i16.i16(
    <vscale x 1 x i16> %0,
    i16 %1,
    iXLen %2)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i16.i16(
  <vscale x 1 x i1>,
  <vscale x 1 x i16>,
  i16,
  <vscale x 1 x i1>,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_mask_vx_nxv1i16_i16(<vscale x 1 x i1> %0, <vscale x 1 x i16> %1, i16 %2, <vscale x 1 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv1i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmslt.vx v10, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v10, v9
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i16.i16(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i16> %1,
    i16 %2,
    <vscale x 1 x i1> %3,
    iXLen %4)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i16.i16(
  <vscale x 2 x i16>,
  i16,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_vx_nxv2i16_i16(<vscale x 2 x i16> %0, i16 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv2i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i16.i16(
    <vscale x 2 x i16> %0,
    i16 %1,
    iXLen %2)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i16.i16(
  <vscale x 2 x i1>,
  <vscale x 2 x i16>,
  i16,
  <vscale x 2 x i1>,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_mask_vx_nxv2i16_i16(<vscale x 2 x i1> %0, <vscale x 2 x i16> %1, i16 %2, <vscale x 2 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv2i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmslt.vx v10, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v10, v9
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i16.i16(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i16> %1,
    i16 %2,
    <vscale x 2 x i1> %3,
    iXLen %4)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i16.i16(
  <vscale x 4 x i16>,
  i16,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_vx_nxv4i16_i16(<vscale x 4 x i16> %0, i16 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv4i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i16.i16(
    <vscale x 4 x i16> %0,
    i16 %1,
    iXLen %2)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i16.i16(
  <vscale x 4 x i1>,
  <vscale x 4 x i16>,
  i16,
  <vscale x 4 x i1>,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vx_nxv4i16_i16(<vscale x 4 x i1> %0, <vscale x 4 x i16> %1, i16 %2, <vscale x 4 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv4i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmslt.vx v10, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v10, v9
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i16.i16(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i16> %1,
    i16 %2,
    <vscale x 4 x i1> %3,
    iXLen %4)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i16.i16(
  <vscale x 8 x i16>,
  i16,
  iXLen);

define <vscale x 8 x i1> @intrinsic_vmsge_vx_nxv8i16_i16(<vscale x 8 x i16> %0, i16 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv8i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmslt.vx v10, v8, a0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i16.i16(
    <vscale x 8 x i16> %0,
    i16 %1,
    iXLen %2)

  ret <vscale x 8 x i1> %a
}

declare <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i16.i16(
  <vscale x 8 x i1>,
  <vscale x 8 x i16>,
  i16,
  <vscale x 8 x i1>,
  iXLen);

define <vscale x 8 x i1> @intrinsic_vmsge_mask_vx_nxv8i16_i16(<vscale x 8 x i1> %0, <vscale x 8 x i16> %1, i16 %2, <vscale x 8 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv8i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmslt.vx v11, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v11, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i16.i16(
    <vscale x 8 x i1> %0,
    <vscale x 8 x i16> %1,
    i16 %2,
    <vscale x 8 x i1> %3,
    iXLen %4)

  ret <vscale x 8 x i1> %a
}

declare <vscale x 16 x i1> @llvm.riscv.vmsge.nxv16i16.i16(
  <vscale x 16 x i16>,
  i16,
  iXLen);

define <vscale x 16 x i1> @intrinsic_vmsge_vx_nxv16i16_i16(<vscale x 16 x i16> %0, i16 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv16i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vmslt.vx v12, v8, a0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.nxv16i16.i16(
    <vscale x 16 x i16> %0,
    i16 %1,
    iXLen %2)

  ret <vscale x 16 x i1> %a
}

declare <vscale x 16 x i1> @llvm.riscv.vmsge.mask.nxv16i16.i16(
  <vscale x 16 x i1>,
  <vscale x 16 x i16>,
  i16,
  <vscale x 16 x i1>,
  iXLen);

define <vscale x 16 x i1> @intrinsic_vmsge_mask_vx_nxv16i16_i16(<vscale x 16 x i1> %0, <vscale x 16 x i16> %1, i16 %2, <vscale x 16 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv16i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, mu
; CHECK-NEXT:    vmv1r.v v13, v0
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmslt.vx v13, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v13, v12
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.mask.nxv16i16.i16(
    <vscale x 16 x i1> %0,
    <vscale x 16 x i16> %1,
    i16 %2,
    <vscale x 16 x i1> %3,
    iXLen %4)

  ret <vscale x 16 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i32.i32(
  <vscale x 1 x i32>,
  i32,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_vx_nxv1i32_i32(<vscale x 1 x i32> %0, i32 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv1i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i32.i32(
    <vscale x 1 x i32> %0,
    i32 %1,
    iXLen %2)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i32.i32(
  <vscale x 1 x i1>,
  <vscale x 1 x i32>,
  i32,
  <vscale x 1 x i1>,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_mask_vx_nxv1i32_i32(<vscale x 1 x i1> %0, <vscale x 1 x i32> %1, i32 %2, <vscale x 1 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv1i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmslt.vx v10, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v10, v9
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i32.i32(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i32> %1,
    i32 %2,
    <vscale x 1 x i1> %3,
    iXLen %4)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i32.i32(
  <vscale x 2 x i32>,
  i32,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_vx_nxv2i32_i32(<vscale x 2 x i32> %0, i32 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv2i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmnot.m v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i32.i32(
    <vscale x 2 x i32> %0,
    i32 %1,
    iXLen %2)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i32.i32(
  <vscale x 2 x i1>,
  <vscale x 2 x i32>,
  i32,
  <vscale x 2 x i1>,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_mask_vx_nxv2i32_i32(<vscale x 2 x i1> %0, <vscale x 2 x i32> %1, i32 %2, <vscale x 2 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv2i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmslt.vx v10, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v10, v9
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i32.i32(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i32> %1,
    i32 %2,
    <vscale x 2 x i1> %3,
    iXLen %4)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i32.i32(
  <vscale x 4 x i32>,
  i32,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_vx_nxv4i32_i32(<vscale x 4 x i32> %0, i32 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv4i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmslt.vx v10, v8, a0
; CHECK-NEXT:    vmnot.m v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i32.i32(
    <vscale x 4 x i32> %0,
    i32 %1,
    iXLen %2)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i32.i32(
  <vscale x 4 x i1>,
  <vscale x 4 x i32>,
  i32,
  <vscale x 4 x i1>,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vx_nxv4i32_i32(<vscale x 4 x i1> %0, <vscale x 4 x i32> %1, i32 %2, <vscale x 4 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv4i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmslt.vx v11, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v11, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i32.i32(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i32> %1,
    i32 %2,
    <vscale x 4 x i1> %3,
    iXLen %4)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i32.i32(
  <vscale x 8 x i32>,
  i32,
  iXLen);

define <vscale x 8 x i1> @intrinsic_vmsge_vx_nxv8i32_i32(<vscale x 8 x i32> %0, i32 %1, iXLen %2) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vx_nxv8i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmslt.vx v12, v8, a0
; CHECK-NEXT:    vmnot.m v0, v12
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i32.i32(
    <vscale x 8 x i32> %0,
    i32 %1,
    iXLen %2)

  ret <vscale x 8 x i1> %a
}

declare <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i32.i32(
  <vscale x 8 x i1>,
  <vscale x 8 x i32>,
  i32,
  <vscale x 8 x i1>,
  iXLen);

define <vscale x 8 x i1> @intrinsic_vmsge_mask_vx_nxv8i32_i32(<vscale x 8 x i1> %0, <vscale x 8 x i32> %1, i32 %2, <vscale x 8 x i1> %3, iXLen %4) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vx_nxv8i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, mu
; CHECK-NEXT:    vmv1r.v v13, v0
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmslt.vx v13, v8, a0, v0.t
; CHECK-NEXT:    vmxor.mm v0, v13, v12
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i32.i32(
    <vscale x 8 x i1> %0,
    <vscale x 8 x i32> %1,
    i32 %2,
    <vscale x 8 x i1> %3,
    iXLen %4)

  ret <vscale x 8 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i64.i64(
  <vscale x 1 x i64>,
  i64,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_vx_nxv1i64_i64(<vscale x 1 x i64> %0, i64 %1, iXLen %2) nounwind {
; RV32-LABEL: intrinsic_vmsge_vx_nxv1i64_i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, ma
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vmsle.vv v0, v9, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: intrinsic_vmsge_vx_nxv1i64_i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmslt.vx v8, v8, a0
; RV64-NEXT:    vmnot.m v0, v8
; RV64-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i64.i64(
    <vscale x 1 x i64> %0,
    i64 %1,
    iXLen %2)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i64.i64(
  <vscale x 1 x i1>,
  <vscale x 1 x i64>,
  i64,
  <vscale x 1 x i1>,
  iXLen);

define <vscale x 1 x i1> @intrinsic_vmsge_mask_vx_nxv1i64_i64(<vscale x 1 x i1> %0, <vscale x 1 x i64> %1, i64 %2, <vscale x 1 x i1> %3, iXLen %4) nounwind {
; RV32-LABEL: intrinsic_vmsge_mask_vx_nxv1i64_i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; RV32-NEXT:    vlse64.v v11, (a0), zero
; RV32-NEXT:    vmv1r.v v10, v0
; RV32-NEXT:    vmv1r.v v0, v9
; RV32-NEXT:    vmsle.vv v10, v11, v8, v0.t
; RV32-NEXT:    vmv.v.v v0, v10
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: intrinsic_vmsge_mask_vx_nxv1i64_i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, mu
; RV64-NEXT:    vmv1r.v v10, v0
; RV64-NEXT:    vmv1r.v v0, v9
; RV64-NEXT:    vmslt.vx v10, v8, a0, v0.t
; RV64-NEXT:    vmxor.mm v0, v10, v9
; RV64-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i64.i64(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i64> %1,
    i64 %2,
    <vscale x 1 x i1> %3,
    iXLen %4)

  ret <vscale x 1 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i64.i64(
  <vscale x 2 x i64>,
  i64,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_vx_nxv2i64_i64(<vscale x 2 x i64> %0, i64 %1, iXLen %2) nounwind {
; RV32-LABEL: intrinsic_vmsge_vx_nxv2i64_i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli zero, a2, e64, m2, ta, ma
; RV32-NEXT:    vlse64.v v10, (a0), zero
; RV32-NEXT:    vmsle.vv v0, v10, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: intrinsic_vmsge_vx_nxv2i64_i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; RV64-NEXT:    vmslt.vx v10, v8, a0
; RV64-NEXT:    vmnot.m v0, v10
; RV64-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i64.i64(
    <vscale x 2 x i64> %0,
    i64 %1,
    iXLen %2)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i64.i64(
  <vscale x 2 x i1>,
  <vscale x 2 x i64>,
  i64,
  <vscale x 2 x i1>,
  iXLen);

define <vscale x 2 x i1> @intrinsic_vmsge_mask_vx_nxv2i64_i64(<vscale x 2 x i1> %0, <vscale x 2 x i64> %1, i64 %2, <vscale x 2 x i1> %3, iXLen %4) nounwind {
; RV32-LABEL: intrinsic_vmsge_mask_vx_nxv2i64_i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vmv1r.v v11, v0
; RV32-NEXT:    vmv1r.v v0, v10
; RV32-NEXT:    vmsle.vv v11, v12, v8, v0.t
; RV32-NEXT:    vmv1r.v v0, v11
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: intrinsic_vmsge_mask_vx_nxv2i64_i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetvli zero, a1, e64, m2, ta, mu
; RV64-NEXT:    vmv1r.v v11, v0
; RV64-NEXT:    vmv1r.v v0, v10
; RV64-NEXT:    vmslt.vx v11, v8, a0, v0.t
; RV64-NEXT:    vmxor.mm v0, v11, v10
; RV64-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i64.i64(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i64> %1,
    i64 %2,
    <vscale x 2 x i1> %3,
    iXLen %4)

  ret <vscale x 2 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i64.i64(
  <vscale x 4 x i64>,
  i64,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_vx_nxv4i64_i64(<vscale x 4 x i64> %0, i64 %1, iXLen %2) nounwind {
; RV32-LABEL: intrinsic_vmsge_vx_nxv4i64_i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli zero, a2, e64, m4, ta, ma
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vmsle.vv v0, v12, v8
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: intrinsic_vmsge_vx_nxv4i64_i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vmslt.vx v12, v8, a0
; RV64-NEXT:    vmnot.m v0, v12
; RV64-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i64.i64(
    <vscale x 4 x i64> %0,
    i64 %1,
    iXLen %2)

  ret <vscale x 4 x i1> %a
}

declare <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i64.i64(
  <vscale x 4 x i1>,
  <vscale x 4 x i64>,
  i64,
  <vscale x 4 x i1>,
  iXLen);

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vx_nxv4i64_i64(<vscale x 4 x i1> %0, <vscale x 4 x i64> %1, i64 %2, <vscale x 4 x i1> %3, iXLen %4) nounwind {
; RV32-LABEL: intrinsic_vmsge_mask_vx_nxv4i64_i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli zero, a2, e64, m4, ta, mu
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmv1r.v v13, v0
; RV32-NEXT:    vmv1r.v v0, v12
; RV32-NEXT:    vmsle.vv v13, v16, v8, v0.t
; RV32-NEXT:    vmv1r.v v0, v13
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: intrinsic_vmsge_mask_vx_nxv4i64_i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, mu
; RV64-NEXT:    vmv1r.v v13, v0
; RV64-NEXT:    vmv1r.v v0, v12
; RV64-NEXT:    vmslt.vx v13, v8, a0, v0.t
; RV64-NEXT:    vmxor.mm v0, v13, v12
; RV64-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i64.i64(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i64> %1,
    i64 %2,
    <vscale x 4 x i1> %3,
    iXLen %4)

  ret <vscale x 4 x i1> %a
}

define <vscale x 1 x i1> @intrinsic_vmsge_vi_nxv1i8_i8(<vscale x 1 x i8> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv1i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -16
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i8.i8(
    <vscale x 1 x i8> %0,
    i8 -15,
    iXLen %1)

  ret <vscale x 1 x i1> %a
}

define <vscale x 1 x i1> @intrinsic_vmsge_mask_vi_nxv1i8_i8(<vscale x 1 x i1> %0, <vscale x 1 x i8> %1, <vscale x 1 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv1i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmsgt.vi v10, v8, -15, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i8.i8(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i8> %1,
    i8 -14,
    <vscale x 1 x i1> %2,
    iXLen %3)

  ret <vscale x 1 x i1> %a
}

define <vscale x 2 x i1> @intrinsic_vmsge_vi_nxv2i8_i8(<vscale x 2 x i8> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv2i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -14
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i8.i8(
    <vscale x 2 x i8> %0,
    i8 -13,
    iXLen %1)

  ret <vscale x 2 x i1> %a
}

define <vscale x 2 x i1> @intrinsic_vmsge_mask_vi_nxv2i8_i8(<vscale x 2 x i1> %0, <vscale x 2 x i8> %1, <vscale x 2 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv2i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmsgt.vi v10, v8, -13, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i8.i8(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i8> %1,
    i8 -12,
    <vscale x 2 x i1> %2,
    iXLen %3)

  ret <vscale x 2 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_vi_nxv4i8_i8(<vscale x 4 x i8> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv4i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -12
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i8.i8(
    <vscale x 4 x i8> %0,
    i8 -11,
    iXLen %1)

  ret <vscale x 4 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_vi_nxv4i8_i8_1(<vscale x 4 x i8> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv4i8_i8_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    li a1, 99
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmsgt.vx v0, v8, a1
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i8.i8(
    <vscale x 4 x i8> %0,
    i8 100,
    iXLen %1)

  ret <vscale x 4 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_vi_nxv4i8_i8_2(<vscale x 4 x i8> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv4i8_i8_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    vmset.m v0
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i8.i8(
    <vscale x 4 x i8> %0,
    i8 -128,
    iXLen %1)

  ret <vscale x 4 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vi_nxv4i8_i8(<vscale x 4 x i1> %0, <vscale x 4 x i8> %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv4i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmsgt.vi v10, v8, -11, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i8.i8(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i8> %1,
    i8 -10,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret <vscale x 4 x i1> %a
}

define <vscale x 8 x i1> @intrinsic_vmsge_vi_nxv8i8_i8(<vscale x 8 x i8> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv8i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i8.i8(
    <vscale x 8 x i8> %0,
    i8 -9,
    iXLen %1)

  ret <vscale x 8 x i1> %a
}

define <vscale x 8 x i1> @intrinsic_vmsge_mask_vi_nxv8i8_i8(<vscale x 8 x i1> %0, <vscale x 8 x i8> %1, <vscale x 8 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv8i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmsgt.vi v10, v8, -9, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i8.i8(
    <vscale x 8 x i1> %0,
    <vscale x 8 x i8> %1,
    i8 -8,
    <vscale x 8 x i1> %2,
    iXLen %3)

  ret <vscale x 8 x i1> %a
}

define <vscale x 16 x i1> @intrinsic_vmsge_vi_nxv16i8_i8(<vscale x 16 x i8> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv16i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.nxv16i8.i8(
    <vscale x 16 x i8> %0,
    i8 -7,
    iXLen %1)

  ret <vscale x 16 x i1> %a
}

define <vscale x 16 x i1> @intrinsic_vmsge_mask_vi_nxv16i8_i8(<vscale x 16 x i1> %0, <vscale x 16 x i8> %1, <vscale x 16 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv16i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmsgt.vi v11, v8, -7, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.mask.nxv16i8.i8(
    <vscale x 16 x i1> %0,
    <vscale x 16 x i8> %1,
    i8 -6,
    <vscale x 16 x i1> %2,
    iXLen %3)

  ret <vscale x 16 x i1> %a
}

define <vscale x 32 x i1> @intrinsic_vmsge_vi_nxv32i8_i8(<vscale x 32 x i8> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv32i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -6
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 32 x i1> @llvm.riscv.vmsge.nxv32i8.i8(
    <vscale x 32 x i8> %0,
    i8 -5,
    iXLen %1)

  ret <vscale x 32 x i1> %a
}

define <vscale x 32 x i1> @intrinsic_vmsge_mask_vi_nxv32i8_i8(<vscale x 32 x i1> %0, <vscale x 32 x i8> %1, <vscale x 32 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv32i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, mu
; CHECK-NEXT:    vmv1r.v v13, v0
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmsgt.vi v13, v8, -5, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 32 x i1> @llvm.riscv.vmsge.mask.nxv32i8.i8(
    <vscale x 32 x i1> %0,
    <vscale x 32 x i8> %1,
    i8 -4,
    <vscale x 32 x i1> %2,
    iXLen %3)

  ret <vscale x 32 x i1> %a
}

define <vscale x 1 x i1> @intrinsic_vmsge_vi_nxv1i16_i16(<vscale x 1 x i16> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv1i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -4
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i16.i16(
    <vscale x 1 x i16> %0,
    i16 -3,
    iXLen %1)

  ret <vscale x 1 x i1> %a
}

define <vscale x 1 x i1> @intrinsic_vmsge_mask_vi_nxv1i16_i16(<vscale x 1 x i1> %0, <vscale x 1 x i16> %1, <vscale x 1 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv1i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmsgt.vi v10, v8, -3, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i16.i16(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i16> %1,
    i16 -2,
    <vscale x 1 x i1> %2,
    iXLen %3)

  ret <vscale x 1 x i1> %a
}

define <vscale x 2 x i1> @intrinsic_vmsge_vi_nxv2i16_i16(<vscale x 2 x i16> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv2i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -2
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i16.i16(
    <vscale x 2 x i16> %0,
    i16 -1,
    iXLen %1)

  ret <vscale x 2 x i1> %a
}

define <vscale x 2 x i1> @intrinsic_vmsge_mask_vi_nxv2i16_i16(<vscale x 2 x i1> %0, <vscale x 2 x i16> %1, <vscale x 2 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv2i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmsgt.vi v10, v8, -1, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i16.i16(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i16> %1,
    i16 0,
    <vscale x 2 x i1> %2,
    iXLen %3)

  ret <vscale x 2 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_vi_nxv4i16_i16(<vscale x 4 x i16> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv4i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, -1
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i16.i16(
    <vscale x 4 x i16> %0,
    i16 0,
    iXLen %1)

  ret <vscale x 4 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vi_nxv4i16_i16(<vscale x 4 x i1> %0, <vscale x 4 x i16> %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv4i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmsgt.vi v10, v8, 0, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i16.i16(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i16> %1,
    i16 1,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret <vscale x 4 x i1> %a
}

define <vscale x 8 x i1> @intrinsic_vmsge_vi_nxv8i16_i16(<vscale x 8 x i16> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv8i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 1
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i16.i16(
    <vscale x 8 x i16> %0,
    i16 2,
    iXLen %1)

  ret <vscale x 8 x i1> %a
}

define <vscale x 8 x i1> @intrinsic_vmsge_mask_vi_nxv8i16_i16(<vscale x 8 x i1> %0, <vscale x 8 x i16> %1, <vscale x 8 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv8i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmsgt.vi v11, v8, 2, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i16.i16(
    <vscale x 8 x i1> %0,
    <vscale x 8 x i16> %1,
    i16 3,
    <vscale x 8 x i1> %2,
    iXLen %3)

  ret <vscale x 8 x i1> %a
}

define <vscale x 16 x i1> @intrinsic_vmsge_vi_nxv16i16_i16(<vscale x 16 x i16> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv16i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 3
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.nxv16i16.i16(
    <vscale x 16 x i16> %0,
    i16 4,
    iXLen %1)

  ret <vscale x 16 x i1> %a
}

define <vscale x 16 x i1> @intrinsic_vmsge_mask_vi_nxv16i16_i16(<vscale x 16 x i1> %0, <vscale x 16 x i16> %1, <vscale x 16 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv16i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, mu
; CHECK-NEXT:    vmv1r.v v13, v0
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmsgt.vi v13, v8, 4, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.mask.nxv16i16.i16(
    <vscale x 16 x i1> %0,
    <vscale x 16 x i16> %1,
    i16 5,
    <vscale x 16 x i1> %2,
    iXLen %3)

  ret <vscale x 16 x i1> %a
}

define <vscale x 1 x i1> @intrinsic_vmsge_vi_nxv1i32_i32(<vscale x 1 x i32> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv1i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 5
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i32.i32(
    <vscale x 1 x i32> %0,
    i32 6,
    iXLen %1)

  ret <vscale x 1 x i1> %a
}

define <vscale x 1 x i1> @intrinsic_vmsge_mask_vi_nxv1i32_i32(<vscale x 1 x i1> %0, <vscale x 1 x i32> %1, <vscale x 1 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv1i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmsgt.vi v10, v8, 6, v0.t
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i32.i32(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i32> %1,
    i32 7,
    <vscale x 1 x i1> %2,
    iXLen %3)

  ret <vscale x 1 x i1> %a
}

define <vscale x 2 x i1> @intrinsic_vmsge_vi_nxv2i32_i32(<vscale x 2 x i32> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv2i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 7
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i32.i32(
    <vscale x 2 x i32> %0,
    i32 8,
    iXLen %1)

  ret <vscale x 2 x i1> %a
}

define <vscale x 2 x i1> @intrinsic_vmsge_mask_vi_nxv2i32_i32(<vscale x 2 x i1> %0, <vscale x 2 x i32> %1, <vscale x 2 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv2i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmsgt.vi v10, v8, 8, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i32.i32(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i32> %1,
    i32 9,
    <vscale x 2 x i1> %2,
    iXLen %3)

  ret <vscale x 2 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_vi_nxv4i32_i32(<vscale x 4 x i32> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv4i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 9
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i32.i32(
    <vscale x 4 x i32> %0,
    i32 10,
    iXLen %1)

  ret <vscale x 4 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vi_nxv4i32_i32(<vscale x 4 x i1> %0, <vscale x 4 x i32> %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv4i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmsgt.vi v11, v8, 10, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i32.i32(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i32> %1,
    i32 11,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret <vscale x 4 x i1> %a
}

define <vscale x 8 x i1> @intrinsic_vmsge_vi_nxv8i32_i32(<vscale x 8 x i32> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv8i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 11
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.nxv8i32.i32(
    <vscale x 8 x i32> %0,
    i32 12,
    iXLen %1)

  ret <vscale x 8 x i1> %a
}

define <vscale x 8 x i1> @intrinsic_vmsge_mask_vi_nxv8i32_i32(<vscale x 8 x i1> %0, <vscale x 8 x i32> %1, <vscale x 8 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv8i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, mu
; CHECK-NEXT:    vmv1r.v v13, v0
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmsgt.vi v13, v8, 12, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i32.i32(
    <vscale x 8 x i1> %0,
    <vscale x 8 x i32> %1,
    i32 13,
    <vscale x 8 x i1> %2,
    iXLen %3)

  ret <vscale x 8 x i1> %a
}

define <vscale x 1 x i1> @intrinsic_vmsge_vi_nxv1i64_i64(<vscale x 1 x i64> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv1i64_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.nxv1i64.i64(
    <vscale x 1 x i64> %0,
    i64 9,
    iXLen %1)

  ret <vscale x 1 x i1> %a
}

define <vscale x 1 x i1> @intrinsic_vmsge_mask_vi_nxv1i64_i64(<vscale x 1 x i1> %0, <vscale x 1 x i64> %1, <vscale x 1 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv1i64_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m1, ta, mu
; CHECK-NEXT:    vmv1r.v v10, v0
; CHECK-NEXT:    vmv1r.v v0, v9
; CHECK-NEXT:    vmsgt.vi v10, v8, 8, v0.t
; CHECK-NEXT:    vmv.v.v v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i64.i64(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i64> %1,
    i64 9,
    <vscale x 1 x i1> %2,
    iXLen %3)

  ret <vscale x 1 x i1> %a
}

define <vscale x 2 x i1> @intrinsic_vmsge_vi_nxv2i64_i64(<vscale x 2 x i64> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv2i64_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.nxv2i64.i64(
    <vscale x 2 x i64> %0,
    i64 9,
    iXLen %1)

  ret <vscale x 2 x i1> %a
}

define <vscale x 2 x i1> @intrinsic_vmsge_mask_vi_nxv2i64_i64(<vscale x 2 x i1> %0, <vscale x 2 x i64> %1, <vscale x 2 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv2i64_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m2, ta, mu
; CHECK-NEXT:    vmv1r.v v11, v0
; CHECK-NEXT:    vmv1r.v v0, v10
; CHECK-NEXT:    vmsgt.vi v11, v8, 8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v11
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i64.i64(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i64> %1,
    i64 9,
    <vscale x 2 x i1> %2,
    iXLen %3)

  ret <vscale x 2 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_vi_nxv4i64_i64(<vscale x 4 x i64> %0, iXLen %1) nounwind {
; CHECK-LABEL: intrinsic_vmsge_vi_nxv4i64_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, ma
; CHECK-NEXT:    vmsgt.vi v0, v8, 8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.nxv4i64.i64(
    <vscale x 4 x i64> %0,
    i64 9,
    iXLen %1)

  ret <vscale x 4 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_mask_vi_nxv4i64_i64(<vscale x 4 x i1> %0, <vscale x 4 x i64> %1, <vscale x 4 x i1> %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_mask_vi_nxv4i64_i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e64, m4, ta, mu
; CHECK-NEXT:    vmv1r.v v13, v0
; CHECK-NEXT:    vmv1r.v v0, v12
; CHECK-NEXT:    vmsgt.vi v13, v8, 8, v0.t
; CHECK-NEXT:    vmv1r.v v0, v13
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i64.i64(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i64> %1,
    i64 9,
    <vscale x 4 x i1> %2,
    iXLen %3)

  ret <vscale x 4 x i1> %a
}

; Test cases where the mask and maskedoff are the same value.
define <vscale x 1 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv1i8_i8(<vscale x 1 x i1> %0, <vscale x 1 x i8> %1, i8 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv1i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i8.i8(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i8> %1,
    i8 %2,
    <vscale x 1 x i1> %0,
    iXLen %3)

  ret <vscale x 1 x i1> %a
}

define <vscale x 2 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv2i8_i8(<vscale x 2 x i1> %0, <vscale x 2 x i8> %1, i8 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv2i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i8.i8(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i8> %1,
    i8 %2,
    <vscale x 2 x i1> %0,
    iXLen %3)

  ret <vscale x 2 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv4i8_i8(<vscale x 4 x i1> %0, <vscale x 4 x i8> %1, i8 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv4i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i8.i8(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i8> %1,
    i8 %2,
    <vscale x 4 x i1> %0,
    iXLen %3)

  ret <vscale x 4 x i1> %a
}

define <vscale x 8 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv8i8_i8(<vscale x 8 x i1> %0, <vscale x 8 x i8> %1, i8 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv8i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i8.i8(
    <vscale x 8 x i1> %0,
    <vscale x 8 x i8> %1,
    i8 %2,
    <vscale x 8 x i1> %0,
    iXLen %3)

  ret <vscale x 8 x i1> %a
}

define <vscale x 16 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv16i8_i8(<vscale x 16 x i1> %0, <vscale x 16 x i8> %1, i8 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv16i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    vmslt.vx v10, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.mask.nxv16i8.i8(
    <vscale x 16 x i1> %0,
    <vscale x 16 x i8> %1,
    i8 %2,
    <vscale x 16 x i1> %0,
    iXLen %3)

  ret <vscale x 16 x i1> %a
}

define <vscale x 32 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv32i8_i8(<vscale x 32 x i1> %0, <vscale x 32 x i8> %1, i8 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv32i8_i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    vmslt.vx v12, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v12
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 32 x i1> @llvm.riscv.vmsge.mask.nxv32i8.i8(
    <vscale x 32 x i1> %0,
    <vscale x 32 x i8> %1,
    i8 %2,
    <vscale x 32 x i1> %0,
    iXLen %3)

  ret <vscale x 32 x i1> %a
}

define <vscale x 1 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv1i16_i16(<vscale x 1 x i1> %0, <vscale x 1 x i16> %1, i16 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv1i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i16.i16(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i16> %1,
    i16 %2,
    <vscale x 1 x i1> %0,
    iXLen %3)

  ret <vscale x 1 x i1> %a
}

define <vscale x 2 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv2i16_i16(<vscale x 2 x i1> %0, <vscale x 2 x i16> %1, i16 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv2i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i16.i16(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i16> %1,
    i16 %2,
    <vscale x 2 x i1> %0,
    iXLen %3)

  ret <vscale x 2 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv4i16_i16(<vscale x 4 x i1> %0, <vscale x 4 x i16> %1, i16 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv4i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i16.i16(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i16> %1,
    i16 %2,
    <vscale x 4 x i1> %0,
    iXLen %3)

  ret <vscale x 4 x i1> %a
}

define <vscale x 8 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv8i16_i16(<vscale x 8 x i1> %0, <vscale x 8 x i16> %1, i16 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv8i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    vmslt.vx v10, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i16.i16(
    <vscale x 8 x i1> %0,
    <vscale x 8 x i16> %1,
    i16 %2,
    <vscale x 8 x i1> %0,
    iXLen %3)

  ret <vscale x 8 x i1> %a
}

define <vscale x 16 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv16i16_i16(<vscale x 16 x i1> %0, <vscale x 16 x i16> %1, i16 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv16i16_i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vmslt.vx v12, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v12
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 16 x i1> @llvm.riscv.vmsge.mask.nxv16i16.i16(
    <vscale x 16 x i1> %0,
    <vscale x 16 x i16> %1,
    i16 %2,
    <vscale x 16 x i1> %0,
    iXLen %3)

  ret <vscale x 16 x i1> %a
}

define <vscale x 1 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv1i32_i32(<vscale x 1 x i1> %0, <vscale x 1 x i32> %1, i32 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv1i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i32.i32(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i32> %1,
    i32 %2,
    <vscale x 1 x i1> %0,
    iXLen %3)

  ret <vscale x 1 x i1> %a
}

define <vscale x 2 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv2i32_i32(<vscale x 2 x i1> %0, <vscale x 2 x i32> %1, i32 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv2i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    vmslt.vx v8, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v8
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i32.i32(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i32> %1,
    i32 %2,
    <vscale x 2 x i1> %0,
    iXLen %3)

  ret <vscale x 2 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv4i32_i32(<vscale x 4 x i1> %0, <vscale x 4 x i32> %1, i32 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv4i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    vmslt.vx v10, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v10
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i32.i32(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i32> %1,
    i32 %2,
    <vscale x 4 x i1> %0,
    iXLen %3)

  ret <vscale x 4 x i1> %a
}

define <vscale x 8 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv8i32_i32(<vscale x 8 x i1> %0, <vscale x 8 x i32> %1, i32 %2, iXLen %3) nounwind {
; CHECK-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv8i32_i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    vmslt.vx v12, v8, a0
; CHECK-NEXT:    vmandn.mm v0, v0, v12
; CHECK-NEXT:    ret
entry:
  %a = call <vscale x 8 x i1> @llvm.riscv.vmsge.mask.nxv8i32.i32(
    <vscale x 8 x i1> %0,
    <vscale x 8 x i32> %1,
    i32 %2,
    <vscale x 8 x i1> %0,
    iXLen %3)

  ret <vscale x 8 x i1> %a
}

define <vscale x 1 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv1i64_i64(<vscale x 1 x i1> %0, <vscale x 1 x i64> %1, i64 %2, iXLen %3) nounwind {
; RV32-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv1i64_i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli zero, a2, e64, m1, ta, mu
; RV32-NEXT:    vlse64.v v9, (a0), zero
; RV32-NEXT:    vmsle.vv v0, v9, v8, v0.t
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv1i64_i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetvli zero, a1, e64, m1, ta, ma
; RV64-NEXT:    vmslt.vx v8, v8, a0
; RV64-NEXT:    vmandn.mm v0, v0, v8
; RV64-NEXT:    ret
entry:
  %a = call <vscale x 1 x i1> @llvm.riscv.vmsge.mask.nxv1i64.i64(
    <vscale x 1 x i1> %0,
    <vscale x 1 x i64> %1,
    i64 %2,
    <vscale x 1 x i1> %0,
    iXLen %3)

  ret <vscale x 1 x i1> %a
}

define <vscale x 2 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv2i64_i64(<vscale x 2 x i1> %0, <vscale x 2 x i64> %1, i64 %2, iXLen %3) nounwind {
; RV32-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv2i64_i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli zero, a2, e64, m2, ta, mu
; RV32-NEXT:    vlse64.v v12, (a0), zero
; RV32-NEXT:    vmv1r.v v10, v0
; RV32-NEXT:    vmsle.vv v10, v12, v8, v0.t
; RV32-NEXT:    vmv1r.v v0, v10
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv2i64_i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetvli zero, a1, e64, m2, ta, ma
; RV64-NEXT:    vmslt.vx v10, v8, a0
; RV64-NEXT:    vmandn.mm v0, v0, v10
; RV64-NEXT:    ret
entry:
  %a = call <vscale x 2 x i1> @llvm.riscv.vmsge.mask.nxv2i64.i64(
    <vscale x 2 x i1> %0,
    <vscale x 2 x i64> %1,
    i64 %2,
    <vscale x 2 x i1> %0,
    iXLen %3)

  ret <vscale x 2 x i1> %a
}

define <vscale x 4 x i1> @intrinsic_vmsge_maskedoff_mask_vx_nxv4i64_i64(<vscale x 4 x i1> %0, <vscale x 4 x i64> %1, i64 %2, iXLen %3) nounwind {
; RV32-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv4i64_i64:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    addi sp, sp, -16
; RV32-NEXT:    sw a0, 8(sp)
; RV32-NEXT:    sw a1, 12(sp)
; RV32-NEXT:    addi a0, sp, 8
; RV32-NEXT:    vsetvli zero, a2, e64, m4, ta, mu
; RV32-NEXT:    vlse64.v v16, (a0), zero
; RV32-NEXT:    vmv1r.v v12, v0
; RV32-NEXT:    vmsle.vv v12, v16, v8, v0.t
; RV32-NEXT:    vmv1r.v v0, v12
; RV32-NEXT:    addi sp, sp, 16
; RV32-NEXT:    ret
;
; RV64-LABEL: intrinsic_vmsge_maskedoff_mask_vx_nxv4i64_i64:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetvli zero, a1, e64, m4, ta, ma
; RV64-NEXT:    vmslt.vx v12, v8, a0
; RV64-NEXT:    vmandn.mm v0, v0, v12
; RV64-NEXT:    ret
entry:
  %a = call <vscale x 4 x i1> @llvm.riscv.vmsge.mask.nxv4i64.i64(
    <vscale x 4 x i1> %0,
    <vscale x 4 x i64> %1,
    i64 %2,
    <vscale x 4 x i1> %0,
    iXLen %3)

  ret <vscale x 4 x i1> %a
}
