; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 4
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr='+v' -verify-machineinstrs | FileCheck %s --check-prefix=RV32
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr='+v' -verify-machineinstrs | FileCheck %s --check-prefix=RV64

define iXLen @bool_vec(<vscale x 2 x i1> %src, <vscale x 2 x i1> %m, i32 %evl) {
; RV32-LABEL: bool_vec:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; RV32-NEXT:    vmv1r.v v9, v0
; RV32-NEXT:    vmv1r.v v0, v8
; RV32-NEXT:    vfirst.m a1, v9, v0.t
; RV32-NEXT:    bltz a1, .LBB0_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:  .LBB0_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: bool_vec:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e8, m1, ta, ma
; RV64-NEXT:    vmv1r.v v9, v0
; RV64-NEXT:    slli a0, a0, 32
; RV64-NEXT:    srli a0, a0, 32
; RV64-NEXT:    vmv1r.v v0, v8
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; RV64-NEXT:    vfirst.m a1, v9, v0.t
; RV64-NEXT:    bltz a1, .LBB0_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:  .LBB0_2:
; RV64-NEXT:    ret
  %r = call iXLen @llvm.vp.cttz.elts.iXLen.nxv2i1(<vscale x 2 x i1> %src, i1 0, <vscale x 2 x i1> %m, i32 %evl)
  ret iXLen %r
}

define iXLen @bool_vec_zero_poison(<vscale x 2 x i1> %src, <vscale x 2 x i1> %m, i32 %evl) {
; RV32-LABEL: bool_vec_zero_poison:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; RV32-NEXT:    vmv1r.v v9, v0
; RV32-NEXT:    vmv1r.v v0, v8
; RV32-NEXT:    vfirst.m a0, v9, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: bool_vec_zero_poison:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 1, e8, m1, ta, ma
; RV64-NEXT:    vmv1r.v v9, v0
; RV64-NEXT:    slli a0, a0, 32
; RV64-NEXT:    srli a0, a0, 32
; RV64-NEXT:    vmv1r.v v0, v8
; RV64-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; RV64-NEXT:    vfirst.m a0, v9, v0.t
; RV64-NEXT:    ret
  %r = call iXLen @llvm.vp.cttz.elts.iXLen.nxv2i1(<vscale x 2 x i1> %src, i1 1, <vscale x 2 x i1> %m, i32 %evl)
  ret iXLen %r
}

define iXLen @nxv2i32(<vscale x 2 x i32> %src, <vscale x 2 x i1> %m, i32 %evl) {
; RV32-LABEL: nxv2i32:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV32-NEXT:    vmsne.vi v8, v8, 0, v0.t
; RV32-NEXT:    vfirst.m a1, v8, v0.t
; RV32-NEXT:    bltz a1, .LBB2_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:  .LBB2_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv2i32:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 32
; RV64-NEXT:    srli a0, a0, 32
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV64-NEXT:    vmsne.vi v8, v8, 0, v0.t
; RV64-NEXT:    vfirst.m a1, v8, v0.t
; RV64-NEXT:    bltz a1, .LBB2_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:  .LBB2_2:
; RV64-NEXT:    ret
  %r = call iXLen @llvm.vp.cttz.elts.iXLen.nxv2i32(<vscale x 2 x i32> %src, i1 0, <vscale x 2 x i1> %m, i32 %evl)
  ret iXLen %r
}

define iXLen @nxv2i32_zero_poison(<vscale x 2 x i32> %src, <vscale x 2 x i1> %m, i32 %evl) {
; RV32-LABEL: nxv2i32_zero_poison:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV32-NEXT:    vmsne.vi v8, v8, 0, v0.t
; RV32-NEXT:    vfirst.m a0, v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv2i32_zero_poison:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 32
; RV64-NEXT:    srli a0, a0, 32
; RV64-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV64-NEXT:    vmsne.vi v8, v8, 0, v0.t
; RV64-NEXT:    vfirst.m a0, v8, v0.t
; RV64-NEXT:    ret
  %r = call iXLen @llvm.vp.cttz.elts.iXLen.nxv2i32(<vscale x 2 x i32> %src, i1 1, <vscale x 2 x i1> %m, i32 %evl)
  ret iXLen %r
}

define iXLen @nxv2i64(<vscale x 2 x i64> %src, <vscale x 2 x i1> %m, i32 %evl) {
; RV32-LABEL: nxv2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vmsne.vi v10, v8, 0, v0.t
; RV32-NEXT:    vfirst.m a1, v10, v0.t
; RV32-NEXT:    bltz a1, .LBB4_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:  .LBB4_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 32
; RV64-NEXT:    srli a0, a0, 32
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV64-NEXT:    vmsne.vi v10, v8, 0, v0.t
; RV64-NEXT:    vfirst.m a1, v10, v0.t
; RV64-NEXT:    bltz a1, .LBB4_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:  .LBB4_2:
; RV64-NEXT:    ret
  %r = call iXLen @llvm.vp.cttz.elts.iXLen.nxv2i64(<vscale x 2 x i64> %src, i1 0, <vscale x 2 x i1> %m, i32 %evl)
  ret iXLen %r
}

define iXLen @nxv2i64_zero_poison(<vscale x 2 x i64> %src, <vscale x 2 x i1> %m, i32 %evl) {
; RV32-LABEL: nxv2i64_zero_poison:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV32-NEXT:    vmsne.vi v10, v8, 0, v0.t
; RV32-NEXT:    vfirst.m a0, v10, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv2i64_zero_poison:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 32
; RV64-NEXT:    srli a0, a0, 32
; RV64-NEXT:    vsetvli zero, a0, e64, m2, ta, ma
; RV64-NEXT:    vmsne.vi v10, v8, 0, v0.t
; RV64-NEXT:    vfirst.m a0, v10, v0.t
; RV64-NEXT:    ret
  %r = call iXLen @llvm.vp.cttz.elts.iXLen.nxv2i64(<vscale x 2 x i64> %src, i1 1, <vscale x 2 x i1> %m, i32 %evl)
  ret iXLen %r
}

define i1 @nxv2i32_cmp_evl(<vscale x 2 x i32> %src, <vscale x 2 x i1> %m, i32 %evl) {
; RV32-LABEL: nxv2i32_cmp_evl:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; RV32-NEXT:    vmsne.vi v8, v8, 0, v0.t
; RV32-NEXT:    vfirst.m a2, v8, v0.t
; RV32-NEXT:    mv a1, a0
; RV32-NEXT:    bltz a2, .LBB6_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a1, a2
; RV32-NEXT:  .LBB6_2:
; RV32-NEXT:    xor a0, a1, a0
; RV32-NEXT:    seqz a0, a0
; RV32-NEXT:    ret
;
; RV64-LABEL: nxv2i32_cmp_evl:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a1, a0, 32
; RV64-NEXT:    srli a1, a1, 32
; RV64-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; RV64-NEXT:    vmsne.vi v8, v8, 0, v0.t
; RV64-NEXT:    vfirst.m a2, v8, v0.t
; RV64-NEXT:    sext.w a0, a0
; RV64-NEXT:    bltz a2, .LBB6_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a1, a2
; RV64-NEXT:  .LBB6_2:
; RV64-NEXT:    sext.w a1, a1
; RV64-NEXT:    xor a0, a1, a0
; RV64-NEXT:    seqz a0, a0
; RV64-NEXT:    ret
  %r = call i32 @llvm.vp.cttz.elts.i32.nxv2i32(<vscale x 2 x i32> %src, i1 0, <vscale x 2 x i1> %m, i32 %evl)
  %cmp = icmp eq i32 %r, %evl
  ret i1 %cmp
}

define iXLen @fixed_v2i64(<2 x i64> %src, <2 x i1> %m, i32 %evl) {
; RV32-LABEL: fixed_v2i64:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vmsne.vi v8, v8, 0, v0.t
; RV32-NEXT:    vfirst.m a1, v8, v0.t
; RV32-NEXT:    bltz a1, .LBB7_2
; RV32-NEXT:  # %bb.1:
; RV32-NEXT:    mv a0, a1
; RV32-NEXT:  .LBB7_2:
; RV32-NEXT:    ret
;
; RV64-LABEL: fixed_v2i64:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 32
; RV64-NEXT:    srli a0, a0, 32
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV64-NEXT:    vmsne.vi v8, v8, 0, v0.t
; RV64-NEXT:    vfirst.m a1, v8, v0.t
; RV64-NEXT:    bltz a1, .LBB7_2
; RV64-NEXT:  # %bb.1:
; RV64-NEXT:    mv a0, a1
; RV64-NEXT:  .LBB7_2:
; RV64-NEXT:    ret
  %r = call iXLen @llvm.vp.cttz.elts.iXLen.v2i64(<2 x i64> %src, i1 0, <2 x i1> %m, i32 %evl)
  ret iXLen %r
}

define iXLen @fixed_v2i64_zero_poison(<2 x i64> %src, <2 x i1> %m, i32 %evl) {
; RV32-LABEL: fixed_v2i64_zero_poison:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV32-NEXT:    vmsne.vi v8, v8, 0, v0.t
; RV32-NEXT:    vfirst.m a0, v8, v0.t
; RV32-NEXT:    ret
;
; RV64-LABEL: fixed_v2i64_zero_poison:
; RV64:       # %bb.0:
; RV64-NEXT:    slli a0, a0, 32
; RV64-NEXT:    srli a0, a0, 32
; RV64-NEXT:    vsetvli zero, a0, e64, m1, ta, ma
; RV64-NEXT:    vmsne.vi v8, v8, 0, v0.t
; RV64-NEXT:    vfirst.m a0, v8, v0.t
; RV64-NEXT:    ret
  %r = call iXLen @llvm.vp.cttz.elts.iXLen.v2i64(<2 x i64> %src, i1 1, <2 x i1> %m, i32 %evl)
  ret iXLen %r
}

declare iXLen @llvm.vp.cttz.elts.iXLen.nxv2i1(<vscale x 2 x i1>, i1, <vscale x 2 x i1>, i32)
declare iXLen @llvm.vp.cttz.elts.iXLen.nxv2i32(<vscale x 2 x i32>, i1, <vscale x 2 x i1>, i32)
declare iXLen @llvm.vp.cttz.elts.iXLen.nxv2i64(<vscale x 2 x i64>, i1, <vscale x 2 x i1>, i32)
declare iXLen @llvm.vp.cttz.elts.iXLen.v2i64(<2 x i64>, i1, <2 x i1>, i32)
