; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvbb,+prefer-w-inst \
; RUN:   -verify-machineinstrs < %s | FileCheck %s

define <vscale x 1 x i8> @vrol_vx_nxv1i8(<vscale x 1 x i8> %a, i8 %b) {
; CHECK-LABEL: vrol_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiw a0, a0, 1
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vrol.vx v8, v8, a0
; CHECK-NEXT:    ret
  %s = add i8 %b, 1
  %b.head = insertelement <vscale x 1 x i8> poison, i8 %s, i32 0
  %b.splat = shufflevector <vscale x 1 x i8> %b.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %x = call <vscale x 1 x i8> @llvm.fshl.nxv1i8(<vscale x 1 x i8> %a, <vscale x 1 x i8> %a, <vscale x 1 x i8> %b.splat)
  ret <vscale x 1 x i8> %x
}

define <vscale x 1 x i8> @vror_vx_nxv1i8(<vscale x 1 x i8> %a, i8 %b) {
; CHECK-LABEL: vror_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiw a0, a0, 1
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vror.vx v8, v8, a0
; CHECK-NEXT:    ret
  %s = add i8 %b, 1
  %b.head = insertelement <vscale x 1 x i8> poison, i8 %s, i32 0
  %b.splat = shufflevector <vscale x 1 x i8> %b.head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %x = call <vscale x 1 x i8> @llvm.fshr.nxv1i8(<vscale x 1 x i8> %a, <vscale x 1 x i8> %a, <vscale x 1 x i8> %b.splat)
  ret <vscale x 1 x i8> %x
}

define <vscale x 2 x i64> @vwsll_vx_i8_nxv2i64_zext(<vscale x 2 x i32> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_nxv2i64_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vmv1r.v v10, v8
; CHECK-NEXT:    addiw a0, a0, 1
; CHECK-NEXT:    vwsll.vx v8, v10, a0
; CHECK-NEXT:    ret
  %s = add i8 %b, 1
  %head = insertelement <vscale x 2 x i8> poison, i8 %s, i32 0
  %splat = shufflevector <vscale x 2 x i8> %head, <vscale x 2 x i8> poison, <vscale x 2 x i32> zeroinitializer
  %x = zext <vscale x 2 x i32> %a to <vscale x 2 x i64>
  %y = zext <vscale x 2 x i8> %splat to <vscale x 2 x i64>
  %z = shl <vscale x 2 x i64> %x, %y
  ret <vscale x 2 x i64> %z
}

define <vscale x 1 x i8> @vandn_vx_nxv1i8(i8 %x, <vscale x 1 x i8> %y) {
; CHECK-LABEL: vandn_vx_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addiw a0, a0, 1
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vandn.vx v8, v8, a0
; CHECK-NEXT:    ret
  %s = add i8 %x, 1
  %a = xor i8 %s, -1
  %head = insertelement <vscale x 1 x i8> poison, i8 %a, i32 0
  %splat = shufflevector <vscale x 1 x i8> %head, <vscale x 1 x i8> poison, <vscale x 1 x i32> zeroinitializer
  %b = and <vscale x 1 x i8> %splat, %y
  ret <vscale x 1 x i8> %b
}
