; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-pc-linux-gnu -mattr=+zu | FileCheck %s --check-prefixes=CHECK,ZU
; RUN: llc < %s -mtriple=x86_64-pc-linux-gnu | FileCheck %s --check-prefixes=CHECK,NOZU

; Test generation of 16b imulzu when -mattr=+zu is specified.
; The mulzu_* tests check for basic generation, which is limited to cases where a
; zero-extend of the result can be folded into imulzu.
; The remaining tests are modifications of selected test/CodeGen/X86/imul.ll tests with
; 16b multiplies, to check that common strength reductions in ISel are still performed
; when -mattr=+zu is in effect.
;
; FIXME: several cases from imul.ll covering DAG combines, in particular those using LEA,
; are not ported as X86's IsDesirableToPromoteOp has no way to accurately identify when
; promotion will permit a better sequence than an unpromoted imulzu.
; These cases should be added when they are implemented.

define i32 @mulzu_16_32(i16 %A) {
; ZU-LABEL: mulzu_16_32:
; ZU:       # %bb.0:
; ZU-NEXT:    imulzuw $1234, %di, %ax # imm = 0x4D2
; ZU-NEXT:    retq
;
; NOZU-LABEL: mulzu_16_32:
; NOZU:       # %bb.0:
; NOZU-NEXT:    imull $1234, %edi, %eax # imm = 0x4D2
; NOZU-NEXT:    movzwl %ax, %eax
; NOZU-NEXT:    retq
    %mul = mul i16 %A, 1234
    %r = zext i16 %mul to i32
    ret i32 %r
}

define i64 @mulzu_16_64(i16 %A) {
; ZU-LABEL: mulzu_16_64:
; ZU:       # %bb.0:
; ZU-NEXT:    imulzuw $1234, %di, %ax # imm = 0x4D2
; ZU-NEXT:    retq
;
; NOZU-LABEL: mulzu_16_64:
; NOZU:       # %bb.0:
; NOZU-NEXT:    imull $1234, %edi, %eax # imm = 0x4D2
; NOZU-NEXT:    movzwl %ax, %eax
; NOZU-NEXT:    retq
    %mul = mul i16 %A, 1234
    %r = zext i16 %mul to i64
    ret i64 %r
}

define i32 @mulzu_16_32_mem(ptr %P) {
; ZU-LABEL: mulzu_16_32_mem:
; ZU:       # %bb.0:
; ZU-NEXT:    imulzuw $1234, (%rdi), %ax # imm = 0x4D2
; ZU-NEXT:    retq
;
; NOZU-LABEL: mulzu_16_32_mem:
; NOZU:       # %bb.0:
; NOZU-NEXT:    movzwl (%rdi), %eax
; NOZU-NEXT:    imull $1234, %eax, %eax # imm = 0x4D2
; NOZU-NEXT:    movzwl %ax, %eax
; NOZU-NEXT:    retq
    %gep = getelementptr i16, ptr %P, i64 0
    %A = load i16, ptr %gep
    %mul = mul i16 %A, 1234
    %r = zext i16 %mul to i32
    ret i32 %r
}

define i64 @mulzu_16_64_mem(ptr %P) {
; ZU-LABEL: mulzu_16_64_mem:
; ZU:       # %bb.0:
; ZU-NEXT:    imulzuw $1234, (%rdi), %ax # imm = 0x4D2
; ZU-NEXT:    retq
;
; NOZU-LABEL: mulzu_16_64_mem:
; NOZU:       # %bb.0:
; NOZU-NEXT:    movzwl (%rdi), %eax
; NOZU-NEXT:    imull $1234, %eax, %eax # imm = 0x4D2
; NOZU-NEXT:    movzwl %ax, %eax
; NOZU-NEXT:    retq
    %gep = getelementptr i16, ptr %P, i64 0
    %A = load i16, ptr %gep
    %mul = mul i16 %A, 1234
    %r = zext i16 %mul to i64
    ret i64 %r
}

; The following mulzu cases check that imulzu is not
; generated in the absence of a single zext user. The ZU/NOZU
; cases should match.

define void @mulzu_16_store(i16 %A, ptr %R) {
; CHECK-LABEL: mulzu_16_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    imull $1234, %edi, %eax # imm = 0x4D2
; CHECK-NEXT:    movw %ax, (%rsi)
; CHECK-NEXT:    retq
    %gep = getelementptr i16, ptr %R, i64 0
    %mul = mul i16 %A, 1234
    store i16 %mul, ptr %gep
    ret void
}

define i32 @mulzu_16_store_32(i16 %A, ptr %R) {
; CHECK-LABEL: mulzu_16_store_32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    imull $1234, %edi, %eax # imm = 0x4D2
; CHECK-NEXT:    movw %ax, (%rsi)
; CHECK-NEXT:    movzwl %ax, %eax
; CHECK-NEXT:    retq
    %gep = getelementptr i16, ptr %R, i64 0
    %mul = mul i16 %A, 1234
    store i16 %mul, ptr %gep
    %r = zext i16 %mul to i32
    ret i32 %r
}

define i64 @mulzu_16_store_64(i16 %A, ptr %R) {
; CHECK-LABEL: mulzu_16_store_64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    imull $1234, %edi, %eax # imm = 0x4D2
; CHECK-NEXT:    movw %ax, (%rsi)
; CHECK-NEXT:    movzwl %ax, %eax
; CHECK-NEXT:    retq
    %gep = getelementptr i16, ptr %R, i64 0
    %mul = mul i16 %A, 1234
    store i16 %mul, ptr %gep
    %r = zext i16 %mul to i64
    ret i64 %r
}

define i32 @mulzu_sext_16_32(i16 %A) {
; CHECK-LABEL: mulzu_sext_16_32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    imull $1234, %edi, %eax # imm = 0x4D2
; CHECK-NEXT:    cwtl
; CHECK-NEXT:    retq
    %mul = mul i16 %A, 1234
    %r = sext i16 %mul to i32
    ret i32 %r
}

define i64 @mulzu_sext_16_64(i16 %A) {
; CHECK-LABEL: mulzu_sext_16_64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    imull $1234, %edi, %eax # imm = 0x4D2
; CHECK-NEXT:    movswq %ax, %rax
; CHECK-NEXT:    retq
    %mul = mul i16 %A, 1234
    %r = sext i16 %mul to i64
    ret i64 %r
}

; Tests ported from test/CodeGen/X86/imul.ll follow from this point.
; The generated code, which strength-reduces multiplies by certain
; constants, should be unaffected by enabling zu.

define i16 @mul4_16(i16 %A) {
;
; CHECK-LABEL: mul4_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NEXT:    leal (,%rdi,4), %eax
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq
    %mul = mul i16 %A, 4
    ret i16 %mul
}

define i16 @mul4096_16(i16 %A) {
;
; CHECK-LABEL: mul4096_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    shll $12, %eax
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq
    %mul = mul i16 %A, 4096
    ret i16 %mul
}

define i16 @mulmin4096_16(i16 %A) {
;
; CHECK-LABEL: mulmin4096_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    shll $12, %eax
; CHECK-NEXT:    negl %eax
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq
    %mul = mul i16 %A, -4096
    ret i16 %mul
}

define i16 @mul4_16_minsize(i16 %A) minsize {
;
; CHECK-LABEL: mul4_16_minsize:
; CHECK:       # %bb.0:
; CHECK-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NEXT:    leal (,%rdi,4), %eax
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq
    %mul = mul i16 %A, 4
    ret i16 %mul
}

define i16 @mul0_16(i16 %A) {
;
; CHECK-LABEL: mul0_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    retq
    %mul = mul i16 %A, 0
    ret i16 %mul
}

define i16 @mul4294967295_16(i16 %A) {
;
; CHECK-LABEL: mul4294967295_16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    negl %eax
; CHECK-NEXT:    # kill: def $ax killed $ax killed $eax
; CHECK-NEXT:    retq
    %mul = mul i16 %A, 4294967295
    ret i16 %mul
}
