; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-unknown-unknown -x86-early-ifcvt -debug-only=early-ifcvt < %s 2>&1 | FileCheck %s
; REQUIRES: asserts

; This test case ensures that machine trace metrics properly calculates
; instructions heights and the trace's critical path for the entry block when
; MinInstr strategy is used. The behavior is demonstrated on early if conversion
; pass.

; CHECK: TBB: MinInstr trace %bb.0 --> %bb.0 --> %bb.2: 8 instrs. 30 cycles.
; CHECK: %bb.0
; CHECK:     -> %bb.2

; CHECK: FBB: MinInstr trace %bb.0 --> %bb.1 --> %bb.2: 10 instrs. 32 cycles.
; CHECK: %bb.1 <- %bb.0
; CHECK:     -> %bb.2

; CHECK: Resource length 10, minimal critical path 30
; CHECK: If-converting

define i32 @_Z3fooiidd(i32 %a, i32 %b, double %d, double %e) #0 {
; CHECK-LABEL: _Z3fooiidd:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $esi killed $esi def $rsi
; CHECK-NEXT:    # kill: def $edi killed $edi def $rdi
; CHECK-NEXT:    leal (%rsi,%rdi), %ecx
; CHECK-NEXT:    cvttsd2si %xmm0, %eax
; CHECK-NEXT:    addl %ecx, %eax
; CHECK-NEXT:    cmpl $3, %edi
; CHECK-NEXT:    cmovll %ecx, %eax
; CHECK-NEXT:    cvttsd2si %xmm1, %ecx
; CHECK-NEXT:    cltd
; CHECK-NEXT:    idivl %ecx
; CHECK-NEXT:    retq
entry:
  %add = add nsw i32 %b, %a
  %cmp = icmp sgt i32 %a, 2
  br i1 %cmp, label %if.then, label %if.end

if.then:
  %conv = fptosi double %d to i32
  %add1 = add nsw i32 %add, %conv
  br label %if.end

if.end:
  %tmp.0 = phi i32 [ %add1, %if.then ], [ %add, %entry ]
  %conv2 = fptosi double %e to i32
  %div = sdiv i32 %tmp.0, %conv2
  ret i32 %div
}

attributes #0 = { "tune-cpu"="generic" }

