; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt %s -S -mattr=+avx512f -passes=msan 2>&1 | FileCheck %s
;
; Forked from llvm/test/CodeGen/X86/avx512fp16-intrinsics.ll
;
; Handled suboptimally (visitInstruction):
; - llvm.x86.avx512fp16.fpclass.ph.512
; - llvm.x86.avx512fp16.mask.add.sh.round
; - llvm.x86.avx512fp16.mask.cmp.sh
; - llvm.x86.avx512fp16.mask.div.sh.round
; - llvm.x86.avx512fp16.mask.fpclass.sh
; - llvm.x86.avx512fp16.mask.getexp.ph.512
; - llvm.x86.avx512fp16.mask.getexp.sh
; - llvm.x86.avx512fp16.mask.getmant.ph.512
; - llvm.x86.avx512fp16.mask.getmant.sh
; - llvm.x86.avx512fp16.mask.rcp.ph.512
; - llvm.x86.avx512fp16.mask.rcp.sh
; - llvm.x86.avx512fp16.mask.reduce.ph.512
; - llvm.x86.avx512fp16.mask.reduce.sh
; - llvm.x86.avx512fp16.mask.rndscale.ph.512
; - llvm.x86.avx512fp16.mask.rndscale.sh
; - llvm.x86.avx512fp16.mask.rsqrt.ph.512
; - llvm.x86.avx512fp16.mask.rsqrt.sh
; - llvm.x86.avx512fp16.mask.scalef.ph.512
; - llvm.x86.avx512fp16.mask.scalef.sh
; - llvm.x86.avx512fp16.mask.sqrt.sh
; - llvm.x86.avx512fp16.mask.vcvtph2dq.512
; - llvm.x86.avx512fp16.mask.vcvtph2qq.512
; - llvm.x86.avx512fp16.mask.vcvtph2udq.512
; - llvm.x86.avx512fp16.mask.vcvtph2uqq.512
; - llvm.x86.avx512fp16.mask.vcvttph2dq.512
; - llvm.x86.avx512fp16.mask.vcvttph2udq.512
; - llvm.x86.avx512fp16.mask.vcvttph2uqq.512
; - llvm.x86.avx512fp16.sqrt.ph.512
; - llvm.x86.avx512fp16.vcomi.sh
; - llvm.x86.avx512fp16.vcvtsh2si32
; - llvm.x86.avx512fp16.vcvtsh2si64
; - llvm.x86.avx512fp16.vcvtsh2usi32
; - llvm.x86.avx512fp16.vcvtsh2usi64
; - llvm.x86.avx512fp16.vcvtsi2sh
; - llvm.x86.avx512fp16.vcvtsi642sh
; - llvm.x86.avx512fp16.vcvttsh2si32
; - llvm.x86.avx512fp16.vcvttsh2si64
; - llvm.x86.avx512fp16.vcvttsh2usi32
; - llvm.x86.avx512fp16.vcvttsh2usi64
; - llvm.x86.avx512fp16.vcvtusi2sh
; - llvm.x86.avx512fp16.vcvtusi642sh
; - llvm.x86.avx512.sitofp.round.v16f16.v16i32
; - llvm.x86.avx512.sitofp.round.v8f16.v8i64
; - llvm.x86.avx512.uitofp.round.v16f16.v16i32
; - llvm.x86.avx512.uitofp.round.v8f16.v8i64
;
; Handled heuristically:
; - llvm.sqrt.f16
; - llvm.sqrt.v32f16

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

declare i32 @llvm.x86.avx512fp16.vcomi.sh(<8 x half>, <8 x half>, i32, i32)

define i32 @test_x86_avx512fp16_ucomi_sh_lt(<8 x half> %a0, <8 x half> %a1) #0 {
; CHECK-LABEL: define i32 @test_x86_avx512fp16_ucomi_sh_lt(
; CHECK-SAME: <8 x half> [[A0:%.*]], <8 x half> [[A1:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB5:.*]], label %[[BB6:.*]], !prof [[PROF1:![0-9]+]]
; CHECK:       [[BB5]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8:[0-9]+]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB6]]:
; CHECK-NEXT:    [[RES:%.*]] = call i32 @llvm.x86.avx512fp16.vcomi.sh(<8 x half> [[A0]], <8 x half> [[A1]], i32 9, i32 4)
; CHECK-NEXT:    store i32 0, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.x86.avx512fp16.vcomi.sh(<8 x half> %a0, <8 x half> %a1, i32 9, i32 4)
  ret i32 %res
}

declare <32 x half> @llvm.x86.avx512fp16.sqrt.ph.512(<32 x half>, i32) nounwind readnone

define <32 x half> @test_sqrt_ph_512(<32 x half> %a0) #0 {
; CHECK-LABEL: define <32 x half> @test_sqrt_ph_512(
; CHECK-SAME: <32 x half> [[A0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = call <32 x half> @llvm.sqrt.v32f16(<32 x half> [[A0]])
; CHECK-NEXT:    store <32 x i16> [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[TMP2]]
;
  %1 = call <32 x half> @llvm.sqrt.v32f16(<32 x half> %a0)
  ret <32 x half> %1
}

define <32 x half> @test_sqrt_ph_512_fast(<32 x half> %a0, <32 x half> %a1) #0 {
; CHECK-LABEL: define <32 x half> @test_sqrt_ph_512_fast(
; CHECK-SAME: <32 x half> [[A0:%.*]], <32 x half> [[A1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <32 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = call fast <32 x half> @llvm.sqrt.v32f16(<32 x half> [[A0]])
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <32 x i16> [[TMP2]], [[TMP1]]
; CHECK-NEXT:    [[TMP4:%.*]] = fdiv fast <32 x half> [[A1]], [[TMP3]]
; CHECK-NEXT:    store <32 x i16> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[TMP4]]
;
  %1 = call fast <32 x half> @llvm.sqrt.v32f16(<32 x half> %a0)
  %2 = fdiv fast <32 x half> %a1, %1
  ret <32 x half> %2
}

define <32 x half> @test_sqrt_ph_512_fast_estimate_attribute(<32 x half> %a0, <32 x half> %a1) "reciprocal-estimates"="vec-sqrt" {
; CHECK-LABEL: define <32 x half> @test_sqrt_ph_512_fast_estimate_attribute(
; CHECK-SAME: <32 x half> [[A0:%.*]], <32 x half> [[A1:%.*]]) #[[ATTR2:[0-9]+]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <32 x half> @llvm.sqrt.v32f16(<32 x half> [[A0]])
; CHECK-NEXT:    [[TMP2:%.*]] = fdiv fast <32 x half> [[A1]], [[TMP1]]
; CHECK-NEXT:    store <32 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[TMP2]]
;
  %1 = call fast <32 x half> @llvm.sqrt.v32f16(<32 x half> %a0)
  %2 = fdiv fast <32 x half> %a1, %1
  ret <32 x half> %2
}

define <32 x half> @test_sqrt_ph_512_fast_estimate_attribute_2(<32 x half> %a0, <32 x half> %a1) "reciprocal-estimates"="vec-sqrth:1" {
; CHECK-LABEL: define <32 x half> @test_sqrt_ph_512_fast_estimate_attribute_2(
; CHECK-SAME: <32 x half> [[A0:%.*]], <32 x half> [[A1:%.*]]) #[[ATTR3:[0-9]+]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <32 x half> @llvm.sqrt.v32f16(<32 x half> [[A0]])
; CHECK-NEXT:    [[TMP2:%.*]] = fdiv fast <32 x half> [[A1]], [[TMP1]]
; CHECK-NEXT:    store <32 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[TMP2]]
;
  %1 = call fast <32 x half> @llvm.sqrt.v32f16(<32 x half> %a0)
  %2 = fdiv fast <32 x half> %a1, %1
  ret <32 x half> %2
}

define <32 x half> @test_mask_sqrt_ph_512(<32 x half> %a0, <32 x half> %passthru, i32 %mask) #0 {
; CHECK-LABEL: define <32 x half> @test_mask_sqrt_ph_512(
; CHECK-SAME: <32 x half> [[A0:%.*]], <32 x half> [[PASSTHRU:%.*]], i32 [[MASK:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 128) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <32 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = call <32 x half> @llvm.sqrt.v32f16(<32 x half> [[A0]])
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast i32 [[TMP2]] to <32 x i1>
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast i32 [[MASK]] to <32 x i1>
; CHECK-NEXT:    [[TMP7:%.*]] = select <32 x i1> [[TMP6]], <32 x i16> [[TMP1]], <32 x i16> [[TMP3]]
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <32 x half> [[TMP4]] to <32 x i16>
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <32 x half> [[PASSTHRU]] to <32 x i16>
; CHECK-NEXT:    [[TMP10:%.*]] = xor <32 x i16> [[TMP8]], [[TMP9]]
; CHECK-NEXT:    [[TMP11:%.*]] = or <32 x i16> [[TMP10]], [[TMP1]]
; CHECK-NEXT:    [[TMP12:%.*]] = or <32 x i16> [[TMP11]], [[TMP3]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <32 x i1> [[TMP5]], <32 x i16> [[TMP12]], <32 x i16> [[TMP7]]
; CHECK-NEXT:    [[TMP13:%.*]] = select <32 x i1> [[TMP6]], <32 x half> [[TMP4]], <32 x half> [[PASSTHRU]]
; CHECK-NEXT:    store <32 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[TMP13]]
;
  %1 = call <32 x half> @llvm.sqrt.v32f16(<32 x half> %a0)
  %2 = bitcast i32 %mask to <32 x i1>
  %3 = select <32 x i1> %2, <32 x half> %1, <32 x half> %passthru
  ret <32 x half> %3
}

define <32 x half> @test_maskz_sqrt_ph_512(<32 x half> %a0, i32 %mask) #0 {
; CHECK-LABEL: define <32 x half> @test_maskz_sqrt_ph_512(
; CHECK-SAME: <32 x half> [[A0:%.*]], i32 [[MASK:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = call <32 x half> @llvm.sqrt.v32f16(<32 x half> [[A0]])
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i32 [[TMP2]] to <32 x i1>
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast i32 [[MASK]] to <32 x i1>
; CHECK-NEXT:    [[TMP6:%.*]] = select <32 x i1> [[TMP5]], <32 x i16> [[TMP1]], <32 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast <32 x half> [[TMP3]] to <32 x i16>
; CHECK-NEXT:    [[TMP8:%.*]] = xor <32 x i16> [[TMP7]], zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = or <32 x i16> [[TMP8]], [[TMP1]]
; CHECK-NEXT:    [[TMP10:%.*]] = or <32 x i16> [[TMP9]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <32 x i1> [[TMP4]], <32 x i16> [[TMP10]], <32 x i16> [[TMP6]]
; CHECK-NEXT:    [[TMP11:%.*]] = select <32 x i1> [[TMP5]], <32 x half> [[TMP3]], <32 x half> zeroinitializer
; CHECK-NEXT:    store <32 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[TMP11]]
;
  %1 = call <32 x half> @llvm.sqrt.v32f16(<32 x half> %a0)
  %2 = bitcast i32 %mask to <32 x i1>
  %3 = select <32 x i1> %2, <32 x half> %1, <32 x half> zeroinitializer
  ret <32 x half> %3
}

declare <32 x half> @llvm.sqrt.v32f16(<32 x half>)

define <32 x half> @test_sqrt_round_ph_512(<32 x half> %a0) #0 {
; CHECK-LABEL: define <32 x half> @test_sqrt_round_ph_512(
; CHECK-SAME: <32 x half> [[A0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[TMP5:%.*]] = call <32 x half> @llvm.x86.avx512fp16.sqrt.ph.512(<32 x half> [[A0]], i32 11)
; CHECK-NEXT:    store <32 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[TMP5]]
;
  %1 = call <32 x half> @llvm.x86.avx512fp16.sqrt.ph.512(<32 x half> %a0, i32 11)
  ret <32 x half> %1
}

define <32 x half> @test_mask_sqrt_round_ph_512(<32 x half> %a0, <32 x half> %passthru, i32 %mask) #0 {
; CHECK-LABEL: define <32 x half> @test_mask_sqrt_round_ph_512(
; CHECK-SAME: <32 x half> [[A0:%.*]], <32 x half> [[PASSTHRU:%.*]], i32 [[MASK:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 128) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <32 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP4]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB5:.*]], label %[[BB6:.*]], !prof [[PROF1]]
; CHECK:       [[BB5]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB6]]:
; CHECK-NEXT:    [[TMP7:%.*]] = call <32 x half> @llvm.x86.avx512fp16.sqrt.ph.512(<32 x half> [[A0]], i32 11)
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast i32 [[TMP2]] to <32 x i1>
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast i32 [[MASK]] to <32 x i1>
; CHECK-NEXT:    [[TMP10:%.*]] = select <32 x i1> [[TMP9]], <32 x i16> zeroinitializer, <32 x i16> [[TMP3]]
; CHECK-NEXT:    [[TMP11:%.*]] = bitcast <32 x half> [[TMP7]] to <32 x i16>
; CHECK-NEXT:    [[TMP12:%.*]] = bitcast <32 x half> [[PASSTHRU]] to <32 x i16>
; CHECK-NEXT:    [[TMP13:%.*]] = xor <32 x i16> [[TMP11]], [[TMP12]]
; CHECK-NEXT:    [[TMP14:%.*]] = or <32 x i16> [[TMP13]], zeroinitializer
; CHECK-NEXT:    [[TMP15:%.*]] = or <32 x i16> [[TMP14]], [[TMP3]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <32 x i1> [[TMP8]], <32 x i16> [[TMP15]], <32 x i16> [[TMP10]]
; CHECK-NEXT:    [[TMP16:%.*]] = select <32 x i1> [[TMP9]], <32 x half> [[TMP7]], <32 x half> [[PASSTHRU]]
; CHECK-NEXT:    store <32 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[TMP16]]
;
  %1 = call <32 x half> @llvm.x86.avx512fp16.sqrt.ph.512(<32 x half> %a0, i32 11)
  %2 = bitcast i32 %mask to <32 x i1>
  %3 = select <32 x i1> %2, <32 x half> %1, <32 x half> %passthru
  ret <32 x half> %3
}

define <32 x half> @test_maskz_sqrt_round_ph_512(<32 x half> %a0, i32 %mask) #0 {
; CHECK-LABEL: define <32 x half> @test_maskz_sqrt_round_ph_512(
; CHECK-SAME: <32 x half> [[A0:%.*]], i32 [[MASK:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP3]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[TMP6:%.*]] = call <32 x half> @llvm.x86.avx512fp16.sqrt.ph.512(<32 x half> [[A0]], i32 11)
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast i32 [[TMP2]] to <32 x i1>
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast i32 [[MASK]] to <32 x i1>
; CHECK-NEXT:    [[TMP9:%.*]] = select <32 x i1> [[TMP8]], <32 x i16> zeroinitializer, <32 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP10:%.*]] = bitcast <32 x half> [[TMP6]] to <32 x i16>
; CHECK-NEXT:    [[TMP11:%.*]] = xor <32 x i16> [[TMP10]], zeroinitializer
; CHECK-NEXT:    [[TMP12:%.*]] = or <32 x i16> [[TMP11]], zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = or <32 x i16> [[TMP12]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <32 x i1> [[TMP7]], <32 x i16> [[TMP13]], <32 x i16> [[TMP9]]
; CHECK-NEXT:    [[TMP14:%.*]] = select <32 x i1> [[TMP8]], <32 x half> [[TMP6]], <32 x half> zeroinitializer
; CHECK-NEXT:    store <32 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[TMP14]]
;
  %1 = call <32 x half> @llvm.x86.avx512fp16.sqrt.ph.512(<32 x half> %a0, i32 11)
  %2 = bitcast i32 %mask to <32 x i1>
  %3 = select <32 x i1> %2, <32 x half> %1, <32 x half> zeroinitializer
  ret <32 x half> %3
}

declare <8 x half> @llvm.x86.avx512fp16.mask.sqrt.sh(<8 x half>, <8 x half>, <8 x half>, i8, i32) nounwind readnone

define <8 x half> @test_sqrt_sh(<8 x half> %a0, <8 x half> %a1, <8 x half> %a2, i8 %mask) #0 {
; CHECK-LABEL: define <8 x half> @test_sqrt_sh(
; CHECK-SAME: <8 x half> [[A0:%.*]], <8 x half> [[A1:%.*]], <8 x half> [[A2:%.*]], i8 [[MASK:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP7]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    [[_MSOR5:%.*]] = or i1 [[_MSOR3]], [[_MSCMP4]]
; CHECK-NEXT:    br i1 [[_MSOR5]], label %[[BB8:.*]], label %[[BB9:.*]], !prof [[PROF1]]
; CHECK:       [[BB8]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB9]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.sqrt.sh(<8 x half> [[A0]], <8 x half> [[A1]], <8 x half> [[A2]], i8 [[MASK]], i32 4)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.sqrt.sh(<8 x half> %a0, <8 x half> %a1, <8 x half> %a2, i8 %mask, i32 4)
  ret <8 x half> %res
}

define half @test_sqrt_sh2(half %a0, half %a1) #0 {
; CHECK-LABEL: define half @test_sqrt_sh2(
; CHECK-SAME: half [[A0:%.*]], half [[A1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = call fast half @llvm.sqrt.f16(half [[A0]])
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i16 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    [[TMP4:%.*]] = fdiv fast half [[A1]], [[TMP3]]
; CHECK-NEXT:    store i16 [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret half [[TMP4]]
;
  %1 = call fast half @llvm.sqrt.f16(half %a0)
  %2 = fdiv fast half %a1, %1
  ret half %2
}

define half @test_sqrt_sh3(half %a0, half %a1) #0 {
; CHECK-LABEL: define half @test_sqrt_sh3(
; CHECK-SAME: half [[A0:%.*]], half [[A1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = call fast half @llvm.sqrt.f16(half [[A0]])
; CHECK-NEXT:    store i16 [[TMP1]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret half [[TMP2]]
;
  %1 = call fast half @llvm.sqrt.f16(half %a0)
  ret half %1
}

declare half @llvm.sqrt.f16(half)

define <8 x half> @test_sqrt_sh_r(<8 x half> %a0, <8 x half> %a1, <8 x half> %a2, i8 %mask) #0 {
; CHECK-LABEL: define <8 x half> @test_sqrt_sh_r(
; CHECK-SAME: <8 x half> [[A0:%.*]], <8 x half> [[A1:%.*]], <8 x half> [[A2:%.*]], i8 [[MASK:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP7]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    [[_MSOR5:%.*]] = or i1 [[_MSOR3]], [[_MSCMP4]]
; CHECK-NEXT:    br i1 [[_MSOR5]], label %[[BB8:.*]], label %[[BB9:.*]], !prof [[PROF1]]
; CHECK:       [[BB8]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB9]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.sqrt.sh(<8 x half> [[A0]], <8 x half> [[A1]], <8 x half> [[A2]], i8 [[MASK]], i32 10)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.sqrt.sh(<8 x half> %a0, <8 x half> %a1, <8 x half> %a2, i8 %mask, i32 10)
  ret <8 x half> %res
}

define <8 x half> @test_sqrt_sh_nomask(<8 x half> %a0, <8 x half> %a1, <8 x half> %a2) #0 {
; CHECK-LABEL: define <8 x half> @test_sqrt_sh_nomask(
; CHECK-SAME: <8 x half> [[A0:%.*]], <8 x half> [[A1:%.*]], <8 x half> [[A2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.sqrt.sh(<8 x half> [[A0]], <8 x half> [[A1]], <8 x half> [[A2]], i8 -1, i32 4)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.sqrt.sh(<8 x half> %a0, <8 x half> %a1, <8 x half> %a2, i8 -1, i32 4)
  ret <8 x half> %res
}

define <8 x half> @test_sqrt_sh_z(<8 x half> %a0, <8 x half> %a1, <8 x half> %a2, i8 %mask) #0 {
; CHECK-LABEL: define <8 x half> @test_sqrt_sh_z(
; CHECK-SAME: <8 x half> [[A0:%.*]], <8 x half> [[A1:%.*]], <8 x half> [[A2:%.*]], i8 [[MASK:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.sqrt.sh(<8 x half> [[A0]], <8 x half> [[A1]], <8 x half> zeroinitializer, i8 [[MASK]], i32 10)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.sqrt.sh(<8 x half> %a0, <8 x half> %a1, <8 x half> zeroinitializer, i8 %mask, i32 10)
  ret <8 x half> %res
}

declare <32 x half> @llvm.x86.avx512fp16.mask.rsqrt.ph.512(<32 x half>, <32 x half>, i32)
declare <8 x half> @llvm.x86.avx512fp16.mask.rsqrt.sh(<8 x half>, <8 x half>, <8 x half>, i8)

define <32 x half> @test_rsqrt_ph_512(<32 x half> %a0) #0 {
; CHECK-LABEL: define <32 x half> @test_rsqrt_ph_512(
; CHECK-SAME: <32 x half> [[A0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES:%.*]] = call <32 x half> @llvm.x86.avx512fp16.mask.rsqrt.ph.512(<32 x half> [[A0]], <32 x half> zeroinitializer, i32 -1)
; CHECK-NEXT:    store <32 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[RES]]
;
  %res = call <32 x half> @llvm.x86.avx512fp16.mask.rsqrt.ph.512(<32 x half> %a0, <32 x half> zeroinitializer, i32 -1)
  ret <32 x half> %res
}

define <8 x half> @test_rsqrt_sh(<8 x half> %a0, <8 x half> %a1, <8 x half> %a2) #0 {
; CHECK-LABEL: define <8 x half> @test_rsqrt_sh(
; CHECK-SAME: <8 x half> [[A0:%.*]], <8 x half> [[A1:%.*]], <8 x half> [[A2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.rsqrt.sh(<8 x half> [[A0]], <8 x half> [[A0]], <8 x half> [[A2]], i8 -1)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.rsqrt.sh(<8 x half> %a0, <8 x half> %a0, <8 x half> %a2, i8 -1)
  ret <8 x half> %res
}

define <8 x half> @test_rsqrt_sh_load(<8 x half> %a0, ptr %a1ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_rsqrt_sh_load(
; CHECK-SAME: <8 x half> [[A0:%.*]], ptr [[A1PTR:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[A1:%.*]] = load <8 x half>, ptr [[A1PTR]], align 16
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[A1PTR]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = xor i64 [[TMP5]], 87960930222080
; CHECK-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP6]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <8 x i16>, ptr [[TMP7]], align 16
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <8 x i16> [[_MSLD]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP1]], [[_MSCMP2]]
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.rsqrt.sh(<8 x half> [[A0]], <8 x half> [[A1]], <8 x half> poison, i8 -1)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %a1 = load <8 x half>, ptr %a1ptr
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.rsqrt.sh(<8 x half> %a0, <8 x half> %a1, <8 x half> poison, i8 -1)
  ret <8 x half> %res
}

define <8 x half> @test_rsqrt_sh_maskz(<8 x half> %a0, i8 %mask) #0 {
; CHECK-LABEL: define <8 x half> @test_rsqrt_sh_maskz(
; CHECK-SAME: <8 x half> [[A0:%.*]], i8 [[MASK:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB5:.*]], label %[[BB6:.*]], !prof [[PROF1]]
; CHECK:       [[BB5]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB6]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.rsqrt.sh(<8 x half> [[A0]], <8 x half> [[A0]], <8 x half> zeroinitializer, i8 [[MASK]])
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.rsqrt.sh(<8 x half> %a0, <8 x half> %a0, <8 x half> zeroinitializer, i8 %mask)
  ret <8 x half> %res
}

define <8 x half> @test_rsqrt_sh_mask(<8 x half> %a0, <8 x half> %b0, <8 x half> %c0, i8 %mask) #0 {
; CHECK-LABEL: define <8 x half> @test_rsqrt_sh_mask(
; CHECK-SAME: <8 x half> [[A0:%.*]], <8 x half> [[B0:%.*]], <8 x half> [[C0:%.*]], i8 [[MASK:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP7]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    [[_MSOR5:%.*]] = or i1 [[_MSOR3]], [[_MSCMP4]]
; CHECK-NEXT:    br i1 [[_MSOR5]], label %[[BB8:.*]], label %[[BB9:.*]], !prof [[PROF1]]
; CHECK:       [[BB8]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB9]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.rsqrt.sh(<8 x half> [[A0]], <8 x half> [[B0]], <8 x half> [[C0]], i8 [[MASK]])
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.rsqrt.sh(<8 x half> %a0, <8 x half> %b0, <8 x half> %c0, i8 %mask)
  ret <8 x half> %res
}

declare <32 x i1> @llvm.x86.avx512fp16.fpclass.ph.512(<32 x half>, i32)

define i32 @test_int_x86_avx512_fpclass_ph_512(<32 x half> %x0) #0 {
; CHECK-LABEL: define i32 @test_int_x86_avx512_fpclass_ph_512(
; CHECK-SAME: <32 x half> [[X0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES:%.*]] = call <32 x i1> @llvm.x86.avx512fp16.fpclass.ph.512(<32 x half> [[X0]], i32 4)
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <32 x i1> @llvm.x86.avx512fp16.fpclass.ph.512(<32 x half> [[X0]], i32 2)
; CHECK-NEXT:    [[TMP8:%.*]] = and <32 x i1> [[RES1]], zeroinitializer
; CHECK-NEXT:    [[TMP9:%.*]] = and <32 x i1> zeroinitializer, [[RES]]
; CHECK-NEXT:    [[TMP10:%.*]] = or <32 x i1> zeroinitializer, [[TMP8]]
; CHECK-NEXT:    [[TMP11:%.*]] = or <32 x i1> [[TMP10]], [[TMP9]]
; CHECK-NEXT:    [[TMP12:%.*]] = and <32 x i1> [[RES1]], [[RES]]
; CHECK-NEXT:    [[TMP13:%.*]] = bitcast <32 x i1> [[TMP11]] to i32
; CHECK-NEXT:    [[TMP14:%.*]] = bitcast <32 x i1> [[TMP12]] to i32
; CHECK-NEXT:    store i32 [[TMP13]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[TMP14]]
;
  %res = call <32 x i1> @llvm.x86.avx512fp16.fpclass.ph.512(<32 x half> %x0, i32 4)
  %res1 = call <32 x i1> @llvm.x86.avx512fp16.fpclass.ph.512(<32 x half> %x0, i32 2)
  %1 = and <32 x i1> %res1, %res
  %2 = bitcast <32 x i1> %1 to i32
  ret i32 %2
}

declare i8 @llvm.x86.avx512fp16.mask.fpclass.sh(<8 x half>, i32, i8)

define i8 @test_int_x86_avx512_mask_fpclass_sh(<8 x half> %x0) #0 {
; CHECK-LABEL: define i8 @test_int_x86_avx512_mask_fpclass_sh(
; CHECK-SAME: <8 x half> [[X0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES:%.*]] = call i8 @llvm.x86.avx512fp16.mask.fpclass.sh(<8 x half> [[X0]], i32 2, i8 -1)
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES1:%.*]] = call i8 @llvm.x86.avx512fp16.mask.fpclass.sh(<8 x half> [[X0]], i32 4, i8 [[RES]])
; CHECK-NEXT:    store i8 0, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i8 [[RES1]]
;
  %res = call i8 @llvm.x86.avx512fp16.mask.fpclass.sh(<8 x half> %x0, i32 2, i8 -1)
  %res1 = call i8 @llvm.x86.avx512fp16.mask.fpclass.sh(<8 x half> %x0, i32 4, i8 %res)
  ret i8 %res1
}

define i8 @test_int_x86_avx512_mask_fpclass_sh_load(ptr %x0ptr) #0 {
; CHECK-LABEL: define i8 @test_int_x86_avx512_mask_fpclass_sh_load(
; CHECK-SAME: ptr [[X0PTR:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB2:.*]], label %[[BB3:.*]], !prof [[PROF1]]
; CHECK:       [[BB2]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB3]]:
; CHECK-NEXT:    [[X0:%.*]] = load <8 x half>, ptr [[X0PTR]], align 16
; CHECK-NEXT:    [[TMP4:%.*]] = ptrtoint ptr [[X0PTR]] to i64
; CHECK-NEXT:    [[TMP5:%.*]] = xor i64 [[TMP4]], 87960930222080
; CHECK-NEXT:    [[TMP6:%.*]] = inttoptr i64 [[TMP5]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <8 x i16>, ptr [[TMP6]], align 16
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast <8 x i16> [[_MSLD]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP7]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB8:.*]], label %[[BB9:.*]], !prof [[PROF1]]
; CHECK:       [[BB8]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB9]]:
; CHECK-NEXT:    [[RES:%.*]] = call i8 @llvm.x86.avx512fp16.mask.fpclass.sh(<8 x half> [[X0]], i32 4, i8 -1)
; CHECK-NEXT:    store i8 0, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i8 [[RES]]
;
  %x0 = load <8 x half>, ptr %x0ptr
  %res = call i8 @llvm.x86.avx512fp16.mask.fpclass.sh(<8 x half> %x0, i32 4, i8 -1)
  ret i8 %res
}

declare <32 x half> @llvm.x86.avx512fp16.mask.rcp.ph.512(<32 x half>, <32 x half>, i32)

define <32 x half> @test_rcp_ph_512(<32 x half> %a0, <32 x half> %a1, i32 %mask) #0 {
; CHECK-LABEL: define <32 x half> @test_rcp_ph_512(
; CHECK-SAME: <32 x half> [[A0:%.*]], <32 x half> [[A1:%.*]], i32 [[MASK:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <32 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 128) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <32 x i16> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i32 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <32 x half> @llvm.x86.avx512fp16.mask.rcp.ph.512(<32 x half> [[A0]], <32 x half> [[A1]], i32 [[MASK]])
; CHECK-NEXT:    store <32 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[RES]]
;
  %res = call <32 x half> @llvm.x86.avx512fp16.mask.rcp.ph.512(<32 x half> %a0, <32 x half> %a1, i32 %mask)
  ret <32 x half> %res
}

declare <8 x half> @llvm.x86.avx512fp16.mask.rcp.sh(<8 x half>, <8 x half>, <8 x half>, i8)

define <8 x half> @test_rcp_sh(<8 x half> %a0) #0 {
; CHECK-LABEL: define <8 x half> @test_rcp_sh(
; CHECK-SAME: <8 x half> [[A0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.rcp.sh(<8 x half> [[A0]], <8 x half> [[A0]], <8 x half> zeroinitializer, i8 -1)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.rcp.sh(<8 x half> %a0, <8 x half> %a0, <8 x half> zeroinitializer, i8 -1)
  ret <8 x half> %res
}

define <8 x half> @test_rcp_sh_load(<8 x half> %a0, ptr %a1ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_rcp_sh_load(
; CHECK-SAME: <8 x half> [[A0:%.*]], ptr [[A1PTR:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[A1:%.*]] = load <8 x half>, ptr [[A1PTR]], align 16
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[A1PTR]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = xor i64 [[TMP5]], 87960930222080
; CHECK-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP6]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <8 x i16>, ptr [[TMP7]], align 16
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <8 x i16> [[_MSLD]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP1]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB10:.*]], label %[[BB11:.*]], !prof [[PROF1]]
; CHECK:       [[BB10]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB11]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.rcp.sh(<8 x half> [[A0]], <8 x half> [[A1]], <8 x half> zeroinitializer, i8 -1)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %a1 = load <8 x half>, ptr %a1ptr
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.rcp.sh(<8 x half> %a0, <8 x half> %a1, <8 x half> zeroinitializer, i8 -1)
  ret <8 x half> %res
}

declare <32 x half> @llvm.x86.avx512fp16.mask.reduce.ph.512(<32 x half>, i32, <32 x half>, i32, i32)

define <32 x half>@test_int_x86_avx512_mask_reduce_ph_512(<32 x half> %x0, <32 x half> %x2, i32 %x3) #0 {
; CHECK-LABEL: define <32 x half> @test_int_x86_avx512_mask_reduce_ph_512(
; CHECK-SAME: <32 x half> [[X0:%.*]], <32 x half> [[X2:%.*]], i32 [[X3:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <32 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 128) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <32 x i16> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i32 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <32 x half> @llvm.x86.avx512fp16.mask.reduce.ph.512(<32 x half> [[X0]], i32 8, <32 x half> [[X2]], i32 [[X3]], i32 4)
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i512 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <32 x i16> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP5:%.*]] = icmp ne i512 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR6:%.*]] = or i1 [[_MSCMP4]], [[_MSCMP5]]
; CHECK-NEXT:    br i1 [[_MSOR6]], label %[[BB10:.*]], label %[[BB11:.*]], !prof [[PROF1]]
; CHECK:       [[BB10]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB11]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <32 x half> @llvm.x86.avx512fp16.mask.reduce.ph.512(<32 x half> [[X0]], i32 4, <32 x half> [[X2]], i32 -1, i32 8)
; CHECK-NEXT:    [[RES2:%.*]] = fadd <32 x half> [[RES]], [[RES1]]
; CHECK-NEXT:    store <32 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[RES2]]
;
  %res = call <32 x half> @llvm.x86.avx512fp16.mask.reduce.ph.512(<32 x half> %x0, i32 8, <32 x half> %x2, i32 %x3, i32 4)
  %res1 = call <32 x half> @llvm.x86.avx512fp16.mask.reduce.ph.512(<32 x half> %x0, i32 4, <32 x half> %x2, i32 -1, i32 8)
  %res2 = fadd <32 x half> %res, %res1
  ret <32 x half> %res2
}

declare <8 x half> @llvm.x86.avx512fp16.mask.reduce.sh(<8 x half>, <8 x half>,<8 x half>, i8, i32, i32)

define <8 x half>@test_int_x86_avx512_mask_reduce_sh(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3, i8 %x4) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_reduce_sh(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x half> [[X1:%.*]], <8 x half> [[X3:%.*]], i8 [[X4:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP7]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    [[_MSOR5:%.*]] = or i1 [[_MSOR3]], [[_MSCMP4]]
; CHECK-NEXT:    br i1 [[_MSOR5]], label %[[BB8:.*]], label %[[BB9:.*]], !prof [[PROF1]]
; CHECK:       [[BB8]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB9]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.reduce.sh(<8 x half> [[X0]], <8 x half> [[X1]], <8 x half> [[X3]], i8 [[X4]], i32 4, i32 4)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.reduce.sh(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3, i8 %x4, i32 4, i32 4)
  ret <8 x half> %res
}

define <8 x half>@test_int_x86_avx512_mask_reduce_sh_nomask(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_reduce_sh_nomask(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x half> [[X1:%.*]], <8 x half> [[X3:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.reduce.sh(<8 x half> [[X0]], <8 x half> [[X1]], <8 x half> [[X3]], i8 -1, i32 4, i32 8)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.reduce.sh(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3, i8 -1, i32 4, i32 8)
  ret <8 x half> %res
}

declare <32 x half> @llvm.x86.avx512fp16.mask.rndscale.ph.512(<32 x half>, i32, <32 x half>, i32, i32)

define <32 x half>@test_int_x86_avx512_mask_rndscale_ph_512(<32 x half> %x0, <32 x half> %x2, i32 %x3) #0 {
; CHECK-LABEL: define <32 x half> @test_int_x86_avx512_mask_rndscale_ph_512(
; CHECK-SAME: <32 x half> [[X0:%.*]], <32 x half> [[X2:%.*]], i32 [[X3:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <32 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 128) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <32 x i16> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i32 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <32 x half> @llvm.x86.avx512fp16.mask.rndscale.ph.512(<32 x half> [[X0]], i32 8, <32 x half> [[X2]], i32 [[X3]], i32 4)
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i512 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <32 x i16> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP5:%.*]] = icmp ne i512 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR6:%.*]] = or i1 [[_MSCMP4]], [[_MSCMP5]]
; CHECK-NEXT:    br i1 [[_MSOR6]], label %[[BB10:.*]], label %[[BB11:.*]], !prof [[PROF1]]
; CHECK:       [[BB10]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB11]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <32 x half> @llvm.x86.avx512fp16.mask.rndscale.ph.512(<32 x half> [[X0]], i32 4, <32 x half> [[X2]], i32 -1, i32 8)
; CHECK-NEXT:    [[RES2:%.*]] = fadd <32 x half> [[RES]], [[RES1]]
; CHECK-NEXT:    store <32 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[RES2]]
;
  %res = call <32 x half> @llvm.x86.avx512fp16.mask.rndscale.ph.512(<32 x half> %x0, i32 8, <32 x half> %x2, i32 %x3, i32 4)
  %res1 = call <32 x half> @llvm.x86.avx512fp16.mask.rndscale.ph.512(<32 x half> %x0, i32 4, <32 x half> %x2, i32 -1, i32 8)
  %res2 = fadd <32 x half> %res, %res1
  ret <32 x half> %res2
}

declare <8 x half> @llvm.x86.avx512fp16.mask.rndscale.sh(<8 x half>, <8 x half>,<8 x half>, i8, i32, i32)

define <8 x half>@test_int_x86_avx512_mask_rndscale_sh(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3, i8 %x4) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_rndscale_sh(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x half> [[X1:%.*]], <8 x half> [[X3:%.*]], i8 [[X4:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP7]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    [[_MSOR5:%.*]] = or i1 [[_MSOR3]], [[_MSCMP4]]
; CHECK-NEXT:    br i1 [[_MSOR5]], label %[[BB8:.*]], label %[[BB9:.*]], !prof [[PROF1]]
; CHECK:       [[BB8]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB9]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.rndscale.sh(<8 x half> [[X0]], <8 x half> [[X1]], <8 x half> [[X3]], i8 [[X4]], i32 4, i32 4)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.rndscale.sh(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3, i8 %x4, i32 4, i32 4)
  ret <8 x half> %res
}

define <8 x half>@test_int_x86_avx512_mask_rndscale_sh_nomask(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_rndscale_sh_nomask(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x half> [[X1:%.*]], <8 x half> [[X3:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.rndscale.sh(<8 x half> [[X0]], <8 x half> [[X1]], <8 x half> [[X3]], i8 -1, i32 4, i32 8)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.rndscale.sh(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3, i8 -1, i32 4, i32 8)
  ret <8 x half> %res
}

declare <32 x half> @llvm.x86.avx512fp16.mask.getexp.ph.512(<32 x half>, <32 x half>, i32, i32)

define <32 x half>@test_int_x86_avx512_mask_getexp_ph_512(<32 x half> %x0, <32 x half> %x1, i32 %x2) #0 {
; CHECK-LABEL: define <32 x half> @test_int_x86_avx512_mask_getexp_ph_512(
; CHECK-SAME: <32 x half> [[X0:%.*]], <32 x half> [[X1:%.*]], i32 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <32 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 128) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <32 x i16> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i32 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <32 x half> @llvm.x86.avx512fp16.mask.getexp.ph.512(<32 x half> [[X0]], <32 x half> [[X1]], i32 [[X2]], i32 4)
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i512 [[TMP8]], 0
; CHECK-NEXT:    br i1 [[_MSCMP4]], label %[[BB9:.*]], label %[[BB10:.*]], !prof [[PROF1]]
; CHECK:       [[BB9]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB10]]:
; CHECK-NEXT:    [[RES2:%.*]] = call <32 x half> @llvm.x86.avx512fp16.mask.getexp.ph.512(<32 x half> [[X0]], <32 x half> zeroinitializer, i32 -1, i32 8)
; CHECK-NEXT:    [[RES3:%.*]] = fadd <32 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <32 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[RES3]]
;
  %res1 = call <32 x half> @llvm.x86.avx512fp16.mask.getexp.ph.512(<32 x half> %x0, <32 x half> %x1, i32 %x2, i32 4)
  %res2 = call <32 x half> @llvm.x86.avx512fp16.mask.getexp.ph.512(<32 x half> %x0, <32 x half> zeroinitializer, i32 -1, i32 8)
  %res3 = fadd <32 x half> %res1, %res2
  ret <32 x half> %res3
}

declare <8 x half> @llvm.x86.avx512fp16.mask.getexp.sh(<8 x half>, <8 x half>,<8 x half>, i8, i32)

define <8 x half>@test_int_x86_avx512_mask_getexp_sh(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3, i8 %x4) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_getexp_sh(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x half> [[X1:%.*]], <8 x half> [[X3:%.*]], i8 [[X4:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP7]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    [[_MSOR5:%.*]] = or i1 [[_MSOR3]], [[_MSCMP4]]
; CHECK-NEXT:    br i1 [[_MSOR5]], label %[[BB8:.*]], label %[[BB9:.*]], !prof [[PROF1]]
; CHECK:       [[BB8]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB9]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.getexp.sh(<8 x half> [[X0]], <8 x half> [[X1]], <8 x half> [[X3]], i8 [[X4]], i32 4)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.getexp.sh(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3, i8 %x4, i32 4)
  ret <8 x half> %res
}

define <8 x half>@test_int_x86_avx512_mask_getexp_sh_nomask(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_getexp_sh_nomask(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x half> [[X1:%.*]], <8 x half> [[X3:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.getexp.sh(<8 x half> [[X0]], <8 x half> [[X1]], <8 x half> [[X3]], i8 -1, i32 8)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.getexp.sh(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3, i8 -1, i32 8)
  ret <8 x half> %res
}

define <8 x half>@test_int_x86_avx512_mask_getexp_sh_load(<8 x half> %x0, ptr %x1ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_getexp_sh_load(
; CHECK-SAME: <8 x half> [[X0:%.*]], ptr [[X1PTR:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[X1:%.*]] = load <8 x half>, ptr [[X1PTR]], align 16
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[X1PTR]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = xor i64 [[TMP5]], 87960930222080
; CHECK-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP6]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <8 x i16>, ptr [[TMP7]], align 16
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <8 x i16> [[_MSLD]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP1]], [[_MSCMP2]]
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.getexp.sh(<8 x half> [[X0]], <8 x half> [[X1]], <8 x half> poison, i8 -1, i32 4)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %x1 = load <8 x half>, ptr %x1ptr
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.getexp.sh(<8 x half> %x0, <8 x half> %x1, <8 x half> poison, i8 -1, i32 4)
  ret <8 x half> %res
}

declare <32 x half> @llvm.x86.avx512fp16.mask.getmant.ph.512(<32 x half>, i32, <32 x half>, i32, i32)

define <32 x half>@test_int_x86_avx512_mask_getmant_ph_512(<32 x half> %x0, <32 x half> %x2, i32 %x3) #0 {
; CHECK-LABEL: define <32 x half> @test_int_x86_avx512_mask_getmant_ph_512(
; CHECK-SAME: <32 x half> [[X0:%.*]], <32 x half> [[X2:%.*]], i32 [[X3:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <32 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 128) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <32 x i16> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i32 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <32 x half> @llvm.x86.avx512fp16.mask.getmant.ph.512(<32 x half> [[X0]], i32 8, <32 x half> [[X2]], i32 [[X3]], i32 4)
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <32 x i16> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i512 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <32 x i16> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP5:%.*]] = icmp ne i512 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR6:%.*]] = or i1 [[_MSCMP4]], [[_MSCMP5]]
; CHECK-NEXT:    br i1 [[_MSOR6]], label %[[BB10:.*]], label %[[BB11:.*]], !prof [[PROF1]]
; CHECK:       [[BB10]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB11]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <32 x half> @llvm.x86.avx512fp16.mask.getmant.ph.512(<32 x half> [[X0]], i32 4, <32 x half> [[X2]], i32 -1, i32 8)
; CHECK-NEXT:    [[RES2:%.*]] = fadd <32 x half> [[RES]], [[RES1]]
; CHECK-NEXT:    store <32 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[RES2]]
;
  %res = call <32 x half> @llvm.x86.avx512fp16.mask.getmant.ph.512(<32 x half> %x0, i32 8, <32 x half> %x2, i32 %x3, i32 4)
  %res1 = call <32 x half> @llvm.x86.avx512fp16.mask.getmant.ph.512(<32 x half> %x0, i32 4, <32 x half> %x2, i32 -1, i32 8)
  %res2 = fadd <32 x half> %res, %res1
  ret <32 x half> %res2
}

declare <8 x half> @llvm.x86.avx512fp16.mask.getmant.sh(<8 x half>, <8 x half>, i32, <8 x half>, i8, i32)

define <8 x half>@test_int_x86_avx512_mask_getmant_sh(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3, i8 %x4) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_getmant_sh(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x half> [[X1:%.*]], <8 x half> [[X3:%.*]], i8 [[X4:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP7]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    [[_MSOR5:%.*]] = or i1 [[_MSOR3]], [[_MSCMP4]]
; CHECK-NEXT:    br i1 [[_MSOR5]], label %[[BB8:.*]], label %[[BB9:.*]], !prof [[PROF1]]
; CHECK:       [[BB8]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB9]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.getmant.sh(<8 x half> [[X0]], <8 x half> [[X1]], i32 11, <8 x half> [[X3]], i8 [[X4]], i32 4)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.getmant.sh(<8 x half> %x0, <8 x half> %x1, i32 11, <8 x half> %x3, i8 %x4, i32 4)
  ret <8 x half> %res
}

define <8 x half>@test_int_x86_avx512_mask_getmant_sh_nomask(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_getmant_sh_nomask(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x half> [[X1:%.*]], <8 x half> [[X3:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.getmant.sh(<8 x half> [[X0]], <8 x half> [[X1]], i32 11, <8 x half> [[X3]], i8 -1, i32 4)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.getmant.sh(<8 x half> %x0, <8 x half> %x1, i32 11, <8 x half> %x3, i8 -1, i32 4)
  ret <8 x half> %res
}

define <8 x half>@test_int_x86_avx512_mask_getmant_sh_z(<8 x half> %x0, <8 x half> %x1, i8 %x4) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_getmant_sh_z(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x half> [[X1:%.*]], i8 [[X4:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.getmant.sh(<8 x half> [[X0]], <8 x half> [[X1]], i32 11, <8 x half> zeroinitializer, i8 [[X4]], i32 4)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.getmant.sh(<8 x half> %x0, <8 x half> %x1, i32 11, <8 x half> zeroinitializer, i8 %x4, i32 4)
  ret <8 x half> %res
}

declare <32 x half> @llvm.x86.avx512fp16.mask.scalef.ph.512(<32 x half>, <32 x half>, <32 x half>, i32, i32)

define <32 x half>@test_int_x86_avx512_mask_scalef_ph_512(<32 x half> %x0, <32 x half> %x1, <32 x half> %x2, i32 %x3) #0 {
; CHECK-LABEL: define <32 x half> @test_int_x86_avx512_mask_scalef_ph_512(
; CHECK-SAME: <32 x half> [[X0:%.*]], <32 x half> [[X1:%.*]], <32 x half> [[X2:%.*]], i32 [[X3:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 192) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <32 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <32 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load <32 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 128) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast i32 [[TMP1]] to <32 x i1>
; CHECK-NEXT:    [[MASK:%.*]] = bitcast i32 [[X3]] to <32 x i1>
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <32 x i16> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP6]], 0
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast <32 x i16> [[TMP3]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP7]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <32 x i16> [[TMP4]] to i512
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i512 [[TMP8]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i32 [[TMP1]], 0
; CHECK-NEXT:    [[_MSOR5:%.*]] = or i1 [[_MSOR3]], [[_MSCMP4]]
; CHECK-NEXT:    br i1 [[_MSOR5]], label %[[BB9:.*]], label %[[BB10:.*]], !prof [[PROF1]]
; CHECK:       [[BB9]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB10]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <32 x half> @llvm.x86.avx512fp16.mask.scalef.ph.512(<32 x half> [[X0]], <32 x half> [[X1]], <32 x half> [[X2]], i32 [[X3]], i32 11)
; CHECK-NEXT:    [[TMP11:%.*]] = bitcast <32 x i16> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP6:%.*]] = icmp ne i512 [[TMP11]], 0
; CHECK-NEXT:    [[TMP12:%.*]] = bitcast <32 x i16> [[TMP3]] to i512
; CHECK-NEXT:    [[_MSCMP7:%.*]] = icmp ne i512 [[TMP12]], 0
; CHECK-NEXT:    [[_MSOR8:%.*]] = or i1 [[_MSCMP6]], [[_MSCMP7]]
; CHECK-NEXT:    br i1 [[_MSOR8]], label %[[BB13:.*]], label %[[BB14:.*]], !prof [[PROF1]]
; CHECK:       [[BB13]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB14]]:
; CHECK-NEXT:    [[RES2:%.*]] = call <32 x half> @llvm.x86.avx512fp16.mask.scalef.ph.512(<32 x half> [[X0]], <32 x half> [[X1]], <32 x half> zeroinitializer, i32 -1, i32 8)
; CHECK-NEXT:    [[RES3:%.*]] = fadd <32 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <32 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[RES3]]
;
  %mask = bitcast i32 %x3 to <32 x i1>
  %res1 = call <32 x half> @llvm.x86.avx512fp16.mask.scalef.ph.512(<32 x half> %x0, <32 x half> %x1, <32 x half> %x2, i32 %x3, i32 11)
  %res2 = call <32 x half> @llvm.x86.avx512fp16.mask.scalef.ph.512(<32 x half> %x0, <32 x half> %x1, <32 x half> zeroinitializer, i32 -1, i32 8)
  %res3 = fadd <32 x half> %res1, %res2
  ret <32 x half> %res3
}

declare <8 x half> @llvm.x86.avx512fp16.mask.scalef.sh(<8 x half>, <8 x half>,<8 x half>, i8, i32)

define <8 x half>@test_int_x86_avx512_mask_scalef_sh(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3, i8 %x4) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_scalef_sh(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x half> [[X1:%.*]], <8 x half> [[X3:%.*]], i8 [[X4:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP4:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP7:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP7]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i8 [[TMP4]], 0
; CHECK-NEXT:    [[_MSOR5:%.*]] = or i1 [[_MSOR3]], [[_MSCMP4]]
; CHECK-NEXT:    br i1 [[_MSOR5]], label %[[BB8:.*]], label %[[BB9:.*]], !prof [[PROF1]]
; CHECK:       [[BB8]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB9]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.scalef.sh(<8 x half> [[X0]], <8 x half> [[X1]], <8 x half> [[X3]], i8 [[X4]], i32 4)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.scalef.sh(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3, i8 %x4, i32 4)
  ret <8 x half> %res
}

define <8 x half>@test_int_x86_avx512_mask_scalef_sh_nomask(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_scalef_sh_nomask(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x half> [[X1:%.*]], <8 x half> [[X3:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP3]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.scalef.sh(<8 x half> [[X0]], <8 x half> [[X1]], <8 x half> [[X3]], i8 -1, i32 8)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.scalef.sh(<8 x half> %x0, <8 x half> %x1, <8 x half> %x3, i8 -1, i32 8)
  ret <8 x half> %res
}

define <8 x half>@test_int_x86_avx512_mask_scalef_sh_load(<8 x half> %x0, ptr %x1ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_scalef_sh_load(
; CHECK-SAME: <8 x half> [[X0:%.*]], ptr [[X1PTR:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[X1:%.*]] = load <8 x half>, ptr [[X1PTR]], align 16
; CHECK-NEXT:    [[TMP5:%.*]] = ptrtoint ptr [[X1PTR]] to i64
; CHECK-NEXT:    [[TMP6:%.*]] = xor i64 [[TMP5]], 87960930222080
; CHECK-NEXT:    [[TMP7:%.*]] = inttoptr i64 [[TMP6]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load <8 x i16>, ptr [[TMP7]], align 16
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <8 x i16> [[_MSLD]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP1]], [[_MSCMP2]]
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.scalef.sh(<8 x half> [[X0]], <8 x half> [[X1]], <8 x half> poison, i8 -1, i32 4)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %x1 = load <8 x half>, ptr %x1ptr
  %res = call <8 x half> @llvm.x86.avx512fp16.mask.scalef.sh(<8 x half> %x0, <8 x half> %x1, <8 x half> poison, i8 -1, i32 4)
  ret <8 x half> %res
}

declare <8 x half> @llvm.x86.avx512fp16.mask.add.sh.round(<8 x half>, <8 x half>, <8 x half>, i8, i32)

define <8 x half> @test_int_x86_avx512fp16_mask_add_sh(<8 x half> %x1, <8 x half> %x2, <8 x half> %src, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_mask_add_sh(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], <8 x half> [[SRC:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 56) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    [[TMP6:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[VAL_HALF:%.*]] = load half, ptr [[PTR]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP9:%.*]] = xor i64 [[TMP8]], 87960930222080
; CHECK-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP9]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i16, ptr [[TMP10]], align 2
; CHECK-NEXT:    [[_MSPROP:%.*]] = insertelement <8 x i16> splat (i16 -1), i16 [[_MSLD]], i32 0
; CHECK-NEXT:    [[VAL:%.*]] = insertelement <8 x half> poison, half [[VAL_HALF]], i32 0
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <8 x i16> [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP13:%.*]] = or i16 [[TMP11]], [[TMP12]]
; CHECK-NEXT:    [[TMP14:%.*]] = select i1 true, i16 [[TMP13]], i16 0
; CHECK-NEXT:    [[_MSPROP1:%.*]] = insertelement <8 x i16> [[TMP2]], i16 [[TMP14]], i32 0
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.add.sh.round(<8 x half> [[X1]], <8 x half> [[X2]], <8 x half> zeroinitializer, i8 -1, i32 4)
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <8 x i16> [[_MSPROP1]], i32 0
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP18:%.*]] = or i16 [[TMP16]], [[TMP17]]
; CHECK-NEXT:    [[TMP19:%.*]] = extractelement <8 x i16> [[TMP6]], i32 0
; CHECK-NEXT:    [[TMP22:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <8 x i1> [[TMP22]], i32 0
; CHECK-NEXT:    [[TMP21:%.*]] = select i1 [[TMP20]], i16 [[TMP18]], i16 [[TMP19]]
; CHECK-NEXT:    [[_MSPROP2:%.*]] = insertelement <8 x i16> [[_MSPROP1]], i16 [[TMP21]], i32 0
; CHECK-NEXT:    [[_MSCMP6:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP6]], label %[[BB22:.*]], label %[[BB23:.*]], !prof [[PROF1]]
; CHECK:       [[BB22]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB23]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.add.sh.round(<8 x half> [[RES0]], <8 x half> [[X2]], <8 x half> [[SRC]], i8 [[MASK]], i32 4)
; CHECK-NEXT:    [[TMP25:%.*]] = extractelement <8 x i16> [[_MSPROP2]], i32 0
; CHECK-NEXT:    [[TMP26:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP27:%.*]] = or i16 [[TMP25]], [[TMP26]]
; CHECK-NEXT:    [[TMP30:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP28:%.*]] = extractelement <8 x i1> [[TMP30]], i32 0
; CHECK-NEXT:    [[TMP29:%.*]] = select i1 [[TMP28]], i16 [[TMP27]], i16 0
; CHECK-NEXT:    [[_MSPROP3:%.*]] = insertelement <8 x i16> [[_MSPROP2]], i16 [[TMP29]], i32 0
; CHECK-NEXT:    [[_MSCMP9:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP9]], label %[[BB30:.*]], label %[[BB31:.*]], !prof [[PROF1]]
; CHECK:       [[BB30]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB31]]:
; CHECK-NEXT:    [[RES2:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.add.sh.round(<8 x half> [[RES1]], <8 x half> [[X2]], <8 x half> zeroinitializer, i8 [[MASK]], i32 4)
; CHECK-NEXT:    [[TMP33:%.*]] = extractelement <8 x i16> [[_MSPROP3]], i32 0
; CHECK-NEXT:    [[TMP34:%.*]] = extractelement <8 x i16> [[_MSPROP]], i32 0
; CHECK-NEXT:    [[TMP35:%.*]] = or i16 [[TMP33]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <8 x i16> [[TMP6]], i32 0
; CHECK-NEXT:    [[TMP39:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP37:%.*]] = extractelement <8 x i1> [[TMP39]], i32 0
; CHECK-NEXT:    [[TMP38:%.*]] = select i1 [[TMP37]], i16 [[TMP35]], i16 [[TMP36]]
; CHECK-NEXT:    [[_MSPROP4:%.*]] = insertelement <8 x i16> [[_MSPROP3]], i16 [[TMP38]], i32 0
; CHECK-NEXT:    [[_MSCMP14:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP14]], label %[[BB39:.*]], label %[[BB40:.*]], !prof [[PROF1]]
; CHECK:       [[BB39]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB40]]:
; CHECK-NEXT:    [[RES3:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.add.sh.round(<8 x half> [[RES2]], <8 x half> [[VAL]], <8 x half> [[SRC]], i8 [[MASK]], i32 4)
; CHECK-NEXT:    store <8 x i16> [[_MSPROP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES3]]
;
  %val.half = load half,ptr %ptr
  %val = insertelement <8 x half> poison, half %val.half, i32 0
  %res0 = call <8 x half> @llvm.x86.avx512fp16.mask.add.sh.round(<8 x half> %x1, <8 x half> %x2, <8 x half> zeroinitializer, i8 -1, i32 4)
  %res1 = call <8 x half> @llvm.x86.avx512fp16.mask.add.sh.round(<8 x half> %res0, <8 x half> %x2, <8 x half> %src , i8 %mask, i32 4)
  %res2 = call <8 x half> @llvm.x86.avx512fp16.mask.add.sh.round(<8 x half> %res1, <8 x half> %x2, <8 x half> zeroinitializer , i8 %mask, i32 4)
  %res3 = call <8 x half> @llvm.x86.avx512fp16.mask.add.sh.round(<8 x half> %res2, <8 x half> %val, <8 x half> %src , i8 %mask, i32 4)
  ret <8 x half> %res3
}

declare <8 x half> @llvm.x86.avx512fp16.mask.sub.sh.round(<8 x half>, <8 x half>, <8 x half>, i8, i32)

define <8 x half> @test_int_x86_avx512fp16_mask_sub_sh(<8 x half> %x1, <8 x half> %x2, <8 x half> %src, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_mask_sub_sh(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], <8 x half> [[SRC:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 56) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    [[TMP6:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[VAL_HALF:%.*]] = load half, ptr [[PTR]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP9:%.*]] = xor i64 [[TMP8]], 87960930222080
; CHECK-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP9]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i16, ptr [[TMP10]], align 2
; CHECK-NEXT:    [[_MSPROP:%.*]] = insertelement <8 x i16> splat (i16 -1), i16 [[_MSLD]], i32 0
; CHECK-NEXT:    [[VAL:%.*]] = insertelement <8 x half> poison, half [[VAL_HALF]], i32 0
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <8 x i16> [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP13:%.*]] = or i16 [[TMP11]], [[TMP12]]
; CHECK-NEXT:    [[TMP14:%.*]] = select i1 true, i16 [[TMP13]], i16 0
; CHECK-NEXT:    [[_MSPROP1:%.*]] = insertelement <8 x i16> [[TMP2]], i16 [[TMP14]], i32 0
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.sub.sh.round(<8 x half> [[X1]], <8 x half> [[X2]], <8 x half> zeroinitializer, i8 -1, i32 4)
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <8 x i16> [[_MSPROP1]], i32 0
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP18:%.*]] = or i16 [[TMP16]], [[TMP17]]
; CHECK-NEXT:    [[TMP19:%.*]] = extractelement <8 x i16> [[TMP6]], i32 0
; CHECK-NEXT:    [[TMP22:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <8 x i1> [[TMP22]], i32 0
; CHECK-NEXT:    [[TMP21:%.*]] = select i1 [[TMP20]], i16 [[TMP18]], i16 [[TMP19]]
; CHECK-NEXT:    [[_MSPROP2:%.*]] = insertelement <8 x i16> [[_MSPROP1]], i16 [[TMP21]], i32 0
; CHECK-NEXT:    [[_MSCMP6:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP6]], label %[[BB22:.*]], label %[[BB23:.*]], !prof [[PROF1]]
; CHECK:       [[BB22]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB23]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.sub.sh.round(<8 x half> [[RES0]], <8 x half> [[X2]], <8 x half> [[SRC]], i8 [[MASK]], i32 4)
; CHECK-NEXT:    [[TMP25:%.*]] = extractelement <8 x i16> [[_MSPROP2]], i32 0
; CHECK-NEXT:    [[TMP26:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP27:%.*]] = or i16 [[TMP25]], [[TMP26]]
; CHECK-NEXT:    [[TMP30:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP28:%.*]] = extractelement <8 x i1> [[TMP30]], i32 0
; CHECK-NEXT:    [[TMP29:%.*]] = select i1 [[TMP28]], i16 [[TMP27]], i16 0
; CHECK-NEXT:    [[_MSPROP3:%.*]] = insertelement <8 x i16> [[_MSPROP2]], i16 [[TMP29]], i32 0
; CHECK-NEXT:    [[_MSCMP9:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP9]], label %[[BB30:.*]], label %[[BB31:.*]], !prof [[PROF1]]
; CHECK:       [[BB30]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB31]]:
; CHECK-NEXT:    [[RES2:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.sub.sh.round(<8 x half> [[RES1]], <8 x half> [[X2]], <8 x half> zeroinitializer, i8 [[MASK]], i32 4)
; CHECK-NEXT:    [[TMP33:%.*]] = extractelement <8 x i16> [[_MSPROP3]], i32 0
; CHECK-NEXT:    [[TMP34:%.*]] = extractelement <8 x i16> [[_MSPROP]], i32 0
; CHECK-NEXT:    [[TMP35:%.*]] = or i16 [[TMP33]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <8 x i16> [[TMP6]], i32 0
; CHECK-NEXT:    [[TMP39:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP37:%.*]] = extractelement <8 x i1> [[TMP39]], i32 0
; CHECK-NEXT:    [[TMP38:%.*]] = select i1 [[TMP37]], i16 [[TMP35]], i16 [[TMP36]]
; CHECK-NEXT:    [[_MSPROP4:%.*]] = insertelement <8 x i16> [[_MSPROP3]], i16 [[TMP38]], i32 0
; CHECK-NEXT:    [[_MSCMP14:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP14]], label %[[BB39:.*]], label %[[BB40:.*]], !prof [[PROF1]]
; CHECK:       [[BB39]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB40]]:
; CHECK-NEXT:    [[RES3:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.sub.sh.round(<8 x half> [[RES2]], <8 x half> [[VAL]], <8 x half> [[SRC]], i8 [[MASK]], i32 4)
; CHECK-NEXT:    store <8 x i16> [[_MSPROP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES3]]
;
  %val.half = load half,ptr %ptr
  %val = insertelement <8 x half> poison, half %val.half, i32 0
  %res0 = call <8 x half> @llvm.x86.avx512fp16.mask.sub.sh.round(<8 x half> %x1, <8 x half> %x2, <8 x half> zeroinitializer, i8 -1, i32 4)
  %res1 = call <8 x half> @llvm.x86.avx512fp16.mask.sub.sh.round(<8 x half> %res0, <8 x half> %x2, <8 x half> %src , i8 %mask, i32 4)
  %res2 = call <8 x half> @llvm.x86.avx512fp16.mask.sub.sh.round(<8 x half> %res1, <8 x half> %x2, <8 x half> zeroinitializer , i8 %mask, i32 4)
  %res3 = call <8 x half> @llvm.x86.avx512fp16.mask.sub.sh.round(<8 x half> %res2, <8 x half> %val, <8 x half> %src , i8 %mask, i32 4)
  ret <8 x half> %res3
}

declare <8 x half> @llvm.x86.avx512fp16.mask.mul.sh.round(<8 x half>, <8 x half>, <8 x half>, i8, i32)

define <8 x half> @test_int_x86_avx512fp16_mask_mul_sh(<8 x half> %x1, <8 x half> %x2, <8 x half> %src, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_mask_mul_sh(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], <8 x half> [[SRC:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 56) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    [[TMP6:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[VAL_HALF:%.*]] = load half, ptr [[PTR]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP9:%.*]] = xor i64 [[TMP8]], 87960930222080
; CHECK-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP9]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i16, ptr [[TMP10]], align 2
; CHECK-NEXT:    [[_MSPROP:%.*]] = insertelement <8 x i16> splat (i16 -1), i16 [[_MSLD]], i32 0
; CHECK-NEXT:    [[VAL:%.*]] = insertelement <8 x half> poison, half [[VAL_HALF]], i32 0
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <8 x i16> [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP13:%.*]] = or i16 [[TMP11]], [[TMP12]]
; CHECK-NEXT:    [[TMP14:%.*]] = select i1 true, i16 [[TMP13]], i16 0
; CHECK-NEXT:    [[_MSPROP1:%.*]] = insertelement <8 x i16> [[TMP2]], i16 [[TMP14]], i32 0
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.mul.sh.round(<8 x half> [[X1]], <8 x half> [[X2]], <8 x half> zeroinitializer, i8 -1, i32 4)
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <8 x i16> [[_MSPROP1]], i32 0
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP18:%.*]] = or i16 [[TMP16]], [[TMP17]]
; CHECK-NEXT:    [[TMP19:%.*]] = extractelement <8 x i16> [[TMP6]], i32 0
; CHECK-NEXT:    [[TMP22:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <8 x i1> [[TMP22]], i32 0
; CHECK-NEXT:    [[TMP21:%.*]] = select i1 [[TMP20]], i16 [[TMP18]], i16 [[TMP19]]
; CHECK-NEXT:    [[_MSPROP2:%.*]] = insertelement <8 x i16> [[_MSPROP1]], i16 [[TMP21]], i32 0
; CHECK-NEXT:    [[_MSCMP6:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP6]], label %[[BB22:.*]], label %[[BB23:.*]], !prof [[PROF1]]
; CHECK:       [[BB22]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB23]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.mul.sh.round(<8 x half> [[RES0]], <8 x half> [[X2]], <8 x half> [[SRC]], i8 [[MASK]], i32 4)
; CHECK-NEXT:    [[TMP25:%.*]] = extractelement <8 x i16> [[_MSPROP2]], i32 0
; CHECK-NEXT:    [[TMP26:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP27:%.*]] = or i16 [[TMP25]], [[TMP26]]
; CHECK-NEXT:    [[TMP30:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP28:%.*]] = extractelement <8 x i1> [[TMP30]], i32 0
; CHECK-NEXT:    [[TMP29:%.*]] = select i1 [[TMP28]], i16 [[TMP27]], i16 0
; CHECK-NEXT:    [[_MSPROP3:%.*]] = insertelement <8 x i16> [[_MSPROP2]], i16 [[TMP29]], i32 0
; CHECK-NEXT:    [[_MSCMP9:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP9]], label %[[BB30:.*]], label %[[BB31:.*]], !prof [[PROF1]]
; CHECK:       [[BB30]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB31]]:
; CHECK-NEXT:    [[RES2:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.mul.sh.round(<8 x half> [[RES1]], <8 x half> [[X2]], <8 x half> zeroinitializer, i8 [[MASK]], i32 4)
; CHECK-NEXT:    [[TMP33:%.*]] = extractelement <8 x i16> [[_MSPROP3]], i32 0
; CHECK-NEXT:    [[TMP34:%.*]] = extractelement <8 x i16> [[_MSPROP]], i32 0
; CHECK-NEXT:    [[TMP35:%.*]] = or i16 [[TMP33]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <8 x i16> [[TMP6]], i32 0
; CHECK-NEXT:    [[TMP39:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP37:%.*]] = extractelement <8 x i1> [[TMP39]], i32 0
; CHECK-NEXT:    [[TMP38:%.*]] = select i1 [[TMP37]], i16 [[TMP35]], i16 [[TMP36]]
; CHECK-NEXT:    [[_MSPROP4:%.*]] = insertelement <8 x i16> [[_MSPROP3]], i16 [[TMP38]], i32 0
; CHECK-NEXT:    [[_MSCMP14:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP14]], label %[[BB39:.*]], label %[[BB40:.*]], !prof [[PROF1]]
; CHECK:       [[BB39]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB40]]:
; CHECK-NEXT:    [[RES3:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.mul.sh.round(<8 x half> [[RES2]], <8 x half> [[VAL]], <8 x half> [[SRC]], i8 [[MASK]], i32 4)
; CHECK-NEXT:    store <8 x i16> [[_MSPROP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES3]]
;
  %val.half = load half,ptr %ptr
  %val = insertelement <8 x half> poison, half %val.half, i32 0
  %res0 = call <8 x half> @llvm.x86.avx512fp16.mask.mul.sh.round(<8 x half> %x1, <8 x half> %x2, <8 x half> zeroinitializer, i8 -1, i32 4)
  %res1 = call <8 x half> @llvm.x86.avx512fp16.mask.mul.sh.round(<8 x half> %res0, <8 x half> %x2, <8 x half> %src , i8 %mask, i32 4)
  %res2 = call <8 x half> @llvm.x86.avx512fp16.mask.mul.sh.round(<8 x half> %res1, <8 x half> %x2, <8 x half> zeroinitializer , i8 %mask, i32 4)
  %res3 = call <8 x half> @llvm.x86.avx512fp16.mask.mul.sh.round(<8 x half> %res2, <8 x half> %val, <8 x half> %src , i8 %mask, i32 4)
  ret <8 x half> %res3
}

declare <8 x half> @llvm.x86.avx512fp16.mask.div.sh.round(<8 x half>, <8 x half>, <8 x half>, i8, i32)

define <8 x half> @test_int_x86_avx512fp16_mask_div_sh(<8 x half> %x1, <8 x half> %x2, <8 x half> %src, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_mask_div_sh(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], <8 x half> [[SRC:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 56) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    [[TMP6:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[VAL_HALF:%.*]] = load half, ptr [[PTR]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP9:%.*]] = xor i64 [[TMP8]], 87960930222080
; CHECK-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP9]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i16, ptr [[TMP10]], align 2
; CHECK-NEXT:    [[_MSPROP:%.*]] = insertelement <8 x i16> splat (i16 -1), i16 [[_MSLD]], i32 0
; CHECK-NEXT:    [[VAL:%.*]] = insertelement <8 x half> poison, half [[VAL_HALF]], i32 0
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <8 x i16> [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP13:%.*]] = or i16 [[TMP11]], [[TMP12]]
; CHECK-NEXT:    [[TMP14:%.*]] = select i1 true, i16 [[TMP13]], i16 0
; CHECK-NEXT:    [[_MSPROP1:%.*]] = insertelement <8 x i16> [[TMP2]], i16 [[TMP14]], i32 0
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.div.sh.round(<8 x half> [[X1]], <8 x half> [[X2]], <8 x half> zeroinitializer, i8 -1, i32 4)
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <8 x i16> [[_MSPROP1]], i32 0
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP18:%.*]] = or i16 [[TMP16]], [[TMP17]]
; CHECK-NEXT:    [[TMP19:%.*]] = extractelement <8 x i16> [[TMP6]], i32 0
; CHECK-NEXT:    [[TMP22:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <8 x i1> [[TMP22]], i32 0
; CHECK-NEXT:    [[TMP21:%.*]] = select i1 [[TMP20]], i16 [[TMP18]], i16 [[TMP19]]
; CHECK-NEXT:    [[_MSPROP2:%.*]] = insertelement <8 x i16> [[_MSPROP1]], i16 [[TMP21]], i32 0
; CHECK-NEXT:    [[_MSCMP6:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP6]], label %[[BB22:.*]], label %[[BB23:.*]], !prof [[PROF1]]
; CHECK:       [[BB22]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB23]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.div.sh.round(<8 x half> [[RES0]], <8 x half> [[X2]], <8 x half> [[SRC]], i8 [[MASK]], i32 4)
; CHECK-NEXT:    [[TMP25:%.*]] = extractelement <8 x i16> [[_MSPROP2]], i32 0
; CHECK-NEXT:    [[TMP26:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP27:%.*]] = or i16 [[TMP25]], [[TMP26]]
; CHECK-NEXT:    [[TMP30:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP28:%.*]] = extractelement <8 x i1> [[TMP30]], i32 0
; CHECK-NEXT:    [[TMP29:%.*]] = select i1 [[TMP28]], i16 [[TMP27]], i16 0
; CHECK-NEXT:    [[_MSPROP3:%.*]] = insertelement <8 x i16> [[_MSPROP2]], i16 [[TMP29]], i32 0
; CHECK-NEXT:    [[_MSCMP9:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP9]], label %[[BB30:.*]], label %[[BB31:.*]], !prof [[PROF1]]
; CHECK:       [[BB30]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB31]]:
; CHECK-NEXT:    [[RES2:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.div.sh.round(<8 x half> [[RES1]], <8 x half> [[X2]], <8 x half> zeroinitializer, i8 [[MASK]], i32 4)
; CHECK-NEXT:    [[TMP33:%.*]] = extractelement <8 x i16> [[_MSPROP3]], i32 0
; CHECK-NEXT:    [[TMP34:%.*]] = extractelement <8 x i16> [[_MSPROP]], i32 0
; CHECK-NEXT:    [[TMP35:%.*]] = or i16 [[TMP33]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <8 x i16> [[TMP6]], i32 0
; CHECK-NEXT:    [[TMP39:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP37:%.*]] = extractelement <8 x i1> [[TMP39]], i32 0
; CHECK-NEXT:    [[TMP38:%.*]] = select i1 [[TMP37]], i16 [[TMP35]], i16 [[TMP36]]
; CHECK-NEXT:    [[_MSPROP4:%.*]] = insertelement <8 x i16> [[_MSPROP3]], i16 [[TMP38]], i32 0
; CHECK-NEXT:    [[_MSCMP14:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP14]], label %[[BB39:.*]], label %[[BB40:.*]], !prof [[PROF1]]
; CHECK:       [[BB39]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB40]]:
; CHECK-NEXT:    [[RES3:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.div.sh.round(<8 x half> [[RES2]], <8 x half> [[VAL]], <8 x half> [[SRC]], i8 [[MASK]], i32 4)
; CHECK-NEXT:    store <8 x i16> [[_MSPROP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES3]]
;
  %val.half = load half,ptr %ptr
  %val = insertelement <8 x half> poison, half %val.half, i32 0
  %res0 = call <8 x half> @llvm.x86.avx512fp16.mask.div.sh.round(<8 x half> %x1, <8 x half> %x2, <8 x half> zeroinitializer, i8 -1, i32 4)
  %res1 = call <8 x half> @llvm.x86.avx512fp16.mask.div.sh.round(<8 x half> %res0, <8 x half> %x2, <8 x half> %src , i8 %mask, i32 4)
  %res2 = call <8 x half> @llvm.x86.avx512fp16.mask.div.sh.round(<8 x half> %res1, <8 x half> %x2, <8 x half> zeroinitializer , i8 %mask, i32 4)
  %res3 = call <8 x half> @llvm.x86.avx512fp16.mask.div.sh.round(<8 x half> %res2, <8 x half> %val, <8 x half> %src , i8 %mask, i32 4)
  ret <8 x half> %res3
}

declare <8 x half> @llvm.x86.avx512fp16.mask.min.sh.round(<8 x half>, <8 x half>, <8 x half>, i8, i32)

define <8 x half> @test_int_x86_avx512fp16_mask_min_sh(<8 x half> %x1, <8 x half> %x2, <8 x half> %src, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_mask_min_sh(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], <8 x half> [[SRC:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 56) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    [[TMP6:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[VAL_HALF:%.*]] = load half, ptr [[PTR]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP9:%.*]] = xor i64 [[TMP8]], 87960930222080
; CHECK-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP9]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i16, ptr [[TMP10]], align 2
; CHECK-NEXT:    [[_MSPROP:%.*]] = insertelement <8 x i16> splat (i16 -1), i16 [[_MSLD]], i32 0
; CHECK-NEXT:    [[VAL:%.*]] = insertelement <8 x half> poison, half [[VAL_HALF]], i32 0
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <8 x i16> [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP13:%.*]] = or i16 [[TMP11]], [[TMP12]]
; CHECK-NEXT:    [[TMP14:%.*]] = select i1 true, i16 [[TMP13]], i16 0
; CHECK-NEXT:    [[_MSPROP1:%.*]] = insertelement <8 x i16> [[TMP2]], i16 [[TMP14]], i32 0
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.min.sh.round(<8 x half> [[X1]], <8 x half> [[X2]], <8 x half> zeroinitializer, i8 -1, i32 4)
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <8 x i16> [[_MSPROP1]], i32 0
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP18:%.*]] = or i16 [[TMP16]], [[TMP17]]
; CHECK-NEXT:    [[TMP19:%.*]] = extractelement <8 x i16> [[TMP6]], i32 0
; CHECK-NEXT:    [[TMP22:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <8 x i1> [[TMP22]], i32 0
; CHECK-NEXT:    [[TMP21:%.*]] = select i1 [[TMP20]], i16 [[TMP18]], i16 [[TMP19]]
; CHECK-NEXT:    [[_MSPROP2:%.*]] = insertelement <8 x i16> [[_MSPROP1]], i16 [[TMP21]], i32 0
; CHECK-NEXT:    [[_MSCMP6:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP6]], label %[[BB22:.*]], label %[[BB23:.*]], !prof [[PROF1]]
; CHECK:       [[BB22]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB23]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.min.sh.round(<8 x half> [[RES0]], <8 x half> [[X2]], <8 x half> [[SRC]], i8 [[MASK]], i32 4)
; CHECK-NEXT:    [[TMP25:%.*]] = extractelement <8 x i16> [[_MSPROP2]], i32 0
; CHECK-NEXT:    [[TMP26:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP27:%.*]] = or i16 [[TMP25]], [[TMP26]]
; CHECK-NEXT:    [[TMP30:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP28:%.*]] = extractelement <8 x i1> [[TMP30]], i32 0
; CHECK-NEXT:    [[TMP29:%.*]] = select i1 [[TMP28]], i16 [[TMP27]], i16 0
; CHECK-NEXT:    [[_MSPROP3:%.*]] = insertelement <8 x i16> [[_MSPROP2]], i16 [[TMP29]], i32 0
; CHECK-NEXT:    [[_MSCMP9:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP9]], label %[[BB30:.*]], label %[[BB31:.*]], !prof [[PROF1]]
; CHECK:       [[BB30]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB31]]:
; CHECK-NEXT:    [[RES2:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.min.sh.round(<8 x half> [[RES1]], <8 x half> [[X2]], <8 x half> zeroinitializer, i8 [[MASK]], i32 4)
; CHECK-NEXT:    [[TMP33:%.*]] = extractelement <8 x i16> [[_MSPROP3]], i32 0
; CHECK-NEXT:    [[TMP34:%.*]] = extractelement <8 x i16> [[_MSPROP]], i32 0
; CHECK-NEXT:    [[TMP35:%.*]] = or i16 [[TMP33]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <8 x i16> [[TMP6]], i32 0
; CHECK-NEXT:    [[TMP39:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP37:%.*]] = extractelement <8 x i1> [[TMP39]], i32 0
; CHECK-NEXT:    [[TMP38:%.*]] = select i1 [[TMP37]], i16 [[TMP35]], i16 [[TMP36]]
; CHECK-NEXT:    [[_MSPROP4:%.*]] = insertelement <8 x i16> [[_MSPROP3]], i16 [[TMP38]], i32 0
; CHECK-NEXT:    [[_MSCMP14:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP14]], label %[[BB39:.*]], label %[[BB40:.*]], !prof [[PROF1]]
; CHECK:       [[BB39]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB40]]:
; CHECK-NEXT:    [[RES3:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.min.sh.round(<8 x half> [[RES2]], <8 x half> [[VAL]], <8 x half> [[SRC]], i8 [[MASK]], i32 4)
; CHECK-NEXT:    store <8 x i16> [[_MSPROP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES3]]
;
  %val.half = load half,ptr %ptr
  %val = insertelement <8 x half> poison, half %val.half, i32 0
  %res0 = call <8 x half> @llvm.x86.avx512fp16.mask.min.sh.round(<8 x half> %x1, <8 x half> %x2, <8 x half> zeroinitializer, i8 -1, i32 4)
  %res1 = call <8 x half> @llvm.x86.avx512fp16.mask.min.sh.round(<8 x half> %res0, <8 x half> %x2, <8 x half> %src , i8 %mask, i32 4)
  %res2 = call <8 x half> @llvm.x86.avx512fp16.mask.min.sh.round(<8 x half> %res1, <8 x half> %x2, <8 x half> zeroinitializer , i8 %mask, i32 4)
  %res3 = call <8 x half> @llvm.x86.avx512fp16.mask.min.sh.round(<8 x half> %res2, <8 x half> %val, <8 x half> %src , i8 %mask, i32 4)
  ret <8 x half> %res3
}

declare <8 x half> @llvm.x86.avx512fp16.mask.max.sh.round(<8 x half>, <8 x half>, <8 x half>, i8, i32)

define <8 x half> @test_int_x86_avx512fp16_mask_max_sh(<8 x half> %x1, <8 x half> %x2, <8 x half> %src, i8 %mask, ptr %ptr) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512fp16_mask_max_sh(
; CHECK-SAME: <8 x half> [[X1:%.*]], <8 x half> [[X2:%.*]], <8 x half> [[SRC:%.*]], i8 [[MASK:%.*]], ptr [[PTR:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 56) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP5:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 48) to ptr), align 8
; CHECK-NEXT:    [[TMP6:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i64 [[TMP1]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[VAL_HALF:%.*]] = load half, ptr [[PTR]], align 2
; CHECK-NEXT:    [[TMP8:%.*]] = ptrtoint ptr [[PTR]] to i64
; CHECK-NEXT:    [[TMP9:%.*]] = xor i64 [[TMP8]], 87960930222080
; CHECK-NEXT:    [[TMP10:%.*]] = inttoptr i64 [[TMP9]] to ptr
; CHECK-NEXT:    [[_MSLD:%.*]] = load i16, ptr [[TMP10]], align 2
; CHECK-NEXT:    [[_MSPROP:%.*]] = insertelement <8 x i16> splat (i16 -1), i16 [[_MSLD]], i32 0
; CHECK-NEXT:    [[VAL:%.*]] = insertelement <8 x half> poison, half [[VAL_HALF]], i32 0
; CHECK-NEXT:    [[TMP11:%.*]] = extractelement <8 x i16> [[TMP2]], i32 0
; CHECK-NEXT:    [[TMP12:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP13:%.*]] = or i16 [[TMP11]], [[TMP12]]
; CHECK-NEXT:    [[TMP14:%.*]] = select i1 true, i16 [[TMP13]], i16 0
; CHECK-NEXT:    [[_MSPROP1:%.*]] = insertelement <8 x i16> [[TMP2]], i16 [[TMP14]], i32 0
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.max.sh.round(<8 x half> [[X1]], <8 x half> [[X2]], <8 x half> zeroinitializer, i8 -1, i32 4)
; CHECK-NEXT:    [[TMP16:%.*]] = extractelement <8 x i16> [[_MSPROP1]], i32 0
; CHECK-NEXT:    [[TMP17:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP18:%.*]] = or i16 [[TMP16]], [[TMP17]]
; CHECK-NEXT:    [[TMP19:%.*]] = extractelement <8 x i16> [[TMP6]], i32 0
; CHECK-NEXT:    [[TMP22:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP20:%.*]] = extractelement <8 x i1> [[TMP22]], i32 0
; CHECK-NEXT:    [[TMP21:%.*]] = select i1 [[TMP20]], i16 [[TMP18]], i16 [[TMP19]]
; CHECK-NEXT:    [[_MSPROP2:%.*]] = insertelement <8 x i16> [[_MSPROP1]], i16 [[TMP21]], i32 0
; CHECK-NEXT:    [[_MSCMP6:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP6]], label %[[BB22:.*]], label %[[BB23:.*]], !prof [[PROF1]]
; CHECK:       [[BB22]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB23]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.max.sh.round(<8 x half> [[RES0]], <8 x half> [[X2]], <8 x half> [[SRC]], i8 [[MASK]], i32 4)
; CHECK-NEXT:    [[TMP25:%.*]] = extractelement <8 x i16> [[_MSPROP2]], i32 0
; CHECK-NEXT:    [[TMP26:%.*]] = extractelement <8 x i16> [[TMP3]], i32 0
; CHECK-NEXT:    [[TMP27:%.*]] = or i16 [[TMP25]], [[TMP26]]
; CHECK-NEXT:    [[TMP30:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP28:%.*]] = extractelement <8 x i1> [[TMP30]], i32 0
; CHECK-NEXT:    [[TMP29:%.*]] = select i1 [[TMP28]], i16 [[TMP27]], i16 0
; CHECK-NEXT:    [[_MSPROP3:%.*]] = insertelement <8 x i16> [[_MSPROP2]], i16 [[TMP29]], i32 0
; CHECK-NEXT:    [[_MSCMP9:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP9]], label %[[BB30:.*]], label %[[BB31:.*]], !prof [[PROF1]]
; CHECK:       [[BB30]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB31]]:
; CHECK-NEXT:    [[RES2:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.max.sh.round(<8 x half> [[RES1]], <8 x half> [[X2]], <8 x half> zeroinitializer, i8 [[MASK]], i32 4)
; CHECK-NEXT:    [[TMP33:%.*]] = extractelement <8 x i16> [[_MSPROP3]], i32 0
; CHECK-NEXT:    [[TMP34:%.*]] = extractelement <8 x i16> [[_MSPROP]], i32 0
; CHECK-NEXT:    [[TMP35:%.*]] = or i16 [[TMP33]], [[TMP34]]
; CHECK-NEXT:    [[TMP36:%.*]] = extractelement <8 x i16> [[TMP6]], i32 0
; CHECK-NEXT:    [[TMP39:%.*]] = bitcast i8 [[MASK]] to <8 x i1>
; CHECK-NEXT:    [[TMP37:%.*]] = extractelement <8 x i1> [[TMP39]], i32 0
; CHECK-NEXT:    [[TMP38:%.*]] = select i1 [[TMP37]], i16 [[TMP35]], i16 [[TMP36]]
; CHECK-NEXT:    [[_MSPROP4:%.*]] = insertelement <8 x i16> [[_MSPROP3]], i16 [[TMP38]], i32 0
; CHECK-NEXT:    [[_MSCMP14:%.*]] = icmp ne i8 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP14]], label %[[BB39:.*]], label %[[BB40:.*]], !prof [[PROF1]]
; CHECK:       [[BB39]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB40]]:
; CHECK-NEXT:    [[RES3:%.*]] = call <8 x half> @llvm.x86.avx512fp16.mask.max.sh.round(<8 x half> [[RES2]], <8 x half> [[VAL]], <8 x half> [[SRC]], i8 [[MASK]], i32 4)
; CHECK-NEXT:    store <8 x i16> [[_MSPROP4]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES3]]
;
  %val.half = load half,ptr %ptr
  %val = insertelement <8 x half> poison, half %val.half, i32 0
  %res0 = call <8 x half> @llvm.x86.avx512fp16.mask.max.sh.round(<8 x half> %x1, <8 x half> %x2, <8 x half> zeroinitializer, i8 -1, i32 4)
  %res1 = call <8 x half> @llvm.x86.avx512fp16.mask.max.sh.round(<8 x half> %res0, <8 x half> %x2, <8 x half> %src , i8 %mask, i32 4)
  %res2 = call <8 x half> @llvm.x86.avx512fp16.mask.max.sh.round(<8 x half> %res1, <8 x half> %x2, <8 x half> zeroinitializer , i8 %mask, i32 4)
  %res3 = call <8 x half> @llvm.x86.avx512fp16.mask.max.sh.round(<8 x half> %res2, <8 x half> %val, <8 x half> %src , i8 %mask, i32 4)
  ret <8 x half> %res3
}

declare i8 @llvm.x86.avx512fp16.mask.cmp.sh(<8 x half>, <8 x half>, i32, i8, i32)

define i8 @test_int_x86_avx512_mask_cmp_sh(<8 x half> %x0, <8 x half> %x1, i8 %x3, i32 %x4) #0 {
; CHECK-LABEL: define i8 @test_int_x86_avx512_mask_cmp_sh(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x half> [[X1:%.*]], i8 [[X3:%.*]], i32 [[X4:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES2:%.*]] = call i8 @llvm.x86.avx512fp16.mask.cmp.sh(<8 x half> [[X0]], <8 x half> [[X1]], i32 3, i8 [[X3]], i32 4)
; CHECK-NEXT:    store i8 0, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i8 [[RES2]]
;
  %res2 = call i8 @llvm.x86.avx512fp16.mask.cmp.sh(<8 x half> %x0, <8 x half> %x1, i32 3, i8 %x3, i32 4)
  ret i8 %res2
}


define i8 @test_int_x86_avx512_mask_cmp_sh_all(<8 x half> %x0, <8 x half> %x1, i8 %x3, i32 %x4) #0 {
; CHECK-LABEL: define i8 @test_int_x86_avx512_mask_cmp_sh_all(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x half> [[X1:%.*]], i8 [[X3:%.*]], i32 [[X4:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES1:%.*]] = call i8 @llvm.x86.avx512fp16.mask.cmp.sh(<8 x half> [[X0]], <8 x half> [[X1]], i32 2, i8 -1, i32 4)
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP3:%.*]] = icmp ne i128 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR4:%.*]] = or i1 [[_MSCMP2]], [[_MSCMP3]]
; CHECK-NEXT:    br i1 [[_MSOR4]], label %[[BB10:.*]], label %[[BB11:.*]], !prof [[PROF1]]
; CHECK:       [[BB10]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB11]]:
; CHECK-NEXT:    [[RES2:%.*]] = call i8 @llvm.x86.avx512fp16.mask.cmp.sh(<8 x half> [[X0]], <8 x half> [[X1]], i32 3, i8 -1, i32 8)
; CHECK-NEXT:    [[TMP12:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP5:%.*]] = icmp ne i128 [[TMP12]], 0
; CHECK-NEXT:    [[TMP13:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP6:%.*]] = icmp ne i128 [[TMP13]], 0
; CHECK-NEXT:    [[_MSOR7:%.*]] = or i1 [[_MSCMP5]], [[_MSCMP6]]
; CHECK-NEXT:    [[_MSCMP8:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR9:%.*]] = or i1 [[_MSOR7]], [[_MSCMP8]]
; CHECK-NEXT:    br i1 [[_MSOR9]], label %[[BB14:.*]], label %[[BB15:.*]], !prof [[PROF1]]
; CHECK:       [[BB14]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB15]]:
; CHECK-NEXT:    [[RES3:%.*]] = call i8 @llvm.x86.avx512fp16.mask.cmp.sh(<8 x half> [[X0]], <8 x half> [[X1]], i32 4, i8 [[X3]], i32 4)
; CHECK-NEXT:    [[TMP16:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP10:%.*]] = icmp ne i128 [[TMP16]], 0
; CHECK-NEXT:    [[TMP17:%.*]] = bitcast <8 x i16> [[TMP2]] to i128
; CHECK-NEXT:    [[_MSCMP11:%.*]] = icmp ne i128 [[TMP17]], 0
; CHECK-NEXT:    [[_MSOR12:%.*]] = or i1 [[_MSCMP10]], [[_MSCMP11]]
; CHECK-NEXT:    [[_MSCMP13:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR14:%.*]] = or i1 [[_MSOR12]], [[_MSCMP13]]
; CHECK-NEXT:    br i1 [[_MSOR14]], label %[[BB18:.*]], label %[[BB19:.*]], !prof [[PROF1]]
; CHECK:       [[BB18]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB19]]:
; CHECK-NEXT:    [[RES4:%.*]] = call i8 @llvm.x86.avx512fp16.mask.cmp.sh(<8 x half> [[X0]], <8 x half> [[X1]], i32 5, i8 [[X3]], i32 8)
; CHECK-NEXT:    [[TMP20:%.*]] = and i8 [[RES1]], 0
; CHECK-NEXT:    [[TMP21:%.*]] = and i8 0, [[RES2]]
; CHECK-NEXT:    [[TMP22:%.*]] = or i8 0, [[TMP20]]
; CHECK-NEXT:    [[TMP23:%.*]] = or i8 [[TMP22]], [[TMP21]]
; CHECK-NEXT:    [[RES11:%.*]] = and i8 [[RES1]], [[RES2]]
; CHECK-NEXT:    [[TMP24:%.*]] = and i8 [[RES3]], 0
; CHECK-NEXT:    [[TMP25:%.*]] = and i8 0, [[RES4]]
; CHECK-NEXT:    [[TMP26:%.*]] = or i8 0, [[TMP24]]
; CHECK-NEXT:    [[TMP27:%.*]] = or i8 [[TMP26]], [[TMP25]]
; CHECK-NEXT:    [[RES12:%.*]] = and i8 [[RES3]], [[RES4]]
; CHECK-NEXT:    [[TMP28:%.*]] = and i8 [[TMP23]], [[TMP27]]
; CHECK-NEXT:    [[TMP29:%.*]] = and i8 [[RES11]], [[TMP27]]
; CHECK-NEXT:    [[TMP30:%.*]] = and i8 [[TMP23]], [[RES12]]
; CHECK-NEXT:    [[TMP31:%.*]] = or i8 [[TMP28]], [[TMP29]]
; CHECK-NEXT:    [[TMP32:%.*]] = or i8 [[TMP31]], [[TMP30]]
; CHECK-NEXT:    [[RES13:%.*]] = and i8 [[RES11]], [[RES12]]
; CHECK-NEXT:    store i8 [[TMP32]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i8 [[RES13]]
;
  %res1 = call i8 @llvm.x86.avx512fp16.mask.cmp.sh(<8 x half> %x0, <8 x half> %x1, i32 2, i8 -1, i32 4)
  %res2 = call i8 @llvm.x86.avx512fp16.mask.cmp.sh(<8 x half> %x0, <8 x half> %x1, i32 3, i8 -1, i32 8)
  %res3 = call i8 @llvm.x86.avx512fp16.mask.cmp.sh(<8 x half> %x0, <8 x half> %x1, i32 4, i8 %x3, i32 4)
  %res4 = call i8 @llvm.x86.avx512fp16.mask.cmp.sh(<8 x half> %x0, <8 x half> %x1, i32 5, i8 %x3, i32 8)

  %res11 = and i8 %res1, %res2
  %res12 = and i8 %res3, %res4
  %res13 = and i8 %res11, %res12
  ret i8 %res13
}

declare <16 x half> @llvm.x86.avx512.sitofp.round.v16f16.v16i32(<16 x i32>, i32)

define <16 x half> @test_int_x86_avx512_mask_cvt_dq2ph_512(<16 x i32> %x0, <16 x half> %x1, i16 %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512_mask_cvt_dq2ph_512(
; CHECK-SAME: <16 x i32> [[X0:%.*]], <16 x half> [[X1:%.*]], i16 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 96) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i16 [[TMP1]] to <16 x i1>
; CHECK-NEXT:    [[MASK:%.*]] = bitcast i16 [[X2]] to <16 x i1>
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <16 x i32> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES0:%.*]] = call <16 x half> @llvm.x86.avx512.sitofp.round.v16f16.v16i32(<16 x i32> [[X0]], i32 4)
; CHECK-NEXT:    [[TMP8:%.*]] = select <16 x i1> [[MASK]], <16 x i16> zeroinitializer, <16 x i16> [[TMP3]]
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <16 x half> [[RES0]] to <16 x i16>
; CHECK-NEXT:    [[TMP10:%.*]] = bitcast <16 x half> [[X1]] to <16 x i16>
; CHECK-NEXT:    [[TMP11:%.*]] = xor <16 x i16> [[TMP9]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = or <16 x i16> [[TMP11]], zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = or <16 x i16> [[TMP12]], [[TMP3]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP4]], <16 x i16> [[TMP13]], <16 x i16> [[TMP8]]
; CHECK-NEXT:    [[RES:%.*]] = select <16 x i1> [[MASK]], <16 x half> [[RES0]], <16 x half> [[X1]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %mask = bitcast i16 %x2 to <16 x i1>
  %res0 = call <16 x half> @llvm.x86.avx512.sitofp.round.v16f16.v16i32(<16 x i32> %x0, i32 4)
  %res = select <16 x i1> %mask, <16 x half> %res0, <16 x half> %x1
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512_mask_cvt_dq2ph_512_r(<16 x i32> %x0, <16 x half> %x1, i16 %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512_mask_cvt_dq2ph_512_r(
; CHECK-SAME: <16 x i32> [[X0:%.*]], <16 x half> [[X1:%.*]], i16 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 96) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i16 [[TMP1]] to <16 x i1>
; CHECK-NEXT:    [[MASK:%.*]] = bitcast i16 [[X2]] to <16 x i1>
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <16 x i32> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES0:%.*]] = call <16 x half> @llvm.x86.avx512.sitofp.round.v16f16.v16i32(<16 x i32> [[X0]], i32 10)
; CHECK-NEXT:    [[TMP8:%.*]] = select <16 x i1> [[MASK]], <16 x i16> zeroinitializer, <16 x i16> [[TMP3]]
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <16 x half> [[RES0]] to <16 x i16>
; CHECK-NEXT:    [[TMP10:%.*]] = bitcast <16 x half> [[X1]] to <16 x i16>
; CHECK-NEXT:    [[TMP11:%.*]] = xor <16 x i16> [[TMP9]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = or <16 x i16> [[TMP11]], zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = or <16 x i16> [[TMP12]], [[TMP3]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP4]], <16 x i16> [[TMP13]], <16 x i16> [[TMP8]]
; CHECK-NEXT:    [[RES:%.*]] = select <16 x i1> [[MASK]], <16 x half> [[RES0]], <16 x half> [[X1]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %mask = bitcast i16 %x2 to <16 x i1>
  %res0 = call <16 x half> @llvm.x86.avx512.sitofp.round.v16f16.v16i32(<16 x i32> %x0, i32 10)
  %res = select <16 x i1> %mask, <16 x half> %res0, <16 x half> %x1
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512_mask_cvt_dq2ph_512_nomask(<16 x i32> %x0, <16 x half> %x1) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512_mask_cvt_dq2ph_512_nomask(
; CHECK-SAME: <16 x i32> [[X0:%.*]], <16 x half> [[X1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <16 x i32> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES:%.*]] = call <16 x half> @llvm.x86.avx512.sitofp.round.v16f16.v16i32(<16 x i32> [[X0]], i32 4)
; CHECK-NEXT:    store <16 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %res = call <16 x half> @llvm.x86.avx512.sitofp.round.v16f16.v16i32(<16 x i32> %x0, i32 4)
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512_mask_cvt_dq2ph_512_z(<16 x i32> %x0, i16 %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512_mask_cvt_dq2ph_512_z(
; CHECK-SAME: <16 x i32> [[X0:%.*]], i16 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[TMP1]] to <16 x i1>
; CHECK-NEXT:    [[MASK:%.*]] = bitcast i16 [[X2]] to <16 x i1>
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <16 x i32> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP4]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB5:.*]], label %[[BB6:.*]], !prof [[PROF1]]
; CHECK:       [[BB5]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB6]]:
; CHECK-NEXT:    [[RES0:%.*]] = call <16 x half> @llvm.x86.avx512.sitofp.round.v16f16.v16i32(<16 x i32> [[X0]], i32 4)
; CHECK-NEXT:    [[TMP7:%.*]] = select <16 x i1> [[MASK]], <16 x i16> zeroinitializer, <16 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <16 x half> [[RES0]] to <16 x i16>
; CHECK-NEXT:    [[TMP9:%.*]] = xor <16 x i16> [[TMP8]], zeroinitializer
; CHECK-NEXT:    [[TMP10:%.*]] = or <16 x i16> [[TMP9]], zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = or <16 x i16> [[TMP10]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP3]], <16 x i16> [[TMP11]], <16 x i16> [[TMP7]]
; CHECK-NEXT:    [[RES:%.*]] = select <16 x i1> [[MASK]], <16 x half> [[RES0]], <16 x half> zeroinitializer
; CHECK-NEXT:    store <16 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %mask = bitcast i16 %x2 to <16 x i1>
  %res0 = call <16 x half> @llvm.x86.avx512.sitofp.round.v16f16.v16i32(<16 x i32> %x0, i32 4)
  %res = select <16 x i1> %mask, <16 x half> %res0, <16 x half> zeroinitializer
  ret <16 x half> %res
}

define <16 x half> @sint_to_fp_16i32_to_16f16(<16 x i32> %x) #0 {
; CHECK-LABEL: define <16 x half> @sint_to_fp_16i32_to_16f16(
; CHECK-SAME: <16 x i32> [[X:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = trunc <16 x i32> [[TMP1]] to <16 x i16>
; CHECK-NEXT:    [[RES:%.*]] = sitofp <16 x i32> [[X]] to <16 x half>
; CHECK-NEXT:    store <16 x i16> [[TMP2]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %res = sitofp <16 x i32> %x to <16 x half>
  ret <16 x half> %res
}

declare <16 x half> @llvm.x86.avx512.uitofp.round.v16f16.v16i32(<16 x i32>, i32)

define <16 x half> @test_int_x86_avx512_mask_cvt_udq2ph_512_r(<16 x i32> %x0, <16 x half> %x1, i16 %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512_mask_cvt_udq2ph_512_r(
; CHECK-SAME: <16 x i32> [[X0:%.*]], <16 x half> [[X1:%.*]], i16 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 96) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <16 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i16 [[TMP1]] to <16 x i1>
; CHECK-NEXT:    [[MASK:%.*]] = bitcast i16 [[X2]] to <16 x i1>
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <16 x i32> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES0:%.*]] = call <16 x half> @llvm.x86.avx512.uitofp.round.v16f16.v16i32(<16 x i32> [[X0]], i32 10)
; CHECK-NEXT:    [[TMP8:%.*]] = select <16 x i1> [[MASK]], <16 x i16> zeroinitializer, <16 x i16> [[TMP3]]
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <16 x half> [[RES0]] to <16 x i16>
; CHECK-NEXT:    [[TMP10:%.*]] = bitcast <16 x half> [[X1]] to <16 x i16>
; CHECK-NEXT:    [[TMP11:%.*]] = xor <16 x i16> [[TMP9]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = or <16 x i16> [[TMP11]], zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = or <16 x i16> [[TMP12]], [[TMP3]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP4]], <16 x i16> [[TMP13]], <16 x i16> [[TMP8]]
; CHECK-NEXT:    [[RES:%.*]] = select <16 x i1> [[MASK]], <16 x half> [[RES0]], <16 x half> [[X1]]
; CHECK-NEXT:    store <16 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %mask = bitcast i16 %x2 to <16 x i1>
  %res0 = call <16 x half> @llvm.x86.avx512.uitofp.round.v16f16.v16i32(<16 x i32> %x0, i32 10)
  %res = select <16 x i1> %mask, <16 x half> %res0, <16 x half> %x1
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512_mask_cvt_udq2ph_512_nomask(<16 x i32> %x0, <16 x half> %x1) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512_mask_cvt_udq2ph_512_nomask(
; CHECK-SAME: <16 x i32> [[X0:%.*]], <16 x half> [[X1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <16 x i32> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES:%.*]] = call <16 x half> @llvm.x86.avx512.uitofp.round.v16f16.v16i32(<16 x i32> [[X0]], i32 4)
; CHECK-NEXT:    store <16 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %res = call <16 x half> @llvm.x86.avx512.uitofp.round.v16f16.v16i32(<16 x i32> %x0, i32 4)
  ret <16 x half> %res
}

define <16 x half> @test_int_x86_avx512_mask_cvt_udq2ph_512_z(<16 x i32> %x0, i16 %x2) #0 {
; CHECK-LABEL: define <16 x half> @test_int_x86_avx512_mask_cvt_udq2ph_512_z(
; CHECK-SAME: <16 x i32> [[X0:%.*]], i16 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast i16 [[TMP1]] to <16 x i1>
; CHECK-NEXT:    [[MASK:%.*]] = bitcast i16 [[X2]] to <16 x i1>
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <16 x i32> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP4]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB5:.*]], label %[[BB6:.*]], !prof [[PROF1]]
; CHECK:       [[BB5]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB6]]:
; CHECK-NEXT:    [[RES0:%.*]] = call <16 x half> @llvm.x86.avx512.uitofp.round.v16f16.v16i32(<16 x i32> [[X0]], i32 4)
; CHECK-NEXT:    [[TMP7:%.*]] = select <16 x i1> [[MASK]], <16 x i16> zeroinitializer, <16 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <16 x half> [[RES0]] to <16 x i16>
; CHECK-NEXT:    [[TMP9:%.*]] = xor <16 x i16> [[TMP8]], zeroinitializer
; CHECK-NEXT:    [[TMP10:%.*]] = or <16 x i16> [[TMP9]], zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = or <16 x i16> [[TMP10]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <16 x i1> [[TMP3]], <16 x i16> [[TMP11]], <16 x i16> [[TMP7]]
; CHECK-NEXT:    [[RES:%.*]] = select <16 x i1> [[MASK]], <16 x half> [[RES0]], <16 x half> zeroinitializer
; CHECK-NEXT:    store <16 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %mask = bitcast i16 %x2 to <16 x i1>
  %res0 = call <16 x half> @llvm.x86.avx512.uitofp.round.v16f16.v16i32(<16 x i32> %x0, i32 4)
  %res = select <16 x i1> %mask, <16 x half> %res0, <16 x half> zeroinitializer
  ret <16 x half> %res
}

define <16 x half> @uint_to_fp_16i32_to_16f16(<16 x i32> %x) #0 {
; CHECK-LABEL: define <16 x half> @uint_to_fp_16i32_to_16f16(
; CHECK-SAME: <16 x i32> [[X:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = trunc <16 x i32> [[TMP1]] to <16 x i16>
; CHECK-NEXT:    [[RES:%.*]] = uitofp <16 x i32> [[X]] to <16 x half>
; CHECK-NEXT:    store <16 x i16> [[TMP2]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %res = uitofp <16 x i32> %x to <16 x half>
  ret <16 x half> %res
}

declare <16 x i32> @llvm.x86.avx512fp16.mask.vcvtph2dq.512(<16 x half>, <16 x i32>, i16, i32)

define <16 x i32> @test_int_x86_avx512_mask_cvt_ph2dq_512(<16 x half> %x0, <16 x i32> %x1, i16 %x2) #0 {
; CHECK-LABEL: define <16 x i32> @test_int_x86_avx512_mask_cvt_ph2dq_512(
; CHECK-SAME: <16 x half> [[X0:%.*]], <16 x i32> [[X1:%.*]], i16 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 96) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <16 x i16> [[TMP1]] to i256
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i256 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <16 x i32> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i16 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvtph2dq.512(<16 x half> [[X0]], <16 x i32> [[X1]], i16 [[X2]], i32 10)
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <16 x i16> [[TMP1]] to i256
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i256 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <16 x i32> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP5:%.*]] = icmp ne i512 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR6:%.*]] = or i1 [[_MSCMP4]], [[_MSCMP5]]
; CHECK-NEXT:    br i1 [[_MSOR6]], label %[[BB10:.*]], label %[[BB11:.*]], !prof [[PROF1]]
; CHECK:       [[BB10]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB11]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvtph2dq.512(<16 x half> [[X0]], <16 x i32> [[X1]], i16 -1, i32 8)
; CHECK-NEXT:    [[RES2:%.*]] = add <16 x i32> [[RES]], [[RES1]]
; CHECK-NEXT:    store <16 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x i32> [[RES2]]
;
  %res = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvtph2dq.512(<16 x half> %x0, <16 x i32> %x1, i16 %x2, i32 10)
  %res1 = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvtph2dq.512(<16 x half> %x0, <16 x i32> %x1, i16 -1, i32 8)
  %res2 = add <16 x i32> %res, %res1
  ret <16 x i32> %res2
}

declare <16 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.512(<16 x half>, <16 x i32>, i16, i32)

define <16 x i32> @test_int_x86_avx512_mask_cvt_ph2udq_512(<16 x half> %x0, <16 x i32> %x1, i16 %x2) #0 {
; CHECK-LABEL: define <16 x i32> @test_int_x86_avx512_mask_cvt_ph2udq_512(
; CHECK-SAME: <16 x half> [[X0:%.*]], <16 x i32> [[X1:%.*]], i16 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 96) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <16 x i16> [[TMP1]] to i256
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i256 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <16 x i32> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i16 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.512(<16 x half> [[X0]], <16 x i32> [[X1]], i16 [[X2]], i32 10)
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <16 x i16> [[TMP1]] to i256
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i256 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <16 x i32> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP5:%.*]] = icmp ne i512 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR6:%.*]] = or i1 [[_MSCMP4]], [[_MSCMP5]]
; CHECK-NEXT:    br i1 [[_MSOR6]], label %[[BB10:.*]], label %[[BB11:.*]], !prof [[PROF1]]
; CHECK:       [[BB10]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB11]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.512(<16 x half> [[X0]], <16 x i32> [[X1]], i16 -1, i32 8)
; CHECK-NEXT:    [[RES2:%.*]] = add <16 x i32> [[RES]], [[RES1]]
; CHECK-NEXT:    store <16 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x i32> [[RES2]]
;
  %res = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.512(<16 x half> %x0, <16 x i32> %x1, i16 %x2, i32 10)
  %res1 = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvtph2udq.512(<16 x half> %x0, <16 x i32> %x1, i16 -1, i32 8)
  %res2 = add <16 x i32> %res, %res1
  ret <16 x i32> %res2
}

declare <16 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.512(<16 x half>, <16 x i32>, i16, i32)

define <16 x i32> @test_int_x86_avx512_mask_cvtt_ph2dq_512(<16 x half> %x0, <16 x i32> %x1, i16 %x2) #0 {
; CHECK-LABEL: define <16 x i32> @test_int_x86_avx512_mask_cvtt_ph2dq_512(
; CHECK-SAME: <16 x half> [[X0:%.*]], <16 x i32> [[X1:%.*]], i16 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 96) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <16 x i16> [[TMP1]] to i256
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i256 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <16 x i32> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i16 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.512(<16 x half> [[X0]], <16 x i32> [[X1]], i16 [[X2]], i32 4)
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <16 x i16> [[TMP1]] to i256
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i256 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <16 x i32> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP5:%.*]] = icmp ne i512 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR6:%.*]] = or i1 [[_MSCMP4]], [[_MSCMP5]]
; CHECK-NEXT:    br i1 [[_MSOR6]], label %[[BB10:.*]], label %[[BB11:.*]], !prof [[PROF1]]
; CHECK:       [[BB10]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB11]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.512(<16 x half> [[X0]], <16 x i32> [[X1]], i16 -1, i32 8)
; CHECK-NEXT:    [[RES2:%.*]] = add <16 x i32> [[RES]], [[RES1]]
; CHECK-NEXT:    store <16 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x i32> [[RES2]]
;
  %res = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.512(<16 x half> %x0, <16 x i32> %x1, i16 %x2, i32 4)
  %res1 = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvttph2dq.512(<16 x half> %x0, <16 x i32> %x1, i16 -1, i32 8)
  %res2 = add <16 x i32> %res, %res1
  ret <16 x i32> %res2
}

declare <16 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.512(<16 x half>, <16 x i32>, i16, i32)

define <16 x i32> @test_int_x86_avx512_mask_cvtt_ph2udq_512(<16 x half> %x0, <16 x i32> %x1, i16 %x2) #0 {
; CHECK-LABEL: define <16 x i32> @test_int_x86_avx512_mask_cvtt_ph2udq_512(
; CHECK-SAME: <16 x half> [[X0:%.*]], <16 x i32> [[X1:%.*]], i16 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <16 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <16 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 32) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i16, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 96) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <16 x i16> [[TMP1]] to i256
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i256 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <16 x i32> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i16 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.512(<16 x half> [[X0]], <16 x i32> [[X1]], i16 [[X2]], i32 4)
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <16 x i16> [[TMP1]] to i256
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i256 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <16 x i32> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP5:%.*]] = icmp ne i512 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR6:%.*]] = or i1 [[_MSCMP4]], [[_MSCMP5]]
; CHECK-NEXT:    br i1 [[_MSOR6]], label %[[BB10:.*]], label %[[BB11:.*]], !prof [[PROF1]]
; CHECK:       [[BB10]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB11]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.512(<16 x half> [[X0]], <16 x i32> [[X1]], i16 -1, i32 8)
; CHECK-NEXT:    [[RES2:%.*]] = add <16 x i32> [[RES]], [[RES1]]
; CHECK-NEXT:    store <16 x i32> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x i32> [[RES2]]
;
  %res = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.512(<16 x half> %x0, <16 x i32> %x1, i16 %x2, i32 4)
  %res1 = call <16 x i32> @llvm.x86.avx512fp16.mask.vcvttph2udq.512(<16 x half> %x0, <16 x i32> %x1, i16 -1, i32 8)
  %res2 = add <16 x i32> %res, %res1
  ret <16 x i32> %res2
}

declare <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v8i64(<8 x i64>, i32)

define <8 x half> @test_int_x86_avx512_mask_cvt_qq2ph_512(<8 x i64> %x0, <8 x half> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_cvt_qq2ph_512(
; CHECK-SAME: <8 x i64> [[X0:%.*]], <8 x half> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 80) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MASK:%.*]] = bitcast i8 [[X2]] to <8 x i1>
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i64> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v8i64(<8 x i64> [[X0]], i32 4)
; CHECK-NEXT:    [[TMP8:%.*]] = select <8 x i1> [[MASK]], <8 x i16> zeroinitializer, <8 x i16> [[TMP3]]
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP10:%.*]] = bitcast <8 x half> [[X1]] to <8 x i16>
; CHECK-NEXT:    [[TMP11:%.*]] = xor <8 x i16> [[TMP9]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = or <8 x i16> [[TMP11]], zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = or <8 x i16> [[TMP12]], [[TMP3]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP4]], <8 x i16> [[TMP13]], <8 x i16> [[TMP8]]
; CHECK-NEXT:    [[RES:%.*]] = select <8 x i1> [[MASK]], <8 x half> [[RES0]], <8 x half> [[X1]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %mask = bitcast i8 %x2 to <8 x i1>
  %res0 = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v8i64(<8 x i64> %x0, i32 4)
  %res = select <8 x i1> %mask, <8 x half> %res0, <8 x half> %x1
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512_mask_cvt_qq2ph_512_r(<8 x i64> %x0, <8 x half> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_cvt_qq2ph_512_r(
; CHECK-SAME: <8 x i64> [[X0:%.*]], <8 x half> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 80) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MASK:%.*]] = bitcast i8 [[X2]] to <8 x i1>
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i64> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v8i64(<8 x i64> [[X0]], i32 10)
; CHECK-NEXT:    [[TMP8:%.*]] = select <8 x i1> [[MASK]], <8 x i16> zeroinitializer, <8 x i16> [[TMP3]]
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP10:%.*]] = bitcast <8 x half> [[X1]] to <8 x i16>
; CHECK-NEXT:    [[TMP11:%.*]] = xor <8 x i16> [[TMP9]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = or <8 x i16> [[TMP11]], zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = or <8 x i16> [[TMP12]], [[TMP3]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP4]], <8 x i16> [[TMP13]], <8 x i16> [[TMP8]]
; CHECK-NEXT:    [[RES:%.*]] = select <8 x i1> [[MASK]], <8 x half> [[RES0]], <8 x half> [[X1]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %mask = bitcast i8 %x2 to <8 x i1>
  %res0 = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v8i64(<8 x i64> %x0, i32 10)
  %res = select <8 x i1> %mask, <8 x half> %res0, <8 x half> %x1
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512_mask_cvt_qq2ph_512_nomask(<8 x i64> %x0, <8 x half> %x1) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_cvt_qq2ph_512_nomask(
; CHECK-SAME: <8 x i64> [[X0:%.*]], <8 x half> [[X1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x i64> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v8i64(<8 x i64> [[X0]], i32 4)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v8i64(<8 x i64> %x0, i32 4)
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512_mask_cvt_qq2ph_512_z(<8 x i64> %x0, i8 %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_cvt_qq2ph_512_z(
; CHECK-SAME: <8 x i64> [[X0:%.*]], i8 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MASK:%.*]] = bitcast i8 [[X2]] to <8 x i1>
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i64> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP4]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB5:.*]], label %[[BB6:.*]], !prof [[PROF1]]
; CHECK:       [[BB5]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB6]]:
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v8i64(<8 x i64> [[X0]], i32 4)
; CHECK-NEXT:    [[TMP7:%.*]] = select <8 x i1> [[MASK]], <8 x i16> zeroinitializer, <8 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP9:%.*]] = xor <8 x i16> [[TMP8]], zeroinitializer
; CHECK-NEXT:    [[TMP10:%.*]] = or <8 x i16> [[TMP9]], zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = or <8 x i16> [[TMP10]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP3]], <8 x i16> [[TMP11]], <8 x i16> [[TMP7]]
; CHECK-NEXT:    [[RES:%.*]] = select <8 x i1> [[MASK]], <8 x half> [[RES0]], <8 x half> zeroinitializer
; CHECK-NEXT:    store <8 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %mask = bitcast i8 %x2 to <8 x i1>
  %res0 = call <8 x half> @llvm.x86.avx512.sitofp.round.v8f16.v8i64(<8 x i64> %x0, i32 4)
  %res = select <8 x i1> %mask, <8 x half> %res0, <8 x half> zeroinitializer
  ret <8 x half> %res
}

declare <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v8i64(<8 x i64>, i32)

define <8 x half> @test_int_x86_avx512_mask_cvt_uqq2ph_512(<8 x i64> %x0, <8 x half> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_cvt_uqq2ph_512(
; CHECK-SAME: <8 x i64> [[X0:%.*]], <8 x half> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 80) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MASK:%.*]] = bitcast i8 [[X2]] to <8 x i1>
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i64> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v8i64(<8 x i64> [[X0]], i32 4)
; CHECK-NEXT:    [[TMP8:%.*]] = select <8 x i1> [[MASK]], <8 x i16> zeroinitializer, <8 x i16> [[TMP3]]
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP10:%.*]] = bitcast <8 x half> [[X1]] to <8 x i16>
; CHECK-NEXT:    [[TMP11:%.*]] = xor <8 x i16> [[TMP9]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = or <8 x i16> [[TMP11]], zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = or <8 x i16> [[TMP12]], [[TMP3]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP4]], <8 x i16> [[TMP13]], <8 x i16> [[TMP8]]
; CHECK-NEXT:    [[RES:%.*]] = select <8 x i1> [[MASK]], <8 x half> [[RES0]], <8 x half> [[X1]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %mask = bitcast i8 %x2 to <8 x i1>
  %res0 = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v8i64(<8 x i64> %x0, i32 4)
  %res = select <8 x i1> %mask, <8 x half> %res0, <8 x half> %x1
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512_mask_cvt_uqq2ph_512_r(<8 x i64> %x0, <8 x half> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_cvt_uqq2ph_512_r(
; CHECK-SAME: <8 x i64> [[X0:%.*]], <8 x half> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 80) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load <8 x i16>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MASK:%.*]] = bitcast i8 [[X2]] to <8 x i1>
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i64> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v8i64(<8 x i64> [[X0]], i32 10)
; CHECK-NEXT:    [[TMP8:%.*]] = select <8 x i1> [[MASK]], <8 x i16> zeroinitializer, <8 x i16> [[TMP3]]
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP10:%.*]] = bitcast <8 x half> [[X1]] to <8 x i16>
; CHECK-NEXT:    [[TMP11:%.*]] = xor <8 x i16> [[TMP9]], [[TMP10]]
; CHECK-NEXT:    [[TMP12:%.*]] = or <8 x i16> [[TMP11]], zeroinitializer
; CHECK-NEXT:    [[TMP13:%.*]] = or <8 x i16> [[TMP12]], [[TMP3]]
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP4]], <8 x i16> [[TMP13]], <8 x i16> [[TMP8]]
; CHECK-NEXT:    [[RES:%.*]] = select <8 x i1> [[MASK]], <8 x half> [[RES0]], <8 x half> [[X1]]
; CHECK-NEXT:    store <8 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %mask = bitcast i8 %x2 to <8 x i1>
  %res0 = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v8i64(<8 x i64> %x0, i32 10)
  %res = select <8 x i1> %mask, <8 x half> %res0, <8 x half> %x1
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512_mask_cvt_uqq2ph_512_nomask(<8 x i64> %x0, <8 x half> %x1) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_cvt_uqq2ph_512_nomask(
; CHECK-SAME: <8 x i64> [[X0:%.*]], <8 x half> [[X1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x i64> [[TMP1]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v8i64(<8 x i64> [[X0]], i32 4)
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v8i64(<8 x i64> %x0, i32 4)
  ret <8 x half> %res
}

define <8 x half> @test_int_x86_avx512_mask_cvt_uqq2ph_512_z(<8 x i64> %x0, i8 %x2) #0 {
; CHECK-LABEL: define <8 x half> @test_int_x86_avx512_mask_cvt_uqq2ph_512_z(
; CHECK-SAME: <8 x i64> [[X0:%.*]], i8 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 64) to ptr), align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i64>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast i8 [[TMP1]] to <8 x i1>
; CHECK-NEXT:    [[MASK:%.*]] = bitcast i8 [[X2]] to <8 x i1>
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i64> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i512 [[TMP4]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB5:.*]], label %[[BB6:.*]], !prof [[PROF1]]
; CHECK:       [[BB5]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB6]]:
; CHECK-NEXT:    [[RES0:%.*]] = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v8i64(<8 x i64> [[X0]], i32 4)
; CHECK-NEXT:    [[TMP7:%.*]] = select <8 x i1> [[MASK]], <8 x i16> zeroinitializer, <8 x i16> zeroinitializer
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x half> [[RES0]] to <8 x i16>
; CHECK-NEXT:    [[TMP9:%.*]] = xor <8 x i16> [[TMP8]], zeroinitializer
; CHECK-NEXT:    [[TMP10:%.*]] = or <8 x i16> [[TMP9]], zeroinitializer
; CHECK-NEXT:    [[TMP11:%.*]] = or <8 x i16> [[TMP10]], zeroinitializer
; CHECK-NEXT:    [[_MSPROP_SELECT:%.*]] = select <8 x i1> [[TMP3]], <8 x i16> [[TMP11]], <8 x i16> [[TMP7]]
; CHECK-NEXT:    [[RES:%.*]] = select <8 x i1> [[MASK]], <8 x half> [[RES0]], <8 x half> zeroinitializer
; CHECK-NEXT:    store <8 x i16> [[_MSPROP_SELECT]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %mask = bitcast i8 %x2 to <8 x i1>
  %res0 = call <8 x half> @llvm.x86.avx512.uitofp.round.v8f16.v8i64(<8 x i64> %x0, i32 4)
  %res = select <8 x i1> %mask, <8 x half> %res0, <8 x half> zeroinitializer
  ret <8 x half> %res
}

declare <8 x i64> @llvm.x86.avx512fp16.mask.vcvtph2qq.512(<8 x half>, <8 x i64>, i8, i32)

define <8 x i64> @test_int_x86_avx512_mask_cvt_ph2qq_512(<8 x half> %x0, <8 x i64> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x i64> @test_int_x86_avx512_mask_cvt_ph2qq_512(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x i64> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i64>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 80) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i64> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i64> @llvm.x86.avx512fp16.mask.vcvtph2qq.512(<8 x half> [[X0]], <8 x i64> [[X1]], i8 [[X2]], i32 10)
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i128 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <8 x i64> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP5:%.*]] = icmp ne i512 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR6:%.*]] = or i1 [[_MSCMP4]], [[_MSCMP5]]
; CHECK-NEXT:    br i1 [[_MSOR6]], label %[[BB10:.*]], label %[[BB11:.*]], !prof [[PROF1]]
; CHECK:       [[BB10]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB11]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x i64> @llvm.x86.avx512fp16.mask.vcvtph2qq.512(<8 x half> [[X0]], <8 x i64> [[X1]], i8 -1, i32 8)
; CHECK-NEXT:    [[RES2:%.*]] = add <8 x i64> [[RES]], [[RES1]]
; CHECK-NEXT:    store <8 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i64> [[RES2]]
;
  %res = call <8 x i64> @llvm.x86.avx512fp16.mask.vcvtph2qq.512(<8 x half> %x0, <8 x i64> %x1, i8 %x2, i32 10)
  %res1 = call <8 x i64> @llvm.x86.avx512fp16.mask.vcvtph2qq.512(<8 x half> %x0, <8 x i64> %x1, i8 -1, i32 8)
  %res2 = add <8 x i64> %res, %res1
  ret <8 x i64> %res2
}

declare <8 x i64> @llvm.x86.avx512fp16.mask.vcvtph2uqq.512(<8 x half>, <8 x i64>, i8, i32)

define <8 x i64> @test_int_x86_avx512_mask_cvt_ph2uqq_512(<8 x half> %x0, <8 x i64> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x i64> @test_int_x86_avx512_mask_cvt_ph2uqq_512(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x i64> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i64>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 80) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i64> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i64> @llvm.x86.avx512fp16.mask.vcvtph2uqq.512(<8 x half> [[X0]], <8 x i64> [[X1]], i8 [[X2]], i32 10)
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i128 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <8 x i64> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP5:%.*]] = icmp ne i512 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR6:%.*]] = or i1 [[_MSCMP4]], [[_MSCMP5]]
; CHECK-NEXT:    br i1 [[_MSOR6]], label %[[BB10:.*]], label %[[BB11:.*]], !prof [[PROF1]]
; CHECK:       [[BB10]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB11]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x i64> @llvm.x86.avx512fp16.mask.vcvtph2uqq.512(<8 x half> [[X0]], <8 x i64> [[X1]], i8 -1, i32 8)
; CHECK-NEXT:    [[RES2:%.*]] = add <8 x i64> [[RES]], [[RES1]]
; CHECK-NEXT:    store <8 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i64> [[RES2]]
;
  %res = call <8 x i64> @llvm.x86.avx512fp16.mask.vcvtph2uqq.512(<8 x half> %x0, <8 x i64> %x1, i8 %x2, i32 10)
  %res1 = call <8 x i64> @llvm.x86.avx512fp16.mask.vcvtph2uqq.512(<8 x half> %x0, <8 x i64> %x1, i8 -1, i32 8)
  %res2 = add <8 x i64> %res, %res1
  ret <8 x i64> %res2
}

declare <8 x i64> @llvm.x86.avx512fp16.mask.vcvttph2uqq.512(<8 x half>, <8 x i64>, i8, i32)

define <8 x i64> @test_int_x86_avx512_mask_cvtt_ph2uqq_512(<8 x half> %x0, <8 x i64> %x1, i8 %x2) #0 {
; CHECK-LABEL: define <8 x i64> @test_int_x86_avx512_mask_cvtt_ph2uqq_512(
; CHECK-SAME: <8 x half> [[X0:%.*]], <8 x i64> [[X1:%.*]], i8 [[X2:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <8 x i64>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    [[TMP3:%.*]] = load i8, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 80) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP4:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP4]], 0
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i64> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i512 [[TMP5]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i8 [[TMP3]], 0
; CHECK-NEXT:    [[_MSOR3:%.*]] = or i1 [[_MSOR]], [[_MSCMP2]]
; CHECK-NEXT:    br i1 [[_MSOR3]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES:%.*]] = call <8 x i64> @llvm.x86.avx512fp16.mask.vcvttph2uqq.512(<8 x half> [[X0]], <8 x i64> [[X1]], i8 [[X2]], i32 8)
; CHECK-NEXT:    [[TMP8:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP4:%.*]] = icmp ne i128 [[TMP8]], 0
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast <8 x i64> [[TMP2]] to i512
; CHECK-NEXT:    [[_MSCMP5:%.*]] = icmp ne i512 [[TMP9]], 0
; CHECK-NEXT:    [[_MSOR6:%.*]] = or i1 [[_MSCMP4]], [[_MSCMP5]]
; CHECK-NEXT:    br i1 [[_MSOR6]], label %[[BB10:.*]], label %[[BB11:.*]], !prof [[PROF1]]
; CHECK:       [[BB10]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB11]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x i64> @llvm.x86.avx512fp16.mask.vcvttph2uqq.512(<8 x half> [[X0]], <8 x i64> [[X1]], i8 -1, i32 4)
; CHECK-NEXT:    [[RES2:%.*]] = add <8 x i64> [[RES]], [[RES1]]
; CHECK-NEXT:    store <8 x i64> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x i64> [[RES2]]
;
  %res = call <8 x i64> @llvm.x86.avx512fp16.mask.vcvttph2uqq.512(<8 x half> %x0, <8 x i64> %x1, i8 %x2, i32 8)
  %res1 = call <8 x i64> @llvm.x86.avx512fp16.mask.vcvttph2uqq.512(<8 x half> %x0, <8 x i64> %x1, i8 -1, i32 4)
  %res2 = add <8 x i64> %res, %res1
  ret <8 x i64> %res2
}

declare i32 @llvm.x86.avx512fp16.vcvtsh2si32(<8 x half>, i32)

define i32 @test_x86_avx512fp16_vcvtsh2si32(<8 x half> %arg0) #0 {
; CHECK-LABEL: define i32 @test_x86_avx512fp16_vcvtsh2si32(
; CHECK-SAME: <8 x half> [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES1:%.*]] = call i32 @llvm.x86.avx512fp16.vcvtsh2si32(<8 x half> [[ARG0]], i32 4)
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES2:%.*]] = call i32 @llvm.x86.avx512fp16.vcvtsh2si32(<8 x half> [[ARG0]], i32 11)
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[RES1]], [[RES2]]
; CHECK-NEXT:    store i32 0, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res1 = call i32 @llvm.x86.avx512fp16.vcvtsh2si32(<8 x half> %arg0, i32 4)
  %res2 = call i32 @llvm.x86.avx512fp16.vcvtsh2si32(<8 x half> %arg0, i32 11)
  %res = add i32 %res1, %res2
  ret i32 %res
}

declare i64 @llvm.x86.avx512fp16.vcvtsh2si64(<8 x half>, i32)

define i64 @test_x86_avx512fp16_vcvtsh2si64(<8 x half> %arg0) #0 {
; CHECK-LABEL: define i64 @test_x86_avx512fp16_vcvtsh2si64(
; CHECK-SAME: <8 x half> [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES1:%.*]] = call i64 @llvm.x86.avx512fp16.vcvtsh2si64(<8 x half> [[ARG0]], i32 4)
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES2:%.*]] = call i64 @llvm.x86.avx512fp16.vcvtsh2si64(<8 x half> [[ARG0]], i32 10)
; CHECK-NEXT:    [[RES:%.*]] = add i64 [[RES1]], [[RES2]]
; CHECK-NEXT:    store i64 0, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res1 = call i64 @llvm.x86.avx512fp16.vcvtsh2si64(<8 x half> %arg0, i32 4)
  %res2 = call i64 @llvm.x86.avx512fp16.vcvtsh2si64(<8 x half> %arg0, i32 10)
  %res = add i64 %res1, %res2
  ret i64 %res
}

declare i32 @llvm.x86.avx512fp16.vcvttsh2si32(<8 x half>, i32)

define i32 @test_x86_avx512fp16_vcvttsh2si32(<8 x half> %arg0) #0 {
; CHECK-LABEL: define i32 @test_x86_avx512fp16_vcvttsh2si32(
; CHECK-SAME: <8 x half> [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES1:%.*]] = call i32 @llvm.x86.avx512fp16.vcvttsh2si32(<8 x half> [[ARG0]], i32 4)
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES2:%.*]] = call i32 @llvm.x86.avx512fp16.vcvttsh2si32(<8 x half> [[ARG0]], i32 8)
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[RES1]], [[RES2]]
; CHECK-NEXT:    store i32 0, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res1 = call i32 @llvm.x86.avx512fp16.vcvttsh2si32(<8 x half> %arg0, i32 4)
  %res2 = call i32 @llvm.x86.avx512fp16.vcvttsh2si32(<8 x half> %arg0, i32 8)
  %res = add i32 %res1, %res2
  ret i32 %res
}

declare i64 @llvm.x86.avx512fp16.vcvttsh2si64(<8 x half>, i32)

define i64 @test_x86_avx512fp16_vcvttsh2si64(<8 x half> %arg0) #0 {
; CHECK-LABEL: define i64 @test_x86_avx512fp16_vcvttsh2si64(
; CHECK-SAME: <8 x half> [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES1:%.*]] = call i64 @llvm.x86.avx512fp16.vcvttsh2si64(<8 x half> [[ARG0]], i32 4)
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES2:%.*]] = call i64 @llvm.x86.avx512fp16.vcvttsh2si64(<8 x half> [[ARG0]], i32 8)
; CHECK-NEXT:    [[RES:%.*]] = add i64 [[RES1]], [[RES2]]
; CHECK-NEXT:    store i64 0, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res1 = call i64 @llvm.x86.avx512fp16.vcvttsh2si64(<8 x half> %arg0, i32 4)
  %res2 = call i64 @llvm.x86.avx512fp16.vcvttsh2si64(<8 x half> %arg0, i32 8)
  %res = add i64 %res1, %res2
  ret i64 %res
}


declare i32 @llvm.x86.avx512fp16.vcvtsh2usi32(<8 x half>, i32)

define i32 @test_x86_avx512fp16_vcvtsh2usi32(<8 x half> %arg0) #0 {
; CHECK-LABEL: define i32 @test_x86_avx512fp16_vcvtsh2usi32(
; CHECK-SAME: <8 x half> [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES1:%.*]] = call i32 @llvm.x86.avx512fp16.vcvtsh2usi32(<8 x half> [[ARG0]], i32 4)
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES2:%.*]] = call i32 @llvm.x86.avx512fp16.vcvtsh2usi32(<8 x half> [[ARG0]], i32 9)
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[RES1]], [[RES2]]
; CHECK-NEXT:    store i32 0, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res1 = call i32 @llvm.x86.avx512fp16.vcvtsh2usi32(<8 x half> %arg0, i32 4)
  %res2 = call i32 @llvm.x86.avx512fp16.vcvtsh2usi32(<8 x half> %arg0, i32 9)
  %res = add i32 %res1, %res2
  ret i32 %res
}


declare i64 @llvm.x86.avx512fp16.vcvtsh2usi64(<8 x half>, i32)

define i64 @test_x86_avx512fp16_vcvtsh2usi64(<8 x half> %arg0) #0 {
; CHECK-LABEL: define i64 @test_x86_avx512fp16_vcvtsh2usi64(
; CHECK-SAME: <8 x half> [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES1:%.*]] = call i64 @llvm.x86.avx512fp16.vcvtsh2usi64(<8 x half> [[ARG0]], i32 4)
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES2:%.*]] = call i64 @llvm.x86.avx512fp16.vcvtsh2usi64(<8 x half> [[ARG0]], i32 10)
; CHECK-NEXT:    [[RES:%.*]] = add i64 [[RES1]], [[RES2]]
; CHECK-NEXT:    store i64 0, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res1 = call i64 @llvm.x86.avx512fp16.vcvtsh2usi64(<8 x half> %arg0, i32 4)
  %res2 = call i64 @llvm.x86.avx512fp16.vcvtsh2usi64(<8 x half> %arg0, i32 10)
  %res = add i64 %res1, %res2
  ret i64 %res
}

declare i32 @llvm.x86.avx512fp16.vcvttsh2usi32(<8 x half>, i32)

define i32 @test_x86_avx512fp16_vcvttsh2usi32(<8 x half> %arg0) #0 {
; CHECK-LABEL: define i32 @test_x86_avx512fp16_vcvttsh2usi32(
; CHECK-SAME: <8 x half> [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES1:%.*]] = call i32 @llvm.x86.avx512fp16.vcvttsh2usi32(<8 x half> [[ARG0]], i32 4)
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES2:%.*]] = call i32 @llvm.x86.avx512fp16.vcvttsh2usi32(<8 x half> [[ARG0]], i32 8)
; CHECK-NEXT:    [[RES:%.*]] = add i32 [[RES1]], [[RES2]]
; CHECK-NEXT:    store i32 0, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i32 [[RES]]
;
  %res1 = call i32 @llvm.x86.avx512fp16.vcvttsh2usi32(<8 x half> %arg0, i32 4)
  %res2 = call i32 @llvm.x86.avx512fp16.vcvttsh2usi32(<8 x half> %arg0, i32 8)
  %res = add i32 %res1, %res2
  ret i32 %res
}

declare i64 @llvm.x86.avx512fp16.vcvttsh2usi64(<8 x half>, i32)

define i64 @test_x86_avx512fp16_vcvttsh2usi64(<8 x half> %arg0) #0 {
; CHECK-LABEL: define i64 @test_x86_avx512fp16_vcvttsh2usi64(
; CHECK-SAME: <8 x half> [[ARG0:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP2:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP2]], 0
; CHECK-NEXT:    br i1 [[_MSCMP]], label %[[BB3:.*]], label %[[BB4:.*]], !prof [[PROF1]]
; CHECK:       [[BB3]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB4]]:
; CHECK-NEXT:    [[RES1:%.*]] = call i64 @llvm.x86.avx512fp16.vcvttsh2usi64(<8 x half> [[ARG0]], i32 4)
; CHECK-NEXT:    [[TMP5:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i128 [[TMP5]], 0
; CHECK-NEXT:    br i1 [[_MSCMP1]], label %[[BB6:.*]], label %[[BB7:.*]], !prof [[PROF1]]
; CHECK:       [[BB6]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB7]]:
; CHECK-NEXT:    [[RES2:%.*]] = call i64 @llvm.x86.avx512fp16.vcvttsh2usi64(<8 x half> [[ARG0]], i32 8)
; CHECK-NEXT:    [[RES:%.*]] = add i64 [[RES1]], [[RES2]]
; CHECK-NEXT:    store i64 0, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res1 = call i64 @llvm.x86.avx512fp16.vcvttsh2usi64(<8 x half> %arg0, i32 4)
  %res2 = call i64 @llvm.x86.avx512fp16.vcvttsh2usi64(<8 x half> %arg0, i32 8)
  %res = add i64 %res1, %res2
  ret i64 %res
}

declare <8 x half> @llvm.x86.avx512fp16.vcvtsi2sh(<8 x half>, i32, i32)

define <8 x half> @test_x86_avx512fp16_vcvtsi2sh(<8 x half> %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define <8 x half> @test_x86_avx512fp16_vcvtsi2sh(
; CHECK-SAME: <8 x half> [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i32 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x half> @llvm.x86.avx512fp16.vcvtsi2sh(<8 x half> [[ARG0]], i32 [[ARG1]], i32 4)
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSCMP3:%.*]] = icmp ne i32 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR4:%.*]] = or i1 [[_MSCMP2]], [[_MSCMP3]]
; CHECK-NEXT:    br i1 [[_MSOR4]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[RES2:%.*]] = call <8 x half> @llvm.x86.avx512fp16.vcvtsi2sh(<8 x half> [[ARG0]], i32 [[ARG1]], i32 9)
; CHECK-NEXT:    [[RES:%.*]] = fadd <8 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res1 = call <8 x half> @llvm.x86.avx512fp16.vcvtsi2sh(<8 x half> %arg0, i32 %arg1, i32 4)
  %res2 = call <8 x half> @llvm.x86.avx512fp16.vcvtsi2sh(<8 x half> %arg0, i32 %arg1, i32 9)
  %res = fadd <8 x half> %res1, %res2
  ret <8 x half> %res
}

declare <8 x half> @llvm.x86.avx512fp16.vcvtsi642sh(<8 x half>, i64, i32)

define <8 x half> @test_x86_avx512fp16_vcvtsi642sh(<8 x half> %arg0, i64 %arg1) #0 {
; CHECK-LABEL: define <8 x half> @test_x86_avx512fp16_vcvtsi642sh(
; CHECK-SAME: <8 x half> [[ARG0:%.*]], i64 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x half> @llvm.x86.avx512fp16.vcvtsi642sh(<8 x half> [[ARG0]], i64 [[ARG1]], i32 4)
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSCMP3:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR4:%.*]] = or i1 [[_MSCMP2]], [[_MSCMP3]]
; CHECK-NEXT:    br i1 [[_MSOR4]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[RES2:%.*]] = call <8 x half> @llvm.x86.avx512fp16.vcvtsi642sh(<8 x half> [[ARG0]], i64 [[ARG1]], i32 8)
; CHECK-NEXT:    [[RES:%.*]] = fadd <8 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res1 = call <8 x half> @llvm.x86.avx512fp16.vcvtsi642sh(<8 x half> %arg0, i64 %arg1, i32 4)
  %res2 = call <8 x half> @llvm.x86.avx512fp16.vcvtsi642sh(<8 x half> %arg0, i64 %arg1, i32 8)
  %res = fadd <8 x half> %res1, %res2
  ret <8 x half> %res
}

declare <8 x half> @llvm.x86.avx512fp16.vcvtusi2sh(<8 x half>, i32, i32)

define <8 x half> @test_x86_avx512fp16_vcvtusi2sh(<8 x half> %arg0, i32 %arg1) #0 {
; CHECK-LABEL: define <8 x half> @test_x86_avx512fp16_vcvtusi2sh(
; CHECK-SAME: <8 x half> [[ARG0:%.*]], i32 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i32, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i32 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x half> @llvm.x86.avx512fp16.vcvtusi2sh(<8 x half> [[ARG0]], i32 [[ARG1]], i32 4)
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSCMP3:%.*]] = icmp ne i32 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR4:%.*]] = or i1 [[_MSCMP2]], [[_MSCMP3]]
; CHECK-NEXT:    br i1 [[_MSOR4]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[RES2:%.*]] = call <8 x half> @llvm.x86.avx512fp16.vcvtusi2sh(<8 x half> [[ARG0]], i32 [[ARG1]], i32 9)
; CHECK-NEXT:    [[RES:%.*]] = fadd <8 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res1 = call <8 x half> @llvm.x86.avx512fp16.vcvtusi2sh(<8 x half> %arg0, i32 %arg1, i32 4)
  %res2 = call <8 x half> @llvm.x86.avx512fp16.vcvtusi2sh(<8 x half> %arg0, i32 %arg1, i32 9)
  %res = fadd <8 x half> %res1, %res2
  ret <8 x half> %res
}

declare <8 x half> @llvm.x86.avx512fp16.vcvtusi642sh(<8 x half>, i64, i32)

define <8 x half> @test_x86_avx512fp16_vcvtusi642sh(<8 x half> %arg0, i64 %arg1) #0 {
; CHECK-LABEL: define <8 x half> @test_x86_avx512fp16_vcvtusi642sh(
; CHECK-SAME: <8 x half> [[ARG0:%.*]], i64 [[ARG1:%.*]]) #[[ATTR1]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <8 x i16>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[TMP3:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP:%.*]] = icmp ne i128 [[TMP3]], 0
; CHECK-NEXT:    [[_MSCMP1:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR:%.*]] = or i1 [[_MSCMP]], [[_MSCMP1]]
; CHECK-NEXT:    br i1 [[_MSOR]], label %[[BB4:.*]], label %[[BB5:.*]], !prof [[PROF1]]
; CHECK:       [[BB4]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB5]]:
; CHECK-NEXT:    [[RES1:%.*]] = call <8 x half> @llvm.x86.avx512fp16.vcvtusi642sh(<8 x half> [[ARG0]], i64 [[ARG1]], i32 4)
; CHECK-NEXT:    [[TMP6:%.*]] = bitcast <8 x i16> [[TMP1]] to i128
; CHECK-NEXT:    [[_MSCMP2:%.*]] = icmp ne i128 [[TMP6]], 0
; CHECK-NEXT:    [[_MSCMP3:%.*]] = icmp ne i64 [[TMP2]], 0
; CHECK-NEXT:    [[_MSOR4:%.*]] = or i1 [[_MSCMP2]], [[_MSCMP3]]
; CHECK-NEXT:    br i1 [[_MSOR4]], label %[[BB7:.*]], label %[[BB8:.*]], !prof [[PROF1]]
; CHECK:       [[BB7]]:
; CHECK-NEXT:    call void @__msan_warning_noreturn() #[[ATTR8]]
; CHECK-NEXT:    unreachable
; CHECK:       [[BB8]]:
; CHECK-NEXT:    [[RES2:%.*]] = call <8 x half> @llvm.x86.avx512fp16.vcvtusi642sh(<8 x half> [[ARG0]], i64 [[ARG1]], i32 9)
; CHECK-NEXT:    [[RES:%.*]] = fadd <8 x half> [[RES1]], [[RES2]]
; CHECK-NEXT:    store <8 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <8 x half> [[RES]]
;
  %res1 = call <8 x half> @llvm.x86.avx512fp16.vcvtusi642sh(<8 x half> %arg0, i64 %arg1, i32 4)
  %res2 = call <8 x half> @llvm.x86.avx512fp16.vcvtusi642sh(<8 x half> %arg0, i64 %arg1, i32 9)
  %res = fadd <8 x half> %res1, %res2
  ret <8 x half> %res
}


define <16 x half> @test_mm256_castph128_ph256_freeze(<8 x half> %a0) nounwind {
; CHECK-LABEL: define <16 x half> @test_mm256_castph128_ph256_freeze(
; CHECK-SAME: <8 x half> [[A0:%.*]]) #[[ATTR5:[0-9]+]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[A1:%.*]] = freeze <8 x half> poison
; CHECK-NEXT:    [[RES:%.*]] = shufflevector <8 x half> [[A0]], <8 x half> [[A1]], <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:    store <16 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <16 x half> [[RES]]
;
  %a1 = freeze <8 x half> poison
; The cold never bothered me anyway
  %res = shufflevector <8 x half> %a0, <8 x half> %a1, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x half> %res
}


define <32 x half> @test_mm512_castph128_ph512_freeze(<8 x half> %a0) nounwind {
; CHECK-LABEL: define <32 x half> @test_mm512_castph128_ph512_freeze(
; CHECK-SAME: <8 x half> [[A0:%.*]]) #[[ATTR5]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[A1:%.*]] = freeze <8 x half> poison
; CHECK-NEXT:    [[RES:%.*]] = shufflevector <8 x half> [[A0]], <8 x half> [[A1]], <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
; CHECK-NEXT:    store <32 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[RES]]
;
  %a1 = freeze <8 x half> poison
  %res = shufflevector <8 x half> %a0, <8 x half> %a1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <32 x half> %res
}


define <32 x half> @test_mm512_castph256_ph512_freeze(<16 x half> %a0) nounwind {
; CHECK-LABEL: define <32 x half> @test_mm512_castph256_ph512_freeze(
; CHECK-SAME: <16 x half> [[A0:%.*]]) #[[ATTR5]] {
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[A1:%.*]] = freeze <16 x half> poison
; CHECK-NEXT:    [[RES:%.*]] = shufflevector <16 x half> [[A0]], <16 x half> [[A1]], <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
; CHECK-NEXT:    store <32 x i16> zeroinitializer, ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <32 x half> [[RES]]
;
  %a1 = freeze <16 x half> poison
  %res = shufflevector <16 x half> %a0, <16 x half> %a1, <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15, i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x half> %res
}

attributes #0 = { sanitize_memory }
