; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -mtriple=aarch64-linux-gnu -passes=atomic-expand %s | FileCheck %s

define i8 @atomic8_load_unordered(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_load_unordered(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i8, ptr [[A:%.*]] unordered, align 1, !pcsections [[META0:![0-9]+]]
; CHECK-NEXT:    ret i8 [[TMP0]]
;
entry:
  %0 = load atomic i8, ptr %a unordered, align 1, !pcsections !0
  ret i8 %0
}

define i8 @atomic8_load_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_load_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i8, ptr [[A:%.*]] monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    ret i8 [[TMP0]]
;
entry:
  %0 = load atomic i8, ptr %a monotonic, align 1, !pcsections !0
  ret i8 %0
}

define i8 @atomic8_load_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_load_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i8, ptr [[A:%.*]] acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    ret i8 [[TMP0]]
;
entry:
  %0 = load atomic i8, ptr %a acquire, align 1, !pcsections !0
  ret i8 %0
}

define i8 @atomic8_load_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_load_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i8, ptr [[A:%.*]] seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    ret i8 [[TMP0]]
;
entry:
  %0 = load atomic i8, ptr %a seq_cst, align 1, !pcsections !0
  ret i8 %0
}

define void @atomic8_store_unordered(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_store_unordered(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i8 0, ptr [[A:%.*]] unordered, align 1, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i8 0, ptr %a unordered, align 1, !pcsections !0
  ret void
}

define void @atomic8_store_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_store_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i8 0, ptr [[A:%.*]] monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i8 0, ptr %a monotonic, align 1, !pcsections !0
  ret void
}

define void @atomic8_store_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_store_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i8 0, ptr [[A:%.*]] release, align 1, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i8 0, ptr %a release, align 1, !pcsections !0
  ret void
}

define void @atomic8_store_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_store_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i8 0, ptr [[A:%.*]] seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i8 0, ptr %a seq_cst, align 1, !pcsections !0
  ret void
}

define void @atomic8_xchg_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_xchg_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 0 monotonic monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i8 0 monotonic, !pcsections !0
  ret void
}

define void @atomic8_add_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_add_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] monotonic monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i8 0 monotonic, !pcsections !0
  ret void
}

define void @atomic8_sub_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_sub_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] monotonic monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i8 0 monotonic, !pcsections !0
  ret void
}

define void @atomic8_and_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_and_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 0 monotonic monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i8 0 monotonic, !pcsections !0
  ret void
}

define void @atomic8_or_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_or_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] monotonic monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i8 0 monotonic, !pcsections !0
  ret void
}

define void @atomic8_xor_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_xor_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] monotonic monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i8 0 monotonic, !pcsections !0
  ret void
}

define void @atomic8_nand_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_nand_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 -1 monotonic monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i8 0 monotonic, !pcsections !0
  ret void
}

define void @atomic8_xchg_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_xchg_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 0 acquire acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i8 0 acquire, !pcsections !0
  ret void
}

define void @atomic8_add_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_add_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] acquire acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i8 0 acquire, !pcsections !0
  ret void
}

define void @atomic8_sub_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_sub_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] acquire acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i8 0 acquire, !pcsections !0
  ret void
}

define void @atomic8_and_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_and_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 0 acquire acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i8 0 acquire, !pcsections !0
  ret void
}

define void @atomic8_or_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_or_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] acquire acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i8 0 acquire, !pcsections !0
  ret void
}

define void @atomic8_xor_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_xor_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] acquire acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i8 0 acquire, !pcsections !0
  ret void
}

define void @atomic8_nand_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_nand_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 -1 acquire acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i8 0 acquire, !pcsections !0
  ret void
}

define void @atomic8_xchg_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_xchg_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 0 release monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i8 0 release, !pcsections !0
  ret void
}

define void @atomic8_add_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_add_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] release monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i8 0 release, !pcsections !0
  ret void
}

define void @atomic8_sub_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_sub_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] release monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i8 0 release, !pcsections !0
  ret void
}

define void @atomic8_and_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_and_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 0 release monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i8 0 release, !pcsections !0
  ret void
}

define void @atomic8_or_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_or_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] release monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i8 0 release, !pcsections !0
  ret void
}

define void @atomic8_xor_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_xor_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] release monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i8 0 release, !pcsections !0
  ret void
}

define void @atomic8_nand_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_nand_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 -1 release monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i8 0 release, !pcsections !0
  ret void
}

define void @atomic8_xchg_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_xchg_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 0 acq_rel acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i8 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic8_add_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_add_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] acq_rel acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i8 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic8_sub_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_sub_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] acq_rel acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i8 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic8_and_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_and_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 0 acq_rel acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i8 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic8_or_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_or_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] acq_rel acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i8 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic8_xor_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_xor_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] acq_rel acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i8 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic8_nand_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_nand_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 -1 acq_rel acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i8 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic8_xchg_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_xchg_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 0 seq_cst seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i8 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic8_add_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_add_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] seq_cst seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i8 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic8_sub_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_sub_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] seq_cst seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i8 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic8_and_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_and_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 0 seq_cst seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i8 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic8_or_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_or_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] seq_cst seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i8 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic8_xor_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_xor_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 [[LOADED]] seq_cst seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i8 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic8_nand_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_nand_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i8, ptr [[A:%.*]], align 1, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i8 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 [[LOADED]], i8 -1 seq_cst seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i8, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i8, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i8 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic8_cas_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_cas_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i8 0, i8 1 monotonic monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 0, i8 1 monotonic acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i8 0, i8 1 monotonic seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i8 0, i8 1 monotonic monotonic, !pcsections !0
  cmpxchg ptr %a, i8 0, i8 1 monotonic acquire, !pcsections !0
  cmpxchg ptr %a, i8 0, i8 1 monotonic seq_cst, !pcsections !0
  ret void
}

define void @atomic8_cas_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_cas_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i8 0, i8 1 acquire monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 0, i8 1 acquire acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i8 0, i8 1 acquire seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i8 0, i8 1 acquire monotonic, !pcsections !0
  cmpxchg ptr %a, i8 0, i8 1 acquire acquire, !pcsections !0
  cmpxchg ptr %a, i8 0, i8 1 acquire seq_cst, !pcsections !0
  ret void
}

define void @atomic8_cas_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_cas_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i8 0, i8 1 release monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 0, i8 1 release acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i8 0, i8 1 release seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i8 0, i8 1 release monotonic, !pcsections !0
  cmpxchg ptr %a, i8 0, i8 1 release acquire, !pcsections !0
  cmpxchg ptr %a, i8 0, i8 1 release seq_cst, !pcsections !0
  ret void
}

define void @atomic8_cas_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_cas_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i8 0, i8 1 acq_rel monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 0, i8 1 acq_rel acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i8 0, i8 1 acq_rel seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i8 0, i8 1 acq_rel monotonic, !pcsections !0
  cmpxchg ptr %a, i8 0, i8 1 acq_rel acquire, !pcsections !0
  cmpxchg ptr %a, i8 0, i8 1 acq_rel seq_cst, !pcsections !0
  ret void
}

define void @atomic8_cas_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic8_cas_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i8 0, i8 1 seq_cst monotonic, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i8 0, i8 1 seq_cst acquire, align 1, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i8 0, i8 1 seq_cst seq_cst, align 1, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i8 0, i8 1 seq_cst monotonic, !pcsections !0
  cmpxchg ptr %a, i8 0, i8 1 seq_cst acquire, !pcsections !0
  cmpxchg ptr %a, i8 0, i8 1 seq_cst seq_cst, !pcsections !0
  ret void
}

define i16 @atomic16_load_unordered(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_load_unordered(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i16, ptr [[A:%.*]] unordered, align 2, !pcsections [[META0]]
; CHECK-NEXT:    ret i16 [[TMP0]]
;
entry:
  %0 = load atomic i16, ptr %a unordered, align 2, !pcsections !0
  ret i16 %0
}

define i16 @atomic16_load_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_load_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i16, ptr [[A:%.*]] monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    ret i16 [[TMP0]]
;
entry:
  %0 = load atomic i16, ptr %a monotonic, align 2, !pcsections !0
  ret i16 %0
}

define i16 @atomic16_load_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_load_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i16, ptr [[A:%.*]] acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    ret i16 [[TMP0]]
;
entry:
  %0 = load atomic i16, ptr %a acquire, align 2, !pcsections !0
  ret i16 %0
}

define i16 @atomic16_load_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_load_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i16, ptr [[A:%.*]] seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    ret i16 [[TMP0]]
;
entry:
  %0 = load atomic i16, ptr %a seq_cst, align 2, !pcsections !0
  ret i16 %0
}

define void @atomic16_store_unordered(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_store_unordered(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i16 0, ptr [[A:%.*]] unordered, align 2, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i16 0, ptr %a unordered, align 2, !pcsections !0
  ret void
}

define void @atomic16_store_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_store_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i16 0, ptr [[A:%.*]] monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i16 0, ptr %a monotonic, align 2, !pcsections !0
  ret void
}

define void @atomic16_store_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_store_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i16 0, ptr [[A:%.*]] release, align 2, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i16 0, ptr %a release, align 2, !pcsections !0
  ret void
}

define void @atomic16_store_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_store_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i16 0, ptr [[A:%.*]] seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i16 0, ptr %a seq_cst, align 2, !pcsections !0
  ret void
}

define void @atomic16_xchg_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_xchg_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 0 monotonic monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i16 0 monotonic, !pcsections !0
  ret void
}

define void @atomic16_add_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_add_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] monotonic monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i16 0 monotonic, !pcsections !0
  ret void
}

define void @atomic16_sub_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_sub_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] monotonic monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i16 0 monotonic, !pcsections !0
  ret void
}

define void @atomic16_and_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_and_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 0 monotonic monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i16 0 monotonic, !pcsections !0
  ret void
}

define void @atomic16_or_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_or_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] monotonic monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i16 0 monotonic, !pcsections !0
  ret void
}

define void @atomic16_xor_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_xor_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] monotonic monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i16 0 monotonic, !pcsections !0
  ret void
}

define void @atomic16_nand_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_nand_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 -1 monotonic monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i16 0 monotonic, !pcsections !0
  ret void
}

define void @atomic16_xchg_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_xchg_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 0 acquire acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i16 0 acquire, !pcsections !0
  ret void
}

define void @atomic16_add_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_add_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] acquire acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i16 0 acquire, !pcsections !0
  ret void
}

define void @atomic16_sub_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_sub_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] acquire acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i16 0 acquire, !pcsections !0
  ret void
}

define void @atomic16_and_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_and_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 0 acquire acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i16 0 acquire, !pcsections !0
  ret void
}

define void @atomic16_or_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_or_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] acquire acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i16 0 acquire, !pcsections !0
  ret void
}

define void @atomic16_xor_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_xor_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] acquire acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i16 0 acquire, !pcsections !0
  ret void
}

define void @atomic16_nand_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_nand_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 -1 acquire acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i16 0 acquire, !pcsections !0
  ret void
}

define void @atomic16_xchg_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_xchg_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 0 release monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i16 0 release, !pcsections !0
  ret void
}

define void @atomic16_add_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_add_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] release monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i16 0 release, !pcsections !0
  ret void
}

define void @atomic16_sub_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_sub_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] release monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i16 0 release, !pcsections !0
  ret void
}

define void @atomic16_and_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_and_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 0 release monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i16 0 release, !pcsections !0
  ret void
}

define void @atomic16_or_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_or_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] release monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i16 0 release, !pcsections !0
  ret void
}

define void @atomic16_xor_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_xor_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] release monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i16 0 release, !pcsections !0
  ret void
}

define void @atomic16_nand_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_nand_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 -1 release monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i16 0 release, !pcsections !0
  ret void
}

define void @atomic16_xchg_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_xchg_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 0 acq_rel acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i16 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic16_add_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_add_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] acq_rel acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i16 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic16_sub_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_sub_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] acq_rel acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i16 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic16_and_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_and_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 0 acq_rel acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i16 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic16_or_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_or_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] acq_rel acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i16 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic16_xor_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_xor_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] acq_rel acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i16 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic16_nand_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_nand_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 -1 acq_rel acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i16 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic16_xchg_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_xchg_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 0 seq_cst seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i16 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic16_add_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_add_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] seq_cst seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i16 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic16_sub_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_sub_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] seq_cst seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i16 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic16_and_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_and_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 0 seq_cst seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i16 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic16_or_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_or_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] seq_cst seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i16 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic16_xor_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_xor_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 [[LOADED]] seq_cst seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i16 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic16_nand_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_nand_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i16, ptr [[A:%.*]], align 2, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i16 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 [[LOADED]], i16 -1 seq_cst seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i16, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i16, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i16 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic16_cas_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_cas_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i16 0, i16 1 monotonic monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 0, i16 1 monotonic acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i16 0, i16 1 monotonic seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i16 0, i16 1 monotonic monotonic, !pcsections !0
  cmpxchg ptr %a, i16 0, i16 1 monotonic acquire, !pcsections !0
  cmpxchg ptr %a, i16 0, i16 1 monotonic seq_cst, !pcsections !0
  ret void
}

define void @atomic16_cas_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_cas_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i16 0, i16 1 acquire monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 0, i16 1 acquire acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i16 0, i16 1 acquire seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i16 0, i16 1 acquire monotonic, !pcsections !0
  cmpxchg ptr %a, i16 0, i16 1 acquire acquire, !pcsections !0
  cmpxchg ptr %a, i16 0, i16 1 acquire seq_cst, !pcsections !0
  ret void
}

define void @atomic16_cas_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_cas_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i16 0, i16 1 release monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 0, i16 1 release acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i16 0, i16 1 release seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i16 0, i16 1 release monotonic, !pcsections !0
  cmpxchg ptr %a, i16 0, i16 1 release acquire, !pcsections !0
  cmpxchg ptr %a, i16 0, i16 1 release seq_cst, !pcsections !0
  ret void
}

define void @atomic16_cas_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_cas_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i16 0, i16 1 acq_rel monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 0, i16 1 acq_rel acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i16 0, i16 1 acq_rel seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i16 0, i16 1 acq_rel monotonic, !pcsections !0
  cmpxchg ptr %a, i16 0, i16 1 acq_rel acquire, !pcsections !0
  cmpxchg ptr %a, i16 0, i16 1 acq_rel seq_cst, !pcsections !0
  ret void
}

define void @atomic16_cas_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic16_cas_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i16 0, i16 1 seq_cst monotonic, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i16 0, i16 1 seq_cst acquire, align 2, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i16 0, i16 1 seq_cst seq_cst, align 2, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i16 0, i16 1 seq_cst monotonic, !pcsections !0
  cmpxchg ptr %a, i16 0, i16 1 seq_cst acquire, !pcsections !0
  cmpxchg ptr %a, i16 0, i16 1 seq_cst seq_cst, !pcsections !0
  ret void
}

define i32 @atomic32_load_unordered(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_load_unordered(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i32, ptr [[A:%.*]] unordered, align 4, !pcsections [[META0]]
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %0 = load atomic i32, ptr %a unordered, align 4, !pcsections !0
  ret i32 %0
}

define i32 @atomic32_load_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_load_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i32, ptr [[A:%.*]] monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %0 = load atomic i32, ptr %a monotonic, align 4, !pcsections !0
  ret i32 %0
}

define i32 @atomic32_load_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_load_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i32, ptr [[A:%.*]] acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %0 = load atomic i32, ptr %a acquire, align 4, !pcsections !0
  ret i32 %0
}

define i32 @atomic32_load_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_load_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i32, ptr [[A:%.*]] seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    ret i32 [[TMP0]]
;
entry:
  %0 = load atomic i32, ptr %a seq_cst, align 4, !pcsections !0
  ret i32 %0
}

define void @atomic32_store_unordered(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_store_unordered(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i32 0, ptr [[A:%.*]] unordered, align 4, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i32 0, ptr %a unordered, align 4, !pcsections !0
  ret void
}

define void @atomic32_store_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_store_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i32 0, ptr [[A:%.*]] monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i32 0, ptr %a monotonic, align 4, !pcsections !0
  ret void
}

define void @atomic32_store_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_store_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i32 0, ptr [[A:%.*]] release, align 4, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i32 0, ptr %a release, align 4, !pcsections !0
  ret void
}

define void @atomic32_store_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_store_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i32 0, ptr [[A:%.*]] seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i32 0, ptr %a seq_cst, align 4, !pcsections !0
  ret void
}

define void @atomic32_xchg_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_xchg_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 0 monotonic monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i32 0 monotonic, !pcsections !0
  ret void
}

define void @atomic32_add_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_add_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] monotonic monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i32 0 monotonic, !pcsections !0
  ret void
}

define void @atomic32_sub_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_sub_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] monotonic monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i32 0 monotonic, !pcsections !0
  ret void
}

define void @atomic32_and_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_and_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 0 monotonic monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i32 0 monotonic, !pcsections !0
  ret void
}

define void @atomic32_or_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_or_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] monotonic monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i32 0 monotonic, !pcsections !0
  ret void
}

define void @atomic32_xor_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_xor_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] monotonic monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i32 0 monotonic, !pcsections !0
  ret void
}

define void @atomic32_nand_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_nand_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 -1 monotonic monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i32 0 monotonic, !pcsections !0
  ret void
}

define void @atomic32_xchg_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_xchg_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 0 acquire acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i32 0 acquire, !pcsections !0
  ret void
}

define void @atomic32_add_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_add_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] acquire acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i32 0 acquire, !pcsections !0
  ret void
}

define void @atomic32_sub_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_sub_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] acquire acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i32 0 acquire, !pcsections !0
  ret void
}

define void @atomic32_and_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_and_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 0 acquire acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i32 0 acquire, !pcsections !0
  ret void
}

define void @atomic32_or_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_or_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] acquire acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i32 0 acquire, !pcsections !0
  ret void
}

define void @atomic32_xor_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_xor_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] acquire acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i32 0 acquire, !pcsections !0
  ret void
}

define void @atomic32_nand_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_nand_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 -1 acquire acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i32 0 acquire, !pcsections !0
  ret void
}

define void @atomic32_xchg_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_xchg_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 0 release monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i32 0 release, !pcsections !0
  ret void
}

define void @atomic32_add_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_add_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] release monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i32 0 release, !pcsections !0
  ret void
}

define void @atomic32_sub_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_sub_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] release monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i32 0 release, !pcsections !0
  ret void
}

define void @atomic32_and_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_and_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 0 release monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i32 0 release, !pcsections !0
  ret void
}

define void @atomic32_or_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_or_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] release monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i32 0 release, !pcsections !0
  ret void
}

define void @atomic32_xor_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_xor_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] release monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i32 0 release, !pcsections !0
  ret void
}

define void @atomic32_nand_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_nand_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 -1 release monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i32 0 release, !pcsections !0
  ret void
}

define void @atomic32_xchg_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_xchg_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 0 acq_rel acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i32 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic32_add_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_add_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] acq_rel acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i32 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic32_sub_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_sub_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] acq_rel acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i32 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic32_and_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_and_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 0 acq_rel acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i32 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic32_or_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_or_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] acq_rel acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i32 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic32_xor_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_xor_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] acq_rel acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i32 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic32_nand_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_nand_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 -1 acq_rel acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i32 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic32_xchg_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_xchg_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 0 seq_cst seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i32 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic32_add_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_add_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] seq_cst seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i32 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic32_sub_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_sub_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] seq_cst seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i32 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic32_and_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_and_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 0 seq_cst seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i32 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic32_or_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_or_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] seq_cst seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i32 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic32_xor_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_xor_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 [[LOADED]] seq_cst seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i32 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic32_nand_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_nand_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i32, ptr [[A:%.*]], align 4, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i32 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 [[LOADED]], i32 -1 seq_cst seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i32, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i32, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i32 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic32_cas_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_cas_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i32 0, i32 1 monotonic monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 0, i32 1 monotonic acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i32 0, i32 1 monotonic seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i32 0, i32 1 monotonic monotonic, !pcsections !0
  cmpxchg ptr %a, i32 0, i32 1 monotonic acquire, !pcsections !0
  cmpxchg ptr %a, i32 0, i32 1 monotonic seq_cst, !pcsections !0
  ret void
}

define void @atomic32_cas_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_cas_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i32 0, i32 1 acquire monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 0, i32 1 acquire acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i32 0, i32 1 acquire seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i32 0, i32 1 acquire monotonic, !pcsections !0
  cmpxchg ptr %a, i32 0, i32 1 acquire acquire, !pcsections !0
  cmpxchg ptr %a, i32 0, i32 1 acquire seq_cst, !pcsections !0
  ret void
}

define void @atomic32_cas_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_cas_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i32 0, i32 1 release monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 0, i32 1 release acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i32 0, i32 1 release seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i32 0, i32 1 release monotonic, !pcsections !0
  cmpxchg ptr %a, i32 0, i32 1 release acquire, !pcsections !0
  cmpxchg ptr %a, i32 0, i32 1 release seq_cst, !pcsections !0
  ret void
}

define void @atomic32_cas_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_cas_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i32 0, i32 1 acq_rel monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 0, i32 1 acq_rel acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i32 0, i32 1 acq_rel seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i32 0, i32 1 acq_rel monotonic, !pcsections !0
  cmpxchg ptr %a, i32 0, i32 1 acq_rel acquire, !pcsections !0
  cmpxchg ptr %a, i32 0, i32 1 acq_rel seq_cst, !pcsections !0
  ret void
}

define void @atomic32_cas_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic32_cas_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i32 0, i32 1 seq_cst monotonic, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i32 0, i32 1 seq_cst acquire, align 4, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i32 0, i32 1 seq_cst seq_cst, align 4, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i32 0, i32 1 seq_cst monotonic, !pcsections !0
  cmpxchg ptr %a, i32 0, i32 1 seq_cst acquire, !pcsections !0
  cmpxchg ptr %a, i32 0, i32 1 seq_cst seq_cst, !pcsections !0
  ret void
}

define i64 @atomic64_load_unordered(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_load_unordered(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i64, ptr [[A:%.*]] unordered, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret i64 [[TMP0]]
;
entry:
  %0 = load atomic i64, ptr %a unordered, align 8, !pcsections !0
  ret i64 %0
}

define i64 @atomic64_load_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_load_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i64, ptr [[A:%.*]] monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret i64 [[TMP0]]
;
entry:
  %0 = load atomic i64, ptr %a monotonic, align 8, !pcsections !0
  ret i64 %0
}

define i64 @atomic64_load_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_load_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i64, ptr [[A:%.*]] acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret i64 [[TMP0]]
;
entry:
  %0 = load atomic i64, ptr %a acquire, align 8, !pcsections !0
  ret i64 %0
}

define i64 @atomic64_load_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_load_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic i64, ptr [[A:%.*]] seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret i64 [[TMP0]]
;
entry:
  %0 = load atomic i64, ptr %a seq_cst, align 8, !pcsections !0
  ret i64 %0
}

define ptr @atomic64_load_seq_cst_ptr_ty(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_load_seq_cst_ptr_ty(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load atomic ptr, ptr [[A:%.*]] seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret ptr [[TMP0]]
;
entry:
  %0 = load atomic ptr, ptr %a seq_cst, align 8, !pcsections !0
  ret ptr %0
}

define void @atomic64_store_unordered(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_store_unordered(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i64 0, ptr [[A:%.*]] unordered, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i64 0, ptr %a unordered, align 8, !pcsections !0
  ret void
}

define void @atomic64_store_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_store_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i64 0, ptr [[A:%.*]] monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i64 0, ptr %a monotonic, align 8, !pcsections !0
  ret void
}

define void @atomic64_store_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_store_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i64 0, ptr [[A:%.*]] release, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i64 0, ptr %a release, align 8, !pcsections !0
  ret void
}

define void @atomic64_store_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_store_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic i64 0, ptr [[A:%.*]] seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic i64 0, ptr %a seq_cst, align 8, !pcsections !0
  ret void
}

define void @atomic64_store_seq_cst_ptr_ty(ptr %a, ptr %v) nounwind uwtable {
; CHECK-LABEL: @atomic64_store_seq_cst_ptr_ty(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store atomic ptr [[V:%.*]], ptr [[A:%.*]] seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  store atomic ptr %v, ptr %a seq_cst, align 8, !pcsections !0
  ret void
}

define void @atomic64_xchg_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_xchg_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 0 monotonic monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i64 0 monotonic, !pcsections !0
  ret void
}

define void @atomic64_add_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_add_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] monotonic monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i64 0 monotonic, !pcsections !0
  ret void
}

define void @atomic64_sub_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_sub_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] monotonic monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i64 0 monotonic, !pcsections !0
  ret void
}

define void @atomic64_and_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_and_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 0 monotonic monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i64 0 monotonic, !pcsections !0
  ret void
}

define void @atomic64_or_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_or_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] monotonic monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i64 0 monotonic, !pcsections !0
  ret void
}

define void @atomic64_xor_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_xor_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] monotonic monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i64 0 monotonic, !pcsections !0
  ret void
}

define void @atomic64_nand_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_nand_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 -1 monotonic monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i64 0 monotonic, !pcsections !0
  ret void
}

define void @atomic64_xchg_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_xchg_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 0 acquire acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i64 0 acquire, !pcsections !0
  ret void
}

define void @atomic64_add_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_add_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] acquire acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i64 0 acquire, !pcsections !0
  ret void
}

define void @atomic64_sub_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_sub_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] acquire acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i64 0 acquire, !pcsections !0
  ret void
}

define void @atomic64_and_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_and_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 0 acquire acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i64 0 acquire, !pcsections !0
  ret void
}

define void @atomic64_or_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_or_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] acquire acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i64 0 acquire, !pcsections !0
  ret void
}

define void @atomic64_xor_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_xor_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] acquire acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i64 0 acquire, !pcsections !0
  ret void
}

define void @atomic64_nand_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_nand_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 -1 acquire acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i64 0 acquire, !pcsections !0
  ret void
}

define void @atomic64_xchg_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_xchg_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 0 release monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i64 0 release, !pcsections !0
  ret void
}

define void @atomic64_add_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_add_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] release monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i64 0 release, !pcsections !0
  ret void
}

define void @atomic64_sub_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_sub_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] release monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i64 0 release, !pcsections !0
  ret void
}

define void @atomic64_and_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_and_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 0 release monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i64 0 release, !pcsections !0
  ret void
}

define void @atomic64_or_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_or_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] release monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i64 0 release, !pcsections !0
  ret void
}

define void @atomic64_xor_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_xor_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] release monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i64 0 release, !pcsections !0
  ret void
}

define void @atomic64_nand_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_nand_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 -1 release monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i64 0 release, !pcsections !0
  ret void
}

define void @atomic64_xchg_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_xchg_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 0 acq_rel acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i64 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic64_add_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_add_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] acq_rel acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i64 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic64_sub_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_sub_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] acq_rel acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i64 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic64_and_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_and_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 0 acq_rel acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i64 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic64_or_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_or_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] acq_rel acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i64 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic64_xor_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_xor_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] acq_rel acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i64 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic64_nand_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_nand_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 -1 acq_rel acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i64 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic64_xchg_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_xchg_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 0 seq_cst seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i64 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic64_add_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_add_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] seq_cst seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i64 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic64_sub_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_sub_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] seq_cst seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i64 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic64_and_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_and_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 0 seq_cst seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i64 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic64_or_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_or_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] seq_cst seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i64 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic64_xor_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_xor_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 [[LOADED]] seq_cst seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i64 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic64_nand_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_nand_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr [[A:%.*]], align 8, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i64 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 [[LOADED]], i64 -1 seq_cst seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i64, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i64, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i64 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic64_cas_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_cas_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i64 0, i64 1 monotonic monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 0, i64 1 monotonic acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i64 0, i64 1 monotonic seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i64 0, i64 1 monotonic monotonic, !pcsections !0
  cmpxchg ptr %a, i64 0, i64 1 monotonic acquire, !pcsections !0
  cmpxchg ptr %a, i64 0, i64 1 monotonic seq_cst, !pcsections !0
  ret void
}

define void @atomic64_cas_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_cas_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i64 0, i64 1 acquire monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 0, i64 1 acquire acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i64 0, i64 1 acquire seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i64 0, i64 1 acquire monotonic, !pcsections !0
  cmpxchg ptr %a, i64 0, i64 1 acquire acquire, !pcsections !0
  cmpxchg ptr %a, i64 0, i64 1 acquire seq_cst, !pcsections !0
  ret void
}

define void @atomic64_cas_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_cas_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i64 0, i64 1 release monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 0, i64 1 release acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i64 0, i64 1 release seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i64 0, i64 1 release monotonic, !pcsections !0
  cmpxchg ptr %a, i64 0, i64 1 release acquire, !pcsections !0
  cmpxchg ptr %a, i64 0, i64 1 release seq_cst, !pcsections !0
  ret void
}

define void @atomic64_cas_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_cas_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i64 0, i64 1 acq_rel monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 0, i64 1 acq_rel acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i64 0, i64 1 acq_rel seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i64 0, i64 1 acq_rel monotonic, !pcsections !0
  cmpxchg ptr %a, i64 0, i64 1 acq_rel acquire, !pcsections !0
  cmpxchg ptr %a, i64 0, i64 1 acq_rel seq_cst, !pcsections !0
  ret void
}

define void @atomic64_cas_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic64_cas_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i64 0, i64 1 seq_cst monotonic, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i64 0, i64 1 seq_cst acquire, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A]], i64 0, i64 1 seq_cst seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i64 0, i64 1 seq_cst monotonic, !pcsections !0
  cmpxchg ptr %a, i64 0, i64 1 seq_cst acquire, !pcsections !0
  cmpxchg ptr %a, i64 0, i64 1 seq_cst seq_cst, !pcsections !0
  ret void
}

define void @atomic64_cas_seq_cst_ptr_ty(ptr %a, ptr %v1, ptr %v2) nounwind uwtable {
; CHECK-LABEL: @atomic64_cas_seq_cst_ptr_ty(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = ptrtoint ptr [[V1:%.*]] to i64, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = ptrtoint ptr [[V2:%.*]] to i64, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP2:%.*]] = cmpxchg ptr [[A:%.*]], i64 [[TMP0]], i64 [[TMP1]] seq_cst seq_cst, align 8, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP3:%.*]] = extractvalue { i64, i1 } [[TMP2]], 0, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP4:%.*]] = extractvalue { i64, i1 } [[TMP2]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP5:%.*]] = inttoptr i64 [[TMP3]] to ptr, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP6:%.*]] = insertvalue { ptr, i1 } poison, ptr [[TMP5]], 0, !pcsections [[META0]]
; CHECK-NEXT:    [[TMP7:%.*]] = insertvalue { ptr, i1 } [[TMP6]], i1 [[TMP4]], 1, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, ptr %v1, ptr %v2 seq_cst seq_cst, !pcsections !0
  ret void
}

define i128 @atomic128_load_unordered(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_load_unordered(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i128 0, i128 0 monotonic monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[LOADED:%.*]] = extractvalue { i128, i1 } [[TMP0]], 0, !pcsections [[META0]]
; CHECK-NEXT:    ret i128 [[LOADED]]
;
entry:
  %0 = load atomic i128, ptr %a unordered, align 16, !pcsections !0
  ret i128 %0
}

define i128 @atomic128_load_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_load_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i128 0, i128 0 monotonic monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[LOADED:%.*]] = extractvalue { i128, i1 } [[TMP0]], 0, !pcsections [[META0]]
; CHECK-NEXT:    ret i128 [[LOADED]]
;
entry:
  %0 = load atomic i128, ptr %a monotonic, align 16, !pcsections !0
  ret i128 %0
}

define i128 @atomic128_load_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_load_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i128 0, i128 0 acquire acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[LOADED:%.*]] = extractvalue { i128, i1 } [[TMP0]], 0, !pcsections [[META0]]
; CHECK-NEXT:    ret i128 [[LOADED]]
;
entry:
  %0 = load atomic i128, ptr %a acquire, align 16, !pcsections !0
  ret i128 %0
}

define i128 @atomic128_load_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_load_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i128 0, i128 0 seq_cst seq_cst, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[LOADED:%.*]] = extractvalue { i128, i1 } [[TMP0]], 0, !pcsections [[META0]]
; CHECK-NEXT:    ret i128 [[LOADED]]
;
entry:
  %0 = load atomic i128, ptr %a seq_cst, align 16, !pcsections !0
  ret i128 %0
}

define void @atomic128_store_unordered(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_store_unordered(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 monotonic monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  store atomic i128 0, ptr %a unordered, align 16, !pcsections !0
  ret void
}

define void @atomic128_store_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_store_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 monotonic monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  store atomic i128 0, ptr %a monotonic, align 16, !pcsections !0
  ret void
}

define void @atomic128_store_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_store_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 release monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  store atomic i128 0, ptr %a release, align 16, !pcsections !0
  ret void
}

define void @atomic128_store_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_store_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 seq_cst seq_cst, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  store atomic i128 0, ptr %a seq_cst, align 16, !pcsections !0
  ret void
}

define void @atomic128_xchg_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_xchg_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 monotonic monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i128 0 monotonic, !pcsections !0
  ret void
}

define void @atomic128_add_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_add_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] monotonic monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i128 0 monotonic, !pcsections !0
  ret void
}

define void @atomic128_sub_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_sub_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] monotonic monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i128 0 monotonic, !pcsections !0
  ret void
}

define void @atomic128_and_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_and_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 monotonic monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i128 0 monotonic, !pcsections !0
  ret void
}

define void @atomic128_or_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_or_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] monotonic monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i128 0 monotonic, !pcsections !0
  ret void
}

define void @atomic128_xor_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_xor_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] monotonic monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i128 0 monotonic, !pcsections !0
  ret void
}

define void @atomic128_nand_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_nand_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 -1 monotonic monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i128 0 monotonic, !pcsections !0
  ret void
}

define void @atomic128_xchg_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_xchg_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 acquire acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i128 0 acquire, !pcsections !0
  ret void
}

define void @atomic128_add_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_add_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] acquire acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i128 0 acquire, !pcsections !0
  ret void
}

define void @atomic128_sub_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_sub_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] acquire acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i128 0 acquire, !pcsections !0
  ret void
}

define void @atomic128_and_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_and_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 acquire acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i128 0 acquire, !pcsections !0
  ret void
}

define void @atomic128_or_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_or_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] acquire acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i128 0 acquire, !pcsections !0
  ret void
}

define void @atomic128_xor_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_xor_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] acquire acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i128 0 acquire, !pcsections !0
  ret void
}

define void @atomic128_nand_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_nand_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 -1 acquire acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i128 0 acquire, !pcsections !0
  ret void
}

define void @atomic128_xchg_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_xchg_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 release monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i128 0 release, !pcsections !0
  ret void
}

define void @atomic128_add_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_add_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] release monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i128 0 release, !pcsections !0
  ret void
}

define void @atomic128_sub_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_sub_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] release monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i128 0 release, !pcsections !0
  ret void
}

define void @atomic128_and_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_and_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 release monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i128 0 release, !pcsections !0
  ret void
}

define void @atomic128_or_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_or_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] release monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i128 0 release, !pcsections !0
  ret void
}

define void @atomic128_xor_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_xor_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] release monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i128 0 release, !pcsections !0
  ret void
}

define void @atomic128_nand_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_nand_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 -1 release monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i128 0 release, !pcsections !0
  ret void
}

define void @atomic128_xchg_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_xchg_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 acq_rel acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i128 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic128_add_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_add_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] acq_rel acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i128 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic128_sub_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_sub_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] acq_rel acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i128 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic128_and_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_and_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 acq_rel acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i128 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic128_or_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_or_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] acq_rel acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i128 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic128_xor_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_xor_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] acq_rel acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i128 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic128_nand_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_nand_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 -1 acq_rel acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i128 0 acq_rel, !pcsections !0
  ret void
}

define void @atomic128_xchg_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_xchg_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 seq_cst seq_cst, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xchg ptr %a, i128 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic128_add_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_add_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] seq_cst seq_cst, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw add ptr %a, i128 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic128_sub_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_sub_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] seq_cst seq_cst, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw sub ptr %a, i128 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic128_and_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_and_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 0 seq_cst seq_cst, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw and ptr %a, i128 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic128_or_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_or_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] seq_cst seq_cst, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw or ptr %a, i128 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic128_xor_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_xor_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 [[LOADED]] seq_cst seq_cst, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw xor ptr %a, i128 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic128_nand_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_nand_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = load i128, ptr [[A:%.*]], align 16, !pcsections [[META0]]
; CHECK-NEXT:    br label [[ATOMICRMW_START:%.*]], !pcsections [[META0]]
; CHECK:       atomicrmw.start:
; CHECK-NEXT:    [[LOADED:%.*]] = phi i128 [ [[TMP0]], [[ENTRY:%.*]] ], [ [[NEWLOADED:%.*]], [[ATOMICRMW_START]] ], !pcsections [[META0]]
; CHECK-NEXT:    [[TMP1:%.*]] = cmpxchg ptr [[A]], i128 [[LOADED]], i128 -1 seq_cst seq_cst, align 16, !pcsections [[META0]]
; CHECK-NEXT:    [[SUCCESS:%.*]] = extractvalue { i128, i1 } [[TMP1]], 1, !pcsections [[META0]]
; CHECK-NEXT:    [[NEWLOADED]] = extractvalue { i128, i1 } [[TMP1]], 0, !pcsections [[META0]]
; CHECK-NEXT:    br i1 [[SUCCESS]], label [[ATOMICRMW_END:%.*]], label [[ATOMICRMW_START]], !pcsections [[META0]]
; CHECK:       atomicrmw.end:
; CHECK-NEXT:    ret void
;
entry:
  atomicrmw nand ptr %a, i128 0 seq_cst, !pcsections !0
  ret void
}

define void @atomic128_cas_monotonic(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_cas_monotonic(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i128 0, i128 1 monotonic monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i128 0, i128 1 monotonic monotonic, !pcsections !0
  ret void
}

define void @atomic128_cas_acquire(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_cas_acquire(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i128 0, i128 1 acquire acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i128 0, i128 1 acquire acquire, !pcsections !0
  ret void
}

define void @atomic128_cas_release(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_cas_release(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i128 0, i128 1 release monotonic, align 16, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i128 0, i128 1 release monotonic, !pcsections !0
  ret void
}

define void @atomic128_cas_acq_rel(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_cas_acq_rel(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i128 0, i128 1 acq_rel acquire, align 16, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i128 0, i128 1 acq_rel acquire, !pcsections !0
  ret void
}

define void @atomic128_cas_seq_cst(ptr %a) nounwind uwtable {
; CHECK-LABEL: @atomic128_cas_seq_cst(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = cmpxchg ptr [[A:%.*]], i128 0, i128 1 seq_cst seq_cst, align 16, !pcsections [[META0]]
; CHECK-NEXT:    ret void
;
entry:
  cmpxchg ptr %a, i128 0, i128 1 seq_cst seq_cst, !pcsections !0
  ret void
}

!0 = !{!"foo"}
