; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-attributes --check-globals
; RUN: opt -aa-pipeline=basic-aa -passes=attributor -attributor-manifest-internal  -attributor-annotate-decl-cs  -S < %s | FileCheck %s --check-prefixes=CHECK,TUNIT
; RUN: opt -aa-pipeline=basic-aa -passes=attributor-cgscc -attributor-manifest-internal  -attributor-annotate-decl-cs -S < %s | FileCheck %s --check-prefixes=CHECK,CGSCC

;; This function returns its second argument on all return statements
define internal ptr @incdec(i1 %C, ptr %V) {
; TUNIT: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: write)
; TUNIT-LABEL: define {{[^@]+}}@incdec
; TUNIT-SAME: (i1 noundef [[C:%.*]], ptr noalias nofree noundef nonnull returned writeonly align 4 dereferenceable(4) "no-capture-maybe-returned" [[V:%.*]]) #[[ATTR0:[0-9]+]] {
; TUNIT-NEXT:    br i1 [[C]], label [[T:%.*]], label [[F:%.*]]
; TUNIT:       T:
; TUNIT-NEXT:    ret ptr [[V]]
; TUNIT:       F:
; TUNIT-NEXT:    ret ptr [[V]]
;
; CGSCC: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: readwrite)
; CGSCC-LABEL: define {{[^@]+}}@incdec
; CGSCC-SAME: (i1 noundef [[C:%.*]], ptr nofree noundef nonnull returned align 4 dereferenceable(4) "no-capture-maybe-returned" [[V:%.*]]) #[[ATTR0:[0-9]+]] {
; CGSCC-NEXT:    [[X:%.*]] = load i32, ptr [[V]], align 4
; CGSCC-NEXT:    br i1 [[C]], label [[T:%.*]], label [[F:%.*]]
; CGSCC:       T:
; CGSCC-NEXT:    [[X1:%.*]] = add i32 [[X]], 1
; CGSCC-NEXT:    store i32 [[X1]], ptr [[V]], align 4
; CGSCC-NEXT:    ret ptr [[V]]
; CGSCC:       F:
; CGSCC-NEXT:    [[X2:%.*]] = sub i32 [[X]], 1
; CGSCC-NEXT:    store i32 [[X2]], ptr [[V]], align 4
; CGSCC-NEXT:    ret ptr [[V]]
;
  %X = load i32, ptr %V
  br i1 %C, label %T, label %F

T:              ; preds = %0
  %X1 = add i32 %X, 1
  store i32 %X1, ptr %V
  ret ptr %V

F:              ; preds = %0
  %X2 = sub i32 %X, 1
  store i32 %X2, ptr %V
  ret ptr %V
}

;; This function returns its first argument as a part of a multiple return
;; value
define internal { i32, i32 } @foo(i32 %A, i32 %B) {
; CGSCC: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@foo
; CGSCC-SAME: (i32 noundef [[A:%.*]], i32 noundef [[B:%.*]]) #[[ATTR1:[0-9]+]] {
; CGSCC-NEXT:    [[X:%.*]] = add i32 [[A]], [[B]]
; CGSCC-NEXT:    [[Y:%.*]] = insertvalue { i32, i32 } undef, i32 [[A]], 0
; CGSCC-NEXT:    [[Z:%.*]] = insertvalue { i32, i32 } [[Y]], i32 [[X]], 1
; CGSCC-NEXT:    ret { i32, i32 } [[Z]]
;
  %X = add i32 %A, %B
  %Y = insertvalue { i32, i32 } undef, i32 %A, 0
  %Z = insertvalue { i32, i32 } %Y, i32 %X, 1
  ret { i32, i32 } %Z
}

define void @caller(i1 %C) personality ptr @__gxx_personality_v0 {
; TUNIT: Function Attrs: mustprogress nofree norecurse nosync nounwind willreturn memory(none)
; TUNIT-LABEL: define {{[^@]+}}@caller
; TUNIT-SAME: (i1 [[C:%.*]]) #[[ATTR1:[0-9]+]] personality ptr @__gxx_personality_v0 {
; TUNIT-NEXT:    [[Q:%.*]] = alloca i32, align 4
; TUNIT-NEXT:    [[W:%.*]] = call align 4 ptr @incdec(i1 noundef [[C]], ptr noalias nofree noundef nonnull writeonly align 4 dereferenceable(4) "no-capture-maybe-returned" [[Q]]) #[[ATTR2:[0-9]+]]
; TUNIT-NEXT:    br label [[OK:%.*]]
; TUNIT:       OK:
; TUNIT-NEXT:    br label [[RET:%.*]]
; TUNIT:       LPAD:
; TUNIT-NEXT:    unreachable
; TUNIT:       RET:
; TUNIT-NEXT:    ret void
;
; CGSCC: Function Attrs: mustprogress nofree nosync nounwind willreturn memory(none)
; CGSCC-LABEL: define {{[^@]+}}@caller
; CGSCC-SAME: (i1 noundef [[C:%.*]]) #[[ATTR2:[0-9]+]] personality ptr @__gxx_personality_v0 {
; CGSCC-NEXT:    [[Q:%.*]] = alloca i32, align 4
; CGSCC-NEXT:    [[W:%.*]] = call align 4 ptr @incdec(i1 noundef [[C]], ptr noalias nofree noundef nonnull align 4 dereferenceable(4) [[Q]]) #[[ATTR3:[0-9]+]]
; CGSCC-NEXT:    [[S1:%.*]] = call { i32, i32 } @foo(i32 noundef 1, i32 noundef 2) #[[ATTR4:[0-9]+]]
; CGSCC-NEXT:    [[X1:%.*]] = extractvalue { i32, i32 } [[S1]], 0
; CGSCC-NEXT:    [[S2:%.*]] = call { i32, i32 } @foo(i32 noundef 3, i32 noundef 4) #[[ATTR5:[0-9]+]]
; CGSCC-NEXT:    br label [[OK:%.*]]
; CGSCC:       OK:
; CGSCC-NEXT:    [[X2:%.*]] = extractvalue { i32, i32 } [[S2]], 0
; CGSCC-NEXT:    [[Z:%.*]] = add i32 [[X1]], [[X2]]
; CGSCC-NEXT:    store i32 [[Z]], ptr [[W]], align 4
; CGSCC-NEXT:    br label [[RET:%.*]]
; CGSCC:       LPAD:
; CGSCC-NEXT:    unreachable
; CGSCC:       RET:
; CGSCC-NEXT:    ret void
;
  %Q = alloca i32
  ;; Call incdec to see if %W is properly replaced by %Q
  %W = call ptr @incdec(i1 %C, ptr %Q )             ; <i32> [#uses=1]
  ;; Call @foo twice, to prevent the arguments from propagating into the
  ;; function (so we can check the returned argument is properly
  ;; propagated per-caller).
  %S1 = call { i32, i32 } @foo(i32 1, i32 2)
  %X1 = extractvalue { i32, i32 } %S1, 0
  %S2 = invoke { i32, i32 } @foo(i32 3, i32 4) to label %OK unwind label %LPAD

OK:
  %X2 = extractvalue { i32, i32 } %S2, 0
  %Z  = add i32 %X1, %X2
  store i32 %Z, ptr %W
  br label %RET

LPAD:
  %exn = landingpad {ptr, i32}
  cleanup
  br label %RET

RET:
  ret void
}

declare i32 @__gxx_personality_v0(...)
;.
; TUNIT: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: write) }
; TUNIT: attributes #[[ATTR1]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; TUNIT: attributes #[[ATTR2]] = { nofree nosync nounwind willreturn memory(write) }
;.
; CGSCC: attributes #[[ATTR0]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(argmem: readwrite) }
; CGSCC: attributes #[[ATTR1]] = { mustprogress nofree norecurse nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR2]] = { mustprogress nofree nosync nounwind willreturn memory(none) }
; CGSCC: attributes #[[ATTR3]] = { nofree nounwind willreturn }
; CGSCC: attributes #[[ATTR4]] = { nofree nosync willreturn }
; CGSCC: attributes #[[ATTR5]] = { nofree nosync nounwind willreturn memory(none) }
;.
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; CHECK: {{.*}}
