; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S < %s -passes=dce  | FileCheck %s

declare i32 @llvm.mips.rddsp(i32)
declare <4 x i8> @llvm.mips.pick.qb(<4 x i8>, <4 x i8>)
declare <2 x i16> @llvm.mips.pick.ph(<2 x i16>, <2 x i16>)
declare i32 @llvm.mips.bposge32()
declare i32 @llvm.mips.lbux(ptr, i32)
declare i32 @llvm.mips.lhx(ptr, i32)
declare i32 @llvm.mips.lwx(ptr, i32)
declare <16 x i8> @llvm.mips.ld.b(ptr, i32)
declare <8 x i16> @llvm.mips.ld.h(ptr, i32)
declare <4 x i32> @llvm.mips.ld.w(ptr, i32)
declare <2 x i64> @llvm.mips.ld.d(ptr, i32)
declare <2 x i64> @llvm.mips.ldr.d(ptr, i32)
declare <4 x i32> @llvm.mips.ldr.w(ptr, i32)

define void @test_mips_rddsp() {
; CHECK-LABEL: define void @test_mips_rddsp() {
; CHECK-NEXT:    ret void
;
  %v = call i32 @llvm.mips.rddsp(i32 4)
  ret void
}

define void @test_llvm_mips_pick_qb(<4 x i8> %a, <4 x i8> %b) {
; CHECK-LABEL: define void @test_llvm_mips_pick_qb(
; CHECK-SAME: <4 x i8> [[A:%.*]], <4 x i8> [[B:%.*]]) {
; CHECK-NEXT:    ret void
;
  %v = call <4 x i8> @llvm.mips.pick.qb(<4 x i8> %a, <4 x i8> %b)
  ret void
}

define void @test_llvm_mips_pick_ph(<2 x i16> %a, <2 x i16> %b) {
; CHECK-LABEL: define void @test_llvm_mips_pick_ph(
; CHECK-SAME: <2 x i16> [[A:%.*]], <2 x i16> [[B:%.*]]) {
; CHECK-NEXT:    ret void
;
  %v = call <2 x i16> @llvm.mips.pick.ph(<2 x i16> %a, <2 x i16> %b)
  ret void
}

define void @test_llvm_mips_bposge32() {
; CHECK-LABEL: define void @test_llvm_mips_bposge32() {
; CHECK-NEXT:    ret void
;
  %v = call i32 @llvm.mips.bposge32()
  ret void
}

define void @test_llvm_mips_lbux(ptr %a, i32 %b) {
; CHECK-LABEL: define void @test_llvm_mips_lbux(
; CHECK-SAME: ptr [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    ret void
;
  %v = call i32 @llvm.mips.lbux(ptr %a, i32 %b)
  ret void
}

define void @test_llvm_mips_lhx(ptr %a, i32 %b) {
; CHECK-LABEL: define void @test_llvm_mips_lhx(
; CHECK-SAME: ptr [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    ret void
;
  %v = call i32 @llvm.mips.lhx(ptr %a, i32 %b)
  ret void
}

define void @test_llvm_mips_lwx(ptr %a, i32 %b) {
; CHECK-LABEL: define void @test_llvm_mips_lwx(
; CHECK-SAME: ptr [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    ret void
;
  %v = call i32 @llvm.mips.lwx(ptr %a, i32 %b)
  ret void
}

define void @test_llvm_mips_ld_b(ptr %a, i32 %b) {
; CHECK-LABEL: define void @test_llvm_mips_ld_b(
; CHECK-SAME: ptr [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    ret void
;
  %v = call <16 x i8> @llvm.mips.ld.b(ptr %a, i32 %b)
  ret void
}

define void @test_llvm_mips_ld_h(ptr %a, i32 %b) {
; CHECK-LABEL: define void @test_llvm_mips_ld_h(
; CHECK-SAME: ptr [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    ret void
;
  %v = call <8 x i16> @llvm.mips.ld.h(ptr %a, i32 %b)
  ret void
}

define void @test_llvm_mips_ld_w(ptr %a, i32 %b) {
; CHECK-LABEL: define void @test_llvm_mips_ld_w(
; CHECK-SAME: ptr [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    ret void
;
  %v = call <4 x i32> @llvm.mips.ld.w(ptr %a, i32 %b)
  ret void
}

define void @test_llvm_mips_ld_d(ptr %a, i32 %b) {
; CHECK-LABEL: define void @test_llvm_mips_ld_d(
; CHECK-SAME: ptr [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    ret void
;
  %v = call <2 x i64> @llvm.mips.ld.d(ptr %a, i32 %b)
  ret void
}

define void @test_llvm_mips_ldr_d(ptr %a, i32 %b) {
; CHECK-LABEL: define void @test_llvm_mips_ldr_d(
; CHECK-SAME: ptr [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    ret void
;
  %v = call <2 x i64> @llvm.mips.ldr.d(ptr %a, i32 %b)
  ret void
}

define void @test_llvm_mips_ldr_w(ptr %a, i32 %b) {
; CHECK-LABEL: define void @test_llvm_mips_ldr_w(
; CHECK-SAME: ptr [[A:%.*]], i32 [[B:%.*]]) {
; CHECK-NEXT:    ret void
;
  %v = call <4 x i32> @llvm.mips.ldr.w(ptr %a, i32 %b)
  ret void
}
