; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=float2int -S | FileCheck %s -check-prefixes=CHECK,NONE
; RUN: opt < %s -passes=float2int -S --data-layout="n64" | FileCheck %s -check-prefixes=CHECK,ONLY64
; RUN: opt < %s -passes=float2int -S --data-layout="n8:16:32:64"| FileCheck %s -check-prefixes=CHECK,MULTIPLE
; RUN: opt < %s -passes=float2int -S --data-layout="e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-i128:128-f80:128-n8:16:32:64-S128"| FileCheck %s -check-prefixes=CHECK,PR-79158

define i32 @pr79158(i32 %x) {
; CHECK-LABEL: define i32 @pr79158(
; CHECK-SAME: i32 [[X:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X]], 0
; CHECK-NEXT:    [[TMP0:%.*]] = zext i1 [[CMP]] to i64
; CHECK-NEXT:    [[MUL1:%.*]] = mul i64 [[TMP0]], 4294967295
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i64 [[MUL1]] to i32
; CHECK-NEXT:    ret i32 [[TMP1]]
;
entry:
  %cmp = icmp sgt i32 %x, 0
  %conv = uitofp i1 %cmp to double
  %mul = fmul double %conv, 0x41EFFFFFFFE00000
  %conv1 = fptoui double %mul to i32
  ret i32 %conv1
}

define i32 @pr79158_2(i32 %x) {
; NONE-LABEL: define i32 @pr79158_2(
; NONE-SAME: i32 [[X:%.*]]) {
; NONE-NEXT:  entry:
; NONE-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X]], 0
; NONE-NEXT:    [[TMP0:%.*]] = zext i1 [[CMP]] to i32
; NONE-NEXT:    [[MUL1:%.*]] = mul i32 [[TMP0]], 255
; NONE-NEXT:    [[TMP1:%.*]] = trunc i32 [[MUL1]] to i8
; NONE-NEXT:    [[CONV2:%.*]] = zext i8 [[TMP1]] to i32
; NONE-NEXT:    ret i32 [[CONV2]]
;
; ONLY64-LABEL: define i32 @pr79158_2(
; ONLY64-SAME: i32 [[X:%.*]]) {
; ONLY64-NEXT:  entry:
; ONLY64-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X]], 0
; ONLY64-NEXT:    [[TMP0:%.*]] = zext i1 [[CMP]] to i64
; ONLY64-NEXT:    [[MUL1:%.*]] = mul i64 [[TMP0]], 255
; ONLY64-NEXT:    [[TMP1:%.*]] = trunc i64 [[MUL1]] to i8
; ONLY64-NEXT:    [[CONV2:%.*]] = zext i8 [[TMP1]] to i32
; ONLY64-NEXT:    ret i32 [[CONV2]]
;
; MULTIPLE-LABEL: define i32 @pr79158_2(
; MULTIPLE-SAME: i32 [[X:%.*]]) {
; MULTIPLE-NEXT:  entry:
; MULTIPLE-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X]], 0
; MULTIPLE-NEXT:    [[TMP0:%.*]] = zext i1 [[CMP]] to i16
; MULTIPLE-NEXT:    [[MUL1:%.*]] = mul i16 [[TMP0]], 255
; MULTIPLE-NEXT:    [[TMP1:%.*]] = trunc i16 [[MUL1]] to i8
; MULTIPLE-NEXT:    [[CONV2:%.*]] = zext i8 [[TMP1]] to i32
; MULTIPLE-NEXT:    ret i32 [[CONV2]]
;
; PR-79158-LABEL: define i32 @pr79158_2(
; PR-79158-SAME: i32 [[X:%.*]]) {
; PR-79158-NEXT:  entry:
; PR-79158-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[X]], 0
; PR-79158-NEXT:    [[TMP0:%.*]] = zext i1 [[CMP]] to i16
; PR-79158-NEXT:    [[MUL1:%.*]] = mul i16 [[TMP0]], 255
; PR-79158-NEXT:    [[TMP1:%.*]] = trunc i16 [[MUL1]] to i8
; PR-79158-NEXT:    [[CONV2:%.*]] = zext i8 [[TMP1]] to i32
; PR-79158-NEXT:    ret i32 [[CONV2]]
;
entry:
  %cmp = icmp sgt i32 %x, 0
  %conv = uitofp i1 %cmp to float
  %mul = fmul float %conv, 2.550000e+02
  %conv1 = fptoui float %mul to i8
  %conv2 = zext i8 %conv1 to i32
  ret i32 %conv2
}
