; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes='licm,guard-widening,licm' -verify-memoryssa -debug-pass-manager < %s 2>&1 | FileCheck %s

; Main point of this test is to check the scheduling -- there should be
; no analysis passes needed between LICM and LoopGuardWidening

; CHECK: LICMPass
; CHECK-NEXT: GuardWideningPass
; CHECK-NEXT: LICMPass

declare void @llvm.experimental.guard(i1,...)

define void @iter(i32 %a, i32 %b, ptr %c_p) {
; CHECK-LABEL: @iter(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B_GW_FR:%.*]] = freeze i32 [[B:%.*]]
; CHECK-NEXT:    [[COND_0:%.*]] = icmp ult i32 [[A:%.*]], 10
; CHECK-NEXT:    [[COND_1:%.*]] = icmp ult i32 [[B_GW_FR]], 10
; CHECK-NEXT:    [[WIDE_CHK:%.*]] = and i1 [[COND_0]], [[COND_1]]
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 [[WIDE_CHK]]) [ "deopt"() ]
; CHECK-NEXT:    [[CND:%.*]] = load i1, ptr [[C_P:%.*]], align 1
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    br i1 [[CND]], label [[LOOP]], label [[LEAVE_LOOPEXIT:%.*]]
; CHECK:       leave.loopexit:
; CHECK-NEXT:    br label [[LEAVE:%.*]]
; CHECK:       leave:
; CHECK-NEXT:    ret void
;

entry:
  %cond_0 = icmp ult i32 %a, 10
  call void (i1, ...) @llvm.experimental.guard(i1 %cond_0) [ "deopt"() ]
  br label %loop

loop:                                             ; preds = %loop.preheader, %loop
  %cond_1 = icmp ult i32 %b, 10
  call void (i1, ...) @llvm.experimental.guard(i1 %cond_1) [ "deopt"() ]
  %cnd = load i1, ptr %c_p
  br i1 %cnd, label %loop, label %leave.loopexit

leave.loopexit:                                   ; preds = %loop
  br label %leave

leave:                                            ; preds = %leave.loopexit, %entry
  ret void
}

define void @within_loop(i32 %a, i32 %b, ptr %c_p) {
; CHECK-LABEL: @within_loop(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[B_GW_FR:%.*]] = freeze i32 [[B:%.*]]
; CHECK-NEXT:    [[COND_0:%.*]] = icmp ult i32 [[A:%.*]], 10
; CHECK-NEXT:    [[COND_1:%.*]] = icmp ult i32 [[B_GW_FR]], 10
; CHECK-NEXT:    [[WIDE_CHK:%.*]] = and i1 [[COND_0]], [[COND_1]]
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 [[WIDE_CHK]]) [ "deopt"() ]
; CHECK-NEXT:    [[CND:%.*]] = load i1, ptr [[C_P:%.*]], align 1
; CHECK-NEXT:    br label [[LOOP:%.*]]
; CHECK:       loop:
; CHECK-NEXT:    br i1 [[CND]], label [[LOOP]], label [[LEAVE_LOOPEXIT:%.*]]
; CHECK:       leave.loopexit:
; CHECK-NEXT:    br label [[LEAVE:%.*]]
; CHECK:       leave:
; CHECK-NEXT:    ret void
;

entry:
  br label %loop

loop:                                             ; preds = %loop.preheader, %loop
  %cond_0 = icmp ult i32 %a, 10
  call void (i1, ...) @llvm.experimental.guard(i1 %cond_0) [ "deopt"() ]
  %cond_1 = icmp ult i32 %b, 10
  call void (i1, ...) @llvm.experimental.guard(i1 %cond_1) [ "deopt"() ]
  %cnd = load i1, ptr %c_p
  br i1 %cnd, label %loop, label %leave.loopexit

leave.loopexit:                                   ; preds = %loop
  br label %leave

leave:                                            ; preds = %leave.loopexit, %entry
  ret void
}

