; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=indvars -S < %s | FileCheck %s

declare void @use(i1)

declare void @llvm.experimental.guard(i1, ...)

define void @test_01(i8 %t) {
; CHECK-LABEL: define void @test_01(
; CHECK-SAME: i8 [[T:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[ST:%.*]] = sext i8 [[T]] to i16
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt i16 [[ST]], 42
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 [[CMP1]]) [ "deopt"() ]
; CHECK-NEXT:    br label %[[LOOP:.*]]
; CHECK:       [[LOOP]]:
; CHECK-NEXT:    [[IDX:%.*]] = phi i8 [ [[T]], %[[ENTRY]] ], [ [[IDX_INC:%.*]], %[[LOOP]] ]
; CHECK-NEXT:    [[IDX_INC]] = add nsw i8 [[IDX]], 1
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[BE:%.*]] = icmp slt i8 [[IDX_INC]], 42
; CHECK-NEXT:    br i1 [[BE]], label %[[LOOP]], label %[[EXIT:.*]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret void
;
  entry:
  %st = sext i8 %t to i16
  %cmp1 = icmp slt i16 %st, 42
  call void(i1, ...) @llvm.experimental.guard(i1 %cmp1) [ "deopt"() ]
  br label %loop

  loop:
  %idx = phi i8 [ %t, %entry ], [ %idx.inc, %loop ]
  %idx.inc = add i8 %idx, 1
  %c = icmp slt i8 %idx, 42
  call void @use(i1 %c)
  %be = icmp slt i8 %idx.inc, 42
  br i1 %be, label %loop, label %exit

  exit:
  ret void
}

define void @test_02(i8 %t) {
; CHECK-LABEL: define void @test_02(
; CHECK-SAME: i8 [[T:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    [[T_PTR:%.*]] = inttoptr i8 [[T]] to ptr
; CHECK-NEXT:    [[P_42:%.*]] = inttoptr i8 42 to ptr
; CHECK-NEXT:    [[CMP1:%.*]] = icmp slt ptr [[T_PTR]], [[P_42]]
; CHECK-NEXT:    call void (i1, ...) @llvm.experimental.guard(i1 [[CMP1]]) [ "deopt"() ]
; CHECK-NEXT:    br label %[[LOOP:.*]]
; CHECK:       [[LOOP]]:
; CHECK-NEXT:    [[IDX:%.*]] = phi ptr [ [[T_PTR]], %[[ENTRY]] ], [ [[SNEXT:%.*]], %[[LOOP]] ]
; CHECK-NEXT:    [[SNEXT]] = getelementptr inbounds i8, ptr [[IDX]], i64 1
; CHECK-NEXT:    call void @use(i1 true)
; CHECK-NEXT:    [[BE:%.*]] = icmp samesign ult ptr [[SNEXT]], [[P_42]]
; CHECK-NEXT:    br i1 [[BE]], label %[[LOOP]], label %[[EXIT:.*]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret void
;
  entry:
  %t.ptr = inttoptr i8 %t to ptr
  %p.42 = inttoptr i8 42 to ptr
  %cmp1 = icmp slt ptr %t.ptr, %p.42
  call void(i1, ...) @llvm.experimental.guard(i1 %cmp1) [ "deopt"() ]
  br label %loop

  loop:
  %idx = phi ptr [ %t.ptr, %entry ], [ %snext, %loop ]
  %snext = getelementptr inbounds i8, ptr %idx, i64 1
  %c = icmp slt ptr %idx, %p.42
  call void @use(i1 %c)
  %be = icmp slt ptr %snext, %p.42
  br i1 %be, label %loop, label %exit

  exit:
  ret void
}
