; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i8 @and_sub(i8 %a) {
; CHECK-LABEL: @and_sub(
; CHECK-NEXT:    [[RET:%.*]] = and i8 [[A:%.*]], 12
; CHECK-NEXT:    ret i8 [[RET]]
;
  %and1 = and i8 %a, 15
  %and2 = and i8 %a, 3

  %ret = sub i8 %and1, %and2
  ret i8 %ret
}

declare void @use(i8)
define i8 @and_sub_multi_use(i8 %a) {
; CHECK-LABEL: @and_sub_multi_use(
; CHECK-NEXT:    [[AND1:%.*]] = and i8 [[A:%.*]], 15
; CHECK-NEXT:    call void @use(i8 [[AND1]])
; CHECK-NEXT:    [[AND2:%.*]] = and i8 [[A]], 3
; CHECK-NEXT:    call void @use(i8 [[AND2]])
; CHECK-NEXT:    [[RET:%.*]] = and i8 [[A]], 12
; CHECK-NEXT:    ret i8 [[RET]]
;
  %and1 = and i8 %a, 15
  call void @use(i8 %and1)
  %and2 = and i8 %a, 3
  call void @use(i8 %and2)
  %ret = sub i8 %and1, %and2
  ret i8 %ret
}

define <2 x i32> @and_sub_vec(<2 x i32> %a) {
; CHECK-LABEL: @and_sub_vec(
; CHECK-NEXT:    [[RET:%.*]] = and <2 x i32> [[A:%.*]], <i32 3, i32 8>
; CHECK-NEXT:    ret <2 x i32> [[RET]]
;
  %and1 = and <2 x i32> %a, <i32 11, i32 10>
  %and2 = and <2 x i32> %a, <i32 8, i32 2>

  %ret = sub <2 x i32> %and1, %and2
  ret <2 x i32> %ret
}

define <2 x i32> @and_sub_vec_posion(<2 x i32> %a) {
; CHECK-LABEL: @and_sub_vec_posion(
; CHECK-NEXT:    ret <2 x i32> poison
;
  %and1 = and <2 x i32> %a, <i32 11, i32 poison>
  %and2 = and <2 x i32> %a, <i32 poison, i32 2>

  %ret = sub <2 x i32> %and1, %and2
  ret <2 x i32> %ret
}

define <2 x i32> @and_sub_vec_undef(<2 x i32> %a) {
; CHECK-LABEL: @and_sub_vec_undef(
; CHECK-NEXT:    [[AND1:%.*]] = and <2 x i32> [[A:%.*]], <i32 11, i32 undef>
; CHECK-NEXT:    [[AND2:%.*]] = and <2 x i32> [[A]], <i32 undef, i32 2>
; CHECK-NEXT:    [[RET:%.*]] = sub <2 x i32> [[AND1]], [[AND2]]
; CHECK-NEXT:    ret <2 x i32> [[RET]]
;
  %and1 = and <2 x i32> %a, <i32 11, i32 undef>
  %and2 = and <2 x i32> %a, <i32 undef, i32 2>

  %ret = sub <2 x i32> %and1, %and2
  ret <2 x i32> %ret
}

define i8 @and_sub_negtive(i8 %a) {
; CHECK-LABEL: @and_sub_negtive(
; CHECK-NEXT:    [[AND1:%.*]] = and i8 [[A:%.*]], 10
; CHECK-NEXT:    [[AND2:%.*]] = and i8 [[A]], 9
; CHECK-NEXT:    [[RET:%.*]] = sub nsw i8 [[AND1]], [[AND2]]
; CHECK-NEXT:    ret i8 [[RET]]
;
  %and1 = and i8 %a, 10
  %and2 = and i8 %a, 9

  %ret = sub i8 %and1, %and2
  ret i8 %ret
}
