; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @use.i8(i8)
declare void @use.i1(i1)
define i1 @src_tv_eq(i1 %c0, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_tv_eq(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i8 [[X:%.*]], 0
; CHECK-NEXT:    [[R:%.*]] = and i1 [[TMP1]], [[C0:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %y = add nuw i8 %yy, 1
  %sel = select i1 %c0, i8 0, i8 %y
  %selx = or i8 %sel, %x
  %r = icmp eq i8 %selx, 0
  ret i1 %r
}

define i1 @src_tv_eq_multiuse_or_fail(i1 %c0, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_tv_eq_multiuse_or_fail(
; CHECK-NEXT:    [[Y:%.*]] = add nuw i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[C0:%.*]], i8 0, i8 [[Y]]
; CHECK-NEXT:    [[SELX:%.*]] = or i8 [[SEL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[SELX]], 0
; CHECK-NEXT:    call void @use.i8(i8 [[SELX]])
; CHECK-NEXT:    ret i1 [[R]]
;
  %y = add nuw i8 %yy, 1
  %sel = select i1 %c0, i8 0, i8 %y
  %selx = or i8 %sel, %x
  %r = icmp eq i8 %selx, 0
  call void @use.i8(i8 %selx)
  ret i1 %r
}

define i1 @src_tv_eq_fail_tv_nonzero(i1 %c0, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_tv_eq_fail_tv_nonzero(
; CHECK-NEXT:    [[Y:%.*]] = add nsw i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[C0:%.*]], i8 1, i8 [[Y]]
; CHECK-NEXT:    [[SELX:%.*]] = or i8 [[SEL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[SELX]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %y = add nsw i8 %yy, 1
  %sel = select i1 %c0, i8 1, i8 %y
  %selx = or i8 %sel, %x
  %r = icmp eq i8 %selx, 0
  ret i1 %r
}

define i1 @src_fv_ne(i1 %c0, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_fv_ne(
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i8 [[X:%.*]], 0
; CHECK-NEXT:    [[R:%.*]] = or i1 [[TMP1]], [[C0:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %y = add nuw i8 %yy, 1
  %sel = select i1 %c0, i8 %y, i8 0
  %selx = or i8 %sel, %x
  %r = icmp ne i8 %selx, 0
  ret i1 %r
}

define i1 @src_fv_ne_fail_maybe_zero(i1 %c0, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_fv_ne_fail_maybe_zero(
; CHECK-NEXT:    [[Y:%.*]] = add nsw i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[C0:%.*]], i8 [[Y]], i8 0
; CHECK-NEXT:    [[SELX:%.*]] = or i8 [[SEL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[SELX]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %y = add nsw i8 %yy, 1
  %sel = select i1 %c0, i8 %y, i8 0
  %selx = or i8 %sel, %x
  %r = icmp ne i8 %selx, 0
  ret i1 %r
}

define i1 @src_tv_ne(i1 %c0, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_tv_ne(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i1 [[C0:%.*]], true
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ne i8 [[X:%.*]], 0
; CHECK-NEXT:    [[R:%.*]] = or i1 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %y = add nuw i8 %yy, 1
  %sel = select i1 %c0, i8 0, i8 %y
  %selx = or i8 %sel, %x
  %r = icmp ne i8 %selx, 0
  ret i1 %r
}

define i1 @src_tv_ne_fail_cmp_nonzero(i1 %c0, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_tv_ne_fail_cmp_nonzero(
; CHECK-NEXT:    [[Y:%.*]] = add nuw i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[C0:%.*]], i8 0, i8 [[Y]]
; CHECK-NEXT:    [[SELX:%.*]] = or i8 [[SEL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[SELX]], 1
; CHECK-NEXT:    ret i1 [[R]]
;
  %y = add nuw i8 %yy, 1
  %sel = select i1 %c0, i8 0, i8 %y
  %selx = or i8 %sel, %x
  %r = icmp ne i8 %selx, 1
  ret i1 %r
}

define i1 @src_fv_eq(i1 %c0, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_fv_eq(
; CHECK-NEXT:    [[TMP1:%.*]] = xor i1 [[C0:%.*]], true
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[X:%.*]], 0
; CHECK-NEXT:    [[R:%.*]] = and i1 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %y = add nuw i8 %yy, 1
  %sel = select i1 %c0, i8 %y, i8 0
  %selx = or i8 %sel, %x
  %r = icmp eq i8 %selx, 0
  ret i1 %r
}

define i1 @src_fv_eq_fail_cant_invert(i1 %c0, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_fv_eq_fail_cant_invert(
; CHECK-NEXT:    [[Y:%.*]] = add nuw i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[C0:%.*]], i8 [[Y]], i8 0
; CHECK-NEXT:    [[SELX:%.*]] = or i8 [[SEL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[SELX]], 0
; CHECK-NEXT:    call void @use.i8(i8 [[SEL]])
; CHECK-NEXT:    ret i1 [[R]]
;
  %y = add nuw i8 %yy, 1
  %sel = select i1 %c0, i8 %y, i8 0
  %selx = or i8 %sel, %x
  %r = icmp eq i8 %selx, 0
  call void @use.i8(i8 %sel)
  ret i1 %r
}

define i1 @src_fv_eq_fail_cant_invert2(i1 %c1, i8 %a, i8 %b, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_fv_eq_fail_cant_invert2(
; CHECK-NEXT:    [[C0:%.*]] = icmp ugt i8 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = add nuw i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[C0]], i8 [[Y]], i8 0
; CHECK-NEXT:    [[CC:%.*]] = or i1 [[C0]], [[C1:%.*]]
; CHECK-NEXT:    [[SEL_OTHER:%.*]] = select i1 [[CC]], i8 [[Y]], i8 [[B]]
; CHECK-NEXT:    [[SELX:%.*]] = or i8 [[SEL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[SELX]], 0
; CHECK-NEXT:    call void @use.i8(i8 [[SEL]])
; CHECK-NEXT:    call void @use.i8(i8 [[SEL_OTHER]])
; CHECK-NEXT:    ret i1 [[R]]
;
  %c0 = icmp ugt i8 %a, %b
  %y = add nuw i8 %yy, 1
  %sel = select i1 %c0, i8 %y, i8 0
  %cc = or i1 %c0, %c1
  %sel_other = select i1 %cc, i8 %y, i8 %b

  %selx = or i8 %sel, %x
  %r = icmp eq i8 %selx, 0
  call void @use.i8(i8 %sel)
  call void @use.i8(i8 %sel_other)
  ret i1 %r
}

define i1 @src_fv_eq_invert2(i1 %c1, i8 %a, i8 %b, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_fv_eq_invert2(
; CHECK-NEXT:    [[C0:%.*]] = icmp ugt i8 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = add nuw i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[CC:%.*]] = or i1 [[C0]], [[C1:%.*]]
; CHECK-NEXT:    [[SEL_OTHER:%.*]] = select i1 [[CC]], i8 [[Y]], i8 [[B]]
; CHECK-NEXT:    [[TMP1:%.*]] = xor i1 [[C0]], true
; CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i8 [[X:%.*]], 0
; CHECK-NEXT:    [[R:%.*]] = and i1 [[TMP2]], [[TMP1]]
; CHECK-NEXT:    call void @use.i8(i8 [[SEL_OTHER]])
; CHECK-NEXT:    ret i1 [[R]]
;
  %c0 = icmp ugt i8 %a, %b
  %y = add nuw i8 %yy, 1
  %sel = select i1 %c0, i8 %y, i8 0
  %cc = or i1 %c0, %c1
  %sel_other = select i1 %cc, i8 %y, i8 %b

  %selx = or i8 %sel, %x
  %r = icmp eq i8 %selx, 0
  call void @use.i8(i8 %sel_other)
  ret i1 %r
}




define i1 @src_fv_eq_invert2_fail_wrong_binop(i1 %c1, i8 %a, i8 %b, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_fv_eq_invert2_fail_wrong_binop(
; CHECK-NEXT:    [[C0:%.*]] = icmp ugt i8 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = add nuw i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[C0]], i8 [[Y]], i8 0
; CHECK-NEXT:    [[CC:%.*]] = or i1 [[C0]], [[C1:%.*]]
; CHECK-NEXT:    [[SEL_OTHER:%.*]] = select i1 [[CC]], i8 [[Y]], i8 [[B]]
; CHECK-NEXT:    [[SELX:%.*]] = sub i8 0, [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[SEL]], [[SELX]]
; CHECK-NEXT:    call void @use.i8(i8 [[SEL_OTHER]])
; CHECK-NEXT:    ret i1 [[R]]
;
  %c0 = icmp ugt i8 %a, %b
  %y = add nuw i8 %yy, 1
  %sel = select i1 %c0, i8 %y, i8 0
  %cc = or i1 %c0, %c1
  %sel_other = select i1 %cc, i8 %y, i8 %b

  %selx = add i8 %sel, %x
  %r = icmp eq i8 %selx, 0
  call void @use.i8(i8 %sel_other)
  ret i1 %r
}

define i1 @src_fv_eq_invert2_fail_bad_sel(i1 %c1, i8 %a, i8 %b, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_fv_eq_invert2_fail_bad_sel(
; CHECK-NEXT:    [[C0:%.*]] = icmp ugt i8 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = add nuw i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[C0]], i8 [[YY]], i8 0
; CHECK-NEXT:    [[CC:%.*]] = or i1 [[C0]], [[C1:%.*]]
; CHECK-NEXT:    [[SEL_OTHER:%.*]] = select i1 [[CC]], i8 [[Y]], i8 [[B]]
; CHECK-NEXT:    [[SELX:%.*]] = or i8 [[SEL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[SELX]], 0
; CHECK-NEXT:    call void @use.i8(i8 [[SEL_OTHER]])
; CHECK-NEXT:    call void @use.i8(i8 [[YY]])
; CHECK-NEXT:    ret i1 [[R]]
;
  %c0 = icmp ugt i8 %a, %b
  %y = add nuw i8 %yy, 1
  %sel = select i1 %c0, i8 %yy, i8 0
  %cc = or i1 %c0, %c1
  %sel_other = select i1 %cc, i8 %y, i8 %b

  %selx = or i8 %sel, %x
  %r = icmp eq i8 %selx, 0
  call void @use.i8(i8 %sel_other)
  call void @use.i8(i8 %yy)
  ret i1 %r
}

define i1 @src_fv_eq_invert3(i8 %a, i8 %b, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_fv_eq_invert3(
; CHECK-NEXT:    [[C0:%.*]] = icmp ugt i8 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    [[Y:%.*]] = add nuw i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[C0]], i8 [[Y]], i8 0
; CHECK-NEXT:    [[SEL_OTHER:%.*]] = select i1 [[C0]], i8 [[Y]], i8 [[B]]
; CHECK-NEXT:    [[SELX:%.*]] = or i8 [[SEL]], [[X:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[SELX]], 0
; CHECK-NEXT:    call void @use.i8(i8 [[SEL_OTHER]])
; CHECK-NEXT:    call void @use.i8(i8 [[SEL]])
; CHECK-NEXT:    ret i1 [[R]]
;
  %c0 = icmp ugt i8 %a, %b
  %y = add nuw i8 %yy, 1
  %sel = select i1 %c0, i8 %y, i8 0
  %sel_other = select i1 %c0, i8 %y, i8 %b

  %selx = or i8 %sel, %x
  %r = icmp eq i8 %selx, 0
  call void @use.i8(i8 %sel_other)
  call void @use.i8(i8 %sel)
  ret i1 %r
}


define i1 @src_tv_ne_invert(i1 %c1, i8 %a, i8 %b, i8 %x, i8 %yy) {
; CHECK-LABEL: @src_tv_ne_invert(
; CHECK-NEXT:    [[NOT_C0:%.*]] = icmp ugt i8 [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    call void @use.i1(i1 [[NOT_C0]])
; CHECK-NEXT:    [[C0:%.*]] = xor i1 [[NOT_C0]], true
; CHECK-NEXT:    [[Y:%.*]] = add nuw i8 [[YY:%.*]], 1
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[NOT_C0]], i8 [[Y]], i8 0
; CHECK-NEXT:    [[CC:%.*]] = or i1 [[C1:%.*]], [[C0]]
; CHECK-NEXT:    [[SEL_OTHER:%.*]] = select i1 [[CC]], i8 [[Y]], i8 [[B]]
; CHECK-NEXT:    [[TMP1:%.*]] = icmp ne i8 [[X:%.*]], 0
; CHECK-NEXT:    [[R:%.*]] = or i1 [[TMP1]], [[NOT_C0]]
; CHECK-NEXT:    call void @use.i8(i8 [[SEL]])
; CHECK-NEXT:    call void @use.i8(i8 [[SEL_OTHER]])
; CHECK-NEXT:    ret i1 [[R]]
;
  %not_c0 = icmp ugt i8 %a, %b
  call void @use.i1(i1 %not_c0)
  %c0 = xor i1 %not_c0, true
  %y = add nuw i8 %yy, 1
  %sel = select i1 %c0, i8 0, i8 %y
  %cc = or i1 %c0, %c1
  %sel_other = select i1 %cc, i8 %y, i8 %b

  %selx = or i8 %sel, %x
  %r = icmp ne i8 %selx, 0
  call void @use.i8(i8 %sel)
  call void @use.i8(i8 %sel_other)
  ret i1 %r
}

; Make sure we don't crash on this case.

define <4 x i1> @pr119063(<4 x i32> %x, i1 %cond) {
; CHECK-LABEL: @pr119063(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[COND:%.*]], <4 x i32> splat (i32 1), <4 x i32> zeroinitializer
; CHECK-NEXT:    [[OR:%.*]] = or <4 x i32> [[SEL]], [[X:%.*]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp ne <4 x i32> [[OR]], zeroinitializer
; CHECK-NEXT:    ret <4 x i1> [[CMP]]
;
entry:
  %sel = select i1 %cond, <4 x i32> splat (i32 1), <4 x i32> zeroinitializer
  %or = or <4 x i32> %sel, %x
  %cmp = icmp ne <4 x i32> %or, zeroinitializer
  ret <4 x i1> %cmp
}
