; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes=instsimplify -S | FileCheck %s

define i32 @ilogbf_const1() {
; CHECK-LABEL: define i32 @ilogbf_const1() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogbf(float 7.000000e+00)
; CHECK-NEXT:    ret i32 2
;
  %r = call i32 @ilogbf(float 7.000000e+00)
  ret i32 %r
}

define i32 @ilogb_const1() {
; CHECK-LABEL: define i32 @ilogb_const1() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogb(double -7.000000e+00)
; CHECK-NEXT:    ret i32 2
;
  %r = call i32 @ilogb(double -7.000000e+00)
  ret i32 %r
}

define i32 @ilogbf_const2() {
; CHECK-LABEL: define i32 @ilogbf_const2() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogbf(float 5.000000e-01)
; CHECK-NEXT:    ret i32 -1
;
  %r = call i32 @ilogbf(float 5.000000e-01)
  ret i32 %r
}

define i32 @ilogb_const2() {
; CHECK-LABEL: define i32 @ilogb_const2() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogb(double -5.000000e-01)
; CHECK-NEXT:    ret i32 -1
;
  %r = call i32 @ilogb(double -5.000000e-01)
  ret i32 %r
}

define i32 @ilogbf_zero() {
; CHECK-LABEL: define i32 @ilogbf_zero() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogbf(float 0.000000e+00)
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogbf(float 0.000000e+00)
  ret i32 %r
}

define i32 @ilogb_zero() {
; CHECK-LABEL: define i32 @ilogb_zero() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogb(double 0.000000e+00)
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogb(double 0.000000e+00)
  ret i32 %r
}

define i32 @ilogbf_neg_zero() {
; CHECK-LABEL: define i32 @ilogbf_neg_zero() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogbf(float -0.000000e+00)
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogbf(float -0.000000e+00)
  ret i32 %r
}

define i32 @ilogb_neg_zero() {
; CHECK-LABEL: define i32 @ilogb_neg_zero() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogb(double -0.000000e+00)
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogb(double -0.000000e+00)
  ret i32 %r
}

define i32 @ilogbf_inf() {
; CHECK-LABEL: define i32 @ilogbf_inf() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogbf(float 0x7FF0000000000000)
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogbf(float 0x7FF0000000000000)
  ret i32 %r
}

define i32 @ilogb_inf() {
; CHECK-LABEL: define i32 @ilogb_inf() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogb(double 0x7FF0000000000000)
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogb(double 0x7FF0000000000000)
  ret i32 %r
}

define i32 @ilogbf_nan() {
; CHECK-LABEL: define i32 @ilogbf_nan() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogbf(float 0x7FF8000000000000)
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogbf(float 0x7FF8000000000000)
  ret i32 %r
}

define i32 @ilogb_nan() {
; CHECK-LABEL: define i32 @ilogb_nan() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogb(double 0x7FF8000000000000)
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogb(double 0x7FF8000000000000)
  ret i32 %r
}

define i32 @ilogbf_zero_readnone() {
; CHECK-LABEL: define i32 @ilogbf_zero_readnone() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogbf(float 0.000000e+00) #[[ATTR1:[0-9]+]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogbf(float 0.000000e+00) readnone
  ret i32 %r
}

define i32 @ilogb_zero_readnone() {
; CHECK-LABEL: define i32 @ilogb_zero_readnone() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogb(double 0.000000e+00) #[[ATTR1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogb(double 0.000000e+00) readnone
  ret i32 %r
}

define i32 @ilogbf_neg_zero_readnone() {
; CHECK-LABEL: define i32 @ilogbf_neg_zero_readnone() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogbf(float -0.000000e+00) #[[ATTR1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogbf(float -0.000000e+00) readnone
  ret i32 %r
}

define i32 @ilogb_neg_zero_readnone() {
; CHECK-LABEL: define i32 @ilogb_neg_zero_readnone() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogb(double -0.000000e+00) #[[ATTR1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogb(double -0.000000e+00) readnone
  ret i32 %r
}

define i32 @ilogbf_inf_readnone() {
; CHECK-LABEL: define i32 @ilogbf_inf_readnone() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogbf(float 0x7FF0000000000000) #[[ATTR1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogbf(float 0x7FF0000000000000) readnone
  ret i32 %r
}

define i32 @ilogb_inf_readnone() {
; CHECK-LABEL: define i32 @ilogb_inf_readnone() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogb(double 0x7FF0000000000000) #[[ATTR1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogb(double 0x7FF0000000000000) readnone
  ret i32 %r
}

define i32 @ilogbf_nan_readnone() {
; CHECK-LABEL: define i32 @ilogbf_nan_readnone() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogbf(float 0x7FF8000000000000) #[[ATTR1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogbf(float 0x7FF8000000000000) readnone
  ret i32 %r
}

define i32 @ilogb_nan_readnone() {
; CHECK-LABEL: define i32 @ilogb_nan_readnone() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogb(double 0x7FF8000000000000) #[[ATTR1]]
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogb(double 0x7FF8000000000000) readnone
  ret i32 %r
}

define i32 @ilogbf_poison() {
; CHECK-LABEL: define i32 @ilogbf_poison() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogbf(float poison)
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogbf(float poison)
  ret i32 %r
}

define i32 @ilogb_poison() {
; CHECK-LABEL: define i32 @ilogb_poison() {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogb(double poison)
; CHECK-NEXT:    ret i32 [[R]]
;
  %r = call i32 @ilogb(double poison)
  ret i32 %r
}

define i32 @ilogb_const1_1() strictfp {
; CHECK-LABEL: define i32 @ilogb_const1_1(
; CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[R:%.*]] = call i32 @ilogb(double -7.000000e+00)
; CHECK-NEXT:    ret i32 2
;
  %r = call i32 @ilogb(double -7.000000e+00)
  ret i32 %r
}

declare i32 @ilogbf(float)
declare i32 @ilogb(double)
