; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p loop-unroll -unroll-full-max-count=0 -S %s | FileCheck %s

declare void @foo(i32)
declare i1 @cond()

define i64 @loop_with_3_exits(i64 %n) {
; CHECK-LABEL: define i64 @loop_with_3_exits(
; CHECK-SAME: i64 [[N:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[LOOP_HEADER:.*]]
; CHECK:       [[LOOP_HEADER]]:
; CHECK-NEXT:    [[IV:%.*]] = phi i64 [ 0, %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; CHECK-NEXT:    br i1 false, label %[[LOOP_LATCH]], label %[[THEN:.*]]
; CHECK:       [[THEN]]:
; CHECK-NEXT:    [[C:%.*]] = icmp eq i64 [[IV]], [[N]]
; CHECK-NEXT:    br i1 [[C]], label %[[EXIT_0:.*]], label %[[THEN_2:.*]]
; CHECK:       [[THEN_2]]:
; CHECK-NEXT:    call void @foo(i32 0)
; CHECK-NEXT:    br label %[[LOOP_LATCH]]
; CHECK:       [[LOOP_LATCH]]:
; CHECK-NEXT:    [[IV_NEXT]] = add i64 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i64 [[IV]], 63
; CHECK-NEXT:    br i1 [[EC]], label %[[EXIT_1:.*]], label %[[LOOP_HEADER]]
; CHECK:       [[EXIT_0]]:
; CHECK-NEXT:    [[IV_LCSSA:%.*]] = phi i64 [ [[IV]], %[[THEN]] ]
; CHECK-NEXT:    ret i64 [[IV_LCSSA]]
; CHECK:       [[EXIT_1]]:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i64 [ [[IV_NEXT]], %[[LOOP_LATCH]] ]
; CHECK-NEXT:    ret i64 [[IV_NEXT_LCSSA]]
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ]
  br i1 false, label %loop.latch, label %then

then:
  %c = icmp eq i64 %iv, %n
  br i1 %c, label %exit.0, label %then.2

then.2:
  call void @foo(i32 0)
  br label %loop.latch

loop.latch:
  %iv.next = add i64 %iv, 1
  %ec = icmp eq i64 %iv, 63
  br i1 %ec, label %exit.1, label %loop.header

exit.0:
  ret i64 %iv

exit.1:
  ret i64 %iv.next
}

define void @peel_last_multi_exit_btc_computable_no_exit_values(i32 %n) {
; CHECK-LABEL: define void @peel_last_multi_exit_btc_computable_no_exit_values(
; CHECK-SAME: i32 [[N:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[LOOP_HEADER:.*]]
; CHECK:       [[LOOP_HEADER]]:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ 0, %[[ENTRY]] ], [ [[IV_NEXT_PEEL:%.*]], %[[LOOP_LATCH:.*]] ]
; CHECK-NEXT:    [[EC_0_PEEL:%.*]] = icmp eq i32 [[IV_NEXT_LCSSA]], [[N]]
; CHECK-NEXT:    br i1 [[EC_0_PEEL]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; CHECK:       [[LOOP_LATCH]]:
; CHECK-NEXT:    [[C_PEEL:%.*]] = icmp eq i32 [[IV_NEXT_LCSSA]], 16
; CHECK-NEXT:    [[COND_PEEL:%.*]] = select i1 [[C_PEEL]], i32 10, i32 20
; CHECK-NEXT:    call void @foo(i32 [[COND_PEEL]])
; CHECK-NEXT:    [[IV_NEXT_PEEL]] = add i32 [[IV_NEXT_LCSSA]], 1
; CHECK-NEXT:    [[EC_PEEL:%.*]] = icmp eq i32 [[IV_NEXT_PEEL]], 17
; CHECK-NEXT:    br i1 [[EC_PEEL]], label %[[EXIT]], label %[[LOOP_HEADER]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %ec.0 = icmp eq i32 %iv, %n
  br i1 %ec.0, label %exit, label %loop.latch

loop.latch:
  %c = icmp eq i32 %iv, 16
  %cond = select i1 %c, i32 10, i32 20
  call void @foo(i32 %cond)
  %iv.next = add i32 %iv, 1
  %ec = icmp eq i32 %iv.next, 17
  br i1 %ec, label %exit, label %loop.header

exit:
  ret void
}

define i32 @peel_last_multi_exit_btc_computable_exit_constant_values(i32 %n) {
; CHECK-LABEL: define i32 @peel_last_multi_exit_btc_computable_exit_constant_values(
; CHECK-SAME: i32 [[N:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[LOOP_HEADER:.*]]
; CHECK:       [[LOOP_HEADER]]:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ 0, %[[ENTRY]] ], [ [[IV_NEXT_PEEL:%.*]], %[[LOOP_LATCH:.*]] ]
; CHECK-NEXT:    [[EC_0_PEEL:%.*]] = icmp eq i32 [[IV_NEXT_LCSSA]], [[N]]
; CHECK-NEXT:    br i1 [[EC_0_PEEL]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; CHECK:       [[LOOP_LATCH]]:
; CHECK-NEXT:    [[C_PEEL:%.*]] = icmp eq i32 [[IV_NEXT_LCSSA]], 16
; CHECK-NEXT:    [[COND_PEEL:%.*]] = select i1 [[C_PEEL]], i32 10, i32 20
; CHECK-NEXT:    call void @foo(i32 [[COND_PEEL]])
; CHECK-NEXT:    [[IV_NEXT_PEEL]] = add i32 [[IV_NEXT_LCSSA]], 1
; CHECK-NEXT:    [[EC_PEEL:%.*]] = icmp eq i32 [[IV_NEXT_PEEL]], 17
; CHECK-NEXT:    br i1 [[EC_PEEL]], label %[[EXIT]], label %[[LOOP_HEADER]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RES:%.*]] = phi i32 [ 1, %[[LOOP_HEADER]] ], [ 2, %[[LOOP_LATCH]] ]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %ec.0 = icmp eq i32 %iv, %n
  br i1 %ec.0, label %exit, label %loop.latch

loop.latch:
  %c = icmp eq i32 %iv, 16
  %cond = select i1 %c, i32 10, i32 20
  call void @foo(i32 %cond)
  %iv.next = add i32 %iv, 1
  %ec = icmp eq i32 %iv.next, 17
  br i1 %ec, label %exit, label %loop.header

exit:
  %res = phi i32 [ 1, %loop.header ], [ 2, %loop.latch ]
  ret i32 %res
}

define i32 @peel_last_multi_exit_btc_computable_exit_values_from_loop(i32 %n) {
; CHECK-LABEL: define i32 @peel_last_multi_exit_btc_computable_exit_values_from_loop(
; CHECK-SAME: i32 [[N:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[LOOP_HEADER:.*]]
; CHECK:       [[LOOP_HEADER]]:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i32 [ 0, %[[ENTRY]] ], [ [[IV_NEXT_PEEL:%.*]], %[[LOOP_LATCH:.*]] ]
; CHECK-NEXT:    [[EC_0_PEEL:%.*]] = icmp eq i32 [[IV_NEXT_LCSSA]], [[N]]
; CHECK-NEXT:    br i1 [[EC_0_PEEL]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; CHECK:       [[LOOP_LATCH]]:
; CHECK-NEXT:    [[C_PEEL:%.*]] = icmp eq i32 [[IV_NEXT_LCSSA]], 16
; CHECK-NEXT:    [[COND_PEEL:%.*]] = select i1 [[C_PEEL]], i32 10, i32 20
; CHECK-NEXT:    call void @foo(i32 [[COND_PEEL]])
; CHECK-NEXT:    [[IV_NEXT_PEEL]] = add i32 [[IV_NEXT_LCSSA]], 1
; CHECK-NEXT:    [[EC_PEEL:%.*]] = icmp eq i32 [[IV_NEXT_PEEL]], 17
; CHECK-NEXT:    br i1 [[EC_PEEL]], label %[[EXIT]], label %[[LOOP_HEADER]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RES:%.*]] = phi i32 [ [[IV_NEXT_LCSSA]], %[[LOOP_HEADER]] ], [ [[COND_PEEL]], %[[LOOP_LATCH]] ]
; CHECK-NEXT:    ret i32 [[RES]]
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %ec.0 = icmp eq i32 %iv, %n
  br i1 %ec.0, label %exit, label %loop.latch

loop.latch:
  %c = icmp eq i32 %iv, 16
  %cond = select i1 %c, i32 10, i32 20
  call void @foo(i32 %cond)
  %iv.next = add i32 %iv, 1
  %ec = icmp eq i32 %iv.next, 17
  br i1 %ec, label %exit, label %loop.header

exit:
  %res = phi i32 [ %iv, %loop.header ], [ %cond, %loop.latch ]
  ret i32 %res
}

define i32 @peel_last_multi_exit_btc_computable_exit_values_from_loop_multiple_exit_blocks(i32 %n) {
; CHECK-LABEL: define i32 @peel_last_multi_exit_btc_computable_exit_values_from_loop_multiple_exit_blocks(
; CHECK-SAME: i32 [[N:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[LOOP_HEADER:.*]]
; CHECK:       [[LOOP_HEADER]]:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; CHECK-NEXT:    [[EC_0:%.*]] = icmp eq i32 [[IV]], [[N]]
; CHECK-NEXT:    br i1 [[EC_0]], label %[[EXIT_0:.*]], label %[[LOOP_LATCH]]
; CHECK:       [[LOOP_LATCH]]:
; CHECK-NEXT:    [[C:%.*]] = icmp eq i32 [[IV]], 16
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[C]], i32 10, i32 20
; CHECK-NEXT:    call void @foo(i32 [[COND]])
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i32 [[IV_NEXT]], 17
; CHECK-NEXT:    br i1 [[EC]], label %[[EXIT_1:.*]], label %[[LOOP_HEADER]]
; CHECK:       [[EXIT_0]]:
; CHECK-NEXT:    [[RES_0:%.*]] = phi i32 [ [[IV]], %[[LOOP_HEADER]] ]
; CHECK-NEXT:    ret i32 [[RES_0]]
; CHECK:       [[EXIT_1]]:
; CHECK-NEXT:    [[RES_1:%.*]] = phi i32 [ [[COND]], %[[LOOP_LATCH]] ]
; CHECK-NEXT:    ret i32 [[RES_1]]
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %ec.0 = icmp eq i32 %iv, %n
  br i1 %ec.0, label %exit.0, label %loop.latch

loop.latch:
  %c = icmp eq i32 %iv, 16
  %cond = select i1 %c, i32 10, i32 20
  call void @foo(i32 %cond)
  %iv.next = add i32 %iv, 1
  %ec = icmp eq i32 %iv.next, 17
  br i1 %ec, label %exit.1, label %loop.header

exit.0:
  %res.0 = phi i32 [ %iv, %loop.header ]
  ret i32 %res.0

exit.1:
  %res.1 = phi i32 [ %cond, %loop.latch ]
  ret i32 %res.1
}

define i64 @peel_last_btc_not_computable() {
; CHECK-LABEL: define i64 @peel_last_btc_not_computable() {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[LOOP_HEADER:.*]]
; CHECK:       [[LOOP_HEADER]]:
; CHECK-NEXT:    [[IV_NEXT_LCSSA:%.*]] = phi i64 [ 0, %[[ENTRY]] ], [ [[IV_NEXT_PEEL:%.*]], %[[LOOP_LATCH:.*]] ]
; CHECK-NEXT:    [[EC_0_PEEL:%.*]] = call i1 @cond()
; CHECK-NEXT:    br i1 [[EC_0_PEEL]], label %[[THEN_1:.*]], label %[[EXIT:.*]]
; CHECK:       [[THEN_1]]:
; CHECK-NEXT:    call void @foo(i32 1)
; CHECK-NEXT:    [[C_PEEL:%.*]] = icmp eq i64 [[IV_NEXT_LCSSA]], 7
; CHECK-NEXT:    br i1 [[C_PEEL]], label %[[LOOP_LATCH]], label %[[THEN_2:.*]]
; CHECK:       [[THEN_2]]:
; CHECK-NEXT:    call void @foo(i32 2)
; CHECK-NEXT:    br label %[[LOOP_LATCH]]
; CHECK:       [[LOOP_LATCH]]:
; CHECK-NEXT:    [[IV_NEXT_PEEL]] = add i64 [[IV_NEXT_LCSSA]], 1
; CHECK-NEXT:    [[EXITCOND_PEEL:%.*]] = icmp ne i64 [[IV_NEXT_PEEL]], 8
; CHECK-NEXT:    br i1 [[EXITCOND_PEEL]], label %[[LOOP_HEADER]], label %[[EXIT]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    [[RES:%.*]] = phi i64 [ 1, %[[LOOP_LATCH]] ], [ 2, %[[LOOP_HEADER]] ]
; CHECK-NEXT:    ret i64 [[RES]]
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %ec.0 = call i1 @cond()
  br i1 %ec.0, label %then.1, label %exit

then.1:
  call void @foo(i32 1)
  %c = icmp eq i64 %iv, 7
  br i1 %c, label %loop.latch, label %then.2

then.2:
  call void @foo(i32 2)
  br label %loop.latch

loop.latch:
  %iv.next = add i64 %iv, 1
  %exitcond = icmp ne i64 %iv.next, 8
  br i1 %exitcond, label %loop.header, label %exit

exit:
  %res = phi i64 [ 1, %loop.latch ], [ 2, %loop.header ]
  ret i64 %res
}

define void @peel_exit_count_larger_than_btc(i32 %n) {
; CHECK-LABEL: define void @peel_exit_count_larger_than_btc(
; CHECK-SAME: i32 [[N:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*]]:
; CHECK-NEXT:    br label %[[LOOP_HEADER:.*]]
; CHECK:       [[LOOP_HEADER]]:
; CHECK-NEXT:    [[IV:%.*]] = phi i32 [ 0, %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; CHECK-NEXT:    [[EC_0:%.*]] = icmp eq i32 [[IV]], 10
; CHECK-NEXT:    br i1 [[EC_0]], label %[[EXIT:.*]], label %[[LOOP_LATCH]]
; CHECK:       [[LOOP_LATCH]]:
; CHECK-NEXT:    [[C:%.*]] = icmp eq i32 [[IV]], 9
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[C]], i32 10, i32 20
; CHECK-NEXT:    call void @foo(i32 [[COND]])
; CHECK-NEXT:    [[IV_NEXT]] = add i32 [[IV]], 1
; CHECK-NEXT:    [[EC:%.*]] = icmp eq i32 [[IV_NEXT]], 17
; CHECK-NEXT:    br i1 [[EC]], label %[[EXIT]], label %[[LOOP_HEADER]]
; CHECK:       [[EXIT]]:
; CHECK-NEXT:    ret void
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i32 [ 0, %entry ], [ %iv.next, %loop.latch ]
  %ec.0 = icmp eq i32 %iv, 10
  br i1 %ec.0, label %exit, label %loop.latch

loop.latch:
  %c = icmp eq i32 %iv, 9
  %cond = select i1 %c, i32 10, i32 20
  call void @foo(i32 %cond)
  %iv.next = add i32 %iv, 1
  %ec = icmp eq i32 %iv.next, 17
  br i1 %ec, label %exit, label %loop.header

exit:
  ret void
}
