; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; REQUIRES: x86-registered-target

; RUN: opt -module-summary %s -o %t1.bc
; RUN: opt -module-summary %S/Inputs/cspgo_bar_sample.ll -o %t2.bc
; RUN: llvm-lto2 run -lto-cspgo-profile-file=alloc -enable-sampled-instrumentation -lto-cspgo-gen -save-temps -o %t %t1.bc %t2.bc \
; RUN:   -r=%t1.bc,foo,pl \
; RUN:   -r=%t1.bc,bar,l \
; RUN:   -r=%t1.bc,main,plx \
; RUN:   -r=%t1.bc,__llvm_profile_filename,plx \
; RUN:   -r=%t1.bc,__llvm_profile_raw_version,plx \
; RUN:   -r=%t1.bc,__llvm_profile_sampling,pl \
; RUN:   -r=%t2.bc,bar,pl \
; RUN:   -r=%t2.bc,odd,pl \
; RUN:   -r=%t2.bc,even,pl \
; RUN:   -r=%t2.bc,__llvm_profile_filename,x \
; RUN:   -r=%t2.bc,__llvm_profile_raw_version,x \
; RUN:   -r=%t2.bc,__llvm_profile_sampling,
; RUN: llvm-dis %t.1.4.opt.bc -o - | FileCheck %s --check-prefix=CSGEN

; CSGEN: @__llvm_profile_sampling = thread_local global i16 0, comdat
; CSGEN: @__profc_
; CSGEN: @__profd_

source_filename = "cspgo.c"
target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

$__llvm_profile_filename = comdat any
$__llvm_profile_raw_version = comdat any
$__llvm_profile_sampling = comdat any
@__llvm_profile_filename = local_unnamed_addr constant [25 x i8] c"pass2/default_%m.profraw\00", comdat
@__llvm_profile_raw_version = local_unnamed_addr constant i64 216172782113783812, comdat
@__llvm_profile_sampling = thread_local global i16 0, comdat
@llvm.used = appending global [1 x i8*] [i8* bitcast (i64* @__llvm_profile_sampling to i8*)], section "llvm.metadata"

define dso_local void @foo() #0 !prof !30 {
entry:
  br label %for.body

for.body:
  %i.06 = phi i32 [ 0, %entry ], [ %add1, %for.body ]
  tail call void @bar(i32 %i.06) #3
  %add = or i32 %i.06, 1
  tail call void @bar(i32 %add) #3
  %add1 = add nuw nsw i32 %i.06, 2
  %cmp = icmp ult i32 %add1, 200000
  br i1 %cmp, label %for.body, label %for.end, !prof !31

for.end:
  ret void
}

; CSGEN-LABEL: @foo
; CSGEN:        [[TMP0:%.*]]  = load i16, ptr @__llvm_profile_sampling, align 2
; CSGEN-NEXT:   [[TMP1:%.*]] = icmp ult i16 [[TMP0]], 200
; CSGEN-NEXT:   br i1 [[TMP1]], label %{{.*}}, label %{{.*}}, !prof [[PROF:![0-9]+]]
; CSGEN:        [[TMP2:%.*]] = add i16 {{.*}}, 1
; CSGEN-NEXT:   store i16 [[TMP2]], ptr @__llvm_profile_sampling, align 2

declare dso_local void @bar(i32)

define dso_local i32 @main() !prof !30 {
entry:
  tail call void @foo()
  ret i32 0
}
; CSGEN-LABEL: @main
; CSGEN:        [[TMP0:%.*]]  = load i16, ptr @__llvm_profile_sampling, align 2
; CSGEN-NEXT:   [[TMP1:%.*]] = icmp ult i16 [[TMP0]], 200
; CSGEN-NEXT:   br i1 [[TMP1]], label %{{.*}}, label %{{.*}}, !prof [[PROF:![0-9]+]]
; CSGEN:        [[TMP2:%.*]] = add i16 {{.*}}, 1
; CSGEN-NEXT:   store i16 [[TMP2]], ptr @__llvm_profile_sampling, align 2

attributes #0 = { "target-cpu"="x86-64" }

!llvm.module.flags = !{!0, !1, !2}

!0 = !{i32 1, !"wchar_size", i32 4}
!1 = !{i32 1, !"EnableSplitLTOUnit", i32 0}
!2 = !{i32 1, !"ProfileSummary", !3}
!3 = !{!4, !5, !6, !7, !8, !9, !10, !11}
!4 = !{!"ProfileFormat", !"InstrProf"}
!5 = !{!"TotalCount", i64 500002}
!6 = !{!"MaxCount", i64 200000}
!7 = !{!"MaxInternalCount", i64 100000}
!8 = !{!"MaxFunctionCount", i64 200000}
!9 = !{!"NumCounts", i64 6}
!10 = !{!"NumFunctions", i64 4}
!11 = !{!"DetailedSummary", !12}
!12 = !{!13, !14, !15, !16, !17, !18, !19, !20, !21, !22, !23, !24, !25, !26, !27, !28}
!13 = !{i32 10000, i64 200000, i32 1}
!14 = !{i32 100000, i64 200000, i32 1}
!15 = !{i32 200000, i64 200000, i32 1}
!16 = !{i32 300000, i64 200000, i32 1}
!17 = !{i32 400000, i64 200000, i32 1}
!18 = !{i32 500000, i64 100000, i32 4}
!19 = !{i32 600000, i64 100000, i32 4}
!20 = !{i32 700000, i64 100000, i32 4}
!21 = !{i32 800000, i64 100000, i32 4}
!22 = !{i32 900000, i64 100000, i32 4}
!23 = !{i32 950000, i64 100000, i32 4}
!24 = !{i32 990000, i64 100000, i32 4}
!25 = !{i32 999000, i64 100000, i32 4}
!26 = !{i32 999900, i64 100000, i32 4}
!27 = !{i32 999990, i64 100000, i32 4}
!28 = !{i32 999999, i64 1, i32 6}
!30 = !{!"function_entry_count", i64 1}
!31 = !{!"branch_weights", i32 100000, i32 1}

; CSGEN: [[PROF]] = !{!"branch_weights", i32 200, i32 65336}

