; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt < %s -passes=reassociate -S | FileCheck %s

; We cannot preserve nuw flags for mul
define i4 @nuw_preserve_negative(i4 %a, i4 %b, i4 %c) {
; CHECK-LABEL: define i4 @nuw_preserve_negative(
; CHECK-SAME: i4 [[A:%.*]], i4 [[B:%.*]], i4 [[C:%.*]]) {
; CHECK-NEXT:    [[V0:%.*]] = mul i4 [[B]], [[A]]
; CHECK-NEXT:    [[V1:%.*]] = mul i4 [[V0]], [[C]]
; CHECK-NEXT:    ret i4 [[V1]]
;
  %v0 = mul nuw i4 %a, %c
  %v1 = mul nuw i4 %v0, %b
  ret i4 %v1
}

; TODO: we can add nuw flags if we know all operands are non-zero.
define i4 @nuw_preserve_non_zero(i4 %a, i4 %b, i4 %c) {
; CHECK-LABEL: define i4 @nuw_preserve_non_zero(
; CHECK-SAME: i4 [[A:%.*]], i4 [[B:%.*]], i4 [[C:%.*]]) {
; CHECK-NEXT:    [[A0:%.*]] = add nuw i4 [[A]], 1
; CHECK-NEXT:    [[B0:%.*]] = add nuw i4 [[B]], 1
; CHECK-NEXT:    [[C0:%.*]] = add nuw i4 [[C]], 1
; CHECK-NEXT:    [[V0:%.*]] = mul nuw i4 [[B0]], [[A0]]
; CHECK-NEXT:    [[V1:%.*]] = mul nuw i4 [[V0]], [[C0]]
; CHECK-NEXT:    ret i4 [[V1]]
;
  %a0 = add nuw i4 %a, 1
  %b0 = add nuw i4 %b, 1
  %c0 = add nuw i4 %c, 1
  %v0 = mul nuw i4 %a0, %c0
  %v1 = mul nuw i4 %v0, %b0
  ret i4 %v1
}

define i4 @re_order_mul_nuw(i4 %xx0, i4 %xx1, i4 %xx2, i4 %xx3) {
; CHECK-LABEL: define i4 @re_order_mul_nuw(
; CHECK-SAME: i4 [[XX0:%.*]], i4 [[XX1:%.*]], i4 [[XX2:%.*]], i4 [[XX3:%.*]]) {
; CHECK-NEXT:    [[X0:%.*]] = add nuw i4 [[XX0]], 1
; CHECK-NEXT:    [[X1:%.*]] = add nuw i4 [[XX1]], 1
; CHECK-NEXT:    [[X2:%.*]] = add nuw i4 [[XX2]], 1
; CHECK-NEXT:    [[X3:%.*]] = add nuw i4 [[XX3]], 1
; CHECK-NEXT:    [[MUL_B:%.*]] = mul nuw i4 [[X1]], [[X0]]
; CHECK-NEXT:    [[MUL_A:%.*]] = mul nuw i4 [[MUL_B]], [[X2]]
; CHECK-NEXT:    [[MUL_C:%.*]] = mul nuw i4 [[MUL_A]], [[X3]]
; CHECK-NEXT:    ret i4 [[MUL_C]]
;
  %x0 = add nuw i4 %xx0, 1
  %x1 = add nuw i4 %xx1, 1
  %x2 = add nuw i4 %xx2, 1
  %x3 = add nuw i4 %xx3, 1
  %mul_a = mul nuw i4 %x0, %x1
  %mul_b = mul nuw i4 %x2, %x3
  %mul_c = mul nuw i4 %mul_a, %mul_b
  ret i4 %mul_c
}

define i4 @re_order_mul_nuw_fail_maybe_zero(i4 %xx0, i4 %xx1, i4 %xx2, i4 %xx3) {
; CHECK-LABEL: define i4 @re_order_mul_nuw_fail_maybe_zero(
; CHECK-SAME: i4 [[XX0:%.*]], i4 [[XX1:%.*]], i4 [[XX2:%.*]], i4 [[XX3:%.*]]) {
; CHECK-NEXT:    [[X0:%.*]] = add nsw i4 [[XX0]], 1
; CHECK-NEXT:    [[X1:%.*]] = add nuw i4 [[XX1]], 1
; CHECK-NEXT:    [[X2:%.*]] = add nuw i4 [[XX2]], 1
; CHECK-NEXT:    [[X3:%.*]] = add nuw i4 [[XX3]], 1
; CHECK-NEXT:    [[MUL_B:%.*]] = mul i4 [[X1]], [[X0]]
; CHECK-NEXT:    [[MUL_A:%.*]] = mul i4 [[MUL_B]], [[X2]]
; CHECK-NEXT:    [[MUL_C:%.*]] = mul i4 [[MUL_A]], [[X3]]
; CHECK-NEXT:    ret i4 [[MUL_C]]
;
  %x0 = add nsw i4 %xx0, 1
  %x1 = add nuw i4 %xx1, 1
  %x2 = add nuw i4 %xx2, 1
  %x3 = add nuw i4 %xx3, 1
  %mul_a = mul nuw i4 %x0, %x1
  %mul_b = mul nuw i4 %x2, %x3
  %mul_c = mul nuw i4 %mul_a, %mul_b
  ret i4 %mul_c
}

define i4 @re_order_mul_nsw(i4 %xx0, i4 %xx1, i4 %xx2, i4 %xx3) {
; CHECK-LABEL: define i4 @re_order_mul_nsw(
; CHECK-SAME: i4 [[XX0:%.*]], i4 [[XX1:%.*]], i4 [[XX2:%.*]], i4 [[XX3:%.*]]) {
; CHECK-NEXT:    [[X0_NZ:%.*]] = add nuw i4 [[XX0]], 1
; CHECK-NEXT:    [[X1_NZ:%.*]] = add nuw i4 [[XX1]], 1
; CHECK-NEXT:    [[X2_NZ:%.*]] = add nuw i4 [[XX2]], 1
; CHECK-NEXT:    [[X3_NZ:%.*]] = add nuw i4 [[XX3]], 1
; CHECK-NEXT:    [[X0:%.*]] = call i4 @llvm.smax.i4(i4 [[X0_NZ]], i4 1)
; CHECK-NEXT:    [[X1:%.*]] = call i4 @llvm.smax.i4(i4 [[X1_NZ]], i4 1)
; CHECK-NEXT:    [[X2:%.*]] = call i4 @llvm.smax.i4(i4 [[X2_NZ]], i4 1)
; CHECK-NEXT:    [[X3:%.*]] = call i4 @llvm.smax.i4(i4 [[X3_NZ]], i4 1)
; CHECK-NEXT:    [[MUL_B:%.*]] = mul nsw i4 [[X1]], [[X0]]
; CHECK-NEXT:    [[MUL_A:%.*]] = mul nsw i4 [[MUL_B]], [[X2]]
; CHECK-NEXT:    [[MUL_C:%.*]] = mul nsw i4 [[MUL_A]], [[X3]]
; CHECK-NEXT:    ret i4 [[MUL_C]]
;
  %x0_nz = add nuw i4 %xx0, 1
  %x1_nz = add nuw i4 %xx1, 1
  %x2_nz = add nuw i4 %xx2, 1
  %x3_nz = add nuw i4 %xx3, 1
  %x0 = call i4 @llvm.smax.i4(i4 %x0_nz, i4 1)
  %x1 = call i4 @llvm.smax.i4(i4 %x1_nz, i4 1)
  %x2 = call i4 @llvm.smax.i4(i4 %x2_nz, i4 1)
  %x3 = call i4 @llvm.smax.i4(i4 %x3_nz, i4 1)
  %mul_a = mul nsw i4 %x0, %x1
  %mul_b = mul nsw i4 %x2, %x3
  %mul_c = mul nsw i4 %mul_a, %mul_b
  ret i4 %mul_c
}

define i4 @re_order_mul_nsw_nuw(i4 %xx0, i4 %xx1, i4 %xx2, i4 %xx3) {
; CHECK-LABEL: define i4 @re_order_mul_nsw_nuw(
; CHECK-SAME: i4 [[XX0:%.*]], i4 [[XX1:%.*]], i4 [[XX2:%.*]], i4 [[XX3:%.*]]) {
; CHECK-NEXT:    [[X0:%.*]] = add nuw i4 [[XX0]], 1
; CHECK-NEXT:    [[X1:%.*]] = add nuw i4 [[XX1]], 1
; CHECK-NEXT:    [[X2:%.*]] = add nuw i4 [[XX2]], 1
; CHECK-NEXT:    [[X3:%.*]] = add nuw i4 [[XX3]], 1
; CHECK-NEXT:    [[MUL_B:%.*]] = mul nuw nsw i4 [[X1]], [[X0]]
; CHECK-NEXT:    [[MUL_A:%.*]] = mul nuw nsw i4 [[MUL_B]], [[X2]]
; CHECK-NEXT:    [[MUL_C:%.*]] = mul nuw nsw i4 [[MUL_A]], [[X3]]
; CHECK-NEXT:    ret i4 [[MUL_C]]
;
  %x0 = add nuw i4 %xx0, 1
  %x1 = add nuw i4 %xx1, 1
  %x2 = add nuw i4 %xx2, 1
  %x3 = add nuw i4 %xx3, 1
  %mul_a = mul nuw nsw i4 %x0, %x1
  %mul_b = mul nuw nsw i4 %x2, %x3
  %mul_c = mul nuw nsw i4 %mul_a, %mul_b
  ret i4 %mul_c
}

define i4 @re_order_mul_fail_maybe_neg(i4 %xx0, i4 %xx1, i4 %xx2, i4 %xx3) {
; CHECK-LABEL: define i4 @re_order_mul_fail_maybe_neg(
; CHECK-SAME: i4 [[XX0:%.*]], i4 [[XX1:%.*]], i4 [[XX2:%.*]], i4 [[XX3:%.*]]) {
; CHECK-NEXT:    [[X0_NZ:%.*]] = add nuw i4 [[XX0]], 1
; CHECK-NEXT:    [[X1_NZ:%.*]] = add nuw i4 [[XX1]], 1
; CHECK-NEXT:    [[X2_NZ:%.*]] = add nuw i4 [[XX2]], 1
; CHECK-NEXT:    [[X3:%.*]] = add nuw i4 [[XX3]], 1
; CHECK-NEXT:    [[X0:%.*]] = call i4 @llvm.smax.i4(i4 [[X0_NZ]], i4 1)
; CHECK-NEXT:    [[X1:%.*]] = call i4 @llvm.smax.i4(i4 [[X1_NZ]], i4 1)
; CHECK-NEXT:    [[X2:%.*]] = call i4 @llvm.smax.i4(i4 [[X2_NZ]], i4 1)
; CHECK-NEXT:    [[MUL_B:%.*]] = mul i4 [[X1]], [[X0]]
; CHECK-NEXT:    [[MUL_A:%.*]] = mul i4 [[MUL_B]], [[X3]]
; CHECK-NEXT:    [[MUL_C:%.*]] = mul i4 [[MUL_A]], [[X2]]
; CHECK-NEXT:    ret i4 [[MUL_C]]
;
  %x0_nz = add nuw i4 %xx0, 1
  %x1_nz = add nuw i4 %xx1, 1
  %x2_nz = add nuw i4 %xx2, 1
  %x3 = add nuw i4 %xx3, 1
  %x0 = call i4 @llvm.smax.i4(i4 %x0_nz, i4 1)
  %x1 = call i4 @llvm.smax.i4(i4 %x1_nz, i4 1)
  %x2 = call i4 @llvm.smax.i4(i4 %x2_nz, i4 1)
  %mul_a = mul nsw i4 %x0, %x1
  %mul_b = mul nsw i4 %x2, %x3
  %mul_c = mul nsw i4 %mul_a, %mul_b
  ret i4 %mul_c
}

define i4 @re_order_mul_nsw_fail_maybe_z(i4 %xx0, i4 %xx1, i4 %xx2, i4 %xx3) {
; CHECK-LABEL: define i4 @re_order_mul_nsw_fail_maybe_z(
; CHECK-SAME: i4 [[XX0:%.*]], i4 [[XX1:%.*]], i4 [[XX2:%.*]], i4 [[XX3:%.*]]) {
; CHECK-NEXT:    [[X0_NZ:%.*]] = add nuw i4 [[XX0]], 1
; CHECK-NEXT:    [[X1_NZ:%.*]] = add nuw i4 [[XX1]], 1
; CHECK-NEXT:    [[X2_NZ:%.*]] = add nuw i4 [[XX2]], 1
; CHECK-NEXT:    [[X3_NZ:%.*]] = add nuw i4 [[XX3]], 1
; CHECK-NEXT:    [[X0:%.*]] = call i4 @llvm.smax.i4(i4 [[X0_NZ]], i4 1)
; CHECK-NEXT:    [[X1:%.*]] = call i4 @llvm.smax.i4(i4 [[X1_NZ]], i4 1)
; CHECK-NEXT:    [[X2:%.*]] = call i4 @llvm.smax.i4(i4 [[X2_NZ]], i4 0)
; CHECK-NEXT:    [[X3:%.*]] = call i4 @llvm.smax.i4(i4 [[X3_NZ]], i4 1)
; CHECK-NEXT:    [[MUL_B:%.*]] = mul i4 [[X1]], [[X0]]
; CHECK-NEXT:    [[MUL_A:%.*]] = mul i4 [[MUL_B]], [[X2]]
; CHECK-NEXT:    [[MUL_C:%.*]] = mul i4 [[MUL_A]], [[X3]]
; CHECK-NEXT:    ret i4 [[MUL_C]]
;
  %x0_nz = add nuw i4 %xx0, 1
  %x1_nz = add nuw i4 %xx1, 1
  %x2_nz = add nuw i4 %xx2, 1
  %x3_nz = add nuw i4 %xx3, 1
  %x0 = call i4 @llvm.smax.i4(i4 %x0_nz, i4 1)
  %x1 = call i4 @llvm.smax.i4(i4 %x1_nz, i4 1)
  %x2 = call i4 @llvm.smax.i4(i4 %x2_nz, i4 0)
  %x3 = call i4 @llvm.smax.i4(i4 %x3_nz, i4 1)
  %mul_a = mul nsw i4 %x0, %x1
  %mul_b = mul nsw i4 %x2, %x3
  %mul_c = mul nsw i4 %mul_a, %mul_b
  ret i4 %mul_c
}
