# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=aarch64 -mcpu=cortex-a55 -timeline -timeline-max-iterations=1 -timeline-max-cycles=1000 < %s | FileCheck %s

# This test demonstrates the latency into a store address operand.

add      x2, x3, #1
str      b0, [x2, #16]
add      x2, x3, #1
str      b0, [x2, #16]!
add      x2, x3, #1
str      b0, [x2], #16
add      x2, x3, #1
str      d0, [x2], #16
add      x2, x3, #1
str      d0, [x2, #16]!
add      x2, x3, #1
str      d0, [x2, #16]
add      x2, x3, #1
str      h0, [x2], #16
add      x2, x3, #1
str      h0, [x2, #16]!
add      x2, x3, #1
str      h0, [x2, #16]
add      x2, x3, #1
str      q0, [x2], #16
add      x2, x3, #1
str      q0, [x2, #16]!
add      x2, x3, #1
str      q0, [x2, #16]
add      x2, x3, #1
str      s0, [x2], #16
add      x2, x3, #1
str      s0, [x2, #16]!
add      x2, x3, #1
str      s0, [x2, #16]
add      x2, x3, #1
str      w0, [x2], #16
add      x2, x3, #1
str      w0, [x2, #16]!
add      x2, x3, #1
str      w0, [x2, #16]
add      x2, x3, #1
str      x0, [x2], #16
add      x2, x3, #1
str      x0, [x2, #16]!
add      x2, x3, #1
str      x0, [x2, #16]
add      x2, x3, #1
strb     w0, [x2], #16
add      x2, x3, #1
strb     w0, [x2, #16]!
add      x2, x3, #1
strb     w0, [x2, #16]
add      x2, x3, #1
strh     w0, [x2], #16
add      x2, x3, #1
strh     w0, [x2, #16]!
add      x2, x3, #1
strh     w0, [x2, #16]
add      x2, x3, #1
str      d0, [x2, x2, lsl #3]
add      x2, x3, #1
str      q0, [x2, w0, sxtw]
add      x2, x3, #1
str      w0, [x2, w0, sxtw]
add      x2, x3, #1
str      x0, [x2, w0, sxtw]
add      x2, x3, #1
strb     w0, [x2, w0, sxtw]
add      x2, x3, #1
strh     w0, [x2, w0, sxtw]
add      x2, x3, #1
stur     b0, [x2, #255]
add      x2, x3, #1
stur     d0, [x2, #255]
add      x2, x3, #1
stur     h0, [x2, #255]
add      x2, x3, #1
stur     q0, [x2, #255]
add      x2, x3, #1
stur     s0, [x2, #255]
add      x2, x3, #1
stur     w0, [x2, #255]
add      x2, x3, #1
sturb    w0, [x2, #255]
add      x2, x3, #1
sturh    w0, [x2, #255]

add      x2, x3, #1
stnp     d0, d1, [x2, #16]
add      x2, x3, #1
stnp     q0, q1, [x2, #16]
add      x2, x3, #1
stnp     s0, s1, [x2, #16]
add      x2, x3, #1
stnp     s0, s1, [x2, #16]
add      x2, x3, #1
stnp     w0, w1, [x2, #16]
add      x2, x3, #1
stnp     x0, x1, [x2, #16]
add      x2, x3, #1
stp      d0, d1, [x2, #16]
add      x2, x3, #1
stp      d0, d1, [x2, #16]!
add      x2, x3, #1
stp      d0, d1, [x2], #16
add      x2, x3, #1
stp      q0, q1, [x2, #16]
add      x2, x3, #1
stp      q0, q1, [x2, #16]!
add      x2, x3, #1
stp      q0, q1, [x2], #16
add      x2, x3, #1
stp      s0, s1, [x2, #16]
add      x2, x3, #1
stp      s0, s1, [x2, #16]!
add      x2, x3, #1
stp      s0, s1, [x2], #16
add      x2, x3, #1
stp      x0, x1, [x2, #16]
add      x2, x3, #1
stp      x0, x1, [x2, #16]!
add      x2, x3, #1
stp      x0, x1, [x2], #16

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      11800
# CHECK-NEXT: Total Cycles:      19801
# CHECK-NEXT: Total uOps:        14400

# CHECK:      Dispatch Width:    2
# CHECK-NEXT: uOps Per Cycle:    0.73
# CHECK-NEXT: IPC:               0.60
# CHECK-NEXT: Block RThroughput: 72.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            str	b0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	b0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	b0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	d0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	d0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            str	d0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	h0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	h0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            str	h0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	q0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	q0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            str	q0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	s0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	s0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            str	s0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	w0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	w0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            str	w0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	x0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            str	x0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            str	x0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            strb	w0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            strb	w0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            strb	w0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            strh	w0, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            strh	w0, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            strh	w0, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            str	d0, [x2, x2, lsl #3]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            str	q0, [x2, w0, sxtw]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            str	w0, [x2, w0, sxtw]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            str	x0, [x2, w0, sxtw]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            strb	w0, [x2, w0, sxtw]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            strh	w0, [x2, w0, sxtw]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stur	b0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stur	d0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stur	h0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stur	q0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stur	s0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stur	w0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            sturb	w0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            sturh	w0, [x2, #255]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stnp	d0, d1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stnp	q0, q1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stnp	s0, s1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stnp	s0, s1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stnp	w0, w1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stnp	x0, x1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stp	d0, d1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            stp	d0, d1, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            stp	d0, d1, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stp	q0, q1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            stp	q0, q1, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            stp	q0, q1, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stp	s0, s1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            stp	s0, s1, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            stp	s0, s1, [x2], #16
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  1      1     1.00           *            stp	x0, x1, [x2, #16]
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            stp	x0, x1, [x2, #16]!
# CHECK-NEXT:  1      3     0.50                        add	x2, x3, #1
# CHECK-NEXT:  2      1     1.00           *            stp	x0, x1, [x2], #16

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - CortexA55UnitALU
# CHECK-NEXT: [0.1] - CortexA55UnitALU
# CHECK-NEXT: [1]   - CortexA55UnitB
# CHECK-NEXT: [2]   - CortexA55UnitDiv
# CHECK-NEXT: [3.0] - CortexA55UnitFPALU
# CHECK-NEXT: [3.1] - CortexA55UnitFPALU
# CHECK-NEXT: [4]   - CortexA55UnitFPDIV
# CHECK-NEXT: [5.0] - CortexA55UnitFPMAC
# CHECK-NEXT: [5.1] - CortexA55UnitFPMAC
# CHECK-NEXT: [6]   - CortexA55UnitLd
# CHECK-NEXT: [7]   - CortexA55UnitMAC
# CHECK-NEXT: [8]   - CortexA55UnitSt

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3.0]  [3.1]  [4]    [5.0]  [5.1]  [6]    [7]    [8]
# CHECK-NEXT: 29.50  29.50   -      -      -      -      -      -      -      -      -     59.00

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1]    [2]    [3.0]  [3.1]  [4]    [5.0]  [5.1]  [6]    [7]    [8]    Instructions:
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	b0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	b0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	b0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	d0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	d0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	d0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	h0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	h0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	h0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	q0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	q0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	q0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	s0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	s0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	s0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	w0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	w0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	w0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	x0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	x0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	x0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   strb	w0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   strb	w0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   strb	w0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   strh	w0, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   strh	w0, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   strh	w0, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	d0, [x2, x2, lsl #3]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	q0, [x2, w0, sxtw]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	w0, [x2, w0, sxtw]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   str	x0, [x2, w0, sxtw]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   strb	w0, [x2, w0, sxtw]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   strh	w0, [x2, w0, sxtw]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stur	b0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stur	d0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stur	h0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stur	q0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stur	s0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stur	w0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   sturb	w0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   sturh	w0, [x2, #255]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stnp	d0, d1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stnp	q0, q1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stnp	s0, s1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stnp	s0, s1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stnp	w0, w1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stnp	x0, x1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stp	d0, d1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stp	d0, d1, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stp	d0, d1, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stp	q0, q1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stp	q0, q1, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stp	q0, q1, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stp	s0, s1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stp	s0, s1, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stp	s0, s1, [x2], #16
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stp	x0, x1, [x2, #16]
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stp	x0, x1, [x2, #16]!
# CHECK-NEXT: 0.50   0.50    -      -      -      -      -      -      -      -      -      -     add	x2, x3, #1
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00   stp	x0, x1, [x2], #16

# CHECK:      Timeline view:
# CHECK-NEXT:                     0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          012345678
# CHECK-NEXT: Index     0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789          0123456789

# CHECK:      [0,0]     DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,1]     .  DE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	b0, [x2, #16]
# CHECK-NEXT: [0,2]     .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,3]     .    .DE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	b0, [x2, #16]!
# CHECK-NEXT: [0,4]     .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,5]     .    .    DE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	b0, [x2], #16
# CHECK-NEXT: [0,6]     .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,7]     .    .    .   DE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	d0, [x2], #16
# CHECK-NEXT: [0,8]     .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,9]     .    .    .    .  DE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	d0, [x2, #16]!
# CHECK-NEXT: [0,10]    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,11]    .    .    .    .    . DE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	d0, [x2, #16]
# CHECK-NEXT: [0,12]    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,13]    .    .    .    .    .    DE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	h0, [x2], #16
# CHECK-NEXT: [0,14]    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,15]    .    .    .    .    .    .   DE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	h0, [x2, #16]!
# CHECK-NEXT: [0,16]    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,17]    .    .    .    .    .    .    .  DE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	h0, [x2, #16]
# CHECK-NEXT: [0,18]    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,19]    .    .    .    .    .    .    .    .DE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	q0, [x2], #16
# CHECK-NEXT: [0,20]    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,21]    .    .    .    .    .    .    .    .    DE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	q0, [x2, #16]!
# CHECK-NEXT: [0,22]    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,23]    .    .    .    .    .    .    .    .    .   DE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	q0, [x2, #16]
# CHECK-NEXT: [0,24]    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,25]    .    .    .    .    .    .    .    .    .    . DE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	s0, [x2], #16
# CHECK-NEXT: [0,26]    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,27]    .    .    .    .    .    .    .    .    .    .    .DE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	s0, [x2, #16]!
# CHECK-NEXT: [0,28]    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,29]    .    .    .    .    .    .    .    .    .    .    .    DE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	s0, [x2, #16]
# CHECK-NEXT: [0,30]    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,31]    .    .    .    .    .    .    .    .    .    .    .    .  DE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	w0, [x2], #16
# CHECK-NEXT: [0,32]    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,33]    .    .    .    .    .    .    .    .    .    .    .    .    . DE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	w0, [x2, #16]!
# CHECK-NEXT: [0,34]    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,35]    .    .    .    .    .    .    .    .    .    .    .    .    .    .DE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	w0, [x2, #16]
# CHECK-NEXT: [0,36]    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,37]    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	x0, [x2], #16
# CHECK-NEXT: [0,38]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,39]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	x0, [x2, #16]!
# CHECK-NEXT: [0,40]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,41]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	x0, [x2, #16]
# CHECK-NEXT: [0,42]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,43]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   strb	w0, [x2], #16
# CHECK-NEXT: [0,44]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,45]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   strb	w0, [x2, #16]!
# CHECK-NEXT: [0,46]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,47]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   strb	w0, [x2, #16]
# CHECK-NEXT: [0,48]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,49]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   strh	w0, [x2], #16
# CHECK-NEXT: [0,50]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,51]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   strh	w0, [x2, #16]!
# CHECK-NEXT: [0,52]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,53]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   strh	w0, [x2, #16]
# CHECK-NEXT: [0,54]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,55]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	d0, [x2, x2, lsl #3]
# CHECK-NEXT: [0,56]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,57]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	q0, [x2, w0, sxtw]
# CHECK-NEXT: [0,58]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,59]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	w0, [x2, w0, sxtw]
# CHECK-NEXT: [0,60]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,61]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   str	x0, [x2, w0, sxtw]
# CHECK-NEXT: [0,62]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,63]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   strb	w0, [x2, w0, sxtw]
# CHECK-NEXT: [0,64]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,65]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   strh	w0, [x2, w0, sxtw]
# CHECK-NEXT: [0,66]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,67]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   stur	b0, [x2, #255]
# CHECK-NEXT: [0,68]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,69]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   stur	d0, [x2, #255]
# CHECK-NEXT: [0,70]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,71]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DE  .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   stur	h0, [x2, #255]
# CHECK-NEXT: [0,72]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,73]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DE    .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   stur	q0, [x2, #255]
# CHECK-NEXT: [0,74]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,75]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DE .    .    .    .    .    .    .    .    .    .    .    .    .    .  .   stur	s0, [x2, #255]
# CHECK-NEXT: [0,76]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,77]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DE   .    .    .    .    .    .    .    .    .    .    .    .    .  .   stur	w0, [x2, #255]
# CHECK-NEXT: [0,78]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,79]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DE.    .    .    .    .    .    .    .    .    .    .    .    .  .   sturb	w0, [x2, #255]
# CHECK-NEXT: [0,80]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,81]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DE  .    .    .    .    .    .    .    .    .    .    .    .  .   sturh	w0, [x2, #255]
# CHECK-NEXT: [0,82]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,83]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DE    .    .    .    .    .    .    .    .    .    .    .  .   stnp	d0, d1, [x2, #16]
# CHECK-NEXT: [0,84]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,85]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DE .    .    .    .    .    .    .    .    .    .    .  .   stnp	q0, q1, [x2, #16]
# CHECK-NEXT: [0,86]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,87]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DE   .    .    .    .    .    .    .    .    .    .  .   stnp	s0, s1, [x2, #16]
# CHECK-NEXT: [0,88]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,89]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DE.    .    .    .    .    .    .    .    .    .  .   stnp	s0, s1, [x2, #16]
# CHECK-NEXT: [0,90]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,91]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DE  .    .    .    .    .    .    .    .    .  .   stnp	w0, w1, [x2, #16]
# CHECK-NEXT: [0,92]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,93]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DE    .    .    .    .    .    .    .    .  .   stnp	x0, x1, [x2, #16]
# CHECK-NEXT: [0,94]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,95]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DE .    .    .    .    .    .    .    .  .   stp	d0, d1, [x2, #16]
# CHECK-NEXT: [0,96]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,97]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DE   .    .    .    .    .    .    .  .   stp	d0, d1, [x2, #16]!
# CHECK-NEXT: [0,98]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,99]    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DE    .    .    .    .    .    .  .   stp	d0, d1, [x2], #16
# CHECK-NEXT: [0,100]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .    .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,101]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DE.    .    .    .    .    .  .   stp	q0, q1, [x2, #16]
# CHECK-NEXT: [0,102]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,103]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DE  .    .    .    .    .  .   stp	q0, q1, [x2, #16]!
# CHECK-NEXT: [0,104]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,105]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DE   .    .    .    .  .   stp	q0, q1, [x2], #16
# CHECK-NEXT: [0,106]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DeeE.    .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,107]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DE    .    .    .  .   stp	s0, s1, [x2, #16]
# CHECK-NEXT: [0,108]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE  .    .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,109]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DE .    .    .  .   stp	s0, s1, [x2, #16]!
# CHECK-NEXT: [0,110]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DeeE   .    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,111]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .DE  .    .  .   stp	s0, s1, [x2], #16
# CHECK-NEXT: [0,112]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DeeE    .  .   add	x2, x3, #1
# CHECK-NEXT: [0,113]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DE   .  .   stp	x0, x1, [x2, #16]
# CHECK-NEXT: [0,114]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    DeeE .  .   add	x2, x3, #1
# CHECK-NEXT: [0,115]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .  DE.  .   stp	x0, x1, [x2, #16]!
# CHECK-NEXT: [0,116]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .   DeeE.   add	x2, x3, #1
# CHECK-NEXT: [0,117]   .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    .    . DE   stp	x0, x1, [x2], #16

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 1.     1     0.0    0.0    0.0       str	b0, [x2, #16]
# CHECK-NEXT: 2.     1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 3.     1     0.0    0.0    0.0       str	b0, [x2, #16]!
# CHECK-NEXT: 4.     1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 5.     1     0.0    0.0    0.0       str	b0, [x2], #16
# CHECK-NEXT: 6.     1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 7.     1     0.0    0.0    0.0       str	d0, [x2], #16
# CHECK-NEXT: 8.     1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 9.     1     0.0    0.0    0.0       str	d0, [x2, #16]!
# CHECK-NEXT: 10.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 11.    1     0.0    0.0    0.0       str	d0, [x2, #16]
# CHECK-NEXT: 12.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 13.    1     0.0    0.0    0.0       str	h0, [x2], #16
# CHECK-NEXT: 14.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 15.    1     0.0    0.0    0.0       str	h0, [x2, #16]!
# CHECK-NEXT: 16.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 17.    1     0.0    0.0    0.0       str	h0, [x2, #16]
# CHECK-NEXT: 18.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 19.    1     0.0    0.0    0.0       str	q0, [x2], #16
# CHECK-NEXT: 20.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 21.    1     0.0    0.0    0.0       str	q0, [x2, #16]!
# CHECK-NEXT: 22.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 23.    1     0.0    0.0    0.0       str	q0, [x2, #16]
# CHECK-NEXT: 24.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 25.    1     0.0    0.0    0.0       str	s0, [x2], #16
# CHECK-NEXT: 26.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 27.    1     0.0    0.0    0.0       str	s0, [x2, #16]!
# CHECK-NEXT: 28.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 29.    1     0.0    0.0    0.0       str	s0, [x2, #16]
# CHECK-NEXT: 30.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 31.    1     0.0    0.0    0.0       str	w0, [x2], #16
# CHECK-NEXT: 32.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 33.    1     0.0    0.0    0.0       str	w0, [x2, #16]!
# CHECK-NEXT: 34.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 35.    1     0.0    0.0    0.0       str	w0, [x2, #16]
# CHECK-NEXT: 36.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 37.    1     0.0    0.0    0.0       str	x0, [x2], #16
# CHECK-NEXT: 38.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 39.    1     0.0    0.0    0.0       str	x0, [x2, #16]!
# CHECK-NEXT: 40.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 41.    1     0.0    0.0    0.0       str	x0, [x2, #16]
# CHECK-NEXT: 42.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 43.    1     0.0    0.0    0.0       strb	w0, [x2], #16
# CHECK-NEXT: 44.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 45.    1     0.0    0.0    0.0       strb	w0, [x2, #16]!
# CHECK-NEXT: 46.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 47.    1     0.0    0.0    0.0       strb	w0, [x2, #16]
# CHECK-NEXT: 48.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 49.    1     0.0    0.0    0.0       strh	w0, [x2], #16
# CHECK-NEXT: 50.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 51.    1     0.0    0.0    0.0       strh	w0, [x2, #16]!
# CHECK-NEXT: 52.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 53.    1     0.0    0.0    0.0       strh	w0, [x2, #16]
# CHECK-NEXT: 54.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 55.    1     0.0    0.0    0.0       str	d0, [x2, x2, lsl #3]
# CHECK-NEXT: 56.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 57.    1     0.0    0.0    0.0       str	q0, [x2, w0, sxtw]
# CHECK-NEXT: 58.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 59.    1     0.0    0.0    0.0       str	w0, [x2, w0, sxtw]
# CHECK-NEXT: 60.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 61.    1     0.0    0.0    0.0       str	x0, [x2, w0, sxtw]
# CHECK-NEXT: 62.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 63.    1     0.0    0.0    0.0       strb	w0, [x2, w0, sxtw]
# CHECK-NEXT: 64.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 65.    1     0.0    0.0    0.0       strh	w0, [x2, w0, sxtw]
# CHECK-NEXT: 66.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 67.    1     0.0    0.0    0.0       stur	b0, [x2, #255]
# CHECK-NEXT: 68.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 69.    1     0.0    0.0    0.0       stur	d0, [x2, #255]
# CHECK-NEXT: 70.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 71.    1     0.0    0.0    0.0       stur	h0, [x2, #255]
# CHECK-NEXT: 72.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 73.    1     0.0    0.0    0.0       stur	q0, [x2, #255]
# CHECK-NEXT: 74.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 75.    1     0.0    0.0    0.0       stur	s0, [x2, #255]
# CHECK-NEXT: 76.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 77.    1     0.0    0.0    0.0       stur	w0, [x2, #255]
# CHECK-NEXT: 78.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 79.    1     0.0    0.0    0.0       sturb	w0, [x2, #255]
# CHECK-NEXT: 80.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 81.    1     0.0    0.0    0.0       sturh	w0, [x2, #255]
# CHECK-NEXT: 82.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 83.    1     0.0    0.0    0.0       stnp	d0, d1, [x2, #16]
# CHECK-NEXT: 84.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 85.    1     0.0    0.0    0.0       stnp	q0, q1, [x2, #16]
# CHECK-NEXT: 86.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 87.    1     0.0    0.0    0.0       stnp	s0, s1, [x2, #16]
# CHECK-NEXT: 88.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 89.    1     0.0    0.0    0.0       stnp	s0, s1, [x2, #16]
# CHECK-NEXT: 90.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 91.    1     0.0    0.0    0.0       stnp	w0, w1, [x2, #16]
# CHECK-NEXT: 92.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 93.    1     0.0    0.0    0.0       stnp	x0, x1, [x2, #16]
# CHECK-NEXT: 94.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 95.    1     0.0    0.0    0.0       stp	d0, d1, [x2, #16]
# CHECK-NEXT: 96.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 97.    1     0.0    0.0    0.0       stp	d0, d1, [x2, #16]!
# CHECK-NEXT: 98.    1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 99.    1     0.0    0.0    0.0       stp	d0, d1, [x2], #16
# CHECK-NEXT: 100.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 101.   1     0.0    0.0    0.0       stp	q0, q1, [x2, #16]
# CHECK-NEXT: 102.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 103.   1     0.0    0.0    0.0       stp	q0, q1, [x2, #16]!
# CHECK-NEXT: 104.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 105.   1     0.0    0.0    0.0       stp	q0, q1, [x2], #16
# CHECK-NEXT: 106.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 107.   1     0.0    0.0    0.0       stp	s0, s1, [x2, #16]
# CHECK-NEXT: 108.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 109.   1     0.0    0.0    0.0       stp	s0, s1, [x2, #16]!
# CHECK-NEXT: 110.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 111.   1     0.0    0.0    0.0       stp	s0, s1, [x2], #16
# CHECK-NEXT: 112.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 113.   1     0.0    0.0    0.0       stp	x0, x1, [x2, #16]
# CHECK-NEXT: 114.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 115.   1     0.0    0.0    0.0       stp	x0, x1, [x2, #16]!
# CHECK-NEXT: 116.   1     0.0    0.0    0.0       add	x2, x3, #1
# CHECK-NEXT: 117.   1     0.0    0.0    0.0       stp	x0, x1, [x2], #16
# CHECK-NEXT:        1     0.0    0.0    0.0       <total>
