# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p670 -iterations=100 < %s | FileCheck %s

vsetvli zero, zero, e32, m1, ta, ma

vmslt.vv v0, v4, v20
vmsle.vv v8, v4, v20
vmsgt.vv v8, v20, v4
vmsge.vv v8, v20, v4
vmseq.vv v8, v4, v20
vmsne.vv v8, v4, v20
vmsltu.vv v8, v4, v20
vmsleu.vv v8, v4, v20
vmsgtu.vv v8, v20, v4
vmsgeu.vv v8, v20, v4

vmflt.vv v0, v4, v20
vmfle.vv v8, v4, v20
vmfgt.vv v8, v20, v4
vmfge.vv v8, v20, v4
vmfeq.vv v8, v4, v20
vmfne.vv v8, v4, v20

vmadc.vv v8, v4, v20
vmsbc.vv v8, v4, v20

vfirst.m a2, v4
vpopc.m a2, v4

viota.m v8, v4

vmsbf.m v8, v4
vmsif.m v8, v4
vmsof.m v8, v4

# CHECK:      Iterations:        100
# CHECK-NEXT: Instructions:      2500
# CHECK-NEXT: Total Cycles:      2605
# CHECK-NEXT: Total uOps:        2500

# CHECK:      Dispatch Width:    4
# CHECK-NEXT: uOps Per Cycle:    0.96
# CHECK-NEXT: IPC:               0.96
# CHECK-NEXT: Block RThroughput: 26.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     1.00                  U     vsetvli	zero, zero, e32, m1, ta, ma
# CHECK-NEXT:  1      2     1.00                        vmslt.vv	v0, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmsle.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmslt.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmsle.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmseq.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmsne.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmsltu.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmsleu.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmsltu.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmsleu.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmflt.vv	v0, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmfle.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmflt.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmfle.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmfeq.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmfne.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmadc.vv	v8, v4, v20
# CHECK-NEXT:  1      2     1.00                        vmsbc.vv	v8, v4, v20
# CHECK-NEXT:  1      2     2.00                        vfirst.m	a2, v4
# CHECK-NEXT:  1      2     2.00                        vcpop.m	a2, v4
# CHECK-NEXT:  1      2     1.00                        viota.m	v8, v4
# CHECK-NEXT:  1      2     1.00                        vmsbf.m	v8, v4
# CHECK-NEXT:  1      2     1.00                        vmsif.m	v8, v4
# CHECK-NEXT:  1      2     1.00                        vmsof.m	v8, v4

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP600Div
# CHECK-NEXT: [1]   - SiFiveP600FEXQ0
# CHECK-NEXT: [2]   - SiFiveP600FEXQ1
# CHECK-NEXT: [3]   - SiFiveP600FloatDiv
# CHECK-NEXT: [4]   - SiFiveP600IEXQ0
# CHECK-NEXT: [5]   - SiFiveP600IEXQ1
# CHECK-NEXT: [6]   - SiFiveP600IEXQ2
# CHECK-NEXT: [7]   - SiFiveP600IEXQ3
# CHECK-NEXT: [8.0] - SiFiveP600LDST
# CHECK-NEXT: [8.1] - SiFiveP600LDST
# CHECK-NEXT: [9]   - SiFiveP600VDiv
# CHECK-NEXT: [10]  - SiFiveP600VEXQ0
# CHECK-NEXT: [11]  - SiFiveP600VEXQ1
# CHECK-NEXT: [12]  - SiFiveP600VFloatDiv
# CHECK-NEXT: [13]  - SiFiveP600VLD
# CHECK-NEXT: [14]  - SiFiveP600VST

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8.0]  [8.1]  [9]    [10]   [11]   [12]   [13]   [14]
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -     26.00   -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8.0]  [8.1]  [9]    [10]   [11]   [12]   [13]   [14]   Instructions:
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -     vsetvli	zero, zero, e32, m1, ta, ma
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmslt.vv	v0, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsle.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmslt.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsle.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmseq.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsne.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsltu.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsleu.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsltu.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsleu.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmflt.vv	v0, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmfle.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmflt.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmfle.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmfeq.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmfne.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmadc.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsbc.vv	v8, v4, v20
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     2.00    -      -      -      -     vfirst.m	a2, v4
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     2.00    -      -      -      -     vcpop.m	a2, v4
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     viota.m	v8, v4
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsbf.m	v8, v4
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsif.m	v8, v4
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -     vmsof.m	v8, v4
