# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=xiangshan-nanhu -timeline -iterations=1 < %s | FileCheck %s

# Test XiangShan load to ALU (4 cycles)
ld a1, 0(a0)
addi a2, a1, 1

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      2
# CHECK-NEXT: Total Cycles:      8
# CHECK-NEXT: Total uOps:        2

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    0.25
# CHECK-NEXT: IPC:               0.25
# CHECK-NEXT: Block RThroughput: 0.5

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      5     0.50    *                   ld	a1, 0(a0)
# CHECK-NEXT:  1      1     0.25                        addi	a2, a1, 1

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - XS2ALU
# CHECK-NEXT: [0.1] - XS2ALU
# CHECK-NEXT: [0.2] - XS2ALU
# CHECK-NEXT: [0.3] - XS2ALU
# CHECK-NEXT: [1.0] - XS2FMAC
# CHECK-NEXT: [1.1] - XS2FMAC
# CHECK-NEXT: [1.2] - XS2FMAC
# CHECK-NEXT: [1.3] - XS2FMAC
# CHECK-NEXT: [2.0] - XS2FMISC
# CHECK-NEXT: [2.1] - XS2FMISC
# CHECK-NEXT: [3.0] - XS2LD
# CHECK-NEXT: [3.1] - XS2LD
# CHECK-NEXT: [4.0] - XS2MDU
# CHECK-NEXT: [4.1] - XS2MDU
# CHECK-NEXT: [5]   - XS2MISC
# CHECK-NEXT: [6.0] - XS2ST
# CHECK-NEXT: [6.1] - XS2ST

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [0.2]  [0.3]  [1.0]  [1.1]  [1.2]  [1.3]  [2.0]  [2.1]  [3.0]  [3.1]  [4.0]  [4.1]  [5]    [6.0]  [6.1]
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -      -      -      -     1.00    -      -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [0.2]  [0.3]  [1.0]  [1.1]  [1.2]  [1.3]  [2.0]  [2.1]  [3.0]  [3.1]  [4.0]  [4.1]  [5]    [6.0]  [6.1]  Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -      -      -     1.00    -      -      -      -      -     ld	a1, 0(a0)
# CHECK-NEXT:  -      -      -     1.00    -      -      -      -      -      -      -      -      -      -      -      -      -     addi	a2, a1, 1

# CHECK:      Timeline view:
# CHECK-NEXT: Index     01234567

# CHECK:      [0,0]     DeeeeeER   ld	a1, 0(a0)
# CHECK-NEXT: [0,1]     D====eER   addi	a2, a1, 1

# CHECK:      Average Wait times (based on the timeline view):
# CHECK-NEXT: [0]: Executions
# CHECK-NEXT: [1]: Average time spent waiting in a scheduler's queue
# CHECK-NEXT: [2]: Average time spent waiting in a scheduler's queue while ready
# CHECK-NEXT: [3]: Average time elapsed from WB until retire stage

# CHECK:            [0]    [1]    [2]    [3]
# CHECK-NEXT: 0.     1     1.0    1.0    0.0       ld	a1, 0(a0)
# CHECK-NEXT: 1.     1     5.0    0.0    0.0       addi	a2, a1, 1
# CHECK-NEXT:        1     3.0    0.5    0.0       <total>
