/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.fb;

import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;
import org.eclipse.fordiac.ide.model.eval.fb.BasicFBEvaluator;
import org.eclipse.fordiac.ide.model.eval.fb.FunctionFBEvaluator;
import org.eclipse.fordiac.ide.model.eval.fb.SimpleFBEvaluator;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;

public class FBEvaluatorFactory
implements EvaluatorFactory {
    private static final String DEPLOYMENT_VARIANT = "deployment";

    @Override
    public Evaluator createEvaluator(Object source, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        if (source instanceof SimpleFBType) {
            SimpleFBType simpleFBType = (SimpleFBType)source;
            return new SimpleFBEvaluator(simpleFBType, context, variables, parent);
        }
        if (source instanceof BasicFBType) {
            BasicFBType basicFBType = (BasicFBType)source;
            return new BasicFBEvaluator(basicFBType, context, variables, parent);
        }
        if (source instanceof FunctionFBType) {
            FunctionFBType functionFBType = (FunctionFBType)source;
            if (functionFBType.getBody() == null) {
                return EvaluatorFactory.createEvaluator(functionFBType, FunctionFBType.class, DEPLOYMENT_VARIANT, context, variables, parent);
            }
            return new FunctionFBEvaluator(functionFBType, context, variables, parent);
        }
        return null;
    }

    public static void register() {
        FBEvaluatorFactory factory = new FBEvaluatorFactory();
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", SimpleFBType.class, factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", BasicFBType.class, factory);
        EvaluatorFactory.Registry.INSTANCE.registerFactory("default", FunctionFBType.class, factory);
    }
}

