/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.types;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.DeviceType;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceType;
import org.eclipse.fordiac.ide.model.libraryElement.Segment;
import org.eclipse.fordiac.ide.model.libraryElement.SegmentType;
import org.eclipse.fordiac.ide.model.libraryElement.UntypedSubApp;
import org.eclipse.fordiac.ide.model.search.LiveSearchContext;
import org.eclipse.fordiac.ide.model.search.types.IEC61499ElementSearch;
import org.eclipse.fordiac.ide.model.search.types.IEC61499SearchFilter;
import org.eclipse.fordiac.ide.model.search.types.ISearchChildrenProvider;
import org.eclipse.fordiac.ide.model.search.types.LibraryElementSearchContext;
import org.eclipse.fordiac.ide.model.search.types.SearchChildrenProviderHelper;
import org.eclipse.fordiac.ide.model.typelibrary.AttributeTypeEntry;

public class AttributeTypeInstanceSearch
extends IEC61499ElementSearch {
    public AttributeTypeInstanceSearch(AttributeTypeEntry attEntry) {
        super(new LiveSearchContext(attEntry.getTypeLibrary()), AttributeTypeInstanceSearch.createSearchFilter(attEntry), new AttributeTypeInstanceSearchChildrenProvider());
    }

    public AttributeTypeInstanceSearch(LibraryElement typeEditable, AttributeTypeEntry attEntry) {
        super(new LibraryElementSearchContext(typeEditable), AttributeTypeInstanceSearch.createSearchFilter(attEntry), new AttributeTypeInstanceSearchChildrenProvider());
    }

    private static IEC61499SearchFilter createSearchFilter(AttributeTypeEntry attEntry) {
        return searchCandidate -> {
            AttributeDeclaration attributeDecl;
            ConfigurableObject confObj;
            Attribute attribute;
            if (searchCandidate instanceof ConfigurableObject && (attribute = (confObj = (ConfigurableObject)searchCandidate).getAttribute(attEntry.getTypeName())) != null && (attributeDecl = attribute.getAttributeDeclaration()) != null) {
                return attributeDecl.getTypeEntry() == attEntry;
            }
            return false;
        };
    }

    private static final class AttributeTypeInstanceSearchChildrenProvider
    implements ISearchChildrenProvider {
        private AttributeTypeInstanceSearchChildrenProvider() {
        }

        @Override
        public boolean hasChildren(EObject obj) {
            return obj instanceof AutomationSystem || obj instanceof Application || obj instanceof FBType || obj instanceof BlockFBNetworkElement || obj instanceof StructuredType || obj instanceof AttributeDeclaration || obj instanceof DeviceType || obj instanceof ResourceType || obj instanceof SegmentType || obj instanceof Device || obj instanceof Resource || obj instanceof Segment || obj instanceof GlobalConstants;
        }

        @Override
        public Stream<? extends EObject> getChildren(EObject obj) {
            EObject eObject = obj;
            Objects.requireNonNull(eObject);
            EObject eObject2 = eObject;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AutomationSystem.class, Application.class, FBType.class, UntypedSubApp.class, BlockFBNetworkElement.class, StructuredType.class, AttributeDeclaration.class, DeviceType.class, ResourceType.class, SegmentType.class, Device.class, Resource.class, Segment.class, GlobalConstants.class}, (Object)eObject2, 0)) {
                case 0 -> {
                    AutomationSystem system = (AutomationSystem)eObject2;
                    Stream stream = system.getApplication().stream();
                    stream = Stream.concat(stream, system.getSystemConfiguration().getDevices().stream());
                    stream = Stream.concat(stream, system.getSystemConfiguration().getLinks().stream());
                    stream = Stream.concat(stream, system.getSystemConfiguration().getSegments().stream());
                    yield stream;
                }
                case 1 -> {
                    Application application = (Application)eObject2;
                    yield SearchChildrenProviderHelper.getFBNetworkChildren(application.getFBNetwork());
                }
                case 2 -> {
                    FBType fbType = (FBType)eObject2;
                    yield SearchChildrenProviderHelper.getFBTypeChildren(fbType);
                }
                case 3 -> {
                    UntypedSubApp untypedSubapp = (UntypedSubApp)eObject2;
                    yield SearchChildrenProviderHelper.getUntypedSubappChildren(untypedSubapp);
                }
                case 4 -> {
                    BlockFBNetworkElement fbnElement = (BlockFBNetworkElement)eObject2;
                    yield SearchChildrenProviderHelper.getInterfaceListChildren(fbnElement.getInterface());
                }
                case 5 -> {
                    StructuredType structType = (StructuredType)eObject2;
                    yield SearchChildrenProviderHelper.getStructChildren(structType);
                }
                case 6 -> {
                    AttributeDeclaration attrdecl = (AttributeDeclaration)eObject2;
                    yield SearchChildrenProviderHelper.getAttributeDeclChildren(attrdecl);
                }
                case 7 -> {
                    DeviceType deviceType = (DeviceType)eObject2;
                    yield deviceType.getVarDeclaration().stream();
                }
                case 8 -> {
                    ResourceType resourceType = (ResourceType)eObject2;
                    yield resourceType.getVarDeclaration().stream();
                }
                case 9 -> {
                    SegmentType segmentType = (SegmentType)eObject2;
                    yield segmentType.getVarDeclaration().stream();
                }
                case 10 -> {
                    Device device = (Device)eObject2;
                    Stream stream = device.getVarDeclarations().stream();
                    stream = Stream.concat(stream, device.getResource().stream());
                    yield stream;
                }
                case 11 -> {
                    Resource resource = (Resource)eObject2;
                    yield resource.getVarDeclarations().stream();
                }
                case 12 -> {
                    Segment segment = (Segment)eObject2;
                    yield segment.getVarDeclarations().stream();
                }
                case 13 -> {
                    GlobalConstants globalConstants = (GlobalConstants)eObject2;
                    yield globalConstants.getConstants().stream();
                }
                default -> Stream.empty();
            };
        }
    }
}

