/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.rename;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.search.types.BlockTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.search.types.DataTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.ReconnectPinChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.rename.RenameElementChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class RenameElementRefactoringProcessor
extends RenameProcessor {
    private URI elementURI;
    private String newName;

    public RenameElementRefactoringProcessor(URI elementURI, String newName) {
        this.elementURI = elementURI;
        this.newName = newName;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        IdentifierVerifier.verifyIdentifier((String)this.newName).ifPresent(arg_0 -> ((RefactoringStatus)status).addFatalError(arg_0));
        return status;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(this.getProcessorName());
        change.add((Change)new RenameElementChange(MessageFormat.format(Messages.RenameElementRefactoringProcessor_RenamePinInType, this.elementURI.lastSegment()), this.elementURI, this.newName));
        this.createChildChanges(change);
        return change;
    }

    private void createChildChanges(CompositeChange change) {
        List list;
        TypeEntry typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForURI(this.elementURI);
        if (typeEntry == null) {
            return;
        }
        if (typeEntry instanceof DataTypeEntry) {
            DataTypeEntry dtEntry = (DataTypeEntry)typeEntry;
            list = new DataTypeInstanceSearch(dtEntry).performSearch();
        } else {
            list = new BlockTypeInstanceSearch(typeEntry).performSearch();
        }
        List result = list;
        EObject eChild = RenameElementRefactoringProcessor.getChildByURI((EObject)typeEntry.getType(), this.elementURI);
        if (eChild instanceof IInterfaceElement) {
            IInterfaceElement interfaceElement = (IInterfaceElement)eChild;
            result.stream().filter(BlockFBNetworkElement.class::isInstance).map(BlockFBNetworkElement.class::cast).forEach(element -> this.createRenameInterfaceChanges(change, (BlockFBNetworkElement)element, interfaceElement));
        }
    }

    private void createRenameInterfaceChanges(CompositeChange change, BlockFBNetworkElement element, IInterfaceElement interfaceElement) {
        String oldName = interfaceElement.getName();
        change.add((Change)new ReconnectPinChange(EcoreUtil.getURI((EObject)element), BlockFBNetworkElement.class, this.newName, oldName));
    }

    public static EObject getChildByURI(EObject parent, URI uri) {
        EObject[] found = new EObject[1];
        parent.eAllContents().forEachRemaining(child -> {
            String uriFragment = child.eResource().getURIFragment(child);
            if (uriFragment.equals(uri.fragment())) {
                eObjectArray[0] = child;
            }
        });
        return found[0];
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)this.elementURI, (RenameArguments)new RenameArguments(this.newName, true), (String[])new String[]{"org.eclipse.fordiac.ide.systemmanagement.FordiacNature"}, (SharableParticipants)sharedParticipants);
    }

    public Object[] getElements() {
        return new Object[]{this.elementURI};
    }

    public String getIdentifier() {
        return "org.eclipse.fordiac.ide.typemanagement.renameElement";
    }

    public String getProcessorName() {
        return MessageFormat.format(Messages.RenameElementRefactoringProcessor_Name, this.newName);
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public URI getElementURI() {
        return this.elementURI;
    }

    public void setElementURI(URI elementURI) {
        this.elementURI = elementURI;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }
}

