/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedSet;
import org.eclipse.fordiac.ide.deployment.data.ResourceDeploymentData;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;

public class DeviceDeploymentData {
    private final Device dev;
    private final List<ResourceDeploymentData> resData = new ArrayList<ResourceDeploymentData>();
    private List<VarDeclaration> selectedDevParams = Collections.emptyList();
    private final SequencedSet<FBTypeEntry> fbTypes = new LinkedHashSet<FBTypeEntry>();
    private final SequencedSet<DataTypeEntry> dataTypes = new LinkedHashSet<DataTypeEntry>();

    public DeviceDeploymentData(Device device) {
        this.dev = device;
    }

    public Device getDevice() {
        return this.dev;
    }

    public void addResourceData(ResourceDeploymentData data) {
        this.resData.add(data);
        this.fbTypes.addAll(data.getFbTypes());
        this.dataTypes.addAll(data.getDataTypes());
    }

    public List<ResourceDeploymentData> getResData() {
        return this.resData;
    }

    public void setSeltectedDevParams(List<VarDeclaration> selParams) {
        this.selectedDevParams = Collections.unmodifiableList(new ArrayList<VarDeclaration>(selParams));
    }

    public List<VarDeclaration> getSelectedDevParams() {
        return this.selectedDevParams;
    }

    public SequencedSet<FBTypeEntry> getFbTypes() {
        return this.fbTypes;
    }

    public SequencedSet<DataTypeEntry> getDataTypes() {
        return this.dataTypes;
    }
}

